import sys
import types

def get_refcounts():
    d = {}
    sys.modules
    # collect all classes
    for m in sys.modules.values():
        for sym in dir(m):
            o = getattr (m, sym)
            if type(o) is types.ClassType:
                d[o] = sys.getrefcount (o)
    # sort by refcount
    pairs = map (lambda x: (x[1],x[0]), d.items())
    pairs.sort()
    pairs.reverse()
    return pairs

def print_top_n(n):
    print "Top %i:"%n
    for n, c in get_refcounts()[:n]:
        print '%10d %s' % (n, c.__name__)

def print_top_100():
    print_top_n(100)

def print_top_10():
    print_top_n(10)
