// apt_config_widgets.cc
//
//  Copyright 2000 Daniel Burrows

#include "apt_config_widgets.h"
#include <generic/apt.h>
#include <generic/config_signal.h>

apt_bool_widget::apt_bool_widget(string _label, string _item, bool _default)
  :vs_checkbutton(_label, aptcfg->FindB(_item, _default)), item(_item)
{
}

void apt_bool_widget::commit()
{
  aptcfg->Set(item, get_checked()?"true":"false");
}

apt_string_widget::apt_string_widget(string _item, string _default)
  :vs_editline("", aptcfg->Find(_item, _default.c_str())), item(_item)
{
}

void apt_string_widget::commit()
{
  aptcfg->Set(item, get_text());
}
