// vs_frame.cc

#include "vs_frame.h"

#include "config/colors.h"

vs_frame::vs_frame(vscreen_widget *w)
  :vs_bin()
{
  set_subwidget(w);

  do_layout.connect(slot(this, &vs_frame::layout_me));
}

size vs_frame::size_request()
{
  if(get_subwidget() && get_subwidget()->get_visible())
    {
      size newsize=get_subwidget()->size_request();

      newsize.w+=2;
      newsize.h+=2;
      return newsize;
    }
  else
    return size(2,2);
}

void vs_frame::layout_me()
{
  if(get_subwidget())
    {
      if(get_subwidget()->get_visible())
	get_subwidget()->alloc_size(1, 1, getmaxx()-2, getmaxy()-2);
      else
	get_subwidget()->alloc_size(0, 0, 0, 0);
    }
}

void vs_frame::paint()
{
  border(0,0,0,0,0,0,0,0);

  if(get_subwidget() && get_subwidget()->get_visible())
    get_subwidget()->display();
}
