// vs_passthrough.cc

#include "vs_passthrough.h"

vs_passthrough::vs_passthrough()
{
  focussed.connect(slot(this, &vs_passthrough::gained_focus));
  unfocussed.connect(slot(this, &vs_passthrough::lost_focus));
}

void vs_passthrough::defocus()
{
  lost_focus();
}

void vs_passthrough::refocus()
{
  gained_focus();
}

void vs_passthrough::gained_focus()
{
  vscreen_widget *w=get_focus();

  if(w)
    w->focussed();
}

void vs_passthrough::lost_focus()
{
  vscreen_widget *w=get_focus();

  if(w)
    w->unfocussed();
}

bool vs_passthrough::focus_me()
{
  vscreen_widget *w=get_focus();

  if(w && w->focus_me())
    return true;
  else
    return vs_container::focus_me();
}

bool vs_passthrough::get_cursorvisible()
{
  vscreen_widget *w=get_focus();

  return w && w->get_cursorvisible();
}

point vs_passthrough::get_cursorloc()
{
  vscreen_widget *w=get_focus();

  if(w)
    {
      point p=w->get_cursorloc();
      p.x+=w->get_startx();
      p.y+=w->get_starty();

      return p;
    }
  else
    return point(0, 0);
}

bool vs_passthrough::handle_char(chtype ch)
{
  vscreen_widget *w=get_focus();

  if(w && w->get_visible() && w->focus_me())
    return w->dispatch_char(ch) || vs_container::handle_char(ch);
  else
    return vs_container::handle_char(ch);
}

void vs_passthrough::dispatch_mouse(short id, int x, int y, int z,
				    mmask_t bstate)
{
  vscreen_widget *w=get_focus();

  if(w && w->get_visible())
    w->dispatch_mouse(id, x-w->get_startx(), y-w->get_starty(), z, bstate);
}
