// vs_table.h   -*-c++-*-
//
//  Your usual table-layout stuff.

#ifndef VS_TABLE_H
#define VS_TABLE_H

#include "vs_passthrough.h"
#include <list>

class keybindings;

class vs_table:public vs_passthrough
{
public:
  // Options for laying out the widget..
  static const int EXPAND=1, SHRINK=2;
  static const int ALIGN_LEFT=4, ALIGN_RIGHT=8;
  static const int ALIGN_CENTER=ALIGN_LEFT|ALIGN_RIGHT;
private:
  struct child_info
  {
    // The widget itself
    vscreen_widget *w;

    // The upper-left corner of this widget
    int row_start, col_start;

    // How big is it?
    int row_span, col_span;

    // various bits of auxilliary info (should we attempt
    // to expand/shrink this widget?  -- if there is extra space, any
    // row/column containing an expandable widget will be expanded; if there
    // isn't extra, rows/columns containing ONLY shrinkable widgets will be
    // shrunk)
    int x_options, y_options;

    // Scratchpad for the algorithms; should I do this in a "nicer" way
    // or is it not worth the trouble?
    size request_size;

    SigC::Connection shown_conn, hidden_conn;

    child_info(vscreen_widget *_w, int _row_start, int _col_start,
	       int _row_span, int _col_span, int xopts, int yopts,
	       SigC::Connection &_shown_conn, SigC::Connection &_hidden_conn)
      :w(_w), row_start(_row_start), col_start(_col_start),
       row_span(_row_span), col_span(_col_span),
       x_options(xopts), y_options(yopts),
       request_size(0, 0),
       shown_conn(_shown_conn), hidden_conn(_hidden_conn)
    {
    }
  };

  bool lies_on_axis(const child_info &base,
		    bool horizontal,
		    const child_info &c);
  class better_fit;
  class nrow_lt;
  class ncol_lt;

  typedef std::list<child_info> childlist;

  // Tables have an automatic behavior similar to dialogs in other widget
  // sets -- they can give the focus to any widget that can handle it.
  //
  // Widgets are given focus in the order in which they are added to the
  // table (cyclically)
  childlist children;
  childlist::iterator focus;

  // Calculate the number of rows or columns (these values are currently
  // determined dynamically; in the future they should be cached for reasons
  // of Speed)
  int num_rows();
  int num_cols();

  void layout_me();

  // Focus-handling stuff
  vscreen_widget *get_focus();
  void hide_widget(vscreen_widget *w);
  void show_widget(vscreen_widget *w);

  // Calculates the requested size of each row, used by the layout code
  void calc_initial_sizes(int *row_sizes, int *col_sizes, int nrows, int ncols, size *final_size);

  void got_focus();
  void lost_focus();

  // Moves the focus in the given direction
  childlist::iterator find_best_focus(childlist::iterator start,
				      int dx,
				      int dy);

protected:
  bool handle_char(chtype ch);
public:
  vs_table();

  void add_widget_opts(vscreen_widget *w, int row_start, int col_start, int row_span, int col_span, int xopts, int yopts);
  // eww.  C++ overloading is annoying..
  void add_widget(vscreen_widget *w, int row_start, int col_start, int row_span=1, int col_span=1, bool expand=true, bool shrink=false);
  // This form uses the same options for X and Y

  void add_widget(vscreen_widget *w);

  void rem_widget(vscreen_widget *w);

  void focus_widget(vscreen_widget *w);

  void show_all();

  size size_request();
  void paint();
  void dispatch_mouse(short id, int x, int y, int z, mmask_t bstate);

  static keybindings *bindings;
  static void init_bindings();
};

#endif
