// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package clouddirectory

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/restjson"
)

const opAddFacetToObject = "AddFacetToObject"

// AddFacetToObjectRequest generates a "aws/request.Request" representing the
// client's request for the AddFacetToObject operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AddFacetToObject for more information on using the AddFacetToObject
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AddFacetToObjectRequest method.
//    req, resp := client.AddFacetToObjectRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2016-05-10/AddFacetToObject
func (c *CloudDirectory) AddFacetToObjectRequest(input *AddFacetToObjectInput) (req *request.Request, output *AddFacetToObjectOutput) {
	op := &request.Operation{
		Name:       opAddFacetToObject,
		HTTPMethod: "PUT",
		HTTPPath:   "/amazonclouddirectory/2017-01-11/object/facets",
	}

	if input == nil {
		input = &AddFacetToObjectInput{}
	}

	output = &AddFacetToObjectOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AddFacetToObject API operation for Amazon CloudDirectory.
//
// Adds a new Facet to an object. An object can have more than one facet applied
// on it.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudDirectory's
// API operation AddFacetToObject for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalServiceException "InternalServiceException"
//   Indicates a problem that must be resolved by Amazon Web Services. This might
//   be a transient error in which case you can retry your request until it succeeds.
//   Otherwise, go to the AWS Service Health Dashboard (http://status.aws.amazon.com/)
//   site to see if there are any operational issues with the service.
//
//   * ErrCodeInvalidArnException "InvalidArnException"
//   Indicates that the provided ARN value is not valid.
//
//   * ErrCodeRetryableConflictException "RetryableConflictException"
//   Occurs when a conflict with a previous successful write is detected. For
//   example, if a write operation occurs on an object and then an attempt is
//   made to read the object using “SERIALIZABLE” consistency, this exception
//   may result. This generally occurs when the previous write did not have time
//   to propagate to the host serving the current request. A retry (with appropriate
//   backoff logic) is the recommended response to this exception.
//
//   * ErrCodeValidationException "ValidationException"
//   Indicates that your request is malformed in some manner. See the exception
//   message.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   Indicates that limits are exceeded. See Limits (http://docs.aws.amazon.com/directoryservice/latest/admin-guide/limits.html)
//   for more information.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   Access denied. Check your permissions.
//
//   * ErrCodeDirectoryNotEnabledException "DirectoryNotEnabledException"
//   Operations are only permitted on enabled directories.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource could not be found.
//
//   * ErrCodeFacetValidationException "FacetValidationException"
//   The Facet that you provided was not well formed or could not be validated
//   with the schema.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2016-05-10/AddFacetToObject
func (c *CloudDirectory) AddFacetToObject(input *AddFacetToObjectInput) (*AddFacetToObjectOutput, error) {
	req, out := c.AddFacetToObjectRequest(input)
	return out, req.Send()
}

// AddFacetToObjectWithContext is the same as AddFacetToObject with the addition of
// the ability to pass a context and additional request options.
//
// See AddFacetToObject for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudDirectory) AddFacetToObjectWithContext(ctx aws.Context, input *AddFacetToObjectInput, opts ...request.Option) (*AddFacetToObjectOutput, error) {
	req, out := c.AddFacetToObjectRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opApplySchema = "ApplySchema"

// ApplySchemaRequest generates a "aws/request.Request" representing the
// client's request for the ApplySchema operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ApplySchema for more information on using the ApplySchema
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ApplySchemaRequest method.
//    req, resp := client.ApplySchemaRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2016-05-10/ApplySchema
func (c *CloudDirectory) ApplySchemaRequest(input *ApplySchemaInput) (req *request.Request, output *ApplySchemaOutput) {
	op := &request.Operation{
		Name:       opApplySchema,
		HTTPMethod: "PUT",
		HTTPPath:   "/amazonclouddirectory/2017-01-11/schema/apply",
	}

	if input == nil {
		input = &ApplySchemaInput{}
	}

	output = &ApplySchemaOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ApplySchema API operation for Amazon CloudDirectory.
//
// Copies the input published schema, at the specified version, into the Directory
// with the same name and version as that of the published schema.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudDirectory's
// API operation ApplySchema for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalServiceException "InternalServiceException"
//   Indicates a problem that must be resolved by Amazon Web Services. This might
//   be a transient error in which case you can retry your request until it succeeds.
//   Otherwise, go to the AWS Service Health Dashboard (http://status.aws.amazon.com/)
//   site to see if there are any operational issues with the service.
//
//   * ErrCodeInvalidArnException "InvalidArnException"
//   Indicates that the provided ARN value is not valid.
//
//   * ErrCodeRetryableConflictException "RetryableConflictException"
//   Occurs when a conflict with a previous successful write is detected. For
//   example, if a write operation occurs on an object and then an attempt is
//   made to read the object using “SERIALIZABLE” consistency, this exception
//   may result. This generally occurs when the previous write did not have time
//   to propagate to the host serving the current request. A retry (with appropriate
//   backoff logic) is the recommended response to this exception.
//
//   * ErrCodeValidationException "ValidationException"
//   Indicates that your request is malformed in some manner. See the exception
//   message.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   Indicates that limits are exceeded. See Limits (http://docs.aws.amazon.com/directoryservice/latest/admin-guide/limits.html)
//   for more information.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   Access denied. Check your permissions.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource could not be found.
//
//   * ErrCodeInvalidAttachmentException "InvalidAttachmentException"
//   Indicates that an attempt to attach an object with the same link name or
//   to apply a schema with the same name has occurred. Rename the link or the
//   schema and then try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2016-05-10/ApplySchema
func (c *CloudDirectory) ApplySchema(input *ApplySchemaInput) (*ApplySchemaOutput, error) {
	req, out := c.ApplySchemaRequest(input)
	return out, req.Send()
}

// ApplySchemaWithContext is the same as ApplySchema with the addition of
// the ability to pass a context and additional request options.
//
// See ApplySchema for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudDirectory) ApplySchemaWithContext(ctx aws.Context, input *ApplySchemaInput, opts ...request.Option) (*ApplySchemaOutput, error) {
	req, out := c.ApplySchemaRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAttachObject = "AttachObject"

// AttachObjectRequest generates a "aws/request.Request" representing the
// client's request for the AttachObject operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AttachObject for more information on using the AttachObject
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AttachObjectRequest method.
//    req, resp := client.AttachObjectRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2016-05-10/AttachObject
func (c *CloudDirectory) AttachObjectRequest(input *AttachObjectInput) (req *request.Request, output *AttachObjectOutput) {
	op := &request.Operation{
		Name:       opAttachObject,
		HTTPMethod: "PUT",
		HTTPPath:   "/amazonclouddirectory/2017-01-11/object/attach",
	}

	if input == nil {
		input = &AttachObjectInput{}
	}

	output = &AttachObjectOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AttachObject API operation for Amazon CloudDirectory.
//
// Attaches an existing object to another object. An object can be accessed
// in two ways:
//
// Using the path
//
// Using ObjectIdentifier
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudDirectory's
// API operation AttachObject for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalServiceException "InternalServiceException"
//   Indicates a problem that must be resolved by Amazon Web Services. This might
//   be a transient error in which case you can retry your request until it succeeds.
//   Otherwise, go to the AWS Service Health Dashboard (http://status.aws.amazon.com/)
//   site to see if there are any operational issues with the service.
//
//   * ErrCodeInvalidArnException "InvalidArnException"
//   Indicates that the provided ARN value is not valid.
//
//   * ErrCodeRetryableConflictException "RetryableConflictException"
//   Occurs when a conflict with a previous successful write is detected. For
//   example, if a write operation occurs on an object and then an attempt is
//   made to read the object using “SERIALIZABLE” consistency, this exception
//   may result. This generally occurs when the previous write did not have time
//   to propagate to the host serving the current request. A retry (with appropriate
//   backoff logic) is the recommended response to this exception.
//
//   * ErrCodeValidationException "ValidationException"
//   Indicates that your request is malformed in some manner. See the exception
//   message.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   Indicates that limits are exceeded. See Limits (http://docs.aws.amazon.com/directoryservice/latest/admin-guide/limits.html)
//   for more information.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   Access denied. Check your permissions.
//
//   * ErrCodeDirectoryNotEnabledException "DirectoryNotEnabledException"
//   Operations are only permitted on enabled directories.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource could not be found.
//
//   * ErrCodeLinkNameAlreadyInUseException "LinkNameAlreadyInUseException"
//   Indicates that a link could not be created due to a naming conflict. Choose
//   a different name and then try again.
//
//   * ErrCodeInvalidAttachmentException "InvalidAttachmentException"
//   Indicates that an attempt to attach an object with the same link name or
//   to apply a schema with the same name has occurred. Rename the link or the
//   schema and then try again.
//
//   * ErrCodeValidationException "ValidationException"
//   Indicates that your request is malformed in some manner. See the exception
//   message.
//
//   * ErrCodeFacetValidationException "FacetValidationException"
//   The Facet that you provided was not well formed or could not be validated
//   with the schema.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2016-05-10/AttachObject
func (c *CloudDirectory) AttachObject(input *AttachObjectInput) (*AttachObjectOutput, error) {
	req, out := c.AttachObjectRequest(input)
	return out, req.Send()
}

// AttachObjectWithContext is the same as AttachObject with the addition of
// the ability to pass a context and additional request options.
//
// See AttachObject for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudDirectory) AttachObjectWithContext(ctx aws.Context, input *AttachObjectInput, opts ...request.Option) (*AttachObjectOutput, error) {
	req, out := c.AttachObjectRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAttachPolicy = "AttachPolicy"

// AttachPolicyRequest generates a "aws/request.Request" representing the
// client's request for the AttachPolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AttachPolicy for more information on using the AttachPolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AttachPolicyRequest method.
//    req, resp := client.AttachPolicyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2016-05-10/AttachPolicy
func (c *CloudDirectory) AttachPolicyRequest(input *AttachPolicyInput) (req *request.Request, output *AttachPolicyOutput) {
	op := &request.Operation{
		Name:       opAttachPolicy,
		HTTPMethod: "PUT",
		HTTPPath:   "/amazonclouddirectory/2017-01-11/policy/attach",
	}

	if input == nil {
		input = &AttachPolicyInput{}
	}

	output = &AttachPolicyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AttachPolicy API operation for Amazon CloudDirectory.
//
// Attaches a policy object to a regular object. An object can have a limited
// number of attached policies.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudDirectory's
// API operation AttachPolicy for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalServiceException "InternalServiceException"
//   Indicates a problem that must be resolved by Amazon Web Services. This might
//   be a transient error in which case you can retry your request until it succeeds.
//   Otherwise, go to the AWS Service Health Dashboard (http://status.aws.amazon.com/)
//   site to see if there are any operational issues with the service.
//
//   * ErrCodeInvalidArnException "InvalidArnException"
//   Indicates that the provided ARN value is not valid.
//
//   * ErrCodeRetryableConflictException "RetryableConflictException"
//   Occurs when a conflict with a previous successful write is detected. For
//   example, if a write operation occurs on an object and then an attempt is
//   made to read the object using “SERIALIZABLE” consistency, this exception
//   may result. This generally occurs when the previous write did not have time
//   to propagate to the host serving the current request. A retry (with appropriate
//   backoff logic) is the recommended response to this exception.
//
//   * ErrCodeValidationException "ValidationException"
//   Indicates that your request is malformed in some manner. See the exception
//   message.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   Indicates that limits are exceeded. See Limits (http://docs.aws.amazon.com/directoryservice/latest/admin-guide/limits.html)
//   for more information.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   Access denied. Check your permissions.
//
//   * ErrCodeDirectoryNotEnabledException "DirectoryNotEnabledException"
//   Operations are only permitted on enabled directories.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource could not be found.
//
//   * ErrCodeNotPolicyException "NotPolicyException"
//   Indicates that the requested operation can only operate on policy objects.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2016-05-10/AttachPolicy
func (c *CloudDirectory) AttachPolicy(input *AttachPolicyInput) (*AttachPolicyOutput, error) {
	req, out := c.AttachPolicyRequest(input)
	return out, req.Send()
}

// AttachPolicyWithContext is the same as AttachPolicy with the addition of
// the ability to pass a context and additional request options.
//
// See AttachPolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudDirectory) AttachPolicyWithContext(ctx aws.Context, input *AttachPolicyInput, opts ...request.Option) (*AttachPolicyOutput, error) {
	req, out := c.AttachPolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAttachToIndex = "AttachToIndex"

// AttachToIndexRequest generates a "aws/request.Request" representing the
// client's request for the AttachToIndex operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AttachToIndex for more information on using the AttachToIndex
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AttachToIndexRequest method.
//    req, resp := client.AttachToIndexRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2016-05-10/AttachToIndex
func (c *CloudDirectory) AttachToIndexRequest(input *AttachToIndexInput) (req *request.Request, output *AttachToIndexOutput) {
	op := &request.Operation{
		Name:       opAttachToIndex,
		HTTPMethod: "PUT",
		HTTPPath:   "/amazonclouddirectory/2017-01-11/index/attach",
	}

	if input == nil {
		input = &AttachToIndexInput{}
	}

	output = &AttachToIndexOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AttachToIndex API operation for Amazon CloudDirectory.
//
// Attaches the specified object to the specified index.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudDirectory's
// API operation AttachToIndex for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalServiceException "InternalServiceException"
//   Indicates a problem that must be resolved by Amazon Web Services. This might
//   be a transient error in which case you can retry your request until it succeeds.
//   Otherwise, go to the AWS Service Health Dashboard (http://status.aws.amazon.com/)
//   site to see if there are any operational issues with the service.
//
//   * ErrCodeInvalidArnException "InvalidArnException"
//   Indicates that the provided ARN value is not valid.
//
//   * ErrCodeRetryableConflictException "RetryableConflictException"
//   Occurs when a conflict with a previous successful write is detected. For
//   example, if a write operation occurs on an object and then an attempt is
//   made to read the object using “SERIALIZABLE” consistency, this exception
//   may result. This generally occurs when the previous write did not have time
//   to propagate to the host serving the current request. A retry (with appropriate
//   backoff logic) is the recommended response to this exception.
//
//   * ErrCodeValidationException "ValidationException"
//   Indicates that your request is malformed in some manner. See the exception
//   message.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   Indicates that limits are exceeded. See Limits (http://docs.aws.amazon.com/directoryservice/latest/admin-guide/limits.html)
//   for more information.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   Access denied. Check your permissions.
//
//   * ErrCodeDirectoryNotEnabledException "DirectoryNotEnabledException"
//   Operations are only permitted on enabled directories.
//
//   * ErrCodeInvalidAttachmentException "InvalidAttachmentException"
//   Indicates that an attempt to attach an object with the same link name or
//   to apply a schema with the same name has occurred. Rename the link or the
//   schema and then try again.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource could not be found.
//
//   * ErrCodeLinkNameAlreadyInUseException "LinkNameAlreadyInUseException"
//   Indicates that a link could not be created due to a naming conflict. Choose
//   a different name and then try again.
//
//   * ErrCodeIndexedAttributeMissingException "IndexedAttributeMissingException"
//   An object has been attempted to be attached to an object that does not have
//   the appropriate attribute value.
//
//   * ErrCodeNotIndexException "NotIndexException"
//   Indicates that the requested operation can only operate on index objects.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2016-05-10/AttachToIndex
func (c *CloudDirectory) AttachToIndex(input *AttachToIndexInput) (*AttachToIndexOutput, error) {
	req, out := c.AttachToIndexRequest(input)
	return out, req.Send()
}

// AttachToIndexWithContext is the same as AttachToIndex with the addition of
// the ability to pass a context and additional request options.
//
// See AttachToIndex for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudDirectory) AttachToIndexWithContext(ctx aws.Context, input *AttachToIndexInput, opts ...request.Option) (*AttachToIndexOutput, error) {
	req, out := c.AttachToIndexRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAttachTypedLink = "AttachTypedLink"

// AttachTypedLinkRequest generates a "aws/request.Request" representing the
// client's request for the AttachTypedLink operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AttachTypedLink for more information on using the AttachTypedLink
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AttachTypedLinkRequest method.
//    req, resp := client.AttachTypedLinkRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2016-05-10/AttachTypedLink
func (c *CloudDirectory) AttachTypedLinkRequest(input *AttachTypedLinkInput) (req *request.Request, output *AttachTypedLinkOutput) {
	op := &request.Operation{
		Name:       opAttachTypedLink,
		HTTPMethod: "PUT",
		HTTPPath:   "/amazonclouddirectory/2017-01-11/typedlink/attach",
	}

	if input == nil {
		input = &AttachTypedLinkInput{}
	}

	output = &AttachTypedLinkOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AttachTypedLink API operation for Amazon CloudDirectory.
//
// Attaches a typed link to a specified source and target object. For more information,
// see Typed link (http://docs.aws.amazon.com/directoryservice/latest/admin-guide/objectsandlinks.html#typedlink).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudDirectory's
// API operation AttachTypedLink for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalServiceException "InternalServiceException"
//   Indicates a problem that must be resolved by Amazon Web Services. This might
//   be a transient error in which case you can retry your request until it succeeds.
//   Otherwise, go to the AWS Service Health Dashboard (http://status.aws.amazon.com/)
//   site to see if there are any operational issues with the service.
//
//   * ErrCodeInvalidArnException "InvalidArnException"
//   Indicates that the provided ARN value is not valid.
//
//   * ErrCodeRetryableConflictException "RetryableConflictException"
//   Occurs when a conflict with a previous successful write is detected. For
//   example, if a write operation occurs on an object and then an attempt is
//   made to read the object using “SERIALIZABLE” consistency, this exception
//   may result. This generally occurs when the previous write did not have time
//   to propagate to the host serving the current request. A retry (with appropriate
//   backoff logic) is the recommended response to this exception.
//
//   * ErrCodeValidationException "ValidationException"
//   Indicates that your request is malformed in some manner. See the exception
//   message.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   Indicates that limits are exceeded. See Limits (http://docs.aws.amazon.com/directoryservice/latest/admin-guide/limits.html)
//   for more information.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   Access denied. Check your permissions.
//
//   * ErrCodeDirectoryNotEnabledException "DirectoryNotEnabledException"
//   Operations are only permitted on enabled directories.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource could not be found.
//
//   * ErrCodeInvalidAttachmentException "InvalidAttachmentException"
//   Indicates that an attempt to attach an object with the same link name or
//   to apply a schema with the same name has occurred. Rename the link or the
//   schema and then try again.
//
//   * ErrCodeValidationException "ValidationException"
//   Indicates that your request is malformed in some manner. See the exception
//   message.
//
//   * ErrCodeFacetValidationException "FacetValidationException"
//   The Facet that you provided was not well formed or could not be validated
//   with the schema.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2016-05-10/AttachTypedLink
func (c *CloudDirectory) AttachTypedLink(input *AttachTypedLinkInput) (*AttachTypedLinkOutput, error) {
	req, out := c.AttachTypedLinkRequest(input)
	return out, req.Send()
}

// AttachTypedLinkWithContext is the same as AttachTypedLink with the addition of
// the ability to pass a context and additional request options.
//
// See AttachTypedLink for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudDirectory) AttachTypedLinkWithContext(ctx aws.Context, input *AttachTypedLinkInput, opts ...request.Option) (*AttachTypedLinkOutput, error) {
	req, out := c.AttachTypedLinkRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opBatchRead = "BatchRead"

// BatchReadRequest generates a "aws/request.Request" representing the
// client's request for the BatchRead operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchRead for more information on using the BatchRead
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the BatchReadRequest method.
//    req, resp := client.BatchReadRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2016-05-10/BatchRead
func (c *CloudDirectory) BatchReadRequest(input *BatchReadInput) (req *request.Request, output *BatchReadOutput) {
	op := &request.Operation{
		Name:       opBatchRead,
		HTTPMethod: "POST",
		HTTPPath:   "/amazonclouddirectory/2017-01-11/batchread",
	}

	if input == nil {
		input = &BatchReadInput{}
	}

	output = &BatchReadOutput{}
	req = c.newRequest(op, input, output)
	return
}

// BatchRead API operation for Amazon CloudDirectory.
//
// Performs all the read operations in a batch.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudDirectory's
// API operation BatchRead for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalServiceException "InternalServiceException"
//   Indicates a problem that must be resolved by Amazon Web Services. This might
//   be a transient error in which case you can retry your request until it succeeds.
//   Otherwise, go to the AWS Service Health Dashboard (http://status.aws.amazon.com/)
//   site to see if there are any operational issues with the service.
//
//   * ErrCodeInvalidArnException "InvalidArnException"
//   Indicates that the provided ARN value is not valid.
//
//   * ErrCodeRetryableConflictException "RetryableConflictException"
//   Occurs when a conflict with a previous successful write is detected. For
//   example, if a write operation occurs on an object and then an attempt is
//   made to read the object using “SERIALIZABLE” consistency, this exception
//   may result. This generally occurs when the previous write did not have time
//   to propagate to the host serving the current request. A retry (with appropriate
//   backoff logic) is the recommended response to this exception.
//
//   * ErrCodeValidationException "ValidationException"
//   Indicates that your request is malformed in some manner. See the exception
//   message.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   Indicates that limits are exceeded. See Limits (http://docs.aws.amazon.com/directoryservice/latest/admin-guide/limits.html)
//   for more information.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   Access denied. Check your permissions.
//
//   * ErrCodeDirectoryNotEnabledException "DirectoryNotEnabledException"
//   Operations are only permitted on enabled directories.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2016-05-10/BatchRead
func (c *CloudDirectory) BatchRead(input *BatchReadInput) (*BatchReadOutput, error) {
	req, out := c.BatchReadRequest(input)
	return out, req.Send()
}

// BatchReadWithContext is the same as BatchRead with the addition of
// the ability to pass a context and additional request options.
//
// See BatchRead for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudDirectory) BatchReadWithContext(ctx aws.Context, input *BatchReadInput, opts ...request.Option) (*BatchReadOutput, error) {
	req, out := c.BatchReadRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opBatchWrite = "BatchWrite"

// BatchWriteRequest generates a "aws/request.Request" representing the
// client's request for the BatchWrite operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchWrite for more information on using the BatchWrite
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the BatchWriteRequest method.
//    req, resp := client.BatchWriteRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2016-05-10/BatchWrite
func (c *CloudDirectory) BatchWriteRequest(input *BatchWriteInput) (req *request.Request, output *BatchWriteOutput) {
	op := &request.Operation{
		Name:       opBatchWrite,
		HTTPMethod: "PUT",
		HTTPPath:   "/amazonclouddirectory/2017-01-11/batchwrite",
	}

	if input == nil {
		input = &BatchWriteInput{}
	}

	output = &BatchWriteOutput{}
	req = c.newRequest(op, input, output)
	return
}

// BatchWrite API operation for Amazon CloudDirectory.
//
// Performs all the write operations in a batch. Either all the operations succeed
// or none.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudDirectory's
// API operation BatchWrite for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalServiceException "InternalServiceException"
//   Indicates a problem that must be resolved by Amazon Web Services. This might
//   be a transient error in which case you can retry your request until it succeeds.
//   Otherwise, go to the AWS Service Health Dashboard (http://status.aws.amazon.com/)
//   site to see if there are any operational issues with the service.
//
//   * ErrCodeInvalidArnException "InvalidArnException"
//   Indicates that the provided ARN value is not valid.
//
//   * ErrCodeRetryableConflictException "RetryableConflictException"
//   Occurs when a conflict with a previous successful write is detected. For
//   example, if a write operation occurs on an object and then an attempt is
//   made to read the object using “SERIALIZABLE” consistency, this exception
//   may result. This generally occurs when the previous write did not have time
//   to propagate to the host serving the current request. A retry (with appropriate
//   backoff logic) is the recommended response to this exception.
//
//   * ErrCodeValidationException "ValidationException"
//   Indicates that your request is malformed in some manner. See the exception
//   message.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   Indicates that limits are exceeded. See Limits (http://docs.aws.amazon.com/directoryservice/latest/admin-guide/limits.html)
//   for more information.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   Access denied. Check your permissions.
//
//   * ErrCodeDirectoryNotEnabledException "DirectoryNotEnabledException"
//   Operations are only permitted on enabled directories.
//
//   * ErrCodeBatchWriteException "BatchWriteException"
//   A BatchWrite exception has occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2016-05-10/BatchWrite
func (c *CloudDirectory) BatchWrite(input *BatchWriteInput) (*BatchWriteOutput, error) {
	req, out := c.BatchWriteRequest(input)
	return out, req.Send()
}

// BatchWriteWithContext is the same as BatchWrite with the addition of
// the ability to pass a context and additional request options.
//
// See BatchWrite for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudDirectory) BatchWriteWithContext(ctx aws.Context, input *BatchWriteInput, opts ...request.Option) (*BatchWriteOutput, error) {
	req, out := c.BatchWriteRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateDirectory = "CreateDirectory"

// CreateDirectoryRequest generates a "aws/request.Request" representing the
// client's request for the CreateDirectory operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateDirectory for more information on using the CreateDirectory
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateDirectoryRequest method.
//    req, resp := client.CreateDirectoryRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2016-05-10/CreateDirectory
func (c *CloudDirectory) CreateDirectoryRequest(input *CreateDirectoryInput) (req *request.Request, output *CreateDirectoryOutput) {
	op := &request.Operation{
		Name:       opCreateDirectory,
		HTTPMethod: "PUT",
		HTTPPath:   "/amazonclouddirectory/2017-01-11/directory/create",
	}

	if input == nil {
		input = &CreateDirectoryInput{}
	}

	output = &CreateDirectoryOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateDirectory API operation for Amazon CloudDirectory.
//
// Creates a Directory by copying the published schema into the directory. A
// directory cannot be created without a schema.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudDirectory's
// API operation CreateDirectory for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalServiceException "InternalServiceException"
//   Indicates a problem that must be resolved by Amazon Web Services. This might
//   be a transient error in which case you can retry your request until it succeeds.
//   Otherwise, go to the AWS Service Health Dashboard (http://status.aws.amazon.com/)
//   site to see if there are any operational issues with the service.
//
//   * ErrCodeInvalidArnException "InvalidArnException"
//   Indicates that the provided ARN value is not valid.
//
//   * ErrCodeRetryableConflictException "RetryableConflictException"
//   Occurs when a conflict with a previous successful write is detected. For
//   example, if a write operation occurs on an object and then an attempt is
//   made to read the object using “SERIALIZABLE” consistency, this exception
//   may result. This generally occurs when the previous write did not have time
//   to propagate to the host serving the current request. A retry (with appropriate
//   backoff logic) is the recommended response to this exception.
//
//   * ErrCodeValidationException "ValidationException"
//   Indicates that your request is malformed in some manner. See the exception
//   message.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   Indicates that limits are exceeded. See Limits (http://docs.aws.amazon.com/directoryservice/latest/admin-guide/limits.html)
//   for more information.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   Access denied. Check your permissions.
//
//   * ErrCodeDirectoryAlreadyExistsException "DirectoryAlreadyExistsException"
//   Indicates that a Directory could not be created due to a naming conflict.
//   Choose a different name and try again.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource could not be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2016-05-10/CreateDirectory
func (c *CloudDirectory) CreateDirectory(input *CreateDirectoryInput) (*CreateDirectoryOutput, error) {
	req, out := c.CreateDirectoryRequest(input)
	return out, req.Send()
}

// CreateDirectoryWithContext is the same as CreateDirectory with the addition of
// the ability to pass a context and additional request options.
//
// See CreateDirectory for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudDirectory) CreateDirectoryWithContext(ctx aws.Context, input *CreateDirectoryInput, opts ...request.Option) (*CreateDirectoryOutput, error) {
	req, out := c.CreateDirectoryRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateFacet = "CreateFacet"

// CreateFacetRequest generates a "aws/request.Request" representing the
// client's request for the CreateFacet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateFacet for more information on using the CreateFacet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateFacetRequest method.
//    req, resp := client.CreateFacetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2016-05-10/CreateFacet
func (c *CloudDirectory) CreateFacetRequest(input *CreateFacetInput) (req *request.Request, output *CreateFacetOutput) {
	op := &request.Operation{
		Name:       opCreateFacet,
		HTTPMethod: "PUT",
		HTTPPath:   "/amazonclouddirectory/2017-01-11/facet/create",
	}

	if input == nil {
		input = &CreateFacetInput{}
	}

	output = &CreateFacetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateFacet API operation for Amazon CloudDirectory.
//
// Creates a new Facet in a schema. Facet creation is allowed only in development
// or applied schemas.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudDirectory's
// API operation CreateFacet for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalServiceException "InternalServiceException"
//   Indicates a problem that must be resolved by Amazon Web Services. This might
//   be a transient error in which case you can retry your request until it succeeds.
//   Otherwise, go to the AWS Service Health Dashboard (http://status.aws.amazon.com/)
//   site to see if there are any operational issues with the service.
//
//   * ErrCodeInvalidArnException "InvalidArnException"
//   Indicates that the provided ARN value is not valid.
//
//   * ErrCodeRetryableConflictException "RetryableConflictException"
//   Occurs when a conflict with a previous successful write is detected. For
//   example, if a write operation occurs on an object and then an attempt is
//   made to read the object using “SERIALIZABLE” consistency, this exception
//   may result. This generally occurs when the previous write did not have time
//   to propagate to the host serving the current request. A retry (with appropriate
//   backoff logic) is the recommended response to this exception.
//
//   * ErrCodeValidationException "ValidationException"
//   Indicates that your request is malformed in some manner. See the exception
//   message.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   Indicates that limits are exceeded. See Limits (http://docs.aws.amazon.com/directoryservice/latest/admin-guide/limits.html)
//   for more information.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   Access denied. Check your permissions.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource could not be found.
//
//   * ErrCodeFacetAlreadyExistsException "FacetAlreadyExistsException"
//   A facet with the same name already exists.
//
//   * ErrCodeInvalidRuleException "InvalidRuleException"
//   Occurs when any of the rule parameter keys or values are invalid.
//
//   * ErrCodeFacetValidationException "FacetValidationException"
//   The Facet that you provided was not well formed or could not be validated
//   with the schema.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2016-05-10/CreateFacet
func (c *CloudDirectory) CreateFacet(input *CreateFacetInput) (*CreateFacetOutput, error) {
	req, out := c.CreateFacetRequest(input)
	return out, req.Send()
}

// CreateFacetWithContext is the same as CreateFacet with the addition of
// the ability to pass a context and additional request options.
//
// See CreateFacet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudDirectory) CreateFacetWithContext(ctx aws.Context, input *CreateFacetInput, opts ...request.Option) (*CreateFacetOutput, error) {
	req, out := c.CreateFacetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateIndex = "CreateIndex"

// CreateIndexRequest generates a "aws/request.Request" representing the
// client's request for the CreateIndex operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateIndex for more information on using the CreateIndex
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateIndexRequest method.
//    req, resp := client.CreateIndexRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2016-05-10/CreateIndex
func (c *CloudDirectory) CreateIndexRequest(input *CreateIndexInput) (req *request.Request, output *CreateIndexOutput) {
	op := &request.Operation{
		Name:       opCreateIndex,
		HTTPMethod: "PUT",
		HTTPPath:   "/amazonclouddirectory/2017-01-11/index",
	}

	if input == nil {
		input = &CreateIndexInput{}
	}

	output = &CreateIndexOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateIndex API operation for Amazon CloudDirectory.
//
// Creates an index object. See Indexing (http://docs.aws.amazon.com/directoryservice/latest/admin-guide/cd_indexing.html)
// for more information.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudDirectory's
// API operation CreateIndex for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalServiceException "InternalServiceException"
//   Indicates a problem that must be resolved by Amazon Web Services. This might
//   be a transient error in which case you can retry your request until it succeeds.
//   Otherwise, go to the AWS Service Health Dashboard (http://status.aws.amazon.com/)
//   site to see if there are any operational issues with the service.
//
//   * ErrCodeInvalidArnException "InvalidArnException"
//   Indicates that the provided ARN value is not valid.
//
//   * ErrCodeRetryableConflictException "RetryableConflictException"
//   Occurs when a conflict with a previous successful write is detected. For
//   example, if a write operation occurs on an object and then an attempt is
//   made to read the object using “SERIALIZABLE” consistency, this exception
//   may result. This generally occurs when the previous write did not have time
//   to propagate to the host serving the current request. A retry (with appropriate
//   backoff logic) is the recommended response to this exception.
//
//   * ErrCodeValidationException "ValidationException"
//   Indicates that your request is malformed in some manner. See the exception
//   message.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   Indicates that limits are exceeded. See Limits (http://docs.aws.amazon.com/directoryservice/latest/admin-guide/limits.html)
//   for more information.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   Access denied. Check your permissions.
//
//   * ErrCodeDirectoryNotEnabledException "DirectoryNotEnabledException"
//   Operations are only permitted on enabled directories.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource could not be found.
//
//   * ErrCodeFacetValidationException "FacetValidationException"
//   The Facet that you provided was not well formed or could not be validated
//   with the schema.
//
//   * ErrCodeLinkNameAlreadyInUseException "LinkNameAlreadyInUseException"
//   Indicates that a link could not be created due to a naming conflict. Choose
//   a different name and then try again.
//
//   * ErrCodeUnsupportedIndexTypeException "UnsupportedIndexTypeException"
//   Indicates that the requested index type is not supported.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2016-05-10/CreateIndex
func (c *CloudDirectory) CreateIndex(input *CreateIndexInput) (*CreateIndexOutput, error) {
	req, out := c.CreateIndexRequest(input)
	return out, req.Send()
}

// CreateIndexWithContext is the same as CreateIndex with the addition of
// the ability to pass a context and additional request options.
//
// See CreateIndex for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudDirectory) CreateIndexWithContext(ctx aws.Context, input *CreateIndexInput, opts ...request.Option) (*CreateIndexOutput, error) {
	req, out := c.CreateIndexRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateObject = "CreateObject"

// CreateObjectRequest generates a "aws/request.Request" representing the
// client's request for the CreateObject operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateObject for more information on using the CreateObject
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateObjectRequest method.
//    req, resp := client.CreateObjectRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2016-05-10/CreateObject
func (c *CloudDirectory) CreateObjectRequest(input *CreateObjectInput) (req *request.Request, output *CreateObjectOutput) {
	op := &request.Operation{
		Name:       opCreateObject,
		HTTPMethod: "PUT",
		HTTPPath:   "/amazonclouddirectory/2017-01-11/object",
	}

	if input == nil {
		input = &CreateObjectInput{}
	}

	output = &CreateObjectOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateObject API operation for Amazon CloudDirectory.
//
// Creates an object in a Directory. Additionally attaches the object to a parent,
// if a parent reference and LinkName is specified. An object is simply a collection
// of Facet attributes. You can also use this API call to create a policy object,
// if the facet from which you create the object is a policy facet.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudDirectory's
// API operation CreateObject for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalServiceException "InternalServiceException"
//   Indicates a problem that must be resolved by Amazon Web Services. This might
//   be a transient error in which case you can retry your request until it succeeds.
//   Otherwise, go to the AWS Service Health Dashboard (http://status.aws.amazon.com/)
//   site to see if there are any operational issues with the service.
//
//   * ErrCodeInvalidArnException "InvalidArnException"
//   Indicates that the provided ARN value is not valid.
//
//   * ErrCodeRetryableConflictException "RetryableConflictException"
//   Occurs when a conflict with a previous successful write is detected. For
//   example, if a write operation occurs on an object and then an attempt is
//   made to read the object using “SERIALIZABLE” consistency, this exception
//   may result. This generally occurs when the previous write did not have time
//   to propagate to the host serving the current request. A retry (with appropriate
//   backoff logic) is the recommended response to this exception.
//
//   * ErrCodeValidationException "ValidationException"
//   Indicates that your request is malformed in some manner. See the exception
//   message.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   Indicates that limits are exceeded. See Limits (http://docs.aws.amazon.com/directoryservice/latest/admin-guide/limits.html)
//   for more information.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   Access denied. Check your permissions.
//
//   * ErrCodeDirectoryNotEnabledException "DirectoryNotEnabledException"
//   Operations are only permitted on enabled directories.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource could not be found.
//
//   * ErrCodeFacetValidationException "FacetValidationException"
//   The Facet that you provided was not well formed or could not be validated
//   with the schema.
//
//   * ErrCodeLinkNameAlreadyInUseException "LinkNameAlreadyInUseException"
//   Indicates that a link could not be created due to a naming conflict. Choose
//   a different name and then try again.
//
//   * ErrCodeUnsupportedIndexTypeException "UnsupportedIndexTypeException"
//   Indicates that the requested index type is not supported.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2016-05-10/CreateObject
func (c *CloudDirectory) CreateObject(input *CreateObjectInput) (*CreateObjectOutput, error) {
	req, out := c.CreateObjectRequest(input)
	return out, req.Send()
}

// CreateObjectWithContext is the same as CreateObject with the addition of
// the ability to pass a context and additional request options.
//
// See CreateObject for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudDirectory) CreateObjectWithContext(ctx aws.Context, input *CreateObjectInput, opts ...request.Option) (*CreateObjectOutput, error) {
	req, out := c.CreateObjectRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateSchema = "CreateSchema"

// CreateSchemaRequest generates a "aws/request.Request" representing the
// client's request for the CreateSchema operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateSchema for more information on using the CreateSchema
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateSchemaRequest method.
//    req, resp := client.CreateSchemaRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2016-05-10/CreateSchema
func (c *CloudDirectory) CreateSchemaRequest(input *CreateSchemaInput) (req *request.Request, output *CreateSchemaOutput) {
	op := &request.Operation{
		Name:       opCreateSchema,
		HTTPMethod: "PUT",
		HTTPPath:   "/amazonclouddirectory/2017-01-11/schema/create",
	}

	if input == nil {
		input = &CreateSchemaInput{}
	}

	output = &CreateSchemaOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateSchema API operation for Amazon CloudDirectory.
//
// Creates a new schema in a development state. A schema can exist in three
// phases:
//
//    * Development: This is a mutable phase of the schema. All new schemas
//    are in the development phase. Once the schema is finalized, it can be
//    published.
//
//    * Published: Published schemas are immutable and have a version associated
//    with them.
//
//    * Applied: Applied schemas are mutable in a way that allows you to add
//    new schema facets. You can also add new, nonrequired attributes to existing
//    schema facets. You can apply only published schemas to directories.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudDirectory's
// API operation CreateSchema for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalServiceException "InternalServiceException"
//   Indicates a problem that must be resolved by Amazon Web Services. This might
//   be a transient error in which case you can retry your request until it succeeds.
//   Otherwise, go to the AWS Service Health Dashboard (http://status.aws.amazon.com/)
//   site to see if there are any operational issues with the service.
//
//   * ErrCodeInvalidArnException "InvalidArnException"
//   Indicates that the provided ARN value is not valid.
//
//   * ErrCodeRetryableConflictException "RetryableConflictException"
//   Occurs when a conflict with a previous successful write is detected. For
//   example, if a write operation occurs on an object and then an attempt is
//   made to read the object using “SERIALIZABLE” consistency, this exception
//   may result. This generally occurs when the previous write did not have time
//   to propagate to the host serving the current request. A retry (with appropriate
//   backoff logic) is the recommended response to this exception.
//
//   * ErrCodeValidationException "ValidationException"
//   Indicates that your request is malformed in some manner. See the exception
//   message.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   Indicates that limits are exceeded. See Limits (http://docs.aws.amazon.com/directoryservice/latest/admin-guide/limits.html)
//   for more information.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   Access denied. Check your permissions.
//
//   * ErrCodeSchemaAlreadyExistsException "SchemaAlreadyExistsException"
//   Indicates that a schema could not be created due to a naming conflict. Please
//   select a different name and then try again.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   Access denied. Check your permissions.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2016-05-10/CreateSchema
func (c *CloudDirectory) CreateSchema(input *CreateSchemaInput) (*CreateSchemaOutput, error) {
	req, out := c.CreateSchemaRequest(input)
	return out, req.Send()
}

// CreateSchemaWithContext is the same as CreateSchema with the addition of
// the ability to pass a context and additional request options.
//
// See CreateSchema for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudDirectory) CreateSchemaWithContext(ctx aws.Context, input *CreateSchemaInput, opts ...request.Option) (*CreateSchemaOutput, error) {
	req, out := c.CreateSchemaRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateTypedLinkFacet = "CreateTypedLinkFacet"

// CreateTypedLinkFacetRequest generates a "aws/request.Request" representing the
// client's request for the CreateTypedLinkFacet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateTypedLinkFacet for more information on using the CreateTypedLinkFacet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateTypedLinkFacetRequest method.
//    req, resp := client.CreateTypedLinkFacetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2016-05-10/CreateTypedLinkFacet
func (c *CloudDirectory) CreateTypedLinkFacetRequest(input *CreateTypedLinkFacetInput) (req *request.Request, output *CreateTypedLinkFacetOutput) {
	op := &request.Operation{
		Name:       opCreateTypedLinkFacet,
		HTTPMethod: "PUT",
		HTTPPath:   "/amazonclouddirectory/2017-01-11/typedlink/facet/create",
	}

	if input == nil {
		input = &CreateTypedLinkFacetInput{}
	}

	output = &CreateTypedLinkFacetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateTypedLinkFacet API operation for Amazon CloudDirectory.
//
// Creates a TypedLinkFacet. For more information, see Typed link (http://docs.aws.amazon.com/directoryservice/latest/admin-guide/objectsandlinks.html#typedlink).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudDirectory's
// API operation CreateTypedLinkFacet for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalServiceException "InternalServiceException"
//   Indicates a problem that must be resolved by Amazon Web Services. This might
//   be a transient error in which case you can retry your request until it succeeds.
//   Otherwise, go to the AWS Service Health Dashboard (http://status.aws.amazon.com/)
//   site to see if there are any operational issues with the service.
//
//   * ErrCodeInvalidArnException "InvalidArnException"
//   Indicates that the provided ARN value is not valid.
//
//   * ErrCodeRetryableConflictException "RetryableConflictException"
//   Occurs when a conflict with a previous successful write is detected. For
//   example, if a write operation occurs on an object and then an attempt is
//   made to read the object using “SERIALIZABLE” consistency, this exception
//   may result. This generally occurs when the previous write did not have time
//   to propagate to the host serving the current request. A retry (with appropriate
//   backoff logic) is the recommended response to this exception.
//
//   * ErrCodeValidationException "ValidationException"
//   Indicates that your request is malformed in some manner. See the exception
//   message.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   Indicates that limits are exceeded. See Limits (http://docs.aws.amazon.com/directoryservice/latest/admin-guide/limits.html)
//   for more information.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   Access denied. Check your permissions.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource could not be found.
//
//   * ErrCodeFacetAlreadyExistsException "FacetAlreadyExistsException"
//   A facet with the same name already exists.
//
//   * ErrCodeInvalidRuleException "InvalidRuleException"
//   Occurs when any of the rule parameter keys or values are invalid.
//
//   * ErrCodeFacetValidationException "FacetValidationException"
//   The Facet that you provided was not well formed or could not be validated
//   with the schema.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2016-05-10/CreateTypedLinkFacet
func (c *CloudDirectory) CreateTypedLinkFacet(input *CreateTypedLinkFacetInput) (*CreateTypedLinkFacetOutput, error) {
	req, out := c.CreateTypedLinkFacetRequest(input)
	return out, req.Send()
}

// CreateTypedLinkFacetWithContext is the same as CreateTypedLinkFacet with the addition of
// the ability to pass a context and additional request options.
//
// See CreateTypedLinkFacet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudDirectory) CreateTypedLinkFacetWithContext(ctx aws.Context, input *CreateTypedLinkFacetInput, opts ...request.Option) (*CreateTypedLinkFacetOutput, error) {
	req, out := c.CreateTypedLinkFacetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteDirectory = "DeleteDirectory"

// DeleteDirectoryRequest generates a "aws/request.Request" representing the
// client's request for the DeleteDirectory operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteDirectory for more information on using the DeleteDirectory
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteDirectoryRequest method.
//    req, resp := client.DeleteDirectoryRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2016-05-10/DeleteDirectory
func (c *CloudDirectory) DeleteDirectoryRequest(input *DeleteDirectoryInput) (req *request.Request, output *DeleteDirectoryOutput) {
	op := &request.Operation{
		Name:       opDeleteDirectory,
		HTTPMethod: "PUT",
		HTTPPath:   "/amazonclouddirectory/2017-01-11/directory",
	}

	if input == nil {
		input = &DeleteDirectoryInput{}
	}

	output = &DeleteDirectoryOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteDirectory API operation for Amazon CloudDirectory.
//
// Deletes a directory. Only disabled directories can be deleted. A deleted
// directory cannot be undone. Exercise extreme caution when deleting directories.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudDirectory's
// API operation DeleteDirectory for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource could not be found.
//
//   * ErrCodeDirectoryNotDisabledException "DirectoryNotDisabledException"
//   An operation can only operate on a disabled directory.
//
//   * ErrCodeInternalServiceException "InternalServiceException"
//   Indicates a problem that must be resolved by Amazon Web Services. This might
//   be a transient error in which case you can retry your request until it succeeds.
//   Otherwise, go to the AWS Service Health Dashboard (http://status.aws.amazon.com/)
//   site to see if there are any operational issues with the service.
//
//   * ErrCodeValidationException "ValidationException"
//   Indicates that your request is malformed in some manner. See the exception
//   message.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   Indicates that limits are exceeded. See Limits (http://docs.aws.amazon.com/directoryservice/latest/admin-guide/limits.html)
//   for more information.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   Access denied. Check your permissions.
//
//   * ErrCodeDirectoryDeletedException "DirectoryDeletedException"
//   A directory that has been deleted and to which access has been attempted.
//   Note: The requested resource will eventually cease to exist.
//
//   * ErrCodeRetryableConflictException "RetryableConflictException"
//   Occurs when a conflict with a previous successful write is detected. For
//   example, if a write operation occurs on an object and then an attempt is
//   made to read the object using “SERIALIZABLE” consistency, this exception
//   may result. This generally occurs when the previous write did not have time
//   to propagate to the host serving the current request. A retry (with appropriate
//   backoff logic) is the recommended response to this exception.
//
//   * ErrCodeInvalidArnException "InvalidArnException"
//   Indicates that the provided ARN value is not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2016-05-10/DeleteDirectory
func (c *CloudDirectory) DeleteDirectory(input *DeleteDirectoryInput) (*DeleteDirectoryOutput, error) {
	req, out := c.DeleteDirectoryRequest(input)
	return out, req.Send()
}

// DeleteDirectoryWithContext is the same as DeleteDirectory with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteDirectory for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudDirectory) DeleteDirectoryWithContext(ctx aws.Context, input *DeleteDirectoryInput, opts ...request.Option) (*DeleteDirectoryOutput, error) {
	req, out := c.DeleteDirectoryRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteFacet = "DeleteFacet"

// DeleteFacetRequest generates a "aws/request.Request" representing the
// client's request for the DeleteFacet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteFacet for more information on using the DeleteFacet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteFacetRequest method.
//    req, resp := client.DeleteFacetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2016-05-10/DeleteFacet
func (c *CloudDirectory) DeleteFacetRequest(input *DeleteFacetInput) (req *request.Request, output *DeleteFacetOutput) {
	op := &request.Operation{
		Name:       opDeleteFacet,
		HTTPMethod: "PUT",
		HTTPPath:   "/amazonclouddirectory/2017-01-11/facet/delete",
	}

	if input == nil {
		input = &DeleteFacetInput{}
	}

	output = &DeleteFacetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteFacet API operation for Amazon CloudDirectory.
//
// Deletes a given Facet. All attributes and Rules that are associated with
// the facet will be deleted. Only development schema facets are allowed deletion.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudDirectory's
// API operation DeleteFacet for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalServiceException "InternalServiceException"
//   Indicates a problem that must be resolved by Amazon Web Services. This might
//   be a transient error in which case you can retry your request until it succeeds.
//   Otherwise, go to the AWS Service Health Dashboard (http://status.aws.amazon.com/)
//   site to see if there are any operational issues with the service.
//
//   * ErrCodeInvalidArnException "InvalidArnException"
//   Indicates that the provided ARN value is not valid.
//
//   * ErrCodeRetryableConflictException "RetryableConflictException"
//   Occurs when a conflict with a previous successful write is detected. For
//   example, if a write operation occurs on an object and then an attempt is
//   made to read the object using “SERIALIZABLE” consistency, this exception
//   may result. This generally occurs when the previous write did not have time
//   to propagate to the host serving the current request. A retry (with appropriate
//   backoff logic) is the recommended response to this exception.
//
//   * ErrCodeValidationException "ValidationException"
//   Indicates that your request is malformed in some manner. See the exception
//   message.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   Indicates that limits are exceeded. See Limits (http://docs.aws.amazon.com/directoryservice/latest/admin-guide/limits.html)
//   for more information.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   Access denied. Check your permissions.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource could not be found.
//
//   * ErrCodeFacetNotFoundException "FacetNotFoundException"
//   The specified Facet could not be found.
//
//   * ErrCodeFacetInUseException "FacetInUseException"
//   Occurs when deleting a facet that contains an attribute that is a target
//   to an attribute reference in a different facet.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2016-05-10/DeleteFacet
func (c *CloudDirectory) DeleteFacet(input *DeleteFacetInput) (*DeleteFacetOutput, error) {
	req, out := c.DeleteFacetRequest(input)
	return out, req.Send()
}

// DeleteFacetWithContext is the same as DeleteFacet with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteFacet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudDirectory) DeleteFacetWithContext(ctx aws.Context, input *DeleteFacetInput, opts ...request.Option) (*DeleteFacetOutput, error) {
	req, out := c.DeleteFacetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteObject = "DeleteObject"

// DeleteObjectRequest generates a "aws/request.Request" representing the
// client's request for the DeleteObject operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteObject for more information on using the DeleteObject
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteObjectRequest method.
//    req, resp := client.DeleteObjectRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2016-05-10/DeleteObject
func (c *CloudDirectory) DeleteObjectRequest(input *DeleteObjectInput) (req *request.Request, output *DeleteObjectOutput) {
	op := &request.Operation{
		Name:       opDeleteObject,
		HTTPMethod: "PUT",
		HTTPPath:   "/amazonclouddirectory/2017-01-11/object/delete",
	}

	if input == nil {
		input = &DeleteObjectInput{}
	}

	output = &DeleteObjectOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteObject API operation for Amazon CloudDirectory.
//
// Deletes an object and its associated attributes. Only objects with no children
// and no parents can be deleted.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudDirectory's
// API operation DeleteObject for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalServiceException "InternalServiceException"
//   Indicates a problem that must be resolved by Amazon Web Services. This might
//   be a transient error in which case you can retry your request until it succeeds.
//   Otherwise, go to the AWS Service Health Dashboard (http://status.aws.amazon.com/)
//   site to see if there are any operational issues with the service.
//
//   * ErrCodeInvalidArnException "InvalidArnException"
//   Indicates that the provided ARN value is not valid.
//
//   * ErrCodeRetryableConflictException "RetryableConflictException"
//   Occurs when a conflict with a previous successful write is detected. For
//   example, if a write operation occurs on an object and then an attempt is
//   made to read the object using “SERIALIZABLE” consistency, this exception
//   may result. This generally occurs when the previous write did not have time
//   to propagate to the host serving the current request. A retry (with appropriate
//   backoff logic) is the recommended response to this exception.
//
//   * ErrCodeValidationException "ValidationException"
//   Indicates that your request is malformed in some manner. See the exception
//   message.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   Indicates that limits are exceeded. See Limits (http://docs.aws.amazon.com/directoryservice/latest/admin-guide/limits.html)
//   for more information.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   Access denied. Check your permissions.
//
//   * ErrCodeDirectoryNotEnabledException "DirectoryNotEnabledException"
//   Operations are only permitted on enabled directories.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource could not be found.
//
//   * ErrCodeObjectNotDetachedException "ObjectNotDetachedException"
//   Indicates that the requested operation cannot be completed because the object
//   has not been detached from the tree.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2016-05-10/DeleteObject
func (c *CloudDirectory) DeleteObject(input *DeleteObjectInput) (*DeleteObjectOutput, error) {
	req, out := c.DeleteObjectRequest(input)
	return out, req.Send()
}

// DeleteObjectWithContext is the same as DeleteObject with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteObject for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudDirectory) DeleteObjectWithContext(ctx aws.Context, input *DeleteObjectInput, opts ...request.Option) (*DeleteObjectOutput, error) {
	req, out := c.DeleteObjectRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteSchema = "DeleteSchema"

// DeleteSchemaRequest generates a "aws/request.Request" representing the
// client's request for the DeleteSchema operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteSchema for more information on using the DeleteSchema
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteSchemaRequest method.
//    req, resp := client.DeleteSchemaRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2016-05-10/DeleteSchema
func (c *CloudDirectory) DeleteSchemaRequest(input *DeleteSchemaInput) (req *request.Request, output *DeleteSchemaOutput) {
	op := &request.Operation{
		Name:       opDeleteSchema,
		HTTPMethod: "PUT",
		HTTPPath:   "/amazonclouddirectory/2017-01-11/schema",
	}

	if input == nil {
		input = &DeleteSchemaInput{}
	}

	output = &DeleteSchemaOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteSchema API operation for Amazon CloudDirectory.
//
// Deletes a given schema. Schemas in a development and published state can
// only be deleted.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudDirectory's
// API operation DeleteSchema for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalServiceException "InternalServiceException"
//   Indicates a problem that must be resolved by Amazon Web Services. This might
//   be a transient error in which case you can retry your request until it succeeds.
//   Otherwise, go to the AWS Service Health Dashboard (http://status.aws.amazon.com/)
//   site to see if there are any operational issues with the service.
//
//   * ErrCodeInvalidArnException "InvalidArnException"
//   Indicates that the provided ARN value is not valid.
//
//   * ErrCodeRetryableConflictException "RetryableConflictException"
//   Occurs when a conflict with a previous successful write is detected. For
//   example, if a write operation occurs on an object and then an attempt is
//   made to read the object using “SERIALIZABLE” consistency, this exception
//   may result. This generally occurs when the previous write did not have time
//   to propagate to the host serving the current request. A retry (with appropriate
//   backoff logic) is the recommended response to this exception.
//
//   * ErrCodeValidationException "ValidationException"
//   Indicates that your request is malformed in some manner. See the exception
//   message.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   Indicates that limits are exceeded. See Limits (http://docs.aws.amazon.com/directoryservice/latest/admin-guide/limits.html)
//   for more information.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   Access denied. Check your permissions.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource could not be found.
//
//   * ErrCodeStillContainsLinksException "StillContainsLinksException"
//   The object could not be deleted because links still exist. Remove the links
//   and then try the operation again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2016-05-10/DeleteSchema
func (c *CloudDirectory) DeleteSchema(input *DeleteSchemaInput) (*DeleteSchemaOutput, error) {
	req, out := c.DeleteSchemaRequest(input)
	return out, req.Send()
}

// DeleteSchemaWithContext is the same as DeleteSchema with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteSchema for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudDirectory) DeleteSchemaWithContext(ctx aws.Context, input *DeleteSchemaInput, opts ...request.Option) (*DeleteSchemaOutput, error) {
	req, out := c.DeleteSchemaRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteTypedLinkFacet = "DeleteTypedLinkFacet"

// DeleteTypedLinkFacetRequest generates a "aws/request.Request" representing the
// client's request for the DeleteTypedLinkFacet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteTypedLinkFacet for more information on using the DeleteTypedLinkFacet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteTypedLinkFacetRequest method.
//    req, resp := client.DeleteTypedLinkFacetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2016-05-10/DeleteTypedLinkFacet
func (c *CloudDirectory) DeleteTypedLinkFacetRequest(input *DeleteTypedLinkFacetInput) (req *request.Request, output *DeleteTypedLinkFacetOutput) {
	op := &request.Operation{
		Name:       opDeleteTypedLinkFacet,
		HTTPMethod: "PUT",
		HTTPPath:   "/amazonclouddirectory/2017-01-11/typedlink/facet/delete",
	}

	if input == nil {
		input = &DeleteTypedLinkFacetInput{}
	}

	output = &DeleteTypedLinkFacetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteTypedLinkFacet API operation for Amazon CloudDirectory.
//
// Deletes a TypedLinkFacet. For more information, see Typed link (http://docs.aws.amazon.com/directoryservice/latest/admin-guide/objectsandlinks.html#typedlink).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudDirectory's
// API operation DeleteTypedLinkFacet for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalServiceException "InternalServiceException"
//   Indicates a problem that must be resolved by Amazon Web Services. This might
//   be a transient error in which case you can retry your request until it succeeds.
//   Otherwise, go to the AWS Service Health Dashboard (http://status.aws.amazon.com/)
//   site to see if there are any operational issues with the service.
//
//   * ErrCodeInvalidArnException "InvalidArnException"
//   Indicates that the provided ARN value is not valid.
//
//   * ErrCodeRetryableConflictException "RetryableConflictException"
//   Occurs when a conflict with a previous successful write is detected. For
//   example, if a write operation occurs on an object and then an attempt is
//   made to read the object using “SERIALIZABLE” consistency, this exception
//   may result. This generally occurs when the previous write did not have time
//   to propagate to the host serving the current request. A retry (with appropriate
//   backoff logic) is the recommended response to this exception.
//
//   * ErrCodeValidationException "ValidationException"
//   Indicates that your request is malformed in some manner. See the exception
//   message.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   Indicates that limits are exceeded. See Limits (http://docs.aws.amazon.com/directoryservice/latest/admin-guide/limits.html)
//   for more information.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   Access denied. Check your permissions.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource could not be found.
//
//   * ErrCodeFacetNotFoundException "FacetNotFoundException"
//   The specified Facet could not be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2016-05-10/DeleteTypedLinkFacet
func (c *CloudDirectory) DeleteTypedLinkFacet(input *DeleteTypedLinkFacetInput) (*DeleteTypedLinkFacetOutput, error) {
	req, out := c.DeleteTypedLinkFacetRequest(input)
	return out, req.Send()
}

// DeleteTypedLinkFacetWithContext is the same as DeleteTypedLinkFacet with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteTypedLinkFacet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudDirectory) DeleteTypedLinkFacetWithContext(ctx aws.Context, input *DeleteTypedLinkFacetInput, opts ...request.Option) (*DeleteTypedLinkFacetOutput, error) {
	req, out := c.DeleteTypedLinkFacetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDetachFromIndex = "DetachFromIndex"

// DetachFromIndexRequest generates a "aws/request.Request" representing the
// client's request for the DetachFromIndex operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DetachFromIndex for more information on using the DetachFromIndex
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DetachFromIndexRequest method.
//    req, resp := client.DetachFromIndexRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2016-05-10/DetachFromIndex
func (c *CloudDirectory) DetachFromIndexRequest(input *DetachFromIndexInput) (req *request.Request, output *DetachFromIndexOutput) {
	op := &request.Operation{
		Name:       opDetachFromIndex,
		HTTPMethod: "PUT",
		HTTPPath:   "/amazonclouddirectory/2017-01-11/index/detach",
	}

	if input == nil {
		input = &DetachFromIndexInput{}
	}

	output = &DetachFromIndexOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DetachFromIndex API operation for Amazon CloudDirectory.
//
// Detaches the specified object from the specified index.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudDirectory's
// API operation DetachFromIndex for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalServiceException "InternalServiceException"
//   Indicates a problem that must be resolved by Amazon Web Services. This might
//   be a transient error in which case you can retry your request until it succeeds.
//   Otherwise, go to the AWS Service Health Dashboard (http://status.aws.amazon.com/)
//   site to see if there are any operational issues with the service.
//
//   * ErrCodeInvalidArnException "InvalidArnException"
//   Indicates that the provided ARN value is not valid.
//
//   * ErrCodeRetryableConflictException "RetryableConflictException"
//   Occurs when a conflict with a previous successful write is detected. For
//   example, if a write operation occurs on an object and then an attempt is
//   made to read the object using “SERIALIZABLE” consistency, this exception
//   may result. This generally occurs when the previous write did not have time
//   to propagate to the host serving the current request. A retry (with appropriate
//   backoff logic) is the recommended response to this exception.
//
//   * ErrCodeValidationException "ValidationException"
//   Indicates that your request is malformed in some manner. See the exception
//   message.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   Indicates that limits are exceeded. See Limits (http://docs.aws.amazon.com/directoryservice/latest/admin-guide/limits.html)
//   for more information.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   Access denied. Check your permissions.
//
//   * ErrCodeDirectoryNotEnabledException "DirectoryNotEnabledException"
//   Operations are only permitted on enabled directories.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource could not be found.
//
//   * ErrCodeObjectAlreadyDetachedException "ObjectAlreadyDetachedException"
//   Indicates that the object is not attached to the index.
//
//   * ErrCodeNotIndexException "NotIndexException"
//   Indicates that the requested operation can only operate on index objects.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2016-05-10/DetachFromIndex
func (c *CloudDirectory) DetachFromIndex(input *DetachFromIndexInput) (*DetachFromIndexOutput, error) {
	req, out := c.DetachFromIndexRequest(input)
	return out, req.Send()
}

// DetachFromIndexWithContext is the same as DetachFromIndex with the addition of
// the ability to pass a context and additional request options.
//
// See DetachFromIndex for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudDirectory) DetachFromIndexWithContext(ctx aws.Context, input *DetachFromIndexInput, opts ...request.Option) (*DetachFromIndexOutput, error) {
	req, out := c.DetachFromIndexRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDetachObject = "DetachObject"

// DetachObjectRequest generates a "aws/request.Request" representing the
// client's request for the DetachObject operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DetachObject for more information on using the DetachObject
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DetachObjectRequest method.
//    req, resp := client.DetachObjectRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2016-05-10/DetachObject
func (c *CloudDirectory) DetachObjectRequest(input *DetachObjectInput) (req *request.Request, output *DetachObjectOutput) {
	op := &request.Operation{
		Name:       opDetachObject,
		HTTPMethod: "PUT",
		HTTPPath:   "/amazonclouddirectory/2017-01-11/object/detach",
	}

	if input == nil {
		input = &DetachObjectInput{}
	}

	output = &DetachObjectOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DetachObject API operation for Amazon CloudDirectory.
//
// Detaches a given object from the parent object. The object that is to be
// detached from the parent is specified by the link name.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudDirectory's
// API operation DetachObject for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalServiceException "InternalServiceException"
//   Indicates a problem that must be resolved by Amazon Web Services. This might
//   be a transient error in which case you can retry your request until it succeeds.
//   Otherwise, go to the AWS Service Health Dashboard (http://status.aws.amazon.com/)
//   site to see if there are any operational issues with the service.
//
//   * ErrCodeInvalidArnException "InvalidArnException"
//   Indicates that the provided ARN value is not valid.
//
//   * ErrCodeRetryableConflictException "RetryableConflictException"
//   Occurs when a conflict with a previous successful write is detected. For
//   example, if a write operation occurs on an object and then an attempt is
//   made to read the object using “SERIALIZABLE” consistency, this exception
//   may result. This generally occurs when the previous write did not have time
//   to propagate to the host serving the current request. A retry (with appropriate
//   backoff logic) is the recommended response to this exception.
//
//   * ErrCodeValidationException "ValidationException"
//   Indicates that your request is malformed in some manner. See the exception
//   message.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   Indicates that limits are exceeded. See Limits (http://docs.aws.amazon.com/directoryservice/latest/admin-guide/limits.html)
//   for more information.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   Access denied. Check your permissions.
//
//   * ErrCodeDirectoryNotEnabledException "DirectoryNotEnabledException"
//   Operations are only permitted on enabled directories.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource could not be found.
//
//   * ErrCodeNotNodeException "NotNodeException"
//   Occurs when any invalid operations are performed on an object that is not
//   a node, such as calling ListObjectChildren for a leaf node object.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2016-05-10/DetachObject
func (c *CloudDirectory) DetachObject(input *DetachObjectInput) (*DetachObjectOutput, error) {
	req, out := c.DetachObjectRequest(input)
	return out, req.Send()
}

// DetachObjectWithContext is the same as DetachObject with the addition of
// the ability to pass a context and additional request options.
//
// See DetachObject for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudDirectory) DetachObjectWithContext(ctx aws.Context, input *DetachObjectInput, opts ...request.Option) (*DetachObjectOutput, error) {
	req, out := c.DetachObjectRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDetachPolicy = "DetachPolicy"

// DetachPolicyRequest generates a "aws/request.Request" representing the
// client's request for the DetachPolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DetachPolicy for more information on using the DetachPolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DetachPolicyRequest method.
//    req, resp := client.DetachPolicyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2016-05-10/DetachPolicy
func (c *CloudDirectory) DetachPolicyRequest(input *DetachPolicyInput) (req *request.Request, output *DetachPolicyOutput) {
	op := &request.Operation{
		Name:       opDetachPolicy,
		HTTPMethod: "PUT",
		HTTPPath:   "/amazonclouddirectory/2017-01-11/policy/detach",
	}

	if input == nil {
		input = &DetachPolicyInput{}
	}

	output = &DetachPolicyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DetachPolicy API operation for Amazon CloudDirectory.
//
// Detaches a policy from an object.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudDirectory's
// API operation DetachPolicy for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalServiceException "InternalServiceException"
//   Indicates a problem that must be resolved by Amazon Web Services. This might
//   be a transient error in which case you can retry your request until it succeeds.
//   Otherwise, go to the AWS Service Health Dashboard (http://status.aws.amazon.com/)
//   site to see if there are any operational issues with the service.
//
//   * ErrCodeInvalidArnException "InvalidArnException"
//   Indicates that the provided ARN value is not valid.
//
//   * ErrCodeRetryableConflictException "RetryableConflictException"
//   Occurs when a conflict with a previous successful write is detected. For
//   example, if a write operation occurs on an object and then an attempt is
//   made to read the object using “SERIALIZABLE” consistency, this exception
//   may result. This generally occurs when the previous write did not have time
//   to propagate to the host serving the current request. A retry (with appropriate
//   backoff logic) is the recommended response to this exception.
//
//   * ErrCodeValidationException "ValidationException"
//   Indicates that your request is malformed in some manner. See the exception
//   message.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   Indicates that limits are exceeded. See Limits (http://docs.aws.amazon.com/directoryservice/latest/admin-guide/limits.html)
//   for more information.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   Access denied. Check your permissions.
//
//   * ErrCodeDirectoryNotEnabledException "DirectoryNotEnabledException"
//   Operations are only permitted on enabled directories.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource could not be found.
//
//   * ErrCodeNotPolicyException "NotPolicyException"
//   Indicates that the requested operation can only operate on policy objects.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2016-05-10/DetachPolicy
func (c *CloudDirectory) DetachPolicy(input *DetachPolicyInput) (*DetachPolicyOutput, error) {
	req, out := c.DetachPolicyRequest(input)
	return out, req.Send()
}

// DetachPolicyWithContext is the same as DetachPolicy with the addition of
// the ability to pass a context and additional request options.
//
// See DetachPolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudDirectory) DetachPolicyWithContext(ctx aws.Context, input *DetachPolicyInput, opts ...request.Option) (*DetachPolicyOutput, error) {
	req, out := c.DetachPolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDetachTypedLink = "DetachTypedLink"

// DetachTypedLinkRequest generates a "aws/request.Request" representing the
// client's request for the DetachTypedLink operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DetachTypedLink for more information on using the DetachTypedLink
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DetachTypedLinkRequest method.
//    req, resp := client.DetachTypedLinkRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2016-05-10/DetachTypedLink
func (c *CloudDirectory) DetachTypedLinkRequest(input *DetachTypedLinkInput) (req *request.Request, output *DetachTypedLinkOutput) {
	op := &request.Operation{
		Name:       opDetachTypedLink,
		HTTPMethod: "PUT",
		HTTPPath:   "/amazonclouddirectory/2017-01-11/typedlink/detach",
	}

	if input == nil {
		input = &DetachTypedLinkInput{}
	}

	output = &DetachTypedLinkOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(restjson.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// DetachTypedLink API operation for Amazon CloudDirectory.
//
// Detaches a typed link from a specified source and target object. For more
// information, see Typed link (http://docs.aws.amazon.com/directoryservice/latest/admin-guide/objectsandlinks.html#typedlink).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudDirectory's
// API operation DetachTypedLink for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalServiceException "InternalServiceException"
//   Indicates a problem that must be resolved by Amazon Web Services. This might
//   be a transient error in which case you can retry your request until it succeeds.
//   Otherwise, go to the AWS Service Health Dashboard (http://status.aws.amazon.com/)
//   site to see if there are any operational issues with the service.
//
//   * ErrCodeInvalidArnException "InvalidArnException"
//   Indicates that the provided ARN value is not valid.
//
//   * ErrCodeRetryableConflictException "RetryableConflictException"
//   Occurs when a conflict with a previous successful write is detected. For
//   example, if a write operation occurs on an object and then an attempt is
//   made to read the object using “SERIALIZABLE” consistency, this exception
//   may result. This generally occurs when the previous write did not have time
//   to propagate to the host serving the current request. A retry (with appropriate
//   backoff logic) is the recommended response to this exception.
//
//   * ErrCodeValidationException "ValidationException"
//   Indicates that your request is malformed in some manner. See the exception
//   message.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   Indicates that limits are exceeded. See Limits (http://docs.aws.amazon.com/directoryservice/latest/admin-guide/limits.html)
//   for more information.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   Access denied. Check your permissions.
//
//   * ErrCodeDirectoryNotEnabledException "DirectoryNotEnabledException"
//   Operations are only permitted on enabled directories.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource could not be found.
//
//   * ErrCodeFacetValidationException "FacetValidationException"
//   The Facet that you provided was not well formed or could not be validated
//   with the schema.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2016-05-10/DetachTypedLink
func (c *CloudDirectory) DetachTypedLink(input *DetachTypedLinkInput) (*DetachTypedLinkOutput, error) {
	req, out := c.DetachTypedLinkRequest(input)
	return out, req.Send()
}

// DetachTypedLinkWithContext is the same as DetachTypedLink with the addition of
// the ability to pass a context and additional request options.
//
// See DetachTypedLink for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudDirectory) DetachTypedLinkWithContext(ctx aws.Context, input *DetachTypedLinkInput, opts ...request.Option) (*DetachTypedLinkOutput, error) {
	req, out := c.DetachTypedLinkRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDisableDirectory = "DisableDirectory"

// DisableDirectoryRequest generates a "aws/request.Request" representing the
// client's request for the DisableDirectory operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DisableDirectory for more information on using the DisableDirectory
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DisableDirectoryRequest method.
//    req, resp := client.DisableDirectoryRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2016-05-10/DisableDirectory
func (c *CloudDirectory) DisableDirectoryRequest(input *DisableDirectoryInput) (req *request.Request, output *DisableDirectoryOutput) {
	op := &request.Operation{
		Name:       opDisableDirectory,
		HTTPMethod: "PUT",
		HTTPPath:   "/amazonclouddirectory/2017-01-11/directory/disable",
	}

	if input == nil {
		input = &DisableDirectoryInput{}
	}

	output = &DisableDirectoryOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DisableDirectory API operation for Amazon CloudDirectory.
//
// Disables the specified directory. Disabled directories cannot be read or
// written to. Only enabled directories can be disabled. Disabled directories
// may be reenabled.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudDirectory's
// API operation DisableDirectory for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource could not be found.
//
//   * ErrCodeDirectoryDeletedException "DirectoryDeletedException"
//   A directory that has been deleted and to which access has been attempted.
//   Note: The requested resource will eventually cease to exist.
//
//   * ErrCodeInternalServiceException "InternalServiceException"
//   Indicates a problem that must be resolved by Amazon Web Services. This might
//   be a transient error in which case you can retry your request until it succeeds.
//   Otherwise, go to the AWS Service Health Dashboard (http://status.aws.amazon.com/)
//   site to see if there are any operational issues with the service.
//
//   * ErrCodeValidationException "ValidationException"
//   Indicates that your request is malformed in some manner. See the exception
//   message.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   Indicates that limits are exceeded. See Limits (http://docs.aws.amazon.com/directoryservice/latest/admin-guide/limits.html)
//   for more information.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   Access denied. Check your permissions.
//
//   * ErrCodeRetryableConflictException "RetryableConflictException"
//   Occurs when a conflict with a previous successful write is detected. For
//   example, if a write operation occurs on an object and then an attempt is
//   made to read the object using “SERIALIZABLE” consistency, this exception
//   may result. This generally occurs when the previous write did not have time
//   to propagate to the host serving the current request. A retry (with appropriate
//   backoff logic) is the recommended response to this exception.
//
//   * ErrCodeInvalidArnException "InvalidArnException"
//   Indicates that the provided ARN value is not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2016-05-10/DisableDirectory
func (c *CloudDirectory) DisableDirectory(input *DisableDirectoryInput) (*DisableDirectoryOutput, error) {
	req, out := c.DisableDirectoryRequest(input)
	return out, req.Send()
}

// DisableDirectoryWithContext is the same as DisableDirectory with the addition of
// the ability to pass a context and additional request options.
//
// See DisableDirectory for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudDirectory) DisableDirectoryWithContext(ctx aws.Context, input *DisableDirectoryInput, opts ...request.Option) (*DisableDirectoryOutput, error) {
	req, out := c.DisableDirectoryRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opEnableDirectory = "EnableDirectory"

// EnableDirectoryRequest generates a "aws/request.Request" representing the
// client's request for the EnableDirectory operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See EnableDirectory for more information on using the EnableDirectory
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the EnableDirectoryRequest method.
//    req, resp := client.EnableDirectoryRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2016-05-10/EnableDirectory
func (c *CloudDirectory) EnableDirectoryRequest(input *EnableDirectoryInput) (req *request.Request, output *EnableDirectoryOutput) {
	op := &request.Operation{
		Name:       opEnableDirectory,
		HTTPMethod: "PUT",
		HTTPPath:   "/amazonclouddirectory/2017-01-11/directory/enable",
	}

	if input == nil {
		input = &EnableDirectoryInput{}
	}

	output = &EnableDirectoryOutput{}
	req = c.newRequest(op, input, output)
	return
}

// EnableDirectory API operation for Amazon CloudDirectory.
//
// Enables the specified directory. Only disabled directories can be enabled.
// Once enabled, the directory can then be read and written to.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudDirectory's
// API operation EnableDirectory for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource could not be found.
//
//   * ErrCodeDirectoryDeletedException "DirectoryDeletedException"
//   A directory that has been deleted and to which access has been attempted.
//   Note: The requested resource will eventually cease to exist.
//
//   * ErrCodeInternalServiceException "InternalServiceException"
//   Indicates a problem that must be resolved by Amazon Web Services. This might
//   be a transient error in which case you can retry your request until it succeeds.
//   Otherwise, go to the AWS Service Health Dashboard (http://status.aws.amazon.com/)
//   site to see if there are any operational issues with the service.
//
//   * ErrCodeValidationException "ValidationException"
//   Indicates that your request is malformed in some manner. See the exception
//   message.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   Indicates that limits are exceeded. See Limits (http://docs.aws.amazon.com/directoryservice/latest/admin-guide/limits.html)
//   for more information.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   Access denied. Check your permissions.
//
//   * ErrCodeRetryableConflictException "RetryableConflictException"
//   Occurs when a conflict with a previous successful write is detected. For
//   example, if a write operation occurs on an object and then an attempt is
//   made to read the object using “SERIALIZABLE” consistency, this exception
//   may result. This generally occurs when the previous write did not have time
//   to propagate to the host serving the current request. A retry (with appropriate
//   backoff logic) is the recommended response to this exception.
//
//   * ErrCodeInvalidArnException "InvalidArnException"
//   Indicates that the provided ARN value is not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2016-05-10/EnableDirectory
func (c *CloudDirectory) EnableDirectory(input *EnableDirectoryInput) (*EnableDirectoryOutput, error) {
	req, out := c.EnableDirectoryRequest(input)
	return out, req.Send()
}

// EnableDirectoryWithContext is the same as EnableDirectory with the addition of
// the ability to pass a context and additional request options.
//
// See EnableDirectory for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudDirectory) EnableDirectoryWithContext(ctx aws.Context, input *EnableDirectoryInput, opts ...request.Option) (*EnableDirectoryOutput, error) {
	req, out := c.EnableDirectoryRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetAppliedSchemaVersion = "GetAppliedSchemaVersion"

// GetAppliedSchemaVersionRequest generates a "aws/request.Request" representing the
// client's request for the GetAppliedSchemaVersion operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetAppliedSchemaVersion for more information on using the GetAppliedSchemaVersion
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetAppliedSchemaVersionRequest method.
//    req, resp := client.GetAppliedSchemaVersionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2016-05-10/GetAppliedSchemaVersion
func (c *CloudDirectory) GetAppliedSchemaVersionRequest(input *GetAppliedSchemaVersionInput) (req *request.Request, output *GetAppliedSchemaVersionOutput) {
	op := &request.Operation{
		Name:       opGetAppliedSchemaVersion,
		HTTPMethod: "POST",
		HTTPPath:   "/amazonclouddirectory/2017-01-11/schema/getappliedschema",
	}

	if input == nil {
		input = &GetAppliedSchemaVersionInput{}
	}

	output = &GetAppliedSchemaVersionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetAppliedSchemaVersion API operation for Amazon CloudDirectory.
//
// Returns current applied schema version ARN, including the minor version in
// use.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudDirectory's
// API operation GetAppliedSchemaVersion for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalServiceException "InternalServiceException"
//   Indicates a problem that must be resolved by Amazon Web Services. This might
//   be a transient error in which case you can retry your request until it succeeds.
//   Otherwise, go to the AWS Service Health Dashboard (http://status.aws.amazon.com/)
//   site to see if there are any operational issues with the service.
//
//   * ErrCodeInvalidArnException "InvalidArnException"
//   Indicates that the provided ARN value is not valid.
//
//   * ErrCodeRetryableConflictException "RetryableConflictException"
//   Occurs when a conflict with a previous successful write is detected. For
//   example, if a write operation occurs on an object and then an attempt is
//   made to read the object using “SERIALIZABLE” consistency, this exception
//   may result. This generally occurs when the previous write did not have time
//   to propagate to the host serving the current request. A retry (with appropriate
//   backoff logic) is the recommended response to this exception.
//
//   * ErrCodeValidationException "ValidationException"
//   Indicates that your request is malformed in some manner. See the exception
//   message.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   Indicates that limits are exceeded. See Limits (http://docs.aws.amazon.com/directoryservice/latest/admin-guide/limits.html)
//   for more information.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   Access denied. Check your permissions.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource could not be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2016-05-10/GetAppliedSchemaVersion
func (c *CloudDirectory) GetAppliedSchemaVersion(input *GetAppliedSchemaVersionInput) (*GetAppliedSchemaVersionOutput, error) {
	req, out := c.GetAppliedSchemaVersionRequest(input)
	return out, req.Send()
}

// GetAppliedSchemaVersionWithContext is the same as GetAppliedSchemaVersion with the addition of
// the ability to pass a context and additional request options.
//
// See GetAppliedSchemaVersion for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudDirectory) GetAppliedSchemaVersionWithContext(ctx aws.Context, input *GetAppliedSchemaVersionInput, opts ...request.Option) (*GetAppliedSchemaVersionOutput, error) {
	req, out := c.GetAppliedSchemaVersionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetDirectory = "GetDirectory"

// GetDirectoryRequest generates a "aws/request.Request" representing the
// client's request for the GetDirectory operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetDirectory for more information on using the GetDirectory
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetDirectoryRequest method.
//    req, resp := client.GetDirectoryRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2016-05-10/GetDirectory
func (c *CloudDirectory) GetDirectoryRequest(input *GetDirectoryInput) (req *request.Request, output *GetDirectoryOutput) {
	op := &request.Operation{
		Name:       opGetDirectory,
		HTTPMethod: "POST",
		HTTPPath:   "/amazonclouddirectory/2017-01-11/directory/get",
	}

	if input == nil {
		input = &GetDirectoryInput{}
	}

	output = &GetDirectoryOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetDirectory API operation for Amazon CloudDirectory.
//
// Retrieves metadata about a directory.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudDirectory's
// API operation GetDirectory for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalServiceException "InternalServiceException"
//   Indicates a problem that must be resolved by Amazon Web Services. This might
//   be a transient error in which case you can retry your request until it succeeds.
//   Otherwise, go to the AWS Service Health Dashboard (http://status.aws.amazon.com/)
//   site to see if there are any operational issues with the service.
//
//   * ErrCodeInvalidArnException "InvalidArnException"
//   Indicates that the provided ARN value is not valid.
//
//   * ErrCodeRetryableConflictException "RetryableConflictException"
//   Occurs when a conflict with a previous successful write is detected. For
//   example, if a write operation occurs on an object and then an attempt is
//   made to read the object using “SERIALIZABLE” consistency, this exception
//   may result. This generally occurs when the previous write did not have time
//   to propagate to the host serving the current request. A retry (with appropriate
//   backoff logic) is the recommended response to this exception.
//
//   * ErrCodeValidationException "ValidationException"
//   Indicates that your request is malformed in some manner. See the exception
//   message.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   Indicates that limits are exceeded. See Limits (http://docs.aws.amazon.com/directoryservice/latest/admin-guide/limits.html)
//   for more information.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   Access denied. Check your permissions.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2016-05-10/GetDirectory
func (c *CloudDirectory) GetDirectory(input *GetDirectoryInput) (*GetDirectoryOutput, error) {
	req, out := c.GetDirectoryRequest(input)
	return out, req.Send()
}

// GetDirectoryWithContext is the same as GetDirectory with the addition of
// the ability to pass a context and additional request options.
//
// See GetDirectory for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudDirectory) GetDirectoryWithContext(ctx aws.Context, input *GetDirectoryInput, opts ...request.Option) (*GetDirectoryOutput, error) {
	req, out := c.GetDirectoryRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetFacet = "GetFacet"

// GetFacetRequest generates a "aws/request.Request" representing the
// client's request for the GetFacet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetFacet for more information on using the GetFacet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetFacetRequest method.
//    req, resp := client.GetFacetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2016-05-10/GetFacet
func (c *CloudDirectory) GetFacetRequest(input *GetFacetInput) (req *request.Request, output *GetFacetOutput) {
	op := &request.Operation{
		Name:       opGetFacet,
		HTTPMethod: "POST",
		HTTPPath:   "/amazonclouddirectory/2017-01-11/facet",
	}

	if input == nil {
		input = &GetFacetInput{}
	}

	output = &GetFacetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetFacet API operation for Amazon CloudDirectory.
//
// Gets details of the Facet, such as facet name, attributes, Rules, or ObjectType.
// You can call this on all kinds of schema facets -- published, development,
// or applied.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudDirectory's
// API operation GetFacet for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalServiceException "InternalServiceException"
//   Indicates a problem that must be resolved by Amazon Web Services. This might
//   be a transient error in which case you can retry your request until it succeeds.
//   Otherwise, go to the AWS Service Health Dashboard (http://status.aws.amazon.com/)
//   site to see if there are any operational issues with the service.
//
//   * ErrCodeInvalidArnException "InvalidArnException"
//   Indicates that the provided ARN value is not valid.
//
//   * ErrCodeRetryableConflictException "RetryableConflictException"
//   Occurs when a conflict with a previous successful write is detected. For
//   example, if a write operation occurs on an object and then an attempt is
//   made to read the object using “SERIALIZABLE” consistency, this exception
//   may result. This generally occurs when the previous write did not have time
//   to propagate to the host serving the current request. A retry (with appropriate
//   backoff logic) is the recommended response to this exception.
//
//   * ErrCodeValidationException "ValidationException"
//   Indicates that your request is malformed in some manner. See the exception
//   message.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   Indicates that limits are exceeded. See Limits (http://docs.aws.amazon.com/directoryservice/latest/admin-guide/limits.html)
//   for more information.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   Access denied. Check your permissions.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource could not be found.
//
//   * ErrCodeFacetNotFoundException "FacetNotFoundException"
//   The specified Facet could not be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2016-05-10/GetFacet
func (c *CloudDirectory) GetFacet(input *GetFacetInput) (*GetFacetOutput, error) {
	req, out := c.GetFacetRequest(input)
	return out, req.Send()
}

// GetFacetWithContext is the same as GetFacet with the addition of
// the ability to pass a context and additional request options.
//
// See GetFacet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudDirectory) GetFacetWithContext(ctx aws.Context, input *GetFacetInput, opts ...request.Option) (*GetFacetOutput, error) {
	req, out := c.GetFacetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetObjectAttributes = "GetObjectAttributes"

// GetObjectAttributesRequest generates a "aws/request.Request" representing the
// client's request for the GetObjectAttributes operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetObjectAttributes for more information on using the GetObjectAttributes
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetObjectAttributesRequest method.
//    req, resp := client.GetObjectAttributesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2016-05-10/GetObjectAttributes
func (c *CloudDirectory) GetObjectAttributesRequest(input *GetObjectAttributesInput) (req *request.Request, output *GetObjectAttributesOutput) {
	op := &request.Operation{
		Name:       opGetObjectAttributes,
		HTTPMethod: "POST",
		HTTPPath:   "/amazonclouddirectory/2017-01-11/object/attributes/get",
	}

	if input == nil {
		input = &GetObjectAttributesInput{}
	}

	output = &GetObjectAttributesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetObjectAttributes API operation for Amazon CloudDirectory.
//
// Retrieves attributes within a facet that are associated with an object.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudDirectory's
// API operation GetObjectAttributes for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalServiceException "InternalServiceException"
//   Indicates a problem that must be resolved by Amazon Web Services. This might
//   be a transient error in which case you can retry your request until it succeeds.
//   Otherwise, go to the AWS Service Health Dashboard (http://status.aws.amazon.com/)
//   site to see if there are any operational issues with the service.
//
//   * ErrCodeInvalidArnException "InvalidArnException"
//   Indicates that the provided ARN value is not valid.
//
//   * ErrCodeRetryableConflictException "RetryableConflictException"
//   Occurs when a conflict with a previous successful write is detected. For
//   example, if a write operation occurs on an object and then an attempt is
//   made to read the object using “SERIALIZABLE” consistency, this exception
//   may result. This generally occurs when the previous write did not have time
//   to propagate to the host serving the current request. A retry (with appropriate
//   backoff logic) is the recommended response to this exception.
//
//   * ErrCodeValidationException "ValidationException"
//   Indicates that your request is malformed in some manner. See the exception
//   message.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   Indicates that limits are exceeded. See Limits (http://docs.aws.amazon.com/directoryservice/latest/admin-guide/limits.html)
//   for more information.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   Access denied. Check your permissions.
//
//   * ErrCodeDirectoryNotEnabledException "DirectoryNotEnabledException"
//   Operations are only permitted on enabled directories.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource could not be found.
//
//   * ErrCodeFacetValidationException "FacetValidationException"
//   The Facet that you provided was not well formed or could not be validated
//   with the schema.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2016-05-10/GetObjectAttributes
func (c *CloudDirectory) GetObjectAttributes(input *GetObjectAttributesInput) (*GetObjectAttributesOutput, error) {
	req, out := c.GetObjectAttributesRequest(input)
	return out, req.Send()
}

// GetObjectAttributesWithContext is the same as GetObjectAttributes with the addition of
// the ability to pass a context and additional request options.
//
// See GetObjectAttributes for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudDirectory) GetObjectAttributesWithContext(ctx aws.Context, input *GetObjectAttributesInput, opts ...request.Option) (*GetObjectAttributesOutput, error) {
	req, out := c.GetObjectAttributesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetObjectInformation = "GetObjectInformation"

// GetObjectInformationRequest generates a "aws/request.Request" representing the
// client's request for the GetObjectInformation operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetObjectInformation for more information on using the GetObjectInformation
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetObjectInformationRequest method.
//    req, resp := client.GetObjectInformationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2016-05-10/GetObjectInformation
func (c *CloudDirectory) GetObjectInformationRequest(input *GetObjectInformationInput) (req *request.Request, output *GetObjectInformationOutput) {
	op := &request.Operation{
		Name:       opGetObjectInformation,
		HTTPMethod: "POST",
		HTTPPath:   "/amazonclouddirectory/2017-01-11/object/information",
	}

	if input == nil {
		input = &GetObjectInformationInput{}
	}

	output = &GetObjectInformationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetObjectInformation API operation for Amazon CloudDirectory.
//
// Retrieves metadata about an object.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudDirectory's
// API operation GetObjectInformation for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalServiceException "InternalServiceException"
//   Indicates a problem that must be resolved by Amazon Web Services. This might
//   be a transient error in which case you can retry your request until it succeeds.
//   Otherwise, go to the AWS Service Health Dashboard (http://status.aws.amazon.com/)
//   site to see if there are any operational issues with the service.
//
//   * ErrCodeInvalidArnException "InvalidArnException"
//   Indicates that the provided ARN value is not valid.
//
//   * ErrCodeRetryableConflictException "RetryableConflictException"
//   Occurs when a conflict with a previous successful write is detected. For
//   example, if a write operation occurs on an object and then an attempt is
//   made to read the object using “SERIALIZABLE” consistency, this exception
//   may result. This generally occurs when the previous write did not have time
//   to propagate to the host serving the current request. A retry (with appropriate
//   backoff logic) is the recommended response to this exception.
//
//   * ErrCodeValidationException "ValidationException"
//   Indicates that your request is malformed in some manner. See the exception
//   message.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   Indicates that limits are exceeded. See Limits (http://docs.aws.amazon.com/directoryservice/latest/admin-guide/limits.html)
//   for more information.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   Access denied. Check your permissions.
//
//   * ErrCodeDirectoryNotEnabledException "DirectoryNotEnabledException"
//   Operations are only permitted on enabled directories.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource could not be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2016-05-10/GetObjectInformation
func (c *CloudDirectory) GetObjectInformation(input *GetObjectInformationInput) (*GetObjectInformationOutput, error) {
	req, out := c.GetObjectInformationRequest(input)
	return out, req.Send()
}

// GetObjectInformationWithContext is the same as GetObjectInformation with the addition of
// the ability to pass a context and additional request options.
//
// See GetObjectInformation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudDirectory) GetObjectInformationWithContext(ctx aws.Context, input *GetObjectInformationInput, opts ...request.Option) (*GetObjectInformationOutput, error) {
	req, out := c.GetObjectInformationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetSchemaAsJson = "GetSchemaAsJson"

// GetSchemaAsJsonRequest generates a "aws/request.Request" representing the
// client's request for the GetSchemaAsJson operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetSchemaAsJson for more information on using the GetSchemaAsJson
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetSchemaAsJsonRequest method.
//    req, resp := client.GetSchemaAsJsonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2016-05-10/GetSchemaAsJson
func (c *CloudDirectory) GetSchemaAsJsonRequest(input *GetSchemaAsJsonInput) (req *request.Request, output *GetSchemaAsJsonOutput) {
	op := &request.Operation{
		Name:       opGetSchemaAsJson,
		HTTPMethod: "POST",
		HTTPPath:   "/amazonclouddirectory/2017-01-11/schema/json",
	}

	if input == nil {
		input = &GetSchemaAsJsonInput{}
	}

	output = &GetSchemaAsJsonOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetSchemaAsJson API operation for Amazon CloudDirectory.
//
// Retrieves a JSON representation of the schema. See JSON Schema Format (http://docs.aws.amazon.com/directoryservice/latest/admin-guide/cd_schemas.html#jsonformat)
// for more information.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudDirectory's
// API operation GetSchemaAsJson for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalServiceException "InternalServiceException"
//   Indicates a problem that must be resolved by Amazon Web Services. This might
//   be a transient error in which case you can retry your request until it succeeds.
//   Otherwise, go to the AWS Service Health Dashboard (http://status.aws.amazon.com/)
//   site to see if there are any operational issues with the service.
//
//   * ErrCodeInvalidArnException "InvalidArnException"
//   Indicates that the provided ARN value is not valid.
//
//   * ErrCodeRetryableConflictException "RetryableConflictException"
//   Occurs when a conflict with a previous successful write is detected. For
//   example, if a write operation occurs on an object and then an attempt is
//   made to read the object using “SERIALIZABLE” consistency, this exception
//   may result. This generally occurs when the previous write did not have time
//   to propagate to the host serving the current request. A retry (with appropriate
//   backoff logic) is the recommended response to this exception.
//
//   * ErrCodeValidationException "ValidationException"
//   Indicates that your request is malformed in some manner. See the exception
//   message.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   Indicates that limits are exceeded. See Limits (http://docs.aws.amazon.com/directoryservice/latest/admin-guide/limits.html)
//   for more information.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   Access denied. Check your permissions.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource could not be found.
//
//   * ErrCodeValidationException "ValidationException"
//   Indicates that your request is malformed in some manner. See the exception
//   message.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2016-05-10/GetSchemaAsJson
func (c *CloudDirectory) GetSchemaAsJson(input *GetSchemaAsJsonInput) (*GetSchemaAsJsonOutput, error) {
	req, out := c.GetSchemaAsJsonRequest(input)
	return out, req.Send()
}

// GetSchemaAsJsonWithContext is the same as GetSchemaAsJson with the addition of
// the ability to pass a context and additional request options.
//
// See GetSchemaAsJson for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudDirectory) GetSchemaAsJsonWithContext(ctx aws.Context, input *GetSchemaAsJsonInput, opts ...request.Option) (*GetSchemaAsJsonOutput, error) {
	req, out := c.GetSchemaAsJsonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetTypedLinkFacetInformation = "GetTypedLinkFacetInformation"

// GetTypedLinkFacetInformationRequest generates a "aws/request.Request" representing the
// client's request for the GetTypedLinkFacetInformation operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetTypedLinkFacetInformation for more information on using the GetTypedLinkFacetInformation
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetTypedLinkFacetInformationRequest method.
//    req, resp := client.GetTypedLinkFacetInformationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2016-05-10/GetTypedLinkFacetInformation
func (c *CloudDirectory) GetTypedLinkFacetInformationRequest(input *GetTypedLinkFacetInformationInput) (req *request.Request, output *GetTypedLinkFacetInformationOutput) {
	op := &request.Operation{
		Name:       opGetTypedLinkFacetInformation,
		HTTPMethod: "POST",
		HTTPPath:   "/amazonclouddirectory/2017-01-11/typedlink/facet/get",
	}

	if input == nil {
		input = &GetTypedLinkFacetInformationInput{}
	}

	output = &GetTypedLinkFacetInformationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetTypedLinkFacetInformation API operation for Amazon CloudDirectory.
//
// Returns the identity attribute order for a specific TypedLinkFacet. For more
// information, see Typed link (http://docs.aws.amazon.com/directoryservice/latest/admin-guide/objectsandlinks.html#typedlink).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudDirectory's
// API operation GetTypedLinkFacetInformation for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalServiceException "InternalServiceException"
//   Indicates a problem that must be resolved by Amazon Web Services. This might
//   be a transient error in which case you can retry your request until it succeeds.
//   Otherwise, go to the AWS Service Health Dashboard (http://status.aws.amazon.com/)
//   site to see if there are any operational issues with the service.
//
//   * ErrCodeInvalidArnException "InvalidArnException"
//   Indicates that the provided ARN value is not valid.
//
//   * ErrCodeRetryableConflictException "RetryableConflictException"
//   Occurs when a conflict with a previous successful write is detected. For
//   example, if a write operation occurs on an object and then an attempt is
//   made to read the object using “SERIALIZABLE” consistency, this exception
//   may result. This generally occurs when the previous write did not have time
//   to propagate to the host serving the current request. A retry (with appropriate
//   backoff logic) is the recommended response to this exception.
//
//   * ErrCodeValidationException "ValidationException"
//   Indicates that your request is malformed in some manner. See the exception
//   message.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   Indicates that limits are exceeded. See Limits (http://docs.aws.amazon.com/directoryservice/latest/admin-guide/limits.html)
//   for more information.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   Access denied. Check your permissions.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource could not be found.
//
//   * ErrCodeInvalidNextTokenException "InvalidNextTokenException"
//   Indicates that the NextToken value is not valid.
//
//   * ErrCodeFacetNotFoundException "FacetNotFoundException"
//   The specified Facet could not be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2016-05-10/GetTypedLinkFacetInformation
func (c *CloudDirectory) GetTypedLinkFacetInformation(input *GetTypedLinkFacetInformationInput) (*GetTypedLinkFacetInformationOutput, error) {
	req, out := c.GetTypedLinkFacetInformationRequest(input)
	return out, req.Send()
}

// GetTypedLinkFacetInformationWithContext is the same as GetTypedLinkFacetInformation with the addition of
// the ability to pass a context and additional request options.
//
// See GetTypedLinkFacetInformation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudDirectory) GetTypedLinkFacetInformationWithContext(ctx aws.Context, input *GetTypedLinkFacetInformationInput, opts ...request.Option) (*GetTypedLinkFacetInformationOutput, error) {
	req, out := c.GetTypedLinkFacetInformationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListAppliedSchemaArns = "ListAppliedSchemaArns"

// ListAppliedSchemaArnsRequest generates a "aws/request.Request" representing the
// client's request for the ListAppliedSchemaArns operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListAppliedSchemaArns for more information on using the ListAppliedSchemaArns
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListAppliedSchemaArnsRequest method.
//    req, resp := client.ListAppliedSchemaArnsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2016-05-10/ListAppliedSchemaArns
func (c *CloudDirectory) ListAppliedSchemaArnsRequest(input *ListAppliedSchemaArnsInput) (req *request.Request, output *ListAppliedSchemaArnsOutput) {
	op := &request.Operation{
		Name:       opListAppliedSchemaArns,
		HTTPMethod: "POST",
		HTTPPath:   "/amazonclouddirectory/2017-01-11/schema/applied",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListAppliedSchemaArnsInput{}
	}

	output = &ListAppliedSchemaArnsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListAppliedSchemaArns API operation for Amazon CloudDirectory.
//
// Lists schema major versions applied to a directory. If SchemaArn is provided,
// lists the minor version.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudDirectory's
// API operation ListAppliedSchemaArns for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalServiceException "InternalServiceException"
//   Indicates a problem that must be resolved by Amazon Web Services. This might
//   be a transient error in which case you can retry your request until it succeeds.
//   Otherwise, go to the AWS Service Health Dashboard (http://status.aws.amazon.com/)
//   site to see if there are any operational issues with the service.
//
//   * ErrCodeInvalidArnException "InvalidArnException"
//   Indicates that the provided ARN value is not valid.
//
//   * ErrCodeRetryableConflictException "RetryableConflictException"
//   Occurs when a conflict with a previous successful write is detected. For
//   example, if a write operation occurs on an object and then an attempt is
//   made to read the object using “SERIALIZABLE” consistency, this exception
//   may result. This generally occurs when the previous write did not have time
//   to propagate to the host serving the current request. A retry (with appropriate
//   backoff logic) is the recommended response to this exception.
//
//   * ErrCodeValidationException "ValidationException"
//   Indicates that your request is malformed in some manner. See the exception
//   message.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   Indicates that limits are exceeded. See Limits (http://docs.aws.amazon.com/directoryservice/latest/admin-guide/limits.html)
//   for more information.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   Access denied. Check your permissions.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource could not be found.
//
//   * ErrCodeInvalidNextTokenException "InvalidNextTokenException"
//   Indicates that the NextToken value is not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2016-05-10/ListAppliedSchemaArns
func (c *CloudDirectory) ListAppliedSchemaArns(input *ListAppliedSchemaArnsInput) (*ListAppliedSchemaArnsOutput, error) {
	req, out := c.ListAppliedSchemaArnsRequest(input)
	return out, req.Send()
}

// ListAppliedSchemaArnsWithContext is the same as ListAppliedSchemaArns with the addition of
// the ability to pass a context and additional request options.
//
// See ListAppliedSchemaArns for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudDirectory) ListAppliedSchemaArnsWithContext(ctx aws.Context, input *ListAppliedSchemaArnsInput, opts ...request.Option) (*ListAppliedSchemaArnsOutput, error) {
	req, out := c.ListAppliedSchemaArnsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListAppliedSchemaArnsPages iterates over the pages of a ListAppliedSchemaArns operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListAppliedSchemaArns method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListAppliedSchemaArns operation.
//    pageNum := 0
//    err := client.ListAppliedSchemaArnsPages(params,
//        func(page *ListAppliedSchemaArnsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *CloudDirectory) ListAppliedSchemaArnsPages(input *ListAppliedSchemaArnsInput, fn func(*ListAppliedSchemaArnsOutput, bool) bool) error {
	return c.ListAppliedSchemaArnsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListAppliedSchemaArnsPagesWithContext same as ListAppliedSchemaArnsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudDirectory) ListAppliedSchemaArnsPagesWithContext(ctx aws.Context, input *ListAppliedSchemaArnsInput, fn func(*ListAppliedSchemaArnsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListAppliedSchemaArnsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListAppliedSchemaArnsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*ListAppliedSchemaArnsOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opListAttachedIndices = "ListAttachedIndices"

// ListAttachedIndicesRequest generates a "aws/request.Request" representing the
// client's request for the ListAttachedIndices operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListAttachedIndices for more information on using the ListAttachedIndices
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListAttachedIndicesRequest method.
//    req, resp := client.ListAttachedIndicesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2016-05-10/ListAttachedIndices
func (c *CloudDirectory) ListAttachedIndicesRequest(input *ListAttachedIndicesInput) (req *request.Request, output *ListAttachedIndicesOutput) {
	op := &request.Operation{
		Name:       opListAttachedIndices,
		HTTPMethod: "POST",
		HTTPPath:   "/amazonclouddirectory/2017-01-11/object/indices",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListAttachedIndicesInput{}
	}

	output = &ListAttachedIndicesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListAttachedIndices API operation for Amazon CloudDirectory.
//
// Lists indices attached to the specified object.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudDirectory's
// API operation ListAttachedIndices for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalServiceException "InternalServiceException"
//   Indicates a problem that must be resolved by Amazon Web Services. This might
//   be a transient error in which case you can retry your request until it succeeds.
//   Otherwise, go to the AWS Service Health Dashboard (http://status.aws.amazon.com/)
//   site to see if there are any operational issues with the service.
//
//   * ErrCodeInvalidArnException "InvalidArnException"
//   Indicates that the provided ARN value is not valid.
//
//   * ErrCodeRetryableConflictException "RetryableConflictException"
//   Occurs when a conflict with a previous successful write is detected. For
//   example, if a write operation occurs on an object and then an attempt is
//   made to read the object using “SERIALIZABLE” consistency, this exception
//   may result. This generally occurs when the previous write did not have time
//   to propagate to the host serving the current request. A retry (with appropriate
//   backoff logic) is the recommended response to this exception.
//
//   * ErrCodeValidationException "ValidationException"
//   Indicates that your request is malformed in some manner. See the exception
//   message.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   Indicates that limits are exceeded. See Limits (http://docs.aws.amazon.com/directoryservice/latest/admin-guide/limits.html)
//   for more information.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   Access denied. Check your permissions.
//
//   * ErrCodeDirectoryNotEnabledException "DirectoryNotEnabledException"
//   Operations are only permitted on enabled directories.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource could not be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2016-05-10/ListAttachedIndices
func (c *CloudDirectory) ListAttachedIndices(input *ListAttachedIndicesInput) (*ListAttachedIndicesOutput, error) {
	req, out := c.ListAttachedIndicesRequest(input)
	return out, req.Send()
}

// ListAttachedIndicesWithContext is the same as ListAttachedIndices with the addition of
// the ability to pass a context and additional request options.
//
// See ListAttachedIndices for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudDirectory) ListAttachedIndicesWithContext(ctx aws.Context, input *ListAttachedIndicesInput, opts ...request.Option) (*ListAttachedIndicesOutput, error) {
	req, out := c.ListAttachedIndicesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListAttachedIndicesPages iterates over the pages of a ListAttachedIndices operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListAttachedIndices method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListAttachedIndices operation.
//    pageNum := 0
//    err := client.ListAttachedIndicesPages(params,
//        func(page *ListAttachedIndicesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *CloudDirectory) ListAttachedIndicesPages(input *ListAttachedIndicesInput, fn func(*ListAttachedIndicesOutput, bool) bool) error {
	return c.ListAttachedIndicesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListAttachedIndicesPagesWithContext same as ListAttachedIndicesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudDirectory) ListAttachedIndicesPagesWithContext(ctx aws.Context, input *ListAttachedIndicesInput, fn func(*ListAttachedIndicesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListAttachedIndicesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListAttachedIndicesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*ListAttachedIndicesOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opListDevelopmentSchemaArns = "ListDevelopmentSchemaArns"

// ListDevelopmentSchemaArnsRequest generates a "aws/request.Request" representing the
// client's request for the ListDevelopmentSchemaArns operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListDevelopmentSchemaArns for more information on using the ListDevelopmentSchemaArns
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListDevelopmentSchemaArnsRequest method.
//    req, resp := client.ListDevelopmentSchemaArnsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2016-05-10/ListDevelopmentSchemaArns
func (c *CloudDirectory) ListDevelopmentSchemaArnsRequest(input *ListDevelopmentSchemaArnsInput) (req *request.Request, output *ListDevelopmentSchemaArnsOutput) {
	op := &request.Operation{
		Name:       opListDevelopmentSchemaArns,
		HTTPMethod: "POST",
		HTTPPath:   "/amazonclouddirectory/2017-01-11/schema/development",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListDevelopmentSchemaArnsInput{}
	}

	output = &ListDevelopmentSchemaArnsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListDevelopmentSchemaArns API operation for Amazon CloudDirectory.
//
// Retrieves each Amazon Resource Name (ARN) of schemas in the development state.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudDirectory's
// API operation ListDevelopmentSchemaArns for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalServiceException "InternalServiceException"
//   Indicates a problem that must be resolved by Amazon Web Services. This might
//   be a transient error in which case you can retry your request until it succeeds.
//   Otherwise, go to the AWS Service Health Dashboard (http://status.aws.amazon.com/)
//   site to see if there are any operational issues with the service.
//
//   * ErrCodeInvalidArnException "InvalidArnException"
//   Indicates that the provided ARN value is not valid.
//
//   * ErrCodeRetryableConflictException "RetryableConflictException"
//   Occurs when a conflict with a previous successful write is detected. For
//   example, if a write operation occurs on an object and then an attempt is
//   made to read the object using “SERIALIZABLE” consistency, this exception
//   may result. This generally occurs when the previous write did not have time
//   to propagate to the host serving the current request. A retry (with appropriate
//   backoff logic) is the recommended response to this exception.
//
//   * ErrCodeValidationException "ValidationException"
//   Indicates that your request is malformed in some manner. See the exception
//   message.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   Indicates that limits are exceeded. See Limits (http://docs.aws.amazon.com/directoryservice/latest/admin-guide/limits.html)
//   for more information.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   Access denied. Check your permissions.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource could not be found.
//
//   * ErrCodeInvalidNextTokenException "InvalidNextTokenException"
//   Indicates that the NextToken value is not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2016-05-10/ListDevelopmentSchemaArns
func (c *CloudDirectory) ListDevelopmentSchemaArns(input *ListDevelopmentSchemaArnsInput) (*ListDevelopmentSchemaArnsOutput, error) {
	req, out := c.ListDevelopmentSchemaArnsRequest(input)
	return out, req.Send()
}

// ListDevelopmentSchemaArnsWithContext is the same as ListDevelopmentSchemaArns with the addition of
// the ability to pass a context and additional request options.
//
// See ListDevelopmentSchemaArns for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudDirectory) ListDevelopmentSchemaArnsWithContext(ctx aws.Context, input *ListDevelopmentSchemaArnsInput, opts ...request.Option) (*ListDevelopmentSchemaArnsOutput, error) {
	req, out := c.ListDevelopmentSchemaArnsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListDevelopmentSchemaArnsPages iterates over the pages of a ListDevelopmentSchemaArns operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListDevelopmentSchemaArns method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListDevelopmentSchemaArns operation.
//    pageNum := 0
//    err := client.ListDevelopmentSchemaArnsPages(params,
//        func(page *ListDevelopmentSchemaArnsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *CloudDirectory) ListDevelopmentSchemaArnsPages(input *ListDevelopmentSchemaArnsInput, fn func(*ListDevelopmentSchemaArnsOutput, bool) bool) error {
	return c.ListDevelopmentSchemaArnsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListDevelopmentSchemaArnsPagesWithContext same as ListDevelopmentSchemaArnsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudDirectory) ListDevelopmentSchemaArnsPagesWithContext(ctx aws.Context, input *ListDevelopmentSchemaArnsInput, fn func(*ListDevelopmentSchemaArnsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListDevelopmentSchemaArnsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListDevelopmentSchemaArnsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*ListDevelopmentSchemaArnsOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opListDirectories = "ListDirectories"

// ListDirectoriesRequest generates a "aws/request.Request" representing the
// client's request for the ListDirectories operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListDirectories for more information on using the ListDirectories
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListDirectoriesRequest method.
//    req, resp := client.ListDirectoriesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2016-05-10/ListDirectories
func (c *CloudDirectory) ListDirectoriesRequest(input *ListDirectoriesInput) (req *request.Request, output *ListDirectoriesOutput) {
	op := &request.Operation{
		Name:       opListDirectories,
		HTTPMethod: "POST",
		HTTPPath:   "/amazonclouddirectory/2017-01-11/directory/list",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListDirectoriesInput{}
	}

	output = &ListDirectoriesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListDirectories API operation for Amazon CloudDirectory.
//
// Lists directories created within an account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudDirectory's
// API operation ListDirectories for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalServiceException "InternalServiceException"
//   Indicates a problem that must be resolved by Amazon Web Services. This might
//   be a transient error in which case you can retry your request until it succeeds.
//   Otherwise, go to the AWS Service Health Dashboard (http://status.aws.amazon.com/)
//   site to see if there are any operational issues with the service.
//
//   * ErrCodeInvalidArnException "InvalidArnException"
//   Indicates that the provided ARN value is not valid.
//
//   * ErrCodeRetryableConflictException "RetryableConflictException"
//   Occurs when a conflict with a previous successful write is detected. For
//   example, if a write operation occurs on an object and then an attempt is
//   made to read the object using “SERIALIZABLE” consistency, this exception
//   may result. This generally occurs when the previous write did not have time
//   to propagate to the host serving the current request. A retry (with appropriate
//   backoff logic) is the recommended response to this exception.
//
//   * ErrCodeValidationException "ValidationException"
//   Indicates that your request is malformed in some manner. See the exception
//   message.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   Indicates that limits are exceeded. See Limits (http://docs.aws.amazon.com/directoryservice/latest/admin-guide/limits.html)
//   for more information.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   Access denied. Check your permissions.
//
//   * ErrCodeInvalidNextTokenException "InvalidNextTokenException"
//   Indicates that the NextToken value is not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2016-05-10/ListDirectories
func (c *CloudDirectory) ListDirectories(input *ListDirectoriesInput) (*ListDirectoriesOutput, error) {
	req, out := c.ListDirectoriesRequest(input)
	return out, req.Send()
}

// ListDirectoriesWithContext is the same as ListDirectories with the addition of
// the ability to pass a context and additional request options.
//
// See ListDirectories for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudDirectory) ListDirectoriesWithContext(ctx aws.Context, input *ListDirectoriesInput, opts ...request.Option) (*ListDirectoriesOutput, error) {
	req, out := c.ListDirectoriesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListDirectoriesPages iterates over the pages of a ListDirectories operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListDirectories method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListDirectories operation.
//    pageNum := 0
//    err := client.ListDirectoriesPages(params,
//        func(page *ListDirectoriesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *CloudDirectory) ListDirectoriesPages(input *ListDirectoriesInput, fn func(*ListDirectoriesOutput, bool) bool) error {
	return c.ListDirectoriesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListDirectoriesPagesWithContext same as ListDirectoriesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudDirectory) ListDirectoriesPagesWithContext(ctx aws.Context, input *ListDirectoriesInput, fn func(*ListDirectoriesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListDirectoriesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListDirectoriesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*ListDirectoriesOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opListFacetAttributes = "ListFacetAttributes"

// ListFacetAttributesRequest generates a "aws/request.Request" representing the
// client's request for the ListFacetAttributes operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListFacetAttributes for more information on using the ListFacetAttributes
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListFacetAttributesRequest method.
//    req, resp := client.ListFacetAttributesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2016-05-10/ListFacetAttributes
func (c *CloudDirectory) ListFacetAttributesRequest(input *ListFacetAttributesInput) (req *request.Request, output *ListFacetAttributesOutput) {
	op := &request.Operation{
		Name:       opListFacetAttributes,
		HTTPMethod: "POST",
		HTTPPath:   "/amazonclouddirectory/2017-01-11/facet/attributes",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListFacetAttributesInput{}
	}

	output = &ListFacetAttributesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListFacetAttributes API operation for Amazon CloudDirectory.
//
// Retrieves attributes attached to the facet.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudDirectory's
// API operation ListFacetAttributes for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalServiceException "InternalServiceException"
//   Indicates a problem that must be resolved by Amazon Web Services. This might
//   be a transient error in which case you can retry your request until it succeeds.
//   Otherwise, go to the AWS Service Health Dashboard (http://status.aws.amazon.com/)
//   site to see if there are any operational issues with the service.
//
//   * ErrCodeInvalidArnException "InvalidArnException"
//   Indicates that the provided ARN value is not valid.
//
//   * ErrCodeRetryableConflictException "RetryableConflictException"
//   Occurs when a conflict with a previous successful write is detected. For
//   example, if a write operation occurs on an object and then an attempt is
//   made to read the object using “SERIALIZABLE” consistency, this exception
//   may result. This generally occurs when the previous write did not have time
//   to propagate to the host serving the current request. A retry (with appropriate
//   backoff logic) is the recommended response to this exception.
//
//   * ErrCodeValidationException "ValidationException"
//   Indicates that your request is malformed in some manner. See the exception
//   message.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   Indicates that limits are exceeded. See Limits (http://docs.aws.amazon.com/directoryservice/latest/admin-guide/limits.html)
//   for more information.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   Access denied. Check your permissions.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource could not be found.
//
//   * ErrCodeFacetNotFoundException "FacetNotFoundException"
//   The specified Facet could not be found.
//
//   * ErrCodeInvalidNextTokenException "InvalidNextTokenException"
//   Indicates that the NextToken value is not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2016-05-10/ListFacetAttributes
func (c *CloudDirectory) ListFacetAttributes(input *ListFacetAttributesInput) (*ListFacetAttributesOutput, error) {
	req, out := c.ListFacetAttributesRequest(input)
	return out, req.Send()
}

// ListFacetAttributesWithContext is the same as ListFacetAttributes with the addition of
// the ability to pass a context and additional request options.
//
// See ListFacetAttributes for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudDirectory) ListFacetAttributesWithContext(ctx aws.Context, input *ListFacetAttributesInput, opts ...request.Option) (*ListFacetAttributesOutput, error) {
	req, out := c.ListFacetAttributesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListFacetAttributesPages iterates over the pages of a ListFacetAttributes operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListFacetAttributes method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListFacetAttributes operation.
//    pageNum := 0
//    err := client.ListFacetAttributesPages(params,
//        func(page *ListFacetAttributesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *CloudDirectory) ListFacetAttributesPages(input *ListFacetAttributesInput, fn func(*ListFacetAttributesOutput, bool) bool) error {
	return c.ListFacetAttributesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListFacetAttributesPagesWithContext same as ListFacetAttributesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudDirectory) ListFacetAttributesPagesWithContext(ctx aws.Context, input *ListFacetAttributesInput, fn func(*ListFacetAttributesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListFacetAttributesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListFacetAttributesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*ListFacetAttributesOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opListFacetNames = "ListFacetNames"

// ListFacetNamesRequest generates a "aws/request.Request" representing the
// client's request for the ListFacetNames operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListFacetNames for more information on using the ListFacetNames
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListFacetNamesRequest method.
//    req, resp := client.ListFacetNamesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2016-05-10/ListFacetNames
func (c *CloudDirectory) ListFacetNamesRequest(input *ListFacetNamesInput) (req *request.Request, output *ListFacetNamesOutput) {
	op := &request.Operation{
		Name:       opListFacetNames,
		HTTPMethod: "POST",
		HTTPPath:   "/amazonclouddirectory/2017-01-11/facet/list",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListFacetNamesInput{}
	}

	output = &ListFacetNamesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListFacetNames API operation for Amazon CloudDirectory.
//
// Retrieves the names of facets that exist in a schema.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudDirectory's
// API operation ListFacetNames for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalServiceException "InternalServiceException"
//   Indicates a problem that must be resolved by Amazon Web Services. This might
//   be a transient error in which case you can retry your request until it succeeds.
//   Otherwise, go to the AWS Service Health Dashboard (http://status.aws.amazon.com/)
//   site to see if there are any operational issues with the service.
//
//   * ErrCodeInvalidArnException "InvalidArnException"
//   Indicates that the provided ARN value is not valid.
//
//   * ErrCodeRetryableConflictException "RetryableConflictException"
//   Occurs when a conflict with a previous successful write is detected. For
//   example, if a write operation occurs on an object and then an attempt is
//   made to read the object using “SERIALIZABLE” consistency, this exception
//   may result. This generally occurs when the previous write did not have time
//   to propagate to the host serving the current request. A retry (with appropriate
//   backoff logic) is the recommended response to this exception.
//
//   * ErrCodeValidationException "ValidationException"
//   Indicates that your request is malformed in some manner. See the exception
//   message.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   Indicates that limits are exceeded. See Limits (http://docs.aws.amazon.com/directoryservice/latest/admin-guide/limits.html)
//   for more information.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   Access denied. Check your permissions.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource could not be found.
//
//   * ErrCodeInvalidNextTokenException "InvalidNextTokenException"
//   Indicates that the NextToken value is not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2016-05-10/ListFacetNames
func (c *CloudDirectory) ListFacetNames(input *ListFacetNamesInput) (*ListFacetNamesOutput, error) {
	req, out := c.ListFacetNamesRequest(input)
	return out, req.Send()
}

// ListFacetNamesWithContext is the same as ListFacetNames with the addition of
// the ability to pass a context and additional request options.
//
// See ListFacetNames for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudDirectory) ListFacetNamesWithContext(ctx aws.Context, input *ListFacetNamesInput, opts ...request.Option) (*ListFacetNamesOutput, error) {
	req, out := c.ListFacetNamesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListFacetNamesPages iterates over the pages of a ListFacetNames operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListFacetNames method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListFacetNames operation.
//    pageNum := 0
//    err := client.ListFacetNamesPages(params,
//        func(page *ListFacetNamesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *CloudDirectory) ListFacetNamesPages(input *ListFacetNamesInput, fn func(*ListFacetNamesOutput, bool) bool) error {
	return c.ListFacetNamesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListFacetNamesPagesWithContext same as ListFacetNamesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudDirectory) ListFacetNamesPagesWithContext(ctx aws.Context, input *ListFacetNamesInput, fn func(*ListFacetNamesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListFacetNamesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListFacetNamesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*ListFacetNamesOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opListIncomingTypedLinks = "ListIncomingTypedLinks"

// ListIncomingTypedLinksRequest generates a "aws/request.Request" representing the
// client's request for the ListIncomingTypedLinks operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListIncomingTypedLinks for more information on using the ListIncomingTypedLinks
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListIncomingTypedLinksRequest method.
//    req, resp := client.ListIncomingTypedLinksRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2016-05-10/ListIncomingTypedLinks
func (c *CloudDirectory) ListIncomingTypedLinksRequest(input *ListIncomingTypedLinksInput) (req *request.Request, output *ListIncomingTypedLinksOutput) {
	op := &request.Operation{
		Name:       opListIncomingTypedLinks,
		HTTPMethod: "POST",
		HTTPPath:   "/amazonclouddirectory/2017-01-11/typedlink/incoming",
	}

	if input == nil {
		input = &ListIncomingTypedLinksInput{}
	}

	output = &ListIncomingTypedLinksOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListIncomingTypedLinks API operation for Amazon CloudDirectory.
//
// Returns a paginated list of all the incoming TypedLinkSpecifier information
// for an object. It also supports filtering by typed link facet and identity
// attributes. For more information, see Typed link (http://docs.aws.amazon.com/directoryservice/latest/admin-guide/objectsandlinks.html#typedlink).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudDirectory's
// API operation ListIncomingTypedLinks for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalServiceException "InternalServiceException"
//   Indicates a problem that must be resolved by Amazon Web Services. This might
//   be a transient error in which case you can retry your request until it succeeds.
//   Otherwise, go to the AWS Service Health Dashboard (http://status.aws.amazon.com/)
//   site to see if there are any operational issues with the service.
//
//   * ErrCodeInvalidArnException "InvalidArnException"
//   Indicates that the provided ARN value is not valid.
//
//   * ErrCodeRetryableConflictException "RetryableConflictException"
//   Occurs when a conflict with a previous successful write is detected. For
//   example, if a write operation occurs on an object and then an attempt is
//   made to read the object using “SERIALIZABLE” consistency, this exception
//   may result. This generally occurs when the previous write did not have time
//   to propagate to the host serving the current request. A retry (with appropriate
//   backoff logic) is the recommended response to this exception.
//
//   * ErrCodeValidationException "ValidationException"
//   Indicates that your request is malformed in some manner. See the exception
//   message.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   Indicates that limits are exceeded. See Limits (http://docs.aws.amazon.com/directoryservice/latest/admin-guide/limits.html)
//   for more information.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   Access denied. Check your permissions.
//
//   * ErrCodeDirectoryNotEnabledException "DirectoryNotEnabledException"
//   Operations are only permitted on enabled directories.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource could not be found.
//
//   * ErrCodeInvalidNextTokenException "InvalidNextTokenException"
//   Indicates that the NextToken value is not valid.
//
//   * ErrCodeFacetValidationException "FacetValidationException"
//   The Facet that you provided was not well formed or could not be validated
//   with the schema.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2016-05-10/ListIncomingTypedLinks
func (c *CloudDirectory) ListIncomingTypedLinks(input *ListIncomingTypedLinksInput) (*ListIncomingTypedLinksOutput, error) {
	req, out := c.ListIncomingTypedLinksRequest(input)
	return out, req.Send()
}

// ListIncomingTypedLinksWithContext is the same as ListIncomingTypedLinks with the addition of
// the ability to pass a context and additional request options.
//
// See ListIncomingTypedLinks for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudDirectory) ListIncomingTypedLinksWithContext(ctx aws.Context, input *ListIncomingTypedLinksInput, opts ...request.Option) (*ListIncomingTypedLinksOutput, error) {
	req, out := c.ListIncomingTypedLinksRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListIndex = "ListIndex"

// ListIndexRequest generates a "aws/request.Request" representing the
// client's request for the ListIndex operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListIndex for more information on using the ListIndex
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListIndexRequest method.
//    req, resp := client.ListIndexRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2016-05-10/ListIndex
func (c *CloudDirectory) ListIndexRequest(input *ListIndexInput) (req *request.Request, output *ListIndexOutput) {
	op := &request.Operation{
		Name:       opListIndex,
		HTTPMethod: "POST",
		HTTPPath:   "/amazonclouddirectory/2017-01-11/index/targets",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListIndexInput{}
	}

	output = &ListIndexOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListIndex API operation for Amazon CloudDirectory.
//
// Lists objects attached to the specified index.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudDirectory's
// API operation ListIndex for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalServiceException "InternalServiceException"
//   Indicates a problem that must be resolved by Amazon Web Services. This might
//   be a transient error in which case you can retry your request until it succeeds.
//   Otherwise, go to the AWS Service Health Dashboard (http://status.aws.amazon.com/)
//   site to see if there are any operational issues with the service.
//
//   * ErrCodeInvalidArnException "InvalidArnException"
//   Indicates that the provided ARN value is not valid.
//
//   * ErrCodeRetryableConflictException "RetryableConflictException"
//   Occurs when a conflict with a previous successful write is detected. For
//   example, if a write operation occurs on an object and then an attempt is
//   made to read the object using “SERIALIZABLE” consistency, this exception
//   may result. This generally occurs when the previous write did not have time
//   to propagate to the host serving the current request. A retry (with appropriate
//   backoff logic) is the recommended response to this exception.
//
//   * ErrCodeFacetValidationException "FacetValidationException"
//   The Facet that you provided was not well formed or could not be validated
//   with the schema.
//
//   * ErrCodeValidationException "ValidationException"
//   Indicates that your request is malformed in some manner. See the exception
//   message.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   Indicates that limits are exceeded. See Limits (http://docs.aws.amazon.com/directoryservice/latest/admin-guide/limits.html)
//   for more information.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   Access denied. Check your permissions.
//
//   * ErrCodeDirectoryNotEnabledException "DirectoryNotEnabledException"
//   Operations are only permitted on enabled directories.
//
//   * ErrCodeInvalidNextTokenException "InvalidNextTokenException"
//   Indicates that the NextToken value is not valid.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource could not be found.
//
//   * ErrCodeNotIndexException "NotIndexException"
//   Indicates that the requested operation can only operate on index objects.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2016-05-10/ListIndex
func (c *CloudDirectory) ListIndex(input *ListIndexInput) (*ListIndexOutput, error) {
	req, out := c.ListIndexRequest(input)
	return out, req.Send()
}

// ListIndexWithContext is the same as ListIndex with the addition of
// the ability to pass a context and additional request options.
//
// See ListIndex for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudDirectory) ListIndexWithContext(ctx aws.Context, input *ListIndexInput, opts ...request.Option) (*ListIndexOutput, error) {
	req, out := c.ListIndexRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListIndexPages iterates over the pages of a ListIndex operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListIndex method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListIndex operation.
//    pageNum := 0
//    err := client.ListIndexPages(params,
//        func(page *ListIndexOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *CloudDirectory) ListIndexPages(input *ListIndexInput, fn func(*ListIndexOutput, bool) bool) error {
	return c.ListIndexPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListIndexPagesWithContext same as ListIndexPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudDirectory) ListIndexPagesWithContext(ctx aws.Context, input *ListIndexInput, fn func(*ListIndexOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListIndexInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListIndexRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*ListIndexOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opListObjectAttributes = "ListObjectAttributes"

// ListObjectAttributesRequest generates a "aws/request.Request" representing the
// client's request for the ListObjectAttributes operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListObjectAttributes for more information on using the ListObjectAttributes
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListObjectAttributesRequest method.
//    req, resp := client.ListObjectAttributesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2016-05-10/ListObjectAttributes
func (c *CloudDirectory) ListObjectAttributesRequest(input *ListObjectAttributesInput) (req *request.Request, output *ListObjectAttributesOutput) {
	op := &request.Operation{
		Name:       opListObjectAttributes,
		HTTPMethod: "POST",
		HTTPPath:   "/amazonclouddirectory/2017-01-11/object/attributes",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListObjectAttributesInput{}
	}

	output = &ListObjectAttributesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListObjectAttributes API operation for Amazon CloudDirectory.
//
// Lists all attributes that are associated with an object.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudDirectory's
// API operation ListObjectAttributes for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalServiceException "InternalServiceException"
//   Indicates a problem that must be resolved by Amazon Web Services. This might
//   be a transient error in which case you can retry your request until it succeeds.
//   Otherwise, go to the AWS Service Health Dashboard (http://status.aws.amazon.com/)
//   site to see if there are any operational issues with the service.
//
//   * ErrCodeInvalidArnException "InvalidArnException"
//   Indicates that the provided ARN value is not valid.
//
//   * ErrCodeRetryableConflictException "RetryableConflictException"
//   Occurs when a conflict with a previous successful write is detected. For
//   example, if a write operation occurs on an object and then an attempt is
//   made to read the object using “SERIALIZABLE” consistency, this exception
//   may result. This generally occurs when the previous write did not have time
//   to propagate to the host serving the current request. A retry (with appropriate
//   backoff logic) is the recommended response to this exception.
//
//   * ErrCodeValidationException "ValidationException"
//   Indicates that your request is malformed in some manner. See the exception
//   message.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   Indicates that limits are exceeded. See Limits (http://docs.aws.amazon.com/directoryservice/latest/admin-guide/limits.html)
//   for more information.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   Access denied. Check your permissions.
//
//   * ErrCodeDirectoryNotEnabledException "DirectoryNotEnabledException"
//   Operations are only permitted on enabled directories.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource could not be found.
//
//   * ErrCodeInvalidNextTokenException "InvalidNextTokenException"
//   Indicates that the NextToken value is not valid.
//
//   * ErrCodeFacetValidationException "FacetValidationException"
//   The Facet that you provided was not well formed or could not be validated
//   with the schema.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2016-05-10/ListObjectAttributes
func (c *CloudDirectory) ListObjectAttributes(input *ListObjectAttributesInput) (*ListObjectAttributesOutput, error) {
	req, out := c.ListObjectAttributesRequest(input)
	return out, req.Send()
}

// ListObjectAttributesWithContext is the same as ListObjectAttributes with the addition of
// the ability to pass a context and additional request options.
//
// See ListObjectAttributes for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudDirectory) ListObjectAttributesWithContext(ctx aws.Context, input *ListObjectAttributesInput, opts ...request.Option) (*ListObjectAttributesOutput, error) {
	req, out := c.ListObjectAttributesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListObjectAttributesPages iterates over the pages of a ListObjectAttributes operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListObjectAttributes method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListObjectAttributes operation.
//    pageNum := 0
//    err := client.ListObjectAttributesPages(params,
//        func(page *ListObjectAttributesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *CloudDirectory) ListObjectAttributesPages(input *ListObjectAttributesInput, fn func(*ListObjectAttributesOutput, bool) bool) error {
	return c.ListObjectAttributesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListObjectAttributesPagesWithContext same as ListObjectAttributesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudDirectory) ListObjectAttributesPagesWithContext(ctx aws.Context, input *ListObjectAttributesInput, fn func(*ListObjectAttributesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListObjectAttributesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListObjectAttributesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*ListObjectAttributesOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opListObjectChildren = "ListObjectChildren"

// ListObjectChildrenRequest generates a "aws/request.Request" representing the
// client's request for the ListObjectChildren operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListObjectChildren for more information on using the ListObjectChildren
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListObjectChildrenRequest method.
//    req, resp := client.ListObjectChildrenRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2016-05-10/ListObjectChildren
func (c *CloudDirectory) ListObjectChildrenRequest(input *ListObjectChildrenInput) (req *request.Request, output *ListObjectChildrenOutput) {
	op := &request.Operation{
		Name:       opListObjectChildren,
		HTTPMethod: "POST",
		HTTPPath:   "/amazonclouddirectory/2017-01-11/object/children",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListObjectChildrenInput{}
	}

	output = &ListObjectChildrenOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListObjectChildren API operation for Amazon CloudDirectory.
//
// Returns a paginated list of child objects that are associated with a given
// object.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudDirectory's
// API operation ListObjectChildren for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalServiceException "InternalServiceException"
//   Indicates a problem that must be resolved by Amazon Web Services. This might
//   be a transient error in which case you can retry your request until it succeeds.
//   Otherwise, go to the AWS Service Health Dashboard (http://status.aws.amazon.com/)
//   site to see if there are any operational issues with the service.
//
//   * ErrCodeInvalidArnException "InvalidArnException"
//   Indicates that the provided ARN value is not valid.
//
//   * ErrCodeRetryableConflictException "RetryableConflictException"
//   Occurs when a conflict with a previous successful write is detected. For
//   example, if a write operation occurs on an object and then an attempt is
//   made to read the object using “SERIALIZABLE” consistency, this exception
//   may result. This generally occurs when the previous write did not have time
//   to propagate to the host serving the current request. A retry (with appropriate
//   backoff logic) is the recommended response to this exception.
//
//   * ErrCodeValidationException "ValidationException"
//   Indicates that your request is malformed in some manner. See the exception
//   message.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   Indicates that limits are exceeded. See Limits (http://docs.aws.amazon.com/directoryservice/latest/admin-guide/limits.html)
//   for more information.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   Access denied. Check your permissions.
//
//   * ErrCodeDirectoryNotEnabledException "DirectoryNotEnabledException"
//   Operations are only permitted on enabled directories.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource could not be found.
//
//   * ErrCodeInvalidNextTokenException "InvalidNextTokenException"
//   Indicates that the NextToken value is not valid.
//
//   * ErrCodeNotNodeException "NotNodeException"
//   Occurs when any invalid operations are performed on an object that is not
//   a node, such as calling ListObjectChildren for a leaf node object.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2016-05-10/ListObjectChildren
func (c *CloudDirectory) ListObjectChildren(input *ListObjectChildrenInput) (*ListObjectChildrenOutput, error) {
	req, out := c.ListObjectChildrenRequest(input)
	return out, req.Send()
}

// ListObjectChildrenWithContext is the same as ListObjectChildren with the addition of
// the ability to pass a context and additional request options.
//
// See ListObjectChildren for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudDirectory) ListObjectChildrenWithContext(ctx aws.Context, input *ListObjectChildrenInput, opts ...request.Option) (*ListObjectChildrenOutput, error) {
	req, out := c.ListObjectChildrenRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListObjectChildrenPages iterates over the pages of a ListObjectChildren operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListObjectChildren method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListObjectChildren operation.
//    pageNum := 0
//    err := client.ListObjectChildrenPages(params,
//        func(page *ListObjectChildrenOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *CloudDirectory) ListObjectChildrenPages(input *ListObjectChildrenInput, fn func(*ListObjectChildrenOutput, bool) bool) error {
	return c.ListObjectChildrenPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListObjectChildrenPagesWithContext same as ListObjectChildrenPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudDirectory) ListObjectChildrenPagesWithContext(ctx aws.Context, input *ListObjectChildrenInput, fn func(*ListObjectChildrenOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListObjectChildrenInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListObjectChildrenRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*ListObjectChildrenOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opListObjectParentPaths = "ListObjectParentPaths"

// ListObjectParentPathsRequest generates a "aws/request.Request" representing the
// client's request for the ListObjectParentPaths operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListObjectParentPaths for more information on using the ListObjectParentPaths
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListObjectParentPathsRequest method.
//    req, resp := client.ListObjectParentPathsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2016-05-10/ListObjectParentPaths
func (c *CloudDirectory) ListObjectParentPathsRequest(input *ListObjectParentPathsInput) (req *request.Request, output *ListObjectParentPathsOutput) {
	op := &request.Operation{
		Name:       opListObjectParentPaths,
		HTTPMethod: "POST",
		HTTPPath:   "/amazonclouddirectory/2017-01-11/object/parentpaths",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListObjectParentPathsInput{}
	}

	output = &ListObjectParentPathsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListObjectParentPaths API operation for Amazon CloudDirectory.
//
// Retrieves all available parent paths for any object type such as node, leaf
// node, policy node, and index node objects. For more information about objects,
// see Directory Structure (http://docs.aws.amazon.com/directoryservice/latest/admin-guide/cd_key_concepts.html#dirstructure).
//
// Use this API to evaluate all parents for an object. The call returns all
// objects from the root of the directory up to the requested object. The API
// returns the number of paths based on user-defined MaxResults, in case there
// are multiple paths to the parent. The order of the paths and nodes returned
// is consistent among multiple API calls unless the objects are deleted or
// moved. Paths not leading to the directory root are ignored from the target
// object.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudDirectory's
// API operation ListObjectParentPaths for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalServiceException "InternalServiceException"
//   Indicates a problem that must be resolved by Amazon Web Services. This might
//   be a transient error in which case you can retry your request until it succeeds.
//   Otherwise, go to the AWS Service Health Dashboard (http://status.aws.amazon.com/)
//   site to see if there are any operational issues with the service.
//
//   * ErrCodeInvalidArnException "InvalidArnException"
//   Indicates that the provided ARN value is not valid.
//
//   * ErrCodeRetryableConflictException "RetryableConflictException"
//   Occurs when a conflict with a previous successful write is detected. For
//   example, if a write operation occurs on an object and then an attempt is
//   made to read the object using “SERIALIZABLE” consistency, this exception
//   may result. This generally occurs when the previous write did not have time
//   to propagate to the host serving the current request. A retry (with appropriate
//   backoff logic) is the recommended response to this exception.
//
//   * ErrCodeValidationException "ValidationException"
//   Indicates that your request is malformed in some manner. See the exception
//   message.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   Indicates that limits are exceeded. See Limits (http://docs.aws.amazon.com/directoryservice/latest/admin-guide/limits.html)
//   for more information.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   Access denied. Check your permissions.
//
//   * ErrCodeDirectoryNotEnabledException "DirectoryNotEnabledException"
//   Operations are only permitted on enabled directories.
//
//   * ErrCodeInvalidNextTokenException "InvalidNextTokenException"
//   Indicates that the NextToken value is not valid.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource could not be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2016-05-10/ListObjectParentPaths
func (c *CloudDirectory) ListObjectParentPaths(input *ListObjectParentPathsInput) (*ListObjectParentPathsOutput, error) {
	req, out := c.ListObjectParentPathsRequest(input)
	return out, req.Send()
}

// ListObjectParentPathsWithContext is the same as ListObjectParentPaths with the addition of
// the ability to pass a context and additional request options.
//
// See ListObjectParentPaths for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudDirectory) ListObjectParentPathsWithContext(ctx aws.Context, input *ListObjectParentPathsInput, opts ...request.Option) (*ListObjectParentPathsOutput, error) {
	req, out := c.ListObjectParentPathsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListObjectParentPathsPages iterates over the pages of a ListObjectParentPaths operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListObjectParentPaths method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListObjectParentPaths operation.
//    pageNum := 0
//    err := client.ListObjectParentPathsPages(params,
//        func(page *ListObjectParentPathsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *CloudDirectory) ListObjectParentPathsPages(input *ListObjectParentPathsInput, fn func(*ListObjectParentPathsOutput, bool) bool) error {
	return c.ListObjectParentPathsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListObjectParentPathsPagesWithContext same as ListObjectParentPathsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudDirectory) ListObjectParentPathsPagesWithContext(ctx aws.Context, input *ListObjectParentPathsInput, fn func(*ListObjectParentPathsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListObjectParentPathsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListObjectParentPathsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*ListObjectParentPathsOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opListObjectParents = "ListObjectParents"

// ListObjectParentsRequest generates a "aws/request.Request" representing the
// client's request for the ListObjectParents operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListObjectParents for more information on using the ListObjectParents
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListObjectParentsRequest method.
//    req, resp := client.ListObjectParentsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2016-05-10/ListObjectParents
func (c *CloudDirectory) ListObjectParentsRequest(input *ListObjectParentsInput) (req *request.Request, output *ListObjectParentsOutput) {
	op := &request.Operation{
		Name:       opListObjectParents,
		HTTPMethod: "POST",
		HTTPPath:   "/amazonclouddirectory/2017-01-11/object/parent",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListObjectParentsInput{}
	}

	output = &ListObjectParentsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListObjectParents API operation for Amazon CloudDirectory.
//
// Lists parent objects that are associated with a given object in pagination
// fashion.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudDirectory's
// API operation ListObjectParents for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalServiceException "InternalServiceException"
//   Indicates a problem that must be resolved by Amazon Web Services. This might
//   be a transient error in which case you can retry your request until it succeeds.
//   Otherwise, go to the AWS Service Health Dashboard (http://status.aws.amazon.com/)
//   site to see if there are any operational issues with the service.
//
//   * ErrCodeInvalidArnException "InvalidArnException"
//   Indicates that the provided ARN value is not valid.
//
//   * ErrCodeRetryableConflictException "RetryableConflictException"
//   Occurs when a conflict with a previous successful write is detected. For
//   example, if a write operation occurs on an object and then an attempt is
//   made to read the object using “SERIALIZABLE” consistency, this exception
//   may result. This generally occurs when the previous write did not have time
//   to propagate to the host serving the current request. A retry (with appropriate
//   backoff logic) is the recommended response to this exception.
//
//   * ErrCodeValidationException "ValidationException"
//   Indicates that your request is malformed in some manner. See the exception
//   message.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   Indicates that limits are exceeded. See Limits (http://docs.aws.amazon.com/directoryservice/latest/admin-guide/limits.html)
//   for more information.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   Access denied. Check your permissions.
//
//   * ErrCodeDirectoryNotEnabledException "DirectoryNotEnabledException"
//   Operations are only permitted on enabled directories.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource could not be found.
//
//   * ErrCodeInvalidNextTokenException "InvalidNextTokenException"
//   Indicates that the NextToken value is not valid.
//
//   * ErrCodeCannotListParentOfRootException "CannotListParentOfRootException"
//   Cannot list the parents of a Directory root.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2016-05-10/ListObjectParents
func (c *CloudDirectory) ListObjectParents(input *ListObjectParentsInput) (*ListObjectParentsOutput, error) {
	req, out := c.ListObjectParentsRequest(input)
	return out, req.Send()
}

// ListObjectParentsWithContext is the same as ListObjectParents with the addition of
// the ability to pass a context and additional request options.
//
// See ListObjectParents for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudDirectory) ListObjectParentsWithContext(ctx aws.Context, input *ListObjectParentsInput, opts ...request.Option) (*ListObjectParentsOutput, error) {
	req, out := c.ListObjectParentsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListObjectParentsPages iterates over the pages of a ListObjectParents operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListObjectParents method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListObjectParents operation.
//    pageNum := 0
//    err := client.ListObjectParentsPages(params,
//        func(page *ListObjectParentsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *CloudDirectory) ListObjectParentsPages(input *ListObjectParentsInput, fn func(*ListObjectParentsOutput, bool) bool) error {
	return c.ListObjectParentsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListObjectParentsPagesWithContext same as ListObjectParentsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudDirectory) ListObjectParentsPagesWithContext(ctx aws.Context, input *ListObjectParentsInput, fn func(*ListObjectParentsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListObjectParentsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListObjectParentsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*ListObjectParentsOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opListObjectPolicies = "ListObjectPolicies"

// ListObjectPoliciesRequest generates a "aws/request.Request" representing the
// client's request for the ListObjectPolicies operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListObjectPolicies for more information on using the ListObjectPolicies
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListObjectPoliciesRequest method.
//    req, resp := client.ListObjectPoliciesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2016-05-10/ListObjectPolicies
func (c *CloudDirectory) ListObjectPoliciesRequest(input *ListObjectPoliciesInput) (req *request.Request, output *ListObjectPoliciesOutput) {
	op := &request.Operation{
		Name:       opListObjectPolicies,
		HTTPMethod: "POST",
		HTTPPath:   "/amazonclouddirectory/2017-01-11/object/policy",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListObjectPoliciesInput{}
	}

	output = &ListObjectPoliciesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListObjectPolicies API operation for Amazon CloudDirectory.
//
// Returns policies attached to an object in pagination fashion.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudDirectory's
// API operation ListObjectPolicies for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalServiceException "InternalServiceException"
//   Indicates a problem that must be resolved by Amazon Web Services. This might
//   be a transient error in which case you can retry your request until it succeeds.
//   Otherwise, go to the AWS Service Health Dashboard (http://status.aws.amazon.com/)
//   site to see if there are any operational issues with the service.
//
//   * ErrCodeInvalidArnException "InvalidArnException"
//   Indicates that the provided ARN value is not valid.
//
//   * ErrCodeRetryableConflictException "RetryableConflictException"
//   Occurs when a conflict with a previous successful write is detected. For
//   example, if a write operation occurs on an object and then an attempt is
//   made to read the object using “SERIALIZABLE” consistency, this exception
//   may result. This generally occurs when the previous write did not have time
//   to propagate to the host serving the current request. A retry (with appropriate
//   backoff logic) is the recommended response to this exception.
//
//   * ErrCodeValidationException "ValidationException"
//   Indicates that your request is malformed in some manner. See the exception
//   message.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   Indicates that limits are exceeded. See Limits (http://docs.aws.amazon.com/directoryservice/latest/admin-guide/limits.html)
//   for more information.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   Access denied. Check your permissions.
//
//   * ErrCodeDirectoryNotEnabledException "DirectoryNotEnabledException"
//   Operations are only permitted on enabled directories.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource could not be found.
//
//   * ErrCodeInvalidNextTokenException "InvalidNextTokenException"
//   Indicates that the NextToken value is not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2016-05-10/ListObjectPolicies
func (c *CloudDirectory) ListObjectPolicies(input *ListObjectPoliciesInput) (*ListObjectPoliciesOutput, error) {
	req, out := c.ListObjectPoliciesRequest(input)
	return out, req.Send()
}

// ListObjectPoliciesWithContext is the same as ListObjectPolicies with the addition of
// the ability to pass a context and additional request options.
//
// See ListObjectPolicies for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudDirectory) ListObjectPoliciesWithContext(ctx aws.Context, input *ListObjectPoliciesInput, opts ...request.Option) (*ListObjectPoliciesOutput, error) {
	req, out := c.ListObjectPoliciesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListObjectPoliciesPages iterates over the pages of a ListObjectPolicies operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListObjectPolicies method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListObjectPolicies operation.
//    pageNum := 0
//    err := client.ListObjectPoliciesPages(params,
//        func(page *ListObjectPoliciesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *CloudDirectory) ListObjectPoliciesPages(input *ListObjectPoliciesInput, fn func(*ListObjectPoliciesOutput, bool) bool) error {
	return c.ListObjectPoliciesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListObjectPoliciesPagesWithContext same as ListObjectPoliciesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudDirectory) ListObjectPoliciesPagesWithContext(ctx aws.Context, input *ListObjectPoliciesInput, fn func(*ListObjectPoliciesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListObjectPoliciesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListObjectPoliciesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*ListObjectPoliciesOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opListOutgoingTypedLinks = "ListOutgoingTypedLinks"

// ListOutgoingTypedLinksRequest generates a "aws/request.Request" representing the
// client's request for the ListOutgoingTypedLinks operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListOutgoingTypedLinks for more information on using the ListOutgoingTypedLinks
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListOutgoingTypedLinksRequest method.
//    req, resp := client.ListOutgoingTypedLinksRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2016-05-10/ListOutgoingTypedLinks
func (c *CloudDirectory) ListOutgoingTypedLinksRequest(input *ListOutgoingTypedLinksInput) (req *request.Request, output *ListOutgoingTypedLinksOutput) {
	op := &request.Operation{
		Name:       opListOutgoingTypedLinks,
		HTTPMethod: "POST",
		HTTPPath:   "/amazonclouddirectory/2017-01-11/typedlink/outgoing",
	}

	if input == nil {
		input = &ListOutgoingTypedLinksInput{}
	}

	output = &ListOutgoingTypedLinksOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListOutgoingTypedLinks API operation for Amazon CloudDirectory.
//
// Returns a paginated list of all the outgoing TypedLinkSpecifier information
// for an object. It also supports filtering by typed link facet and identity
// attributes. For more information, see Typed link (http://docs.aws.amazon.com/directoryservice/latest/admin-guide/objectsandlinks.html#typedlink).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudDirectory's
// API operation ListOutgoingTypedLinks for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalServiceException "InternalServiceException"
//   Indicates a problem that must be resolved by Amazon Web Services. This might
//   be a transient error in which case you can retry your request until it succeeds.
//   Otherwise, go to the AWS Service Health Dashboard (http://status.aws.amazon.com/)
//   site to see if there are any operational issues with the service.
//
//   * ErrCodeInvalidArnException "InvalidArnException"
//   Indicates that the provided ARN value is not valid.
//
//   * ErrCodeRetryableConflictException "RetryableConflictException"
//   Occurs when a conflict with a previous successful write is detected. For
//   example, if a write operation occurs on an object and then an attempt is
//   made to read the object using “SERIALIZABLE” consistency, this exception
//   may result. This generally occurs when the previous write did not have time
//   to propagate to the host serving the current request. A retry (with appropriate
//   backoff logic) is the recommended response to this exception.
//
//   * ErrCodeValidationException "ValidationException"
//   Indicates that your request is malformed in some manner. See the exception
//   message.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   Indicates that limits are exceeded. See Limits (http://docs.aws.amazon.com/directoryservice/latest/admin-guide/limits.html)
//   for more information.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   Access denied. Check your permissions.
//
//   * ErrCodeDirectoryNotEnabledException "DirectoryNotEnabledException"
//   Operations are only permitted on enabled directories.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource could not be found.
//
//   * ErrCodeInvalidNextTokenException "InvalidNextTokenException"
//   Indicates that the NextToken value is not valid.
//
//   * ErrCodeFacetValidationException "FacetValidationException"
//   The Facet that you provided was not well formed or could not be validated
//   with the schema.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2016-05-10/ListOutgoingTypedLinks
func (c *CloudDirectory) ListOutgoingTypedLinks(input *ListOutgoingTypedLinksInput) (*ListOutgoingTypedLinksOutput, error) {
	req, out := c.ListOutgoingTypedLinksRequest(input)
	return out, req.Send()
}

// ListOutgoingTypedLinksWithContext is the same as ListOutgoingTypedLinks with the addition of
// the ability to pass a context and additional request options.
//
// See ListOutgoingTypedLinks for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudDirectory) ListOutgoingTypedLinksWithContext(ctx aws.Context, input *ListOutgoingTypedLinksInput, opts ...request.Option) (*ListOutgoingTypedLinksOutput, error) {
	req, out := c.ListOutgoingTypedLinksRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListPolicyAttachments = "ListPolicyAttachments"

// ListPolicyAttachmentsRequest generates a "aws/request.Request" representing the
// client's request for the ListPolicyAttachments operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListPolicyAttachments for more information on using the ListPolicyAttachments
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListPolicyAttachmentsRequest method.
//    req, resp := client.ListPolicyAttachmentsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2016-05-10/ListPolicyAttachments
func (c *CloudDirectory) ListPolicyAttachmentsRequest(input *ListPolicyAttachmentsInput) (req *request.Request, output *ListPolicyAttachmentsOutput) {
	op := &request.Operation{
		Name:       opListPolicyAttachments,
		HTTPMethod: "POST",
		HTTPPath:   "/amazonclouddirectory/2017-01-11/policy/attachment",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListPolicyAttachmentsInput{}
	}

	output = &ListPolicyAttachmentsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListPolicyAttachments API operation for Amazon CloudDirectory.
//
// Returns all of the ObjectIdentifiers to which a given policy is attached.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudDirectory's
// API operation ListPolicyAttachments for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalServiceException "InternalServiceException"
//   Indicates a problem that must be resolved by Amazon Web Services. This might
//   be a transient error in which case you can retry your request until it succeeds.
//   Otherwise, go to the AWS Service Health Dashboard (http://status.aws.amazon.com/)
//   site to see if there are any operational issues with the service.
//
//   * ErrCodeInvalidArnException "InvalidArnException"
//   Indicates that the provided ARN value is not valid.
//
//   * ErrCodeRetryableConflictException "RetryableConflictException"
//   Occurs when a conflict with a previous successful write is detected. For
//   example, if a write operation occurs on an object and then an attempt is
//   made to read the object using “SERIALIZABLE” consistency, this exception
//   may result. This generally occurs when the previous write did not have time
//   to propagate to the host serving the current request. A retry (with appropriate
//   backoff logic) is the recommended response to this exception.
//
//   * ErrCodeValidationException "ValidationException"
//   Indicates that your request is malformed in some manner. See the exception
//   message.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   Indicates that limits are exceeded. See Limits (http://docs.aws.amazon.com/directoryservice/latest/admin-guide/limits.html)
//   for more information.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   Access denied. Check your permissions.
//
//   * ErrCodeDirectoryNotEnabledException "DirectoryNotEnabledException"
//   Operations are only permitted on enabled directories.
//
//   * ErrCodeInvalidNextTokenException "InvalidNextTokenException"
//   Indicates that the NextToken value is not valid.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource could not be found.
//
//   * ErrCodeNotPolicyException "NotPolicyException"
//   Indicates that the requested operation can only operate on policy objects.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2016-05-10/ListPolicyAttachments
func (c *CloudDirectory) ListPolicyAttachments(input *ListPolicyAttachmentsInput) (*ListPolicyAttachmentsOutput, error) {
	req, out := c.ListPolicyAttachmentsRequest(input)
	return out, req.Send()
}

// ListPolicyAttachmentsWithContext is the same as ListPolicyAttachments with the addition of
// the ability to pass a context and additional request options.
//
// See ListPolicyAttachments for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudDirectory) ListPolicyAttachmentsWithContext(ctx aws.Context, input *ListPolicyAttachmentsInput, opts ...request.Option) (*ListPolicyAttachmentsOutput, error) {
	req, out := c.ListPolicyAttachmentsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListPolicyAttachmentsPages iterates over the pages of a ListPolicyAttachments operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListPolicyAttachments method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListPolicyAttachments operation.
//    pageNum := 0
//    err := client.ListPolicyAttachmentsPages(params,
//        func(page *ListPolicyAttachmentsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *CloudDirectory) ListPolicyAttachmentsPages(input *ListPolicyAttachmentsInput, fn func(*ListPolicyAttachmentsOutput, bool) bool) error {
	return c.ListPolicyAttachmentsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListPolicyAttachmentsPagesWithContext same as ListPolicyAttachmentsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudDirectory) ListPolicyAttachmentsPagesWithContext(ctx aws.Context, input *ListPolicyAttachmentsInput, fn func(*ListPolicyAttachmentsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListPolicyAttachmentsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListPolicyAttachmentsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*ListPolicyAttachmentsOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opListPublishedSchemaArns = "ListPublishedSchemaArns"

// ListPublishedSchemaArnsRequest generates a "aws/request.Request" representing the
// client's request for the ListPublishedSchemaArns operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListPublishedSchemaArns for more information on using the ListPublishedSchemaArns
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListPublishedSchemaArnsRequest method.
//    req, resp := client.ListPublishedSchemaArnsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2016-05-10/ListPublishedSchemaArns
func (c *CloudDirectory) ListPublishedSchemaArnsRequest(input *ListPublishedSchemaArnsInput) (req *request.Request, output *ListPublishedSchemaArnsOutput) {
	op := &request.Operation{
		Name:       opListPublishedSchemaArns,
		HTTPMethod: "POST",
		HTTPPath:   "/amazonclouddirectory/2017-01-11/schema/published",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListPublishedSchemaArnsInput{}
	}

	output = &ListPublishedSchemaArnsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListPublishedSchemaArns API operation for Amazon CloudDirectory.
//
// Lists the major version families of each published schema. If a major version
// ARN is provided as SchemaArn, the minor version revisions in that family
// are listed instead.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudDirectory's
// API operation ListPublishedSchemaArns for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalServiceException "InternalServiceException"
//   Indicates a problem that must be resolved by Amazon Web Services. This might
//   be a transient error in which case you can retry your request until it succeeds.
//   Otherwise, go to the AWS Service Health Dashboard (http://status.aws.amazon.com/)
//   site to see if there are any operational issues with the service.
//
//   * ErrCodeInvalidArnException "InvalidArnException"
//   Indicates that the provided ARN value is not valid.
//
//   * ErrCodeRetryableConflictException "RetryableConflictException"
//   Occurs when a conflict with a previous successful write is detected. For
//   example, if a write operation occurs on an object and then an attempt is
//   made to read the object using “SERIALIZABLE” consistency, this exception
//   may result. This generally occurs when the previous write did not have time
//   to propagate to the host serving the current request. A retry (with appropriate
//   backoff logic) is the recommended response to this exception.
//
//   * ErrCodeValidationException "ValidationException"
//   Indicates that your request is malformed in some manner. See the exception
//   message.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   Indicates that limits are exceeded. See Limits (http://docs.aws.amazon.com/directoryservice/latest/admin-guide/limits.html)
//   for more information.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   Access denied. Check your permissions.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource could not be found.
//
//   * ErrCodeInvalidNextTokenException "InvalidNextTokenException"
//   Indicates that the NextToken value is not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2016-05-10/ListPublishedSchemaArns
func (c *CloudDirectory) ListPublishedSchemaArns(input *ListPublishedSchemaArnsInput) (*ListPublishedSchemaArnsOutput, error) {
	req, out := c.ListPublishedSchemaArnsRequest(input)
	return out, req.Send()
}

// ListPublishedSchemaArnsWithContext is the same as ListPublishedSchemaArns with the addition of
// the ability to pass a context and additional request options.
//
// See ListPublishedSchemaArns for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudDirectory) ListPublishedSchemaArnsWithContext(ctx aws.Context, input *ListPublishedSchemaArnsInput, opts ...request.Option) (*ListPublishedSchemaArnsOutput, error) {
	req, out := c.ListPublishedSchemaArnsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListPublishedSchemaArnsPages iterates over the pages of a ListPublishedSchemaArns operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListPublishedSchemaArns method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListPublishedSchemaArns operation.
//    pageNum := 0
//    err := client.ListPublishedSchemaArnsPages(params,
//        func(page *ListPublishedSchemaArnsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *CloudDirectory) ListPublishedSchemaArnsPages(input *ListPublishedSchemaArnsInput, fn func(*ListPublishedSchemaArnsOutput, bool) bool) error {
	return c.ListPublishedSchemaArnsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListPublishedSchemaArnsPagesWithContext same as ListPublishedSchemaArnsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudDirectory) ListPublishedSchemaArnsPagesWithContext(ctx aws.Context, input *ListPublishedSchemaArnsInput, fn func(*ListPublishedSchemaArnsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListPublishedSchemaArnsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListPublishedSchemaArnsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*ListPublishedSchemaArnsOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListTagsForResourceRequest method.
//    req, resp := client.ListTagsForResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2016-05-10/ListTagsForResource
func (c *CloudDirectory) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "POST",
		HTTPPath:   "/amazonclouddirectory/2017-01-11/tags",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for Amazon CloudDirectory.
//
// Returns tags for a resource. Tagging is currently supported only for directories
// with a limit of 50 tags per directory. All 50 tags are returned for a given
// directory with this API call.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudDirectory's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalServiceException "InternalServiceException"
//   Indicates a problem that must be resolved by Amazon Web Services. This might
//   be a transient error in which case you can retry your request until it succeeds.
//   Otherwise, go to the AWS Service Health Dashboard (http://status.aws.amazon.com/)
//   site to see if there are any operational issues with the service.
//
//   * ErrCodeInvalidArnException "InvalidArnException"
//   Indicates that the provided ARN value is not valid.
//
//   * ErrCodeRetryableConflictException "RetryableConflictException"
//   Occurs when a conflict with a previous successful write is detected. For
//   example, if a write operation occurs on an object and then an attempt is
//   made to read the object using “SERIALIZABLE” consistency, this exception
//   may result. This generally occurs when the previous write did not have time
//   to propagate to the host serving the current request. A retry (with appropriate
//   backoff logic) is the recommended response to this exception.
//
//   * ErrCodeValidationException "ValidationException"
//   Indicates that your request is malformed in some manner. See the exception
//   message.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   Indicates that limits are exceeded. See Limits (http://docs.aws.amazon.com/directoryservice/latest/admin-guide/limits.html)
//   for more information.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   Access denied. Check your permissions.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource could not be found.
//
//   * ErrCodeInvalidTaggingRequestException "InvalidTaggingRequestException"
//   Can occur for multiple reasons such as when you tag a resource that doesn’t
//   exist or if you specify a higher number of tags for a resource than the allowed
//   limit. Allowed limit is 50 tags per resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2016-05-10/ListTagsForResource
func (c *CloudDirectory) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudDirectory) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListTagsForResourcePages iterates over the pages of a ListTagsForResource operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListTagsForResource method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListTagsForResource operation.
//    pageNum := 0
//    err := client.ListTagsForResourcePages(params,
//        func(page *ListTagsForResourceOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *CloudDirectory) ListTagsForResourcePages(input *ListTagsForResourceInput, fn func(*ListTagsForResourceOutput, bool) bool) error {
	return c.ListTagsForResourcePagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListTagsForResourcePagesWithContext same as ListTagsForResourcePages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudDirectory) ListTagsForResourcePagesWithContext(ctx aws.Context, input *ListTagsForResourceInput, fn func(*ListTagsForResourceOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListTagsForResourceInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListTagsForResourceRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*ListTagsForResourceOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opListTypedLinkFacetAttributes = "ListTypedLinkFacetAttributes"

// ListTypedLinkFacetAttributesRequest generates a "aws/request.Request" representing the
// client's request for the ListTypedLinkFacetAttributes operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTypedLinkFacetAttributes for more information on using the ListTypedLinkFacetAttributes
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListTypedLinkFacetAttributesRequest method.
//    req, resp := client.ListTypedLinkFacetAttributesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2016-05-10/ListTypedLinkFacetAttributes
func (c *CloudDirectory) ListTypedLinkFacetAttributesRequest(input *ListTypedLinkFacetAttributesInput) (req *request.Request, output *ListTypedLinkFacetAttributesOutput) {
	op := &request.Operation{
		Name:       opListTypedLinkFacetAttributes,
		HTTPMethod: "POST",
		HTTPPath:   "/amazonclouddirectory/2017-01-11/typedlink/facet/attributes",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListTypedLinkFacetAttributesInput{}
	}

	output = &ListTypedLinkFacetAttributesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTypedLinkFacetAttributes API operation for Amazon CloudDirectory.
//
// Returns a paginated list of all attribute definitions for a particular TypedLinkFacet.
// For more information, see Typed link (http://docs.aws.amazon.com/directoryservice/latest/admin-guide/objectsandlinks.html#typedlink).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudDirectory's
// API operation ListTypedLinkFacetAttributes for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalServiceException "InternalServiceException"
//   Indicates a problem that must be resolved by Amazon Web Services. This might
//   be a transient error in which case you can retry your request until it succeeds.
//   Otherwise, go to the AWS Service Health Dashboard (http://status.aws.amazon.com/)
//   site to see if there are any operational issues with the service.
//
//   * ErrCodeInvalidArnException "InvalidArnException"
//   Indicates that the provided ARN value is not valid.
//
//   * ErrCodeRetryableConflictException "RetryableConflictException"
//   Occurs when a conflict with a previous successful write is detected. For
//   example, if a write operation occurs on an object and then an attempt is
//   made to read the object using “SERIALIZABLE” consistency, this exception
//   may result. This generally occurs when the previous write did not have time
//   to propagate to the host serving the current request. A retry (with appropriate
//   backoff logic) is the recommended response to this exception.
//
//   * ErrCodeValidationException "ValidationException"
//   Indicates that your request is malformed in some manner. See the exception
//   message.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   Indicates that limits are exceeded. See Limits (http://docs.aws.amazon.com/directoryservice/latest/admin-guide/limits.html)
//   for more information.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   Access denied. Check your permissions.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource could not be found.
//
//   * ErrCodeFacetNotFoundException "FacetNotFoundException"
//   The specified Facet could not be found.
//
//   * ErrCodeInvalidNextTokenException "InvalidNextTokenException"
//   Indicates that the NextToken value is not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2016-05-10/ListTypedLinkFacetAttributes
func (c *CloudDirectory) ListTypedLinkFacetAttributes(input *ListTypedLinkFacetAttributesInput) (*ListTypedLinkFacetAttributesOutput, error) {
	req, out := c.ListTypedLinkFacetAttributesRequest(input)
	return out, req.Send()
}

// ListTypedLinkFacetAttributesWithContext is the same as ListTypedLinkFacetAttributes with the addition of
// the ability to pass a context and additional request options.
//
// See ListTypedLinkFacetAttributes for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudDirectory) ListTypedLinkFacetAttributesWithContext(ctx aws.Context, input *ListTypedLinkFacetAttributesInput, opts ...request.Option) (*ListTypedLinkFacetAttributesOutput, error) {
	req, out := c.ListTypedLinkFacetAttributesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListTypedLinkFacetAttributesPages iterates over the pages of a ListTypedLinkFacetAttributes operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListTypedLinkFacetAttributes method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListTypedLinkFacetAttributes operation.
//    pageNum := 0
//    err := client.ListTypedLinkFacetAttributesPages(params,
//        func(page *ListTypedLinkFacetAttributesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *CloudDirectory) ListTypedLinkFacetAttributesPages(input *ListTypedLinkFacetAttributesInput, fn func(*ListTypedLinkFacetAttributesOutput, bool) bool) error {
	return c.ListTypedLinkFacetAttributesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListTypedLinkFacetAttributesPagesWithContext same as ListTypedLinkFacetAttributesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudDirectory) ListTypedLinkFacetAttributesPagesWithContext(ctx aws.Context, input *ListTypedLinkFacetAttributesInput, fn func(*ListTypedLinkFacetAttributesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListTypedLinkFacetAttributesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListTypedLinkFacetAttributesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*ListTypedLinkFacetAttributesOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opListTypedLinkFacetNames = "ListTypedLinkFacetNames"

// ListTypedLinkFacetNamesRequest generates a "aws/request.Request" representing the
// client's request for the ListTypedLinkFacetNames operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTypedLinkFacetNames for more information on using the ListTypedLinkFacetNames
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListTypedLinkFacetNamesRequest method.
//    req, resp := client.ListTypedLinkFacetNamesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2016-05-10/ListTypedLinkFacetNames
func (c *CloudDirectory) ListTypedLinkFacetNamesRequest(input *ListTypedLinkFacetNamesInput) (req *request.Request, output *ListTypedLinkFacetNamesOutput) {
	op := &request.Operation{
		Name:       opListTypedLinkFacetNames,
		HTTPMethod: "POST",
		HTTPPath:   "/amazonclouddirectory/2017-01-11/typedlink/facet/list",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListTypedLinkFacetNamesInput{}
	}

	output = &ListTypedLinkFacetNamesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTypedLinkFacetNames API operation for Amazon CloudDirectory.
//
// Returns a paginated list of TypedLink facet names for a particular schema.
// For more information, see Typed link (http://docs.aws.amazon.com/directoryservice/latest/admin-guide/objectsandlinks.html#typedlink).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudDirectory's
// API operation ListTypedLinkFacetNames for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalServiceException "InternalServiceException"
//   Indicates a problem that must be resolved by Amazon Web Services. This might
//   be a transient error in which case you can retry your request until it succeeds.
//   Otherwise, go to the AWS Service Health Dashboard (http://status.aws.amazon.com/)
//   site to see if there are any operational issues with the service.
//
//   * ErrCodeInvalidArnException "InvalidArnException"
//   Indicates that the provided ARN value is not valid.
//
//   * ErrCodeRetryableConflictException "RetryableConflictException"
//   Occurs when a conflict with a previous successful write is detected. For
//   example, if a write operation occurs on an object and then an attempt is
//   made to read the object using “SERIALIZABLE” consistency, this exception
//   may result. This generally occurs when the previous write did not have time
//   to propagate to the host serving the current request. A retry (with appropriate
//   backoff logic) is the recommended response to this exception.
//
//   * ErrCodeValidationException "ValidationException"
//   Indicates that your request is malformed in some manner. See the exception
//   message.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   Indicates that limits are exceeded. See Limits (http://docs.aws.amazon.com/directoryservice/latest/admin-guide/limits.html)
//   for more information.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   Access denied. Check your permissions.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource could not be found.
//
//   * ErrCodeInvalidNextTokenException "InvalidNextTokenException"
//   Indicates that the NextToken value is not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2016-05-10/ListTypedLinkFacetNames
func (c *CloudDirectory) ListTypedLinkFacetNames(input *ListTypedLinkFacetNamesInput) (*ListTypedLinkFacetNamesOutput, error) {
	req, out := c.ListTypedLinkFacetNamesRequest(input)
	return out, req.Send()
}

// ListTypedLinkFacetNamesWithContext is the same as ListTypedLinkFacetNames with the addition of
// the ability to pass a context and additional request options.
//
// See ListTypedLinkFacetNames for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudDirectory) ListTypedLinkFacetNamesWithContext(ctx aws.Context, input *ListTypedLinkFacetNamesInput, opts ...request.Option) (*ListTypedLinkFacetNamesOutput, error) {
	req, out := c.ListTypedLinkFacetNamesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListTypedLinkFacetNamesPages iterates over the pages of a ListTypedLinkFacetNames operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListTypedLinkFacetNames method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListTypedLinkFacetNames operation.
//    pageNum := 0
//    err := client.ListTypedLinkFacetNamesPages(params,
//        func(page *ListTypedLinkFacetNamesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *CloudDirectory) ListTypedLinkFacetNamesPages(input *ListTypedLinkFacetNamesInput, fn func(*ListTypedLinkFacetNamesOutput, bool) bool) error {
	return c.ListTypedLinkFacetNamesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListTypedLinkFacetNamesPagesWithContext same as ListTypedLinkFacetNamesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudDirectory) ListTypedLinkFacetNamesPagesWithContext(ctx aws.Context, input *ListTypedLinkFacetNamesInput, fn func(*ListTypedLinkFacetNamesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListTypedLinkFacetNamesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListTypedLinkFacetNamesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*ListTypedLinkFacetNamesOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opLookupPolicy = "LookupPolicy"

// LookupPolicyRequest generates a "aws/request.Request" representing the
// client's request for the LookupPolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See LookupPolicy for more information on using the LookupPolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the LookupPolicyRequest method.
//    req, resp := client.LookupPolicyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2016-05-10/LookupPolicy
func (c *CloudDirectory) LookupPolicyRequest(input *LookupPolicyInput) (req *request.Request, output *LookupPolicyOutput) {
	op := &request.Operation{
		Name:       opLookupPolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/amazonclouddirectory/2017-01-11/policy/lookup",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &LookupPolicyInput{}
	}

	output = &LookupPolicyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// LookupPolicy API operation for Amazon CloudDirectory.
//
// Lists all policies from the root of the Directory to the object specified.
// If there are no policies present, an empty list is returned. If policies
// are present, and if some objects don't have the policies attached, it returns
// the ObjectIdentifier for such objects. If policies are present, it returns
// ObjectIdentifier, policyId, and policyType. Paths that don't lead to the
// root from the target object are ignored. For more information, see Policies
// (http://docs.aws.amazon.com/directoryservice/latest/admin-guide/cd_key_concepts.html#policies).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudDirectory's
// API operation LookupPolicy for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalServiceException "InternalServiceException"
//   Indicates a problem that must be resolved by Amazon Web Services. This might
//   be a transient error in which case you can retry your request until it succeeds.
//   Otherwise, go to the AWS Service Health Dashboard (http://status.aws.amazon.com/)
//   site to see if there are any operational issues with the service.
//
//   * ErrCodeInvalidArnException "InvalidArnException"
//   Indicates that the provided ARN value is not valid.
//
//   * ErrCodeRetryableConflictException "RetryableConflictException"
//   Occurs when a conflict with a previous successful write is detected. For
//   example, if a write operation occurs on an object and then an attempt is
//   made to read the object using “SERIALIZABLE” consistency, this exception
//   may result. This generally occurs when the previous write did not have time
//   to propagate to the host serving the current request. A retry (with appropriate
//   backoff logic) is the recommended response to this exception.
//
//   * ErrCodeValidationException "ValidationException"
//   Indicates that your request is malformed in some manner. See the exception
//   message.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   Indicates that limits are exceeded. See Limits (http://docs.aws.amazon.com/directoryservice/latest/admin-guide/limits.html)
//   for more information.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   Access denied. Check your permissions.
//
//   * ErrCodeDirectoryNotEnabledException "DirectoryNotEnabledException"
//   Operations are only permitted on enabled directories.
//
//   * ErrCodeInvalidNextTokenException "InvalidNextTokenException"
//   Indicates that the NextToken value is not valid.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource could not be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2016-05-10/LookupPolicy
func (c *CloudDirectory) LookupPolicy(input *LookupPolicyInput) (*LookupPolicyOutput, error) {
	req, out := c.LookupPolicyRequest(input)
	return out, req.Send()
}

// LookupPolicyWithContext is the same as LookupPolicy with the addition of
// the ability to pass a context and additional request options.
//
// See LookupPolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudDirectory) LookupPolicyWithContext(ctx aws.Context, input *LookupPolicyInput, opts ...request.Option) (*LookupPolicyOutput, error) {
	req, out := c.LookupPolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// LookupPolicyPages iterates over the pages of a LookupPolicy operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See LookupPolicy method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a LookupPolicy operation.
//    pageNum := 0
//    err := client.LookupPolicyPages(params,
//        func(page *LookupPolicyOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *CloudDirectory) LookupPolicyPages(input *LookupPolicyInput, fn func(*LookupPolicyOutput, bool) bool) error {
	return c.LookupPolicyPagesWithContext(aws.BackgroundContext(), input, fn)
}

// LookupPolicyPagesWithContext same as LookupPolicyPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudDirectory) LookupPolicyPagesWithContext(ctx aws.Context, input *LookupPolicyInput, fn func(*LookupPolicyOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *LookupPolicyInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.LookupPolicyRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*LookupPolicyOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opPublishSchema = "PublishSchema"

// PublishSchemaRequest generates a "aws/request.Request" representing the
// client's request for the PublishSchema operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PublishSchema for more information on using the PublishSchema
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PublishSchemaRequest method.
//    req, resp := client.PublishSchemaRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2016-05-10/PublishSchema
func (c *CloudDirectory) PublishSchemaRequest(input *PublishSchemaInput) (req *request.Request, output *PublishSchemaOutput) {
	op := &request.Operation{
		Name:       opPublishSchema,
		HTTPMethod: "PUT",
		HTTPPath:   "/amazonclouddirectory/2017-01-11/schema/publish",
	}

	if input == nil {
		input = &PublishSchemaInput{}
	}

	output = &PublishSchemaOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PublishSchema API operation for Amazon CloudDirectory.
//
// Publishes a development schema with a major version and a recommended minor
// version.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudDirectory's
// API operation PublishSchema for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalServiceException "InternalServiceException"
//   Indicates a problem that must be resolved by Amazon Web Services. This might
//   be a transient error in which case you can retry your request until it succeeds.
//   Otherwise, go to the AWS Service Health Dashboard (http://status.aws.amazon.com/)
//   site to see if there are any operational issues with the service.
//
//   * ErrCodeInvalidArnException "InvalidArnException"
//   Indicates that the provided ARN value is not valid.
//
//   * ErrCodeRetryableConflictException "RetryableConflictException"
//   Occurs when a conflict with a previous successful write is detected. For
//   example, if a write operation occurs on an object and then an attempt is
//   made to read the object using “SERIALIZABLE” consistency, this exception
//   may result. This generally occurs when the previous write did not have time
//   to propagate to the host serving the current request. A retry (with appropriate
//   backoff logic) is the recommended response to this exception.
//
//   * ErrCodeValidationException "ValidationException"
//   Indicates that your request is malformed in some manner. See the exception
//   message.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   Indicates that limits are exceeded. See Limits (http://docs.aws.amazon.com/directoryservice/latest/admin-guide/limits.html)
//   for more information.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   Access denied. Check your permissions.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource could not be found.
//
//   * ErrCodeSchemaAlreadyPublishedException "SchemaAlreadyPublishedException"
//   Indicates that a schema is already published.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2016-05-10/PublishSchema
func (c *CloudDirectory) PublishSchema(input *PublishSchemaInput) (*PublishSchemaOutput, error) {
	req, out := c.PublishSchemaRequest(input)
	return out, req.Send()
}

// PublishSchemaWithContext is the same as PublishSchema with the addition of
// the ability to pass a context and additional request options.
//
// See PublishSchema for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudDirectory) PublishSchemaWithContext(ctx aws.Context, input *PublishSchemaInput, opts ...request.Option) (*PublishSchemaOutput, error) {
	req, out := c.PublishSchemaRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutSchemaFromJson = "PutSchemaFromJson"

// PutSchemaFromJsonRequest generates a "aws/request.Request" representing the
// client's request for the PutSchemaFromJson operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutSchemaFromJson for more information on using the PutSchemaFromJson
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutSchemaFromJsonRequest method.
//    req, resp := client.PutSchemaFromJsonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2016-05-10/PutSchemaFromJson
func (c *CloudDirectory) PutSchemaFromJsonRequest(input *PutSchemaFromJsonInput) (req *request.Request, output *PutSchemaFromJsonOutput) {
	op := &request.Operation{
		Name:       opPutSchemaFromJson,
		HTTPMethod: "PUT",
		HTTPPath:   "/amazonclouddirectory/2017-01-11/schema/json",
	}

	if input == nil {
		input = &PutSchemaFromJsonInput{}
	}

	output = &PutSchemaFromJsonOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PutSchemaFromJson API operation for Amazon CloudDirectory.
//
// Allows a schema to be updated using JSON upload. Only available for development
// schemas. See JSON Schema Format (http://docs.aws.amazon.com/directoryservice/latest/admin-guide/cd_schemas.html#jsonformat)
// for more information.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudDirectory's
// API operation PutSchemaFromJson for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalServiceException "InternalServiceException"
//   Indicates a problem that must be resolved by Amazon Web Services. This might
//   be a transient error in which case you can retry your request until it succeeds.
//   Otherwise, go to the AWS Service Health Dashboard (http://status.aws.amazon.com/)
//   site to see if there are any operational issues with the service.
//
//   * ErrCodeInvalidArnException "InvalidArnException"
//   Indicates that the provided ARN value is not valid.
//
//   * ErrCodeRetryableConflictException "RetryableConflictException"
//   Occurs when a conflict with a previous successful write is detected. For
//   example, if a write operation occurs on an object and then an attempt is
//   made to read the object using “SERIALIZABLE” consistency, this exception
//   may result. This generally occurs when the previous write did not have time
//   to propagate to the host serving the current request. A retry (with appropriate
//   backoff logic) is the recommended response to this exception.
//
//   * ErrCodeValidationException "ValidationException"
//   Indicates that your request is malformed in some manner. See the exception
//   message.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   Indicates that limits are exceeded. See Limits (http://docs.aws.amazon.com/directoryservice/latest/admin-guide/limits.html)
//   for more information.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   Access denied. Check your permissions.
//
//   * ErrCodeInvalidSchemaDocException "InvalidSchemaDocException"
//   Indicates that the provided SchemaDoc value is not valid.
//
//   * ErrCodeInvalidRuleException "InvalidRuleException"
//   Occurs when any of the rule parameter keys or values are invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2016-05-10/PutSchemaFromJson
func (c *CloudDirectory) PutSchemaFromJson(input *PutSchemaFromJsonInput) (*PutSchemaFromJsonOutput, error) {
	req, out := c.PutSchemaFromJsonRequest(input)
	return out, req.Send()
}

// PutSchemaFromJsonWithContext is the same as PutSchemaFromJson with the addition of
// the ability to pass a context and additional request options.
//
// See PutSchemaFromJson for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudDirectory) PutSchemaFromJsonWithContext(ctx aws.Context, input *PutSchemaFromJsonInput, opts ...request.Option) (*PutSchemaFromJsonOutput, error) {
	req, out := c.PutSchemaFromJsonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRemoveFacetFromObject = "RemoveFacetFromObject"

// RemoveFacetFromObjectRequest generates a "aws/request.Request" representing the
// client's request for the RemoveFacetFromObject operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RemoveFacetFromObject for more information on using the RemoveFacetFromObject
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the RemoveFacetFromObjectRequest method.
//    req, resp := client.RemoveFacetFromObjectRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2016-05-10/RemoveFacetFromObject
func (c *CloudDirectory) RemoveFacetFromObjectRequest(input *RemoveFacetFromObjectInput) (req *request.Request, output *RemoveFacetFromObjectOutput) {
	op := &request.Operation{
		Name:       opRemoveFacetFromObject,
		HTTPMethod: "PUT",
		HTTPPath:   "/amazonclouddirectory/2017-01-11/object/facets/delete",
	}

	if input == nil {
		input = &RemoveFacetFromObjectInput{}
	}

	output = &RemoveFacetFromObjectOutput{}
	req = c.newRequest(op, input, output)
	return
}

// RemoveFacetFromObject API operation for Amazon CloudDirectory.
//
// Removes the specified facet from the specified object.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudDirectory's
// API operation RemoveFacetFromObject for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalServiceException "InternalServiceException"
//   Indicates a problem that must be resolved by Amazon Web Services. This might
//   be a transient error in which case you can retry your request until it succeeds.
//   Otherwise, go to the AWS Service Health Dashboard (http://status.aws.amazon.com/)
//   site to see if there are any operational issues with the service.
//
//   * ErrCodeInvalidArnException "InvalidArnException"
//   Indicates that the provided ARN value is not valid.
//
//   * ErrCodeRetryableConflictException "RetryableConflictException"
//   Occurs when a conflict with a previous successful write is detected. For
//   example, if a write operation occurs on an object and then an attempt is
//   made to read the object using “SERIALIZABLE” consistency, this exception
//   may result. This generally occurs when the previous write did not have time
//   to propagate to the host serving the current request. A retry (with appropriate
//   backoff logic) is the recommended response to this exception.
//
//   * ErrCodeValidationException "ValidationException"
//   Indicates that your request is malformed in some manner. See the exception
//   message.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   Indicates that limits are exceeded. See Limits (http://docs.aws.amazon.com/directoryservice/latest/admin-guide/limits.html)
//   for more information.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   Access denied. Check your permissions.
//
//   * ErrCodeDirectoryNotEnabledException "DirectoryNotEnabledException"
//   Operations are only permitted on enabled directories.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource could not be found.
//
//   * ErrCodeFacetValidationException "FacetValidationException"
//   The Facet that you provided was not well formed or could not be validated
//   with the schema.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2016-05-10/RemoveFacetFromObject
func (c *CloudDirectory) RemoveFacetFromObject(input *RemoveFacetFromObjectInput) (*RemoveFacetFromObjectOutput, error) {
	req, out := c.RemoveFacetFromObjectRequest(input)
	return out, req.Send()
}

// RemoveFacetFromObjectWithContext is the same as RemoveFacetFromObject with the addition of
// the ability to pass a context and additional request options.
//
// See RemoveFacetFromObject for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudDirectory) RemoveFacetFromObjectWithContext(ctx aws.Context, input *RemoveFacetFromObjectInput, opts ...request.Option) (*RemoveFacetFromObjectOutput, error) {
	req, out := c.RemoveFacetFromObjectRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the TagResourceRequest method.
//    req, resp := client.TagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2016-05-10/TagResource
func (c *CloudDirectory) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "PUT",
		HTTPPath:   "/amazonclouddirectory/2017-01-11/tags/add",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// TagResource API operation for Amazon CloudDirectory.
//
// An API operation for adding tags to a resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudDirectory's
// API operation TagResource for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalServiceException "InternalServiceException"
//   Indicates a problem that must be resolved by Amazon Web Services. This might
//   be a transient error in which case you can retry your request until it succeeds.
//   Otherwise, go to the AWS Service Health Dashboard (http://status.aws.amazon.com/)
//   site to see if there are any operational issues with the service.
//
//   * ErrCodeInvalidArnException "InvalidArnException"
//   Indicates that the provided ARN value is not valid.
//
//   * ErrCodeRetryableConflictException "RetryableConflictException"
//   Occurs when a conflict with a previous successful write is detected. For
//   example, if a write operation occurs on an object and then an attempt is
//   made to read the object using “SERIALIZABLE” consistency, this exception
//   may result. This generally occurs when the previous write did not have time
//   to propagate to the host serving the current request. A retry (with appropriate
//   backoff logic) is the recommended response to this exception.
//
//   * ErrCodeValidationException "ValidationException"
//   Indicates that your request is malformed in some manner. See the exception
//   message.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   Indicates that limits are exceeded. See Limits (http://docs.aws.amazon.com/directoryservice/latest/admin-guide/limits.html)
//   for more information.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   Access denied. Check your permissions.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource could not be found.
//
//   * ErrCodeInvalidTaggingRequestException "InvalidTaggingRequestException"
//   Can occur for multiple reasons such as when you tag a resource that doesn’t
//   exist or if you specify a higher number of tags for a resource than the allowed
//   limit. Allowed limit is 50 tags per resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2016-05-10/TagResource
func (c *CloudDirectory) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudDirectory) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UntagResourceRequest method.
//    req, resp := client.UntagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2016-05-10/UntagResource
func (c *CloudDirectory) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "PUT",
		HTTPPath:   "/amazonclouddirectory/2017-01-11/tags/remove",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UntagResource API operation for Amazon CloudDirectory.
//
// An API operation for removing tags from a resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudDirectory's
// API operation UntagResource for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalServiceException "InternalServiceException"
//   Indicates a problem that must be resolved by Amazon Web Services. This might
//   be a transient error in which case you can retry your request until it succeeds.
//   Otherwise, go to the AWS Service Health Dashboard (http://status.aws.amazon.com/)
//   site to see if there are any operational issues with the service.
//
//   * ErrCodeInvalidArnException "InvalidArnException"
//   Indicates that the provided ARN value is not valid.
//
//   * ErrCodeRetryableConflictException "RetryableConflictException"
//   Occurs when a conflict with a previous successful write is detected. For
//   example, if a write operation occurs on an object and then an attempt is
//   made to read the object using “SERIALIZABLE” consistency, this exception
//   may result. This generally occurs when the previous write did not have time
//   to propagate to the host serving the current request. A retry (with appropriate
//   backoff logic) is the recommended response to this exception.
//
//   * ErrCodeValidationException "ValidationException"
//   Indicates that your request is malformed in some manner. See the exception
//   message.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   Indicates that limits are exceeded. See Limits (http://docs.aws.amazon.com/directoryservice/latest/admin-guide/limits.html)
//   for more information.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   Access denied. Check your permissions.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource could not be found.
//
//   * ErrCodeInvalidTaggingRequestException "InvalidTaggingRequestException"
//   Can occur for multiple reasons such as when you tag a resource that doesn’t
//   exist or if you specify a higher number of tags for a resource than the allowed
//   limit. Allowed limit is 50 tags per resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2016-05-10/UntagResource
func (c *CloudDirectory) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudDirectory) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateFacet = "UpdateFacet"

// UpdateFacetRequest generates a "aws/request.Request" representing the
// client's request for the UpdateFacet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateFacet for more information on using the UpdateFacet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateFacetRequest method.
//    req, resp := client.UpdateFacetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2016-05-10/UpdateFacet
func (c *CloudDirectory) UpdateFacetRequest(input *UpdateFacetInput) (req *request.Request, output *UpdateFacetOutput) {
	op := &request.Operation{
		Name:       opUpdateFacet,
		HTTPMethod: "PUT",
		HTTPPath:   "/amazonclouddirectory/2017-01-11/facet",
	}

	if input == nil {
		input = &UpdateFacetInput{}
	}

	output = &UpdateFacetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateFacet API operation for Amazon CloudDirectory.
//
// Does the following:
//
// Adds new Attributes, Rules, or ObjectTypes.
//
// Updates existing Attributes, Rules, or ObjectTypes.
//
// Deletes existing Attributes, Rules, or ObjectTypes.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudDirectory's
// API operation UpdateFacet for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalServiceException "InternalServiceException"
//   Indicates a problem that must be resolved by Amazon Web Services. This might
//   be a transient error in which case you can retry your request until it succeeds.
//   Otherwise, go to the AWS Service Health Dashboard (http://status.aws.amazon.com/)
//   site to see if there are any operational issues with the service.
//
//   * ErrCodeInvalidArnException "InvalidArnException"
//   Indicates that the provided ARN value is not valid.
//
//   * ErrCodeRetryableConflictException "RetryableConflictException"
//   Occurs when a conflict with a previous successful write is detected. For
//   example, if a write operation occurs on an object and then an attempt is
//   made to read the object using “SERIALIZABLE” consistency, this exception
//   may result. This generally occurs when the previous write did not have time
//   to propagate to the host serving the current request. A retry (with appropriate
//   backoff logic) is the recommended response to this exception.
//
//   * ErrCodeValidationException "ValidationException"
//   Indicates that your request is malformed in some manner. See the exception
//   message.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   Indicates that limits are exceeded. See Limits (http://docs.aws.amazon.com/directoryservice/latest/admin-guide/limits.html)
//   for more information.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   Access denied. Check your permissions.
//
//   * ErrCodeInvalidFacetUpdateException "InvalidFacetUpdateException"
//   An attempt to modify a Facet resulted in an invalid schema exception.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource could not be found.
//
//   * ErrCodeFacetNotFoundException "FacetNotFoundException"
//   The specified Facet could not be found.
//
//   * ErrCodeInvalidRuleException "InvalidRuleException"
//   Occurs when any of the rule parameter keys or values are invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2016-05-10/UpdateFacet
func (c *CloudDirectory) UpdateFacet(input *UpdateFacetInput) (*UpdateFacetOutput, error) {
	req, out := c.UpdateFacetRequest(input)
	return out, req.Send()
}

// UpdateFacetWithContext is the same as UpdateFacet with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateFacet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudDirectory) UpdateFacetWithContext(ctx aws.Context, input *UpdateFacetInput, opts ...request.Option) (*UpdateFacetOutput, error) {
	req, out := c.UpdateFacetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateObjectAttributes = "UpdateObjectAttributes"

// UpdateObjectAttributesRequest generates a "aws/request.Request" representing the
// client's request for the UpdateObjectAttributes operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateObjectAttributes for more information on using the UpdateObjectAttributes
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateObjectAttributesRequest method.
//    req, resp := client.UpdateObjectAttributesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2016-05-10/UpdateObjectAttributes
func (c *CloudDirectory) UpdateObjectAttributesRequest(input *UpdateObjectAttributesInput) (req *request.Request, output *UpdateObjectAttributesOutput) {
	op := &request.Operation{
		Name:       opUpdateObjectAttributes,
		HTTPMethod: "PUT",
		HTTPPath:   "/amazonclouddirectory/2017-01-11/object/update",
	}

	if input == nil {
		input = &UpdateObjectAttributesInput{}
	}

	output = &UpdateObjectAttributesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateObjectAttributes API operation for Amazon CloudDirectory.
//
// Updates a given object's attributes.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudDirectory's
// API operation UpdateObjectAttributes for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalServiceException "InternalServiceException"
//   Indicates a problem that must be resolved by Amazon Web Services. This might
//   be a transient error in which case you can retry your request until it succeeds.
//   Otherwise, go to the AWS Service Health Dashboard (http://status.aws.amazon.com/)
//   site to see if there are any operational issues with the service.
//
//   * ErrCodeInvalidArnException "InvalidArnException"
//   Indicates that the provided ARN value is not valid.
//
//   * ErrCodeRetryableConflictException "RetryableConflictException"
//   Occurs when a conflict with a previous successful write is detected. For
//   example, if a write operation occurs on an object and then an attempt is
//   made to read the object using “SERIALIZABLE” consistency, this exception
//   may result. This generally occurs when the previous write did not have time
//   to propagate to the host serving the current request. A retry (with appropriate
//   backoff logic) is the recommended response to this exception.
//
//   * ErrCodeValidationException "ValidationException"
//   Indicates that your request is malformed in some manner. See the exception
//   message.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   Indicates that limits are exceeded. See Limits (http://docs.aws.amazon.com/directoryservice/latest/admin-guide/limits.html)
//   for more information.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   Access denied. Check your permissions.
//
//   * ErrCodeDirectoryNotEnabledException "DirectoryNotEnabledException"
//   Operations are only permitted on enabled directories.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource could not be found.
//
//   * ErrCodeFacetValidationException "FacetValidationException"
//   The Facet that you provided was not well formed or could not be validated
//   with the schema.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2016-05-10/UpdateObjectAttributes
func (c *CloudDirectory) UpdateObjectAttributes(input *UpdateObjectAttributesInput) (*UpdateObjectAttributesOutput, error) {
	req, out := c.UpdateObjectAttributesRequest(input)
	return out, req.Send()
}

// UpdateObjectAttributesWithContext is the same as UpdateObjectAttributes with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateObjectAttributes for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudDirectory) UpdateObjectAttributesWithContext(ctx aws.Context, input *UpdateObjectAttributesInput, opts ...request.Option) (*UpdateObjectAttributesOutput, error) {
	req, out := c.UpdateObjectAttributesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateSchema = "UpdateSchema"

// UpdateSchemaRequest generates a "aws/request.Request" representing the
// client's request for the UpdateSchema operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateSchema for more information on using the UpdateSchema
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateSchemaRequest method.
//    req, resp := client.UpdateSchemaRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2016-05-10/UpdateSchema
func (c *CloudDirectory) UpdateSchemaRequest(input *UpdateSchemaInput) (req *request.Request, output *UpdateSchemaOutput) {
	op := &request.Operation{
		Name:       opUpdateSchema,
		HTTPMethod: "PUT",
		HTTPPath:   "/amazonclouddirectory/2017-01-11/schema/update",
	}

	if input == nil {
		input = &UpdateSchemaInput{}
	}

	output = &UpdateSchemaOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateSchema API operation for Amazon CloudDirectory.
//
// Updates the schema name with a new name. Only development schema names can
// be updated.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudDirectory's
// API operation UpdateSchema for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalServiceException "InternalServiceException"
//   Indicates a problem that must be resolved by Amazon Web Services. This might
//   be a transient error in which case you can retry your request until it succeeds.
//   Otherwise, go to the AWS Service Health Dashboard (http://status.aws.amazon.com/)
//   site to see if there are any operational issues with the service.
//
//   * ErrCodeInvalidArnException "InvalidArnException"
//   Indicates that the provided ARN value is not valid.
//
//   * ErrCodeRetryableConflictException "RetryableConflictException"
//   Occurs when a conflict with a previous successful write is detected. For
//   example, if a write operation occurs on an object and then an attempt is
//   made to read the object using “SERIALIZABLE” consistency, this exception
//   may result. This generally occurs when the previous write did not have time
//   to propagate to the host serving the current request. A retry (with appropriate
//   backoff logic) is the recommended response to this exception.
//
//   * ErrCodeValidationException "ValidationException"
//   Indicates that your request is malformed in some manner. See the exception
//   message.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   Indicates that limits are exceeded. See Limits (http://docs.aws.amazon.com/directoryservice/latest/admin-guide/limits.html)
//   for more information.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   Access denied. Check your permissions.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource could not be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2016-05-10/UpdateSchema
func (c *CloudDirectory) UpdateSchema(input *UpdateSchemaInput) (*UpdateSchemaOutput, error) {
	req, out := c.UpdateSchemaRequest(input)
	return out, req.Send()
}

// UpdateSchemaWithContext is the same as UpdateSchema with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateSchema for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudDirectory) UpdateSchemaWithContext(ctx aws.Context, input *UpdateSchemaInput, opts ...request.Option) (*UpdateSchemaOutput, error) {
	req, out := c.UpdateSchemaRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateTypedLinkFacet = "UpdateTypedLinkFacet"

// UpdateTypedLinkFacetRequest generates a "aws/request.Request" representing the
// client's request for the UpdateTypedLinkFacet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateTypedLinkFacet for more information on using the UpdateTypedLinkFacet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateTypedLinkFacetRequest method.
//    req, resp := client.UpdateTypedLinkFacetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2016-05-10/UpdateTypedLinkFacet
func (c *CloudDirectory) UpdateTypedLinkFacetRequest(input *UpdateTypedLinkFacetInput) (req *request.Request, output *UpdateTypedLinkFacetOutput) {
	op := &request.Operation{
		Name:       opUpdateTypedLinkFacet,
		HTTPMethod: "PUT",
		HTTPPath:   "/amazonclouddirectory/2017-01-11/typedlink/facet",
	}

	if input == nil {
		input = &UpdateTypedLinkFacetInput{}
	}

	output = &UpdateTypedLinkFacetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateTypedLinkFacet API operation for Amazon CloudDirectory.
//
// Updates a TypedLinkFacet. For more information, see Typed link (http://docs.aws.amazon.com/directoryservice/latest/admin-guide/objectsandlinks.html#typedlink).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudDirectory's
// API operation UpdateTypedLinkFacet for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalServiceException "InternalServiceException"
//   Indicates a problem that must be resolved by Amazon Web Services. This might
//   be a transient error in which case you can retry your request until it succeeds.
//   Otherwise, go to the AWS Service Health Dashboard (http://status.aws.amazon.com/)
//   site to see if there are any operational issues with the service.
//
//   * ErrCodeInvalidArnException "InvalidArnException"
//   Indicates that the provided ARN value is not valid.
//
//   * ErrCodeRetryableConflictException "RetryableConflictException"
//   Occurs when a conflict with a previous successful write is detected. For
//   example, if a write operation occurs on an object and then an attempt is
//   made to read the object using “SERIALIZABLE” consistency, this exception
//   may result. This generally occurs when the previous write did not have time
//   to propagate to the host serving the current request. A retry (with appropriate
//   backoff logic) is the recommended response to this exception.
//
//   * ErrCodeValidationException "ValidationException"
//   Indicates that your request is malformed in some manner. See the exception
//   message.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   Indicates that limits are exceeded. See Limits (http://docs.aws.amazon.com/directoryservice/latest/admin-guide/limits.html)
//   for more information.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   Access denied. Check your permissions.
//
//   * ErrCodeFacetValidationException "FacetValidationException"
//   The Facet that you provided was not well formed or could not be validated
//   with the schema.
//
//   * ErrCodeInvalidFacetUpdateException "InvalidFacetUpdateException"
//   An attempt to modify a Facet resulted in an invalid schema exception.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource could not be found.
//
//   * ErrCodeFacetNotFoundException "FacetNotFoundException"
//   The specified Facet could not be found.
//
//   * ErrCodeInvalidRuleException "InvalidRuleException"
//   Occurs when any of the rule parameter keys or values are invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2016-05-10/UpdateTypedLinkFacet
func (c *CloudDirectory) UpdateTypedLinkFacet(input *UpdateTypedLinkFacetInput) (*UpdateTypedLinkFacetOutput, error) {
	req, out := c.UpdateTypedLinkFacetRequest(input)
	return out, req.Send()
}

// UpdateTypedLinkFacetWithContext is the same as UpdateTypedLinkFacet with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateTypedLinkFacet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudDirectory) UpdateTypedLinkFacetWithContext(ctx aws.Context, input *UpdateTypedLinkFacetInput, opts ...request.Option) (*UpdateTypedLinkFacetOutput, error) {
	req, out := c.UpdateTypedLinkFacetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpgradeAppliedSchema = "UpgradeAppliedSchema"

// UpgradeAppliedSchemaRequest generates a "aws/request.Request" representing the
// client's request for the UpgradeAppliedSchema operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpgradeAppliedSchema for more information on using the UpgradeAppliedSchema
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpgradeAppliedSchemaRequest method.
//    req, resp := client.UpgradeAppliedSchemaRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2016-05-10/UpgradeAppliedSchema
func (c *CloudDirectory) UpgradeAppliedSchemaRequest(input *UpgradeAppliedSchemaInput) (req *request.Request, output *UpgradeAppliedSchemaOutput) {
	op := &request.Operation{
		Name:       opUpgradeAppliedSchema,
		HTTPMethod: "PUT",
		HTTPPath:   "/amazonclouddirectory/2017-01-11/schema/upgradeapplied",
	}

	if input == nil {
		input = &UpgradeAppliedSchemaInput{}
	}

	output = &UpgradeAppliedSchemaOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpgradeAppliedSchema API operation for Amazon CloudDirectory.
//
// Upgrades a single directory in-place using the PublishedSchemaArn with schema
// updates found in MinorVersion. Backwards-compatible minor version upgrades
// are instantaneously available for readers on all objects in the directory.
// Note: This is a synchronous API call and upgrades only one schema on a given
// directory per call. To upgrade multiple directories from one schema, you
// would need to call this API on each directory.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudDirectory's
// API operation UpgradeAppliedSchema for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalServiceException "InternalServiceException"
//   Indicates a problem that must be resolved by Amazon Web Services. This might
//   be a transient error in which case you can retry your request until it succeeds.
//   Otherwise, go to the AWS Service Health Dashboard (http://status.aws.amazon.com/)
//   site to see if there are any operational issues with the service.
//
//   * ErrCodeInvalidArnException "InvalidArnException"
//   Indicates that the provided ARN value is not valid.
//
//   * ErrCodeRetryableConflictException "RetryableConflictException"
//   Occurs when a conflict with a previous successful write is detected. For
//   example, if a write operation occurs on an object and then an attempt is
//   made to read the object using “SERIALIZABLE” consistency, this exception
//   may result. This generally occurs when the previous write did not have time
//   to propagate to the host serving the current request. A retry (with appropriate
//   backoff logic) is the recommended response to this exception.
//
//   * ErrCodeValidationException "ValidationException"
//   Indicates that your request is malformed in some manner. See the exception
//   message.
//
//   * ErrCodeIncompatibleSchemaException "IncompatibleSchemaException"
//   Indicates a failure occurred while performing a check for backward compatibility
//   between the specified schema and the schema that is currently applied to
//   the directory.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   Access denied. Check your permissions.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource could not be found.
//
//   * ErrCodeInvalidAttachmentException "InvalidAttachmentException"
//   Indicates that an attempt to attach an object with the same link name or
//   to apply a schema with the same name has occurred. Rename the link or the
//   schema and then try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2016-05-10/UpgradeAppliedSchema
func (c *CloudDirectory) UpgradeAppliedSchema(input *UpgradeAppliedSchemaInput) (*UpgradeAppliedSchemaOutput, error) {
	req, out := c.UpgradeAppliedSchemaRequest(input)
	return out, req.Send()
}

// UpgradeAppliedSchemaWithContext is the same as UpgradeAppliedSchema with the addition of
// the ability to pass a context and additional request options.
//
// See UpgradeAppliedSchema for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudDirectory) UpgradeAppliedSchemaWithContext(ctx aws.Context, input *UpgradeAppliedSchemaInput, opts ...request.Option) (*UpgradeAppliedSchemaOutput, error) {
	req, out := c.UpgradeAppliedSchemaRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpgradePublishedSchema = "UpgradePublishedSchema"

// UpgradePublishedSchemaRequest generates a "aws/request.Request" representing the
// client's request for the UpgradePublishedSchema operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpgradePublishedSchema for more information on using the UpgradePublishedSchema
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpgradePublishedSchemaRequest method.
//    req, resp := client.UpgradePublishedSchemaRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2016-05-10/UpgradePublishedSchema
func (c *CloudDirectory) UpgradePublishedSchemaRequest(input *UpgradePublishedSchemaInput) (req *request.Request, output *UpgradePublishedSchemaOutput) {
	op := &request.Operation{
		Name:       opUpgradePublishedSchema,
		HTTPMethod: "PUT",
		HTTPPath:   "/amazonclouddirectory/2017-01-11/schema/upgradepublished",
	}

	if input == nil {
		input = &UpgradePublishedSchemaInput{}
	}

	output = &UpgradePublishedSchemaOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpgradePublishedSchema API operation for Amazon CloudDirectory.
//
// Upgrades a published schema under a new minor version revision using the
// current contents of DevelopmentSchemaArn.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudDirectory's
// API operation UpgradePublishedSchema for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalServiceException "InternalServiceException"
//   Indicates a problem that must be resolved by Amazon Web Services. This might
//   be a transient error in which case you can retry your request until it succeeds.
//   Otherwise, go to the AWS Service Health Dashboard (http://status.aws.amazon.com/)
//   site to see if there are any operational issues with the service.
//
//   * ErrCodeInvalidArnException "InvalidArnException"
//   Indicates that the provided ARN value is not valid.
//
//   * ErrCodeRetryableConflictException "RetryableConflictException"
//   Occurs when a conflict with a previous successful write is detected. For
//   example, if a write operation occurs on an object and then an attempt is
//   made to read the object using “SERIALIZABLE” consistency, this exception
//   may result. This generally occurs when the previous write did not have time
//   to propagate to the host serving the current request. A retry (with appropriate
//   backoff logic) is the recommended response to this exception.
//
//   * ErrCodeValidationException "ValidationException"
//   Indicates that your request is malformed in some manner. See the exception
//   message.
//
//   * ErrCodeIncompatibleSchemaException "IncompatibleSchemaException"
//   Indicates a failure occurred while performing a check for backward compatibility
//   between the specified schema and the schema that is currently applied to
//   the directory.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   Access denied. Check your permissions.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource could not be found.
//
//   * ErrCodeInvalidAttachmentException "InvalidAttachmentException"
//   Indicates that an attempt to attach an object with the same link name or
//   to apply a schema with the same name has occurred. Rename the link or the
//   schema and then try again.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   Indicates that limits are exceeded. See Limits (http://docs.aws.amazon.com/directoryservice/latest/admin-guide/limits.html)
//   for more information.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2016-05-10/UpgradePublishedSchema
func (c *CloudDirectory) UpgradePublishedSchema(input *UpgradePublishedSchemaInput) (*UpgradePublishedSchemaOutput, error) {
	req, out := c.UpgradePublishedSchemaRequest(input)
	return out, req.Send()
}

// UpgradePublishedSchemaWithContext is the same as UpgradePublishedSchema with the addition of
// the ability to pass a context and additional request options.
//
// See UpgradePublishedSchema for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudDirectory) UpgradePublishedSchemaWithContext(ctx aws.Context, input *UpgradePublishedSchemaInput, opts ...request.Option) (*UpgradePublishedSchemaOutput, error) {
	req, out := c.UpgradePublishedSchemaRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type AddFacetToObjectInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) that is associated with the Directory where
	// the object resides. For more information, see arns.
	//
	// DirectoryArn is a required field
	DirectoryArn *string `location:"header" locationName:"x-amz-data-partition" type:"string" required:"true"`

	// Attributes on the facet that you are adding to the object.
	ObjectAttributeList []*AttributeKeyAndValue `type:"list"`

	// A reference to the object you are adding the specified facet to.
	//
	// ObjectReference is a required field
	ObjectReference *ObjectReference `type:"structure" required:"true"`

	// Identifiers for the facet that you are adding to the object. See SchemaFacet
	// for details.
	//
	// SchemaFacet is a required field
	SchemaFacet *SchemaFacet `type:"structure" required:"true"`
}

// String returns the string representation
func (s AddFacetToObjectInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddFacetToObjectInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AddFacetToObjectInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AddFacetToObjectInput"}
	if s.DirectoryArn == nil {
		invalidParams.Add(request.NewErrParamRequired("DirectoryArn"))
	}
	if s.ObjectReference == nil {
		invalidParams.Add(request.NewErrParamRequired("ObjectReference"))
	}
	if s.SchemaFacet == nil {
		invalidParams.Add(request.NewErrParamRequired("SchemaFacet"))
	}
	if s.ObjectAttributeList != nil {
		for i, v := range s.ObjectAttributeList {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ObjectAttributeList", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.SchemaFacet != nil {
		if err := s.SchemaFacet.Validate(); err != nil {
			invalidParams.AddNested("SchemaFacet", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDirectoryArn sets the DirectoryArn field's value.
func (s *AddFacetToObjectInput) SetDirectoryArn(v string) *AddFacetToObjectInput {
	s.DirectoryArn = &v
	return s
}

// SetObjectAttributeList sets the ObjectAttributeList field's value.
func (s *AddFacetToObjectInput) SetObjectAttributeList(v []*AttributeKeyAndValue) *AddFacetToObjectInput {
	s.ObjectAttributeList = v
	return s
}

// SetObjectReference sets the ObjectReference field's value.
func (s *AddFacetToObjectInput) SetObjectReference(v *ObjectReference) *AddFacetToObjectInput {
	s.ObjectReference = v
	return s
}

// SetSchemaFacet sets the SchemaFacet field's value.
func (s *AddFacetToObjectInput) SetSchemaFacet(v *SchemaFacet) *AddFacetToObjectInput {
	s.SchemaFacet = v
	return s
}

type AddFacetToObjectOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s AddFacetToObjectOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddFacetToObjectOutput) GoString() string {
	return s.String()
}

type ApplySchemaInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) that is associated with the Directory into
	// which the schema is copied. For more information, see arns.
	//
	// DirectoryArn is a required field
	DirectoryArn *string `location:"header" locationName:"x-amz-data-partition" type:"string" required:"true"`

	// Published schema Amazon Resource Name (ARN) that needs to be copied. For
	// more information, see arns.
	//
	// PublishedSchemaArn is a required field
	PublishedSchemaArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s ApplySchemaInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ApplySchemaInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ApplySchemaInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ApplySchemaInput"}
	if s.DirectoryArn == nil {
		invalidParams.Add(request.NewErrParamRequired("DirectoryArn"))
	}
	if s.PublishedSchemaArn == nil {
		invalidParams.Add(request.NewErrParamRequired("PublishedSchemaArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDirectoryArn sets the DirectoryArn field's value.
func (s *ApplySchemaInput) SetDirectoryArn(v string) *ApplySchemaInput {
	s.DirectoryArn = &v
	return s
}

// SetPublishedSchemaArn sets the PublishedSchemaArn field's value.
func (s *ApplySchemaInput) SetPublishedSchemaArn(v string) *ApplySchemaInput {
	s.PublishedSchemaArn = &v
	return s
}

type ApplySchemaOutput struct {
	_ struct{} `type:"structure"`

	// The applied schema ARN that is associated with the copied schema in the Directory.
	// You can use this ARN to describe the schema information applied on this directory.
	// For more information, see arns.
	AppliedSchemaArn *string `type:"string"`

	// The ARN that is associated with the Directory. For more information, see
	// arns.
	DirectoryArn *string `type:"string"`
}

// String returns the string representation
func (s ApplySchemaOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ApplySchemaOutput) GoString() string {
	return s.String()
}

// SetAppliedSchemaArn sets the AppliedSchemaArn field's value.
func (s *ApplySchemaOutput) SetAppliedSchemaArn(v string) *ApplySchemaOutput {
	s.AppliedSchemaArn = &v
	return s
}

// SetDirectoryArn sets the DirectoryArn field's value.
func (s *ApplySchemaOutput) SetDirectoryArn(v string) *ApplySchemaOutput {
	s.DirectoryArn = &v
	return s
}

type AttachObjectInput struct {
	_ struct{} `type:"structure"`

	// The child object reference to be attached to the object.
	//
	// ChildReference is a required field
	ChildReference *ObjectReference `type:"structure" required:"true"`

	// Amazon Resource Name (ARN) that is associated with the Directory where both
	// objects reside. For more information, see arns.
	//
	// DirectoryArn is a required field
	DirectoryArn *string `location:"header" locationName:"x-amz-data-partition" type:"string" required:"true"`

	// The link name with which the child object is attached to the parent.
	//
	// LinkName is a required field
	LinkName *string `min:"1" type:"string" required:"true"`

	// The parent object reference.
	//
	// ParentReference is a required field
	ParentReference *ObjectReference `type:"structure" required:"true"`
}

// String returns the string representation
func (s AttachObjectInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AttachObjectInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AttachObjectInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AttachObjectInput"}
	if s.ChildReference == nil {
		invalidParams.Add(request.NewErrParamRequired("ChildReference"))
	}
	if s.DirectoryArn == nil {
		invalidParams.Add(request.NewErrParamRequired("DirectoryArn"))
	}
	if s.LinkName == nil {
		invalidParams.Add(request.NewErrParamRequired("LinkName"))
	}
	if s.LinkName != nil && len(*s.LinkName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LinkName", 1))
	}
	if s.ParentReference == nil {
		invalidParams.Add(request.NewErrParamRequired("ParentReference"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChildReference sets the ChildReference field's value.
func (s *AttachObjectInput) SetChildReference(v *ObjectReference) *AttachObjectInput {
	s.ChildReference = v
	return s
}

// SetDirectoryArn sets the DirectoryArn field's value.
func (s *AttachObjectInput) SetDirectoryArn(v string) *AttachObjectInput {
	s.DirectoryArn = &v
	return s
}

// SetLinkName sets the LinkName field's value.
func (s *AttachObjectInput) SetLinkName(v string) *AttachObjectInput {
	s.LinkName = &v
	return s
}

// SetParentReference sets the ParentReference field's value.
func (s *AttachObjectInput) SetParentReference(v *ObjectReference) *AttachObjectInput {
	s.ParentReference = v
	return s
}

type AttachObjectOutput struct {
	_ struct{} `type:"structure"`

	// The attached ObjectIdentifier, which is the child ObjectIdentifier.
	AttachedObjectIdentifier *string `type:"string"`
}

// String returns the string representation
func (s AttachObjectOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AttachObjectOutput) GoString() string {
	return s.String()
}

// SetAttachedObjectIdentifier sets the AttachedObjectIdentifier field's value.
func (s *AttachObjectOutput) SetAttachedObjectIdentifier(v string) *AttachObjectOutput {
	s.AttachedObjectIdentifier = &v
	return s
}

type AttachPolicyInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) that is associated with the Directory where
	// both objects reside. For more information, see arns.
	//
	// DirectoryArn is a required field
	DirectoryArn *string `location:"header" locationName:"x-amz-data-partition" type:"string" required:"true"`

	// The reference that identifies the object to which the policy will be attached.
	//
	// ObjectReference is a required field
	ObjectReference *ObjectReference `type:"structure" required:"true"`

	// The reference that is associated with the policy object.
	//
	// PolicyReference is a required field
	PolicyReference *ObjectReference `type:"structure" required:"true"`
}

// String returns the string representation
func (s AttachPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AttachPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AttachPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AttachPolicyInput"}
	if s.DirectoryArn == nil {
		invalidParams.Add(request.NewErrParamRequired("DirectoryArn"))
	}
	if s.ObjectReference == nil {
		invalidParams.Add(request.NewErrParamRequired("ObjectReference"))
	}
	if s.PolicyReference == nil {
		invalidParams.Add(request.NewErrParamRequired("PolicyReference"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDirectoryArn sets the DirectoryArn field's value.
func (s *AttachPolicyInput) SetDirectoryArn(v string) *AttachPolicyInput {
	s.DirectoryArn = &v
	return s
}

// SetObjectReference sets the ObjectReference field's value.
func (s *AttachPolicyInput) SetObjectReference(v *ObjectReference) *AttachPolicyInput {
	s.ObjectReference = v
	return s
}

// SetPolicyReference sets the PolicyReference field's value.
func (s *AttachPolicyInput) SetPolicyReference(v *ObjectReference) *AttachPolicyInput {
	s.PolicyReference = v
	return s
}

type AttachPolicyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s AttachPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AttachPolicyOutput) GoString() string {
	return s.String()
}

type AttachToIndexInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the directory where the object and index
	// exist.
	//
	// DirectoryArn is a required field
	DirectoryArn *string `location:"header" locationName:"x-amz-data-partition" type:"string" required:"true"`

	// A reference to the index that you are attaching the object to.
	//
	// IndexReference is a required field
	IndexReference *ObjectReference `type:"structure" required:"true"`

	// A reference to the object that you are attaching to the index.
	//
	// TargetReference is a required field
	TargetReference *ObjectReference `type:"structure" required:"true"`
}

// String returns the string representation
func (s AttachToIndexInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AttachToIndexInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AttachToIndexInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AttachToIndexInput"}
	if s.DirectoryArn == nil {
		invalidParams.Add(request.NewErrParamRequired("DirectoryArn"))
	}
	if s.IndexReference == nil {
		invalidParams.Add(request.NewErrParamRequired("IndexReference"))
	}
	if s.TargetReference == nil {
		invalidParams.Add(request.NewErrParamRequired("TargetReference"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDirectoryArn sets the DirectoryArn field's value.
func (s *AttachToIndexInput) SetDirectoryArn(v string) *AttachToIndexInput {
	s.DirectoryArn = &v
	return s
}

// SetIndexReference sets the IndexReference field's value.
func (s *AttachToIndexInput) SetIndexReference(v *ObjectReference) *AttachToIndexInput {
	s.IndexReference = v
	return s
}

// SetTargetReference sets the TargetReference field's value.
func (s *AttachToIndexInput) SetTargetReference(v *ObjectReference) *AttachToIndexInput {
	s.TargetReference = v
	return s
}

type AttachToIndexOutput struct {
	_ struct{} `type:"structure"`

	// The ObjectIdentifier of the object that was attached to the index.
	AttachedObjectIdentifier *string `type:"string"`
}

// String returns the string representation
func (s AttachToIndexOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AttachToIndexOutput) GoString() string {
	return s.String()
}

// SetAttachedObjectIdentifier sets the AttachedObjectIdentifier field's value.
func (s *AttachToIndexOutput) SetAttachedObjectIdentifier(v string) *AttachToIndexOutput {
	s.AttachedObjectIdentifier = &v
	return s
}

type AttachTypedLinkInput struct {
	_ struct{} `type:"structure"`

	// A set of attributes that are associated with the typed link.
	//
	// Attributes is a required field
	Attributes []*AttributeNameAndValue `type:"list" required:"true"`

	// The Amazon Resource Name (ARN) of the directory where you want to attach
	// the typed link.
	//
	// DirectoryArn is a required field
	DirectoryArn *string `location:"header" locationName:"x-amz-data-partition" type:"string" required:"true"`

	// Identifies the source object that the typed link will attach to.
	//
	// SourceObjectReference is a required field
	SourceObjectReference *ObjectReference `type:"structure" required:"true"`

	// Identifies the target object that the typed link will attach to.
	//
	// TargetObjectReference is a required field
	TargetObjectReference *ObjectReference `type:"structure" required:"true"`

	// Identifies the typed link facet that is associated with the typed link.
	//
	// TypedLinkFacet is a required field
	TypedLinkFacet *TypedLinkSchemaAndFacetName `type:"structure" required:"true"`
}

// String returns the string representation
func (s AttachTypedLinkInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AttachTypedLinkInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AttachTypedLinkInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AttachTypedLinkInput"}
	if s.Attributes == nil {
		invalidParams.Add(request.NewErrParamRequired("Attributes"))
	}
	if s.DirectoryArn == nil {
		invalidParams.Add(request.NewErrParamRequired("DirectoryArn"))
	}
	if s.SourceObjectReference == nil {
		invalidParams.Add(request.NewErrParamRequired("SourceObjectReference"))
	}
	if s.TargetObjectReference == nil {
		invalidParams.Add(request.NewErrParamRequired("TargetObjectReference"))
	}
	if s.TypedLinkFacet == nil {
		invalidParams.Add(request.NewErrParamRequired("TypedLinkFacet"))
	}
	if s.Attributes != nil {
		for i, v := range s.Attributes {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Attributes", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.TypedLinkFacet != nil {
		if err := s.TypedLinkFacet.Validate(); err != nil {
			invalidParams.AddNested("TypedLinkFacet", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAttributes sets the Attributes field's value.
func (s *AttachTypedLinkInput) SetAttributes(v []*AttributeNameAndValue) *AttachTypedLinkInput {
	s.Attributes = v
	return s
}

// SetDirectoryArn sets the DirectoryArn field's value.
func (s *AttachTypedLinkInput) SetDirectoryArn(v string) *AttachTypedLinkInput {
	s.DirectoryArn = &v
	return s
}

// SetSourceObjectReference sets the SourceObjectReference field's value.
func (s *AttachTypedLinkInput) SetSourceObjectReference(v *ObjectReference) *AttachTypedLinkInput {
	s.SourceObjectReference = v
	return s
}

// SetTargetObjectReference sets the TargetObjectReference field's value.
func (s *AttachTypedLinkInput) SetTargetObjectReference(v *ObjectReference) *AttachTypedLinkInput {
	s.TargetObjectReference = v
	return s
}

// SetTypedLinkFacet sets the TypedLinkFacet field's value.
func (s *AttachTypedLinkInput) SetTypedLinkFacet(v *TypedLinkSchemaAndFacetName) *AttachTypedLinkInput {
	s.TypedLinkFacet = v
	return s
}

type AttachTypedLinkOutput struct {
	_ struct{} `type:"structure"`

	// Returns a typed link specifier as output.
	TypedLinkSpecifier *TypedLinkSpecifier `type:"structure"`
}

// String returns the string representation
func (s AttachTypedLinkOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AttachTypedLinkOutput) GoString() string {
	return s.String()
}

// SetTypedLinkSpecifier sets the TypedLinkSpecifier field's value.
func (s *AttachTypedLinkOutput) SetTypedLinkSpecifier(v *TypedLinkSpecifier) *AttachTypedLinkOutput {
	s.TypedLinkSpecifier = v
	return s
}

// A unique identifier for an attribute.
type AttributeKey struct {
	_ struct{} `type:"structure"`

	// The name of the facet that the attribute exists within.
	//
	// FacetName is a required field
	FacetName *string `min:"1" type:"string" required:"true"`

	// The name of the attribute.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the schema that contains the facet and
	// attribute.
	//
	// SchemaArn is a required field
	SchemaArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s AttributeKey) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AttributeKey) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AttributeKey) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AttributeKey"}
	if s.FacetName == nil {
		invalidParams.Add(request.NewErrParamRequired("FacetName"))
	}
	if s.FacetName != nil && len(*s.FacetName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FacetName", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.SchemaArn == nil {
		invalidParams.Add(request.NewErrParamRequired("SchemaArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFacetName sets the FacetName field's value.
func (s *AttributeKey) SetFacetName(v string) *AttributeKey {
	s.FacetName = &v
	return s
}

// SetName sets the Name field's value.
func (s *AttributeKey) SetName(v string) *AttributeKey {
	s.Name = &v
	return s
}

// SetSchemaArn sets the SchemaArn field's value.
func (s *AttributeKey) SetSchemaArn(v string) *AttributeKey {
	s.SchemaArn = &v
	return s
}

// The combination of an attribute key and an attribute value.
type AttributeKeyAndValue struct {
	_ struct{} `type:"structure"`

	// The key of the attribute.
	//
	// Key is a required field
	Key *AttributeKey `type:"structure" required:"true"`

	// The value of the attribute.
	//
	// Value is a required field
	Value *TypedAttributeValue `type:"structure" required:"true"`
}

// String returns the string representation
func (s AttributeKeyAndValue) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AttributeKeyAndValue) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AttributeKeyAndValue) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AttributeKeyAndValue"}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}
	if s.Key != nil {
		if err := s.Key.Validate(); err != nil {
			invalidParams.AddNested("Key", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *AttributeKeyAndValue) SetKey(v *AttributeKey) *AttributeKeyAndValue {
	s.Key = v
	return s
}

// SetValue sets the Value field's value.
func (s *AttributeKeyAndValue) SetValue(v *TypedAttributeValue) *AttributeKeyAndValue {
	s.Value = v
	return s
}

// Identifies the attribute name and value for a typed link.
type AttributeNameAndValue struct {
	_ struct{} `type:"structure"`

	// The attribute name of the typed link.
	//
	// AttributeName is a required field
	AttributeName *string `min:"1" type:"string" required:"true"`

	// The value for the typed link.
	//
	// Value is a required field
	Value *TypedAttributeValue `type:"structure" required:"true"`
}

// String returns the string representation
func (s AttributeNameAndValue) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AttributeNameAndValue) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AttributeNameAndValue) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AttributeNameAndValue"}
	if s.AttributeName == nil {
		invalidParams.Add(request.NewErrParamRequired("AttributeName"))
	}
	if s.AttributeName != nil && len(*s.AttributeName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AttributeName", 1))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAttributeName sets the AttributeName field's value.
func (s *AttributeNameAndValue) SetAttributeName(v string) *AttributeNameAndValue {
	s.AttributeName = &v
	return s
}

// SetValue sets the Value field's value.
func (s *AttributeNameAndValue) SetValue(v *TypedAttributeValue) *AttributeNameAndValue {
	s.Value = v
	return s
}

// Represents the output of a batch add facet to object operation.
type BatchAddFacetToObject struct {
	_ struct{} `type:"structure"`

	// The attributes to set on the object.
	//
	// ObjectAttributeList is a required field
	ObjectAttributeList []*AttributeKeyAndValue `type:"list" required:"true"`

	// A reference to the object being mutated.
	//
	// ObjectReference is a required field
	ObjectReference *ObjectReference `type:"structure" required:"true"`

	// Represents the facet being added to the object.
	//
	// SchemaFacet is a required field
	SchemaFacet *SchemaFacet `type:"structure" required:"true"`
}

// String returns the string representation
func (s BatchAddFacetToObject) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchAddFacetToObject) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchAddFacetToObject) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchAddFacetToObject"}
	if s.ObjectAttributeList == nil {
		invalidParams.Add(request.NewErrParamRequired("ObjectAttributeList"))
	}
	if s.ObjectReference == nil {
		invalidParams.Add(request.NewErrParamRequired("ObjectReference"))
	}
	if s.SchemaFacet == nil {
		invalidParams.Add(request.NewErrParamRequired("SchemaFacet"))
	}
	if s.ObjectAttributeList != nil {
		for i, v := range s.ObjectAttributeList {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ObjectAttributeList", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.SchemaFacet != nil {
		if err := s.SchemaFacet.Validate(); err != nil {
			invalidParams.AddNested("SchemaFacet", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetObjectAttributeList sets the ObjectAttributeList field's value.
func (s *BatchAddFacetToObject) SetObjectAttributeList(v []*AttributeKeyAndValue) *BatchAddFacetToObject {
	s.ObjectAttributeList = v
	return s
}

// SetObjectReference sets the ObjectReference field's value.
func (s *BatchAddFacetToObject) SetObjectReference(v *ObjectReference) *BatchAddFacetToObject {
	s.ObjectReference = v
	return s
}

// SetSchemaFacet sets the SchemaFacet field's value.
func (s *BatchAddFacetToObject) SetSchemaFacet(v *SchemaFacet) *BatchAddFacetToObject {
	s.SchemaFacet = v
	return s
}

// The result of a batch add facet to object operation.
type BatchAddFacetToObjectResponse struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s BatchAddFacetToObjectResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchAddFacetToObjectResponse) GoString() string {
	return s.String()
}

// Represents the output of an AttachObject operation.
type BatchAttachObject struct {
	_ struct{} `type:"structure"`

	// The child object reference that is to be attached to the object.
	//
	// ChildReference is a required field
	ChildReference *ObjectReference `type:"structure" required:"true"`

	// The name of the link.
	//
	// LinkName is a required field
	LinkName *string `min:"1" type:"string" required:"true"`

	// The parent object reference.
	//
	// ParentReference is a required field
	ParentReference *ObjectReference `type:"structure" required:"true"`
}

// String returns the string representation
func (s BatchAttachObject) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchAttachObject) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchAttachObject) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchAttachObject"}
	if s.ChildReference == nil {
		invalidParams.Add(request.NewErrParamRequired("ChildReference"))
	}
	if s.LinkName == nil {
		invalidParams.Add(request.NewErrParamRequired("LinkName"))
	}
	if s.LinkName != nil && len(*s.LinkName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LinkName", 1))
	}
	if s.ParentReference == nil {
		invalidParams.Add(request.NewErrParamRequired("ParentReference"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChildReference sets the ChildReference field's value.
func (s *BatchAttachObject) SetChildReference(v *ObjectReference) *BatchAttachObject {
	s.ChildReference = v
	return s
}

// SetLinkName sets the LinkName field's value.
func (s *BatchAttachObject) SetLinkName(v string) *BatchAttachObject {
	s.LinkName = &v
	return s
}

// SetParentReference sets the ParentReference field's value.
func (s *BatchAttachObject) SetParentReference(v *ObjectReference) *BatchAttachObject {
	s.ParentReference = v
	return s
}

// Represents the output batch AttachObject response operation.
type BatchAttachObjectResponse struct {
	_ struct{} `type:"structure"`

	// The ObjectIdentifier of the object that has been attached.
	AttachedObjectIdentifier *string `locationName:"attachedObjectIdentifier" type:"string"`
}

// String returns the string representation
func (s BatchAttachObjectResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchAttachObjectResponse) GoString() string {
	return s.String()
}

// SetAttachedObjectIdentifier sets the AttachedObjectIdentifier field's value.
func (s *BatchAttachObjectResponse) SetAttachedObjectIdentifier(v string) *BatchAttachObjectResponse {
	s.AttachedObjectIdentifier = &v
	return s
}

// Attaches a policy object to a regular object inside a BatchRead operation. For
// more information, see AttachPolicy and BatchReadRequest$Operations.
type BatchAttachPolicy struct {
	_ struct{} `type:"structure"`

	// The reference that identifies the object to which the policy will be attached.
	//
	// ObjectReference is a required field
	ObjectReference *ObjectReference `type:"structure" required:"true"`

	// The reference that is associated with the policy object.
	//
	// PolicyReference is a required field
	PolicyReference *ObjectReference `type:"structure" required:"true"`
}

// String returns the string representation
func (s BatchAttachPolicy) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchAttachPolicy) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchAttachPolicy) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchAttachPolicy"}
	if s.ObjectReference == nil {
		invalidParams.Add(request.NewErrParamRequired("ObjectReference"))
	}
	if s.PolicyReference == nil {
		invalidParams.Add(request.NewErrParamRequired("PolicyReference"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetObjectReference sets the ObjectReference field's value.
func (s *BatchAttachPolicy) SetObjectReference(v *ObjectReference) *BatchAttachPolicy {
	s.ObjectReference = v
	return s
}

// SetPolicyReference sets the PolicyReference field's value.
func (s *BatchAttachPolicy) SetPolicyReference(v *ObjectReference) *BatchAttachPolicy {
	s.PolicyReference = v
	return s
}

// Represents the output of an AttachPolicy response operation.
type BatchAttachPolicyResponse struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s BatchAttachPolicyResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchAttachPolicyResponse) GoString() string {
	return s.String()
}

// Attaches the specified object to the specified index inside a BatchRead operation.
// For more information, see AttachToIndex and BatchReadRequest$Operations.
type BatchAttachToIndex struct {
	_ struct{} `type:"structure"`

	// A reference to the index that you are attaching the object to.
	//
	// IndexReference is a required field
	IndexReference *ObjectReference `type:"structure" required:"true"`

	// A reference to the object that you are attaching to the index.
	//
	// TargetReference is a required field
	TargetReference *ObjectReference `type:"structure" required:"true"`
}

// String returns the string representation
func (s BatchAttachToIndex) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchAttachToIndex) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchAttachToIndex) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchAttachToIndex"}
	if s.IndexReference == nil {
		invalidParams.Add(request.NewErrParamRequired("IndexReference"))
	}
	if s.TargetReference == nil {
		invalidParams.Add(request.NewErrParamRequired("TargetReference"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIndexReference sets the IndexReference field's value.
func (s *BatchAttachToIndex) SetIndexReference(v *ObjectReference) *BatchAttachToIndex {
	s.IndexReference = v
	return s
}

// SetTargetReference sets the TargetReference field's value.
func (s *BatchAttachToIndex) SetTargetReference(v *ObjectReference) *BatchAttachToIndex {
	s.TargetReference = v
	return s
}

// Represents the output of a AttachToIndex response operation.
type BatchAttachToIndexResponse struct {
	_ struct{} `type:"structure"`

	// The ObjectIdentifier of the object that was attached to the index.
	AttachedObjectIdentifier *string `type:"string"`
}

// String returns the string representation
func (s BatchAttachToIndexResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchAttachToIndexResponse) GoString() string {
	return s.String()
}

// SetAttachedObjectIdentifier sets the AttachedObjectIdentifier field's value.
func (s *BatchAttachToIndexResponse) SetAttachedObjectIdentifier(v string) *BatchAttachToIndexResponse {
	s.AttachedObjectIdentifier = &v
	return s
}

// Attaches a typed link to a specified source and target object inside a BatchRead
// operation. For more information, see AttachTypedLink and BatchReadRequest$Operations.
type BatchAttachTypedLink struct {
	_ struct{} `type:"structure"`

	// A set of attributes that are associated with the typed link.
	//
	// Attributes is a required field
	Attributes []*AttributeNameAndValue `type:"list" required:"true"`

	// Identifies the source object that the typed link will attach to.
	//
	// SourceObjectReference is a required field
	SourceObjectReference *ObjectReference `type:"structure" required:"true"`

	// Identifies the target object that the typed link will attach to.
	//
	// TargetObjectReference is a required field
	TargetObjectReference *ObjectReference `type:"structure" required:"true"`

	// Identifies the typed link facet that is associated with the typed link.
	//
	// TypedLinkFacet is a required field
	TypedLinkFacet *TypedLinkSchemaAndFacetName `type:"structure" required:"true"`
}

// String returns the string representation
func (s BatchAttachTypedLink) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchAttachTypedLink) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchAttachTypedLink) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchAttachTypedLink"}
	if s.Attributes == nil {
		invalidParams.Add(request.NewErrParamRequired("Attributes"))
	}
	if s.SourceObjectReference == nil {
		invalidParams.Add(request.NewErrParamRequired("SourceObjectReference"))
	}
	if s.TargetObjectReference == nil {
		invalidParams.Add(request.NewErrParamRequired("TargetObjectReference"))
	}
	if s.TypedLinkFacet == nil {
		invalidParams.Add(request.NewErrParamRequired("TypedLinkFacet"))
	}
	if s.Attributes != nil {
		for i, v := range s.Attributes {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Attributes", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.TypedLinkFacet != nil {
		if err := s.TypedLinkFacet.Validate(); err != nil {
			invalidParams.AddNested("TypedLinkFacet", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAttributes sets the Attributes field's value.
func (s *BatchAttachTypedLink) SetAttributes(v []*AttributeNameAndValue) *BatchAttachTypedLink {
	s.Attributes = v
	return s
}

// SetSourceObjectReference sets the SourceObjectReference field's value.
func (s *BatchAttachTypedLink) SetSourceObjectReference(v *ObjectReference) *BatchAttachTypedLink {
	s.SourceObjectReference = v
	return s
}

// SetTargetObjectReference sets the TargetObjectReference field's value.
func (s *BatchAttachTypedLink) SetTargetObjectReference(v *ObjectReference) *BatchAttachTypedLink {
	s.TargetObjectReference = v
	return s
}

// SetTypedLinkFacet sets the TypedLinkFacet field's value.
func (s *BatchAttachTypedLink) SetTypedLinkFacet(v *TypedLinkSchemaAndFacetName) *BatchAttachTypedLink {
	s.TypedLinkFacet = v
	return s
}

// Represents the output of a AttachTypedLink response operation.
type BatchAttachTypedLinkResponse struct {
	_ struct{} `type:"structure"`

	// Returns a typed link specifier as output.
	TypedLinkSpecifier *TypedLinkSpecifier `type:"structure"`
}

// String returns the string representation
func (s BatchAttachTypedLinkResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchAttachTypedLinkResponse) GoString() string {
	return s.String()
}

// SetTypedLinkSpecifier sets the TypedLinkSpecifier field's value.
func (s *BatchAttachTypedLinkResponse) SetTypedLinkSpecifier(v *TypedLinkSpecifier) *BatchAttachTypedLinkResponse {
	s.TypedLinkSpecifier = v
	return s
}

// Creates an index object inside of a BatchRead operation. For more information,
// see CreateIndex and BatchReadRequest$Operations.
type BatchCreateIndex struct {
	_ struct{} `type:"structure"`

	// The batch reference name. See Batches (http://docs.aws.amazon.com/directoryservice/latest/admin-guide/cd_advanced.html#batches)
	// for more information.
	BatchReferenceName *string `type:"string"`

	// Indicates whether the attribute that is being indexed has unique values or
	// not.
	//
	// IsUnique is a required field
	IsUnique *bool `type:"boolean" required:"true"`

	// The name of the link between the parent object and the index object.
	LinkName *string `min:"1" type:"string"`

	// Specifies the attributes that should be indexed on. Currently only a single
	// attribute is supported.
	//
	// OrderedIndexedAttributeList is a required field
	OrderedIndexedAttributeList []*AttributeKey `type:"list" required:"true"`

	// A reference to the parent object that contains the index object.
	ParentReference *ObjectReference `type:"structure"`
}

// String returns the string representation
func (s BatchCreateIndex) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchCreateIndex) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchCreateIndex) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchCreateIndex"}
	if s.IsUnique == nil {
		invalidParams.Add(request.NewErrParamRequired("IsUnique"))
	}
	if s.LinkName != nil && len(*s.LinkName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LinkName", 1))
	}
	if s.OrderedIndexedAttributeList == nil {
		invalidParams.Add(request.NewErrParamRequired("OrderedIndexedAttributeList"))
	}
	if s.OrderedIndexedAttributeList != nil {
		for i, v := range s.OrderedIndexedAttributeList {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "OrderedIndexedAttributeList", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBatchReferenceName sets the BatchReferenceName field's value.
func (s *BatchCreateIndex) SetBatchReferenceName(v string) *BatchCreateIndex {
	s.BatchReferenceName = &v
	return s
}

// SetIsUnique sets the IsUnique field's value.
func (s *BatchCreateIndex) SetIsUnique(v bool) *BatchCreateIndex {
	s.IsUnique = &v
	return s
}

// SetLinkName sets the LinkName field's value.
func (s *BatchCreateIndex) SetLinkName(v string) *BatchCreateIndex {
	s.LinkName = &v
	return s
}

// SetOrderedIndexedAttributeList sets the OrderedIndexedAttributeList field's value.
func (s *BatchCreateIndex) SetOrderedIndexedAttributeList(v []*AttributeKey) *BatchCreateIndex {
	s.OrderedIndexedAttributeList = v
	return s
}

// SetParentReference sets the ParentReference field's value.
func (s *BatchCreateIndex) SetParentReference(v *ObjectReference) *BatchCreateIndex {
	s.ParentReference = v
	return s
}

// Represents the output of a CreateIndex response operation.
type BatchCreateIndexResponse struct {
	_ struct{} `type:"structure"`

	// The ObjectIdentifier of the index created by this operation.
	ObjectIdentifier *string `type:"string"`
}

// String returns the string representation
func (s BatchCreateIndexResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchCreateIndexResponse) GoString() string {
	return s.String()
}

// SetObjectIdentifier sets the ObjectIdentifier field's value.
func (s *BatchCreateIndexResponse) SetObjectIdentifier(v string) *BatchCreateIndexResponse {
	s.ObjectIdentifier = &v
	return s
}

// Represents the output of a CreateObject operation.
type BatchCreateObject struct {
	_ struct{} `type:"structure"`

	// The batch reference name. See Batches (http://docs.aws.amazon.com/directoryservice/latest/admin-guide/cd_advanced.html#batches)
	// for more information.
	BatchReferenceName *string `type:"string"`

	// The name of the link.
	LinkName *string `min:"1" type:"string"`

	// An attribute map, which contains an attribute ARN as the key and attribute
	// value as the map value.
	//
	// ObjectAttributeList is a required field
	ObjectAttributeList []*AttributeKeyAndValue `type:"list" required:"true"`

	// If specified, the parent reference to which this object will be attached.
	ParentReference *ObjectReference `type:"structure"`

	// A list of FacetArns that will be associated with the object. For more information,
	// see arns.
	//
	// SchemaFacet is a required field
	SchemaFacet []*SchemaFacet `type:"list" required:"true"`
}

// String returns the string representation
func (s BatchCreateObject) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchCreateObject) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchCreateObject) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchCreateObject"}
	if s.LinkName != nil && len(*s.LinkName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LinkName", 1))
	}
	if s.ObjectAttributeList == nil {
		invalidParams.Add(request.NewErrParamRequired("ObjectAttributeList"))
	}
	if s.SchemaFacet == nil {
		invalidParams.Add(request.NewErrParamRequired("SchemaFacet"))
	}
	if s.ObjectAttributeList != nil {
		for i, v := range s.ObjectAttributeList {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ObjectAttributeList", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.SchemaFacet != nil {
		for i, v := range s.SchemaFacet {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "SchemaFacet", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBatchReferenceName sets the BatchReferenceName field's value.
func (s *BatchCreateObject) SetBatchReferenceName(v string) *BatchCreateObject {
	s.BatchReferenceName = &v
	return s
}

// SetLinkName sets the LinkName field's value.
func (s *BatchCreateObject) SetLinkName(v string) *BatchCreateObject {
	s.LinkName = &v
	return s
}

// SetObjectAttributeList sets the ObjectAttributeList field's value.
func (s *BatchCreateObject) SetObjectAttributeList(v []*AttributeKeyAndValue) *BatchCreateObject {
	s.ObjectAttributeList = v
	return s
}

// SetParentReference sets the ParentReference field's value.
func (s *BatchCreateObject) SetParentReference(v *ObjectReference) *BatchCreateObject {
	s.ParentReference = v
	return s
}

// SetSchemaFacet sets the SchemaFacet field's value.
func (s *BatchCreateObject) SetSchemaFacet(v []*SchemaFacet) *BatchCreateObject {
	s.SchemaFacet = v
	return s
}

// Represents the output of a CreateObject response operation.
type BatchCreateObjectResponse struct {
	_ struct{} `type:"structure"`

	// The ID that is associated with the object.
	ObjectIdentifier *string `type:"string"`
}

// String returns the string representation
func (s BatchCreateObjectResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchCreateObjectResponse) GoString() string {
	return s.String()
}

// SetObjectIdentifier sets the ObjectIdentifier field's value.
func (s *BatchCreateObjectResponse) SetObjectIdentifier(v string) *BatchCreateObjectResponse {
	s.ObjectIdentifier = &v
	return s
}

// Represents the output of a DeleteObject operation.
type BatchDeleteObject struct {
	_ struct{} `type:"structure"`

	// The reference that identifies the object.
	//
	// ObjectReference is a required field
	ObjectReference *ObjectReference `type:"structure" required:"true"`
}

// String returns the string representation
func (s BatchDeleteObject) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchDeleteObject) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchDeleteObject) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchDeleteObject"}
	if s.ObjectReference == nil {
		invalidParams.Add(request.NewErrParamRequired("ObjectReference"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetObjectReference sets the ObjectReference field's value.
func (s *BatchDeleteObject) SetObjectReference(v *ObjectReference) *BatchDeleteObject {
	s.ObjectReference = v
	return s
}

// Represents the output of a DeleteObject response operation.
type BatchDeleteObjectResponse struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s BatchDeleteObjectResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchDeleteObjectResponse) GoString() string {
	return s.String()
}

// Detaches the specified object from the specified index inside a BatchRead
// operation. For more information, see DetachFromIndex and BatchReadRequest$Operations.
type BatchDetachFromIndex struct {
	_ struct{} `type:"structure"`

	// A reference to the index object.
	//
	// IndexReference is a required field
	IndexReference *ObjectReference `type:"structure" required:"true"`

	// A reference to the object being detached from the index.
	//
	// TargetReference is a required field
	TargetReference *ObjectReference `type:"structure" required:"true"`
}

// String returns the string representation
func (s BatchDetachFromIndex) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchDetachFromIndex) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchDetachFromIndex) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchDetachFromIndex"}
	if s.IndexReference == nil {
		invalidParams.Add(request.NewErrParamRequired("IndexReference"))
	}
	if s.TargetReference == nil {
		invalidParams.Add(request.NewErrParamRequired("TargetReference"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIndexReference sets the IndexReference field's value.
func (s *BatchDetachFromIndex) SetIndexReference(v *ObjectReference) *BatchDetachFromIndex {
	s.IndexReference = v
	return s
}

// SetTargetReference sets the TargetReference field's value.
func (s *BatchDetachFromIndex) SetTargetReference(v *ObjectReference) *BatchDetachFromIndex {
	s.TargetReference = v
	return s
}

// Represents the output of a DetachFromIndex response operation.
type BatchDetachFromIndexResponse struct {
	_ struct{} `type:"structure"`

	// The ObjectIdentifier of the object that was detached from the index.
	DetachedObjectIdentifier *string `type:"string"`
}

// String returns the string representation
func (s BatchDetachFromIndexResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchDetachFromIndexResponse) GoString() string {
	return s.String()
}

// SetDetachedObjectIdentifier sets the DetachedObjectIdentifier field's value.
func (s *BatchDetachFromIndexResponse) SetDetachedObjectIdentifier(v string) *BatchDetachFromIndexResponse {
	s.DetachedObjectIdentifier = &v
	return s
}

// Represents the output of a DetachObject operation.
type BatchDetachObject struct {
	_ struct{} `type:"structure"`

	// The batch reference name. See Batches (http://docs.aws.amazon.com/directoryservice/latest/admin-guide/cd_advanced.html#batches)
	// for more information.
	BatchReferenceName *string `type:"string"`

	// The name of the link.
	//
	// LinkName is a required field
	LinkName *string `min:"1" type:"string" required:"true"`

	// Parent reference from which the object with the specified link name is detached.
	//
	// ParentReference is a required field
	ParentReference *ObjectReference `type:"structure" required:"true"`
}

// String returns the string representation
func (s BatchDetachObject) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchDetachObject) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchDetachObject) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchDetachObject"}
	if s.LinkName == nil {
		invalidParams.Add(request.NewErrParamRequired("LinkName"))
	}
	if s.LinkName != nil && len(*s.LinkName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LinkName", 1))
	}
	if s.ParentReference == nil {
		invalidParams.Add(request.NewErrParamRequired("ParentReference"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBatchReferenceName sets the BatchReferenceName field's value.
func (s *BatchDetachObject) SetBatchReferenceName(v string) *BatchDetachObject {
	s.BatchReferenceName = &v
	return s
}

// SetLinkName sets the LinkName field's value.
func (s *BatchDetachObject) SetLinkName(v string) *BatchDetachObject {
	s.LinkName = &v
	return s
}

// SetParentReference sets the ParentReference field's value.
func (s *BatchDetachObject) SetParentReference(v *ObjectReference) *BatchDetachObject {
	s.ParentReference = v
	return s
}

// Represents the output of a DetachObject response operation.
type BatchDetachObjectResponse struct {
	_ struct{} `type:"structure"`

	// The ObjectIdentifier of the detached object.
	DetachedObjectIdentifier *string `locationName:"detachedObjectIdentifier" type:"string"`
}

// String returns the string representation
func (s BatchDetachObjectResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchDetachObjectResponse) GoString() string {
	return s.String()
}

// SetDetachedObjectIdentifier sets the DetachedObjectIdentifier field's value.
func (s *BatchDetachObjectResponse) SetDetachedObjectIdentifier(v string) *BatchDetachObjectResponse {
	s.DetachedObjectIdentifier = &v
	return s
}

// Detaches the specified policy from the specified directory inside a BatchWrite
// operation. For more information, see DetachPolicy and BatchWriteRequest$Operations.
type BatchDetachPolicy struct {
	_ struct{} `type:"structure"`

	// Reference that identifies the object whose policy object will be detached.
	//
	// ObjectReference is a required field
	ObjectReference *ObjectReference `type:"structure" required:"true"`

	// Reference that identifies the policy object.
	//
	// PolicyReference is a required field
	PolicyReference *ObjectReference `type:"structure" required:"true"`
}

// String returns the string representation
func (s BatchDetachPolicy) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchDetachPolicy) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchDetachPolicy) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchDetachPolicy"}
	if s.ObjectReference == nil {
		invalidParams.Add(request.NewErrParamRequired("ObjectReference"))
	}
	if s.PolicyReference == nil {
		invalidParams.Add(request.NewErrParamRequired("PolicyReference"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetObjectReference sets the ObjectReference field's value.
func (s *BatchDetachPolicy) SetObjectReference(v *ObjectReference) *BatchDetachPolicy {
	s.ObjectReference = v
	return s
}

// SetPolicyReference sets the PolicyReference field's value.
func (s *BatchDetachPolicy) SetPolicyReference(v *ObjectReference) *BatchDetachPolicy {
	s.PolicyReference = v
	return s
}

// Represents the output of a DetachPolicy response operation.
type BatchDetachPolicyResponse struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s BatchDetachPolicyResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchDetachPolicyResponse) GoString() string {
	return s.String()
}

// Detaches a typed link from a specified source and target object inside a
// BatchRead operation. For more information, see DetachTypedLink and BatchReadRequest$Operations.
type BatchDetachTypedLink struct {
	_ struct{} `type:"structure"`

	// Used to accept a typed link specifier as input.
	//
	// TypedLinkSpecifier is a required field
	TypedLinkSpecifier *TypedLinkSpecifier `type:"structure" required:"true"`
}

// String returns the string representation
func (s BatchDetachTypedLink) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchDetachTypedLink) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchDetachTypedLink) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchDetachTypedLink"}
	if s.TypedLinkSpecifier == nil {
		invalidParams.Add(request.NewErrParamRequired("TypedLinkSpecifier"))
	}
	if s.TypedLinkSpecifier != nil {
		if err := s.TypedLinkSpecifier.Validate(); err != nil {
			invalidParams.AddNested("TypedLinkSpecifier", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTypedLinkSpecifier sets the TypedLinkSpecifier field's value.
func (s *BatchDetachTypedLink) SetTypedLinkSpecifier(v *TypedLinkSpecifier) *BatchDetachTypedLink {
	s.TypedLinkSpecifier = v
	return s
}

// Represents the output of a DetachTypedLink response operation.
type BatchDetachTypedLinkResponse struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s BatchDetachTypedLinkResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchDetachTypedLinkResponse) GoString() string {
	return s.String()
}

// Retrieves attributes within a facet that are associated with an object inside
// an BatchRead operation. For more information, see GetObjectAttributes and
// BatchReadRequest$Operations.
type BatchGetObjectAttributes struct {
	_ struct{} `type:"structure"`

	// List of attribute names whose values will be retrieved.
	//
	// AttributeNames is a required field
	AttributeNames []*string `type:"list" required:"true"`

	// Reference that identifies the object whose attributes will be retrieved.
	//
	// ObjectReference is a required field
	ObjectReference *ObjectReference `type:"structure" required:"true"`

	// Identifier for the facet whose attributes will be retrieved. See SchemaFacet
	// for details.
	//
	// SchemaFacet is a required field
	SchemaFacet *SchemaFacet `type:"structure" required:"true"`
}

// String returns the string representation
func (s BatchGetObjectAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchGetObjectAttributes) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchGetObjectAttributes) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchGetObjectAttributes"}
	if s.AttributeNames == nil {
		invalidParams.Add(request.NewErrParamRequired("AttributeNames"))
	}
	if s.ObjectReference == nil {
		invalidParams.Add(request.NewErrParamRequired("ObjectReference"))
	}
	if s.SchemaFacet == nil {
		invalidParams.Add(request.NewErrParamRequired("SchemaFacet"))
	}
	if s.SchemaFacet != nil {
		if err := s.SchemaFacet.Validate(); err != nil {
			invalidParams.AddNested("SchemaFacet", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAttributeNames sets the AttributeNames field's value.
func (s *BatchGetObjectAttributes) SetAttributeNames(v []*string) *BatchGetObjectAttributes {
	s.AttributeNames = v
	return s
}

// SetObjectReference sets the ObjectReference field's value.
func (s *BatchGetObjectAttributes) SetObjectReference(v *ObjectReference) *BatchGetObjectAttributes {
	s.ObjectReference = v
	return s
}

// SetSchemaFacet sets the SchemaFacet field's value.
func (s *BatchGetObjectAttributes) SetSchemaFacet(v *SchemaFacet) *BatchGetObjectAttributes {
	s.SchemaFacet = v
	return s
}

// Represents the output of a GetObjectAttributes response operation.
type BatchGetObjectAttributesResponse struct {
	_ struct{} `type:"structure"`

	// The attribute values that are associated with an object.
	Attributes []*AttributeKeyAndValue `type:"list"`
}

// String returns the string representation
func (s BatchGetObjectAttributesResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchGetObjectAttributesResponse) GoString() string {
	return s.String()
}

// SetAttributes sets the Attributes field's value.
func (s *BatchGetObjectAttributesResponse) SetAttributes(v []*AttributeKeyAndValue) *BatchGetObjectAttributesResponse {
	s.Attributes = v
	return s
}

// Retrieves metadata about an object inside a BatchRead operation. For more
// information, see GetObjectInformation and BatchReadRequest$Operations.
type BatchGetObjectInformation struct {
	_ struct{} `type:"structure"`

	// A reference to the object.
	//
	// ObjectReference is a required field
	ObjectReference *ObjectReference `type:"structure" required:"true"`
}

// String returns the string representation
func (s BatchGetObjectInformation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchGetObjectInformation) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchGetObjectInformation) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchGetObjectInformation"}
	if s.ObjectReference == nil {
		invalidParams.Add(request.NewErrParamRequired("ObjectReference"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetObjectReference sets the ObjectReference field's value.
func (s *BatchGetObjectInformation) SetObjectReference(v *ObjectReference) *BatchGetObjectInformation {
	s.ObjectReference = v
	return s
}

// Represents the output of a GetObjectInformation response operation.
type BatchGetObjectInformationResponse struct {
	_ struct{} `type:"structure"`

	// The ObjectIdentifier of the specified object.
	ObjectIdentifier *string `type:"string"`

	// The facets attached to the specified object.
	SchemaFacets []*SchemaFacet `type:"list"`
}

// String returns the string representation
func (s BatchGetObjectInformationResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchGetObjectInformationResponse) GoString() string {
	return s.String()
}

// SetObjectIdentifier sets the ObjectIdentifier field's value.
func (s *BatchGetObjectInformationResponse) SetObjectIdentifier(v string) *BatchGetObjectInformationResponse {
	s.ObjectIdentifier = &v
	return s
}

// SetSchemaFacets sets the SchemaFacets field's value.
func (s *BatchGetObjectInformationResponse) SetSchemaFacets(v []*SchemaFacet) *BatchGetObjectInformationResponse {
	s.SchemaFacets = v
	return s
}

// Lists indices attached to an object inside a BatchRead operation. For more
// information, see ListAttachedIndices and BatchReadRequest$Operations.
type BatchListAttachedIndices struct {
	_ struct{} `type:"structure"`

	// The maximum number of results to retrieve.
	MaxResults *int64 `min:"1" type:"integer"`

	// The pagination token.
	NextToken *string `type:"string"`

	// A reference to the object that has indices attached.
	//
	// TargetReference is a required field
	TargetReference *ObjectReference `type:"structure" required:"true"`
}

// String returns the string representation
func (s BatchListAttachedIndices) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchListAttachedIndices) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchListAttachedIndices) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchListAttachedIndices"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.TargetReference == nil {
		invalidParams.Add(request.NewErrParamRequired("TargetReference"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *BatchListAttachedIndices) SetMaxResults(v int64) *BatchListAttachedIndices {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *BatchListAttachedIndices) SetNextToken(v string) *BatchListAttachedIndices {
	s.NextToken = &v
	return s
}

// SetTargetReference sets the TargetReference field's value.
func (s *BatchListAttachedIndices) SetTargetReference(v *ObjectReference) *BatchListAttachedIndices {
	s.TargetReference = v
	return s
}

// Represents the output of a ListAttachedIndices response operation.
type BatchListAttachedIndicesResponse struct {
	_ struct{} `type:"structure"`

	// The indices attached to the specified object.
	IndexAttachments []*IndexAttachment `type:"list"`

	// The pagination token.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s BatchListAttachedIndicesResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchListAttachedIndicesResponse) GoString() string {
	return s.String()
}

// SetIndexAttachments sets the IndexAttachments field's value.
func (s *BatchListAttachedIndicesResponse) SetIndexAttachments(v []*IndexAttachment) *BatchListAttachedIndicesResponse {
	s.IndexAttachments = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *BatchListAttachedIndicesResponse) SetNextToken(v string) *BatchListAttachedIndicesResponse {
	s.NextToken = &v
	return s
}

// Returns a paginated list of all the incoming TypedLinkSpecifier information
// for an object inside a BatchRead operation. For more information, see ListIncomingTypedLinks
// and BatchReadRequest$Operations.
type BatchListIncomingTypedLinks struct {
	_ struct{} `type:"structure"`

	// Provides range filters for multiple attributes. When providing ranges to
	// typed link selection, any inexact ranges must be specified at the end. Any
	// attributes that do not have a range specified are presumed to match the entire
	// range.
	FilterAttributeRanges []*TypedLinkAttributeRange `type:"list"`

	// Filters are interpreted in the order of the attributes on the typed link
	// facet, not the order in which they are supplied to any API calls.
	FilterTypedLink *TypedLinkSchemaAndFacetName `type:"structure"`

	// The maximum number of results to retrieve.
	MaxResults *int64 `min:"1" type:"integer"`

	// The pagination token.
	NextToken *string `type:"string"`

	// The reference that identifies the object whose attributes will be listed.
	//
	// ObjectReference is a required field
	ObjectReference *ObjectReference `type:"structure" required:"true"`
}

// String returns the string representation
func (s BatchListIncomingTypedLinks) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchListIncomingTypedLinks) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchListIncomingTypedLinks) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchListIncomingTypedLinks"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.ObjectReference == nil {
		invalidParams.Add(request.NewErrParamRequired("ObjectReference"))
	}
	if s.FilterAttributeRanges != nil {
		for i, v := range s.FilterAttributeRanges {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "FilterAttributeRanges", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.FilterTypedLink != nil {
		if err := s.FilterTypedLink.Validate(); err != nil {
			invalidParams.AddNested("FilterTypedLink", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilterAttributeRanges sets the FilterAttributeRanges field's value.
func (s *BatchListIncomingTypedLinks) SetFilterAttributeRanges(v []*TypedLinkAttributeRange) *BatchListIncomingTypedLinks {
	s.FilterAttributeRanges = v
	return s
}

// SetFilterTypedLink sets the FilterTypedLink field's value.
func (s *BatchListIncomingTypedLinks) SetFilterTypedLink(v *TypedLinkSchemaAndFacetName) *BatchListIncomingTypedLinks {
	s.FilterTypedLink = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *BatchListIncomingTypedLinks) SetMaxResults(v int64) *BatchListIncomingTypedLinks {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *BatchListIncomingTypedLinks) SetNextToken(v string) *BatchListIncomingTypedLinks {
	s.NextToken = &v
	return s
}

// SetObjectReference sets the ObjectReference field's value.
func (s *BatchListIncomingTypedLinks) SetObjectReference(v *ObjectReference) *BatchListIncomingTypedLinks {
	s.ObjectReference = v
	return s
}

// Represents the output of a ListIncomingTypedLinks response operation.
type BatchListIncomingTypedLinksResponse struct {
	_ struct{} `type:"structure"`

	// Returns one or more typed link specifiers as output.
	LinkSpecifiers []*TypedLinkSpecifier `type:"list"`

	// The pagination token.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s BatchListIncomingTypedLinksResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchListIncomingTypedLinksResponse) GoString() string {
	return s.String()
}

// SetLinkSpecifiers sets the LinkSpecifiers field's value.
func (s *BatchListIncomingTypedLinksResponse) SetLinkSpecifiers(v []*TypedLinkSpecifier) *BatchListIncomingTypedLinksResponse {
	s.LinkSpecifiers = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *BatchListIncomingTypedLinksResponse) SetNextToken(v string) *BatchListIncomingTypedLinksResponse {
	s.NextToken = &v
	return s
}

// Lists objects attached to the specified index inside a BatchRead operation.
// For more information, see ListIndex and BatchReadRequest$Operations.
type BatchListIndex struct {
	_ struct{} `type:"structure"`

	// The reference to the index to list.
	//
	// IndexReference is a required field
	IndexReference *ObjectReference `type:"structure" required:"true"`

	// The maximum number of results to retrieve.
	MaxResults *int64 `min:"1" type:"integer"`

	// The pagination token.
	NextToken *string `type:"string"`

	// Specifies the ranges of indexed values that you want to query.
	RangesOnIndexedValues []*ObjectAttributeRange `type:"list"`
}

// String returns the string representation
func (s BatchListIndex) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchListIndex) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchListIndex) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchListIndex"}
	if s.IndexReference == nil {
		invalidParams.Add(request.NewErrParamRequired("IndexReference"))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.RangesOnIndexedValues != nil {
		for i, v := range s.RangesOnIndexedValues {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "RangesOnIndexedValues", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIndexReference sets the IndexReference field's value.
func (s *BatchListIndex) SetIndexReference(v *ObjectReference) *BatchListIndex {
	s.IndexReference = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *BatchListIndex) SetMaxResults(v int64) *BatchListIndex {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *BatchListIndex) SetNextToken(v string) *BatchListIndex {
	s.NextToken = &v
	return s
}

// SetRangesOnIndexedValues sets the RangesOnIndexedValues field's value.
func (s *BatchListIndex) SetRangesOnIndexedValues(v []*ObjectAttributeRange) *BatchListIndex {
	s.RangesOnIndexedValues = v
	return s
}

// Represents the output of a ListIndex response operation.
type BatchListIndexResponse struct {
	_ struct{} `type:"structure"`

	// The objects and indexed values attached to the index.
	IndexAttachments []*IndexAttachment `type:"list"`

	// The pagination token.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s BatchListIndexResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchListIndexResponse) GoString() string {
	return s.String()
}

// SetIndexAttachments sets the IndexAttachments field's value.
func (s *BatchListIndexResponse) SetIndexAttachments(v []*IndexAttachment) *BatchListIndexResponse {
	s.IndexAttachments = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *BatchListIndexResponse) SetNextToken(v string) *BatchListIndexResponse {
	s.NextToken = &v
	return s
}

// Represents the output of a ListObjectAttributes operation.
type BatchListObjectAttributes struct {
	_ struct{} `type:"structure"`

	// Used to filter the list of object attributes that are associated with a certain
	// facet.
	FacetFilter *SchemaFacet `type:"structure"`

	// The maximum number of items to be retrieved in a single call. This is an
	// approximate number.
	MaxResults *int64 `min:"1" type:"integer"`

	// The pagination token.
	NextToken *string `type:"string"`

	// Reference of the object whose attributes need to be listed.
	//
	// ObjectReference is a required field
	ObjectReference *ObjectReference `type:"structure" required:"true"`
}

// String returns the string representation
func (s BatchListObjectAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchListObjectAttributes) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchListObjectAttributes) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchListObjectAttributes"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.ObjectReference == nil {
		invalidParams.Add(request.NewErrParamRequired("ObjectReference"))
	}
	if s.FacetFilter != nil {
		if err := s.FacetFilter.Validate(); err != nil {
			invalidParams.AddNested("FacetFilter", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFacetFilter sets the FacetFilter field's value.
func (s *BatchListObjectAttributes) SetFacetFilter(v *SchemaFacet) *BatchListObjectAttributes {
	s.FacetFilter = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *BatchListObjectAttributes) SetMaxResults(v int64) *BatchListObjectAttributes {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *BatchListObjectAttributes) SetNextToken(v string) *BatchListObjectAttributes {
	s.NextToken = &v
	return s
}

// SetObjectReference sets the ObjectReference field's value.
func (s *BatchListObjectAttributes) SetObjectReference(v *ObjectReference) *BatchListObjectAttributes {
	s.ObjectReference = v
	return s
}

// Represents the output of a ListObjectAttributes response operation.
type BatchListObjectAttributesResponse struct {
	_ struct{} `type:"structure"`

	// The attributes map that is associated with the object. AttributeArn is the
	// key; attribute value is the value.
	Attributes []*AttributeKeyAndValue `type:"list"`

	// The pagination token.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s BatchListObjectAttributesResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchListObjectAttributesResponse) GoString() string {
	return s.String()
}

// SetAttributes sets the Attributes field's value.
func (s *BatchListObjectAttributesResponse) SetAttributes(v []*AttributeKeyAndValue) *BatchListObjectAttributesResponse {
	s.Attributes = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *BatchListObjectAttributesResponse) SetNextToken(v string) *BatchListObjectAttributesResponse {
	s.NextToken = &v
	return s
}

// Represents the output of a ListObjectChildren operation.
type BatchListObjectChildren struct {
	_ struct{} `type:"structure"`

	// Maximum number of items to be retrieved in a single call. This is an approximate
	// number.
	MaxResults *int64 `min:"1" type:"integer"`

	// The pagination token.
	NextToken *string `type:"string"`

	// Reference of the object for which child objects are being listed.
	//
	// ObjectReference is a required field
	ObjectReference *ObjectReference `type:"structure" required:"true"`
}

// String returns the string representation
func (s BatchListObjectChildren) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchListObjectChildren) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchListObjectChildren) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchListObjectChildren"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.ObjectReference == nil {
		invalidParams.Add(request.NewErrParamRequired("ObjectReference"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *BatchListObjectChildren) SetMaxResults(v int64) *BatchListObjectChildren {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *BatchListObjectChildren) SetNextToken(v string) *BatchListObjectChildren {
	s.NextToken = &v
	return s
}

// SetObjectReference sets the ObjectReference field's value.
func (s *BatchListObjectChildren) SetObjectReference(v *ObjectReference) *BatchListObjectChildren {
	s.ObjectReference = v
	return s
}

// Represents the output of a ListObjectChildren response operation.
type BatchListObjectChildrenResponse struct {
	_ struct{} `type:"structure"`

	// The children structure, which is a map with the key as the LinkName and ObjectIdentifier
	// as the value.
	Children map[string]*string `type:"map"`

	// The pagination token.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s BatchListObjectChildrenResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchListObjectChildrenResponse) GoString() string {
	return s.String()
}

// SetChildren sets the Children field's value.
func (s *BatchListObjectChildrenResponse) SetChildren(v map[string]*string) *BatchListObjectChildrenResponse {
	s.Children = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *BatchListObjectChildrenResponse) SetNextToken(v string) *BatchListObjectChildrenResponse {
	s.NextToken = &v
	return s
}

// Retrieves all available parent paths for any object type such as node, leaf
// node, policy node, and index node objects inside a BatchRead operation. For
// more information, see ListObjectParentPaths and BatchReadRequest$Operations.
type BatchListObjectParentPaths struct {
	_ struct{} `type:"structure"`

	// The maximum number of results to retrieve.
	MaxResults *int64 `min:"1" type:"integer"`

	// The pagination token.
	NextToken *string `type:"string"`

	// The reference that identifies the object whose attributes will be listed.
	//
	// ObjectReference is a required field
	ObjectReference *ObjectReference `type:"structure" required:"true"`
}

// String returns the string representation
func (s BatchListObjectParentPaths) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchListObjectParentPaths) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchListObjectParentPaths) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchListObjectParentPaths"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.ObjectReference == nil {
		invalidParams.Add(request.NewErrParamRequired("ObjectReference"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *BatchListObjectParentPaths) SetMaxResults(v int64) *BatchListObjectParentPaths {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *BatchListObjectParentPaths) SetNextToken(v string) *BatchListObjectParentPaths {
	s.NextToken = &v
	return s
}

// SetObjectReference sets the ObjectReference field's value.
func (s *BatchListObjectParentPaths) SetObjectReference(v *ObjectReference) *BatchListObjectParentPaths {
	s.ObjectReference = v
	return s
}

// Represents the output of a ListObjectParentPaths response operation.
type BatchListObjectParentPathsResponse struct {
	_ struct{} `type:"structure"`

	// The pagination token.
	NextToken *string `type:"string"`

	// Returns the path to the ObjectIdentifiers that are associated with the directory.
	PathToObjectIdentifiersList []*PathToObjectIdentifiers `type:"list"`
}

// String returns the string representation
func (s BatchListObjectParentPathsResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchListObjectParentPathsResponse) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *BatchListObjectParentPathsResponse) SetNextToken(v string) *BatchListObjectParentPathsResponse {
	s.NextToken = &v
	return s
}

// SetPathToObjectIdentifiersList sets the PathToObjectIdentifiersList field's value.
func (s *BatchListObjectParentPathsResponse) SetPathToObjectIdentifiersList(v []*PathToObjectIdentifiers) *BatchListObjectParentPathsResponse {
	s.PathToObjectIdentifiersList = v
	return s
}

// Returns policies attached to an object in pagination fashion inside a BatchRead
// operation. For more information, see ListObjectPolicies and BatchReadRequest$Operations.
type BatchListObjectPolicies struct {
	_ struct{} `type:"structure"`

	// The maximum number of results to retrieve.
	MaxResults *int64 `min:"1" type:"integer"`

	// The pagination token.
	NextToken *string `type:"string"`

	// The reference that identifies the object whose attributes will be listed.
	//
	// ObjectReference is a required field
	ObjectReference *ObjectReference `type:"structure" required:"true"`
}

// String returns the string representation
func (s BatchListObjectPolicies) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchListObjectPolicies) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchListObjectPolicies) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchListObjectPolicies"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.ObjectReference == nil {
		invalidParams.Add(request.NewErrParamRequired("ObjectReference"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *BatchListObjectPolicies) SetMaxResults(v int64) *BatchListObjectPolicies {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *BatchListObjectPolicies) SetNextToken(v string) *BatchListObjectPolicies {
	s.NextToken = &v
	return s
}

// SetObjectReference sets the ObjectReference field's value.
func (s *BatchListObjectPolicies) SetObjectReference(v *ObjectReference) *BatchListObjectPolicies {
	s.ObjectReference = v
	return s
}

// Represents the output of a ListObjectPolicies response operation.
type BatchListObjectPoliciesResponse struct {
	_ struct{} `type:"structure"`

	// A list of policy ObjectIdentifiers, that are attached to the object.
	AttachedPolicyIds []*string `type:"list"`

	// The pagination token.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s BatchListObjectPoliciesResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchListObjectPoliciesResponse) GoString() string {
	return s.String()
}

// SetAttachedPolicyIds sets the AttachedPolicyIds field's value.
func (s *BatchListObjectPoliciesResponse) SetAttachedPolicyIds(v []*string) *BatchListObjectPoliciesResponse {
	s.AttachedPolicyIds = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *BatchListObjectPoliciesResponse) SetNextToken(v string) *BatchListObjectPoliciesResponse {
	s.NextToken = &v
	return s
}

// Returns a paginated list of all the outgoing TypedLinkSpecifier information
// for an object inside a BatchRead operation. For more information, see ListOutgoingTypedLinks
// and BatchReadRequest$Operations.
type BatchListOutgoingTypedLinks struct {
	_ struct{} `type:"structure"`

	// Provides range filters for multiple attributes. When providing ranges to
	// typed link selection, any inexact ranges must be specified at the end. Any
	// attributes that do not have a range specified are presumed to match the entire
	// range.
	FilterAttributeRanges []*TypedLinkAttributeRange `type:"list"`

	// Filters are interpreted in the order of the attributes defined on the typed
	// link facet, not the order they are supplied to any API calls.
	FilterTypedLink *TypedLinkSchemaAndFacetName `type:"structure"`

	// The maximum number of results to retrieve.
	MaxResults *int64 `min:"1" type:"integer"`

	// The pagination token.
	NextToken *string `type:"string"`

	// The reference that identifies the object whose attributes will be listed.
	//
	// ObjectReference is a required field
	ObjectReference *ObjectReference `type:"structure" required:"true"`
}

// String returns the string representation
func (s BatchListOutgoingTypedLinks) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchListOutgoingTypedLinks) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchListOutgoingTypedLinks) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchListOutgoingTypedLinks"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.ObjectReference == nil {
		invalidParams.Add(request.NewErrParamRequired("ObjectReference"))
	}
	if s.FilterAttributeRanges != nil {
		for i, v := range s.FilterAttributeRanges {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "FilterAttributeRanges", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.FilterTypedLink != nil {
		if err := s.FilterTypedLink.Validate(); err != nil {
			invalidParams.AddNested("FilterTypedLink", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilterAttributeRanges sets the FilterAttributeRanges field's value.
func (s *BatchListOutgoingTypedLinks) SetFilterAttributeRanges(v []*TypedLinkAttributeRange) *BatchListOutgoingTypedLinks {
	s.FilterAttributeRanges = v
	return s
}

// SetFilterTypedLink sets the FilterTypedLink field's value.
func (s *BatchListOutgoingTypedLinks) SetFilterTypedLink(v *TypedLinkSchemaAndFacetName) *BatchListOutgoingTypedLinks {
	s.FilterTypedLink = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *BatchListOutgoingTypedLinks) SetMaxResults(v int64) *BatchListOutgoingTypedLinks {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *BatchListOutgoingTypedLinks) SetNextToken(v string) *BatchListOutgoingTypedLinks {
	s.NextToken = &v
	return s
}

// SetObjectReference sets the ObjectReference field's value.
func (s *BatchListOutgoingTypedLinks) SetObjectReference(v *ObjectReference) *BatchListOutgoingTypedLinks {
	s.ObjectReference = v
	return s
}

// Represents the output of a ListOutgoingTypedLinks response operation.
type BatchListOutgoingTypedLinksResponse struct {
	_ struct{} `type:"structure"`

	// The pagination token.
	NextToken *string `type:"string"`

	// Returns a typed link specifier as output.
	TypedLinkSpecifiers []*TypedLinkSpecifier `type:"list"`
}

// String returns the string representation
func (s BatchListOutgoingTypedLinksResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchListOutgoingTypedLinksResponse) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *BatchListOutgoingTypedLinksResponse) SetNextToken(v string) *BatchListOutgoingTypedLinksResponse {
	s.NextToken = &v
	return s
}

// SetTypedLinkSpecifiers sets the TypedLinkSpecifiers field's value.
func (s *BatchListOutgoingTypedLinksResponse) SetTypedLinkSpecifiers(v []*TypedLinkSpecifier) *BatchListOutgoingTypedLinksResponse {
	s.TypedLinkSpecifiers = v
	return s
}

// Returns all of the ObjectIdentifiers to which a given policy is attached
// inside a BatchRead operation. For more information, see ListPolicyAttachments
// and BatchReadRequest$Operations.
type BatchListPolicyAttachments struct {
	_ struct{} `type:"structure"`

	// The maximum number of results to retrieve.
	MaxResults *int64 `min:"1" type:"integer"`

	// The pagination token.
	NextToken *string `type:"string"`

	// The reference that identifies the policy object.
	//
	// PolicyReference is a required field
	PolicyReference *ObjectReference `type:"structure" required:"true"`
}

// String returns the string representation
func (s BatchListPolicyAttachments) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchListPolicyAttachments) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchListPolicyAttachments) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchListPolicyAttachments"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.PolicyReference == nil {
		invalidParams.Add(request.NewErrParamRequired("PolicyReference"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *BatchListPolicyAttachments) SetMaxResults(v int64) *BatchListPolicyAttachments {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *BatchListPolicyAttachments) SetNextToken(v string) *BatchListPolicyAttachments {
	s.NextToken = &v
	return s
}

// SetPolicyReference sets the PolicyReference field's value.
func (s *BatchListPolicyAttachments) SetPolicyReference(v *ObjectReference) *BatchListPolicyAttachments {
	s.PolicyReference = v
	return s
}

// Represents the output of a ListPolicyAttachments response operation.
type BatchListPolicyAttachmentsResponse struct {
	_ struct{} `type:"structure"`

	// The pagination token.
	NextToken *string `type:"string"`

	// A list of ObjectIdentifiers to which the policy is attached.
	ObjectIdentifiers []*string `type:"list"`
}

// String returns the string representation
func (s BatchListPolicyAttachmentsResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchListPolicyAttachmentsResponse) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *BatchListPolicyAttachmentsResponse) SetNextToken(v string) *BatchListPolicyAttachmentsResponse {
	s.NextToken = &v
	return s
}

// SetObjectIdentifiers sets the ObjectIdentifiers field's value.
func (s *BatchListPolicyAttachmentsResponse) SetObjectIdentifiers(v []*string) *BatchListPolicyAttachmentsResponse {
	s.ObjectIdentifiers = v
	return s
}

// Lists all policies from the root of the Directory to the object specified
// inside a BatchRead operation. For more information, see LookupPolicy and
// BatchReadRequest$Operations.
type BatchLookupPolicy struct {
	_ struct{} `type:"structure"`

	// The maximum number of results to retrieve.
	MaxResults *int64 `min:"1" type:"integer"`

	// The pagination token.
	NextToken *string `type:"string"`

	// Reference that identifies the object whose policies will be looked up.
	//
	// ObjectReference is a required field
	ObjectReference *ObjectReference `type:"structure" required:"true"`
}

// String returns the string representation
func (s BatchLookupPolicy) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchLookupPolicy) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchLookupPolicy) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchLookupPolicy"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.ObjectReference == nil {
		invalidParams.Add(request.NewErrParamRequired("ObjectReference"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *BatchLookupPolicy) SetMaxResults(v int64) *BatchLookupPolicy {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *BatchLookupPolicy) SetNextToken(v string) *BatchLookupPolicy {
	s.NextToken = &v
	return s
}

// SetObjectReference sets the ObjectReference field's value.
func (s *BatchLookupPolicy) SetObjectReference(v *ObjectReference) *BatchLookupPolicy {
	s.ObjectReference = v
	return s
}

// Represents the output of a LookupPolicy response operation.
type BatchLookupPolicyResponse struct {
	_ struct{} `type:"structure"`

	// The pagination token.
	NextToken *string `type:"string"`

	// Provides list of path to policies. Policies contain PolicyId, ObjectIdentifier,
	// and PolicyType. For more information, see Policies (http://docs.aws.amazon.com/directoryservice/latest/admin-guide/cd_key_concepts.html#policies).
	PolicyToPathList []*PolicyToPath `type:"list"`
}

// String returns the string representation
func (s BatchLookupPolicyResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchLookupPolicyResponse) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *BatchLookupPolicyResponse) SetNextToken(v string) *BatchLookupPolicyResponse {
	s.NextToken = &v
	return s
}

// SetPolicyToPathList sets the PolicyToPathList field's value.
func (s *BatchLookupPolicyResponse) SetPolicyToPathList(v []*PolicyToPath) *BatchLookupPolicyResponse {
	s.PolicyToPathList = v
	return s
}

// The batch read exception structure, which contains the exception type and
// message.
type BatchReadException struct {
	_ struct{} `type:"structure"`

	// An exception message that is associated with the failure.
	Message *string `type:"string"`

	// A type of exception, such as InvalidArnException.
	Type *string `type:"string" enum:"BatchReadExceptionType"`
}

// String returns the string representation
func (s BatchReadException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchReadException) GoString() string {
	return s.String()
}

// SetMessage sets the Message field's value.
func (s *BatchReadException) SetMessage(v string) *BatchReadException {
	s.Message = &v
	return s
}

// SetType sets the Type field's value.
func (s *BatchReadException) SetType(v string) *BatchReadException {
	s.Type = &v
	return s
}

type BatchReadInput struct {
	_ struct{} `type:"structure"`

	// Represents the manner and timing in which the successful write or update
	// of an object is reflected in a subsequent read operation of that same object.
	ConsistencyLevel *string `location:"header" locationName:"x-amz-consistency-level" type:"string" enum:"ConsistencyLevel"`

	// The Amazon Resource Name (ARN) that is associated with the Directory. For
	// more information, see arns.
	//
	// DirectoryArn is a required field
	DirectoryArn *string `location:"header" locationName:"x-amz-data-partition" type:"string" required:"true"`

	// A list of operations that are part of the batch.
	//
	// Operations is a required field
	Operations []*BatchReadOperation `type:"list" required:"true"`
}

// String returns the string representation
func (s BatchReadInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchReadInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchReadInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchReadInput"}
	if s.DirectoryArn == nil {
		invalidParams.Add(request.NewErrParamRequired("DirectoryArn"))
	}
	if s.Operations == nil {
		invalidParams.Add(request.NewErrParamRequired("Operations"))
	}
	if s.Operations != nil {
		for i, v := range s.Operations {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Operations", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConsistencyLevel sets the ConsistencyLevel field's value.
func (s *BatchReadInput) SetConsistencyLevel(v string) *BatchReadInput {
	s.ConsistencyLevel = &v
	return s
}

// SetDirectoryArn sets the DirectoryArn field's value.
func (s *BatchReadInput) SetDirectoryArn(v string) *BatchReadInput {
	s.DirectoryArn = &v
	return s
}

// SetOperations sets the Operations field's value.
func (s *BatchReadInput) SetOperations(v []*BatchReadOperation) *BatchReadInput {
	s.Operations = v
	return s
}

// Represents the output of a BatchRead operation.
type BatchReadOperation struct {
	_ struct{} `type:"structure"`

	// Retrieves attributes within a facet that are associated with an object.
	GetObjectAttributes *BatchGetObjectAttributes `type:"structure"`

	// Retrieves metadata about an object.
	GetObjectInformation *BatchGetObjectInformation `type:"structure"`

	// Lists indices attached to an object.
	ListAttachedIndices *BatchListAttachedIndices `type:"structure"`

	// Returns a paginated list of all the incoming TypedLinkSpecifier information
	// for an object. It also supports filtering by typed link facet and identity
	// attributes. For more information, see Typed link (http://docs.aws.amazon.com/directoryservice/latest/admin-guide/objectsandlinks.html#typedlink).
	ListIncomingTypedLinks *BatchListIncomingTypedLinks `type:"structure"`

	// Lists objects attached to the specified index.
	ListIndex *BatchListIndex `type:"structure"`

	// Lists all attributes that are associated with an object.
	ListObjectAttributes *BatchListObjectAttributes `type:"structure"`

	// Returns a paginated list of child objects that are associated with a given
	// object.
	ListObjectChildren *BatchListObjectChildren `type:"structure"`

	// Retrieves all available parent paths for any object type such as node, leaf
	// node, policy node, and index node objects. For more information about objects,
	// see Directory Structure (http://docs.aws.amazon.com/directoryservice/latest/admin-guide/cd_key_concepts.html#dirstructure).
	ListObjectParentPaths *BatchListObjectParentPaths `type:"structure"`

	// Returns policies attached to an object in pagination fashion.
	ListObjectPolicies *BatchListObjectPolicies `type:"structure"`

	// Returns a paginated list of all the outgoing TypedLinkSpecifier information
	// for an object. It also supports filtering by typed link facet and identity
	// attributes. For more information, see Typed link (http://docs.aws.amazon.com/directoryservice/latest/admin-guide/objectsandlinks.html#typedlink).
	ListOutgoingTypedLinks *BatchListOutgoingTypedLinks `type:"structure"`

	// Returns all of the ObjectIdentifiers to which a given policy is attached.
	ListPolicyAttachments *BatchListPolicyAttachments `type:"structure"`

	// Lists all policies from the root of the Directory to the object specified.
	// If there are no policies present, an empty list is returned. If policies
	// are present, and if some objects don't have the policies attached, it returns
	// the ObjectIdentifier for such objects. If policies are present, it returns
	// ObjectIdentifier, policyId, and policyType. Paths that don't lead to the
	// root from the target object are ignored. For more information, see Policies
	// (http://docs.aws.amazon.com/directoryservice/latest/admin-guide/cd_key_concepts.html#policies).
	LookupPolicy *BatchLookupPolicy `type:"structure"`
}

// String returns the string representation
func (s BatchReadOperation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchReadOperation) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchReadOperation) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchReadOperation"}
	if s.GetObjectAttributes != nil {
		if err := s.GetObjectAttributes.Validate(); err != nil {
			invalidParams.AddNested("GetObjectAttributes", err.(request.ErrInvalidParams))
		}
	}
	if s.GetObjectInformation != nil {
		if err := s.GetObjectInformation.Validate(); err != nil {
			invalidParams.AddNested("GetObjectInformation", err.(request.ErrInvalidParams))
		}
	}
	if s.ListAttachedIndices != nil {
		if err := s.ListAttachedIndices.Validate(); err != nil {
			invalidParams.AddNested("ListAttachedIndices", err.(request.ErrInvalidParams))
		}
	}
	if s.ListIncomingTypedLinks != nil {
		if err := s.ListIncomingTypedLinks.Validate(); err != nil {
			invalidParams.AddNested("ListIncomingTypedLinks", err.(request.ErrInvalidParams))
		}
	}
	if s.ListIndex != nil {
		if err := s.ListIndex.Validate(); err != nil {
			invalidParams.AddNested("ListIndex", err.(request.ErrInvalidParams))
		}
	}
	if s.ListObjectAttributes != nil {
		if err := s.ListObjectAttributes.Validate(); err != nil {
			invalidParams.AddNested("ListObjectAttributes", err.(request.ErrInvalidParams))
		}
	}
	if s.ListObjectChildren != nil {
		if err := s.ListObjectChildren.Validate(); err != nil {
			invalidParams.AddNested("ListObjectChildren", err.(request.ErrInvalidParams))
		}
	}
	if s.ListObjectParentPaths != nil {
		if err := s.ListObjectParentPaths.Validate(); err != nil {
			invalidParams.AddNested("ListObjectParentPaths", err.(request.ErrInvalidParams))
		}
	}
	if s.ListObjectPolicies != nil {
		if err := s.ListObjectPolicies.Validate(); err != nil {
			invalidParams.AddNested("ListObjectPolicies", err.(request.ErrInvalidParams))
		}
	}
	if s.ListOutgoingTypedLinks != nil {
		if err := s.ListOutgoingTypedLinks.Validate(); err != nil {
			invalidParams.AddNested("ListOutgoingTypedLinks", err.(request.ErrInvalidParams))
		}
	}
	if s.ListPolicyAttachments != nil {
		if err := s.ListPolicyAttachments.Validate(); err != nil {
			invalidParams.AddNested("ListPolicyAttachments", err.(request.ErrInvalidParams))
		}
	}
	if s.LookupPolicy != nil {
		if err := s.LookupPolicy.Validate(); err != nil {
			invalidParams.AddNested("LookupPolicy", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGetObjectAttributes sets the GetObjectAttributes field's value.
func (s *BatchReadOperation) SetGetObjectAttributes(v *BatchGetObjectAttributes) *BatchReadOperation {
	s.GetObjectAttributes = v
	return s
}

// SetGetObjectInformation sets the GetObjectInformation field's value.
func (s *BatchReadOperation) SetGetObjectInformation(v *BatchGetObjectInformation) *BatchReadOperation {
	s.GetObjectInformation = v
	return s
}

// SetListAttachedIndices sets the ListAttachedIndices field's value.
func (s *BatchReadOperation) SetListAttachedIndices(v *BatchListAttachedIndices) *BatchReadOperation {
	s.ListAttachedIndices = v
	return s
}

// SetListIncomingTypedLinks sets the ListIncomingTypedLinks field's value.
func (s *BatchReadOperation) SetListIncomingTypedLinks(v *BatchListIncomingTypedLinks) *BatchReadOperation {
	s.ListIncomingTypedLinks = v
	return s
}

// SetListIndex sets the ListIndex field's value.
func (s *BatchReadOperation) SetListIndex(v *BatchListIndex) *BatchReadOperation {
	s.ListIndex = v
	return s
}

// SetListObjectAttributes sets the ListObjectAttributes field's value.
func (s *BatchReadOperation) SetListObjectAttributes(v *BatchListObjectAttributes) *BatchReadOperation {
	s.ListObjectAttributes = v
	return s
}

// SetListObjectChildren sets the ListObjectChildren field's value.
func (s *BatchReadOperation) SetListObjectChildren(v *BatchListObjectChildren) *BatchReadOperation {
	s.ListObjectChildren = v
	return s
}

// SetListObjectParentPaths sets the ListObjectParentPaths field's value.
func (s *BatchReadOperation) SetListObjectParentPaths(v *BatchListObjectParentPaths) *BatchReadOperation {
	s.ListObjectParentPaths = v
	return s
}

// SetListObjectPolicies sets the ListObjectPolicies field's value.
func (s *BatchReadOperation) SetListObjectPolicies(v *BatchListObjectPolicies) *BatchReadOperation {
	s.ListObjectPolicies = v
	return s
}

// SetListOutgoingTypedLinks sets the ListOutgoingTypedLinks field's value.
func (s *BatchReadOperation) SetListOutgoingTypedLinks(v *BatchListOutgoingTypedLinks) *BatchReadOperation {
	s.ListOutgoingTypedLinks = v
	return s
}

// SetListPolicyAttachments sets the ListPolicyAttachments field's value.
func (s *BatchReadOperation) SetListPolicyAttachments(v *BatchListPolicyAttachments) *BatchReadOperation {
	s.ListPolicyAttachments = v
	return s
}

// SetLookupPolicy sets the LookupPolicy field's value.
func (s *BatchReadOperation) SetLookupPolicy(v *BatchLookupPolicy) *BatchReadOperation {
	s.LookupPolicy = v
	return s
}

// Represents the output of a BatchRead response operation.
type BatchReadOperationResponse struct {
	_ struct{} `type:"structure"`

	// Identifies which operation in a batch has failed.
	ExceptionResponse *BatchReadException `type:"structure"`

	// Identifies which operation in a batch has succeeded.
	SuccessfulResponse *BatchReadSuccessfulResponse `type:"structure"`
}

// String returns the string representation
func (s BatchReadOperationResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchReadOperationResponse) GoString() string {
	return s.String()
}

// SetExceptionResponse sets the ExceptionResponse field's value.
func (s *BatchReadOperationResponse) SetExceptionResponse(v *BatchReadException) *BatchReadOperationResponse {
	s.ExceptionResponse = v
	return s
}

// SetSuccessfulResponse sets the SuccessfulResponse field's value.
func (s *BatchReadOperationResponse) SetSuccessfulResponse(v *BatchReadSuccessfulResponse) *BatchReadOperationResponse {
	s.SuccessfulResponse = v
	return s
}

type BatchReadOutput struct {
	_ struct{} `type:"structure"`

	// A list of all the responses for each batch read.
	Responses []*BatchReadOperationResponse `type:"list"`
}

// String returns the string representation
func (s BatchReadOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchReadOutput) GoString() string {
	return s.String()
}

// SetResponses sets the Responses field's value.
func (s *BatchReadOutput) SetResponses(v []*BatchReadOperationResponse) *BatchReadOutput {
	s.Responses = v
	return s
}

// Represents the output of a BatchRead success response operation.
type BatchReadSuccessfulResponse struct {
	_ struct{} `type:"structure"`

	// Retrieves attributes within a facet that are associated with an object.
	GetObjectAttributes *BatchGetObjectAttributesResponse `type:"structure"`

	// Retrieves metadata about an object.
	GetObjectInformation *BatchGetObjectInformationResponse `type:"structure"`

	// Lists indices attached to an object.
	ListAttachedIndices *BatchListAttachedIndicesResponse `type:"structure"`

	// Returns a paginated list of all the incoming TypedLinkSpecifier information
	// for an object. It also supports filtering by typed link facet and identity
	// attributes. For more information, see Typed link (http://docs.aws.amazon.com/directoryservice/latest/admin-guide/objectsandlinks.html#typedlink).
	ListIncomingTypedLinks *BatchListIncomingTypedLinksResponse `type:"structure"`

	// Lists objects attached to the specified index.
	ListIndex *BatchListIndexResponse `type:"structure"`

	// Lists all attributes that are associated with an object.
	ListObjectAttributes *BatchListObjectAttributesResponse `type:"structure"`

	// Returns a paginated list of child objects that are associated with a given
	// object.
	ListObjectChildren *BatchListObjectChildrenResponse `type:"structure"`

	// Retrieves all available parent paths for any object type such as node, leaf
	// node, policy node, and index node objects. For more information about objects,
	// see Directory Structure (http://docs.aws.amazon.com/directoryservice/latest/admin-guide/cd_key_concepts.html#dirstructure).
	ListObjectParentPaths *BatchListObjectParentPathsResponse `type:"structure"`

	// Returns policies attached to an object in pagination fashion.
	ListObjectPolicies *BatchListObjectPoliciesResponse `type:"structure"`

	// Returns a paginated list of all the outgoing TypedLinkSpecifier information
	// for an object. It also supports filtering by typed link facet and identity
	// attributes. For more information, see Typed link (http://docs.aws.amazon.com/directoryservice/latest/admin-guide/objectsandlinks.html#typedlink).
	ListOutgoingTypedLinks *BatchListOutgoingTypedLinksResponse `type:"structure"`

	// Returns all of the ObjectIdentifiers to which a given policy is attached.
	ListPolicyAttachments *BatchListPolicyAttachmentsResponse `type:"structure"`

	// Lists all policies from the root of the Directory to the object specified.
	// If there are no policies present, an empty list is returned. If policies
	// are present, and if some objects don't have the policies attached, it returns
	// the ObjectIdentifier for such objects. If policies are present, it returns
	// ObjectIdentifier, policyId, and policyType. Paths that don't lead to the
	// root from the target object are ignored. For more information, see Policies
	// (http://docs.aws.amazon.com/directoryservice/latest/admin-guide/cd_key_concepts.html#policies).
	LookupPolicy *BatchLookupPolicyResponse `type:"structure"`
}

// String returns the string representation
func (s BatchReadSuccessfulResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchReadSuccessfulResponse) GoString() string {
	return s.String()
}

// SetGetObjectAttributes sets the GetObjectAttributes field's value.
func (s *BatchReadSuccessfulResponse) SetGetObjectAttributes(v *BatchGetObjectAttributesResponse) *BatchReadSuccessfulResponse {
	s.GetObjectAttributes = v
	return s
}

// SetGetObjectInformation sets the GetObjectInformation field's value.
func (s *BatchReadSuccessfulResponse) SetGetObjectInformation(v *BatchGetObjectInformationResponse) *BatchReadSuccessfulResponse {
	s.GetObjectInformation = v
	return s
}

// SetListAttachedIndices sets the ListAttachedIndices field's value.
func (s *BatchReadSuccessfulResponse) SetListAttachedIndices(v *BatchListAttachedIndicesResponse) *BatchReadSuccessfulResponse {
	s.ListAttachedIndices = v
	return s
}

// SetListIncomingTypedLinks sets the ListIncomingTypedLinks field's value.
func (s *BatchReadSuccessfulResponse) SetListIncomingTypedLinks(v *BatchListIncomingTypedLinksResponse) *BatchReadSuccessfulResponse {
	s.ListIncomingTypedLinks = v
	return s
}

// SetListIndex sets the ListIndex field's value.
func (s *BatchReadSuccessfulResponse) SetListIndex(v *BatchListIndexResponse) *BatchReadSuccessfulResponse {
	s.ListIndex = v
	return s
}

// SetListObjectAttributes sets the ListObjectAttributes field's value.
func (s *BatchReadSuccessfulResponse) SetListObjectAttributes(v *BatchListObjectAttributesResponse) *BatchReadSuccessfulResponse {
	s.ListObjectAttributes = v
	return s
}

// SetListObjectChildren sets the ListObjectChildren field's value.
func (s *BatchReadSuccessfulResponse) SetListObjectChildren(v *BatchListObjectChildrenResponse) *BatchReadSuccessfulResponse {
	s.ListObjectChildren = v
	return s
}

// SetListObjectParentPaths sets the ListObjectParentPaths field's value.
func (s *BatchReadSuccessfulResponse) SetListObjectParentPaths(v *BatchListObjectParentPathsResponse) *BatchReadSuccessfulResponse {
	s.ListObjectParentPaths = v
	return s
}

// SetListObjectPolicies sets the ListObjectPolicies field's value.
func (s *BatchReadSuccessfulResponse) SetListObjectPolicies(v *BatchListObjectPoliciesResponse) *BatchReadSuccessfulResponse {
	s.ListObjectPolicies = v
	return s
}

// SetListOutgoingTypedLinks sets the ListOutgoingTypedLinks field's value.
func (s *BatchReadSuccessfulResponse) SetListOutgoingTypedLinks(v *BatchListOutgoingTypedLinksResponse) *BatchReadSuccessfulResponse {
	s.ListOutgoingTypedLinks = v
	return s
}

// SetListPolicyAttachments sets the ListPolicyAttachments field's value.
func (s *BatchReadSuccessfulResponse) SetListPolicyAttachments(v *BatchListPolicyAttachmentsResponse) *BatchReadSuccessfulResponse {
	s.ListPolicyAttachments = v
	return s
}

// SetLookupPolicy sets the LookupPolicy field's value.
func (s *BatchReadSuccessfulResponse) SetLookupPolicy(v *BatchLookupPolicyResponse) *BatchReadSuccessfulResponse {
	s.LookupPolicy = v
	return s
}

// A batch operation to remove a facet from an object.
type BatchRemoveFacetFromObject struct {
	_ struct{} `type:"structure"`

	// A reference to the object whose facet will be removed.
	//
	// ObjectReference is a required field
	ObjectReference *ObjectReference `type:"structure" required:"true"`

	// The facet to remove from the object.
	//
	// SchemaFacet is a required field
	SchemaFacet *SchemaFacet `type:"structure" required:"true"`
}

// String returns the string representation
func (s BatchRemoveFacetFromObject) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchRemoveFacetFromObject) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchRemoveFacetFromObject) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchRemoveFacetFromObject"}
	if s.ObjectReference == nil {
		invalidParams.Add(request.NewErrParamRequired("ObjectReference"))
	}
	if s.SchemaFacet == nil {
		invalidParams.Add(request.NewErrParamRequired("SchemaFacet"))
	}
	if s.SchemaFacet != nil {
		if err := s.SchemaFacet.Validate(); err != nil {
			invalidParams.AddNested("SchemaFacet", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetObjectReference sets the ObjectReference field's value.
func (s *BatchRemoveFacetFromObject) SetObjectReference(v *ObjectReference) *BatchRemoveFacetFromObject {
	s.ObjectReference = v
	return s
}

// SetSchemaFacet sets the SchemaFacet field's value.
func (s *BatchRemoveFacetFromObject) SetSchemaFacet(v *SchemaFacet) *BatchRemoveFacetFromObject {
	s.SchemaFacet = v
	return s
}

// An empty result that represents success.
type BatchRemoveFacetFromObjectResponse struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s BatchRemoveFacetFromObjectResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchRemoveFacetFromObjectResponse) GoString() string {
	return s.String()
}

// Represents the output of a BatchUpdate operation.
type BatchUpdateObjectAttributes struct {
	_ struct{} `type:"structure"`

	// Attributes update structure.
	//
	// AttributeUpdates is a required field
	AttributeUpdates []*ObjectAttributeUpdate `type:"list" required:"true"`

	// Reference that identifies the object.
	//
	// ObjectReference is a required field
	ObjectReference *ObjectReference `type:"structure" required:"true"`
}

// String returns the string representation
func (s BatchUpdateObjectAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchUpdateObjectAttributes) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchUpdateObjectAttributes) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchUpdateObjectAttributes"}
	if s.AttributeUpdates == nil {
		invalidParams.Add(request.NewErrParamRequired("AttributeUpdates"))
	}
	if s.ObjectReference == nil {
		invalidParams.Add(request.NewErrParamRequired("ObjectReference"))
	}
	if s.AttributeUpdates != nil {
		for i, v := range s.AttributeUpdates {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "AttributeUpdates", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAttributeUpdates sets the AttributeUpdates field's value.
func (s *BatchUpdateObjectAttributes) SetAttributeUpdates(v []*ObjectAttributeUpdate) *BatchUpdateObjectAttributes {
	s.AttributeUpdates = v
	return s
}

// SetObjectReference sets the ObjectReference field's value.
func (s *BatchUpdateObjectAttributes) SetObjectReference(v *ObjectReference) *BatchUpdateObjectAttributes {
	s.ObjectReference = v
	return s
}

// Represents the output of a BatchUpdate response operation.
type BatchUpdateObjectAttributesResponse struct {
	_ struct{} `type:"structure"`

	// ID that is associated with the object.
	ObjectIdentifier *string `type:"string"`
}

// String returns the string representation
func (s BatchUpdateObjectAttributesResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchUpdateObjectAttributesResponse) GoString() string {
	return s.String()
}

// SetObjectIdentifier sets the ObjectIdentifier field's value.
func (s *BatchUpdateObjectAttributesResponse) SetObjectIdentifier(v string) *BatchUpdateObjectAttributesResponse {
	s.ObjectIdentifier = &v
	return s
}

type BatchWriteInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) that is associated with the Directory. For
	// more information, see arns.
	//
	// DirectoryArn is a required field
	DirectoryArn *string `location:"header" locationName:"x-amz-data-partition" type:"string" required:"true"`

	// A list of operations that are part of the batch.
	//
	// Operations is a required field
	Operations []*BatchWriteOperation `type:"list" required:"true"`
}

// String returns the string representation
func (s BatchWriteInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchWriteInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchWriteInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchWriteInput"}
	if s.DirectoryArn == nil {
		invalidParams.Add(request.NewErrParamRequired("DirectoryArn"))
	}
	if s.Operations == nil {
		invalidParams.Add(request.NewErrParamRequired("Operations"))
	}
	if s.Operations != nil {
		for i, v := range s.Operations {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Operations", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDirectoryArn sets the DirectoryArn field's value.
func (s *BatchWriteInput) SetDirectoryArn(v string) *BatchWriteInput {
	s.DirectoryArn = &v
	return s
}

// SetOperations sets the Operations field's value.
func (s *BatchWriteInput) SetOperations(v []*BatchWriteOperation) *BatchWriteInput {
	s.Operations = v
	return s
}

// Represents the output of a BatchWrite operation.
type BatchWriteOperation struct {
	_ struct{} `type:"structure"`

	// A batch operation that adds a facet to an object.
	AddFacetToObject *BatchAddFacetToObject `type:"structure"`

	// Attaches an object to a Directory.
	AttachObject *BatchAttachObject `type:"structure"`

	// Attaches a policy object to a regular object. An object can have a limited
	// number of attached policies.
	AttachPolicy *BatchAttachPolicy `type:"structure"`

	// Attaches the specified object to the specified index.
	AttachToIndex *BatchAttachToIndex `type:"structure"`

	// Attaches a typed link to a specified source and target object. For more information,
	// see Typed link (http://docs.aws.amazon.com/directoryservice/latest/admin-guide/objectsandlinks.html#typedlink).
	AttachTypedLink *BatchAttachTypedLink `type:"structure"`

	// Creates an index object. See Indexing (http://docs.aws.amazon.com/directoryservice/latest/admin-guide/cd_indexing.html)
	// for more information.
	CreateIndex *BatchCreateIndex `type:"structure"`

	// Creates an object.
	CreateObject *BatchCreateObject `type:"structure"`

	// Deletes an object in a Directory.
	DeleteObject *BatchDeleteObject `type:"structure"`

	// Detaches the specified object from the specified index.
	DetachFromIndex *BatchDetachFromIndex `type:"structure"`

	// Detaches an object from a Directory.
	DetachObject *BatchDetachObject `type:"structure"`

	// Detaches a policy from a Directory.
	DetachPolicy *BatchDetachPolicy `type:"structure"`

	// Detaches a typed link from a specified source and target object. For more
	// information, see Typed link (http://docs.aws.amazon.com/directoryservice/latest/admin-guide/objectsandlinks.html#typedlink).
	DetachTypedLink *BatchDetachTypedLink `type:"structure"`

	// A batch operation that removes a facet from an object.
	RemoveFacetFromObject *BatchRemoveFacetFromObject `type:"structure"`

	// Updates a given object's attributes.
	UpdateObjectAttributes *BatchUpdateObjectAttributes `type:"structure"`
}

// String returns the string representation
func (s BatchWriteOperation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchWriteOperation) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchWriteOperation) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchWriteOperation"}
	if s.AddFacetToObject != nil {
		if err := s.AddFacetToObject.Validate(); err != nil {
			invalidParams.AddNested("AddFacetToObject", err.(request.ErrInvalidParams))
		}
	}
	if s.AttachObject != nil {
		if err := s.AttachObject.Validate(); err != nil {
			invalidParams.AddNested("AttachObject", err.(request.ErrInvalidParams))
		}
	}
	if s.AttachPolicy != nil {
		if err := s.AttachPolicy.Validate(); err != nil {
			invalidParams.AddNested("AttachPolicy", err.(request.ErrInvalidParams))
		}
	}
	if s.AttachToIndex != nil {
		if err := s.AttachToIndex.Validate(); err != nil {
			invalidParams.AddNested("AttachToIndex", err.(request.ErrInvalidParams))
		}
	}
	if s.AttachTypedLink != nil {
		if err := s.AttachTypedLink.Validate(); err != nil {
			invalidParams.AddNested("AttachTypedLink", err.(request.ErrInvalidParams))
		}
	}
	if s.CreateIndex != nil {
		if err := s.CreateIndex.Validate(); err != nil {
			invalidParams.AddNested("CreateIndex", err.(request.ErrInvalidParams))
		}
	}
	if s.CreateObject != nil {
		if err := s.CreateObject.Validate(); err != nil {
			invalidParams.AddNested("CreateObject", err.(request.ErrInvalidParams))
		}
	}
	if s.DeleteObject != nil {
		if err := s.DeleteObject.Validate(); err != nil {
			invalidParams.AddNested("DeleteObject", err.(request.ErrInvalidParams))
		}
	}
	if s.DetachFromIndex != nil {
		if err := s.DetachFromIndex.Validate(); err != nil {
			invalidParams.AddNested("DetachFromIndex", err.(request.ErrInvalidParams))
		}
	}
	if s.DetachObject != nil {
		if err := s.DetachObject.Validate(); err != nil {
			invalidParams.AddNested("DetachObject", err.(request.ErrInvalidParams))
		}
	}
	if s.DetachPolicy != nil {
		if err := s.DetachPolicy.Validate(); err != nil {
			invalidParams.AddNested("DetachPolicy", err.(request.ErrInvalidParams))
		}
	}
	if s.DetachTypedLink != nil {
		if err := s.DetachTypedLink.Validate(); err != nil {
			invalidParams.AddNested("DetachTypedLink", err.(request.ErrInvalidParams))
		}
	}
	if s.RemoveFacetFromObject != nil {
		if err := s.RemoveFacetFromObject.Validate(); err != nil {
			invalidParams.AddNested("RemoveFacetFromObject", err.(request.ErrInvalidParams))
		}
	}
	if s.UpdateObjectAttributes != nil {
		if err := s.UpdateObjectAttributes.Validate(); err != nil {
			invalidParams.AddNested("UpdateObjectAttributes", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAddFacetToObject sets the AddFacetToObject field's value.
func (s *BatchWriteOperation) SetAddFacetToObject(v *BatchAddFacetToObject) *BatchWriteOperation {
	s.AddFacetToObject = v
	return s
}

// SetAttachObject sets the AttachObject field's value.
func (s *BatchWriteOperation) SetAttachObject(v *BatchAttachObject) *BatchWriteOperation {
	s.AttachObject = v
	return s
}

// SetAttachPolicy sets the AttachPolicy field's value.
func (s *BatchWriteOperation) SetAttachPolicy(v *BatchAttachPolicy) *BatchWriteOperation {
	s.AttachPolicy = v
	return s
}

// SetAttachToIndex sets the AttachToIndex field's value.
func (s *BatchWriteOperation) SetAttachToIndex(v *BatchAttachToIndex) *BatchWriteOperation {
	s.AttachToIndex = v
	return s
}

// SetAttachTypedLink sets the AttachTypedLink field's value.
func (s *BatchWriteOperation) SetAttachTypedLink(v *BatchAttachTypedLink) *BatchWriteOperation {
	s.AttachTypedLink = v
	return s
}

// SetCreateIndex sets the CreateIndex field's value.
func (s *BatchWriteOperation) SetCreateIndex(v *BatchCreateIndex) *BatchWriteOperation {
	s.CreateIndex = v
	return s
}

// SetCreateObject sets the CreateObject field's value.
func (s *BatchWriteOperation) SetCreateObject(v *BatchCreateObject) *BatchWriteOperation {
	s.CreateObject = v
	return s
}

// SetDeleteObject sets the DeleteObject field's value.
func (s *BatchWriteOperation) SetDeleteObject(v *BatchDeleteObject) *BatchWriteOperation {
	s.DeleteObject = v
	return s
}

// SetDetachFromIndex sets the DetachFromIndex field's value.
func (s *BatchWriteOperation) SetDetachFromIndex(v *BatchDetachFromIndex) *BatchWriteOperation {
	s.DetachFromIndex = v
	return s
}

// SetDetachObject sets the DetachObject field's value.
func (s *BatchWriteOperation) SetDetachObject(v *BatchDetachObject) *BatchWriteOperation {
	s.DetachObject = v
	return s
}

// SetDetachPolicy sets the DetachPolicy field's value.
func (s *BatchWriteOperation) SetDetachPolicy(v *BatchDetachPolicy) *BatchWriteOperation {
	s.DetachPolicy = v
	return s
}

// SetDetachTypedLink sets the DetachTypedLink field's value.
func (s *BatchWriteOperation) SetDetachTypedLink(v *BatchDetachTypedLink) *BatchWriteOperation {
	s.DetachTypedLink = v
	return s
}

// SetRemoveFacetFromObject sets the RemoveFacetFromObject field's value.
func (s *BatchWriteOperation) SetRemoveFacetFromObject(v *BatchRemoveFacetFromObject) *BatchWriteOperation {
	s.RemoveFacetFromObject = v
	return s
}

// SetUpdateObjectAttributes sets the UpdateObjectAttributes field's value.
func (s *BatchWriteOperation) SetUpdateObjectAttributes(v *BatchUpdateObjectAttributes) *BatchWriteOperation {
	s.UpdateObjectAttributes = v
	return s
}

// Represents the output of a BatchWrite response operation.
type BatchWriteOperationResponse struct {
	_ struct{} `type:"structure"`

	// The result of an add facet to object batch operation.
	AddFacetToObject *BatchAddFacetToObjectResponse `type:"structure"`

	// Attaches an object to a Directory.
	AttachObject *BatchAttachObjectResponse `type:"structure"`

	// Attaches a policy object to a regular object. An object can have a limited
	// number of attached policies.
	AttachPolicy *BatchAttachPolicyResponse `type:"structure"`

	// Attaches the specified object to the specified index.
	AttachToIndex *BatchAttachToIndexResponse `type:"structure"`

	// Attaches a typed link to a specified source and target object. For more information,
	// see Typed link (http://docs.aws.amazon.com/directoryservice/latest/admin-guide/objectsandlinks.html#typedlink).
	AttachTypedLink *BatchAttachTypedLinkResponse `type:"structure"`

	// Creates an index object. See Indexing (http://docs.aws.amazon.com/directoryservice/latest/admin-guide/cd_indexing.html)
	// for more information.
	CreateIndex *BatchCreateIndexResponse `type:"structure"`

	// Creates an object in a Directory.
	CreateObject *BatchCreateObjectResponse `type:"structure"`

	// Deletes an object in a Directory.
	DeleteObject *BatchDeleteObjectResponse `type:"structure"`

	// Detaches the specified object from the specified index.
	DetachFromIndex *BatchDetachFromIndexResponse `type:"structure"`

	// Detaches an object from a Directory.
	DetachObject *BatchDetachObjectResponse `type:"structure"`

	// Detaches a policy from a Directory.
	DetachPolicy *BatchDetachPolicyResponse `type:"structure"`

	// Detaches a typed link from a specified source and target object. For more
	// information, see Typed link (http://docs.aws.amazon.com/directoryservice/latest/admin-guide/objectsandlinks.html#typedlink).
	DetachTypedLink *BatchDetachTypedLinkResponse `type:"structure"`

	// The result of a batch remove facet from object operation.
	RemoveFacetFromObject *BatchRemoveFacetFromObjectResponse `type:"structure"`

	// Updates a given object’s attributes.
	UpdateObjectAttributes *BatchUpdateObjectAttributesResponse `type:"structure"`
}

// String returns the string representation
func (s BatchWriteOperationResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchWriteOperationResponse) GoString() string {
	return s.String()
}

// SetAddFacetToObject sets the AddFacetToObject field's value.
func (s *BatchWriteOperationResponse) SetAddFacetToObject(v *BatchAddFacetToObjectResponse) *BatchWriteOperationResponse {
	s.AddFacetToObject = v
	return s
}

// SetAttachObject sets the AttachObject field's value.
func (s *BatchWriteOperationResponse) SetAttachObject(v *BatchAttachObjectResponse) *BatchWriteOperationResponse {
	s.AttachObject = v
	return s
}

// SetAttachPolicy sets the AttachPolicy field's value.
func (s *BatchWriteOperationResponse) SetAttachPolicy(v *BatchAttachPolicyResponse) *BatchWriteOperationResponse {
	s.AttachPolicy = v
	return s
}

// SetAttachToIndex sets the AttachToIndex field's value.
func (s *BatchWriteOperationResponse) SetAttachToIndex(v *BatchAttachToIndexResponse) *BatchWriteOperationResponse {
	s.AttachToIndex = v
	return s
}

// SetAttachTypedLink sets the AttachTypedLink field's value.
func (s *BatchWriteOperationResponse) SetAttachTypedLink(v *BatchAttachTypedLinkResponse) *BatchWriteOperationResponse {
	s.AttachTypedLink = v
	return s
}

// SetCreateIndex sets the CreateIndex field's value.
func (s *BatchWriteOperationResponse) SetCreateIndex(v *BatchCreateIndexResponse) *BatchWriteOperationResponse {
	s.CreateIndex = v
	return s
}

// SetCreateObject sets the CreateObject field's value.
func (s *BatchWriteOperationResponse) SetCreateObject(v *BatchCreateObjectResponse) *BatchWriteOperationResponse {
	s.CreateObject = v
	return s
}

// SetDeleteObject sets the DeleteObject field's value.
func (s *BatchWriteOperationResponse) SetDeleteObject(v *BatchDeleteObjectResponse) *BatchWriteOperationResponse {
	s.DeleteObject = v
	return s
}

// SetDetachFromIndex sets the DetachFromIndex field's value.
func (s *BatchWriteOperationResponse) SetDetachFromIndex(v *BatchDetachFromIndexResponse) *BatchWriteOperationResponse {
	s.DetachFromIndex = v
	return s
}

// SetDetachObject sets the DetachObject field's value.
func (s *BatchWriteOperationResponse) SetDetachObject(v *BatchDetachObjectResponse) *BatchWriteOperationResponse {
	s.DetachObject = v
	return s
}

// SetDetachPolicy sets the DetachPolicy field's value.
func (s *BatchWriteOperationResponse) SetDetachPolicy(v *BatchDetachPolicyResponse) *BatchWriteOperationResponse {
	s.DetachPolicy = v
	return s
}

// SetDetachTypedLink sets the DetachTypedLink field's value.
func (s *BatchWriteOperationResponse) SetDetachTypedLink(v *BatchDetachTypedLinkResponse) *BatchWriteOperationResponse {
	s.DetachTypedLink = v
	return s
}

// SetRemoveFacetFromObject sets the RemoveFacetFromObject field's value.
func (s *BatchWriteOperationResponse) SetRemoveFacetFromObject(v *BatchRemoveFacetFromObjectResponse) *BatchWriteOperationResponse {
	s.RemoveFacetFromObject = v
	return s
}

// SetUpdateObjectAttributes sets the UpdateObjectAttributes field's value.
func (s *BatchWriteOperationResponse) SetUpdateObjectAttributes(v *BatchUpdateObjectAttributesResponse) *BatchWriteOperationResponse {
	s.UpdateObjectAttributes = v
	return s
}

type BatchWriteOutput struct {
	_ struct{} `type:"structure"`

	// A list of all the responses for each batch write.
	Responses []*BatchWriteOperationResponse `type:"list"`
}

// String returns the string representation
func (s BatchWriteOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchWriteOutput) GoString() string {
	return s.String()
}

// SetResponses sets the Responses field's value.
func (s *BatchWriteOutput) SetResponses(v []*BatchWriteOperationResponse) *BatchWriteOutput {
	s.Responses = v
	return s
}

type CreateDirectoryInput struct {
	_ struct{} `type:"structure"`

	// The name of the Directory. Should be unique per account, per region.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the published schema that will be copied
	// into the data Directory. For more information, see arns.
	//
	// SchemaArn is a required field
	SchemaArn *string `location:"header" locationName:"x-amz-data-partition" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateDirectoryInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDirectoryInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateDirectoryInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateDirectoryInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.SchemaArn == nil {
		invalidParams.Add(request.NewErrParamRequired("SchemaArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *CreateDirectoryInput) SetName(v string) *CreateDirectoryInput {
	s.Name = &v
	return s
}

// SetSchemaArn sets the SchemaArn field's value.
func (s *CreateDirectoryInput) SetSchemaArn(v string) *CreateDirectoryInput {
	s.SchemaArn = &v
	return s
}

type CreateDirectoryOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the published schema in the Directory. Once a published schema
	// is copied into the directory, it has its own ARN, which is referred to applied
	// schema ARN. For more information, see arns.
	//
	// AppliedSchemaArn is a required field
	AppliedSchemaArn *string `type:"string" required:"true"`

	// The ARN that is associated with the Directory. For more information, see
	// arns.
	//
	// DirectoryArn is a required field
	DirectoryArn *string `type:"string" required:"true"`

	// The name of the Directory.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The root object node of the created directory.
	//
	// ObjectIdentifier is a required field
	ObjectIdentifier *string `type:"string" required:"true"`
}

// String returns the string representation
func (s CreateDirectoryOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDirectoryOutput) GoString() string {
	return s.String()
}

// SetAppliedSchemaArn sets the AppliedSchemaArn field's value.
func (s *CreateDirectoryOutput) SetAppliedSchemaArn(v string) *CreateDirectoryOutput {
	s.AppliedSchemaArn = &v
	return s
}

// SetDirectoryArn sets the DirectoryArn field's value.
func (s *CreateDirectoryOutput) SetDirectoryArn(v string) *CreateDirectoryOutput {
	s.DirectoryArn = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateDirectoryOutput) SetName(v string) *CreateDirectoryOutput {
	s.Name = &v
	return s
}

// SetObjectIdentifier sets the ObjectIdentifier field's value.
func (s *CreateDirectoryOutput) SetObjectIdentifier(v string) *CreateDirectoryOutput {
	s.ObjectIdentifier = &v
	return s
}

type CreateFacetInput struct {
	_ struct{} `type:"structure"`

	// The attributes that are associated with the Facet.
	Attributes []*FacetAttribute `type:"list"`

	// The name of the Facet, which is unique for a given schema.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// Specifies whether a given object created from this facet is of type node,
	// leaf node, policy or index.
	//
	//    * Node: Can have multiple children but one parent.
	//
	//    * Leaf node: Cannot have children but can have multiple parents.
	//
	//    * Policy: Allows you to store a policy document and policy type. For more
	//    information, see Policies (http://docs.aws.amazon.com/directoryservice/latest/admin-guide/cd_key_concepts.html#policies).
	//
	//    * Index: Can be created with the Index API.
	//
	// ObjectType is a required field
	ObjectType *string `type:"string" required:"true" enum:"ObjectType"`

	// The schema ARN in which the new Facet will be created. For more information,
	// see arns.
	//
	// SchemaArn is a required field
	SchemaArn *string `location:"header" locationName:"x-amz-data-partition" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateFacetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateFacetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateFacetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateFacetInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.ObjectType == nil {
		invalidParams.Add(request.NewErrParamRequired("ObjectType"))
	}
	if s.SchemaArn == nil {
		invalidParams.Add(request.NewErrParamRequired("SchemaArn"))
	}
	if s.Attributes != nil {
		for i, v := range s.Attributes {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Attributes", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAttributes sets the Attributes field's value.
func (s *CreateFacetInput) SetAttributes(v []*FacetAttribute) *CreateFacetInput {
	s.Attributes = v
	return s
}

// SetName sets the Name field's value.
func (s *CreateFacetInput) SetName(v string) *CreateFacetInput {
	s.Name = &v
	return s
}

// SetObjectType sets the ObjectType field's value.
func (s *CreateFacetInput) SetObjectType(v string) *CreateFacetInput {
	s.ObjectType = &v
	return s
}

// SetSchemaArn sets the SchemaArn field's value.
func (s *CreateFacetInput) SetSchemaArn(v string) *CreateFacetInput {
	s.SchemaArn = &v
	return s
}

type CreateFacetOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s CreateFacetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateFacetOutput) GoString() string {
	return s.String()
}

type CreateIndexInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the directory where the index should be created.
	//
	// DirectoryArn is a required field
	DirectoryArn *string `location:"header" locationName:"x-amz-data-partition" type:"string" required:"true"`

	// Indicates whether the attribute that is being indexed has unique values or
	// not.
	//
	// IsUnique is a required field
	IsUnique *bool `type:"boolean" required:"true"`

	// The name of the link between the parent object and the index object.
	LinkName *string `min:"1" type:"string"`

	// Specifies the attributes that should be indexed on. Currently only a single
	// attribute is supported.
	//
	// OrderedIndexedAttributeList is a required field
	OrderedIndexedAttributeList []*AttributeKey `type:"list" required:"true"`

	// A reference to the parent object that contains the index object.
	ParentReference *ObjectReference `type:"structure"`
}

// String returns the string representation
func (s CreateIndexInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateIndexInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateIndexInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateIndexInput"}
	if s.DirectoryArn == nil {
		invalidParams.Add(request.NewErrParamRequired("DirectoryArn"))
	}
	if s.IsUnique == nil {
		invalidParams.Add(request.NewErrParamRequired("IsUnique"))
	}
	if s.LinkName != nil && len(*s.LinkName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LinkName", 1))
	}
	if s.OrderedIndexedAttributeList == nil {
		invalidParams.Add(request.NewErrParamRequired("OrderedIndexedAttributeList"))
	}
	if s.OrderedIndexedAttributeList != nil {
		for i, v := range s.OrderedIndexedAttributeList {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "OrderedIndexedAttributeList", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDirectoryArn sets the DirectoryArn field's value.
func (s *CreateIndexInput) SetDirectoryArn(v string) *CreateIndexInput {
	s.DirectoryArn = &v
	return s
}

// SetIsUnique sets the IsUnique field's value.
func (s *CreateIndexInput) SetIsUnique(v bool) *CreateIndexInput {
	s.IsUnique = &v
	return s
}

// SetLinkName sets the LinkName field's value.
func (s *CreateIndexInput) SetLinkName(v string) *CreateIndexInput {
	s.LinkName = &v
	return s
}

// SetOrderedIndexedAttributeList sets the OrderedIndexedAttributeList field's value.
func (s *CreateIndexInput) SetOrderedIndexedAttributeList(v []*AttributeKey) *CreateIndexInput {
	s.OrderedIndexedAttributeList = v
	return s
}

// SetParentReference sets the ParentReference field's value.
func (s *CreateIndexInput) SetParentReference(v *ObjectReference) *CreateIndexInput {
	s.ParentReference = v
	return s
}

type CreateIndexOutput struct {
	_ struct{} `type:"structure"`

	// The ObjectIdentifier of the index created by this operation.
	ObjectIdentifier *string `type:"string"`
}

// String returns the string representation
func (s CreateIndexOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateIndexOutput) GoString() string {
	return s.String()
}

// SetObjectIdentifier sets the ObjectIdentifier field's value.
func (s *CreateIndexOutput) SetObjectIdentifier(v string) *CreateIndexOutput {
	s.ObjectIdentifier = &v
	return s
}

type CreateObjectInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) that is associated with the Directory in which
	// the object will be created. For more information, see arns.
	//
	// DirectoryArn is a required field
	DirectoryArn *string `location:"header" locationName:"x-amz-data-partition" type:"string" required:"true"`

	// The name of link that is used to attach this object to a parent.
	LinkName *string `min:"1" type:"string"`

	// The attribute map whose attribute ARN contains the key and attribute value
	// as the map value.
	ObjectAttributeList []*AttributeKeyAndValue `type:"list"`

	// If specified, the parent reference to which this object will be attached.
	ParentReference *ObjectReference `type:"structure"`

	// A list of schema facets to be associated with the object. Do not provide
	// minor version components. See SchemaFacet for details.
	//
	// SchemaFacets is a required field
	SchemaFacets []*SchemaFacet `type:"list" required:"true"`
}

// String returns the string representation
func (s CreateObjectInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateObjectInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateObjectInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateObjectInput"}
	if s.DirectoryArn == nil {
		invalidParams.Add(request.NewErrParamRequired("DirectoryArn"))
	}
	if s.LinkName != nil && len(*s.LinkName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LinkName", 1))
	}
	if s.SchemaFacets == nil {
		invalidParams.Add(request.NewErrParamRequired("SchemaFacets"))
	}
	if s.ObjectAttributeList != nil {
		for i, v := range s.ObjectAttributeList {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ObjectAttributeList", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.SchemaFacets != nil {
		for i, v := range s.SchemaFacets {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "SchemaFacets", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDirectoryArn sets the DirectoryArn field's value.
func (s *CreateObjectInput) SetDirectoryArn(v string) *CreateObjectInput {
	s.DirectoryArn = &v
	return s
}

// SetLinkName sets the LinkName field's value.
func (s *CreateObjectInput) SetLinkName(v string) *CreateObjectInput {
	s.LinkName = &v
	return s
}

// SetObjectAttributeList sets the ObjectAttributeList field's value.
func (s *CreateObjectInput) SetObjectAttributeList(v []*AttributeKeyAndValue) *CreateObjectInput {
	s.ObjectAttributeList = v
	return s
}

// SetParentReference sets the ParentReference field's value.
func (s *CreateObjectInput) SetParentReference(v *ObjectReference) *CreateObjectInput {
	s.ParentReference = v
	return s
}

// SetSchemaFacets sets the SchemaFacets field's value.
func (s *CreateObjectInput) SetSchemaFacets(v []*SchemaFacet) *CreateObjectInput {
	s.SchemaFacets = v
	return s
}

type CreateObjectOutput struct {
	_ struct{} `type:"structure"`

	// The identifier that is associated with the object.
	ObjectIdentifier *string `type:"string"`
}

// String returns the string representation
func (s CreateObjectOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateObjectOutput) GoString() string {
	return s.String()
}

// SetObjectIdentifier sets the ObjectIdentifier field's value.
func (s *CreateObjectOutput) SetObjectIdentifier(v string) *CreateObjectOutput {
	s.ObjectIdentifier = &v
	return s
}

type CreateSchemaInput struct {
	_ struct{} `type:"structure"`

	// The name that is associated with the schema. This is unique to each account
	// and in each region.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateSchemaInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateSchemaInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateSchemaInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateSchemaInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *CreateSchemaInput) SetName(v string) *CreateSchemaInput {
	s.Name = &v
	return s
}

type CreateSchemaOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) that is associated with the schema. For more
	// information, see arns.
	SchemaArn *string `type:"string"`
}

// String returns the string representation
func (s CreateSchemaOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateSchemaOutput) GoString() string {
	return s.String()
}

// SetSchemaArn sets the SchemaArn field's value.
func (s *CreateSchemaOutput) SetSchemaArn(v string) *CreateSchemaOutput {
	s.SchemaArn = &v
	return s
}

type CreateTypedLinkFacetInput struct {
	_ struct{} `type:"structure"`

	// Facet structure that is associated with the typed link facet.
	//
	// Facet is a required field
	Facet *TypedLinkFacet `type:"structure" required:"true"`

	// The Amazon Resource Name (ARN) that is associated with the schema. For more
	// information, see arns.
	//
	// SchemaArn is a required field
	SchemaArn *string `location:"header" locationName:"x-amz-data-partition" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateTypedLinkFacetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateTypedLinkFacetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateTypedLinkFacetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateTypedLinkFacetInput"}
	if s.Facet == nil {
		invalidParams.Add(request.NewErrParamRequired("Facet"))
	}
	if s.SchemaArn == nil {
		invalidParams.Add(request.NewErrParamRequired("SchemaArn"))
	}
	if s.Facet != nil {
		if err := s.Facet.Validate(); err != nil {
			invalidParams.AddNested("Facet", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFacet sets the Facet field's value.
func (s *CreateTypedLinkFacetInput) SetFacet(v *TypedLinkFacet) *CreateTypedLinkFacetInput {
	s.Facet = v
	return s
}

// SetSchemaArn sets the SchemaArn field's value.
func (s *CreateTypedLinkFacetInput) SetSchemaArn(v string) *CreateTypedLinkFacetInput {
	s.SchemaArn = &v
	return s
}

type CreateTypedLinkFacetOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s CreateTypedLinkFacetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateTypedLinkFacetOutput) GoString() string {
	return s.String()
}

type DeleteDirectoryInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the directory to delete.
	//
	// DirectoryArn is a required field
	DirectoryArn *string `location:"header" locationName:"x-amz-data-partition" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteDirectoryInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDirectoryInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteDirectoryInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteDirectoryInput"}
	if s.DirectoryArn == nil {
		invalidParams.Add(request.NewErrParamRequired("DirectoryArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDirectoryArn sets the DirectoryArn field's value.
func (s *DeleteDirectoryInput) SetDirectoryArn(v string) *DeleteDirectoryInput {
	s.DirectoryArn = &v
	return s
}

type DeleteDirectoryOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the deleted directory.
	//
	// DirectoryArn is a required field
	DirectoryArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteDirectoryOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDirectoryOutput) GoString() string {
	return s.String()
}

// SetDirectoryArn sets the DirectoryArn field's value.
func (s *DeleteDirectoryOutput) SetDirectoryArn(v string) *DeleteDirectoryOutput {
	s.DirectoryArn = &v
	return s
}

type DeleteFacetInput struct {
	_ struct{} `type:"structure"`

	// The name of the facet to delete.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) that is associated with the Facet. For more
	// information, see arns.
	//
	// SchemaArn is a required field
	SchemaArn *string `location:"header" locationName:"x-amz-data-partition" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteFacetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteFacetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteFacetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteFacetInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.SchemaArn == nil {
		invalidParams.Add(request.NewErrParamRequired("SchemaArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *DeleteFacetInput) SetName(v string) *DeleteFacetInput {
	s.Name = &v
	return s
}

// SetSchemaArn sets the SchemaArn field's value.
func (s *DeleteFacetInput) SetSchemaArn(v string) *DeleteFacetInput {
	s.SchemaArn = &v
	return s
}

type DeleteFacetOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteFacetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteFacetOutput) GoString() string {
	return s.String()
}

type DeleteObjectInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) that is associated with the Directory where
	// the object resides. For more information, see arns.
	//
	// DirectoryArn is a required field
	DirectoryArn *string `location:"header" locationName:"x-amz-data-partition" type:"string" required:"true"`

	// A reference that identifies the object.
	//
	// ObjectReference is a required field
	ObjectReference *ObjectReference `type:"structure" required:"true"`
}

// String returns the string representation
func (s DeleteObjectInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteObjectInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteObjectInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteObjectInput"}
	if s.DirectoryArn == nil {
		invalidParams.Add(request.NewErrParamRequired("DirectoryArn"))
	}
	if s.ObjectReference == nil {
		invalidParams.Add(request.NewErrParamRequired("ObjectReference"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDirectoryArn sets the DirectoryArn field's value.
func (s *DeleteObjectInput) SetDirectoryArn(v string) *DeleteObjectInput {
	s.DirectoryArn = &v
	return s
}

// SetObjectReference sets the ObjectReference field's value.
func (s *DeleteObjectInput) SetObjectReference(v *ObjectReference) *DeleteObjectInput {
	s.ObjectReference = v
	return s
}

type DeleteObjectOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteObjectOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteObjectOutput) GoString() string {
	return s.String()
}

type DeleteSchemaInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the development schema. For more information,
	// see arns.
	//
	// SchemaArn is a required field
	SchemaArn *string `location:"header" locationName:"x-amz-data-partition" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteSchemaInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteSchemaInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteSchemaInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteSchemaInput"}
	if s.SchemaArn == nil {
		invalidParams.Add(request.NewErrParamRequired("SchemaArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSchemaArn sets the SchemaArn field's value.
func (s *DeleteSchemaInput) SetSchemaArn(v string) *DeleteSchemaInput {
	s.SchemaArn = &v
	return s
}

type DeleteSchemaOutput struct {
	_ struct{} `type:"structure"`

	// The input ARN that is returned as part of the response. For more information,
	// see arns.
	SchemaArn *string `type:"string"`
}

// String returns the string representation
func (s DeleteSchemaOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteSchemaOutput) GoString() string {
	return s.String()
}

// SetSchemaArn sets the SchemaArn field's value.
func (s *DeleteSchemaOutput) SetSchemaArn(v string) *DeleteSchemaOutput {
	s.SchemaArn = &v
	return s
}

type DeleteTypedLinkFacetInput struct {
	_ struct{} `type:"structure"`

	// The unique name of the typed link facet.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`

	// The Amazon Resource Name (ARN) that is associated with the schema. For more
	// information, see arns.
	//
	// SchemaArn is a required field
	SchemaArn *string `location:"header" locationName:"x-amz-data-partition" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteTypedLinkFacetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteTypedLinkFacetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteTypedLinkFacetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteTypedLinkFacetInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.SchemaArn == nil {
		invalidParams.Add(request.NewErrParamRequired("SchemaArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *DeleteTypedLinkFacetInput) SetName(v string) *DeleteTypedLinkFacetInput {
	s.Name = &v
	return s
}

// SetSchemaArn sets the SchemaArn field's value.
func (s *DeleteTypedLinkFacetInput) SetSchemaArn(v string) *DeleteTypedLinkFacetInput {
	s.SchemaArn = &v
	return s
}

type DeleteTypedLinkFacetOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteTypedLinkFacetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteTypedLinkFacetOutput) GoString() string {
	return s.String()
}

type DetachFromIndexInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the directory the index and object exist
	// in.
	//
	// DirectoryArn is a required field
	DirectoryArn *string `location:"header" locationName:"x-amz-data-partition" type:"string" required:"true"`

	// A reference to the index object.
	//
	// IndexReference is a required field
	IndexReference *ObjectReference `type:"structure" required:"true"`

	// A reference to the object being detached from the index.
	//
	// TargetReference is a required field
	TargetReference *ObjectReference `type:"structure" required:"true"`
}

// String returns the string representation
func (s DetachFromIndexInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DetachFromIndexInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DetachFromIndexInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DetachFromIndexInput"}
	if s.DirectoryArn == nil {
		invalidParams.Add(request.NewErrParamRequired("DirectoryArn"))
	}
	if s.IndexReference == nil {
		invalidParams.Add(request.NewErrParamRequired("IndexReference"))
	}
	if s.TargetReference == nil {
		invalidParams.Add(request.NewErrParamRequired("TargetReference"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDirectoryArn sets the DirectoryArn field's value.
func (s *DetachFromIndexInput) SetDirectoryArn(v string) *DetachFromIndexInput {
	s.DirectoryArn = &v
	return s
}

// SetIndexReference sets the IndexReference field's value.
func (s *DetachFromIndexInput) SetIndexReference(v *ObjectReference) *DetachFromIndexInput {
	s.IndexReference = v
	return s
}

// SetTargetReference sets the TargetReference field's value.
func (s *DetachFromIndexInput) SetTargetReference(v *ObjectReference) *DetachFromIndexInput {
	s.TargetReference = v
	return s
}

type DetachFromIndexOutput struct {
	_ struct{} `type:"structure"`

	// The ObjectIdentifier of the object that was detached from the index.
	DetachedObjectIdentifier *string `type:"string"`
}

// String returns the string representation
func (s DetachFromIndexOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DetachFromIndexOutput) GoString() string {
	return s.String()
}

// SetDetachedObjectIdentifier sets the DetachedObjectIdentifier field's value.
func (s *DetachFromIndexOutput) SetDetachedObjectIdentifier(v string) *DetachFromIndexOutput {
	s.DetachedObjectIdentifier = &v
	return s
}

type DetachObjectInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) that is associated with the Directory where
	// objects reside. For more information, see arns.
	//
	// DirectoryArn is a required field
	DirectoryArn *string `location:"header" locationName:"x-amz-data-partition" type:"string" required:"true"`

	// The link name associated with the object that needs to be detached.
	//
	// LinkName is a required field
	LinkName *string `min:"1" type:"string" required:"true"`

	// The parent reference from which the object with the specified link name is
	// detached.
	//
	// ParentReference is a required field
	ParentReference *ObjectReference `type:"structure" required:"true"`
}

// String returns the string representation
func (s DetachObjectInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DetachObjectInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DetachObjectInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DetachObjectInput"}
	if s.DirectoryArn == nil {
		invalidParams.Add(request.NewErrParamRequired("DirectoryArn"))
	}
	if s.LinkName == nil {
		invalidParams.Add(request.NewErrParamRequired("LinkName"))
	}
	if s.LinkName != nil && len(*s.LinkName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LinkName", 1))
	}
	if s.ParentReference == nil {
		invalidParams.Add(request.NewErrParamRequired("ParentReference"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDirectoryArn sets the DirectoryArn field's value.
func (s *DetachObjectInput) SetDirectoryArn(v string) *DetachObjectInput {
	s.DirectoryArn = &v
	return s
}

// SetLinkName sets the LinkName field's value.
func (s *DetachObjectInput) SetLinkName(v string) *DetachObjectInput {
	s.LinkName = &v
	return s
}

// SetParentReference sets the ParentReference field's value.
func (s *DetachObjectInput) SetParentReference(v *ObjectReference) *DetachObjectInput {
	s.ParentReference = v
	return s
}

type DetachObjectOutput struct {
	_ struct{} `type:"structure"`

	// The ObjectIdentifier that was detached from the object.
	DetachedObjectIdentifier *string `type:"string"`
}

// String returns the string representation
func (s DetachObjectOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DetachObjectOutput) GoString() string {
	return s.String()
}

// SetDetachedObjectIdentifier sets the DetachedObjectIdentifier field's value.
func (s *DetachObjectOutput) SetDetachedObjectIdentifier(v string) *DetachObjectOutput {
	s.DetachedObjectIdentifier = &v
	return s
}

type DetachPolicyInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) that is associated with the Directory where
	// both objects reside. For more information, see arns.
	//
	// DirectoryArn is a required field
	DirectoryArn *string `location:"header" locationName:"x-amz-data-partition" type:"string" required:"true"`

	// Reference that identifies the object whose policy object will be detached.
	//
	// ObjectReference is a required field
	ObjectReference *ObjectReference `type:"structure" required:"true"`

	// Reference that identifies the policy object.
	//
	// PolicyReference is a required field
	PolicyReference *ObjectReference `type:"structure" required:"true"`
}

// String returns the string representation
func (s DetachPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DetachPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DetachPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DetachPolicyInput"}
	if s.DirectoryArn == nil {
		invalidParams.Add(request.NewErrParamRequired("DirectoryArn"))
	}
	if s.ObjectReference == nil {
		invalidParams.Add(request.NewErrParamRequired("ObjectReference"))
	}
	if s.PolicyReference == nil {
		invalidParams.Add(request.NewErrParamRequired("PolicyReference"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDirectoryArn sets the DirectoryArn field's value.
func (s *DetachPolicyInput) SetDirectoryArn(v string) *DetachPolicyInput {
	s.DirectoryArn = &v
	return s
}

// SetObjectReference sets the ObjectReference field's value.
func (s *DetachPolicyInput) SetObjectReference(v *ObjectReference) *DetachPolicyInput {
	s.ObjectReference = v
	return s
}

// SetPolicyReference sets the PolicyReference field's value.
func (s *DetachPolicyInput) SetPolicyReference(v *ObjectReference) *DetachPolicyInput {
	s.PolicyReference = v
	return s
}

type DetachPolicyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DetachPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DetachPolicyOutput) GoString() string {
	return s.String()
}

type DetachTypedLinkInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the directory where you want to detach
	// the typed link.
	//
	// DirectoryArn is a required field
	DirectoryArn *string `location:"header" locationName:"x-amz-data-partition" type:"string" required:"true"`

	// Used to accept a typed link specifier as input.
	//
	// TypedLinkSpecifier is a required field
	TypedLinkSpecifier *TypedLinkSpecifier `type:"structure" required:"true"`
}

// String returns the string representation
func (s DetachTypedLinkInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DetachTypedLinkInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DetachTypedLinkInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DetachTypedLinkInput"}
	if s.DirectoryArn == nil {
		invalidParams.Add(request.NewErrParamRequired("DirectoryArn"))
	}
	if s.TypedLinkSpecifier == nil {
		invalidParams.Add(request.NewErrParamRequired("TypedLinkSpecifier"))
	}
	if s.TypedLinkSpecifier != nil {
		if err := s.TypedLinkSpecifier.Validate(); err != nil {
			invalidParams.AddNested("TypedLinkSpecifier", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDirectoryArn sets the DirectoryArn field's value.
func (s *DetachTypedLinkInput) SetDirectoryArn(v string) *DetachTypedLinkInput {
	s.DirectoryArn = &v
	return s
}

// SetTypedLinkSpecifier sets the TypedLinkSpecifier field's value.
func (s *DetachTypedLinkInput) SetTypedLinkSpecifier(v *TypedLinkSpecifier) *DetachTypedLinkInput {
	s.TypedLinkSpecifier = v
	return s
}

type DetachTypedLinkOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DetachTypedLinkOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DetachTypedLinkOutput) GoString() string {
	return s.String()
}

// Directory structure that includes the directory name and directory ARN.
type Directory struct {
	_ struct{} `type:"structure"`

	// The date and time when the directory was created.
	CreationDateTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The Amazon Resource Name (ARN) that is associated with the directory. For
	// more information, see arns.
	DirectoryArn *string `type:"string"`

	// The name of the directory.
	Name *string `min:"1" type:"string"`

	// The state of the directory. Can be either Enabled, Disabled, or Deleted.
	State *string `type:"string" enum:"DirectoryState"`
}

// String returns the string representation
func (s Directory) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Directory) GoString() string {
	return s.String()
}

// SetCreationDateTime sets the CreationDateTime field's value.
func (s *Directory) SetCreationDateTime(v time.Time) *Directory {
	s.CreationDateTime = &v
	return s
}

// SetDirectoryArn sets the DirectoryArn field's value.
func (s *Directory) SetDirectoryArn(v string) *Directory {
	s.DirectoryArn = &v
	return s
}

// SetName sets the Name field's value.
func (s *Directory) SetName(v string) *Directory {
	s.Name = &v
	return s
}

// SetState sets the State field's value.
func (s *Directory) SetState(v string) *Directory {
	s.State = &v
	return s
}

type DisableDirectoryInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the directory to disable.
	//
	// DirectoryArn is a required field
	DirectoryArn *string `location:"header" locationName:"x-amz-data-partition" type:"string" required:"true"`
}

// String returns the string representation
func (s DisableDirectoryInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisableDirectoryInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DisableDirectoryInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DisableDirectoryInput"}
	if s.DirectoryArn == nil {
		invalidParams.Add(request.NewErrParamRequired("DirectoryArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDirectoryArn sets the DirectoryArn field's value.
func (s *DisableDirectoryInput) SetDirectoryArn(v string) *DisableDirectoryInput {
	s.DirectoryArn = &v
	return s
}

type DisableDirectoryOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the directory that has been disabled.
	//
	// DirectoryArn is a required field
	DirectoryArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DisableDirectoryOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisableDirectoryOutput) GoString() string {
	return s.String()
}

// SetDirectoryArn sets the DirectoryArn field's value.
func (s *DisableDirectoryOutput) SetDirectoryArn(v string) *DisableDirectoryOutput {
	s.DirectoryArn = &v
	return s
}

type EnableDirectoryInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the directory to enable.
	//
	// DirectoryArn is a required field
	DirectoryArn *string `location:"header" locationName:"x-amz-data-partition" type:"string" required:"true"`
}

// String returns the string representation
func (s EnableDirectoryInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EnableDirectoryInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EnableDirectoryInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EnableDirectoryInput"}
	if s.DirectoryArn == nil {
		invalidParams.Add(request.NewErrParamRequired("DirectoryArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDirectoryArn sets the DirectoryArn field's value.
func (s *EnableDirectoryInput) SetDirectoryArn(v string) *EnableDirectoryInput {
	s.DirectoryArn = &v
	return s
}

type EnableDirectoryOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the enabled directory.
	//
	// DirectoryArn is a required field
	DirectoryArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s EnableDirectoryOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EnableDirectoryOutput) GoString() string {
	return s.String()
}

// SetDirectoryArn sets the DirectoryArn field's value.
func (s *EnableDirectoryOutput) SetDirectoryArn(v string) *EnableDirectoryOutput {
	s.DirectoryArn = &v
	return s
}

// A structure that contains Name, ARN, Attributes, Rules, and ObjectTypes.
// See Facets (http://docs.aws.amazon.com/directoryservice/latest/admin-guide/whatarefacets.html)
// for more information.
type Facet struct {
	_ struct{} `type:"structure"`

	// The name of the Facet.
	Name *string `min:"1" type:"string"`

	// The object type that is associated with the facet. See CreateFacetRequest$ObjectType
	// for more details.
	ObjectType *string `type:"string" enum:"ObjectType"`
}

// String returns the string representation
func (s Facet) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Facet) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *Facet) SetName(v string) *Facet {
	s.Name = &v
	return s
}

// SetObjectType sets the ObjectType field's value.
func (s *Facet) SetObjectType(v string) *Facet {
	s.ObjectType = &v
	return s
}

// An attribute that is associated with the Facet.
type FacetAttribute struct {
	_ struct{} `type:"structure"`

	// A facet attribute consists of either a definition or a reference. This structure
	// contains the attribute definition. See Attribute References (http://docs.aws.amazon.com/directoryservice/latest/admin-guide/cd_advanced.html#attributereferences)
	// for more information.
	AttributeDefinition *FacetAttributeDefinition `type:"structure"`

	// An attribute reference that is associated with the attribute. See Attribute
	// References (http://docs.aws.amazon.com/directoryservice/latest/admin-guide/cd_advanced.html#attributereferences)
	// for more information.
	AttributeReference *FacetAttributeReference `type:"structure"`

	// The name of the facet attribute.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The required behavior of the FacetAttribute.
	RequiredBehavior *string `type:"string" enum:"RequiredAttributeBehavior"`
}

// String returns the string representation
func (s FacetAttribute) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s FacetAttribute) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *FacetAttribute) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "FacetAttribute"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.AttributeDefinition != nil {
		if err := s.AttributeDefinition.Validate(); err != nil {
			invalidParams.AddNested("AttributeDefinition", err.(request.ErrInvalidParams))
		}
	}
	if s.AttributeReference != nil {
		if err := s.AttributeReference.Validate(); err != nil {
			invalidParams.AddNested("AttributeReference", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAttributeDefinition sets the AttributeDefinition field's value.
func (s *FacetAttribute) SetAttributeDefinition(v *FacetAttributeDefinition) *FacetAttribute {
	s.AttributeDefinition = v
	return s
}

// SetAttributeReference sets the AttributeReference field's value.
func (s *FacetAttribute) SetAttributeReference(v *FacetAttributeReference) *FacetAttribute {
	s.AttributeReference = v
	return s
}

// SetName sets the Name field's value.
func (s *FacetAttribute) SetName(v string) *FacetAttribute {
	s.Name = &v
	return s
}

// SetRequiredBehavior sets the RequiredBehavior field's value.
func (s *FacetAttribute) SetRequiredBehavior(v string) *FacetAttribute {
	s.RequiredBehavior = &v
	return s
}

// A facet attribute definition. See Attribute References (http://docs.aws.amazon.com/directoryservice/latest/admin-guide/cd_advanced.html#attributereferences)
// for more information.
type FacetAttributeDefinition struct {
	_ struct{} `type:"structure"`

	// The default value of the attribute (if configured).
	DefaultValue *TypedAttributeValue `type:"structure"`

	// Whether the attribute is mutable or not.
	IsImmutable *bool `type:"boolean"`

	// Validation rules attached to the attribute definition.
	Rules map[string]*Rule `type:"map"`

	// The type of the attribute.
	//
	// Type is a required field
	Type *string `type:"string" required:"true" enum:"FacetAttributeType"`
}

// String returns the string representation
func (s FacetAttributeDefinition) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s FacetAttributeDefinition) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *FacetAttributeDefinition) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "FacetAttributeDefinition"}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDefaultValue sets the DefaultValue field's value.
func (s *FacetAttributeDefinition) SetDefaultValue(v *TypedAttributeValue) *FacetAttributeDefinition {
	s.DefaultValue = v
	return s
}

// SetIsImmutable sets the IsImmutable field's value.
func (s *FacetAttributeDefinition) SetIsImmutable(v bool) *FacetAttributeDefinition {
	s.IsImmutable = &v
	return s
}

// SetRules sets the Rules field's value.
func (s *FacetAttributeDefinition) SetRules(v map[string]*Rule) *FacetAttributeDefinition {
	s.Rules = v
	return s
}

// SetType sets the Type field's value.
func (s *FacetAttributeDefinition) SetType(v string) *FacetAttributeDefinition {
	s.Type = &v
	return s
}

// The facet attribute reference that specifies the attribute definition that
// contains the attribute facet name and attribute name.
type FacetAttributeReference struct {
	_ struct{} `type:"structure"`

	// The target attribute name that is associated with the facet reference. See
	// Attribute References (http://docs.aws.amazon.com/directoryservice/latest/admin-guide/cd_advanced.html#attributereferences)
	// for more information.
	//
	// TargetAttributeName is a required field
	TargetAttributeName *string `min:"1" type:"string" required:"true"`

	// The target facet name that is associated with the facet reference. See Attribute
	// References (http://docs.aws.amazon.com/directoryservice/latest/admin-guide/cd_advanced.html#attributereferences)
	// for more information.
	//
	// TargetFacetName is a required field
	TargetFacetName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s FacetAttributeReference) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s FacetAttributeReference) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *FacetAttributeReference) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "FacetAttributeReference"}
	if s.TargetAttributeName == nil {
		invalidParams.Add(request.NewErrParamRequired("TargetAttributeName"))
	}
	if s.TargetAttributeName != nil && len(*s.TargetAttributeName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TargetAttributeName", 1))
	}
	if s.TargetFacetName == nil {
		invalidParams.Add(request.NewErrParamRequired("TargetFacetName"))
	}
	if s.TargetFacetName != nil && len(*s.TargetFacetName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TargetFacetName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTargetAttributeName sets the TargetAttributeName field's value.
func (s *FacetAttributeReference) SetTargetAttributeName(v string) *FacetAttributeReference {
	s.TargetAttributeName = &v
	return s
}

// SetTargetFacetName sets the TargetFacetName field's value.
func (s *FacetAttributeReference) SetTargetFacetName(v string) *FacetAttributeReference {
	s.TargetFacetName = &v
	return s
}

// A structure that contains information used to update an attribute.
type FacetAttributeUpdate struct {
	_ struct{} `type:"structure"`

	// The action to perform when updating the attribute.
	Action *string `type:"string" enum:"UpdateActionType"`

	// The attribute to update.
	Attribute *FacetAttribute `type:"structure"`
}

// String returns the string representation
func (s FacetAttributeUpdate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s FacetAttributeUpdate) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *FacetAttributeUpdate) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "FacetAttributeUpdate"}
	if s.Attribute != nil {
		if err := s.Attribute.Validate(); err != nil {
			invalidParams.AddNested("Attribute", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAction sets the Action field's value.
func (s *FacetAttributeUpdate) SetAction(v string) *FacetAttributeUpdate {
	s.Action = &v
	return s
}

// SetAttribute sets the Attribute field's value.
func (s *FacetAttributeUpdate) SetAttribute(v *FacetAttribute) *FacetAttributeUpdate {
	s.Attribute = v
	return s
}

type GetAppliedSchemaVersionInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the applied schema.
	//
	// SchemaArn is a required field
	SchemaArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s GetAppliedSchemaVersionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetAppliedSchemaVersionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetAppliedSchemaVersionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetAppliedSchemaVersionInput"}
	if s.SchemaArn == nil {
		invalidParams.Add(request.NewErrParamRequired("SchemaArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSchemaArn sets the SchemaArn field's value.
func (s *GetAppliedSchemaVersionInput) SetSchemaArn(v string) *GetAppliedSchemaVersionInput {
	s.SchemaArn = &v
	return s
}

type GetAppliedSchemaVersionOutput struct {
	_ struct{} `type:"structure"`

	// Current applied schema ARN, including the minor version in use if one was
	// provided.
	AppliedSchemaArn *string `type:"string"`
}

// String returns the string representation
func (s GetAppliedSchemaVersionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetAppliedSchemaVersionOutput) GoString() string {
	return s.String()
}

// SetAppliedSchemaArn sets the AppliedSchemaArn field's value.
func (s *GetAppliedSchemaVersionOutput) SetAppliedSchemaArn(v string) *GetAppliedSchemaVersionOutput {
	s.AppliedSchemaArn = &v
	return s
}

type GetDirectoryInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the directory.
	//
	// DirectoryArn is a required field
	DirectoryArn *string `location:"header" locationName:"x-amz-data-partition" type:"string" required:"true"`
}

// String returns the string representation
func (s GetDirectoryInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDirectoryInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetDirectoryInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetDirectoryInput"}
	if s.DirectoryArn == nil {
		invalidParams.Add(request.NewErrParamRequired("DirectoryArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDirectoryArn sets the DirectoryArn field's value.
func (s *GetDirectoryInput) SetDirectoryArn(v string) *GetDirectoryInput {
	s.DirectoryArn = &v
	return s
}

type GetDirectoryOutput struct {
	_ struct{} `type:"structure"`

	// Metadata about the directory.
	//
	// Directory is a required field
	Directory *Directory `type:"structure" required:"true"`
}

// String returns the string representation
func (s GetDirectoryOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDirectoryOutput) GoString() string {
	return s.String()
}

// SetDirectory sets the Directory field's value.
func (s *GetDirectoryOutput) SetDirectory(v *Directory) *GetDirectoryOutput {
	s.Directory = v
	return s
}

type GetFacetInput struct {
	_ struct{} `type:"structure"`

	// The name of the facet to retrieve.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) that is associated with the Facet. For more
	// information, see arns.
	//
	// SchemaArn is a required field
	SchemaArn *string `location:"header" locationName:"x-amz-data-partition" type:"string" required:"true"`
}

// String returns the string representation
func (s GetFacetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetFacetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetFacetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetFacetInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.SchemaArn == nil {
		invalidParams.Add(request.NewErrParamRequired("SchemaArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *GetFacetInput) SetName(v string) *GetFacetInput {
	s.Name = &v
	return s
}

// SetSchemaArn sets the SchemaArn field's value.
func (s *GetFacetInput) SetSchemaArn(v string) *GetFacetInput {
	s.SchemaArn = &v
	return s
}

type GetFacetOutput struct {
	_ struct{} `type:"structure"`

	// The Facet structure that is associated with the facet.
	Facet *Facet `type:"structure"`
}

// String returns the string representation
func (s GetFacetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetFacetOutput) GoString() string {
	return s.String()
}

// SetFacet sets the Facet field's value.
func (s *GetFacetOutput) SetFacet(v *Facet) *GetFacetOutput {
	s.Facet = v
	return s
}

type GetObjectAttributesInput struct {
	_ struct{} `type:"structure"`

	// List of attribute names whose values will be retrieved.
	//
	// AttributeNames is a required field
	AttributeNames []*string `type:"list" required:"true"`

	// The consistency level at which to retrieve the attributes on an object.
	ConsistencyLevel *string `location:"header" locationName:"x-amz-consistency-level" type:"string" enum:"ConsistencyLevel"`

	// The Amazon Resource Name (ARN) that is associated with the Directory where
	// the object resides.
	//
	// DirectoryArn is a required field
	DirectoryArn *string `location:"header" locationName:"x-amz-data-partition" type:"string" required:"true"`

	// Reference that identifies the object whose attributes will be retrieved.
	//
	// ObjectReference is a required field
	ObjectReference *ObjectReference `type:"structure" required:"true"`

	// Identifier for the facet whose attributes will be retrieved. See SchemaFacet
	// for details.
	//
	// SchemaFacet is a required field
	SchemaFacet *SchemaFacet `type:"structure" required:"true"`
}

// String returns the string representation
func (s GetObjectAttributesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetObjectAttributesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetObjectAttributesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetObjectAttributesInput"}
	if s.AttributeNames == nil {
		invalidParams.Add(request.NewErrParamRequired("AttributeNames"))
	}
	if s.DirectoryArn == nil {
		invalidParams.Add(request.NewErrParamRequired("DirectoryArn"))
	}
	if s.ObjectReference == nil {
		invalidParams.Add(request.NewErrParamRequired("ObjectReference"))
	}
	if s.SchemaFacet == nil {
		invalidParams.Add(request.NewErrParamRequired("SchemaFacet"))
	}
	if s.SchemaFacet != nil {
		if err := s.SchemaFacet.Validate(); err != nil {
			invalidParams.AddNested("SchemaFacet", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAttributeNames sets the AttributeNames field's value.
func (s *GetObjectAttributesInput) SetAttributeNames(v []*string) *GetObjectAttributesInput {
	s.AttributeNames = v
	return s
}

// SetConsistencyLevel sets the ConsistencyLevel field's value.
func (s *GetObjectAttributesInput) SetConsistencyLevel(v string) *GetObjectAttributesInput {
	s.ConsistencyLevel = &v
	return s
}

// SetDirectoryArn sets the DirectoryArn field's value.
func (s *GetObjectAttributesInput) SetDirectoryArn(v string) *GetObjectAttributesInput {
	s.DirectoryArn = &v
	return s
}

// SetObjectReference sets the ObjectReference field's value.
func (s *GetObjectAttributesInput) SetObjectReference(v *ObjectReference) *GetObjectAttributesInput {
	s.ObjectReference = v
	return s
}

// SetSchemaFacet sets the SchemaFacet field's value.
func (s *GetObjectAttributesInput) SetSchemaFacet(v *SchemaFacet) *GetObjectAttributesInput {
	s.SchemaFacet = v
	return s
}

type GetObjectAttributesOutput struct {
	_ struct{} `type:"structure"`

	// The attributes that are associated with the object.
	Attributes []*AttributeKeyAndValue `type:"list"`
}

// String returns the string representation
func (s GetObjectAttributesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetObjectAttributesOutput) GoString() string {
	return s.String()
}

// SetAttributes sets the Attributes field's value.
func (s *GetObjectAttributesOutput) SetAttributes(v []*AttributeKeyAndValue) *GetObjectAttributesOutput {
	s.Attributes = v
	return s
}

type GetObjectInformationInput struct {
	_ struct{} `type:"structure"`

	// The consistency level at which to retrieve the object information.
	ConsistencyLevel *string `location:"header" locationName:"x-amz-consistency-level" type:"string" enum:"ConsistencyLevel"`

	// The ARN of the directory being retrieved.
	//
	// DirectoryArn is a required field
	DirectoryArn *string `location:"header" locationName:"x-amz-data-partition" type:"string" required:"true"`

	// A reference to the object.
	//
	// ObjectReference is a required field
	ObjectReference *ObjectReference `type:"structure" required:"true"`
}

// String returns the string representation
func (s GetObjectInformationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetObjectInformationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetObjectInformationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetObjectInformationInput"}
	if s.DirectoryArn == nil {
		invalidParams.Add(request.NewErrParamRequired("DirectoryArn"))
	}
	if s.ObjectReference == nil {
		invalidParams.Add(request.NewErrParamRequired("ObjectReference"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConsistencyLevel sets the ConsistencyLevel field's value.
func (s *GetObjectInformationInput) SetConsistencyLevel(v string) *GetObjectInformationInput {
	s.ConsistencyLevel = &v
	return s
}

// SetDirectoryArn sets the DirectoryArn field's value.
func (s *GetObjectInformationInput) SetDirectoryArn(v string) *GetObjectInformationInput {
	s.DirectoryArn = &v
	return s
}

// SetObjectReference sets the ObjectReference field's value.
func (s *GetObjectInformationInput) SetObjectReference(v *ObjectReference) *GetObjectInformationInput {
	s.ObjectReference = v
	return s
}

type GetObjectInformationOutput struct {
	_ struct{} `type:"structure"`

	// The ObjectIdentifier of the specified object.
	ObjectIdentifier *string `type:"string"`

	// The facets attached to the specified object. Although the response does not
	// include minor version information, the most recently applied minor version
	// of each Facet is in effect. See GetAppliedSchemaVersion for details.
	SchemaFacets []*SchemaFacet `type:"list"`
}

// String returns the string representation
func (s GetObjectInformationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetObjectInformationOutput) GoString() string {
	return s.String()
}

// SetObjectIdentifier sets the ObjectIdentifier field's value.
func (s *GetObjectInformationOutput) SetObjectIdentifier(v string) *GetObjectInformationOutput {
	s.ObjectIdentifier = &v
	return s
}

// SetSchemaFacets sets the SchemaFacets field's value.
func (s *GetObjectInformationOutput) SetSchemaFacets(v []*SchemaFacet) *GetObjectInformationOutput {
	s.SchemaFacets = v
	return s
}

type GetSchemaAsJsonInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the schema to retrieve.
	//
	// SchemaArn is a required field
	SchemaArn *string `location:"header" locationName:"x-amz-data-partition" type:"string" required:"true"`
}

// String returns the string representation
func (s GetSchemaAsJsonInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetSchemaAsJsonInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetSchemaAsJsonInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetSchemaAsJsonInput"}
	if s.SchemaArn == nil {
		invalidParams.Add(request.NewErrParamRequired("SchemaArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSchemaArn sets the SchemaArn field's value.
func (s *GetSchemaAsJsonInput) SetSchemaArn(v string) *GetSchemaAsJsonInput {
	s.SchemaArn = &v
	return s
}

type GetSchemaAsJsonOutput struct {
	_ struct{} `type:"structure"`

	// The JSON representation of the schema document.
	Document *string `type:"string"`

	// The name of the retrieved schema.
	Name *string `min:"1" type:"string"`
}

// String returns the string representation
func (s GetSchemaAsJsonOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetSchemaAsJsonOutput) GoString() string {
	return s.String()
}

// SetDocument sets the Document field's value.
func (s *GetSchemaAsJsonOutput) SetDocument(v string) *GetSchemaAsJsonOutput {
	s.Document = &v
	return s
}

// SetName sets the Name field's value.
func (s *GetSchemaAsJsonOutput) SetName(v string) *GetSchemaAsJsonOutput {
	s.Name = &v
	return s
}

type GetTypedLinkFacetInformationInput struct {
	_ struct{} `type:"structure"`

	// The unique name of the typed link facet.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`

	// The Amazon Resource Name (ARN) that is associated with the schema. For more
	// information, see arns.
	//
	// SchemaArn is a required field
	SchemaArn *string `location:"header" locationName:"x-amz-data-partition" type:"string" required:"true"`
}

// String returns the string representation
func (s GetTypedLinkFacetInformationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetTypedLinkFacetInformationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetTypedLinkFacetInformationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetTypedLinkFacetInformationInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.SchemaArn == nil {
		invalidParams.Add(request.NewErrParamRequired("SchemaArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *GetTypedLinkFacetInformationInput) SetName(v string) *GetTypedLinkFacetInformationInput {
	s.Name = &v
	return s
}

// SetSchemaArn sets the SchemaArn field's value.
func (s *GetTypedLinkFacetInformationInput) SetSchemaArn(v string) *GetTypedLinkFacetInformationInput {
	s.SchemaArn = &v
	return s
}

type GetTypedLinkFacetInformationOutput struct {
	_ struct{} `type:"structure"`

	// The order of identity attributes for the facet, from most significant to
	// least significant. The ability to filter typed links considers the order
	// that the attributes are defined on the typed link facet. When providing ranges
	// to typed link selection, any inexact ranges must be specified at the end.
	// Any attributes that do not have a range specified are presumed to match the
	// entire range. Filters are interpreted in the order of the attributes on the
	// typed link facet, not the order in which they are supplied to any API calls.
	// For more information about identity attributes, see Typed link (http://docs.aws.amazon.com/directoryservice/latest/admin-guide/objectsandlinks.html#typedlink).
	IdentityAttributeOrder []*string `type:"list"`
}

// String returns the string representation
func (s GetTypedLinkFacetInformationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetTypedLinkFacetInformationOutput) GoString() string {
	return s.String()
}

// SetIdentityAttributeOrder sets the IdentityAttributeOrder field's value.
func (s *GetTypedLinkFacetInformationOutput) SetIdentityAttributeOrder(v []*string) *GetTypedLinkFacetInformationOutput {
	s.IdentityAttributeOrder = v
	return s
}

// Represents an index and an attached object.
type IndexAttachment struct {
	_ struct{} `type:"structure"`

	// The indexed attribute values.
	IndexedAttributes []*AttributeKeyAndValue `type:"list"`

	// In response to ListIndex, the ObjectIdentifier of the object attached to
	// the index. In response to ListAttachedIndices, the ObjectIdentifier of the
	// index attached to the object. This field will always contain the ObjectIdentifier
	// of the object on the opposite side of the attachment specified in the query.
	ObjectIdentifier *string `type:"string"`
}

// String returns the string representation
func (s IndexAttachment) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s IndexAttachment) GoString() string {
	return s.String()
}

// SetIndexedAttributes sets the IndexedAttributes field's value.
func (s *IndexAttachment) SetIndexedAttributes(v []*AttributeKeyAndValue) *IndexAttachment {
	s.IndexedAttributes = v
	return s
}

// SetObjectIdentifier sets the ObjectIdentifier field's value.
func (s *IndexAttachment) SetObjectIdentifier(v string) *IndexAttachment {
	s.ObjectIdentifier = &v
	return s
}

type ListAppliedSchemaArnsInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the directory you are listing.
	//
	// DirectoryArn is a required field
	DirectoryArn *string `type:"string" required:"true"`

	// The maximum number of results to retrieve.
	MaxResults *int64 `min:"1" type:"integer"`

	// The pagination token.
	NextToken *string `type:"string"`

	// The response for ListAppliedSchemaArns when this parameter is used will list
	// all minor version ARNs for a major version.
	SchemaArn *string `type:"string"`
}

// String returns the string representation
func (s ListAppliedSchemaArnsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListAppliedSchemaArnsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListAppliedSchemaArnsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListAppliedSchemaArnsInput"}
	if s.DirectoryArn == nil {
		invalidParams.Add(request.NewErrParamRequired("DirectoryArn"))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDirectoryArn sets the DirectoryArn field's value.
func (s *ListAppliedSchemaArnsInput) SetDirectoryArn(v string) *ListAppliedSchemaArnsInput {
	s.DirectoryArn = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListAppliedSchemaArnsInput) SetMaxResults(v int64) *ListAppliedSchemaArnsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAppliedSchemaArnsInput) SetNextToken(v string) *ListAppliedSchemaArnsInput {
	s.NextToken = &v
	return s
}

// SetSchemaArn sets the SchemaArn field's value.
func (s *ListAppliedSchemaArnsInput) SetSchemaArn(v string) *ListAppliedSchemaArnsInput {
	s.SchemaArn = &v
	return s
}

type ListAppliedSchemaArnsOutput struct {
	_ struct{} `type:"structure"`

	// The pagination token.
	NextToken *string `type:"string"`

	// The ARNs of schemas that are applied to the directory.
	SchemaArns []*string `type:"list"`
}

// String returns the string representation
func (s ListAppliedSchemaArnsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListAppliedSchemaArnsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListAppliedSchemaArnsOutput) SetNextToken(v string) *ListAppliedSchemaArnsOutput {
	s.NextToken = &v
	return s
}

// SetSchemaArns sets the SchemaArns field's value.
func (s *ListAppliedSchemaArnsOutput) SetSchemaArns(v []*string) *ListAppliedSchemaArnsOutput {
	s.SchemaArns = v
	return s
}

type ListAttachedIndicesInput struct {
	_ struct{} `type:"structure"`

	// The consistency level to use for this operation.
	ConsistencyLevel *string `location:"header" locationName:"x-amz-consistency-level" type:"string" enum:"ConsistencyLevel"`

	// The ARN of the directory.
	//
	// DirectoryArn is a required field
	DirectoryArn *string `location:"header" locationName:"x-amz-data-partition" type:"string" required:"true"`

	// The maximum number of results to retrieve.
	MaxResults *int64 `min:"1" type:"integer"`

	// The pagination token.
	NextToken *string `type:"string"`

	// A reference to the object that has indices attached.
	//
	// TargetReference is a required field
	TargetReference *ObjectReference `type:"structure" required:"true"`
}

// String returns the string representation
func (s ListAttachedIndicesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListAttachedIndicesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListAttachedIndicesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListAttachedIndicesInput"}
	if s.DirectoryArn == nil {
		invalidParams.Add(request.NewErrParamRequired("DirectoryArn"))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.TargetReference == nil {
		invalidParams.Add(request.NewErrParamRequired("TargetReference"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConsistencyLevel sets the ConsistencyLevel field's value.
func (s *ListAttachedIndicesInput) SetConsistencyLevel(v string) *ListAttachedIndicesInput {
	s.ConsistencyLevel = &v
	return s
}

// SetDirectoryArn sets the DirectoryArn field's value.
func (s *ListAttachedIndicesInput) SetDirectoryArn(v string) *ListAttachedIndicesInput {
	s.DirectoryArn = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListAttachedIndicesInput) SetMaxResults(v int64) *ListAttachedIndicesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAttachedIndicesInput) SetNextToken(v string) *ListAttachedIndicesInput {
	s.NextToken = &v
	return s
}

// SetTargetReference sets the TargetReference field's value.
func (s *ListAttachedIndicesInput) SetTargetReference(v *ObjectReference) *ListAttachedIndicesInput {
	s.TargetReference = v
	return s
}

type ListAttachedIndicesOutput struct {
	_ struct{} `type:"structure"`

	// The indices attached to the specified object.
	IndexAttachments []*IndexAttachment `type:"list"`

	// The pagination token.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListAttachedIndicesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListAttachedIndicesOutput) GoString() string {
	return s.String()
}

// SetIndexAttachments sets the IndexAttachments field's value.
func (s *ListAttachedIndicesOutput) SetIndexAttachments(v []*IndexAttachment) *ListAttachedIndicesOutput {
	s.IndexAttachments = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAttachedIndicesOutput) SetNextToken(v string) *ListAttachedIndicesOutput {
	s.NextToken = &v
	return s
}

type ListDevelopmentSchemaArnsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results to retrieve.
	MaxResults *int64 `min:"1" type:"integer"`

	// The pagination token.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListDevelopmentSchemaArnsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListDevelopmentSchemaArnsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListDevelopmentSchemaArnsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListDevelopmentSchemaArnsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListDevelopmentSchemaArnsInput) SetMaxResults(v int64) *ListDevelopmentSchemaArnsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDevelopmentSchemaArnsInput) SetNextToken(v string) *ListDevelopmentSchemaArnsInput {
	s.NextToken = &v
	return s
}

type ListDevelopmentSchemaArnsOutput struct {
	_ struct{} `type:"structure"`

	// The pagination token.
	NextToken *string `type:"string"`

	// The ARNs of retrieved development schemas.
	SchemaArns []*string `type:"list"`
}

// String returns the string representation
func (s ListDevelopmentSchemaArnsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListDevelopmentSchemaArnsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListDevelopmentSchemaArnsOutput) SetNextToken(v string) *ListDevelopmentSchemaArnsOutput {
	s.NextToken = &v
	return s
}

// SetSchemaArns sets the SchemaArns field's value.
func (s *ListDevelopmentSchemaArnsOutput) SetSchemaArns(v []*string) *ListDevelopmentSchemaArnsOutput {
	s.SchemaArns = v
	return s
}

type ListDirectoriesInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results to retrieve.
	MaxResults *int64 `min:"1" type:"integer"`

	// The pagination token.
	NextToken *string `type:"string"`

	// The state of the directories in the list. Can be either Enabled, Disabled,
	// or Deleted.
	State *string `locationName:"state" type:"string" enum:"DirectoryState"`
}

// String returns the string representation
func (s ListDirectoriesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListDirectoriesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListDirectoriesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListDirectoriesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListDirectoriesInput) SetMaxResults(v int64) *ListDirectoriesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDirectoriesInput) SetNextToken(v string) *ListDirectoriesInput {
	s.NextToken = &v
	return s
}

// SetState sets the State field's value.
func (s *ListDirectoriesInput) SetState(v string) *ListDirectoriesInput {
	s.State = &v
	return s
}

type ListDirectoriesOutput struct {
	_ struct{} `type:"structure"`

	// Lists all directories that are associated with your account in pagination
	// fashion.
	//
	// Directories is a required field
	Directories []*Directory `type:"list" required:"true"`

	// The pagination token.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListDirectoriesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListDirectoriesOutput) GoString() string {
	return s.String()
}

// SetDirectories sets the Directories field's value.
func (s *ListDirectoriesOutput) SetDirectories(v []*Directory) *ListDirectoriesOutput {
	s.Directories = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDirectoriesOutput) SetNextToken(v string) *ListDirectoriesOutput {
	s.NextToken = &v
	return s
}

type ListFacetAttributesInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results to retrieve.
	MaxResults *int64 `min:"1" type:"integer"`

	// The name of the facet whose attributes will be retrieved.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The pagination token.
	NextToken *string `type:"string"`

	// The ARN of the schema where the facet resides.
	//
	// SchemaArn is a required field
	SchemaArn *string `location:"header" locationName:"x-amz-data-partition" type:"string" required:"true"`
}

// String returns the string representation
func (s ListFacetAttributesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListFacetAttributesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListFacetAttributesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListFacetAttributesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.SchemaArn == nil {
		invalidParams.Add(request.NewErrParamRequired("SchemaArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListFacetAttributesInput) SetMaxResults(v int64) *ListFacetAttributesInput {
	s.MaxResults = &v
	return s
}

// SetName sets the Name field's value.
func (s *ListFacetAttributesInput) SetName(v string) *ListFacetAttributesInput {
	s.Name = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListFacetAttributesInput) SetNextToken(v string) *ListFacetAttributesInput {
	s.NextToken = &v
	return s
}

// SetSchemaArn sets the SchemaArn field's value.
func (s *ListFacetAttributesInput) SetSchemaArn(v string) *ListFacetAttributesInput {
	s.SchemaArn = &v
	return s
}

type ListFacetAttributesOutput struct {
	_ struct{} `type:"structure"`

	// The attributes attached to the facet.
	Attributes []*FacetAttribute `type:"list"`

	// The pagination token.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListFacetAttributesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListFacetAttributesOutput) GoString() string {
	return s.String()
}

// SetAttributes sets the Attributes field's value.
func (s *ListFacetAttributesOutput) SetAttributes(v []*FacetAttribute) *ListFacetAttributesOutput {
	s.Attributes = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListFacetAttributesOutput) SetNextToken(v string) *ListFacetAttributesOutput {
	s.NextToken = &v
	return s
}

type ListFacetNamesInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results to retrieve.
	MaxResults *int64 `min:"1" type:"integer"`

	// The pagination token.
	NextToken *string `type:"string"`

	// The Amazon Resource Name (ARN) to retrieve facet names from.
	//
	// SchemaArn is a required field
	SchemaArn *string `location:"header" locationName:"x-amz-data-partition" type:"string" required:"true"`
}

// String returns the string representation
func (s ListFacetNamesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListFacetNamesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListFacetNamesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListFacetNamesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.SchemaArn == nil {
		invalidParams.Add(request.NewErrParamRequired("SchemaArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListFacetNamesInput) SetMaxResults(v int64) *ListFacetNamesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListFacetNamesInput) SetNextToken(v string) *ListFacetNamesInput {
	s.NextToken = &v
	return s
}

// SetSchemaArn sets the SchemaArn field's value.
func (s *ListFacetNamesInput) SetSchemaArn(v string) *ListFacetNamesInput {
	s.SchemaArn = &v
	return s
}

type ListFacetNamesOutput struct {
	_ struct{} `type:"structure"`

	// The names of facets that exist within the schema.
	FacetNames []*string `type:"list"`

	// The pagination token.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListFacetNamesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListFacetNamesOutput) GoString() string {
	return s.String()
}

// SetFacetNames sets the FacetNames field's value.
func (s *ListFacetNamesOutput) SetFacetNames(v []*string) *ListFacetNamesOutput {
	s.FacetNames = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListFacetNamesOutput) SetNextToken(v string) *ListFacetNamesOutput {
	s.NextToken = &v
	return s
}

type ListIncomingTypedLinksInput struct {
	_ struct{} `type:"structure"`

	// The consistency level to execute the request at.
	ConsistencyLevel *string `type:"string" enum:"ConsistencyLevel"`

	// The Amazon Resource Name (ARN) of the directory where you want to list the
	// typed links.
	//
	// DirectoryArn is a required field
	DirectoryArn *string `location:"header" locationName:"x-amz-data-partition" type:"string" required:"true"`

	// Provides range filters for multiple attributes. When providing ranges to
	// typed link selection, any inexact ranges must be specified at the end. Any
	// attributes that do not have a range specified are presumed to match the entire
	// range.
	FilterAttributeRanges []*TypedLinkAttributeRange `type:"list"`

	// Filters are interpreted in the order of the attributes on the typed link
	// facet, not the order in which they are supplied to any API calls.
	FilterTypedLink *TypedLinkSchemaAndFacetName `type:"structure"`

	// The maximum number of results to retrieve.
	MaxResults *int64 `min:"1" type:"integer"`

	// The pagination token.
	NextToken *string `type:"string"`

	// Reference that identifies the object whose attributes will be listed.
	//
	// ObjectReference is a required field
	ObjectReference *ObjectReference `type:"structure" required:"true"`
}

// String returns the string representation
func (s ListIncomingTypedLinksInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListIncomingTypedLinksInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListIncomingTypedLinksInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListIncomingTypedLinksInput"}
	if s.DirectoryArn == nil {
		invalidParams.Add(request.NewErrParamRequired("DirectoryArn"))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.ObjectReference == nil {
		invalidParams.Add(request.NewErrParamRequired("ObjectReference"))
	}
	if s.FilterAttributeRanges != nil {
		for i, v := range s.FilterAttributeRanges {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "FilterAttributeRanges", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.FilterTypedLink != nil {
		if err := s.FilterTypedLink.Validate(); err != nil {
			invalidParams.AddNested("FilterTypedLink", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConsistencyLevel sets the ConsistencyLevel field's value.
func (s *ListIncomingTypedLinksInput) SetConsistencyLevel(v string) *ListIncomingTypedLinksInput {
	s.ConsistencyLevel = &v
	return s
}

// SetDirectoryArn sets the DirectoryArn field's value.
func (s *ListIncomingTypedLinksInput) SetDirectoryArn(v string) *ListIncomingTypedLinksInput {
	s.DirectoryArn = &v
	return s
}

// SetFilterAttributeRanges sets the FilterAttributeRanges field's value.
func (s *ListIncomingTypedLinksInput) SetFilterAttributeRanges(v []*TypedLinkAttributeRange) *ListIncomingTypedLinksInput {
	s.FilterAttributeRanges = v
	return s
}

// SetFilterTypedLink sets the FilterTypedLink field's value.
func (s *ListIncomingTypedLinksInput) SetFilterTypedLink(v *TypedLinkSchemaAndFacetName) *ListIncomingTypedLinksInput {
	s.FilterTypedLink = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListIncomingTypedLinksInput) SetMaxResults(v int64) *ListIncomingTypedLinksInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListIncomingTypedLinksInput) SetNextToken(v string) *ListIncomingTypedLinksInput {
	s.NextToken = &v
	return s
}

// SetObjectReference sets the ObjectReference field's value.
func (s *ListIncomingTypedLinksInput) SetObjectReference(v *ObjectReference) *ListIncomingTypedLinksInput {
	s.ObjectReference = v
	return s
}

type ListIncomingTypedLinksOutput struct {
	_ struct{} `type:"structure"`

	// Returns one or more typed link specifiers as output.
	LinkSpecifiers []*TypedLinkSpecifier `type:"list"`

	// The pagination token.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListIncomingTypedLinksOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListIncomingTypedLinksOutput) GoString() string {
	return s.String()
}

// SetLinkSpecifiers sets the LinkSpecifiers field's value.
func (s *ListIncomingTypedLinksOutput) SetLinkSpecifiers(v []*TypedLinkSpecifier) *ListIncomingTypedLinksOutput {
	s.LinkSpecifiers = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListIncomingTypedLinksOutput) SetNextToken(v string) *ListIncomingTypedLinksOutput {
	s.NextToken = &v
	return s
}

type ListIndexInput struct {
	_ struct{} `type:"structure"`

	// The consistency level to execute the request at.
	ConsistencyLevel *string `location:"header" locationName:"x-amz-consistency-level" type:"string" enum:"ConsistencyLevel"`

	// The ARN of the directory that the index exists in.
	//
	// DirectoryArn is a required field
	DirectoryArn *string `location:"header" locationName:"x-amz-data-partition" type:"string" required:"true"`

	// The reference to the index to list.
	//
	// IndexReference is a required field
	IndexReference *ObjectReference `type:"structure" required:"true"`

	// The maximum number of objects in a single page to retrieve from the index
	// during a request. For more information, see AWS Directory Service Limits
	// (http://docs.aws.amazon.com/directoryservice/latest/admin-guide/limits.html#limits_cd).
	MaxResults *int64 `min:"1" type:"integer"`

	// The pagination token.
	NextToken *string `type:"string"`

	// Specifies the ranges of indexed values that you want to query.
	RangesOnIndexedValues []*ObjectAttributeRange `type:"list"`
}

// String returns the string representation
func (s ListIndexInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListIndexInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListIndexInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListIndexInput"}
	if s.DirectoryArn == nil {
		invalidParams.Add(request.NewErrParamRequired("DirectoryArn"))
	}
	if s.IndexReference == nil {
		invalidParams.Add(request.NewErrParamRequired("IndexReference"))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.RangesOnIndexedValues != nil {
		for i, v := range s.RangesOnIndexedValues {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "RangesOnIndexedValues", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConsistencyLevel sets the ConsistencyLevel field's value.
func (s *ListIndexInput) SetConsistencyLevel(v string) *ListIndexInput {
	s.ConsistencyLevel = &v
	return s
}

// SetDirectoryArn sets the DirectoryArn field's value.
func (s *ListIndexInput) SetDirectoryArn(v string) *ListIndexInput {
	s.DirectoryArn = &v
	return s
}

// SetIndexReference sets the IndexReference field's value.
func (s *ListIndexInput) SetIndexReference(v *ObjectReference) *ListIndexInput {
	s.IndexReference = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListIndexInput) SetMaxResults(v int64) *ListIndexInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListIndexInput) SetNextToken(v string) *ListIndexInput {
	s.NextToken = &v
	return s
}

// SetRangesOnIndexedValues sets the RangesOnIndexedValues field's value.
func (s *ListIndexInput) SetRangesOnIndexedValues(v []*ObjectAttributeRange) *ListIndexInput {
	s.RangesOnIndexedValues = v
	return s
}

type ListIndexOutput struct {
	_ struct{} `type:"structure"`

	// The objects and indexed values attached to the index.
	IndexAttachments []*IndexAttachment `type:"list"`

	// The pagination token.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListIndexOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListIndexOutput) GoString() string {
	return s.String()
}

// SetIndexAttachments sets the IndexAttachments field's value.
func (s *ListIndexOutput) SetIndexAttachments(v []*IndexAttachment) *ListIndexOutput {
	s.IndexAttachments = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListIndexOutput) SetNextToken(v string) *ListIndexOutput {
	s.NextToken = &v
	return s
}

type ListObjectAttributesInput struct {
	_ struct{} `type:"structure"`

	// Represents the manner and timing in which the successful write or update
	// of an object is reflected in a subsequent read operation of that same object.
	ConsistencyLevel *string `location:"header" locationName:"x-amz-consistency-level" type:"string" enum:"ConsistencyLevel"`

	// The Amazon Resource Name (ARN) that is associated with the Directory where
	// the object resides. For more information, see arns.
	//
	// DirectoryArn is a required field
	DirectoryArn *string `location:"header" locationName:"x-amz-data-partition" type:"string" required:"true"`

	// Used to filter the list of object attributes that are associated with a certain
	// facet.
	FacetFilter *SchemaFacet `type:"structure"`

	// The maximum number of items to be retrieved in a single call. This is an
	// approximate number.
	MaxResults *int64 `min:"1" type:"integer"`

	// The pagination token.
	NextToken *string `type:"string"`

	// The reference that identifies the object whose attributes will be listed.
	//
	// ObjectReference is a required field
	ObjectReference *ObjectReference `type:"structure" required:"true"`
}

// String returns the string representation
func (s ListObjectAttributesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListObjectAttributesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListObjectAttributesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListObjectAttributesInput"}
	if s.DirectoryArn == nil {
		invalidParams.Add(request.NewErrParamRequired("DirectoryArn"))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.ObjectReference == nil {
		invalidParams.Add(request.NewErrParamRequired("ObjectReference"))
	}
	if s.FacetFilter != nil {
		if err := s.FacetFilter.Validate(); err != nil {
			invalidParams.AddNested("FacetFilter", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConsistencyLevel sets the ConsistencyLevel field's value.
func (s *ListObjectAttributesInput) SetConsistencyLevel(v string) *ListObjectAttributesInput {
	s.ConsistencyLevel = &v
	return s
}

// SetDirectoryArn sets the DirectoryArn field's value.
func (s *ListObjectAttributesInput) SetDirectoryArn(v string) *ListObjectAttributesInput {
	s.DirectoryArn = &v
	return s
}

// SetFacetFilter sets the FacetFilter field's value.
func (s *ListObjectAttributesInput) SetFacetFilter(v *SchemaFacet) *ListObjectAttributesInput {
	s.FacetFilter = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListObjectAttributesInput) SetMaxResults(v int64) *ListObjectAttributesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListObjectAttributesInput) SetNextToken(v string) *ListObjectAttributesInput {
	s.NextToken = &v
	return s
}

// SetObjectReference sets the ObjectReference field's value.
func (s *ListObjectAttributesInput) SetObjectReference(v *ObjectReference) *ListObjectAttributesInput {
	s.ObjectReference = v
	return s
}

type ListObjectAttributesOutput struct {
	_ struct{} `type:"structure"`

	// Attributes map that is associated with the object. AttributeArn is the key,
	// and attribute value is the value.
	Attributes []*AttributeKeyAndValue `type:"list"`

	// The pagination token.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListObjectAttributesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListObjectAttributesOutput) GoString() string {
	return s.String()
}

// SetAttributes sets the Attributes field's value.
func (s *ListObjectAttributesOutput) SetAttributes(v []*AttributeKeyAndValue) *ListObjectAttributesOutput {
	s.Attributes = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListObjectAttributesOutput) SetNextToken(v string) *ListObjectAttributesOutput {
	s.NextToken = &v
	return s
}

type ListObjectChildrenInput struct {
	_ struct{} `type:"structure"`

	// Represents the manner and timing in which the successful write or update
	// of an object is reflected in a subsequent read operation of that same object.
	ConsistencyLevel *string `location:"header" locationName:"x-amz-consistency-level" type:"string" enum:"ConsistencyLevel"`

	// The Amazon Resource Name (ARN) that is associated with the Directory where
	// the object resides. For more information, see arns.
	//
	// DirectoryArn is a required field
	DirectoryArn *string `location:"header" locationName:"x-amz-data-partition" type:"string" required:"true"`

	// The maximum number of items to be retrieved in a single call. This is an
	// approximate number.
	MaxResults *int64 `min:"1" type:"integer"`

	// The pagination token.
	NextToken *string `type:"string"`

	// The reference that identifies the object for which child objects are being
	// listed.
	//
	// ObjectReference is a required field
	ObjectReference *ObjectReference `type:"structure" required:"true"`
}

// String returns the string representation
func (s ListObjectChildrenInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListObjectChildrenInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListObjectChildrenInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListObjectChildrenInput"}
	if s.DirectoryArn == nil {
		invalidParams.Add(request.NewErrParamRequired("DirectoryArn"))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.ObjectReference == nil {
		invalidParams.Add(request.NewErrParamRequired("ObjectReference"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConsistencyLevel sets the ConsistencyLevel field's value.
func (s *ListObjectChildrenInput) SetConsistencyLevel(v string) *ListObjectChildrenInput {
	s.ConsistencyLevel = &v
	return s
}

// SetDirectoryArn sets the DirectoryArn field's value.
func (s *ListObjectChildrenInput) SetDirectoryArn(v string) *ListObjectChildrenInput {
	s.DirectoryArn = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListObjectChildrenInput) SetMaxResults(v int64) *ListObjectChildrenInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListObjectChildrenInput) SetNextToken(v string) *ListObjectChildrenInput {
	s.NextToken = &v
	return s
}

// SetObjectReference sets the ObjectReference field's value.
func (s *ListObjectChildrenInput) SetObjectReference(v *ObjectReference) *ListObjectChildrenInput {
	s.ObjectReference = v
	return s
}

type ListObjectChildrenOutput struct {
	_ struct{} `type:"structure"`

	// Children structure, which is a map with key as the LinkName and ObjectIdentifier
	// as the value.
	Children map[string]*string `type:"map"`

	// The pagination token.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListObjectChildrenOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListObjectChildrenOutput) GoString() string {
	return s.String()
}

// SetChildren sets the Children field's value.
func (s *ListObjectChildrenOutput) SetChildren(v map[string]*string) *ListObjectChildrenOutput {
	s.Children = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListObjectChildrenOutput) SetNextToken(v string) *ListObjectChildrenOutput {
	s.NextToken = &v
	return s
}

type ListObjectParentPathsInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the directory to which the parent path applies.
	//
	// DirectoryArn is a required field
	DirectoryArn *string `location:"header" locationName:"x-amz-data-partition" type:"string" required:"true"`

	// The maximum number of items to be retrieved in a single call. This is an
	// approximate number.
	MaxResults *int64 `min:"1" type:"integer"`

	// The pagination token.
	NextToken *string `type:"string"`

	// The reference that identifies the object whose parent paths are listed.
	//
	// ObjectReference is a required field
	ObjectReference *ObjectReference `type:"structure" required:"true"`
}

// String returns the string representation
func (s ListObjectParentPathsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListObjectParentPathsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListObjectParentPathsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListObjectParentPathsInput"}
	if s.DirectoryArn == nil {
		invalidParams.Add(request.NewErrParamRequired("DirectoryArn"))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.ObjectReference == nil {
		invalidParams.Add(request.NewErrParamRequired("ObjectReference"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDirectoryArn sets the DirectoryArn field's value.
func (s *ListObjectParentPathsInput) SetDirectoryArn(v string) *ListObjectParentPathsInput {
	s.DirectoryArn = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListObjectParentPathsInput) SetMaxResults(v int64) *ListObjectParentPathsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListObjectParentPathsInput) SetNextToken(v string) *ListObjectParentPathsInput {
	s.NextToken = &v
	return s
}

// SetObjectReference sets the ObjectReference field's value.
func (s *ListObjectParentPathsInput) SetObjectReference(v *ObjectReference) *ListObjectParentPathsInput {
	s.ObjectReference = v
	return s
}

type ListObjectParentPathsOutput struct {
	_ struct{} `type:"structure"`

	// The pagination token.
	NextToken *string `type:"string"`

	// Returns the path to the ObjectIdentifiers that are associated with the directory.
	PathToObjectIdentifiersList []*PathToObjectIdentifiers `type:"list"`
}

// String returns the string representation
func (s ListObjectParentPathsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListObjectParentPathsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListObjectParentPathsOutput) SetNextToken(v string) *ListObjectParentPathsOutput {
	s.NextToken = &v
	return s
}

// SetPathToObjectIdentifiersList sets the PathToObjectIdentifiersList field's value.
func (s *ListObjectParentPathsOutput) SetPathToObjectIdentifiersList(v []*PathToObjectIdentifiers) *ListObjectParentPathsOutput {
	s.PathToObjectIdentifiersList = v
	return s
}

type ListObjectParentsInput struct {
	_ struct{} `type:"structure"`

	// Represents the manner and timing in which the successful write or update
	// of an object is reflected in a subsequent read operation of that same object.
	ConsistencyLevel *string `location:"header" locationName:"x-amz-consistency-level" type:"string" enum:"ConsistencyLevel"`

	// The Amazon Resource Name (ARN) that is associated with the Directory where
	// the object resides. For more information, see arns.
	//
	// DirectoryArn is a required field
	DirectoryArn *string `location:"header" locationName:"x-amz-data-partition" type:"string" required:"true"`

	// The maximum number of items to be retrieved in a single call. This is an
	// approximate number.
	MaxResults *int64 `min:"1" type:"integer"`

	// The pagination token.
	NextToken *string `type:"string"`

	// The reference that identifies the object for which parent objects are being
	// listed.
	//
	// ObjectReference is a required field
	ObjectReference *ObjectReference `type:"structure" required:"true"`
}

// String returns the string representation
func (s ListObjectParentsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListObjectParentsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListObjectParentsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListObjectParentsInput"}
	if s.DirectoryArn == nil {
		invalidParams.Add(request.NewErrParamRequired("DirectoryArn"))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.ObjectReference == nil {
		invalidParams.Add(request.NewErrParamRequired("ObjectReference"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConsistencyLevel sets the ConsistencyLevel field's value.
func (s *ListObjectParentsInput) SetConsistencyLevel(v string) *ListObjectParentsInput {
	s.ConsistencyLevel = &v
	return s
}

// SetDirectoryArn sets the DirectoryArn field's value.
func (s *ListObjectParentsInput) SetDirectoryArn(v string) *ListObjectParentsInput {
	s.DirectoryArn = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListObjectParentsInput) SetMaxResults(v int64) *ListObjectParentsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListObjectParentsInput) SetNextToken(v string) *ListObjectParentsInput {
	s.NextToken = &v
	return s
}

// SetObjectReference sets the ObjectReference field's value.
func (s *ListObjectParentsInput) SetObjectReference(v *ObjectReference) *ListObjectParentsInput {
	s.ObjectReference = v
	return s
}

type ListObjectParentsOutput struct {
	_ struct{} `type:"structure"`

	// The pagination token.
	NextToken *string `type:"string"`

	// The parent structure, which is a map with key as the ObjectIdentifier and
	// LinkName as the value.
	Parents map[string]*string `type:"map"`
}

// String returns the string representation
func (s ListObjectParentsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListObjectParentsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListObjectParentsOutput) SetNextToken(v string) *ListObjectParentsOutput {
	s.NextToken = &v
	return s
}

// SetParents sets the Parents field's value.
func (s *ListObjectParentsOutput) SetParents(v map[string]*string) *ListObjectParentsOutput {
	s.Parents = v
	return s
}

type ListObjectPoliciesInput struct {
	_ struct{} `type:"structure"`

	// Represents the manner and timing in which the successful write or update
	// of an object is reflected in a subsequent read operation of that same object.
	ConsistencyLevel *string `location:"header" locationName:"x-amz-consistency-level" type:"string" enum:"ConsistencyLevel"`

	// The Amazon Resource Name (ARN) that is associated with the Directory where
	// objects reside. For more information, see arns.
	//
	// DirectoryArn is a required field
	DirectoryArn *string `location:"header" locationName:"x-amz-data-partition" type:"string" required:"true"`

	// The maximum number of items to be retrieved in a single call. This is an
	// approximate number.
	MaxResults *int64 `min:"1" type:"integer"`

	// The pagination token.
	NextToken *string `type:"string"`

	// Reference that identifies the object for which policies will be listed.
	//
	// ObjectReference is a required field
	ObjectReference *ObjectReference `type:"structure" required:"true"`
}

// String returns the string representation
func (s ListObjectPoliciesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListObjectPoliciesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListObjectPoliciesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListObjectPoliciesInput"}
	if s.DirectoryArn == nil {
		invalidParams.Add(request.NewErrParamRequired("DirectoryArn"))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.ObjectReference == nil {
		invalidParams.Add(request.NewErrParamRequired("ObjectReference"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConsistencyLevel sets the ConsistencyLevel field's value.
func (s *ListObjectPoliciesInput) SetConsistencyLevel(v string) *ListObjectPoliciesInput {
	s.ConsistencyLevel = &v
	return s
}

// SetDirectoryArn sets the DirectoryArn field's value.
func (s *ListObjectPoliciesInput) SetDirectoryArn(v string) *ListObjectPoliciesInput {
	s.DirectoryArn = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListObjectPoliciesInput) SetMaxResults(v int64) *ListObjectPoliciesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListObjectPoliciesInput) SetNextToken(v string) *ListObjectPoliciesInput {
	s.NextToken = &v
	return s
}

// SetObjectReference sets the ObjectReference field's value.
func (s *ListObjectPoliciesInput) SetObjectReference(v *ObjectReference) *ListObjectPoliciesInput {
	s.ObjectReference = v
	return s
}

type ListObjectPoliciesOutput struct {
	_ struct{} `type:"structure"`

	// A list of policy ObjectIdentifiers, that are attached to the object.
	AttachedPolicyIds []*string `type:"list"`

	// The pagination token.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListObjectPoliciesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListObjectPoliciesOutput) GoString() string {
	return s.String()
}

// SetAttachedPolicyIds sets the AttachedPolicyIds field's value.
func (s *ListObjectPoliciesOutput) SetAttachedPolicyIds(v []*string) *ListObjectPoliciesOutput {
	s.AttachedPolicyIds = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListObjectPoliciesOutput) SetNextToken(v string) *ListObjectPoliciesOutput {
	s.NextToken = &v
	return s
}

type ListOutgoingTypedLinksInput struct {
	_ struct{} `type:"structure"`

	// The consistency level to execute the request at.
	ConsistencyLevel *string `type:"string" enum:"ConsistencyLevel"`

	// The Amazon Resource Name (ARN) of the directory where you want to list the
	// typed links.
	//
	// DirectoryArn is a required field
	DirectoryArn *string `location:"header" locationName:"x-amz-data-partition" type:"string" required:"true"`

	// Provides range filters for multiple attributes. When providing ranges to
	// typed link selection, any inexact ranges must be specified at the end. Any
	// attributes that do not have a range specified are presumed to match the entire
	// range.
	FilterAttributeRanges []*TypedLinkAttributeRange `type:"list"`

	// Filters are interpreted in the order of the attributes defined on the typed
	// link facet, not the order they are supplied to any API calls.
	FilterTypedLink *TypedLinkSchemaAndFacetName `type:"structure"`

	// The maximum number of results to retrieve.
	MaxResults *int64 `min:"1" type:"integer"`

	// The pagination token.
	NextToken *string `type:"string"`

	// A reference that identifies the object whose attributes will be listed.
	//
	// ObjectReference is a required field
	ObjectReference *ObjectReference `type:"structure" required:"true"`
}

// String returns the string representation
func (s ListOutgoingTypedLinksInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListOutgoingTypedLinksInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListOutgoingTypedLinksInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListOutgoingTypedLinksInput"}
	if s.DirectoryArn == nil {
		invalidParams.Add(request.NewErrParamRequired("DirectoryArn"))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.ObjectReference == nil {
		invalidParams.Add(request.NewErrParamRequired("ObjectReference"))
	}
	if s.FilterAttributeRanges != nil {
		for i, v := range s.FilterAttributeRanges {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "FilterAttributeRanges", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.FilterTypedLink != nil {
		if err := s.FilterTypedLink.Validate(); err != nil {
			invalidParams.AddNested("FilterTypedLink", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConsistencyLevel sets the ConsistencyLevel field's value.
func (s *ListOutgoingTypedLinksInput) SetConsistencyLevel(v string) *ListOutgoingTypedLinksInput {
	s.ConsistencyLevel = &v
	return s
}

// SetDirectoryArn sets the DirectoryArn field's value.
func (s *ListOutgoingTypedLinksInput) SetDirectoryArn(v string) *ListOutgoingTypedLinksInput {
	s.DirectoryArn = &v
	return s
}

// SetFilterAttributeRanges sets the FilterAttributeRanges field's value.
func (s *ListOutgoingTypedLinksInput) SetFilterAttributeRanges(v []*TypedLinkAttributeRange) *ListOutgoingTypedLinksInput {
	s.FilterAttributeRanges = v
	return s
}

// SetFilterTypedLink sets the FilterTypedLink field's value.
func (s *ListOutgoingTypedLinksInput) SetFilterTypedLink(v *TypedLinkSchemaAndFacetName) *ListOutgoingTypedLinksInput {
	s.FilterTypedLink = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListOutgoingTypedLinksInput) SetMaxResults(v int64) *ListOutgoingTypedLinksInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListOutgoingTypedLinksInput) SetNextToken(v string) *ListOutgoingTypedLinksInput {
	s.NextToken = &v
	return s
}

// SetObjectReference sets the ObjectReference field's value.
func (s *ListOutgoingTypedLinksInput) SetObjectReference(v *ObjectReference) *ListOutgoingTypedLinksInput {
	s.ObjectReference = v
	return s
}

type ListOutgoingTypedLinksOutput struct {
	_ struct{} `type:"structure"`

	// The pagination token.
	NextToken *string `type:"string"`

	// Returns a typed link specifier as output.
	TypedLinkSpecifiers []*TypedLinkSpecifier `type:"list"`
}

// String returns the string representation
func (s ListOutgoingTypedLinksOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListOutgoingTypedLinksOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListOutgoingTypedLinksOutput) SetNextToken(v string) *ListOutgoingTypedLinksOutput {
	s.NextToken = &v
	return s
}

// SetTypedLinkSpecifiers sets the TypedLinkSpecifiers field's value.
func (s *ListOutgoingTypedLinksOutput) SetTypedLinkSpecifiers(v []*TypedLinkSpecifier) *ListOutgoingTypedLinksOutput {
	s.TypedLinkSpecifiers = v
	return s
}

type ListPolicyAttachmentsInput struct {
	_ struct{} `type:"structure"`

	// Represents the manner and timing in which the successful write or update
	// of an object is reflected in a subsequent read operation of that same object.
	ConsistencyLevel *string `location:"header" locationName:"x-amz-consistency-level" type:"string" enum:"ConsistencyLevel"`

	// The Amazon Resource Name (ARN) that is associated with the Directory where
	// objects reside. For more information, see arns.
	//
	// DirectoryArn is a required field
	DirectoryArn *string `location:"header" locationName:"x-amz-data-partition" type:"string" required:"true"`

	// The maximum number of items to be retrieved in a single call. This is an
	// approximate number.
	MaxResults *int64 `min:"1" type:"integer"`

	// The pagination token.
	NextToken *string `type:"string"`

	// The reference that identifies the policy object.
	//
	// PolicyReference is a required field
	PolicyReference *ObjectReference `type:"structure" required:"true"`
}

// String returns the string representation
func (s ListPolicyAttachmentsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListPolicyAttachmentsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListPolicyAttachmentsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListPolicyAttachmentsInput"}
	if s.DirectoryArn == nil {
		invalidParams.Add(request.NewErrParamRequired("DirectoryArn"))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.PolicyReference == nil {
		invalidParams.Add(request.NewErrParamRequired("PolicyReference"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConsistencyLevel sets the ConsistencyLevel field's value.
func (s *ListPolicyAttachmentsInput) SetConsistencyLevel(v string) *ListPolicyAttachmentsInput {
	s.ConsistencyLevel = &v
	return s
}

// SetDirectoryArn sets the DirectoryArn field's value.
func (s *ListPolicyAttachmentsInput) SetDirectoryArn(v string) *ListPolicyAttachmentsInput {
	s.DirectoryArn = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListPolicyAttachmentsInput) SetMaxResults(v int64) *ListPolicyAttachmentsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListPolicyAttachmentsInput) SetNextToken(v string) *ListPolicyAttachmentsInput {
	s.NextToken = &v
	return s
}

// SetPolicyReference sets the PolicyReference field's value.
func (s *ListPolicyAttachmentsInput) SetPolicyReference(v *ObjectReference) *ListPolicyAttachmentsInput {
	s.PolicyReference = v
	return s
}

type ListPolicyAttachmentsOutput struct {
	_ struct{} `type:"structure"`

	// The pagination token.
	NextToken *string `type:"string"`

	// A list of ObjectIdentifiers to which the policy is attached.
	ObjectIdentifiers []*string `type:"list"`
}

// String returns the string representation
func (s ListPolicyAttachmentsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListPolicyAttachmentsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListPolicyAttachmentsOutput) SetNextToken(v string) *ListPolicyAttachmentsOutput {
	s.NextToken = &v
	return s
}

// SetObjectIdentifiers sets the ObjectIdentifiers field's value.
func (s *ListPolicyAttachmentsOutput) SetObjectIdentifiers(v []*string) *ListPolicyAttachmentsOutput {
	s.ObjectIdentifiers = v
	return s
}

type ListPublishedSchemaArnsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results to retrieve.
	MaxResults *int64 `min:"1" type:"integer"`

	// The pagination token.
	NextToken *string `type:"string"`

	// The response for ListPublishedSchemaArns when this parameter is used will
	// list all minor version ARNs for a major version.
	SchemaArn *string `type:"string"`
}

// String returns the string representation
func (s ListPublishedSchemaArnsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListPublishedSchemaArnsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListPublishedSchemaArnsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListPublishedSchemaArnsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListPublishedSchemaArnsInput) SetMaxResults(v int64) *ListPublishedSchemaArnsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListPublishedSchemaArnsInput) SetNextToken(v string) *ListPublishedSchemaArnsInput {
	s.NextToken = &v
	return s
}

// SetSchemaArn sets the SchemaArn field's value.
func (s *ListPublishedSchemaArnsInput) SetSchemaArn(v string) *ListPublishedSchemaArnsInput {
	s.SchemaArn = &v
	return s
}

type ListPublishedSchemaArnsOutput struct {
	_ struct{} `type:"structure"`

	// The pagination token.
	NextToken *string `type:"string"`

	// The ARNs of published schemas.
	SchemaArns []*string `type:"list"`
}

// String returns the string representation
func (s ListPublishedSchemaArnsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListPublishedSchemaArnsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListPublishedSchemaArnsOutput) SetNextToken(v string) *ListPublishedSchemaArnsOutput {
	s.NextToken = &v
	return s
}

// SetSchemaArns sets the SchemaArns field's value.
func (s *ListPublishedSchemaArnsOutput) SetSchemaArns(v []*string) *ListPublishedSchemaArnsOutput {
	s.SchemaArns = v
	return s
}

type ListTagsForResourceInput struct {
	_ struct{} `type:"structure"`

	// The MaxResults parameter sets the maximum number of results returned in a
	// single page. This is for future use and is not supported currently.
	MaxResults *int64 `min:"50" type:"integer"`

	// The pagination token. This is for future use. Currently pagination is not
	// supported for tagging.
	NextToken *string `type:"string"`

	// The Amazon Resource Name (ARN) of the resource. Tagging is only supported
	// for directories.
	//
	// ResourceArn is a required field
	ResourceArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.MaxResults != nil && *s.MaxResults < 50 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 50))
	}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListTagsForResourceInput) SetMaxResults(v int64) *ListTagsForResourceInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListTagsForResourceInput) SetNextToken(v string) *ListTagsForResourceInput {
	s.NextToken = &v
	return s
}

// SetResourceArn sets the ResourceArn field's value.
func (s *ListTagsForResourceInput) SetResourceArn(v string) *ListTagsForResourceInput {
	s.ResourceArn = &v
	return s
}

type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// The token to use to retrieve the next page of results. This value is null
	// when there are no more results to return.
	NextToken *string `type:"string"`

	// A list of tag key value pairs that are associated with the response.
	Tags []*Tag `type:"list"`
}

// String returns the string representation
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListTagsForResourceOutput) SetNextToken(v string) *ListTagsForResourceOutput {
	s.NextToken = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *ListTagsForResourceOutput) SetTags(v []*Tag) *ListTagsForResourceOutput {
	s.Tags = v
	return s
}

type ListTypedLinkFacetAttributesInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results to retrieve.
	MaxResults *int64 `min:"1" type:"integer"`

	// The unique name of the typed link facet.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`

	// The pagination token.
	NextToken *string `type:"string"`

	// The Amazon Resource Name (ARN) that is associated with the schema. For more
	// information, see arns.
	//
	// SchemaArn is a required field
	SchemaArn *string `location:"header" locationName:"x-amz-data-partition" type:"string" required:"true"`
}

// String returns the string representation
func (s ListTypedLinkFacetAttributesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTypedLinkFacetAttributesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTypedLinkFacetAttributesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTypedLinkFacetAttributesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.SchemaArn == nil {
		invalidParams.Add(request.NewErrParamRequired("SchemaArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListTypedLinkFacetAttributesInput) SetMaxResults(v int64) *ListTypedLinkFacetAttributesInput {
	s.MaxResults = &v
	return s
}

// SetName sets the Name field's value.
func (s *ListTypedLinkFacetAttributesInput) SetName(v string) *ListTypedLinkFacetAttributesInput {
	s.Name = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListTypedLinkFacetAttributesInput) SetNextToken(v string) *ListTypedLinkFacetAttributesInput {
	s.NextToken = &v
	return s
}

// SetSchemaArn sets the SchemaArn field's value.
func (s *ListTypedLinkFacetAttributesInput) SetSchemaArn(v string) *ListTypedLinkFacetAttributesInput {
	s.SchemaArn = &v
	return s
}

type ListTypedLinkFacetAttributesOutput struct {
	_ struct{} `type:"structure"`

	// An ordered set of attributes associate with the typed link.
	Attributes []*TypedLinkAttributeDefinition `type:"list"`

	// The pagination token.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListTypedLinkFacetAttributesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTypedLinkFacetAttributesOutput) GoString() string {
	return s.String()
}

// SetAttributes sets the Attributes field's value.
func (s *ListTypedLinkFacetAttributesOutput) SetAttributes(v []*TypedLinkAttributeDefinition) *ListTypedLinkFacetAttributesOutput {
	s.Attributes = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListTypedLinkFacetAttributesOutput) SetNextToken(v string) *ListTypedLinkFacetAttributesOutput {
	s.NextToken = &v
	return s
}

type ListTypedLinkFacetNamesInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results to retrieve.
	MaxResults *int64 `min:"1" type:"integer"`

	// The pagination token.
	NextToken *string `type:"string"`

	// The Amazon Resource Name (ARN) that is associated with the schema. For more
	// information, see arns.
	//
	// SchemaArn is a required field
	SchemaArn *string `location:"header" locationName:"x-amz-data-partition" type:"string" required:"true"`
}

// String returns the string representation
func (s ListTypedLinkFacetNamesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTypedLinkFacetNamesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTypedLinkFacetNamesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTypedLinkFacetNamesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.SchemaArn == nil {
		invalidParams.Add(request.NewErrParamRequired("SchemaArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListTypedLinkFacetNamesInput) SetMaxResults(v int64) *ListTypedLinkFacetNamesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListTypedLinkFacetNamesInput) SetNextToken(v string) *ListTypedLinkFacetNamesInput {
	s.NextToken = &v
	return s
}

// SetSchemaArn sets the SchemaArn field's value.
func (s *ListTypedLinkFacetNamesInput) SetSchemaArn(v string) *ListTypedLinkFacetNamesInput {
	s.SchemaArn = &v
	return s
}

type ListTypedLinkFacetNamesOutput struct {
	_ struct{} `type:"structure"`

	// The names of typed link facets that exist within the schema.
	FacetNames []*string `type:"list"`

	// The pagination token.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListTypedLinkFacetNamesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTypedLinkFacetNamesOutput) GoString() string {
	return s.String()
}

// SetFacetNames sets the FacetNames field's value.
func (s *ListTypedLinkFacetNamesOutput) SetFacetNames(v []*string) *ListTypedLinkFacetNamesOutput {
	s.FacetNames = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListTypedLinkFacetNamesOutput) SetNextToken(v string) *ListTypedLinkFacetNamesOutput {
	s.NextToken = &v
	return s
}

type LookupPolicyInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) that is associated with the Directory. For
	// more information, see arns.
	//
	// DirectoryArn is a required field
	DirectoryArn *string `location:"header" locationName:"x-amz-data-partition" type:"string" required:"true"`

	// The maximum number of items to be retrieved in a single call. This is an
	// approximate number.
	MaxResults *int64 `min:"1" type:"integer"`

	// The token to request the next page of results.
	NextToken *string `type:"string"`

	// Reference that identifies the object whose policies will be looked up.
	//
	// ObjectReference is a required field
	ObjectReference *ObjectReference `type:"structure" required:"true"`
}

// String returns the string representation
func (s LookupPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LookupPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *LookupPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "LookupPolicyInput"}
	if s.DirectoryArn == nil {
		invalidParams.Add(request.NewErrParamRequired("DirectoryArn"))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.ObjectReference == nil {
		invalidParams.Add(request.NewErrParamRequired("ObjectReference"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDirectoryArn sets the DirectoryArn field's value.
func (s *LookupPolicyInput) SetDirectoryArn(v string) *LookupPolicyInput {
	s.DirectoryArn = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *LookupPolicyInput) SetMaxResults(v int64) *LookupPolicyInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *LookupPolicyInput) SetNextToken(v string) *LookupPolicyInput {
	s.NextToken = &v
	return s
}

// SetObjectReference sets the ObjectReference field's value.
func (s *LookupPolicyInput) SetObjectReference(v *ObjectReference) *LookupPolicyInput {
	s.ObjectReference = v
	return s
}

type LookupPolicyOutput struct {
	_ struct{} `type:"structure"`

	// The pagination token.
	NextToken *string `type:"string"`

	// Provides list of path to policies. Policies contain PolicyId, ObjectIdentifier,
	// and PolicyType. For more information, see Policies (http://docs.aws.amazon.com/directoryservice/latest/admin-guide/cd_key_concepts.html#policies).
	PolicyToPathList []*PolicyToPath `type:"list"`
}

// String returns the string representation
func (s LookupPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LookupPolicyOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *LookupPolicyOutput) SetNextToken(v string) *LookupPolicyOutput {
	s.NextToken = &v
	return s
}

// SetPolicyToPathList sets the PolicyToPathList field's value.
func (s *LookupPolicyOutput) SetPolicyToPathList(v []*PolicyToPath) *LookupPolicyOutput {
	s.PolicyToPathList = v
	return s
}

// The action to take on the object attribute.
type ObjectAttributeAction struct {
	_ struct{} `type:"structure"`

	// A type that can be either Update or Delete.
	ObjectAttributeActionType *string `type:"string" enum:"UpdateActionType"`

	// The value that you want to update to.
	ObjectAttributeUpdateValue *TypedAttributeValue `type:"structure"`
}

// String returns the string representation
func (s ObjectAttributeAction) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ObjectAttributeAction) GoString() string {
	return s.String()
}

// SetObjectAttributeActionType sets the ObjectAttributeActionType field's value.
func (s *ObjectAttributeAction) SetObjectAttributeActionType(v string) *ObjectAttributeAction {
	s.ObjectAttributeActionType = &v
	return s
}

// SetObjectAttributeUpdateValue sets the ObjectAttributeUpdateValue field's value.
func (s *ObjectAttributeAction) SetObjectAttributeUpdateValue(v *TypedAttributeValue) *ObjectAttributeAction {
	s.ObjectAttributeUpdateValue = v
	return s
}

// A range of attributes.
type ObjectAttributeRange struct {
	_ struct{} `type:"structure"`

	// The key of the attribute that the attribute range covers.
	AttributeKey *AttributeKey `type:"structure"`

	// The range of attribute values being selected.
	Range *TypedAttributeValueRange `type:"structure"`
}

// String returns the string representation
func (s ObjectAttributeRange) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ObjectAttributeRange) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ObjectAttributeRange) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ObjectAttributeRange"}
	if s.AttributeKey != nil {
		if err := s.AttributeKey.Validate(); err != nil {
			invalidParams.AddNested("AttributeKey", err.(request.ErrInvalidParams))
		}
	}
	if s.Range != nil {
		if err := s.Range.Validate(); err != nil {
			invalidParams.AddNested("Range", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAttributeKey sets the AttributeKey field's value.
func (s *ObjectAttributeRange) SetAttributeKey(v *AttributeKey) *ObjectAttributeRange {
	s.AttributeKey = v
	return s
}

// SetRange sets the Range field's value.
func (s *ObjectAttributeRange) SetRange(v *TypedAttributeValueRange) *ObjectAttributeRange {
	s.Range = v
	return s
}

// Structure that contains attribute update information.
type ObjectAttributeUpdate struct {
	_ struct{} `type:"structure"`

	// The action to perform as part of the attribute update.
	ObjectAttributeAction *ObjectAttributeAction `type:"structure"`

	// The key of the attribute being updated.
	ObjectAttributeKey *AttributeKey `type:"structure"`
}

// String returns the string representation
func (s ObjectAttributeUpdate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ObjectAttributeUpdate) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ObjectAttributeUpdate) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ObjectAttributeUpdate"}
	if s.ObjectAttributeKey != nil {
		if err := s.ObjectAttributeKey.Validate(); err != nil {
			invalidParams.AddNested("ObjectAttributeKey", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetObjectAttributeAction sets the ObjectAttributeAction field's value.
func (s *ObjectAttributeUpdate) SetObjectAttributeAction(v *ObjectAttributeAction) *ObjectAttributeUpdate {
	s.ObjectAttributeAction = v
	return s
}

// SetObjectAttributeKey sets the ObjectAttributeKey field's value.
func (s *ObjectAttributeUpdate) SetObjectAttributeKey(v *AttributeKey) *ObjectAttributeUpdate {
	s.ObjectAttributeKey = v
	return s
}

// The reference that identifies an object.
type ObjectReference struct {
	_ struct{} `type:"structure"`

	// A path selector supports easy selection of an object by the parent/child
	// links leading to it from the directory root. Use the link names from each
	// parent/child link to construct the path. Path selectors start with a slash
	// (/) and link names are separated by slashes. For more information about paths,
	// see Accessing Objects (http://docs.aws.amazon.com/directoryservice/latest/admin-guide/objectsandlinks.html#accessingobjects).
	// You can identify an object in one of the following ways:
	//
	//    * $ObjectIdentifier - An object identifier is an opaque string provided
	//    by Amazon Cloud Directory. When creating objects, the system will provide
	//    you with the identifier of the created object. An object’s identifier
	//    is immutable and no two objects will ever share the same object identifier
	//
	//    * /some/path - Identifies the object based on path
	//
	//    * #SomeBatchReference - Identifies the object in a batch call
	Selector *string `type:"string"`
}

// String returns the string representation
func (s ObjectReference) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ObjectReference) GoString() string {
	return s.String()
}

// SetSelector sets the Selector field's value.
func (s *ObjectReference) SetSelector(v string) *ObjectReference {
	s.Selector = &v
	return s
}

// Returns the path to the ObjectIdentifiers that is associated with the directory.
type PathToObjectIdentifiers struct {
	_ struct{} `type:"structure"`

	// Lists ObjectIdentifiers starting from directory root to the object in the
	// request.
	ObjectIdentifiers []*string `type:"list"`

	// The path that is used to identify the object starting from directory root.
	Path *string `type:"string"`
}

// String returns the string representation
func (s PathToObjectIdentifiers) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PathToObjectIdentifiers) GoString() string {
	return s.String()
}

// SetObjectIdentifiers sets the ObjectIdentifiers field's value.
func (s *PathToObjectIdentifiers) SetObjectIdentifiers(v []*string) *PathToObjectIdentifiers {
	s.ObjectIdentifiers = v
	return s
}

// SetPath sets the Path field's value.
func (s *PathToObjectIdentifiers) SetPath(v string) *PathToObjectIdentifiers {
	s.Path = &v
	return s
}

// Contains the PolicyType, PolicyId, and the ObjectIdentifier to which it is
// attached. For more information, see Policies (http://docs.aws.amazon.com/directoryservice/latest/admin-guide/cd_key_concepts.html#policies).
type PolicyAttachment struct {
	_ struct{} `type:"structure"`

	// The ObjectIdentifier that is associated with PolicyAttachment.
	ObjectIdentifier *string `type:"string"`

	// The ID of PolicyAttachment.
	PolicyId *string `type:"string"`

	// The type of policy that can be associated with PolicyAttachment.
	PolicyType *string `type:"string"`
}

// String returns the string representation
func (s PolicyAttachment) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PolicyAttachment) GoString() string {
	return s.String()
}

// SetObjectIdentifier sets the ObjectIdentifier field's value.
func (s *PolicyAttachment) SetObjectIdentifier(v string) *PolicyAttachment {
	s.ObjectIdentifier = &v
	return s
}

// SetPolicyId sets the PolicyId field's value.
func (s *PolicyAttachment) SetPolicyId(v string) *PolicyAttachment {
	s.PolicyId = &v
	return s
}

// SetPolicyType sets the PolicyType field's value.
func (s *PolicyAttachment) SetPolicyType(v string) *PolicyAttachment {
	s.PolicyType = &v
	return s
}

// Used when a regular object exists in a Directory and you want to find all
// of the policies that are associated with that object and the parent to that
// object.
type PolicyToPath struct {
	_ struct{} `type:"structure"`

	// The path that is referenced from the root.
	Path *string `type:"string"`

	// List of policy objects.
	Policies []*PolicyAttachment `type:"list"`
}

// String returns the string representation
func (s PolicyToPath) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PolicyToPath) GoString() string {
	return s.String()
}

// SetPath sets the Path field's value.
func (s *PolicyToPath) SetPath(v string) *PolicyToPath {
	s.Path = &v
	return s
}

// SetPolicies sets the Policies field's value.
func (s *PolicyToPath) SetPolicies(v []*PolicyAttachment) *PolicyToPath {
	s.Policies = v
	return s
}

type PublishSchemaInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) that is associated with the development schema.
	// For more information, see arns.
	//
	// DevelopmentSchemaArn is a required field
	DevelopmentSchemaArn *string `location:"header" locationName:"x-amz-data-partition" type:"string" required:"true"`

	// The minor version under which the schema will be published. This parameter
	// is recommended. Schemas have both a major and minor version associated with
	// them.
	MinorVersion *string `min:"1" type:"string"`

	// The new name under which the schema will be published. If this is not provided,
	// the development schema is considered.
	Name *string `min:"1" type:"string"`

	// The major version under which the schema will be published. Schemas have
	// both a major and minor version associated with them.
	//
	// Version is a required field
	Version *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s PublishSchemaInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PublishSchemaInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PublishSchemaInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PublishSchemaInput"}
	if s.DevelopmentSchemaArn == nil {
		invalidParams.Add(request.NewErrParamRequired("DevelopmentSchemaArn"))
	}
	if s.MinorVersion != nil && len(*s.MinorVersion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MinorVersion", 1))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Version == nil {
		invalidParams.Add(request.NewErrParamRequired("Version"))
	}
	if s.Version != nil && len(*s.Version) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Version", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDevelopmentSchemaArn sets the DevelopmentSchemaArn field's value.
func (s *PublishSchemaInput) SetDevelopmentSchemaArn(v string) *PublishSchemaInput {
	s.DevelopmentSchemaArn = &v
	return s
}

// SetMinorVersion sets the MinorVersion field's value.
func (s *PublishSchemaInput) SetMinorVersion(v string) *PublishSchemaInput {
	s.MinorVersion = &v
	return s
}

// SetName sets the Name field's value.
func (s *PublishSchemaInput) SetName(v string) *PublishSchemaInput {
	s.Name = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *PublishSchemaInput) SetVersion(v string) *PublishSchemaInput {
	s.Version = &v
	return s
}

type PublishSchemaOutput struct {
	_ struct{} `type:"structure"`

	// The ARN that is associated with the published schema. For more information,
	// see arns.
	PublishedSchemaArn *string `type:"string"`
}

// String returns the string representation
func (s PublishSchemaOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PublishSchemaOutput) GoString() string {
	return s.String()
}

// SetPublishedSchemaArn sets the PublishedSchemaArn field's value.
func (s *PublishSchemaOutput) SetPublishedSchemaArn(v string) *PublishSchemaOutput {
	s.PublishedSchemaArn = &v
	return s
}

type PutSchemaFromJsonInput struct {
	_ struct{} `type:"structure"`

	// The replacement JSON schema.
	//
	// Document is a required field
	Document *string `type:"string" required:"true"`

	// The ARN of the schema to update.
	//
	// SchemaArn is a required field
	SchemaArn *string `location:"header" locationName:"x-amz-data-partition" type:"string" required:"true"`
}

// String returns the string representation
func (s PutSchemaFromJsonInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutSchemaFromJsonInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutSchemaFromJsonInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutSchemaFromJsonInput"}
	if s.Document == nil {
		invalidParams.Add(request.NewErrParamRequired("Document"))
	}
	if s.SchemaArn == nil {
		invalidParams.Add(request.NewErrParamRequired("SchemaArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDocument sets the Document field's value.
func (s *PutSchemaFromJsonInput) SetDocument(v string) *PutSchemaFromJsonInput {
	s.Document = &v
	return s
}

// SetSchemaArn sets the SchemaArn field's value.
func (s *PutSchemaFromJsonInput) SetSchemaArn(v string) *PutSchemaFromJsonInput {
	s.SchemaArn = &v
	return s
}

type PutSchemaFromJsonOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the schema to update.
	Arn *string `type:"string"`
}

// String returns the string representation
func (s PutSchemaFromJsonOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutSchemaFromJsonOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *PutSchemaFromJsonOutput) SetArn(v string) *PutSchemaFromJsonOutput {
	s.Arn = &v
	return s
}

type RemoveFacetFromObjectInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the directory in which the object resides.
	//
	// DirectoryArn is a required field
	DirectoryArn *string `location:"header" locationName:"x-amz-data-partition" type:"string" required:"true"`

	// A reference to the object to remove the facet from.
	//
	// ObjectReference is a required field
	ObjectReference *ObjectReference `type:"structure" required:"true"`

	// The facet to remove. See SchemaFacet for details.
	//
	// SchemaFacet is a required field
	SchemaFacet *SchemaFacet `type:"structure" required:"true"`
}

// String returns the string representation
func (s RemoveFacetFromObjectInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RemoveFacetFromObjectInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RemoveFacetFromObjectInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RemoveFacetFromObjectInput"}
	if s.DirectoryArn == nil {
		invalidParams.Add(request.NewErrParamRequired("DirectoryArn"))
	}
	if s.ObjectReference == nil {
		invalidParams.Add(request.NewErrParamRequired("ObjectReference"))
	}
	if s.SchemaFacet == nil {
		invalidParams.Add(request.NewErrParamRequired("SchemaFacet"))
	}
	if s.SchemaFacet != nil {
		if err := s.SchemaFacet.Validate(); err != nil {
			invalidParams.AddNested("SchemaFacet", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDirectoryArn sets the DirectoryArn field's value.
func (s *RemoveFacetFromObjectInput) SetDirectoryArn(v string) *RemoveFacetFromObjectInput {
	s.DirectoryArn = &v
	return s
}

// SetObjectReference sets the ObjectReference field's value.
func (s *RemoveFacetFromObjectInput) SetObjectReference(v *ObjectReference) *RemoveFacetFromObjectInput {
	s.ObjectReference = v
	return s
}

// SetSchemaFacet sets the SchemaFacet field's value.
func (s *RemoveFacetFromObjectInput) SetSchemaFacet(v *SchemaFacet) *RemoveFacetFromObjectInput {
	s.SchemaFacet = v
	return s
}

type RemoveFacetFromObjectOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s RemoveFacetFromObjectOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RemoveFacetFromObjectOutput) GoString() string {
	return s.String()
}

// Contains an Amazon Resource Name (ARN) and parameters that are associated
// with the rule.
type Rule struct {
	_ struct{} `type:"structure"`

	// The minimum and maximum parameters that are associated with the rule.
	Parameters map[string]*string `type:"map"`

	// The type of attribute validation rule.
	Type *string `type:"string" enum:"RuleType"`
}

// String returns the string representation
func (s Rule) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Rule) GoString() string {
	return s.String()
}

// SetParameters sets the Parameters field's value.
func (s *Rule) SetParameters(v map[string]*string) *Rule {
	s.Parameters = v
	return s
}

// SetType sets the Type field's value.
func (s *Rule) SetType(v string) *Rule {
	s.Type = &v
	return s
}

// A facet.
type SchemaFacet struct {
	_ struct{} `type:"structure"`

	// The name of the facet.
	FacetName *string `min:"1" type:"string"`

	// The ARN of the schema that contains the facet with no minor component. See
	// arns and In-Place Schema Upgrade (http://docs.aws.amazon.com/directoryservice/latest/admin-guide/inplaceschemaupgrade.html)
	// for a description of when to provide minor versions.
	SchemaArn *string `type:"string"`
}

// String returns the string representation
func (s SchemaFacet) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SchemaFacet) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SchemaFacet) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SchemaFacet"}
	if s.FacetName != nil && len(*s.FacetName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FacetName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFacetName sets the FacetName field's value.
func (s *SchemaFacet) SetFacetName(v string) *SchemaFacet {
	s.FacetName = &v
	return s
}

// SetSchemaArn sets the SchemaArn field's value.
func (s *SchemaFacet) SetSchemaArn(v string) *SchemaFacet {
	s.SchemaArn = &v
	return s
}

// The tag structure that contains a tag key and value.
type Tag struct {
	_ struct{} `type:"structure"`

	// The key that is associated with the tag.
	Key *string `type:"string"`

	// The value that is associated with the tag.
	Value *string `type:"string"`
}

// String returns the string representation
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Tag) GoString() string {
	return s.String()
}

// SetKey sets the Key field's value.
func (s *Tag) SetKey(v string) *Tag {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Tag) SetValue(v string) *Tag {
	s.Value = &v
	return s
}

type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the resource. Tagging is only supported
	// for directories.
	//
	// ResourceArn is a required field
	ResourceArn *string `type:"string" required:"true"`

	// A list of tag key-value pairs.
	//
	// Tags is a required field
	Tags []*Tag `type:"list" required:"true"`
}

// String returns the string representation
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *TagResourceInput) SetResourceArn(v string) *TagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v []*Tag) *TagResourceInput {
	s.Tags = v
	return s
}

type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TagResourceOutput) GoString() string {
	return s.String()
}

// Represents the data for a typed attribute. You can set one, and only one,
// of the elements. Each attribute in an item is a name-value pair. Attributes
// have a single value.
type TypedAttributeValue struct {
	_ struct{} `type:"structure"`

	// A binary data value.
	//
	// BinaryValue is automatically base64 encoded/decoded by the SDK.
	BinaryValue []byte `type:"blob"`

	// A Boolean data value.
	BooleanValue *bool `type:"boolean"`

	// A date and time value.
	DatetimeValue *time.Time `type:"timestamp" timestampFormat:"unix"`

	// A number data value.
	NumberValue *string `type:"string"`

	// A string data value.
	StringValue *string `type:"string"`
}

// String returns the string representation
func (s TypedAttributeValue) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TypedAttributeValue) GoString() string {
	return s.String()
}

// SetBinaryValue sets the BinaryValue field's value.
func (s *TypedAttributeValue) SetBinaryValue(v []byte) *TypedAttributeValue {
	s.BinaryValue = v
	return s
}

// SetBooleanValue sets the BooleanValue field's value.
func (s *TypedAttributeValue) SetBooleanValue(v bool) *TypedAttributeValue {
	s.BooleanValue = &v
	return s
}

// SetDatetimeValue sets the DatetimeValue field's value.
func (s *TypedAttributeValue) SetDatetimeValue(v time.Time) *TypedAttributeValue {
	s.DatetimeValue = &v
	return s
}

// SetNumberValue sets the NumberValue field's value.
func (s *TypedAttributeValue) SetNumberValue(v string) *TypedAttributeValue {
	s.NumberValue = &v
	return s
}

// SetStringValue sets the StringValue field's value.
func (s *TypedAttributeValue) SetStringValue(v string) *TypedAttributeValue {
	s.StringValue = &v
	return s
}

// A range of attribute values. For more information, see Range Filters (http://docs.aws.amazon.com/directoryservice/latest/admin-guide/objectsandlinks.html#rangefilters).
type TypedAttributeValueRange struct {
	_ struct{} `type:"structure"`

	// The inclusive or exclusive range end.
	//
	// EndMode is a required field
	EndMode *string `type:"string" required:"true" enum:"RangeMode"`

	// The attribute value to terminate the range at.
	EndValue *TypedAttributeValue `type:"structure"`

	// The inclusive or exclusive range start.
	//
	// StartMode is a required field
	StartMode *string `type:"string" required:"true" enum:"RangeMode"`

	// The value to start the range at.
	StartValue *TypedAttributeValue `type:"structure"`
}

// String returns the string representation
func (s TypedAttributeValueRange) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TypedAttributeValueRange) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TypedAttributeValueRange) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TypedAttributeValueRange"}
	if s.EndMode == nil {
		invalidParams.Add(request.NewErrParamRequired("EndMode"))
	}
	if s.StartMode == nil {
		invalidParams.Add(request.NewErrParamRequired("StartMode"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEndMode sets the EndMode field's value.
func (s *TypedAttributeValueRange) SetEndMode(v string) *TypedAttributeValueRange {
	s.EndMode = &v
	return s
}

// SetEndValue sets the EndValue field's value.
func (s *TypedAttributeValueRange) SetEndValue(v *TypedAttributeValue) *TypedAttributeValueRange {
	s.EndValue = v
	return s
}

// SetStartMode sets the StartMode field's value.
func (s *TypedAttributeValueRange) SetStartMode(v string) *TypedAttributeValueRange {
	s.StartMode = &v
	return s
}

// SetStartValue sets the StartValue field's value.
func (s *TypedAttributeValueRange) SetStartValue(v *TypedAttributeValue) *TypedAttributeValueRange {
	s.StartValue = v
	return s
}

// A typed link attribute definition.
type TypedLinkAttributeDefinition struct {
	_ struct{} `type:"structure"`

	// The default value of the attribute (if configured).
	DefaultValue *TypedAttributeValue `type:"structure"`

	// Whether the attribute is mutable or not.
	IsImmutable *bool `type:"boolean"`

	// The unique name of the typed link attribute.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The required behavior of the TypedLinkAttributeDefinition.
	//
	// RequiredBehavior is a required field
	RequiredBehavior *string `type:"string" required:"true" enum:"RequiredAttributeBehavior"`

	// Validation rules that are attached to the attribute definition.
	Rules map[string]*Rule `type:"map"`

	// The type of the attribute.
	//
	// Type is a required field
	Type *string `type:"string" required:"true" enum:"FacetAttributeType"`
}

// String returns the string representation
func (s TypedLinkAttributeDefinition) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TypedLinkAttributeDefinition) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TypedLinkAttributeDefinition) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TypedLinkAttributeDefinition"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.RequiredBehavior == nil {
		invalidParams.Add(request.NewErrParamRequired("RequiredBehavior"))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDefaultValue sets the DefaultValue field's value.
func (s *TypedLinkAttributeDefinition) SetDefaultValue(v *TypedAttributeValue) *TypedLinkAttributeDefinition {
	s.DefaultValue = v
	return s
}

// SetIsImmutable sets the IsImmutable field's value.
func (s *TypedLinkAttributeDefinition) SetIsImmutable(v bool) *TypedLinkAttributeDefinition {
	s.IsImmutable = &v
	return s
}

// SetName sets the Name field's value.
func (s *TypedLinkAttributeDefinition) SetName(v string) *TypedLinkAttributeDefinition {
	s.Name = &v
	return s
}

// SetRequiredBehavior sets the RequiredBehavior field's value.
func (s *TypedLinkAttributeDefinition) SetRequiredBehavior(v string) *TypedLinkAttributeDefinition {
	s.RequiredBehavior = &v
	return s
}

// SetRules sets the Rules field's value.
func (s *TypedLinkAttributeDefinition) SetRules(v map[string]*Rule) *TypedLinkAttributeDefinition {
	s.Rules = v
	return s
}

// SetType sets the Type field's value.
func (s *TypedLinkAttributeDefinition) SetType(v string) *TypedLinkAttributeDefinition {
	s.Type = &v
	return s
}

// Identifies the range of attributes that are used by a specified filter.
type TypedLinkAttributeRange struct {
	_ struct{} `type:"structure"`

	// The unique name of the typed link attribute.
	AttributeName *string `min:"1" type:"string"`

	// The range of attribute values that are being selected.
	//
	// Range is a required field
	Range *TypedAttributeValueRange `type:"structure" required:"true"`
}

// String returns the string representation
func (s TypedLinkAttributeRange) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TypedLinkAttributeRange) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TypedLinkAttributeRange) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TypedLinkAttributeRange"}
	if s.AttributeName != nil && len(*s.AttributeName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AttributeName", 1))
	}
	if s.Range == nil {
		invalidParams.Add(request.NewErrParamRequired("Range"))
	}
	if s.Range != nil {
		if err := s.Range.Validate(); err != nil {
			invalidParams.AddNested("Range", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAttributeName sets the AttributeName field's value.
func (s *TypedLinkAttributeRange) SetAttributeName(v string) *TypedLinkAttributeRange {
	s.AttributeName = &v
	return s
}

// SetRange sets the Range field's value.
func (s *TypedLinkAttributeRange) SetRange(v *TypedAttributeValueRange) *TypedLinkAttributeRange {
	s.Range = v
	return s
}

// Defines the typed links structure and its attributes. To create a typed link
// facet, use the CreateTypedLinkFacet API.
type TypedLinkFacet struct {
	_ struct{} `type:"structure"`

	// A set of key-value pairs associated with the typed link. Typed link attributes
	// are used when you have data values that are related to the link itself, and
	// not to one of the two objects being linked. Identity attributes also serve
	// to distinguish the link from others of the same type between the same objects.
	//
	// Attributes is a required field
	Attributes []*TypedLinkAttributeDefinition `type:"list" required:"true"`

	// The set of attributes that distinguish links made from this facet from each
	// other, in the order of significance. Listing typed links can filter on the
	// values of these attributes. See ListOutgoingTypedLinks and ListIncomingTypedLinks
	// for details.
	//
	// IdentityAttributeOrder is a required field
	IdentityAttributeOrder []*string `type:"list" required:"true"`

	// The unique name of the typed link facet.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`
}

// String returns the string representation
func (s TypedLinkFacet) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TypedLinkFacet) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TypedLinkFacet) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TypedLinkFacet"}
	if s.Attributes == nil {
		invalidParams.Add(request.NewErrParamRequired("Attributes"))
	}
	if s.IdentityAttributeOrder == nil {
		invalidParams.Add(request.NewErrParamRequired("IdentityAttributeOrder"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Attributes != nil {
		for i, v := range s.Attributes {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Attributes", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAttributes sets the Attributes field's value.
func (s *TypedLinkFacet) SetAttributes(v []*TypedLinkAttributeDefinition) *TypedLinkFacet {
	s.Attributes = v
	return s
}

// SetIdentityAttributeOrder sets the IdentityAttributeOrder field's value.
func (s *TypedLinkFacet) SetIdentityAttributeOrder(v []*string) *TypedLinkFacet {
	s.IdentityAttributeOrder = v
	return s
}

// SetName sets the Name field's value.
func (s *TypedLinkFacet) SetName(v string) *TypedLinkFacet {
	s.Name = &v
	return s
}

// A typed link facet attribute update.
type TypedLinkFacetAttributeUpdate struct {
	_ struct{} `type:"structure"`

	// The action to perform when updating the attribute.
	//
	// Action is a required field
	Action *string `type:"string" required:"true" enum:"UpdateActionType"`

	// The attribute to update.
	//
	// Attribute is a required field
	Attribute *TypedLinkAttributeDefinition `type:"structure" required:"true"`
}

// String returns the string representation
func (s TypedLinkFacetAttributeUpdate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TypedLinkFacetAttributeUpdate) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TypedLinkFacetAttributeUpdate) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TypedLinkFacetAttributeUpdate"}
	if s.Action == nil {
		invalidParams.Add(request.NewErrParamRequired("Action"))
	}
	if s.Attribute == nil {
		invalidParams.Add(request.NewErrParamRequired("Attribute"))
	}
	if s.Attribute != nil {
		if err := s.Attribute.Validate(); err != nil {
			invalidParams.AddNested("Attribute", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAction sets the Action field's value.
func (s *TypedLinkFacetAttributeUpdate) SetAction(v string) *TypedLinkFacetAttributeUpdate {
	s.Action = &v
	return s
}

// SetAttribute sets the Attribute field's value.
func (s *TypedLinkFacetAttributeUpdate) SetAttribute(v *TypedLinkAttributeDefinition) *TypedLinkFacetAttributeUpdate {
	s.Attribute = v
	return s
}

// Identifies the schema Amazon Resource Name (ARN) and facet name for the typed
// link.
type TypedLinkSchemaAndFacetName struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) that is associated with the schema. For more
	// information, see arns.
	//
	// SchemaArn is a required field
	SchemaArn *string `type:"string" required:"true"`

	// The unique name of the typed link facet.
	//
	// TypedLinkName is a required field
	TypedLinkName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s TypedLinkSchemaAndFacetName) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TypedLinkSchemaAndFacetName) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TypedLinkSchemaAndFacetName) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TypedLinkSchemaAndFacetName"}
	if s.SchemaArn == nil {
		invalidParams.Add(request.NewErrParamRequired("SchemaArn"))
	}
	if s.TypedLinkName == nil {
		invalidParams.Add(request.NewErrParamRequired("TypedLinkName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSchemaArn sets the SchemaArn field's value.
func (s *TypedLinkSchemaAndFacetName) SetSchemaArn(v string) *TypedLinkSchemaAndFacetName {
	s.SchemaArn = &v
	return s
}

// SetTypedLinkName sets the TypedLinkName field's value.
func (s *TypedLinkSchemaAndFacetName) SetTypedLinkName(v string) *TypedLinkSchemaAndFacetName {
	s.TypedLinkName = &v
	return s
}

// Contains all the information that is used to uniquely identify a typed link.
// The parameters discussed in this topic are used to uniquely specify the typed
// link being operated on. The AttachTypedLink API returns a typed link specifier
// while the DetachTypedLink API accepts one as input. Similarly, the ListIncomingTypedLinks
// and ListOutgoingTypedLinks API operations provide typed link specifiers as
// output. You can also construct a typed link specifier from scratch.
type TypedLinkSpecifier struct {
	_ struct{} `type:"structure"`

	// Identifies the attribute value to update.
	//
	// IdentityAttributeValues is a required field
	IdentityAttributeValues []*AttributeNameAndValue `type:"list" required:"true"`

	// Identifies the source object that the typed link will attach to.
	//
	// SourceObjectReference is a required field
	SourceObjectReference *ObjectReference `type:"structure" required:"true"`

	// Identifies the target object that the typed link will attach to.
	//
	// TargetObjectReference is a required field
	TargetObjectReference *ObjectReference `type:"structure" required:"true"`

	// Identifies the typed link facet that is associated with the typed link.
	//
	// TypedLinkFacet is a required field
	TypedLinkFacet *TypedLinkSchemaAndFacetName `type:"structure" required:"true"`
}

// String returns the string representation
func (s TypedLinkSpecifier) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TypedLinkSpecifier) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TypedLinkSpecifier) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TypedLinkSpecifier"}
	if s.IdentityAttributeValues == nil {
		invalidParams.Add(request.NewErrParamRequired("IdentityAttributeValues"))
	}
	if s.SourceObjectReference == nil {
		invalidParams.Add(request.NewErrParamRequired("SourceObjectReference"))
	}
	if s.TargetObjectReference == nil {
		invalidParams.Add(request.NewErrParamRequired("TargetObjectReference"))
	}
	if s.TypedLinkFacet == nil {
		invalidParams.Add(request.NewErrParamRequired("TypedLinkFacet"))
	}
	if s.IdentityAttributeValues != nil {
		for i, v := range s.IdentityAttributeValues {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "IdentityAttributeValues", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.TypedLinkFacet != nil {
		if err := s.TypedLinkFacet.Validate(); err != nil {
			invalidParams.AddNested("TypedLinkFacet", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIdentityAttributeValues sets the IdentityAttributeValues field's value.
func (s *TypedLinkSpecifier) SetIdentityAttributeValues(v []*AttributeNameAndValue) *TypedLinkSpecifier {
	s.IdentityAttributeValues = v
	return s
}

// SetSourceObjectReference sets the SourceObjectReference field's value.
func (s *TypedLinkSpecifier) SetSourceObjectReference(v *ObjectReference) *TypedLinkSpecifier {
	s.SourceObjectReference = v
	return s
}

// SetTargetObjectReference sets the TargetObjectReference field's value.
func (s *TypedLinkSpecifier) SetTargetObjectReference(v *ObjectReference) *TypedLinkSpecifier {
	s.TargetObjectReference = v
	return s
}

// SetTypedLinkFacet sets the TypedLinkFacet field's value.
func (s *TypedLinkSpecifier) SetTypedLinkFacet(v *TypedLinkSchemaAndFacetName) *TypedLinkSpecifier {
	s.TypedLinkFacet = v
	return s
}

type UntagResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the resource. Tagging is only supported
	// for directories.
	//
	// ResourceArn is a required field
	ResourceArn *string `type:"string" required:"true"`

	// Keys of the tag that need to be removed from the resource.
	//
	// TagKeys is a required field
	TagKeys []*string `type:"list" required:"true"`
}

// String returns the string representation
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *UntagResourceInput) SetResourceArn(v string) *UntagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v []*string) *UntagResourceInput {
	s.TagKeys = v
	return s
}

type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

type UpdateFacetInput struct {
	_ struct{} `type:"structure"`

	// List of attributes that need to be updated in a given schema Facet. Each
	// attribute is followed by AttributeAction, which specifies the type of update
	// operation to perform.
	AttributeUpdates []*FacetAttributeUpdate `type:"list"`

	// The name of the facet.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The object type that is associated with the facet. See CreateFacetRequest$ObjectType
	// for more details.
	ObjectType *string `type:"string" enum:"ObjectType"`

	// The Amazon Resource Name (ARN) that is associated with the Facet. For more
	// information, see arns.
	//
	// SchemaArn is a required field
	SchemaArn *string `location:"header" locationName:"x-amz-data-partition" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateFacetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateFacetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateFacetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateFacetInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.SchemaArn == nil {
		invalidParams.Add(request.NewErrParamRequired("SchemaArn"))
	}
	if s.AttributeUpdates != nil {
		for i, v := range s.AttributeUpdates {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "AttributeUpdates", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAttributeUpdates sets the AttributeUpdates field's value.
func (s *UpdateFacetInput) SetAttributeUpdates(v []*FacetAttributeUpdate) *UpdateFacetInput {
	s.AttributeUpdates = v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateFacetInput) SetName(v string) *UpdateFacetInput {
	s.Name = &v
	return s
}

// SetObjectType sets the ObjectType field's value.
func (s *UpdateFacetInput) SetObjectType(v string) *UpdateFacetInput {
	s.ObjectType = &v
	return s
}

// SetSchemaArn sets the SchemaArn field's value.
func (s *UpdateFacetInput) SetSchemaArn(v string) *UpdateFacetInput {
	s.SchemaArn = &v
	return s
}

type UpdateFacetOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateFacetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateFacetOutput) GoString() string {
	return s.String()
}

type UpdateObjectAttributesInput struct {
	_ struct{} `type:"structure"`

	// The attributes update structure.
	//
	// AttributeUpdates is a required field
	AttributeUpdates []*ObjectAttributeUpdate `type:"list" required:"true"`

	// The Amazon Resource Name (ARN) that is associated with the Directory where
	// the object resides. For more information, see arns.
	//
	// DirectoryArn is a required field
	DirectoryArn *string `location:"header" locationName:"x-amz-data-partition" type:"string" required:"true"`

	// The reference that identifies the object.
	//
	// ObjectReference is a required field
	ObjectReference *ObjectReference `type:"structure" required:"true"`
}

// String returns the string representation
func (s UpdateObjectAttributesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateObjectAttributesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateObjectAttributesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateObjectAttributesInput"}
	if s.AttributeUpdates == nil {
		invalidParams.Add(request.NewErrParamRequired("AttributeUpdates"))
	}
	if s.DirectoryArn == nil {
		invalidParams.Add(request.NewErrParamRequired("DirectoryArn"))
	}
	if s.ObjectReference == nil {
		invalidParams.Add(request.NewErrParamRequired("ObjectReference"))
	}
	if s.AttributeUpdates != nil {
		for i, v := range s.AttributeUpdates {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "AttributeUpdates", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAttributeUpdates sets the AttributeUpdates field's value.
func (s *UpdateObjectAttributesInput) SetAttributeUpdates(v []*ObjectAttributeUpdate) *UpdateObjectAttributesInput {
	s.AttributeUpdates = v
	return s
}

// SetDirectoryArn sets the DirectoryArn field's value.
func (s *UpdateObjectAttributesInput) SetDirectoryArn(v string) *UpdateObjectAttributesInput {
	s.DirectoryArn = &v
	return s
}

// SetObjectReference sets the ObjectReference field's value.
func (s *UpdateObjectAttributesInput) SetObjectReference(v *ObjectReference) *UpdateObjectAttributesInput {
	s.ObjectReference = v
	return s
}

type UpdateObjectAttributesOutput struct {
	_ struct{} `type:"structure"`

	// The ObjectIdentifier of the updated object.
	ObjectIdentifier *string `type:"string"`
}

// String returns the string representation
func (s UpdateObjectAttributesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateObjectAttributesOutput) GoString() string {
	return s.String()
}

// SetObjectIdentifier sets the ObjectIdentifier field's value.
func (s *UpdateObjectAttributesOutput) SetObjectIdentifier(v string) *UpdateObjectAttributesOutput {
	s.ObjectIdentifier = &v
	return s
}

type UpdateSchemaInput struct {
	_ struct{} `type:"structure"`

	// The name of the schema.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the development schema. For more information,
	// see arns.
	//
	// SchemaArn is a required field
	SchemaArn *string `location:"header" locationName:"x-amz-data-partition" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateSchemaInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateSchemaInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateSchemaInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateSchemaInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.SchemaArn == nil {
		invalidParams.Add(request.NewErrParamRequired("SchemaArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *UpdateSchemaInput) SetName(v string) *UpdateSchemaInput {
	s.Name = &v
	return s
}

// SetSchemaArn sets the SchemaArn field's value.
func (s *UpdateSchemaInput) SetSchemaArn(v string) *UpdateSchemaInput {
	s.SchemaArn = &v
	return s
}

type UpdateSchemaOutput struct {
	_ struct{} `type:"structure"`

	// The ARN that is associated with the updated schema. For more information,
	// see arns.
	SchemaArn *string `type:"string"`
}

// String returns the string representation
func (s UpdateSchemaOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateSchemaOutput) GoString() string {
	return s.String()
}

// SetSchemaArn sets the SchemaArn field's value.
func (s *UpdateSchemaOutput) SetSchemaArn(v string) *UpdateSchemaOutput {
	s.SchemaArn = &v
	return s
}

type UpdateTypedLinkFacetInput struct {
	_ struct{} `type:"structure"`

	// Attributes update structure.
	//
	// AttributeUpdates is a required field
	AttributeUpdates []*TypedLinkFacetAttributeUpdate `type:"list" required:"true"`

	// The order of identity attributes for the facet, from most significant to
	// least significant. The ability to filter typed links considers the order
	// that the attributes are defined on the typed link facet. When providing ranges
	// to a typed link selection, any inexact ranges must be specified at the end.
	// Any attributes that do not have a range specified are presumed to match the
	// entire range. Filters are interpreted in the order of the attributes on the
	// typed link facet, not the order in which they are supplied to any API calls.
	// For more information about identity attributes, see Typed link (http://docs.aws.amazon.com/directoryservice/latest/admin-guide/objectsandlinks.html#typedlink).
	//
	// IdentityAttributeOrder is a required field
	IdentityAttributeOrder []*string `type:"list" required:"true"`

	// The unique name of the typed link facet.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`

	// The Amazon Resource Name (ARN) that is associated with the schema. For more
	// information, see arns.
	//
	// SchemaArn is a required field
	SchemaArn *string `location:"header" locationName:"x-amz-data-partition" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateTypedLinkFacetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateTypedLinkFacetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateTypedLinkFacetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateTypedLinkFacetInput"}
	if s.AttributeUpdates == nil {
		invalidParams.Add(request.NewErrParamRequired("AttributeUpdates"))
	}
	if s.IdentityAttributeOrder == nil {
		invalidParams.Add(request.NewErrParamRequired("IdentityAttributeOrder"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.SchemaArn == nil {
		invalidParams.Add(request.NewErrParamRequired("SchemaArn"))
	}
	if s.AttributeUpdates != nil {
		for i, v := range s.AttributeUpdates {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "AttributeUpdates", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAttributeUpdates sets the AttributeUpdates field's value.
func (s *UpdateTypedLinkFacetInput) SetAttributeUpdates(v []*TypedLinkFacetAttributeUpdate) *UpdateTypedLinkFacetInput {
	s.AttributeUpdates = v
	return s
}

// SetIdentityAttributeOrder sets the IdentityAttributeOrder field's value.
func (s *UpdateTypedLinkFacetInput) SetIdentityAttributeOrder(v []*string) *UpdateTypedLinkFacetInput {
	s.IdentityAttributeOrder = v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateTypedLinkFacetInput) SetName(v string) *UpdateTypedLinkFacetInput {
	s.Name = &v
	return s
}

// SetSchemaArn sets the SchemaArn field's value.
func (s *UpdateTypedLinkFacetInput) SetSchemaArn(v string) *UpdateTypedLinkFacetInput {
	s.SchemaArn = &v
	return s
}

type UpdateTypedLinkFacetOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateTypedLinkFacetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateTypedLinkFacetOutput) GoString() string {
	return s.String()
}

type UpgradeAppliedSchemaInput struct {
	_ struct{} `type:"structure"`

	// The ARN for the directory to which the upgraded schema will be applied.
	//
	// DirectoryArn is a required field
	DirectoryArn *string `type:"string" required:"true"`

	// Used for testing whether the major version schemas are backward compatible
	// or not. If schema compatibility fails, an exception would be thrown else
	// the call would succeed but no changes will be saved. This parameter is optional.
	DryRun *bool `type:"boolean"`

	// The revision of the published schema to upgrade the directory to.
	//
	// PublishedSchemaArn is a required field
	PublishedSchemaArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s UpgradeAppliedSchemaInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpgradeAppliedSchemaInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpgradeAppliedSchemaInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpgradeAppliedSchemaInput"}
	if s.DirectoryArn == nil {
		invalidParams.Add(request.NewErrParamRequired("DirectoryArn"))
	}
	if s.PublishedSchemaArn == nil {
		invalidParams.Add(request.NewErrParamRequired("PublishedSchemaArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDirectoryArn sets the DirectoryArn field's value.
func (s *UpgradeAppliedSchemaInput) SetDirectoryArn(v string) *UpgradeAppliedSchemaInput {
	s.DirectoryArn = &v
	return s
}

// SetDryRun sets the DryRun field's value.
func (s *UpgradeAppliedSchemaInput) SetDryRun(v bool) *UpgradeAppliedSchemaInput {
	s.DryRun = &v
	return s
}

// SetPublishedSchemaArn sets the PublishedSchemaArn field's value.
func (s *UpgradeAppliedSchemaInput) SetPublishedSchemaArn(v string) *UpgradeAppliedSchemaInput {
	s.PublishedSchemaArn = &v
	return s
}

type UpgradeAppliedSchemaOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the directory that is returned as part of the response.
	DirectoryArn *string `type:"string"`

	// The ARN of the upgraded schema that is returned as part of the response.
	UpgradedSchemaArn *string `type:"string"`
}

// String returns the string representation
func (s UpgradeAppliedSchemaOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpgradeAppliedSchemaOutput) GoString() string {
	return s.String()
}

// SetDirectoryArn sets the DirectoryArn field's value.
func (s *UpgradeAppliedSchemaOutput) SetDirectoryArn(v string) *UpgradeAppliedSchemaOutput {
	s.DirectoryArn = &v
	return s
}

// SetUpgradedSchemaArn sets the UpgradedSchemaArn field's value.
func (s *UpgradeAppliedSchemaOutput) SetUpgradedSchemaArn(v string) *UpgradeAppliedSchemaOutput {
	s.UpgradedSchemaArn = &v
	return s
}

type UpgradePublishedSchemaInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the development schema with the changes used for the upgrade.
	//
	// DevelopmentSchemaArn is a required field
	DevelopmentSchemaArn *string `type:"string" required:"true"`

	// Used for testing whether the Development schema provided is backwards compatible,
	// or not, with the publish schema provided by the user to be upgraded. If schema
	// compatibility fails, an exception would be thrown else the call would succeed.
	// This parameter is optional and defaults to false.
	DryRun *bool `type:"boolean"`

	// Identifies the minor version of the published schema that will be created.
	// This parameter is NOT optional.
	//
	// MinorVersion is a required field
	MinorVersion *string `min:"1" type:"string" required:"true"`

	// The ARN of the published schema to be upgraded.
	//
	// PublishedSchemaArn is a required field
	PublishedSchemaArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s UpgradePublishedSchemaInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpgradePublishedSchemaInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpgradePublishedSchemaInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpgradePublishedSchemaInput"}
	if s.DevelopmentSchemaArn == nil {
		invalidParams.Add(request.NewErrParamRequired("DevelopmentSchemaArn"))
	}
	if s.MinorVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("MinorVersion"))
	}
	if s.MinorVersion != nil && len(*s.MinorVersion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MinorVersion", 1))
	}
	if s.PublishedSchemaArn == nil {
		invalidParams.Add(request.NewErrParamRequired("PublishedSchemaArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDevelopmentSchemaArn sets the DevelopmentSchemaArn field's value.
func (s *UpgradePublishedSchemaInput) SetDevelopmentSchemaArn(v string) *UpgradePublishedSchemaInput {
	s.DevelopmentSchemaArn = &v
	return s
}

// SetDryRun sets the DryRun field's value.
func (s *UpgradePublishedSchemaInput) SetDryRun(v bool) *UpgradePublishedSchemaInput {
	s.DryRun = &v
	return s
}

// SetMinorVersion sets the MinorVersion field's value.
func (s *UpgradePublishedSchemaInput) SetMinorVersion(v string) *UpgradePublishedSchemaInput {
	s.MinorVersion = &v
	return s
}

// SetPublishedSchemaArn sets the PublishedSchemaArn field's value.
func (s *UpgradePublishedSchemaInput) SetPublishedSchemaArn(v string) *UpgradePublishedSchemaInput {
	s.PublishedSchemaArn = &v
	return s
}

type UpgradePublishedSchemaOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the upgraded schema that is returned as part of the response.
	UpgradedSchemaArn *string `type:"string"`
}

// String returns the string representation
func (s UpgradePublishedSchemaOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpgradePublishedSchemaOutput) GoString() string {
	return s.String()
}

// SetUpgradedSchemaArn sets the UpgradedSchemaArn field's value.
func (s *UpgradePublishedSchemaOutput) SetUpgradedSchemaArn(v string) *UpgradePublishedSchemaOutput {
	s.UpgradedSchemaArn = &v
	return s
}

const (
	// BatchReadExceptionTypeValidationException is a BatchReadExceptionType enum value
	BatchReadExceptionTypeValidationException = "ValidationException"

	// BatchReadExceptionTypeInvalidArnException is a BatchReadExceptionType enum value
	BatchReadExceptionTypeInvalidArnException = "InvalidArnException"

	// BatchReadExceptionTypeResourceNotFoundException is a BatchReadExceptionType enum value
	BatchReadExceptionTypeResourceNotFoundException = "ResourceNotFoundException"

	// BatchReadExceptionTypeInvalidNextTokenException is a BatchReadExceptionType enum value
	BatchReadExceptionTypeInvalidNextTokenException = "InvalidNextTokenException"

	// BatchReadExceptionTypeAccessDeniedException is a BatchReadExceptionType enum value
	BatchReadExceptionTypeAccessDeniedException = "AccessDeniedException"

	// BatchReadExceptionTypeNotNodeException is a BatchReadExceptionType enum value
	BatchReadExceptionTypeNotNodeException = "NotNodeException"

	// BatchReadExceptionTypeFacetValidationException is a BatchReadExceptionType enum value
	BatchReadExceptionTypeFacetValidationException = "FacetValidationException"

	// BatchReadExceptionTypeCannotListParentOfRootException is a BatchReadExceptionType enum value
	BatchReadExceptionTypeCannotListParentOfRootException = "CannotListParentOfRootException"

	// BatchReadExceptionTypeNotIndexException is a BatchReadExceptionType enum value
	BatchReadExceptionTypeNotIndexException = "NotIndexException"

	// BatchReadExceptionTypeNotPolicyException is a BatchReadExceptionType enum value
	BatchReadExceptionTypeNotPolicyException = "NotPolicyException"

	// BatchReadExceptionTypeDirectoryNotEnabledException is a BatchReadExceptionType enum value
	BatchReadExceptionTypeDirectoryNotEnabledException = "DirectoryNotEnabledException"

	// BatchReadExceptionTypeLimitExceededException is a BatchReadExceptionType enum value
	BatchReadExceptionTypeLimitExceededException = "LimitExceededException"

	// BatchReadExceptionTypeInternalServiceException is a BatchReadExceptionType enum value
	BatchReadExceptionTypeInternalServiceException = "InternalServiceException"
)

const (
	// BatchWriteExceptionTypeInternalServiceException is a BatchWriteExceptionType enum value
	BatchWriteExceptionTypeInternalServiceException = "InternalServiceException"

	// BatchWriteExceptionTypeValidationException is a BatchWriteExceptionType enum value
	BatchWriteExceptionTypeValidationException = "ValidationException"

	// BatchWriteExceptionTypeInvalidArnException is a BatchWriteExceptionType enum value
	BatchWriteExceptionTypeInvalidArnException = "InvalidArnException"

	// BatchWriteExceptionTypeLinkNameAlreadyInUseException is a BatchWriteExceptionType enum value
	BatchWriteExceptionTypeLinkNameAlreadyInUseException = "LinkNameAlreadyInUseException"

	// BatchWriteExceptionTypeStillContainsLinksException is a BatchWriteExceptionType enum value
	BatchWriteExceptionTypeStillContainsLinksException = "StillContainsLinksException"

	// BatchWriteExceptionTypeFacetValidationException is a BatchWriteExceptionType enum value
	BatchWriteExceptionTypeFacetValidationException = "FacetValidationException"

	// BatchWriteExceptionTypeObjectNotDetachedException is a BatchWriteExceptionType enum value
	BatchWriteExceptionTypeObjectNotDetachedException = "ObjectNotDetachedException"

	// BatchWriteExceptionTypeResourceNotFoundException is a BatchWriteExceptionType enum value
	BatchWriteExceptionTypeResourceNotFoundException = "ResourceNotFoundException"

	// BatchWriteExceptionTypeAccessDeniedException is a BatchWriteExceptionType enum value
	BatchWriteExceptionTypeAccessDeniedException = "AccessDeniedException"

	// BatchWriteExceptionTypeInvalidAttachmentException is a BatchWriteExceptionType enum value
	BatchWriteExceptionTypeInvalidAttachmentException = "InvalidAttachmentException"

	// BatchWriteExceptionTypeNotIndexException is a BatchWriteExceptionType enum value
	BatchWriteExceptionTypeNotIndexException = "NotIndexException"

	// BatchWriteExceptionTypeNotNodeException is a BatchWriteExceptionType enum value
	BatchWriteExceptionTypeNotNodeException = "NotNodeException"

	// BatchWriteExceptionTypeIndexedAttributeMissingException is a BatchWriteExceptionType enum value
	BatchWriteExceptionTypeIndexedAttributeMissingException = "IndexedAttributeMissingException"

	// BatchWriteExceptionTypeObjectAlreadyDetachedException is a BatchWriteExceptionType enum value
	BatchWriteExceptionTypeObjectAlreadyDetachedException = "ObjectAlreadyDetachedException"

	// BatchWriteExceptionTypeNotPolicyException is a BatchWriteExceptionType enum value
	BatchWriteExceptionTypeNotPolicyException = "NotPolicyException"

	// BatchWriteExceptionTypeDirectoryNotEnabledException is a BatchWriteExceptionType enum value
	BatchWriteExceptionTypeDirectoryNotEnabledException = "DirectoryNotEnabledException"

	// BatchWriteExceptionTypeLimitExceededException is a BatchWriteExceptionType enum value
	BatchWriteExceptionTypeLimitExceededException = "LimitExceededException"

	// BatchWriteExceptionTypeUnsupportedIndexTypeException is a BatchWriteExceptionType enum value
	BatchWriteExceptionTypeUnsupportedIndexTypeException = "UnsupportedIndexTypeException"
)

const (
	// ConsistencyLevelSerializable is a ConsistencyLevel enum value
	ConsistencyLevelSerializable = "SERIALIZABLE"

	// ConsistencyLevelEventual is a ConsistencyLevel enum value
	ConsistencyLevelEventual = "EVENTUAL"
)

const (
	// DirectoryStateEnabled is a DirectoryState enum value
	DirectoryStateEnabled = "ENABLED"

	// DirectoryStateDisabled is a DirectoryState enum value
	DirectoryStateDisabled = "DISABLED"

	// DirectoryStateDeleted is a DirectoryState enum value
	DirectoryStateDeleted = "DELETED"
)

const (
	// FacetAttributeTypeString is a FacetAttributeType enum value
	FacetAttributeTypeString = "STRING"

	// FacetAttributeTypeBinary is a FacetAttributeType enum value
	FacetAttributeTypeBinary = "BINARY"

	// FacetAttributeTypeBoolean is a FacetAttributeType enum value
	FacetAttributeTypeBoolean = "BOOLEAN"

	// FacetAttributeTypeNumber is a FacetAttributeType enum value
	FacetAttributeTypeNumber = "NUMBER"

	// FacetAttributeTypeDatetime is a FacetAttributeType enum value
	FacetAttributeTypeDatetime = "DATETIME"
)

const (
	// ObjectTypeNode is a ObjectType enum value
	ObjectTypeNode = "NODE"

	// ObjectTypeLeafNode is a ObjectType enum value
	ObjectTypeLeafNode = "LEAF_NODE"

	// ObjectTypePolicy is a ObjectType enum value
	ObjectTypePolicy = "POLICY"

	// ObjectTypeIndex is a ObjectType enum value
	ObjectTypeIndex = "INDEX"
)

const (
	// RangeModeFirst is a RangeMode enum value
	RangeModeFirst = "FIRST"

	// RangeModeLast is a RangeMode enum value
	RangeModeLast = "LAST"

	// RangeModeLastBeforeMissingValues is a RangeMode enum value
	RangeModeLastBeforeMissingValues = "LAST_BEFORE_MISSING_VALUES"

	// RangeModeInclusive is a RangeMode enum value
	RangeModeInclusive = "INCLUSIVE"

	// RangeModeExclusive is a RangeMode enum value
	RangeModeExclusive = "EXCLUSIVE"
)

const (
	// RequiredAttributeBehaviorRequiredAlways is a RequiredAttributeBehavior enum value
	RequiredAttributeBehaviorRequiredAlways = "REQUIRED_ALWAYS"

	// RequiredAttributeBehaviorNotRequired is a RequiredAttributeBehavior enum value
	RequiredAttributeBehaviorNotRequired = "NOT_REQUIRED"
)

const (
	// RuleTypeBinaryLength is a RuleType enum value
	RuleTypeBinaryLength = "BINARY_LENGTH"

	// RuleTypeNumberComparison is a RuleType enum value
	RuleTypeNumberComparison = "NUMBER_COMPARISON"

	// RuleTypeStringFromSet is a RuleType enum value
	RuleTypeStringFromSet = "STRING_FROM_SET"

	// RuleTypeStringLength is a RuleType enum value
	RuleTypeStringLength = "STRING_LENGTH"
)

const (
	// UpdateActionTypeCreateOrUpdate is a UpdateActionType enum value
	UpdateActionTypeCreateOrUpdate = "CREATE_OR_UPDATE"

	// UpdateActionTypeDelete is a UpdateActionType enum value
	UpdateActionTypeDelete = "DELETE"
)
