/***************************************************************************
 $RCSfile: changekeys.cpp,v $
                             -------------------
    cvs         : $Id: changekeys.cpp,v 1.4 2003/05/18 03:02:11 aquamaniac Exp $
    begin       : Thu Feb 20 2003
    copyright   : (C) 2003 by Fabian Kaiser
    email       : openhbci@derzach.de

 ***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or         *
 *   modify it under the terms of the GNU Lesser General Public            *
 *   License as published by the Free Software Foundation; either          *
 *   version 2.1 of the License, or (at your option) any later version.    *
 *                                                                         *
 *   This library is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   Lesser General Public License for more details.                       *
 *                                                                         *
 *   You should have received a copy of the GNU Lesser General Public      *
 *   License along with this library; if not, write to the Free Software   *
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston,                 *
 *   MA  02111-1307  USA                                                   *
 *                                                                         *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
# include <config.h>
#endif



/*
 */

#include "changekeys.h"


HBCI::Error changeKeys(HBCI::Pointer<AQMAPI> hbciif,
		       HBCI::SimpleConfig &opt){
  HBCI::Pointer<HBCI::OutboxJob> job;
  HBCI::Tree<HBCI::ConfigNode>::iterator var;
  int country;
  string instid;
  string userid;
  HBCI::Error err;
  HBCI::Pointer<HBCI::User> user;
  HBCI::Pointer<HBCI::Customer> cust;

  job.setDescription("changeKeys:job (HBCI::OutboxJob)");
  country=opt.getIntVariable("country",280,opt.root());
  instid=opt.getVariable("instid","*",opt.root());
  userid=opt.getVariable("user","",opt.root());

  // get the user
  user = hbciif.ref().findUser(country, instid, userid);
  if (!user.isValid())
    return HBCI::Error("changeKeys()",
		       ERROR_LEVEL_NORMAL,
		       0,
		       ERROR_ADVISE_DONTKNOW,
		       "user not found");

  // we need the customer for creating the job
  cust = user.ref().customers().back();
  if (!cust.isValid())
    return HBCI::Error("changeKeys()",
		       ERROR_LEVEL_NORMAL,
		       0,
		       ERROR_ADVISE_DONTKNOW,
		       "customer not found");

  // create the new keys
  if (! HBCI_SECURITY_RDH ==
      cust.ref().user().ref().medium().ref().securityMode())
    return HBCI::Error("changeKeys()",
		       ERROR_LEVEL_NORMAL,
		       0,
		       ERROR_ADVISE_DONTKNOW,
		       "not in RDH mode");

  HBCI::Pointer<HBCI::MediumRDHBase> mediumRDH =
    cust.ref().user().ref().medium().cast<HBCI::MediumRDHBase>();
  mediumRDH.ref().createUserKeys(false);

  // create job
  job=new HBCI::OutboxJobChangeKeys(hbciif.ptr(), cust);

  // enqueue job
  hbciif.ref().addJob(job);


  try {
    // execute queue
    err=hbciif.ref().executeQueue(true);
    // if submission was successful, activate the new keys
    if (HBCI_JOB_RESULT_SUCCESS == job.ref().result())
      mediumRDH.ref().activateKeys();
  }
  catch (HBCI::Error lerr) {
    err=lerr;
  }

  if (hbciif.ref().debugLevel() > 0) {
    cerr << "Changing keys was ";
    if (HBCI_JOB_RESULT_SUCCESS != job.ref().result())
      cerr << "not ";
    cerr << "successful" << endl;
  }

  return err;
}


