val info : string -> unit
type request = Get of string
and headers = (string * string) list
and response = Okay of content_type * byte_source | Error of error * string
and error =
| Internal_server_error
| Document_not_found
| Forbidden
| Method_not_allowed
and content_type =
| Text_Html
| Text_Css
| Application_Octet_stream
and byte_source =
| Html of Html.html_document
| File of string
| String of string
val handler :
  (request * (string * string) list -> response) ->
  Unix.file_descr * 'a -> unit
