/* Generated by call-gen.pl from /usr/local/include/GL/gl.h */

void OSMesaDriver::glClearIndex(Uint32 ctx, GLfloat c )
{
	D(bug("nfosmesa: glClearIndex"));
	SelectContext(ctx);
	fn.glClearIndex(  c );
}

void OSMesaDriver::glClearColor(Uint32 ctx, GLclampf red, GLclampf green, GLclampf blue, GLclampf alpha )
{
	D(bug("nfosmesa: glClearColor(%.3f,%.3f,%.3f,%.3f)",red,green,blue,alpha));
	SelectContext(ctx);
	fn.glClearColor(  red,  green,  blue,  alpha );
}

void OSMesaDriver::glClear(Uint32 ctx, GLbitfield mask )
{
	D(bug("nfosmesa: glClear"));
	SelectContext(ctx);
	fn.glClear(  mask );
}

void OSMesaDriver::glIndexMask(Uint32 ctx, GLuint mask )
{
	D(bug("nfosmesa: glIndexMask"));
	SelectContext(ctx);
	fn.glIndexMask(  mask );
}

void OSMesaDriver::glColorMask(Uint32 ctx, GLboolean red, GLboolean green, GLboolean blue, GLboolean alpha )
{
	D(bug("nfosmesa: glColorMask"));
	SelectContext(ctx);
	fn.glColorMask(  red,  green,  blue,  alpha );
}

void OSMesaDriver::glAlphaFunc(Uint32 ctx, GLenum func, GLclampf ref )
{
	D(bug("nfosmesa: glAlphaFunc"));
	SelectContext(ctx);
	fn.glAlphaFunc(  func,  ref );
}

void OSMesaDriver::glBlendFunc(Uint32 ctx, GLenum sfactor, GLenum dfactor )
{
	D(bug("nfosmesa: glBlendFunc"));
	SelectContext(ctx);
	fn.glBlendFunc(  sfactor,  dfactor );
}

void OSMesaDriver::glLogicOp(Uint32 ctx, GLenum opcode )
{
	D(bug("nfosmesa: glLogicOp"));
	SelectContext(ctx);
	fn.glLogicOp(  opcode );
}

void OSMesaDriver::glCullFace(Uint32 ctx, GLenum mode )
{
	D(bug("nfosmesa: glCullFace"));
	SelectContext(ctx);
	fn.glCullFace(  mode );
}

void OSMesaDriver::glFrontFace(Uint32 ctx, GLenum mode )
{
	D(bug("nfosmesa: glFrontFace"));
	SelectContext(ctx);
	fn.glFrontFace(  mode );
}

void OSMesaDriver::glPointSize(Uint32 ctx, GLfloat size )
{
	D(bug("nfosmesa: glPointSize"));
	SelectContext(ctx);
	fn.glPointSize(  size );
}

void OSMesaDriver::glLineWidth(Uint32 ctx, GLfloat width )
{
	D(bug("nfosmesa: glLineWidth"));
	SelectContext(ctx);
	fn.glLineWidth(  width );
}

void OSMesaDriver::glLineStipple(Uint32 ctx, GLint factor, GLushort pattern )
{
	D(bug("nfosmesa: glLineStipple"));
	SelectContext(ctx);
	fn.glLineStipple(  factor,  pattern );
}

void OSMesaDriver::glPolygonMode(Uint32 ctx, GLenum face, GLenum mode )
{
	D(bug("nfosmesa: glPolygonMode"));
	SelectContext(ctx);
	fn.glPolygonMode(  face,  mode );
}

void OSMesaDriver::glPolygonOffset(Uint32 ctx, GLfloat factor, GLfloat units )
{
	D(bug("nfosmesa: glPolygonOffset"));
	SelectContext(ctx);
	fn.glPolygonOffset(  factor,  units );
}

void OSMesaDriver::glPolygonStipple(Uint32 ctx, const GLubyte *mask )
{
	D(bug("nfosmesa: glPolygonStipple"));
	SelectContext(ctx);
	fn.glPolygonStipple(  mask );
}

void OSMesaDriver::glGetPolygonStipple(Uint32 ctx, GLubyte *mask )
{
	D(bug("nfosmesa: glGetPolygonStipple"));
	SelectContext(ctx);
	fn.glGetPolygonStipple(  mask );
}

void OSMesaDriver::glEdgeFlag(Uint32 ctx, GLboolean flag )
{
	D(bug("nfosmesa: glEdgeFlag"));
	SelectContext(ctx);
	fn.glEdgeFlag(  flag );
}

void OSMesaDriver::glEdgeFlagv(Uint32 ctx, const GLboolean *flag )
{
	D(bug("nfosmesa: glEdgeFlagv"));
	SelectContext(ctx);
	fn.glEdgeFlagv(  flag );
}

void OSMesaDriver::glScissor(Uint32 ctx, GLint x, GLint y, GLsizei width, GLsizei height)
{
	D(bug("nfosmesa: glScissor"));
	SelectContext(ctx);
	fn.glScissor(  x,  y,  width,  height);
}

void OSMesaDriver::glClipPlane(Uint32 ctx, GLenum plane, const GLdouble *equation )
{
	GLdouble tmp[4];

	D(bug("nfosmesa: glClipPlane"));
	SelectContext(ctx);
	Atari2HostDoublePtr(4, (Uint32 *)equation, tmp);
	fn.glClipPlane(  plane,  tmp );
}

void OSMesaDriver::glGetClipPlane(Uint32 ctx, GLenum plane, GLdouble *equation )
{
	D(bug("nfosmesa: glGetClipPlane"));
	SelectContext(ctx);
	fn.glGetClipPlane(  plane,  equation );
}

void OSMesaDriver::glDrawBuffer(Uint32 ctx, GLenum mode )
{
	D(bug("nfosmesa: glDrawBuffer"));
	SelectContext(ctx);
	fn.glDrawBuffer(  mode );
}

void OSMesaDriver::glReadBuffer(Uint32 ctx, GLenum mode )
{
	D(bug("nfosmesa: glReadBuffer"));
	SelectContext(ctx);
	fn.glReadBuffer(  mode );
}

void OSMesaDriver::glEnable(Uint32 ctx, GLenum cap )
{
	D(bug("nfosmesa: glEnable"));
	SelectContext(ctx);
	fn.glEnable(  cap );
}

void OSMesaDriver::glDisable(Uint32 ctx, GLenum cap )
{
	D(bug("nfosmesa: glDisable"));
	SelectContext(ctx);
	fn.glDisable(  cap );
}

GLboolean OSMesaDriver::glIsEnabled(Uint32 ctx, GLenum cap )
{
	D(bug("nfosmesa: glIsEnabled"));
	SelectContext(ctx);
	return fn.glIsEnabled(  cap );
}

void OSMesaDriver::glEnableClientState(Uint32 ctx, GLenum cap )
{
	D(bug("nfosmesa: glEnableClientState"));
	SelectContext(ctx);
#if SDL_BYTEORDER == SDL_LIL_ENDIAN
	switch(cap) {
		case GL_VERTEX_ARRAY:
			contexts[ctx].enabled_arrays |= NFOSMESA_VERTEX_ARRAY;
			break;
		case GL_NORMAL_ARRAY:
			contexts[ctx].enabled_arrays |= NFOSMESA_NORMAL_ARRAY;
			break;
		case GL_COLOR_ARRAY:
			contexts[ctx].enabled_arrays |= NFOSMESA_COLOR_ARRAY;
			break;
		case GL_INDEX_ARRAY:
			contexts[ctx].enabled_arrays |= NFOSMESA_INDEX_ARRAY;
			break;
		case GL_EDGE_FLAG_ARRAY:
			contexts[ctx].enabled_arrays |= NFOSMESA_EDGEFLAG_ARRAY;
			break;
		case GL_TEXTURE_COORD_ARRAY:
			contexts[ctx].enabled_arrays |= NFOSMESA_TEXCOORD_ARRAY;
			break;
	}
#endif
	fn.glEnableClientState(  cap );
}

void OSMesaDriver::glDisableClientState(Uint32 ctx, GLenum cap )
{
	D(bug("nfosmesa: glDisableClientState"));
	SelectContext(ctx);
#if SDL_BYTEORDER == SDL_LIL_ENDIAN
	switch(cap) {
		case GL_VERTEX_ARRAY:
			contexts[ctx].enabled_arrays &= ~NFOSMESA_VERTEX_ARRAY;
			break;
		case GL_NORMAL_ARRAY:
			contexts[ctx].enabled_arrays &= ~NFOSMESA_NORMAL_ARRAY;
			break;
		case GL_COLOR_ARRAY:
			contexts[ctx].enabled_arrays &= ~NFOSMESA_COLOR_ARRAY;
			break;
		case GL_INDEX_ARRAY:
			contexts[ctx].enabled_arrays &= ~NFOSMESA_INDEX_ARRAY;
			break;
		case GL_EDGE_FLAG_ARRAY:
			contexts[ctx].enabled_arrays &= ~NFOSMESA_EDGEFLAG_ARRAY;
			break;
		case GL_TEXTURE_COORD_ARRAY:
			contexts[ctx].enabled_arrays &= ~NFOSMESA_TEXCOORD_ARRAY;
			break;
	}
#endif
	fn.glDisableClientState(  cap );
}

void OSMesaDriver::glGetBooleanv(Uint32 ctx, GLenum pname, GLboolean *params )
{
	GLboolean tmp;

	D(bug("nfosmesa: glGetBooleanv"));
	SelectContext(ctx);
	fn.glGetBooleanv(  pname,  &tmp );
	*params = SDL_SwapBE32(tmp);
}

void OSMesaDriver::glGetDoublev(Uint32 ctx, GLenum pname, GLdouble *params )
{
	D(bug("nfosmesa: glGetDoublev"));
	SelectContext(ctx);
	fn.glGetDoublev(  pname,  params );
}

void OSMesaDriver::glGetFloatv(Uint32 ctx, GLenum pname, GLfloat *params )
{
	GLfloat tmp;

	D(bug("nfosmesa: glGetFloatv"));
	SelectContext(ctx);
	fn.glGetFloatv(  pname,  &tmp );
	*params = (GLfloat)SDL_SwapBE32((Uint32)tmp);
}

void OSMesaDriver::glGetIntegerv(Uint32 ctx, GLenum pname, GLint *params )
{
	GLint tmp;

	D(bug("nfosmesa: glGetIntegerv"));
	SelectContext(ctx);
	fn.glGetIntegerv(  pname,  &tmp );
	*params = SDL_SwapBE32(tmp);
}

void OSMesaDriver::glPushAttrib(Uint32 ctx, GLbitfield mask )
{
	D(bug("nfosmesa: glPushAttrib"));
	SelectContext(ctx);
	fn.glPushAttrib(  mask );
}

void OSMesaDriver::glPopAttrib(Uint32 ctx)
{
	D(bug("nfosmesa: glPopAttrib"));
	SelectContext(ctx);
	fn.glPopAttrib(  );
}

void OSMesaDriver::glPushClientAttrib(Uint32 ctx, GLbitfield mask )
{
	D(bug("nfosmesa: glPushClientAttrib"));
	SelectContext(ctx);
	fn.glPushClientAttrib(  mask );
}

void OSMesaDriver::glPopClientAttrib(Uint32 ctx)
{
	D(bug("nfosmesa: glPopClientAttrib"));
	SelectContext(ctx);
	fn.glPopClientAttrib(  );
}

GLint OSMesaDriver::glRenderMode(Uint32 ctx, GLenum mode )
{
	D(bug("nfosmesa: glRenderMode"));
	SelectContext(ctx);
	return fn.glRenderMode(  mode );
}

GLenum OSMesaDriver::glGetError(Uint32 ctx)
{
	D(bug("nfosmesa: glGetError"));
	SelectContext(ctx);
	return fn.glGetError(  );
}

const GLubyte* OSMesaDriver::glGetString(Uint32 ctx, GLenum name )
{
	D(bug("nfosmesa: glGetString"));
	SelectContext(ctx);
	return fn.glGetString(  name );
}

void OSMesaDriver::glFinish(Uint32 ctx)
{
	D(bug("nfosmesa: glFinish"));
	SelectContext(ctx);
	fn.glFinish(  );
#if SDL_BYTEORDER == SDL_LIL_ENDIAN
	ConvertContext(ctx);
#endif
}

void OSMesaDriver::glFlush(Uint32 ctx)
{
	D(bug("nfosmesa: glFlush"));
	SelectContext(ctx);
	fn.glFlush(  );
#if SDL_BYTEORDER == SDL_LIL_ENDIAN
	ConvertContext(ctx);
#endif
}

void OSMesaDriver::glHint(Uint32 ctx, GLenum target, GLenum mode )
{
	D(bug("nfosmesa: glHint"));
	SelectContext(ctx);
	fn.glHint(  target,  mode );
}

void OSMesaDriver::glClearDepth(Uint32 ctx, GLclampd depth )
{
	D(bug("nfosmesa: glClearDepth"));
	SelectContext(ctx);
	fn.glClearDepth(  depth );
}

void OSMesaDriver::glDepthFunc(Uint32 ctx, GLenum func )
{
	D(bug("nfosmesa: glDepthFunc"));
	SelectContext(ctx);
	fn.glDepthFunc(  func );
}

void OSMesaDriver::glDepthMask(Uint32 ctx, GLboolean flag )
{
	D(bug("nfosmesa: glDepthMask"));
	SelectContext(ctx);
	fn.glDepthMask(  flag );
}

void OSMesaDriver::glDepthRange(Uint32 ctx, GLclampd near_val, GLclampd far_val )
{
	D(bug("nfosmesa: glDepthRange"));
	SelectContext(ctx);
	fn.glDepthRange(  near_val,  far_val );
}

void OSMesaDriver::glClearAccum(Uint32 ctx, GLfloat red, GLfloat green, GLfloat blue, GLfloat alpha )
{
	D(bug("nfosmesa: glClearAccum"));
	SelectContext(ctx);
	fn.glClearAccum(  red,  green,  blue,  alpha );
}

void OSMesaDriver::glAccum(Uint32 ctx, GLenum op, GLfloat value )
{
	D(bug("nfosmesa: glAccum"));
	SelectContext(ctx);
	fn.glAccum(  op,  value );
}

void OSMesaDriver::glMatrixMode(Uint32 ctx, GLenum mode )
{
	D(bug("nfosmesa: glMatrixMode"));
	SelectContext(ctx);
	fn.glMatrixMode(  mode );
}

void OSMesaDriver::glOrtho(Uint32 ctx, GLdouble left, GLdouble right, GLdouble bottom, GLdouble top, GLdouble near_val, GLdouble far_val )
{
	D(bug("nfosmesa: glOrtho(%.3f,%.3f, %.3f,%.3f, %.3f,%.3f)",left,right,bottom,top,near_val,far_val));
	SelectContext(ctx);
	fn.glOrtho(  left,  right,  bottom,  top,  near_val,  far_val );
}

void OSMesaDriver::glFrustum(Uint32 ctx, GLdouble left, GLdouble right, GLdouble bottom, GLdouble top, GLdouble near_val, GLdouble far_val )
{
	D(bug("nfosmesa: glFrustum"));
	SelectContext(ctx);
	fn.glFrustum(  left,  right,  bottom,  top,  near_val,  far_val );
}

void OSMesaDriver::glViewport(Uint32 ctx, GLint x, GLint y, GLsizei width, GLsizei height )
{
	D(bug("nfosmesa: glViewport"));
	SelectContext(ctx);
	fn.glViewport(  x,  y,  width,  height );
}

void OSMesaDriver::glPushMatrix(Uint32 ctx)
{
	D(bug("nfosmesa: glPushMatrix"));
	SelectContext(ctx);
	fn.glPushMatrix(  );
}

void OSMesaDriver::glPopMatrix(Uint32 ctx)
{
	D(bug("nfosmesa: glPopMatrix"));
	SelectContext(ctx);
	fn.glPopMatrix(  );
}

void OSMesaDriver::glLoadIdentity(Uint32 ctx)
{
	D(bug("nfosmesa: glLoadIdentity"));
	SelectContext(ctx);
	fn.glLoadIdentity(  );
}

void OSMesaDriver::glLoadMatrixd(Uint32 ctx, const GLdouble *m )
{
	GLdouble tmp[16];

	D(bug("nfosmesa: glLoadMatrixd"));
	SelectContext(ctx);
	Atari2HostDoublePtr(16, (Uint32 *)m, tmp);
	fn.glLoadMatrixd(  tmp );
}

void OSMesaDriver::glLoadMatrixf(Uint32 ctx, const GLfloat *m )
{
	GLfloat tmp[16];

	D(bug("nfosmesa: glLoadMatrixf"));
	SelectContext(ctx);
	Atari2HostFloatPtr(16, (Uint32 *)m, tmp);
	fn.glLoadMatrixf(tmp);
}

void OSMesaDriver::glMultMatrixd(Uint32 ctx, const GLdouble *m )
{
	GLdouble tmp[16];

	D(bug("nfosmesa: glMultMatrixd"));
	SelectContext(ctx);
	Atari2HostDoublePtr(16, (Uint32 *)m, tmp);
	fn.glMultMatrixd( tmp );
}

void OSMesaDriver::glMultMatrixf(Uint32 ctx, const GLfloat *m )
{
	GLfloat tmp[16];

	D(bug("nfosmesa: glMultMatrixf"));
	SelectContext(ctx);
	Atari2HostFloatPtr(16, (Uint32 *)m, tmp);
	fn.glMultMatrixf(tmp);
}

void OSMesaDriver::glRotated(Uint32 ctx, GLdouble angle, GLdouble x, GLdouble y, GLdouble z )
{
	D(bug("nfosmesa: glRotated"));
	SelectContext(ctx);
	fn.glRotated(  angle,  x,  y,  z );
}

void OSMesaDriver::glRotatef(Uint32 ctx, GLfloat angle, GLfloat x, GLfloat y, GLfloat z )
{
	D(bug("nfosmesa: glRotatef"));
	SelectContext(ctx);
	fn.glRotatef(  angle,  x,  y,  z );
}

void OSMesaDriver::glScaled(Uint32 ctx, GLdouble x, GLdouble y, GLdouble z )
{
	D(bug("nfosmesa: glScaled"));
	SelectContext(ctx);
	fn.glScaled(  x,  y,  z );
}

void OSMesaDriver::glScalef(Uint32 ctx, GLfloat x, GLfloat y, GLfloat z )
{
	D(bug("nfosmesa: glScalef"));
	SelectContext(ctx);
	fn.glScalef(  x,  y,  z );
}

void OSMesaDriver::glTranslated(Uint32 ctx, GLdouble x, GLdouble y, GLdouble z )
{
	D(bug("nfosmesa: glTranslated"));
	SelectContext(ctx);
	fn.glTranslated(  x,  y,  z );
}

void OSMesaDriver::glTranslatef(Uint32 ctx, GLfloat x, GLfloat y, GLfloat z )
{
	D(bug("nfosmesa: glTranslatef"));
	SelectContext(ctx);
	fn.glTranslatef(  x,  y,  z );
}

GLboolean OSMesaDriver::glIsList(Uint32 ctx, GLuint list )
{
	D(bug("nfosmesa: glIsList"));
	SelectContext(ctx);
	return fn.glIsList(  list );
}

void OSMesaDriver::glDeleteLists(Uint32 ctx, GLuint list, GLsizei range )
{
	D(bug("nfosmesa: glDeleteLists"));
	SelectContext(ctx);
	fn.glDeleteLists(  list,  range );
}

GLuint OSMesaDriver::glGenLists(Uint32 ctx, GLsizei range )
{
	D(bug("nfosmesa: glGenLists"));
	SelectContext(ctx);
	return fn.glGenLists(  range );
}

void OSMesaDriver::glNewList(Uint32 ctx, GLuint list, GLenum mode )
{
	D(bug("nfosmesa: glNewList"));
	SelectContext(ctx);
	fn.glNewList(  list,  mode );
}

void OSMesaDriver::glEndList(Uint32 ctx)
{
	D(bug("nfosmesa: glEndList"));
	SelectContext(ctx);
	fn.glEndList(  );
}

void OSMesaDriver::glCallList(Uint32 ctx, GLuint list )
{
	D(bug("nfosmesa: glCallList"));
	SelectContext(ctx);
	fn.glCallList(  list );
}

void OSMesaDriver::glCallLists(Uint32 ctx, GLsizei n, GLenum type, const GLvoid *lists )
{
	void *tmp;
	int i;
	GLshort *src16,*dst16;
	GLint *src32,*dst32;

	D(bug("nfosmesa: glCallLists"));
	if (n<=0) {
		return;
	}
	switch(type) {
		case GL_BYTE:
		case GL_UNSIGNED_BYTE:
			tmp = malloc(n);
			if (!tmp) {
				return;
			}
			memcpy(tmp,lists,n);
			break;
		case GL_SHORT:
		case GL_UNSIGNED_SHORT:
			tmp = malloc(n*sizeof(GLshort));
			if (!tmp) {
				return;
			}
			dst16 = (GLshort *)tmp;
			src16 = (GLshort *)lists;
			for (i=0;i<n;i++) {
				*dst16++ = SDL_SwapBE16((Uint16)(*src16++));
			}
			break;
		case GL_INT:
		case GL_UNSIGNED_INT:
		case GL_FLOAT:
			tmp = malloc(n*sizeof(GLint));
			if (!tmp) {
				return;
			}
			dst32 = (GLint *)tmp;
			src32 = (GLint *)lists;
			for (i=0;i<n;i++) {
				*dst32++ = SDL_SwapBE32((Uint32)(*src32++));
			}
			break;
		default:
			/* FIXME: GL_n_BYTES */
			return;
	}
	SelectContext(ctx);
	fn.glCallLists(  n,  type,  tmp );
	if (tmp) {
		free(tmp);
	}
}

void OSMesaDriver::glListBase(Uint32 ctx, GLuint base )
{
	D(bug("nfosmesa: glListBase"));
	SelectContext(ctx);
	fn.glListBase(  base );
}

void OSMesaDriver::glBegin(Uint32 ctx, GLenum mode )
{
	D(bug("nfosmesa: glBegin"));
	SelectContext(ctx);
	fn.glBegin(  mode );
}

void OSMesaDriver::glEnd(Uint32 ctx)
{
	D(bug("nfosmesa: glEnd"));
	SelectContext(ctx);
	fn.glEnd(  );
}

void OSMesaDriver::glVertex2d(Uint32 ctx, GLdouble x, GLdouble y )
{
	D(bug("nfosmesa: glVertex2d"));
	SelectContext(ctx);
	fn.glVertex2d(  x,  y );
}

void OSMesaDriver::glVertex2f(Uint32 ctx, GLfloat x, GLfloat y )
{
	D(bug("nfosmesa: glVertex2f"));
	SelectContext(ctx);
	fn.glVertex2f(  x,  y );
}

void OSMesaDriver::glVertex2i(Uint32 ctx, GLint x, GLint y )
{
	D(bug("nfosmesa: glVertex2i"));
	SelectContext(ctx);
	fn.glVertex2i(  x,  y );
}

void OSMesaDriver::glVertex2s(Uint32 ctx, GLshort x, GLshort y )
{
	D(bug("nfosmesa: glVertex2s"));
	SelectContext(ctx);
	fn.glVertex2s(  x,  y );
}

void OSMesaDriver::glVertex3d(Uint32 ctx, GLdouble x, GLdouble y, GLdouble z )
{
	D(bug("nfosmesa: glVertex3d"));
	SelectContext(ctx);
	fn.glVertex3d(  x,  y,  z );
}

void OSMesaDriver::glVertex3f(Uint32 ctx, GLfloat x, GLfloat y, GLfloat z )
{
	D(bug("nfosmesa: glVertex3f(%.3f,%.3f,%.3f)",x,y,z));
	SelectContext(ctx);
	fn.glVertex3f(  x,  y,  z );
}

void OSMesaDriver::glVertex3i(Uint32 ctx, GLint x, GLint y, GLint z )
{
	D(bug("nfosmesa: glVertex3i"));
	SelectContext(ctx);
	fn.glVertex3i(  x,  y,  z );
}

void OSMesaDriver::glVertex3s(Uint32 ctx, GLshort x, GLshort y, GLshort z )
{
	D(bug("nfosmesa: glVertex3s"));
	SelectContext(ctx);
	fn.glVertex3s(  x,  y,  z );
}

void OSMesaDriver::glVertex4d(Uint32 ctx, GLdouble x, GLdouble y, GLdouble z, GLdouble w )
{
	D(bug("nfosmesa: glVertex4d"));
	SelectContext(ctx);
	fn.glVertex4d(  x,  y,  z,  w );
}

void OSMesaDriver::glVertex4f(Uint32 ctx, GLfloat x, GLfloat y, GLfloat z, GLfloat w )
{
	D(bug("nfosmesa: glVertex4f"));
	SelectContext(ctx);
	fn.glVertex4f(  x,  y,  z,  w );
}

void OSMesaDriver::glVertex4i(Uint32 ctx, GLint x, GLint y, GLint z, GLint w )
{
	D(bug("nfosmesa: glVertex4i"));
	SelectContext(ctx);
	fn.glVertex4i(  x,  y,  z,  w );
}

void OSMesaDriver::glVertex4s(Uint32 ctx, GLshort x, GLshort y, GLshort z, GLshort w )
{
	D(bug("nfosmesa: glVertex4s"));
	SelectContext(ctx);
	fn.glVertex4s(  x,  y,  z,  w );
}

void OSMesaDriver::glVertex2dv(Uint32 ctx, const GLdouble *v )
{
	GLdouble tmp[2];

	D(bug("nfosmesa: glVertex2dv"));
	SelectContext(ctx);
	Atari2HostDoublePtr(2, (Uint32 *)v, tmp);
	fn.glVertex2dv(  tmp );
}

void OSMesaDriver::glVertex2fv(Uint32 ctx, const GLfloat *v )
{
	GLfloat tmp[2];

	D(bug("nfosmesa: glVertex2fv"));
	SelectContext(ctx);
	Atari2HostFloatPtr(2, (Uint32 *)v, tmp);
	fn.glVertex2fv(  tmp);
}

void OSMesaDriver::glVertex2iv(Uint32 ctx, const GLint *v )
{
	GLint tmp[2];

	D(bug("nfosmesa: glVertex2iv"));
	SelectContext(ctx);
	Atari2HostIntPtr(2, (Uint32 *)v, tmp);
	fn.glVertex2iv( tmp );
}

void OSMesaDriver::glVertex2sv(Uint32 ctx, const GLshort *v )
{
	GLshort tmp[2];

	D(bug("nfosmesa: glVertex2sv"));
	SelectContext(ctx);
	Atari2HostShortPtr(2, (Uint16 *)v, tmp);
	fn.glVertex2sv( tmp );
}

void OSMesaDriver::glVertex3dv(Uint32 ctx, const GLdouble *v )
{
	GLdouble tmp[3];

	D(bug("nfosmesa: glVertex3dv"));
	SelectContext(ctx);
	Atari2HostDoublePtr(3, (Uint32 *)v, tmp);
	fn.glVertex3dv(tmp );
}

void OSMesaDriver::glVertex3fv(Uint32 ctx, const GLfloat *v )
{
	GLfloat tmp[3];

	D(bug("nfosmesa: glVertex3fv"));
	SelectContext(ctx);
	Atari2HostFloatPtr(3, (Uint32 *)v, tmp);
	fn.glVertex3fv(tmp);
}

void OSMesaDriver::glVertex3iv(Uint32 ctx, const GLint *v )
{
	GLint tmp[3];

	D(bug("nfosmesa: glVertex3iv"));
	SelectContext(ctx);
	Atari2HostIntPtr(3, (Uint32 *)v, tmp);
	fn.glVertex3iv(tmp);
}

void OSMesaDriver::glVertex3sv(Uint32 ctx, const GLshort *v )
{
	GLshort tmp[3];

	D(bug("nfosmesa: glVertex3sv"));
	SelectContext(ctx);
	Atari2HostShortPtr(3, (Uint16 *)v, tmp);
	fn.glVertex3sv( tmp);
}

void OSMesaDriver::glVertex4dv(Uint32 ctx, const GLdouble *v )
{
	GLdouble tmp[4];

	D(bug("nfosmesa: glVertex4dv"));
	SelectContext(ctx);
	Atari2HostDoublePtr(4, (Uint32 *)v, tmp);
	fn.glVertex4dv( tmp );
}

void OSMesaDriver::glVertex4fv(Uint32 ctx, const GLfloat *v )
{
	GLfloat tmp[4];

	D(bug("nfosmesa: glVertex4fv"));
	SelectContext(ctx);
	Atari2HostFloatPtr(4, (Uint32 *)v, tmp);
	fn.glVertex4fv(tmp );
}

void OSMesaDriver::glVertex4iv(Uint32 ctx, const GLint *v )
{
	GLint tmp[4];

	D(bug("nfosmesa: glVertex4iv"));
	SelectContext(ctx);
	Atari2HostIntPtr(4, (Uint32 *)v, tmp);
	fn.glVertex4iv( tmp );
}

void OSMesaDriver::glVertex4sv(Uint32 ctx, const GLshort *v )
{
	GLshort tmp[4];

	D(bug("nfosmesa: glVertex4sv"));
	SelectContext(ctx);
	Atari2HostShortPtr(4, (Uint16 *)v, tmp);
	fn.glVertex4sv( tmp );
}

void OSMesaDriver::glNormal3b(Uint32 ctx, GLbyte nx, GLbyte ny, GLbyte nz )
{
	D(bug("nfosmesa: glNormal3b"));
	SelectContext(ctx);
	fn.glNormal3b(  nx,  ny,  nz );
}

void OSMesaDriver::glNormal3d(Uint32 ctx, GLdouble nx, GLdouble ny, GLdouble nz )
{
	D(bug("nfosmesa: glNormal3d"));
	SelectContext(ctx);
	fn.glNormal3d(  nx,  ny,  nz );
}

void OSMesaDriver::glNormal3f(Uint32 ctx, GLfloat nx, GLfloat ny, GLfloat nz )
{
	D(bug("nfosmesa: glNormal3f"));
	SelectContext(ctx);
	fn.glNormal3f(  nx,  ny,  nz );
}

void OSMesaDriver::glNormal3i(Uint32 ctx, GLint nx, GLint ny, GLint nz )
{
	D(bug("nfosmesa: glNormal3i"));
	SelectContext(ctx);
	fn.glNormal3i(  nx,  ny,  nz );
}

void OSMesaDriver::glNormal3s(Uint32 ctx, GLshort nx, GLshort ny, GLshort nz )
{
	D(bug("nfosmesa: glNormal3s"));
	SelectContext(ctx);
	fn.glNormal3s(  nx,  ny,  nz );
}

void OSMesaDriver::glNormal3bv(Uint32 ctx, const GLbyte *v )
{
	D(bug("nfosmesa: glNormal3bv"));
	SelectContext(ctx);
	fn.glNormal3bv(  v );
}

void OSMesaDriver::glNormal3dv(Uint32 ctx, const GLdouble *v )
{
	GLdouble tmp[3];

	D(bug("nfosmesa: glNormal3dv"));
	SelectContext(ctx);
	Atari2HostDoublePtr(3, (Uint32 *)v, tmp);
	fn.glNormal3dv( tmp );
}

void OSMesaDriver::glNormal3fv(Uint32 ctx, const GLfloat *v )
{
	GLfloat tmp[3];

	D(bug("nfosmesa: glNormal3fv"));
	SelectContext(ctx);
	Atari2HostFloatPtr(3, (Uint32 *)v, tmp);
	fn.glNormal3fv( tmp);
}

void OSMesaDriver::glNormal3iv(Uint32 ctx, const GLint *v )
{
	GLint tmp[3];

	D(bug("nfosmesa: glNormal3iv"));
	SelectContext(ctx);
	Atari2HostIntPtr(3, (Uint32 *)v, tmp);
	fn.glNormal3iv(tmp );
}

void OSMesaDriver::glNormal3sv(Uint32 ctx, const GLshort *v )
{
	GLshort tmp[3];

	D(bug("nfosmesa: glNormal3sv"));
	SelectContext(ctx);
	Atari2HostShortPtr(3, (Uint16 *)v, tmp);
	fn.glNormal3sv(tmp );
}

void OSMesaDriver::glIndexd(Uint32 ctx, GLdouble c )
{
	D(bug("nfosmesa: glIndexd"));
	SelectContext(ctx);
	fn.glIndexd(  c );
}

void OSMesaDriver::glIndexf(Uint32 ctx, GLfloat c )
{
	D(bug("nfosmesa: glIndexf"));
	SelectContext(ctx);
	fn.glIndexf(  c );
}

void OSMesaDriver::glIndexi(Uint32 ctx, GLint c )
{
	D(bug("nfosmesa: glIndexi"));
	SelectContext(ctx);
	fn.glIndexi(  c );
}

void OSMesaDriver::glIndexs(Uint32 ctx, GLshort c )
{
	D(bug("nfosmesa: glIndexs"));
	SelectContext(ctx);
	fn.glIndexs(  c );
}

void OSMesaDriver::glIndexub(Uint32 ctx, GLubyte c )
{
	D(bug("nfosmesa: glIndexub"));
	SelectContext(ctx);
	fn.glIndexub(  c );
}

void OSMesaDriver::glIndexdv(Uint32 ctx, const GLdouble *c )
{
	GLdouble tmp[1];

	D(bug("nfosmesa: glIndexdv"));
	SelectContext(ctx);
	Atari2HostDoublePtr(1, (Uint32 *)c, tmp);
	fn.glIndexdv( tmp);
}

void OSMesaDriver::glIndexfv(Uint32 ctx, const GLfloat *c )
{
	GLfloat tmp[1];

	D(bug("nfosmesa: glIndexfv"));
	SelectContext(ctx);
	Atari2HostFloatPtr(1, (Uint32 *)c, tmp);
	fn.glIndexfv( tmp );
}

void OSMesaDriver::glIndexiv(Uint32 ctx, const GLint *c )
{
	GLint tmp[1];

	D(bug("nfosmesa: glIndexiv"));
	SelectContext(ctx);
	Atari2HostIntPtr(1, (Uint32 *)c, tmp);
	fn.glIndexiv( tmp );
}

void OSMesaDriver::glIndexsv(Uint32 ctx, const GLshort *c )
{
	GLshort tmp[1];

	D(bug("nfosmesa: glIndexsv"));
	SelectContext(ctx);
	Atari2HostShortPtr(1, (Uint16 *)c, tmp);
	fn.glIndexsv( tmp );
}

void OSMesaDriver::glIndexubv(Uint32 ctx, const GLubyte *c )
{
	D(bug("nfosmesa: glIndexubv"));
	SelectContext(ctx);
	fn.glIndexubv(  c );
}

void OSMesaDriver::glColor3b(Uint32 ctx, GLbyte red, GLbyte green, GLbyte blue )
{
	D(bug("nfosmesa: glColor3b"));
	SelectContext(ctx);
	fn.glColor3b(  red,  green,  blue );
}

void OSMesaDriver::glColor3d(Uint32 ctx, GLdouble red, GLdouble green, GLdouble blue )
{
	D(bug("nfosmesa: glColor3d"));
	SelectContext(ctx);
	fn.glColor3d(  red,  green,  blue );
}

void OSMesaDriver::glColor3f(Uint32 ctx, GLfloat red, GLfloat green, GLfloat blue )
{
	D(bug("nfosmesa: glColor3f(%.3f,%.3f,%.3f)",red,green,blue));
	SelectContext(ctx);
	fn.glColor3f(  red,  green,  blue );
}

void OSMesaDriver::glColor3i(Uint32 ctx, GLint red, GLint green, GLint blue )
{
	D(bug("nfosmesa: glColor3i"));
	SelectContext(ctx);
	fn.glColor3i(  red,  green,  blue );
}

void OSMesaDriver::glColor3s(Uint32 ctx, GLshort red, GLshort green, GLshort blue )
{
	D(bug("nfosmesa: glColor3s"));
	SelectContext(ctx);
	fn.glColor3s(  red,  green,  blue );
}

void OSMesaDriver::glColor3ub(Uint32 ctx, GLubyte red, GLubyte green, GLubyte blue )
{
	D(bug("nfosmesa: glColor3ub"));
	SelectContext(ctx);
	fn.glColor3ub(  red,  green,  blue );
}

void OSMesaDriver::glColor3ui(Uint32 ctx, GLuint red, GLuint green, GLuint blue )
{
	D(bug("nfosmesa: glColor3ui"));
	SelectContext(ctx);
	fn.glColor3ui(  red,  green,  blue );
}

void OSMesaDriver::glColor3us(Uint32 ctx, GLushort red, GLushort green, GLushort blue )
{
	D(bug("nfosmesa: glColor3us"));
	SelectContext(ctx);
	fn.glColor3us(  red,  green,  blue );
}

void OSMesaDriver::glColor4b(Uint32 ctx, GLbyte red, GLbyte green, GLbyte blue, GLbyte alpha )
{
	D(bug("nfosmesa: glColor4b"));
	SelectContext(ctx);
	fn.glColor4b(  red,  green,  blue,  alpha );
}

void OSMesaDriver::glColor4d(Uint32 ctx, GLdouble red, GLdouble green, GLdouble blue, GLdouble alpha )
{
	D(bug("nfosmesa: glColor4d"));
	SelectContext(ctx);
	fn.glColor4d(  red,  green,  blue,  alpha );
}

void OSMesaDriver::glColor4f(Uint32 ctx, GLfloat red, GLfloat green, GLfloat blue, GLfloat alpha )
{
	D(bug("nfosmesa: glColor4f"));
	SelectContext(ctx);
	fn.glColor4f(  red,  green,  blue,  alpha );
}

void OSMesaDriver::glColor4i(Uint32 ctx, GLint red, GLint green, GLint blue, GLint alpha )
{
	D(bug("nfosmesa: glColor4i"));
	SelectContext(ctx);
	fn.glColor4i(  red,  green,  blue,  alpha );
}

void OSMesaDriver::glColor4s(Uint32 ctx, GLshort red, GLshort green, GLshort blue, GLshort alpha )
{
	D(bug("nfosmesa: glColor4s"));
	SelectContext(ctx);
	fn.glColor4s(  red,  green,  blue,  alpha );
}

void OSMesaDriver::glColor4ub(Uint32 ctx, GLubyte red, GLubyte green, GLubyte blue, GLubyte alpha )
{
	D(bug("nfosmesa: glColor4ub"));
	SelectContext(ctx);
	fn.glColor4ub(  red,  green,  blue,  alpha );
}

void OSMesaDriver::glColor4ui(Uint32 ctx, GLuint red, GLuint green, GLuint blue, GLuint alpha )
{
	D(bug("nfosmesa: glColor4ui"));
	SelectContext(ctx);
	fn.glColor4ui(  red,  green,  blue,  alpha );
}

void OSMesaDriver::glColor4us(Uint32 ctx, GLushort red, GLushort green, GLushort blue, GLushort alpha )
{
	D(bug("nfosmesa: glColor4us"));
	SelectContext(ctx);
	fn.glColor4us(  red,  green,  blue,  alpha );
}

void OSMesaDriver::glColor3bv(Uint32 ctx, const GLbyte *v )
{
	D(bug("nfosmesa: glColor3bv"));
	SelectContext(ctx);
	fn.glColor3bv(  v );
}

void OSMesaDriver::glColor3dv(Uint32 ctx, const GLdouble *v )
{
	GLdouble tmp[3];

	D(bug("nfosmesa: glColor3dv"));
	SelectContext(ctx);
	Atari2HostDoublePtr(3, (Uint32 *)v, tmp);
	fn.glColor3dv( tmp );
}

void OSMesaDriver::glColor3fv(Uint32 ctx, const GLfloat *v )
{
	GLfloat tmp[3];

	D(bug("nfosmesa: glColor3fv"));
	SelectContext(ctx);
	Atari2HostFloatPtr(3, (Uint32 *)v, tmp);
	fn.glColor3fv( tmp );
}

void OSMesaDriver::glColor3iv(Uint32 ctx, const GLint *v )
{
	GLint tmp[3];

	D(bug("nfosmesa: glColor3iv"));
	SelectContext(ctx);
	Atari2HostIntPtr(3, (Uint32 *)v, tmp);
	fn.glColor3iv(  tmp);
}

void OSMesaDriver::glColor3sv(Uint32 ctx, const GLshort *v )
{
	GLshort tmp[3];

	D(bug("nfosmesa: glColor3sv"));
	SelectContext(ctx);
	Atari2HostShortPtr(3, (Uint16 *)v, tmp);
	fn.glColor3sv(tmp );
}

void OSMesaDriver::glColor3ubv(Uint32 ctx, const GLubyte *v )
{
	D(bug("nfosmesa: glColor3ubv"));
	SelectContext(ctx);
	fn.glColor3ubv(  v );
}

void OSMesaDriver::glColor3uiv(Uint32 ctx, const GLuint *v )
{
	GLuint tmp[3];

	D(bug("nfosmesa: glColor3uiv"));
	SelectContext(ctx);
	Atari2HostIntPtr(3, (Uint32 *)v, (GLint *)tmp);
	fn.glColor3uiv( tmp );
}

void OSMesaDriver::glColor3usv(Uint32 ctx, const GLushort *v )
{
	GLushort tmp[3];

	D(bug("nfosmesa: glColor3usv"));
	SelectContext(ctx);
	Atari2HostShortPtr(3, (Uint16 *)v, (GLshort *)tmp);
	fn.glColor3usv( tmp );
}

void OSMesaDriver::glColor4bv(Uint32 ctx, const GLbyte *v )
{
	D(bug("nfosmesa: glColor4bv"));
	SelectContext(ctx);
	fn.glColor4bv(  v );
}

void OSMesaDriver::glColor4dv(Uint32 ctx, const GLdouble *v )
{
	GLdouble tmp[4];

	D(bug("nfosmesa: glColor4dv"));
	SelectContext(ctx);
	Atari2HostDoublePtr(4, (Uint32 *)v, tmp);
	fn.glColor4dv( tmp );
}

void OSMesaDriver::glColor4fv(Uint32 ctx, const GLfloat *v )
{
	GLfloat tmp[4];

	D(bug("nfosmesa: glColor4fv"));
	SelectContext(ctx);
	Atari2HostFloatPtr(4, (Uint32 *)v, tmp);
	fn.glColor4fv(tmp);
}

void OSMesaDriver::glColor4iv(Uint32 ctx, const GLint *v )
{
	GLint tmp[4];

	D(bug("nfosmesa: glColor4iv"));
	SelectContext(ctx);
	Atari2HostIntPtr(4, (Uint32 *)v, tmp);
	fn.glColor4iv( tmp );
}

void OSMesaDriver::glColor4sv(Uint32 ctx, const GLshort *v )
{
	GLshort tmp[4];

	D(bug("nfosmesa: glColor4sv"));
	SelectContext(ctx);
	Atari2HostShortPtr(4, (Uint16 *)v, tmp);
	fn.glColor4sv( tmp );
}

void OSMesaDriver::glColor4ubv(Uint32 ctx, const GLubyte *v )
{
	D(bug("nfosmesa: glColor4ubv"));
	SelectContext(ctx);
	fn.glColor4ubv(  v );
}

void OSMesaDriver::glColor4uiv(Uint32 ctx, const GLuint *v )
{
	GLuint tmp[4];

	D(bug("nfosmesa: glColor4uiv"));
	SelectContext(ctx);
	Atari2HostIntPtr(4, (Uint32 *)v, (GLint *)tmp);
	fn.glColor4uiv( tmp );
}

void OSMesaDriver::glColor4usv(Uint32 ctx, const GLushort *v )
{
	GLushort tmp[4];

	D(bug("nfosmesa: glColor4usv"));
	SelectContext(ctx);
	Atari2HostShortPtr(4, (Uint16 *)v, (GLshort *)tmp);
	fn.glColor4usv( tmp );
}

void OSMesaDriver::glTexCoord1d(Uint32 ctx, GLdouble s )
{
	D(bug("nfosmesa: glTexCoord1d"));
	SelectContext(ctx);
	fn.glTexCoord1d(  s );
}

void OSMesaDriver::glTexCoord1f(Uint32 ctx, GLfloat s )
{
	D(bug("nfosmesa: glTexCoord1f"));
	SelectContext(ctx);
	fn.glTexCoord1f(  s );
}

void OSMesaDriver::glTexCoord1i(Uint32 ctx, GLint s )
{
	D(bug("nfosmesa: glTexCoord1i"));
	SelectContext(ctx);
	fn.glTexCoord1i(  s );
}

void OSMesaDriver::glTexCoord1s(Uint32 ctx, GLshort s )
{
	D(bug("nfosmesa: glTexCoord1s"));
	SelectContext(ctx);
	fn.glTexCoord1s(  s );
}

void OSMesaDriver::glTexCoord2d(Uint32 ctx, GLdouble s, GLdouble t )
{
	D(bug("nfosmesa: glTexCoord2d"));
	SelectContext(ctx);
	fn.glTexCoord2d(  s,  t );
}

void OSMesaDriver::glTexCoord2f(Uint32 ctx, GLfloat s, GLfloat t )
{
	D(bug("nfosmesa: glTexCoord2f"));
	SelectContext(ctx);
	fn.glTexCoord2f(  s,  t );
}

void OSMesaDriver::glTexCoord2i(Uint32 ctx, GLint s, GLint t )
{
	D(bug("nfosmesa: glTexCoord2i"));
	SelectContext(ctx);
	fn.glTexCoord2i(  s,  t );
}

void OSMesaDriver::glTexCoord2s(Uint32 ctx, GLshort s, GLshort t )
{
	D(bug("nfosmesa: glTexCoord2s"));
	SelectContext(ctx);
	fn.glTexCoord2s(  s,  t );
}

void OSMesaDriver::glTexCoord3d(Uint32 ctx, GLdouble s, GLdouble t, GLdouble r )
{
	D(bug("nfosmesa: glTexCoord3d"));
	SelectContext(ctx);
	fn.glTexCoord3d(  s,  t,  r );
}

void OSMesaDriver::glTexCoord3f(Uint32 ctx, GLfloat s, GLfloat t, GLfloat r )
{
	D(bug("nfosmesa: glTexCoord3f"));
	SelectContext(ctx);
	fn.glTexCoord3f(  s,  t,  r );
}

void OSMesaDriver::glTexCoord3i(Uint32 ctx, GLint s, GLint t, GLint r )
{
	D(bug("nfosmesa: glTexCoord3i"));
	SelectContext(ctx);
	fn.glTexCoord3i(  s,  t,  r );
}

void OSMesaDriver::glTexCoord3s(Uint32 ctx, GLshort s, GLshort t, GLshort r )
{
	D(bug("nfosmesa: glTexCoord3s"));
	SelectContext(ctx);
	fn.glTexCoord3s(  s,  t,  r );
}

void OSMesaDriver::glTexCoord4d(Uint32 ctx, GLdouble s, GLdouble t, GLdouble r, GLdouble q )
{
	D(bug("nfosmesa: glTexCoord4d"));
	SelectContext(ctx);
	fn.glTexCoord4d(  s,  t,  r,  q );
}

void OSMesaDriver::glTexCoord4f(Uint32 ctx, GLfloat s, GLfloat t, GLfloat r, GLfloat q )
{
	D(bug("nfosmesa: glTexCoord4f"));
	SelectContext(ctx);
	fn.glTexCoord4f(  s,  t,  r,  q );
}

void OSMesaDriver::glTexCoord4i(Uint32 ctx, GLint s, GLint t, GLint r, GLint q )
{
	D(bug("nfosmesa: glTexCoord4i"));
	SelectContext(ctx);
	fn.glTexCoord4i(  s,  t,  r,  q );
}

void OSMesaDriver::glTexCoord4s(Uint32 ctx, GLshort s, GLshort t, GLshort r, GLshort q )
{
	D(bug("nfosmesa: glTexCoord4s"));
	SelectContext(ctx);
	fn.glTexCoord4s(  s,  t,  r,  q );
}

void OSMesaDriver::glTexCoord1dv(Uint32 ctx, const GLdouble *v )
{
	GLdouble tmp[1];

	D(bug("nfosmesa: glTexCoord1dv"));
	SelectContext(ctx);
	Atari2HostDoublePtr(1, (Uint32 *)v, tmp);
	fn.glTexCoord1dv(tmp);
}

void OSMesaDriver::glTexCoord1fv(Uint32 ctx, const GLfloat *v )
{
	GLfloat tmp[1];

	D(bug("nfosmesa: glTexCoord1fv"));
	SelectContext(ctx);
	Atari2HostFloatPtr(1, (Uint32 *)v, tmp);
	fn.glTexCoord1fv(tmp);
}

void OSMesaDriver::glTexCoord1iv(Uint32 ctx, const GLint *v )
{
	GLint tmp[1];

	D(bug("nfosmesa: glTexCoord1iv"));
	SelectContext(ctx);
	Atari2HostIntPtr(1, (Uint32 *)v, tmp);
	fn.glTexCoord1iv( tmp );
}

void OSMesaDriver::glTexCoord1sv(Uint32 ctx, const GLshort *v )
{
	GLshort tmp[1];

	D(bug("nfosmesa: glTexCoord1sv"));
	SelectContext(ctx);
	Atari2HostShortPtr(1, (Uint16 *)v, tmp);
	fn.glTexCoord1sv( tmp );
}

void OSMesaDriver::glTexCoord2dv(Uint32 ctx, const GLdouble *v )
{
	GLdouble tmp[2];

	D(bug("nfosmesa: glTexCoord2dv"));
	SelectContext(ctx);
	Atari2HostDoublePtr(2, (Uint32 *)v, tmp);
	fn.glTexCoord2dv( tmp );
}

void OSMesaDriver::glTexCoord2fv(Uint32 ctx, const GLfloat *v )
{
	GLfloat tmp[2];

	D(bug("nfosmesa: glTexCoord2fv"));
	SelectContext(ctx);
	Atari2HostFloatPtr(2, (Uint32 *)v, tmp);
	fn.glTexCoord2fv( tmp );
}

void OSMesaDriver::glTexCoord2iv(Uint32 ctx, const GLint *v )
{
	GLint tmp[2];

	D(bug("nfosmesa: glTexCoord2iv"));
	SelectContext(ctx);
	Atari2HostIntPtr(2, (Uint32 *)v, tmp);
	fn.glTexCoord2iv( tmp );
}

void OSMesaDriver::glTexCoord2sv(Uint32 ctx, const GLshort *v )
{
	GLshort tmp[2];

	D(bug("nfosmesa: glTexCoord2sv"));
	SelectContext(ctx);
	Atari2HostShortPtr(2, (Uint16 *)v, tmp);
	fn.glTexCoord2sv( tmp );
}

void OSMesaDriver::glTexCoord3dv(Uint32 ctx, const GLdouble *v )
{
	GLdouble tmp[3];

	D(bug("nfosmesa: glTexCoord3dv"));
	SelectContext(ctx);
	Atari2HostDoublePtr(3, (Uint32 *)v, tmp);
	fn.glTexCoord3dv( tmp );
}

void OSMesaDriver::glTexCoord3fv(Uint32 ctx, const GLfloat *v )
{
	GLfloat tmp[3];

	D(bug("nfosmesa: glTexCoord3fv"));
	SelectContext(ctx);
	Atari2HostFloatPtr(3, (Uint32 *)v, tmp);
	fn.glTexCoord3fv( tmp );
}

void OSMesaDriver::glTexCoord3iv(Uint32 ctx, const GLint *v )
{
	GLint tmp[3];

	D(bug("nfosmesa: glTexCoord3iv"));
	SelectContext(ctx);
	Atari2HostIntPtr(3, (Uint32 *)v, tmp);
	fn.glTexCoord3iv(  tmp );
}

void OSMesaDriver::glTexCoord3sv(Uint32 ctx, const GLshort *v )
{
	GLshort tmp[3];

	D(bug("nfosmesa: glTexCoord3sv"));
	SelectContext(ctx);
	Atari2HostShortPtr(3, (Uint16 *)v, tmp);
	fn.glTexCoord3sv( tmp );
}

void OSMesaDriver::glTexCoord4dv(Uint32 ctx, const GLdouble *v )
{
	GLdouble tmp[4];

	D(bug("nfosmesa: glTexCoord4dv"));
	SelectContext(ctx);
	Atari2HostDoublePtr(4, (Uint32 *)v, tmp);
	fn.glTexCoord4dv( tmp );
}

void OSMesaDriver::glTexCoord4fv(Uint32 ctx, const GLfloat *v )
{
	GLfloat tmp[4];

	D(bug("nfosmesa: glTexCoord4fv"));
	SelectContext(ctx);
	Atari2HostFloatPtr(4, (Uint32 *)v, tmp);
	fn.glTexCoord4fv( tmp );
}

void OSMesaDriver::glTexCoord4iv(Uint32 ctx, const GLint *v )
{
	GLint tmp[4];

	D(bug("nfosmesa: glTexCoord4iv"));
	SelectContext(ctx);
	Atari2HostIntPtr(4, (Uint32 *)v, tmp);
	fn.glTexCoord4iv( tmp );
}

void OSMesaDriver::glTexCoord4sv(Uint32 ctx, const GLshort *v )
{
	GLshort tmp[4];

	D(bug("nfosmesa: glTexCoord4sv"));
	SelectContext(ctx);
	Atari2HostShortPtr(4, (Uint16 *)v, tmp);
	fn.glTexCoord4sv( tmp );
}

void OSMesaDriver::glRasterPos2d(Uint32 ctx, GLdouble x, GLdouble y )
{
	D(bug("nfosmesa: glRasterPos2d"));
	SelectContext(ctx);
	fn.glRasterPos2d(  x,  y );
}

void OSMesaDriver::glRasterPos2f(Uint32 ctx, GLfloat x, GLfloat y )
{
	D(bug("nfosmesa: glRasterPos2f"));
	SelectContext(ctx);
	fn.glRasterPos2f(  x,  y );
}

void OSMesaDriver::glRasterPos2i(Uint32 ctx, GLint x, GLint y )
{
	D(bug("nfosmesa: glRasterPos2i"));
	SelectContext(ctx);
	fn.glRasterPos2i(  x,  y );
}

void OSMesaDriver::glRasterPos2s(Uint32 ctx, GLshort x, GLshort y )
{
	D(bug("nfosmesa: glRasterPos2s"));
	SelectContext(ctx);
	fn.glRasterPos2s(  x,  y );
}

void OSMesaDriver::glRasterPos3d(Uint32 ctx, GLdouble x, GLdouble y, GLdouble z )
{
	D(bug("nfosmesa: glRasterPos3d"));
	SelectContext(ctx);
	fn.glRasterPos3d(  x,  y,  z );
}

void OSMesaDriver::glRasterPos3f(Uint32 ctx, GLfloat x, GLfloat y, GLfloat z )
{
	D(bug("nfosmesa: glRasterPos3f"));
	SelectContext(ctx);
	fn.glRasterPos3f(  x,  y,  z );
}

void OSMesaDriver::glRasterPos3i(Uint32 ctx, GLint x, GLint y, GLint z )
{
	D(bug("nfosmesa: glRasterPos3i"));
	SelectContext(ctx);
	fn.glRasterPos3i(  x,  y,  z );
}

void OSMesaDriver::glRasterPos3s(Uint32 ctx, GLshort x, GLshort y, GLshort z )
{
	D(bug("nfosmesa: glRasterPos3s"));
	SelectContext(ctx);
	fn.glRasterPos3s(  x,  y,  z );
}

void OSMesaDriver::glRasterPos4d(Uint32 ctx, GLdouble x, GLdouble y, GLdouble z, GLdouble w )
{
	D(bug("nfosmesa: glRasterPos4d"));
	SelectContext(ctx);
	fn.glRasterPos4d(  x,  y,  z,  w );
}

void OSMesaDriver::glRasterPos4f(Uint32 ctx, GLfloat x, GLfloat y, GLfloat z, GLfloat w )
{
	D(bug("nfosmesa: glRasterPos4f"));
	SelectContext(ctx);
	fn.glRasterPos4f(  x,  y,  z,  w );
}

void OSMesaDriver::glRasterPos4i(Uint32 ctx, GLint x, GLint y, GLint z, GLint w )
{
	D(bug("nfosmesa: glRasterPos4i"));
	SelectContext(ctx);
	fn.glRasterPos4i(  x,  y,  z,  w );
}

void OSMesaDriver::glRasterPos4s(Uint32 ctx, GLshort x, GLshort y, GLshort z, GLshort w )
{
	D(bug("nfosmesa: glRasterPos4s"));
	SelectContext(ctx);
	fn.glRasterPos4s(  x,  y,  z,  w );
}

void OSMesaDriver::glRasterPos2dv(Uint32 ctx, const GLdouble *v )
{
	GLdouble tmp[2];

	D(bug("nfosmesa: glRasterPos2dv"));
	SelectContext(ctx);
	Atari2HostDoublePtr(2, (Uint32 *)v, tmp);
	fn.glRasterPos2dv( tmp );
}

void OSMesaDriver::glRasterPos2fv(Uint32 ctx, const GLfloat *v )
{
	GLfloat tmp[2];

	D(bug("nfosmesa: glRasterPos2fv"));
	SelectContext(ctx);
	Atari2HostFloatPtr(2, (Uint32 *)v, tmp);
	fn.glRasterPos2fv( tmp );
}

void OSMesaDriver::glRasterPos2iv(Uint32 ctx, const GLint *v )
{
	GLint tmp[2];

	D(bug("nfosmesa: glRasterPos2iv"));
	SelectContext(ctx);
	Atari2HostIntPtr(2, (Uint32 *)v, tmp);
	fn.glRasterPos2iv( tmp );
}

void OSMesaDriver::glRasterPos2sv(Uint32 ctx, const GLshort *v )
{
	GLshort tmp[2];

	D(bug("nfosmesa: glRasterPos2sv"));
	SelectContext(ctx);
	Atari2HostShortPtr(2, (Uint16 *)v, tmp);
	fn.glRasterPos2sv( tmp );
}

void OSMesaDriver::glRasterPos3dv(Uint32 ctx, const GLdouble *v )
{
	GLdouble tmp[3];

	D(bug("nfosmesa: glRasterPos3dv"));
	SelectContext(ctx);
	Atari2HostDoublePtr(3, (Uint32 *)v, tmp);
	fn.glRasterPos3dv( tmp );
}

void OSMesaDriver::glRasterPos3fv(Uint32 ctx, const GLfloat *v )
{
	GLfloat tmp[3];

	D(bug("nfosmesa: glRasterPos3fv"));
	SelectContext(ctx);
	Atari2HostFloatPtr(3, (Uint32 *)v, tmp);
	fn.glRasterPos3fv(tmp);
}

void OSMesaDriver::glRasterPos3iv(Uint32 ctx, const GLint *v )
{
	GLint tmp[3];

	D(bug("nfosmesa: glRasterPos3iv"));
	SelectContext(ctx);
	Atari2HostIntPtr(3, (Uint32 *)v, tmp);
	fn.glRasterPos3iv( tmp );
}

void OSMesaDriver::glRasterPos3sv(Uint32 ctx, const GLshort *v )
{
	GLshort tmp[3];

	D(bug("nfosmesa: glRasterPos3sv"));
	SelectContext(ctx);
	Atari2HostShortPtr(3, (Uint16 *)v, tmp);
	fn.glRasterPos3sv( tmp );
}

void OSMesaDriver::glRasterPos4dv(Uint32 ctx, const GLdouble *v )
{
	GLdouble tmp[4];

	D(bug("nfosmesa: glRasterPos4dv"));
	SelectContext(ctx);
	Atari2HostDoublePtr(4, (Uint32 *)v, tmp);
	fn.glRasterPos4dv( tmp );
}

void OSMesaDriver::glRasterPos4fv(Uint32 ctx, const GLfloat *v )
{
	GLfloat tmp[4];

	D(bug("nfosmesa: glRasterPos4fv"));
	SelectContext(ctx);
	Atari2HostFloatPtr(4, (Uint32 *)v, tmp);
	fn.glRasterPos4fv( tmp );
}

void OSMesaDriver::glRasterPos4iv(Uint32 ctx, const GLint *v )
{
	GLint tmp[4];

	D(bug("nfosmesa: glRasterPos4iv"));
	SelectContext(ctx);
	Atari2HostIntPtr(4, (Uint32 *)v, tmp);
	fn.glRasterPos4iv( tmp );
}

void OSMesaDriver::glRasterPos4sv(Uint32 ctx, const GLshort *v )
{
	GLshort tmp[4];

	D(bug("nfosmesa: glRasterPos4sv"));
	SelectContext(ctx);
	Atari2HostShortPtr(4, (Uint16 *)v, tmp);
	fn.glRasterPos4sv( tmp );
}

void OSMesaDriver::glRectd(Uint32 ctx, GLdouble x1, GLdouble y1, GLdouble x2, GLdouble y2 )
{
	D(bug("nfosmesa: glRectd"));
	SelectContext(ctx);
	fn.glRectd(  x1,  y1,  x2,  y2 );
}

void OSMesaDriver::glRectf(Uint32 ctx, GLfloat x1, GLfloat y1, GLfloat x2, GLfloat y2 )
{
	D(bug("nfosmesa: glRectf"));
	SelectContext(ctx);
	fn.glRectf(  x1,  y1,  x2,  y2 );
}

void OSMesaDriver::glRecti(Uint32 ctx, GLint x1, GLint y1, GLint x2, GLint y2 )
{
	D(bug("nfosmesa: glRecti"));
	SelectContext(ctx);
	fn.glRecti(  x1,  y1,  x2,  y2 );
}

void OSMesaDriver::glRects(Uint32 ctx, GLshort x1, GLshort y1, GLshort x2, GLshort y2 )
{
	D(bug("nfosmesa: glRects"));
	SelectContext(ctx);
	fn.glRects(  x1,  y1,  x2,  y2 );
}

void OSMesaDriver::glRectdv(Uint32 ctx, const GLdouble *v1, const GLdouble *v2 )
{
	GLdouble tmp1[4],tmp2[4];

	D(bug("nfosmesa: glRectdv"));
	SelectContext(ctx);
	Atari2HostDoublePtr(4, (Uint32 *)v1, tmp1);
	Atari2HostDoublePtr(4, (Uint32 *)v2, tmp2);
	fn.glRectdv(  tmp1,  tmp2 );
}

void OSMesaDriver::glRectfv(Uint32 ctx, const GLfloat *v1, const GLfloat *v2 )
{
	GLfloat tmp1[4],tmp2[4];

	D(bug("nfosmesa: glRectfv"));
	SelectContext(ctx);
	Atari2HostFloatPtr(4, (Uint32 *)v1, tmp1);
	Atari2HostFloatPtr(4, (Uint32 *)v2, tmp2);
	fn.glRectfv( tmp1, tmp2 );
}

void OSMesaDriver::glRectiv(Uint32 ctx, const GLint *v1, const GLint *v2 )
{
	GLint tmp1[4],tmp2[4];

	D(bug("nfosmesa: glRectiv"));
	SelectContext(ctx);
	Atari2HostIntPtr(4, (Uint32 *)v1, tmp1);
	Atari2HostIntPtr(4, (Uint32 *)v2, tmp2);
	fn.glRectiv(  tmp1, tmp2 );
}

void OSMesaDriver::glRectsv(Uint32 ctx, const GLshort *v1, const GLshort *v2 )
{
	GLshort tmp1[4],tmp2[4];

	D(bug("nfosmesa: glRectsv"));
	SelectContext(ctx);
	Atari2HostShortPtr(4, (Uint16 *)v1, tmp1);
	Atari2HostShortPtr(4, (Uint16 *)v2, tmp2);
	fn.glRectsv(  tmp1,  tmp2 );
}

void OSMesaDriver::glVertexPointer(Uint32 ctx, GLint size, GLenum type, GLsizei stride, const GLvoid *ptr )
{
	D(bug("nfosmesa: glVertexPointer"));
	SelectContext(ctx);
#if SDL_BYTEORDER == SDL_LIL_ENDIAN
	contexts[ctx].vertex.size = size;
	contexts[ctx].vertex.type = type;
	contexts[ctx].vertex.stride = stride;
	contexts[ctx].vertex.ptr = (GLvoid *)ptr;
#endif
	fn.glVertexPointer(  size,  type,  stride,  ptr );
}

void OSMesaDriver::glNormalPointer(Uint32 ctx, GLenum type, GLsizei stride, const GLvoid *ptr )
{
	D(bug("nfosmesa: glNormalPointer"));
	SelectContext(ctx);
#if SDL_BYTEORDER == SDL_LIL_ENDIAN
	contexts[ctx].normal.size = 3;
	contexts[ctx].normal.type = type;
	contexts[ctx].normal.stride = stride;
	contexts[ctx].normal.ptr = (GLvoid *)ptr;
#endif
	fn.glNormalPointer(  type,  stride,  ptr );
}

void OSMesaDriver::glColorPointer(Uint32 ctx, GLint size, GLenum type, GLsizei stride, const GLvoid *ptr )
{
	D(bug("nfosmesa: glColorPointer"));
	SelectContext(ctx);
#if SDL_BYTEORDER == SDL_LIL_ENDIAN
	contexts[ctx].color.size = size;
	contexts[ctx].color.type = type;
	contexts[ctx].color.stride = stride;
	contexts[ctx].color.ptr = (GLvoid *)ptr;
#endif
	fn.glColorPointer(  size,  type,  stride,  ptr );
}

void OSMesaDriver::glIndexPointer(Uint32 ctx, GLenum type, GLsizei stride, const GLvoid *ptr )
{
	D(bug("nfosmesa: glIndexPointer"));
	SelectContext(ctx);
#if SDL_BYTEORDER == SDL_LIL_ENDIAN
	contexts[ctx].index.size = 1;
	contexts[ctx].index.type = type;
	contexts[ctx].index.stride = stride;
	contexts[ctx].index.ptr = (GLvoid *)ptr;
#endif
	fn.glIndexPointer(  type,  stride,  ptr );
}

void OSMesaDriver::glTexCoordPointer(Uint32 ctx, GLint size, GLenum type, GLsizei stride, const GLvoid *ptr )
{
	D(bug("nfosmesa: glTexCoordPointer"));
	SelectContext(ctx);
#if SDL_BYTEORDER == SDL_LIL_ENDIAN
	contexts[ctx].texcoord.size = size;
	contexts[ctx].texcoord.type = type;
	contexts[ctx].texcoord.stride = stride;
	contexts[ctx].texcoord.ptr = (GLvoid *)ptr;
#endif
	fn.glTexCoordPointer(  size,  type,  stride,  ptr );
}

void OSMesaDriver::glEdgeFlagPointer(Uint32 ctx, GLsizei stride, const GLvoid *ptr )
{
	D(bug("nfosmesa: glEdgeFlagPointer"));
	SelectContext(ctx);
#if SDL_BYTEORDER == SDL_LIL_ENDIAN
	contexts[ctx].edgeflag.size = 1;
	contexts[ctx].edgeflag.type = GL_UNSIGNED_BYTE;
	contexts[ctx].edgeflag.stride = stride;
	contexts[ctx].edgeflag.ptr = (GLvoid *)ptr;
#endif
	fn.glEdgeFlagPointer(  stride,  ptr );
}

void OSMesaDriver::glGetPointerv(Uint32 ctx, GLenum pname, GLvoid **params )
{
	D(bug("nfosmesa: glGetPointerv"));
	SelectContext(ctx);
	fn.glGetPointerv(  pname,  params );
}

void OSMesaDriver::glArrayElement(Uint32 ctx, GLint i )
{
	D(bug("nfosmesa: glArrayElement"));
	SelectContext(ctx);
#if SDL_BYTEORDER == SDL_LIL_ENDIAN
	{
		int stride;
		GLubyte *ptr;

		if (contexts[ctx].enabled_arrays & NFOSMESA_NORMAL_ARRAY) {
			stride=contexts[ctx].vertex.stride;
			ptr=(GLubyte *)contexts[ctx].vertex.ptr;
			if (stride==0) {
				stride = contexts[ctx].vertex.size;
				switch(contexts[ctx].vertex.type) {
					case GL_SHORT:
						stride *= sizeof(GLshort);
						break;
					case GL_INT:
						stride *= sizeof(GLint);
						break;
					case GL_FLOAT:
						stride *= sizeof(GLfloat);
						break;
					case GL_DOUBLE:
						stride *= sizeof(GLdouble);
						break;
				}
			}
			ptr += i*stride;
			switch(contexts[ctx].vertex.type) {
				case GL_BYTE:
					glNormal3bv(ctx, (GLbyte *)ptr);
					break;
				case GL_SHORT:
					glNormal3sv(ctx, (GLshort *)ptr);
					break;
				case GL_INT:
					glNormal3iv(ctx, (GLint *)ptr);
					break;
				case GL_FLOAT:
					glNormal3fv(ctx, (GLfloat *)ptr);
					break;
				case GL_DOUBLE:
					glNormal3dv(ctx, (GLdouble *)ptr);
					break;
			}
		}

		if (contexts[ctx].enabled_arrays & NFOSMESA_INDEX_ARRAY) {
			stride=contexts[ctx].vertex.stride;
			ptr=(GLubyte *)contexts[ctx].vertex.ptr;
			if (stride==0) {
				stride = contexts[ctx].vertex.size;
				switch(contexts[ctx].vertex.type) {
					case GL_SHORT:
						stride *= sizeof(GLshort);
						break;
					case GL_INT:
						stride *= sizeof(GLint);
						break;
					case GL_FLOAT:
						stride *= sizeof(GLfloat);
						break;
					case GL_DOUBLE:
						stride *= sizeof(GLdouble);
						break;
				}
			}
			ptr += i*stride;
			switch(contexts[ctx].vertex.type) {
				case GL_UNSIGNED_BYTE:
					glIndexubv(ctx, (GLubyte *)ptr);
					break;
				case GL_SHORT:
					glIndexsv(ctx, (GLshort *)ptr);
					break;
				case GL_INT:
					glIndexiv(ctx, (GLint *)ptr);
					break;
				case GL_FLOAT:
					glIndexfv(ctx, (GLfloat *)ptr);
					break;
				case GL_DOUBLE:
					glIndexdv(ctx, (GLdouble *)ptr);
					break;
			}
		}

		if (contexts[ctx].enabled_arrays & NFOSMESA_COLOR_ARRAY) {
			stride=contexts[ctx].vertex.stride;
			ptr=(GLubyte *)contexts[ctx].vertex.ptr;
			if (stride==0) {
				stride = contexts[ctx].vertex.size;
				switch(contexts[ctx].vertex.type) {
					case GL_SHORT:
					case GL_UNSIGNED_SHORT:
						stride *= sizeof(GLshort);
						break;
					case GL_INT:
					case GL_UNSIGNED_INT:
						stride *= sizeof(GLint);
						break;
					case GL_FLOAT:
						stride *= sizeof(GLfloat);
						break;
					case GL_DOUBLE:
						stride *= sizeof(GLdouble);
						break;
				}
			}
			ptr += i*stride;
			switch(contexts[ctx].vertex.type) {
				case GL_BYTE:
					switch(contexts[ctx].vertex.size) {
						case 3:
							glColor3bv(ctx, (GLbyte *)ptr);
							break;
						case 4:
							glColor4bv(ctx, (GLbyte *)ptr);
							break;
					}
					break;
				case GL_UNSIGNED_BYTE:
					switch(contexts[ctx].vertex.size) {
						case 3:
							glColor3ubv(ctx, (GLubyte *)ptr);
							break;
						case 4:
							glColor4ubv(ctx, (GLubyte *)ptr);
							break;
					}
					break;
				case GL_SHORT:
					switch(contexts[ctx].vertex.size) {
						case 3:
							glColor3sv(ctx, (GLshort *)ptr);
							break;
						case 4:
							glColor4sv(ctx, (GLshort *)ptr);
							break;
					}
					break;
				case GL_UNSIGNED_SHORT:
					switch(contexts[ctx].vertex.size) {
						case 3:
							glColor3usv(ctx, (GLushort *)ptr);
							break;
						case 4:
							glColor4usv(ctx, (GLushort *)ptr);
							break;
					}
					break;
				case GL_INT:
					switch(contexts[ctx].vertex.size) {
						case 3:
							glColor3iv(ctx, (GLint *)ptr);
							break;
						case 4:
							glColor4iv(ctx, (GLint *)ptr);
							break;
					}
					break;
				case GL_UNSIGNED_INT:
					switch(contexts[ctx].vertex.size) {
						case 3:
							glColor3uiv(ctx, (GLuint *)ptr);
							break;
						case 4:
							glColor4uiv(ctx, (GLuint *)ptr);
							break;
					}
					break;
				case GL_FLOAT:
					switch(contexts[ctx].vertex.size) {
						case 3:
							glColor3fv(ctx, (GLfloat *)ptr);
							break;
						case 4:
							glColor4fv(ctx, (GLfloat *)ptr);
							break;
					}
					break;
				case GL_DOUBLE:
					switch(contexts[ctx].vertex.size) {
						case 3:
							glColor3dv(ctx, (GLdouble *)ptr);
							break;
						case 4:
							glColor4dv(ctx, (GLdouble *)ptr);
							break;
					}
					break;
			}
		}

		if (contexts[ctx].enabled_arrays & NFOSMESA_EDGEFLAG_ARRAY) {
			stride=contexts[ctx].vertex.stride;
			ptr=(GLubyte *)contexts[ctx].vertex.ptr;
			if (stride==0) {
				stride = contexts[ctx].vertex.size;
			}
			ptr += i*stride;
			glEdgeFlagv(ctx, (GLboolean *)ptr);
		}

		if (contexts[ctx].enabled_arrays & NFOSMESA_TEXCOORD_ARRAY) {
			stride=contexts[ctx].vertex.stride;
			ptr=(GLubyte *)contexts[ctx].vertex.ptr;
			if (stride==0) {
				stride = contexts[ctx].vertex.size;
				switch(contexts[ctx].vertex.type) {
					case GL_SHORT:
						stride *= sizeof(GLshort);
						break;
					case GL_INT:
						stride *= sizeof(GLint);
						break;
					case GL_FLOAT:
						stride *= sizeof(GLfloat);
						break;
					case GL_DOUBLE:
						stride *= sizeof(GLdouble);
						break;
				}
			}
			ptr += i*stride;
			switch(contexts[ctx].vertex.type) {
				case GL_SHORT:
					switch(contexts[ctx].vertex.size) {
						case 1:
							glTexCoord1sv(ctx, (GLshort *)ptr);
							break;
						case 2:
							glTexCoord2sv(ctx, (GLshort *)ptr);
							break;
						case 3:
							glTexCoord3sv(ctx, (GLshort *)ptr);
							break;
						case 4:
							glTexCoord4sv(ctx, (GLshort *)ptr);
							break;
					}
					break;
				case GL_INT:
					switch(contexts[ctx].vertex.size) {
						case 1:
							glTexCoord1iv(ctx, (GLint *)ptr);
							break;
						case 2:
							glTexCoord2iv(ctx, (GLint *)ptr);
							break;
						case 3:
							glTexCoord3iv(ctx, (GLint *)ptr);
							break;
						case 4:
							glTexCoord4iv(ctx, (GLint *)ptr);
							break;
					}
					break;
				case GL_FLOAT:
					switch(contexts[ctx].vertex.size) {
						case 1:
							glTexCoord1fv(ctx, (GLfloat *)ptr);
							break;
						case 2:
							glTexCoord2fv(ctx, (GLfloat *)ptr);
							break;
						case 3:
							glTexCoord3fv(ctx, (GLfloat *)ptr);
							break;
						case 4:
							glTexCoord4fv(ctx, (GLfloat *)ptr);
							break;
					}
					break;
				case GL_DOUBLE:
					switch(contexts[ctx].vertex.size) {
						case 1:
							glTexCoord1dv(ctx, (GLdouble *)ptr);
							break;
						case 2:
							glTexCoord2dv(ctx, (GLdouble *)ptr);
							break;
						case 3:
							glTexCoord3dv(ctx, (GLdouble *)ptr);
							break;
						case 4:
							glTexCoord4dv(ctx, (GLdouble *)ptr);
							break;
					}
					break;
			}
		}

		if (contexts[ctx].enabled_arrays & NFOSMESA_VERTEX_ARRAY) {
			stride=contexts[ctx].vertex.stride;
			ptr=(GLubyte *)contexts[ctx].vertex.ptr;
			if (stride==0) {
				stride = contexts[ctx].vertex.size;
				switch(contexts[ctx].vertex.type) {
					case GL_SHORT:
						stride *= sizeof(GLshort);
						break;
					case GL_INT:
						stride *= sizeof(GLint);
						break;
					case GL_FLOAT:
						stride *= sizeof(GLfloat);
						break;
					case GL_DOUBLE:
						stride *= sizeof(GLdouble);
						break;
				}
			}
			ptr += i*stride;
			switch(contexts[ctx].vertex.type) {
				case GL_SHORT:
					switch(contexts[ctx].vertex.size) {
						case 2:
							glVertex2sv(ctx, (GLshort *)ptr);
							break;
						case 3:
							glVertex3sv(ctx, (GLshort *)ptr);
							break;
						case 4:
							glVertex4sv(ctx, (GLshort *)ptr);
							break;
					}
					break;
				case GL_INT:
					switch(contexts[ctx].vertex.size) {
						case 2:
							glVertex2iv(ctx, (GLint *)ptr);
							break;
						case 3:
							glVertex3iv(ctx, (GLint *)ptr);
							break;
						case 4:
							glVertex4iv(ctx, (GLint *)ptr);
							break;
					}
					break;
				case GL_FLOAT:
					switch(contexts[ctx].vertex.size) {
						case 2:
							glVertex2fv(ctx, (GLfloat *)ptr);
							break;
						case 3:
							glVertex3fv(ctx, (GLfloat *)ptr);
							break;
						case 4:
							glVertex4fv(ctx, (GLfloat *)ptr);
							break;
					}
					break;
				case GL_DOUBLE:
					switch(contexts[ctx].vertex.size) {
						case 2:
							glVertex2dv(ctx, (GLdouble *)ptr);
							break;
						case 3:
							glVertex3dv(ctx, (GLdouble *)ptr);
							break;
						case 4:
							glVertex4dv(ctx, (GLdouble *)ptr);
							break;
					}
					break;
			}
		}
	}
#else
	fn.glArrayElement(  i );
#endif
}

void OSMesaDriver::glDrawArrays(Uint32 ctx, GLenum mode, GLint first, GLsizei count )
{
	D(bug("nfosmesa: glDrawArrays"));
	SelectContext(ctx);
#if SDL_BYTEORDER == SDL_LIL_ENDIAN
	{
		int i;

		fn.glBegin(	mode);
		for (i=0;i<count;i++) {
			glArrayElement(ctx,first+i);
		}
		fn.glEnd();
	}
#else
	fn.glDrawArrays(  mode,  first,  count );
#endif
}

void OSMesaDriver::glDrawElements(Uint32 ctx, GLenum mode, GLsizei count, GLenum type, const GLvoid *indices )
{
	D(bug("nfosmesa: glDrawElements"));
	SelectContext(ctx);
#if SDL_BYTEORDER == SDL_LIL_ENDIAN
	{
		int i;
		Uint32 *ptr32;
		Uint16 *ptr16;
		Uint8 *ptr8;

		ptr32 = (Uint32 *)indices;
		ptr16 = (Uint16 *)indices;
		ptr8 = (Uint8 *)indices;
		fn.glBegin(	mode);
		for (i=0;i<count;i++) {
			switch(type) {
				case GL_UNSIGNED_BYTE:
					glArrayElement(ctx,ptr8[i]);
					break;
				case GL_UNSIGNED_SHORT:
					glArrayElement(ctx,SDL_SwapBE16(ptr16[i]));
					break;
				case GL_UNSIGNED_INT:
					glArrayElement(ctx,SDL_SwapBE32(ptr32[i]));
					break;
			}
		}
		fn.glEnd();
	}
#else
	fn.glDrawElements(  mode,  count,  type,  indices );
#endif
}

void OSMesaDriver::glInterleavedArrays(Uint32 ctx, GLenum format, GLsizei stride, const GLvoid *pointer )
{
	D(bug("nfosmesa: glInterleavedArrays"));
#if SDL_BYTEORDER == SDL_LIL_ENDIAN
	{
		SDL_bool enable_texcoord, enable_normal, enable_color;
		int texcoord_size, color_size, vertex_size;
		int texcoord_stride, color_stride, vertex_stride, normal_stride;
		GLubyte *texcoord_ptr,*normal_ptr,*color_ptr,*vertex_ptr;
		GLenum color_type;

		enable_texcoord=SDL_FALSE;
		enable_normal=SDL_FALSE;
		enable_color=SDL_FALSE;
		texcoord_size=color_size=vertex_size=0;
		texcoord_stride=color_stride=vertex_stride=normal_stride=stride;
		texcoord_ptr=normal_ptr=color_ptr=vertex_ptr=(GLubyte *)pointer;
		color_type = GL_FLOAT;
		switch(format) {
			case GL_V2F:
				vertex_size=2;
				break;
			case GL_V3F:
				vertex_size=3;
				break;
			case GL_C4UB_V2F:
				vertex_size=2;
				color_size=4;
				enable_color=SDL_TRUE;
				vertex_ptr += color_size*sizeof(GLubyte);
				color_type = GL_UNSIGNED_BYTE;
				if (stride==0) {
					color_stride = vertex_stride =
						(color_size*sizeof(GLubyte))+(vertex_size*sizeof(GLfloat));
				}
				break;
			case GL_C4UB_V3F:
				vertex_size=3;
				color_size=4;
				enable_color=SDL_TRUE;
				vertex_ptr += color_size*sizeof(GLubyte);
				color_type = GL_UNSIGNED_BYTE;
				if (stride==0) {
					color_stride = vertex_stride =
						(color_size*sizeof(GLubyte))+(vertex_size*sizeof(GLfloat));
				}
				break;
			case GL_C3F_V3F:
				vertex_size=3;
				color_size=3;
				enable_color=SDL_TRUE;
				vertex_ptr += color_size*sizeof(GLfloat);
				if (stride==0) {
					color_stride = vertex_stride =
						(color_size+vertex_size)*sizeof(GLfloat);
				}
				break;
			case GL_N3F_V3F:
				vertex_size=3;
				enable_normal=SDL_TRUE;
				vertex_ptr += 3*sizeof(GLfloat);
				if (stride==0) {
					normal_stride = vertex_stride =
						(vertex_size+3)*sizeof(GLfloat);
				}
				break;
			case GL_C4F_N3F_V3F:
				vertex_size=3;
				color_size=4;
				enable_color=SDL_TRUE;
				enable_normal=SDL_TRUE;
				vertex_ptr += (color_size+3)*sizeof(GLfloat);
				normal_ptr += color_size*sizeof(GLfloat);
				if (stride==0) {
					normal_stride = vertex_stride = color_stride =
						(color_size+vertex_size+3)*sizeof(GLfloat);
				}
				break;
			case GL_T2F_V3F:
				vertex_size=3;
				texcoord_size=2;
				enable_texcoord=SDL_TRUE;
				vertex_ptr += texcoord_size*sizeof(GLfloat);
				if (stride==0) {
					texcoord_stride = vertex_stride =
						(texcoord_size+vertex_size)*sizeof(GLfloat);
				}
				break;
			case GL_T4F_V4F:
				vertex_size=4;
				texcoord_size=4;
				enable_texcoord=SDL_TRUE;
				vertex_ptr += texcoord_size*sizeof(GLfloat);
				if (stride==0) {
					texcoord_stride = vertex_stride =
						(texcoord_size+vertex_size)*sizeof(GLfloat);
				}
				break;
			case GL_T2F_C4UB_V3F:
				vertex_size=3;
				texcoord_size=2;
				color_size=4;
				enable_texcoord=SDL_TRUE;
				enable_color=SDL_TRUE;
				vertex_ptr += texcoord_size*sizeof(GLfloat);
				vertex_ptr += color_size*sizeof(GLubyte);
				color_ptr += texcoord_size*sizeof(GLfloat);
				color_type = GL_UNSIGNED_BYTE;
				if (stride==0) {
					texcoord_stride = vertex_stride = color_stride =
						((texcoord_size+vertex_size)*sizeof(GLfloat))+(color_size*sizeof(GLubyte));
				}
				break;
			case GL_T2F_C3F_V3F:
				vertex_size=3;
				texcoord_size=2;
				color_size=3;
				enable_texcoord=SDL_TRUE;
				enable_color=SDL_TRUE;
				vertex_ptr += (texcoord_size+color_size)*sizeof(GLfloat);
				color_ptr += texcoord_size*sizeof(GLfloat);
				if (stride==0) {
					texcoord_stride = vertex_stride = color_stride =
						(texcoord_size+vertex_size+color_size)*sizeof(GLfloat);
				}
				break;
			case GL_T2F_N3F_V3F:
				vertex_size=3;
				texcoord_size=2;
				enable_normal=SDL_TRUE;
				enable_texcoord=SDL_TRUE;
				vertex_ptr += (texcoord_size+3)*sizeof(GLfloat);
				normal_ptr += texcoord_size*sizeof(GLfloat);
				if (stride==0) {
					texcoord_stride = vertex_stride = normal_stride =
						(texcoord_size+vertex_size+3)*sizeof(GLfloat);
				}
				break;
			case GL_T2F_C4F_N3F_V3F:
				vertex_size=3;
				texcoord_size=2;
				color_size=4;
				enable_normal=SDL_TRUE;
				enable_texcoord=SDL_TRUE;
				enable_color=SDL_TRUE;
				vertex_ptr += (texcoord_size+color_size+3)*sizeof(GLfloat);
				normal_ptr += (texcoord_size+color_size)*sizeof(GLfloat);
				color_ptr += texcoord_size*sizeof(GLfloat);
				if (stride==0) {
					texcoord_stride = vertex_stride = color_stride = normal_stride =
						(texcoord_size+vertex_size+color_size+3)*sizeof(GLfloat);
				}
				break;
			case GL_T4F_C4F_N3F_V4F:
				vertex_size=4;
				texcoord_size=4;
				color_size=4;
				enable_normal=SDL_TRUE;
				enable_texcoord=SDL_TRUE;
				enable_color=SDL_TRUE;
				vertex_ptr += (texcoord_size+color_size+3)*sizeof(GLfloat);
				normal_ptr += (texcoord_size+color_size)*sizeof(GLfloat);
				color_ptr += texcoord_size*sizeof(GLfloat);
				if (stride==0) {
					texcoord_stride = vertex_stride = color_stride = normal_stride =
						(texcoord_size+vertex_size+color_size+3)*sizeof(GLfloat);
				}
				break;
		}

		glDisableClientState(ctx, GL_EDGE_FLAG_ARRAY);
		glDisableClientState(ctx, GL_INDEX_ARRAY);

		if (enable_normal) {
			glEnableClientState(ctx, GL_NORMAL_ARRAY);
			glNormalPointer(ctx, GL_FLOAT, normal_stride, (GLfloat *)normal_ptr);
		} else {
			glDisableClientState(ctx, GL_NORMAL_ARRAY);
		}

		if (enable_color) {
			glEnableClientState(ctx, GL_COLOR_ARRAY);
			if (color_type == GL_FLOAT) {
				glColorPointer(ctx, color_size, GL_FLOAT, color_stride, (GLfloat *)color_ptr);
			} else {
				glColorPointer(ctx, color_size, GL_UNSIGNED_BYTE, color_stride, (GLubyte *)color_ptr);
			}
		} else {
			glDisableClientState(ctx, GL_COLOR_ARRAY);
		}

		if (enable_texcoord) {
			glEnableClientState(ctx, GL_TEXTURE_COORD_ARRAY);
			glTexCoordPointer(ctx, texcoord_size, GL_FLOAT, texcoord_stride, (GLfloat *)texcoord_ptr);
		} else {
			glDisableClientState(ctx, GL_TEXTURE_COORD_ARRAY);
		}

		glEnableClientState(ctx, GL_VERTEX_ARRAY);
		glVertexPointer(ctx, vertex_size, GL_FLOAT, vertex_stride, (GLfloat *)vertex_ptr);
	}
#else
	SelectContext(ctx);
	fn.glInterleavedArrays(  format,  stride,  pointer );
#endif
}

void OSMesaDriver::glShadeModel(Uint32 ctx, GLenum mode )
{
	D(bug("nfosmesa: glShadeModel"));
	SelectContext(ctx);
	fn.glShadeModel(  mode );
}

void OSMesaDriver::glLightf(Uint32 ctx, GLenum light, GLenum pname, GLfloat param )
{
	D(bug("nfosmesa: glLightf"));
	SelectContext(ctx);
	fn.glLightf(  light,  pname,  param );
}

void OSMesaDriver::glLighti(Uint32 ctx, GLenum light, GLenum pname, GLint param )
{
	D(bug("nfosmesa: glLighti"));
	SelectContext(ctx);
	fn.glLighti(  light,  pname,  param );
}

void OSMesaDriver::glLightfv(Uint32 ctx, GLenum light, GLenum pname, const GLfloat *params )
{
	GLfloat tmp[4];

	D(bug("nfosmesa: glLightfv"));
	SelectContext(ctx);
	Atari2HostFloatPtr(4, (Uint32 *)params,tmp);
	fn.glLightfv(  light,  pname,  tmp );
}

void OSMesaDriver::glLightiv(Uint32 ctx, GLenum light, GLenum pname, const GLint *params )
{
	GLint tmp[4];

	D(bug("nfosmesa: glLightiv"));
	SelectContext(ctx);
	Atari2HostIntPtr(4, (Uint32 *)params, tmp);
	fn.glLightiv(  light,  pname,  tmp );
}

void OSMesaDriver::glGetLightfv(Uint32 ctx, GLenum light, GLenum pname, GLfloat *params )
{
	D(bug("nfosmesa: glGetLightfv"));
	SelectContext(ctx);
	fn.glGetLightfv(  light,  pname,  params );
}

void OSMesaDriver::glGetLightiv(Uint32 ctx, GLenum light, GLenum pname, GLint *params )
{
	D(bug("nfosmesa: glGetLightiv"));
	SelectContext(ctx);
	fn.glGetLightiv(  light,  pname,  params );
}

void OSMesaDriver::glLightModelf(Uint32 ctx, GLenum pname, GLfloat param )
{
	D(bug("nfosmesa: glLightModelf"));
	SelectContext(ctx);
	fn.glLightModelf(  pname,  param );
}

void OSMesaDriver::glLightModeli(Uint32 ctx, GLenum pname, GLint param )
{
	D(bug("nfosmesa: glLightModeli"));
	SelectContext(ctx);
	fn.glLightModeli(  pname,  param );
}

void OSMesaDriver::glLightModelfv(Uint32 ctx, GLenum pname, const GLfloat *params )
{
	GLfloat tmp[4];
	int size;

	D(bug("nfosmesa: glLightModelfv"));
	SelectContext(ctx);
	switch(pname) {
		case GL_LIGHT_MODEL_AMBIENT:
			size=4;
			break;
		default:
			size=1;
			break;
	}
	Atari2HostFloatPtr(size, (Uint32 *)params,tmp);
	fn.glLightModelfv(  pname, tmp );
}

void OSMesaDriver::glLightModeliv(Uint32 ctx, GLenum pname, const GLint *params )
{
	GLint tmp[4];
	int size;

	D(bug("nfosmesa: glLightModeliv"));
	SelectContext(ctx);
	switch(pname) {
		case GL_LIGHT_MODEL_AMBIENT:
			size=4;
			break;
		default:
			size=1;
			break;
	}
	Atari2HostIntPtr(size, (Uint32 *)params, tmp);
	fn.glLightModeliv(  pname,  tmp );
}

void OSMesaDriver::glMaterialf(Uint32 ctx, GLenum face, GLenum pname, GLfloat param )
{
	D(bug("nfosmesa: glMaterialf"));
	SelectContext(ctx);
	fn.glMaterialf(  face,  pname,  param );
}

void OSMesaDriver::glMateriali(Uint32 ctx, GLenum face, GLenum pname, GLint param )
{
	D(bug("nfosmesa: glMateriali"));
	SelectContext(ctx);
	fn.glMateriali(  face,  pname,  param );
}

void OSMesaDriver::glMaterialfv(Uint32 ctx, GLenum face, GLenum pname, const GLfloat *params )
{
	GLfloat tmp[4];
	int size;

	D(bug("nfosmesa: glMaterialfv"));
	SelectContext(ctx);
	switch(pname) {
		case GL_SHININESS:
			size=1;
			break;
		case GL_COLOR_INDEXES:
			size=3;
			break;
		default:
			size=4;
			break;
	}
	Atari2HostFloatPtr(size, (Uint32 *)params,tmp);
	fn.glMaterialfv(  face,  pname,  tmp );
}

void OSMesaDriver::glMaterialiv(Uint32 ctx, GLenum face, GLenum pname, const GLint *params )
{
	GLint tmp[4];
	int size;

	D(bug("nfosmesa: glMaterialiv"));
	SelectContext(ctx);
	switch(pname) {
		case GL_SHININESS:
			size=1;
			break;
		case GL_COLOR_INDEXES:
			size=3;
			break;
		default:
			size=4;
			break;
	}
	Atari2HostIntPtr(size, (Uint32 *)params,tmp);
	fn.glMaterialiv(  face,  pname,  tmp );
}

void OSMesaDriver::glGetMaterialfv(Uint32 ctx, GLenum face, GLenum pname, GLfloat *params )
{
	D(bug("nfosmesa: glGetMaterialfv"));
	SelectContext(ctx);
	fn.glGetMaterialfv(  face,  pname,  params );
}

void OSMesaDriver::glGetMaterialiv(Uint32 ctx, GLenum face, GLenum pname, GLint *params )
{
	D(bug("nfosmesa: glGetMaterialiv"));
	SelectContext(ctx);
	fn.glGetMaterialiv(  face,  pname,  params );
}

void OSMesaDriver::glColorMaterial(Uint32 ctx, GLenum face, GLenum mode )
{
	D(bug("nfosmesa: glColorMaterial"));
	SelectContext(ctx);
	fn.glColorMaterial(  face,  mode );
}

void OSMesaDriver::glPixelZoom(Uint32 ctx, GLfloat xfactor, GLfloat yfactor )
{
	D(bug("nfosmesa: glPixelZoom"));
	SelectContext(ctx);
	fn.glPixelZoom(  xfactor,  yfactor );
}

void OSMesaDriver::glPixelStoref(Uint32 ctx, GLenum pname, GLfloat param )
{
	D(bug("nfosmesa: glPixelStoref"));
	SelectContext(ctx);
	fn.glPixelStoref(  pname,  param );
}

void OSMesaDriver::glPixelStorei(Uint32 ctx, GLenum pname, GLint param )
{
	D(bug("nfosmesa: glPixelStorei"));
	SelectContext(ctx);
	fn.glPixelStorei(  pname,  param );
}

void OSMesaDriver::glPixelTransferf(Uint32 ctx, GLenum pname, GLfloat param )
{
	D(bug("nfosmesa: glPixelTransferf"));
	SelectContext(ctx);
	fn.glPixelTransferf(  pname,  param );
}

void OSMesaDriver::glPixelTransferi(Uint32 ctx, GLenum pname, GLint param )
{
	D(bug("nfosmesa: glPixelTransferi"));
	SelectContext(ctx);
	fn.glPixelTransferi(  pname,  param );
}

void OSMesaDriver::glPixelMapfv(Uint32 ctx, GLenum map, GLsizei mapsize, const GLfloat *values )
{
	GLfloat *tmp;

	D(bug("nfosmesa: glPixelMapfv"));
	tmp=(GLfloat *)malloc(mapsize*sizeof(GLfloat));
	if (tmp) {
		SelectContext(ctx);
		Atari2HostFloatPtr(mapsize, (Uint32 *)values, tmp);
		fn.glPixelMapfv(  map,  mapsize,  tmp );
		free(tmp);
	}
}

void OSMesaDriver::glPixelMapuiv(Uint32 ctx, GLenum map, GLsizei mapsize, const GLuint *values )
{
	GLuint *tmp;

	D(bug("nfosmesa: glPixelMapuiv"));
	SelectContext(ctx);
	tmp=(GLuint *)malloc(mapsize*sizeof(GLuint));
	if (tmp) {
		SelectContext(ctx);
		Atari2HostIntPtr(mapsize, (Uint32 *)values, (GLint *)tmp);
		fn.glPixelMapuiv(  map,  mapsize,  tmp );
		free(tmp);
	}
}

void OSMesaDriver::glPixelMapusv(Uint32 ctx, GLenum map, GLsizei mapsize, const GLushort *values )
{
	GLushort *tmp;

	D(bug("nfosmesa: glPixelMapusv"));
	SelectContext(ctx);
	tmp=(GLushort *)malloc(mapsize*sizeof(GLushort));
	if (tmp) {
		SelectContext(ctx);
		Atari2HostShortPtr(mapsize, (Uint16 *)values, (GLshort *)tmp);
		fn.glPixelMapusv(  map,  mapsize,  tmp );
		free(tmp);
	}
}

void OSMesaDriver::glGetPixelMapfv(Uint32 ctx, GLenum map, GLfloat *values )
{
	D(bug("nfosmesa: glGetPixelMapfv"));
	SelectContext(ctx);
	fn.glGetPixelMapfv(  map,  values );
}

void OSMesaDriver::glGetPixelMapuiv(Uint32 ctx, GLenum map, GLuint *values )
{
	D(bug("nfosmesa: glGetPixelMapuiv"));
	SelectContext(ctx);
	fn.glGetPixelMapuiv(  map,  values );
}

void OSMesaDriver::glGetPixelMapusv(Uint32 ctx, GLenum map, GLushort *values )
{
	D(bug("nfosmesa: glGetPixelMapusv"));
	SelectContext(ctx);
	fn.glGetPixelMapusv(  map,  values );
}

void OSMesaDriver::glBitmap(Uint32 ctx, GLsizei width, GLsizei height, GLfloat xorig, GLfloat yorig, GLfloat xmove, GLfloat ymove, const GLubyte *bitmap )
{
	D(bug("nfosmesa: glBitmap"));
	SelectContext(ctx);
	fn.glBitmap(  width,  height,  xorig,  yorig,  xmove,  ymove,  bitmap );
}

void OSMesaDriver::glReadPixels(Uint32 ctx, GLint x, GLint y, GLsizei width, GLsizei height, GLenum format, GLenum type, GLvoid *pixels )
{
	D(bug("nfosmesa: glReadPixels"));
	SelectContext(ctx);
	fn.glReadPixels(  x,  y,  width,  height,  format,  type,  pixels );
}

void OSMesaDriver::glDrawPixels(Uint32 ctx, GLsizei width, GLsizei height, GLenum format, GLenum type, const GLvoid *pixels )
{
	D(bug("nfosmesa: glDrawPixels"));
	SelectContext(ctx);
	fn.glDrawPixels(  width,  height,  format,  type,  pixels );
}

void OSMesaDriver::glCopyPixels(Uint32 ctx, GLint x, GLint y, GLsizei width, GLsizei height, GLenum type )
{
	D(bug("nfosmesa: glCopyPixels"));
	SelectContext(ctx);
	fn.glCopyPixels(  x,  y,  width,  height,  type );
}

void OSMesaDriver::glStencilFunc(Uint32 ctx, GLenum func, GLint ref, GLuint mask )
{
	D(bug("nfosmesa: glStencilFunc"));
	SelectContext(ctx);
	fn.glStencilFunc(  func,  ref,  mask );
}

void OSMesaDriver::glStencilMask(Uint32 ctx, GLuint mask )
{
	D(bug("nfosmesa: glStencilMask"));
	SelectContext(ctx);
	fn.glStencilMask(  mask );
}

void OSMesaDriver::glStencilOp(Uint32 ctx, GLenum fail, GLenum zfail, GLenum zpass )
{
	D(bug("nfosmesa: glStencilOp"));
	SelectContext(ctx);
	fn.glStencilOp(  fail,  zfail,  zpass );
}

void OSMesaDriver::glClearStencil(Uint32 ctx, GLint s )
{
	D(bug("nfosmesa: glClearStencil"));
	SelectContext(ctx);
	fn.glClearStencil(  s );
}

void OSMesaDriver::glTexGend(Uint32 ctx, GLenum coord, GLenum pname, GLdouble param )
{
	D(bug("nfosmesa: glTexGend"));
	SelectContext(ctx);
	fn.glTexGend(  coord,  pname,  param );
}

void OSMesaDriver::glTexGenf(Uint32 ctx, GLenum coord, GLenum pname, GLfloat param )
{
	D(bug("nfosmesa: glTexGenf"));
	SelectContext(ctx);
	fn.glTexGenf(  coord,  pname,  param );
}

void OSMesaDriver::glTexGeni(Uint32 ctx, GLenum coord, GLenum pname, GLint param )
{
	D(bug("nfosmesa: glTexGeni"));
	SelectContext(ctx);
	fn.glTexGeni(  coord,  pname,  param );
}

void OSMesaDriver::glTexGendv(Uint32 ctx, GLenum coord, GLenum pname, const GLdouble *params )
{
	GLdouble tmp[4];

	D(bug("nfosmesa: glTexGendv"));
	SelectContext(ctx);
	Atari2HostDoublePtr(4, (Uint32 *)params, tmp);
	fn.glTexGendv(  coord,  pname,  tmp);
}

void OSMesaDriver::glTexGenfv(Uint32 ctx, GLenum coord, GLenum pname, const GLfloat *params )
{
	GLfloat tmp[4];
	
	D(bug("nfosmesa: glTexGenfv"));
	SelectContext(ctx);
	Atari2HostFloatPtr(4, (Uint32 *)params, tmp);
	fn.glTexGenfv(  coord,  pname,  tmp );
}

void OSMesaDriver::glTexGeniv(Uint32 ctx, GLenum coord, GLenum pname, const GLint *params )
{
	GLint tmp[4];

	D(bug("nfosmesa: glTexGeniv"));
	SelectContext(ctx);
	Atari2HostIntPtr(4, (Uint32 *)params, tmp);
	fn.glTexGeniv(  coord,  pname,  tmp );
}

void OSMesaDriver::glGetTexGendv(Uint32 ctx, GLenum coord, GLenum pname, GLdouble *params )
{
	D(bug("nfosmesa: glGetTexGendv"));
	SelectContext(ctx);
	fn.glGetTexGendv(  coord,  pname,  params );
}

void OSMesaDriver::glGetTexGenfv(Uint32 ctx, GLenum coord, GLenum pname, GLfloat *params )
{
	D(bug("nfosmesa: glGetTexGenfv"));
	SelectContext(ctx);
	fn.glGetTexGenfv(  coord,  pname,  params );
}

void OSMesaDriver::glGetTexGeniv(Uint32 ctx, GLenum coord, GLenum pname, GLint *params )
{
	D(bug("nfosmesa: glGetTexGeniv"));
	SelectContext(ctx);
	fn.glGetTexGeniv(  coord,  pname,  params );
}

void OSMesaDriver::glTexEnvf(Uint32 ctx, GLenum target, GLenum pname, GLfloat param )
{
	D(bug("nfosmesa: glTexEnvf"));
	SelectContext(ctx);
	fn.glTexEnvf(  target,  pname,  param );
}

void OSMesaDriver::glTexEnvi(Uint32 ctx, GLenum target, GLenum pname, GLint param )
{
	D(bug("nfosmesa: glTexEnvi"));
	SelectContext(ctx);
	fn.glTexEnvi(  target,  pname,  param );
}

void OSMesaDriver::glTexEnvfv(Uint32 ctx, GLenum target, GLenum pname, const GLfloat *params )
{
	GLfloat tmp[4];

	D(bug("nfosmesa: glTexEnvfv"));
	SelectContext(ctx);
	if (pname==GL_BLEND) {
		Atari2HostFloatPtr(4, (Uint32 *)params, tmp);
		fn.glTexEnvfv(  target,  pname,  tmp );
	} else {
		fn.glTexEnvfv(  target,  pname,  params );
	}
}

void OSMesaDriver::glTexEnviv(Uint32 ctx, GLenum target, GLenum pname, const GLint *params )
{
	GLint tmp[4];

	D(bug("nfosmesa: glTexEnviv"));
	SelectContext(ctx);
	if (pname==GL_BLEND) {
		Atari2HostIntPtr(4, (Uint32 *)params, tmp);
		fn.glTexEnviv(  target,  pname,  tmp );
	} else {
		fn.glTexEnviv(  target,  pname,  params );
	}
}

void OSMesaDriver::glGetTexEnvfv(Uint32 ctx, GLenum target, GLenum pname, GLfloat *params )
{
	D(bug("nfosmesa: glGetTexEnvfv"));
	SelectContext(ctx);
	fn.glGetTexEnvfv(  target,  pname,  params );
}

void OSMesaDriver::glGetTexEnviv(Uint32 ctx, GLenum target, GLenum pname, GLint *params )
{
	D(bug("nfosmesa: glGetTexEnviv"));
	SelectContext(ctx);
	fn.glGetTexEnviv(  target,  pname,  params );
}

void OSMesaDriver::glTexParameterf(Uint32 ctx, GLenum target, GLenum pname, GLfloat param )
{
	D(bug("nfosmesa: glTexParameterf"));
	SelectContext(ctx);
	fn.glTexParameterf(  target,  pname,  param );
}

void OSMesaDriver::glTexParameteri(Uint32 ctx, GLenum target, GLenum pname, GLint param )
{
	D(bug("nfosmesa: glTexParameteri"));
	SelectContext(ctx);
	fn.glTexParameteri(  target,  pname,  param );
}

void OSMesaDriver::glTexParameterfv(Uint32 ctx, GLenum target, GLenum pname, const GLfloat *params )
{
	GLfloat tmp[4];
	int size;

	D(bug("nfosmesa: glTexParameterfv"));
	SelectContext(ctx);
	size=1;
	if (pname==GL_TEXTURE_BORDER_COLOR) {
		size=4;
	}	
	Atari2HostFloatPtr(size, (Uint32 *)params, tmp);
	fn.glTexParameterfv(  target,  pname, tmp );
}

void OSMesaDriver::glTexParameteriv(Uint32 ctx, GLenum target, GLenum pname, const GLint *params )
{
	GLint tmp[4];
	int size;

	D(bug("nfosmesa: glTexParameteriv"));
	SelectContext(ctx);
	size=1;
	if (pname==GL_TEXTURE_BORDER_COLOR) {
		size=4;
	}	
	Atari2HostIntPtr(size, (Uint32 *)params, tmp);
	fn.glTexParameteriv(  target,  pname,  tmp );
}

void OSMesaDriver::glGetTexParameterfv(Uint32 ctx, GLenum target, GLenum pname, GLfloat *params)
{
	D(bug("nfosmesa: glGetTexParameterfv"));
	SelectContext(ctx);
	fn.glGetTexParameterfv(  target,  pname,  params);
}

void OSMesaDriver::glGetTexParameteriv(Uint32 ctx, GLenum target, GLenum pname, GLint *params )
{
	D(bug("nfosmesa: glGetTexParameteriv"));
	SelectContext(ctx);
	fn.glGetTexParameteriv(  target,  pname,  params );
}

void OSMesaDriver::glGetTexLevelParameterfv(Uint32 ctx, GLenum target, GLint level, GLenum pname, GLfloat *params )
{
	D(bug("nfosmesa: glGetTexLevelParameterfv"));
	SelectContext(ctx);
	fn.glGetTexLevelParameterfv(  target,  level,  pname,  params );
}

void OSMesaDriver::glGetTexLevelParameteriv(Uint32 ctx, GLenum target, GLint level, GLenum pname, GLint *params )
{
	D(bug("nfosmesa: glGetTexLevelParameteriv"));
	SelectContext(ctx);
	fn.glGetTexLevelParameteriv(  target,  level,  pname,  params );
}

void OSMesaDriver::glTexImage1D(Uint32 ctx, GLenum target, GLint level, GLint internalFormat, GLsizei width, GLint border, GLenum format, GLenum type, const GLvoid *pixels )
{
	D(bug("nfosmesa: glTexImage1D"));
	SelectContext(ctx);
	fn.glTexImage1D(  target,  level,  internalFormat,  width,  border,  format,  type,  pixels );
}

void OSMesaDriver::glTexImage2D(Uint32 ctx, GLenum target, GLint level, GLint internalFormat, GLsizei width, GLsizei height, GLint border, GLenum format, GLenum type, const GLvoid *pixels )
{
	D(bug("nfosmesa: glTexImage2D"));
	SelectContext(ctx);
	fn.glTexImage2D(  target,  level,  internalFormat,  width,  height,  border,  format,  type,  pixels );
}

void OSMesaDriver::glGetTexImage(Uint32 ctx, GLenum target, GLint level, GLenum format, GLenum type, GLvoid *pixels )
{
	D(bug("nfosmesa: glGetTexImage"));
	SelectContext(ctx);
	fn.glGetTexImage(  target,  level,  format,  type,  pixels );
}

void OSMesaDriver::glGenTextures(Uint32 ctx, GLsizei n, GLuint *textures )
{
	int i;

	D(bug("nfosmesa: glGenTextures"));
	SelectContext(ctx);
	fn.glGenTextures(  n,  textures );
	for (i=0;i<n;i++) {
		GLuint numtex;
		
		numtex=textures[i];
		textures[i]=SDL_SwapBE32(numtex);
	}	
}

void OSMesaDriver::glDeleteTextures(Uint32 ctx, GLsizei n, const GLuint *textures)
{
	GLuint *tmp;

	D(bug("nfosmesa: glDeleteTextures"));
	if (n<=0) {
		return;
	}
	tmp=(GLuint *)malloc(n*sizeof(GLuint));
	if (tmp) {
		Atari2HostIntPtr(n, (Uint32 *)textures, (GLint *)tmp);
		SelectContext(ctx);
		fn.glDeleteTextures(  n,  tmp);
		free(tmp);
	}
}

void OSMesaDriver::glBindTexture(Uint32 ctx, GLenum target, GLuint texture )
{
	D(bug("nfosmesa: glBindTexture"));
	SelectContext(ctx);
	fn.glBindTexture(  target,  texture );
}

void OSMesaDriver::glPrioritizeTextures(Uint32 ctx, GLsizei n, const GLuint *textures, const GLclampf *priorities )
{
	GLuint *tmp;
	GLclampf *tmp2;

	D(bug("nfosmesa: glPrioritizeTextures"));
	if (n<=0) {
		return;
	}
	tmp=(GLuint *)malloc(n*sizeof(GLuint));
	if (tmp) {
		tmp2=(GLclampf *)malloc(n*sizeof(GLclampf));
		if (tmp2) {
			Atari2HostIntPtr(n,(Uint32 *)textures, (GLint *)tmp);
			Atari2HostFloatPtr(n,(Uint32 *)priorities, tmp2);
			SelectContext(ctx);
			fn.glPrioritizeTextures(  n,  tmp,  tmp2 );
			free(tmp2);
		}
		free(tmp);
	}
}

GLboolean OSMesaDriver::glAreTexturesResident(Uint32 ctx, GLsizei n, const GLuint *textures, GLboolean *residences )
{
	GLuint *tmp;
	GLboolean result=GL_FALSE;

	D(bug("nfosmesa: glAreTexturesResident"));
	if (n<=0) {
		return result;
	}
	tmp=(GLuint *)malloc(n*sizeof(GLuint));
	if (tmp) {
		Atari2HostIntPtr(n, (Uint32 *)textures, (GLint *)tmp);
		SelectContext(ctx);
		result=fn.glAreTexturesResident(  n,  tmp,  residences );
		free(tmp);
	}
	return result;
}

GLboolean OSMesaDriver::glIsTexture(Uint32 ctx, GLuint texture )
{
	D(bug("nfosmesa: glIsTexture"));
	SelectContext(ctx);
	return fn.glIsTexture(  texture );
}

void OSMesaDriver::glTexSubImage1D(Uint32 ctx, GLenum target, GLint level, GLint xoffset, GLsizei width, GLenum format, GLenum type, const GLvoid *pixels )
{
	D(bug("nfosmesa: glTexSubImage1D"));
	SelectContext(ctx);
	fn.glTexSubImage1D(  target,  level,  xoffset,  width,  format,  type,  pixels );
}

void OSMesaDriver::glTexSubImage2D(Uint32 ctx, GLenum target, GLint level, GLint xoffset, GLint yoffset, GLsizei width, GLsizei height, GLenum format, GLenum type, const GLvoid *pixels )
{
	D(bug("nfosmesa: glTexSubImage2D"));
	SelectContext(ctx);
	fn.glTexSubImage2D(  target,  level,  xoffset,  yoffset,  width,  height,  format,  type,  pixels );
}

void OSMesaDriver::glCopyTexImage1D(Uint32 ctx, GLenum target, GLint level, GLenum internalformat, GLint x, GLint y, GLsizei width, GLint border )
{
	D(bug("nfosmesa: glCopyTexImage1D"));
	SelectContext(ctx);
	fn.glCopyTexImage1D(  target,  level,  internalformat,  x,  y,  width,  border );
}

void OSMesaDriver::glCopyTexImage2D(Uint32 ctx, GLenum target, GLint level, GLenum internalformat, GLint x, GLint y, GLsizei width, GLsizei height, GLint border )
{
	D(bug("nfosmesa: glCopyTexImage2D"));
	SelectContext(ctx);
	fn.glCopyTexImage2D(  target,  level,  internalformat,  x,  y,  width,  height,  border );
}

void OSMesaDriver::glCopyTexSubImage1D(Uint32 ctx, GLenum target, GLint level, GLint xoffset, GLint x, GLint y, GLsizei width )
{
	D(bug("nfosmesa: glCopyTexSubImage1D"));
	SelectContext(ctx);
	fn.glCopyTexSubImage1D(  target,  level,  xoffset,  x,  y,  width );
}

void OSMesaDriver::glCopyTexSubImage2D(Uint32 ctx, GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint x, GLint y, GLsizei width, GLsizei height )
{
	D(bug("nfosmesa: glCopyTexSubImage2D"));
	SelectContext(ctx);
	fn.glCopyTexSubImage2D(  target,  level,  xoffset,  yoffset,  x,  y,  width,  height );
}

void OSMesaDriver::glMap1d(Uint32 ctx, GLenum target, GLdouble u1, GLdouble u2, GLint stride, GLint order, const GLdouble *points )
{
	D(bug("nfosmesa: glMap1d"));
	SelectContext(ctx);
#if SDL_BYTEORDER == SDL_LIL_ENDIAN
	{
		GLdouble *tmp;
		GLubyte *ptr;
		int size, i,j;
		
		switch(target) {
			case GL_MAP1_INDEX:
			case GL_MAP1_TEXTURE_COORD_1:
				size=1;
				break;
			case GL_MAP1_TEXTURE_COORD_2:
				size=2;
				break;
			case GL_MAP1_VERTEX_3:
			case GL_MAP1_NORMAL:
			case GL_MAP1_TEXTURE_COORD_3:
				size=3;
				break;
			default:
				size=4;
				break;
		}

		tmp=(GLdouble *)malloc(size*order*sizeof(GLdouble));
		if (tmp) {
			ptr =(GLubyte *)points;
			for (i=0;i<order;i++) {
				for (j=0;j<size;j++) {
					Atari2HostDoublePtr(1, (Uint32 *)&ptr[j], &tmp[i*size+j]);
				}
				ptr += stride*sizeof(GLdouble);
			}
			fn.glMap1d(  target,  u1,  u2,  size,  order,  tmp );
			free(tmp);
		}
	}
#else
	fn.glMap1d(  target,  u1,  u2,  stride,  order,  points );
#endif
}

void OSMesaDriver::glMap1f(Uint32 ctx, GLenum target, GLfloat u1, GLfloat u2, GLint stride, GLint order, const GLfloat *points )
{
	D(bug("nfosmesa: glMap1f"));
	SelectContext(ctx);
#if SDL_BYTEORDER == SDL_LIL_ENDIAN
	{
		GLfloat *tmp;
		GLubyte *ptr;
		int size, i,j;
		
		switch(target) {
			case GL_MAP1_INDEX:
			case GL_MAP1_TEXTURE_COORD_1:
				size=1;
				break;
			case GL_MAP1_TEXTURE_COORD_2:
				size=2;
				break;
			case GL_MAP1_VERTEX_3:
			case GL_MAP1_NORMAL:
			case GL_MAP1_TEXTURE_COORD_3:
				size=3;
				break;
			default:
				size=4;
				break;
		}

		tmp=(GLfloat *)malloc(size*order*sizeof(GLfloat));
		if (tmp) {
			ptr =(GLubyte *)points;
			for (i=0;i<order;i++) {
				for (j=0;j<size;j++) {
					Atari2HostFloatPtr(1, (Uint32 *)&ptr[j], &tmp[i*size+j]);
				}
				ptr += stride*sizeof(GLfloat);
			}
			fn.glMap1f(  target,  u1,  u2,  size,  order,  tmp );
			free(tmp);
		}
	}
#else
	fn.glMap1f(  target,  u1,  u2,  stride,  order,  points );
#endif
}

void OSMesaDriver::glMap2d(Uint32 ctx, GLenum target, GLdouble u1, GLdouble u2, GLint ustride, GLint uorder, GLdouble v1, GLdouble v2, GLint vstride, GLint vorder, const GLdouble *points )
{
	D(bug("nfosmesa: glMap2d"));
	SelectContext(ctx);
#if SDL_BYTEORDER == SDL_LIL_ENDIAN
	{
		GLdouble *tmp1,*tmp2;
		GLubyte *ptr1,*ptr2;
		int size, i,j;
		
		switch(target) {
			case GL_MAP2_INDEX:
			case GL_MAP2_TEXTURE_COORD_1:
				size=1;
				break;
			case GL_MAP2_TEXTURE_COORD_2:
				size=2;
				break;
			case GL_MAP2_VERTEX_3:
			case GL_MAP2_NORMAL:
			case GL_MAP2_TEXTURE_COORD_3:
				size=3;
				break;
			default:
				size=4;
				break;
		}

		tmp1=(GLdouble *)malloc(size*(uorder+vorder)*sizeof(GLdouble));
		if (tmp1) {
			ptr1 =(GLubyte *)points;
			for (i=0;i<uorder;i++) {
				for (j=0;j<size;j++) {
					Atari2HostDoublePtr(1, (Uint32 *)&ptr1[j], &tmp1[i*size+j]);
				}
				ptr1 += ustride*sizeof(GLdouble);
			}

			tmp2=&tmp1[uorder*size];

			ptr2 =(GLubyte *)points;
			for (i=0;i<vorder;i++) {
				for (j=0;j<size;j++) {
					Atari2HostDoublePtr(1, (Uint32 *)&ptr2[j], &tmp2[i*size+j]);
				}
				ptr2 += vstride*sizeof(GLdouble);
			}

			fn.glMap2d(  target,
				u1,  u2,  size,  uorder,
				v1,  v2,  size*uorder,  vorder, tmp1
			);

			free(tmp1);
		}
	}
#else
	fn.glMap2d(  target,  u1,  u2,  ustride,  uorder,  v1,  v2,  vstride,  vorder,  points );
#endif
}

void OSMesaDriver::glMap2f(Uint32 ctx, GLenum target, GLfloat u1, GLfloat u2, GLint ustride, GLint uorder, GLfloat v1, GLfloat v2, GLint vstride, GLint vorder, const GLfloat *points )
{
	D(bug("nfosmesa: glMap2f"));
	SelectContext(ctx);
#if SDL_BYTEORDER == SDL_LIL_ENDIAN
	{
		GLfloat *tmp1,*tmp2;
		GLubyte *ptr1,*ptr2;
		int size, i,j;
		
		switch(target) {
			case GL_MAP2_INDEX:
			case GL_MAP2_TEXTURE_COORD_1:
				size=1;
				break;
			case GL_MAP2_TEXTURE_COORD_2:
				size=2;
				break;
			case GL_MAP2_VERTEX_3:
			case GL_MAP2_NORMAL:
			case GL_MAP2_TEXTURE_COORD_3:
				size=3;
				break;
			default:
				size=4;
				break;
		}

		tmp1=(GLfloat *)malloc(size*(uorder+vorder)*sizeof(GLfloat));
		if (tmp1) {
			ptr1 =(GLubyte *)points;
			for (i=0;i<uorder;i++) {
				for (j=0;j<size;j++) {
					Atari2HostFloatPtr(1, (Uint32 *)&ptr1[j], &tmp1[i*size+j]);
				}
				ptr1 += ustride*sizeof(GLfloat);
			}

			tmp2= &tmp1[uorder*size];

			ptr2 =(GLubyte *)points;
			for (i=0;i<vorder;i++) {
				for (j=0;j<size;j++) {
					Atari2HostFloatPtr(1, (Uint32 *)&ptr2[j], &tmp2[i*size+j]);
				}
				ptr2 += vstride*sizeof(GLfloat);
			}

			fn.glMap2f(  target,
				u1,  u2,  size,  uorder,
				v1,  v2,  size*uorder,  vorder,  tmp1
			);

			free(tmp1);
		}
	}
#else
	fn.glMap2f(  target,  u1,  u2,  ustride,  uorder,  v1,  v2,  vstride,  vorder,  points );
#endif
}

void OSMesaDriver::glGetMapdv(Uint32 ctx, GLenum target, GLenum query, GLdouble *v )
{
	D(bug("nfosmesa: glGetMapdv"));
	SelectContext(ctx);
	fn.glGetMapdv(  target,  query,  v );
}

void OSMesaDriver::glGetMapfv(Uint32 ctx, GLenum target, GLenum query, GLfloat *v )
{
	D(bug("nfosmesa: glGetMapfv"));
	SelectContext(ctx);
	fn.glGetMapfv(  target,  query,  v );
}

void OSMesaDriver::glGetMapiv(Uint32 ctx, GLenum target, GLenum query, GLint *v )
{
	D(bug("nfosmesa: glGetMapiv"));
	SelectContext(ctx);
	fn.glGetMapiv(  target,  query,  v );
}

void OSMesaDriver::glEvalCoord1d(Uint32 ctx, GLdouble u )
{
	D(bug("nfosmesa: glEvalCoord1d"));
	SelectContext(ctx);
	fn.glEvalCoord1d(  u );
}

void OSMesaDriver::glEvalCoord1f(Uint32 ctx, GLfloat u )
{
	D(bug("nfosmesa: glEvalCoord1f"));
	SelectContext(ctx);
	fn.glEvalCoord1f(  u );
}

void OSMesaDriver::glEvalCoord1dv(Uint32 ctx, const GLdouble *u )
{
	GLdouble tmp[1];

	D(bug("nfosmesa: glEvalCoord1dv"));
	SelectContext(ctx);
	Atari2HostDoublePtr(1, (Uint32 *)u, tmp);
	fn.glEvalCoord1dv( tmp );
}

void OSMesaDriver::glEvalCoord1fv(Uint32 ctx, const GLfloat *u )
{
	GLfloat tmp[1];

	D(bug("nfosmesa: glEvalCoord1fv"));
	SelectContext(ctx);
	Atari2HostFloatPtr(1, (Uint32 *)u, tmp);
	fn.glEvalCoord1fv( tmp );
}

void OSMesaDriver::glEvalCoord2d(Uint32 ctx, GLdouble u, GLdouble v )
{
	D(bug("nfosmesa: glEvalCoord2d"));
	SelectContext(ctx);
	fn.glEvalCoord2d(  u,  v );
}

void OSMesaDriver::glEvalCoord2f(Uint32 ctx, GLfloat u, GLfloat v )
{
	D(bug("nfosmesa: glEvalCoord2f"));
	SelectContext(ctx);
	fn.glEvalCoord2f(  u,  v );
}

void OSMesaDriver::glEvalCoord2dv(Uint32 ctx, const GLdouble *u )
{
	GLdouble tmp[2];

	D(bug("nfosmesa: glEvalCoord2dv"));
	SelectContext(ctx);
	Atari2HostDoublePtr(2, (Uint32 *)u, tmp);
	fn.glEvalCoord2dv( tmp );
}

void OSMesaDriver::glEvalCoord2fv(Uint32 ctx, const GLfloat *u )
{
	GLfloat tmp[2];

	D(bug("nfosmesa: glEvalCoord2fv"));
	SelectContext(ctx);
	Atari2HostFloatPtr(2, (Uint32 *)u, tmp);
	fn.glEvalCoord2fv( tmp );
}

void OSMesaDriver::glMapGrid1d(Uint32 ctx, GLint un, GLdouble u1, GLdouble u2 )
{
	D(bug("nfosmesa: glMapGrid1d"));
	SelectContext(ctx);
	fn.glMapGrid1d(  un,  u1,  u2 );
}

void OSMesaDriver::glMapGrid1f(Uint32 ctx, GLint un, GLfloat u1, GLfloat u2 )
{
	D(bug("nfosmesa: glMapGrid1f"));
	SelectContext(ctx);
	fn.glMapGrid1f(  un,  u1,  u2 );
}

void OSMesaDriver::glMapGrid2d(Uint32 ctx, GLint un, GLdouble u1, GLdouble u2, GLint vn, GLdouble v1, GLdouble v2 )
{
	D(bug("nfosmesa: glMapGrid2d"));
	SelectContext(ctx);
	fn.glMapGrid2d(  un,  u1,  u2,  vn,  v1,  v2 );
}

void OSMesaDriver::glMapGrid2f(Uint32 ctx, GLint un, GLfloat u1, GLfloat u2, GLint vn, GLfloat v1, GLfloat v2 )
{
	D(bug("nfosmesa: glMapGrid2f"));
	SelectContext(ctx);
	fn.glMapGrid2f(  un,  u1,  u2,  vn,  v1,  v2 );
}

void OSMesaDriver::glEvalPoint1(Uint32 ctx, GLint i )
{
	D(bug("nfosmesa: glEvalPoint1"));
	SelectContext(ctx);
	fn.glEvalPoint1(  i );
}

void OSMesaDriver::glEvalPoint2(Uint32 ctx, GLint i, GLint j )
{
	D(bug("nfosmesa: glEvalPoint2"));
	SelectContext(ctx);
	fn.glEvalPoint2(  i,  j );
}

void OSMesaDriver::glEvalMesh1(Uint32 ctx, GLenum mode, GLint i1, GLint i2 )
{
	D(bug("nfosmesa: glEvalMesh1"));
	SelectContext(ctx);
	fn.glEvalMesh1(  mode,  i1,  i2 );
}

void OSMesaDriver::glEvalMesh2(Uint32 ctx, GLenum mode, GLint i1, GLint i2, GLint j1, GLint j2 )
{
	D(bug("nfosmesa: glEvalMesh2"));
	SelectContext(ctx);
	fn.glEvalMesh2(  mode,  i1,  i2,  j1,  j2 );
}

void OSMesaDriver::glFogf(Uint32 ctx, GLenum pname, GLfloat param )
{
	D(bug("nfosmesa: glFogf"));
	SelectContext(ctx);
	fn.glFogf(  pname,  param );
}

void OSMesaDriver::glFogi(Uint32 ctx, GLenum pname, GLint param )
{
	D(bug("nfosmesa: glFogi"));
	SelectContext(ctx);
	fn.glFogi(  pname,  param );
}

void OSMesaDriver::glFogfv(Uint32 ctx, GLenum pname, const GLfloat *params )
{
	GLfloat tmp[4];
	int size;

	D(bug("nfosmesa: glFogfv"));
	switch(pname) {
		case GL_FOG_COLOR:
			size=4;
			break;
		default:
			size=1;
			break;
	}
	Atari2HostFloatPtr(size, (Uint32 *)params, tmp);
	SelectContext(ctx);
	fn.glFogfv(  pname,  tmp );
}

void OSMesaDriver::glFogiv(Uint32 ctx, GLenum pname, const GLint *params )
{
	GLint tmp[4];
	int size;

	D(bug("nfosmesa: glFogiv"));
	switch(pname) {
		case GL_FOG_COLOR:
			size=4;
			break;
		default:
			size=1;
			break;
	}
	Atari2HostIntPtr(size, (Uint32 *)params, tmp);
	SelectContext(ctx);
	fn.glFogiv(  pname,  tmp );
}

void OSMesaDriver::glFeedbackBuffer(Uint32 ctx, GLsizei size, GLenum type, GLfloat *buffer )
{
	D(bug("nfosmesa: glFeedbackBuffer"));
	SelectContext(ctx);
	fn.glFeedbackBuffer(  size,  type,  buffer );
}

void OSMesaDriver::glPassThrough(Uint32 ctx, GLfloat token )
{
	D(bug("nfosmesa: glPassThrough"));
	SelectContext(ctx);
	fn.glPassThrough(  token );
}

void OSMesaDriver::glSelectBuffer(Uint32 ctx, GLsizei size, GLuint *buffer )
{
	D(bug("nfosmesa: glSelectBuffer"));
	SelectContext(ctx);
	fn.glSelectBuffer(  size,  buffer );
}

void OSMesaDriver::glInitNames(Uint32 ctx)
{
	D(bug("nfosmesa: glInitNames"));
	SelectContext(ctx);
	fn.glInitNames(  );
}

void OSMesaDriver::glLoadName(Uint32 ctx, GLuint name )
{
	D(bug("nfosmesa: glLoadName"));
	SelectContext(ctx);
	fn.glLoadName(  name );
}

void OSMesaDriver::glPushName(Uint32 ctx, GLuint name )
{
	D(bug("nfosmesa: glPushName"));
	SelectContext(ctx);
	fn.glPushName(  name );
}

void OSMesaDriver::glPopName(Uint32 ctx)
{
	D(bug("nfosmesa: glPopName"));
	SelectContext(ctx);
	fn.glPopName(  );
}

/*
void OSMesaDriver::glDrawRangeElements(Uint32 ctx, GLenum mode, GLuint start, GLuint end, GLsizei count, GLenum type, const GLvoid *indices )
{
	D(bug("nfosmesa: glDrawRangeElements"));
	SelectContext(ctx);
	fn.glDrawRangeElements(  mode,  start,  end,  count,  type,  indices );
}

void OSMesaDriver::glTexImage3D(Uint32 ctx, GLenum target, GLint level, GLint internalFormat, GLsizei width, GLsizei height, GLsizei depth, GLint border, GLenum format, GLenum type, const GLvoid *pixels )
{
	D(bug("nfosmesa: glTexImage3D"));
	SelectContext(ctx);
	fn.glTexImage3D(  target,  level,  internalFormat,  width,  height,  depth,  border,  format,  type,  pixels );
}

void OSMesaDriver::glTexSubImage3D(Uint32 ctx, GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLenum type, const GLvoid *pixels)
{
	D(bug("nfosmesa: glTexSubImage3D"));
	SelectContext(ctx);
	fn.glTexSubImage3D(  target,  level,  xoffset,  yoffset,  zoffset,  width,  height,  depth,  format,  type,  pixels);
}

void OSMesaDriver::glCopyTexSubImage3D(Uint32 ctx, GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLint x, GLint y, GLsizei width, GLsizei height )
{
	D(bug("nfosmesa: glCopyTexSubImage3D"));
	SelectContext(ctx);
	fn.glCopyTexSubImage3D(  target,  level,  xoffset,  yoffset,  zoffset,  x,  y,  width,  height );
}

void OSMesaDriver::glColorTable(Uint32 ctx, GLenum target, GLenum internalformat, GLsizei width, GLenum format, GLenum type, const GLvoid *table )
{
	D(bug("nfosmesa: glColorTable"));
	SelectContext(ctx);
	fn.glColorTable(  target,  internalformat,  width,  format,  type,  table );
}

void OSMesaDriver::glColorSubTable(Uint32 ctx, GLenum target, GLsizei start, GLsizei count, GLenum format, GLenum type, const GLvoid *data )
{
	D(bug("nfosmesa: glColorSubTable"));
	SelectContext(ctx);
	fn.glColorSubTable(  target,  start,  count,  format,  type,  data );
}

void OSMesaDriver::glColorTableParameteriv(Uint32 ctx,GLenum target, GLenum pname, const GLint *params)
{
	D(bug("nfosmesa: glColorTableParameteriv"));
	SelectContext(ctx);
	fn.glColorTableParameteriv( target,  pname,  params);
}

void OSMesaDriver::glColorTableParameterfv(Uint32 ctx,GLenum target, GLenum pname, const GLfloat *params)
{
	D(bug("nfosmesa: glColorTableParameterfv"));
	SelectContext(ctx);
	fn.glColorTableParameterfv( target,  pname,  params);
}

void OSMesaDriver::glCopyColorSubTable(Uint32 ctx, GLenum target, GLsizei start, GLint x, GLint y, GLsizei width )
{
	D(bug("nfosmesa: glCopyColorSubTable"));
	SelectContext(ctx);
	fn.glCopyColorSubTable(  target,  start,  x,  y,  width );
}

void OSMesaDriver::glCopyColorTable(Uint32 ctx, GLenum target, GLenum internalformat, GLint x, GLint y, GLsizei width )
{
	D(bug("nfosmesa: glCopyColorTable"));
	SelectContext(ctx);
	fn.glCopyColorTable(  target,  internalformat,  x,  y,  width );
}

void OSMesaDriver::glGetColorTable(Uint32 ctx, GLenum target, GLenum format, GLenum type, GLvoid *table )
{
	D(bug("nfosmesa: glGetColorTable"));
	SelectContext(ctx);
	fn.glGetColorTable(  target,  format,  type,  table );
}

void OSMesaDriver::glGetColorTableParameterfv(Uint32 ctx, GLenum target, GLenum pname, GLfloat *params )
{
	D(bug("nfosmesa: glGetColorTableParameterfv"));
	SelectContext(ctx);
	fn.glGetColorTableParameterfv(  target,  pname,  params );
}

void OSMesaDriver::glGetColorTableParameteriv(Uint32 ctx, GLenum target, GLenum pname, GLint *params )
{
	D(bug("nfosmesa: glGetColorTableParameteriv"));
	SelectContext(ctx);
	fn.glGetColorTableParameteriv(  target,  pname,  params );
}

void OSMesaDriver::glBlendEquation(Uint32 ctx, GLenum mode )
{
	D(bug("nfosmesa: glBlendEquation"));
	SelectContext(ctx);
	fn.glBlendEquation(  mode );
}

void OSMesaDriver::glBlendColor(Uint32 ctx, GLclampf red, GLclampf green, GLclampf blue, GLclampf alpha )
{
	D(bug("nfosmesa: glBlendColor"));
	SelectContext(ctx);
	fn.glBlendColor(  red,  green,  blue,  alpha );
}

void OSMesaDriver::glHistogram(Uint32 ctx, GLenum target, GLsizei width, GLenum internalformat, GLboolean sink )
{
	D(bug("nfosmesa: glHistogram"));
	SelectContext(ctx);
	fn.glHistogram(  target,  width,  internalformat,  sink );
}

void OSMesaDriver::glResetHistogram(Uint32 ctx, GLenum target )
{
	D(bug("nfosmesa: glResetHistogram"));
	SelectContext(ctx);
	fn.glResetHistogram(  target );
}

void OSMesaDriver::glGetHistogram(Uint32 ctx, GLenum target, GLboolean reset, GLenum format, GLenum type, GLvoid *values )
{
	D(bug("nfosmesa: glGetHistogram"));
	SelectContext(ctx);
	fn.glGetHistogram(  target,  reset,  format,  type,  values );
}

void OSMesaDriver::glGetHistogramParameterfv(Uint32 ctx, GLenum target, GLenum pname, GLfloat *params )
{
	D(bug("nfosmesa: glGetHistogramParameterfv"));
	SelectContext(ctx);
	fn.glGetHistogramParameterfv(  target,  pname,  params );
}

void OSMesaDriver::glGetHistogramParameteriv(Uint32 ctx, GLenum target, GLenum pname, GLint *params )
{
	D(bug("nfosmesa: glGetHistogramParameteriv"));
	SelectContext(ctx);
	fn.glGetHistogramParameteriv(  target,  pname,  params );
}

void OSMesaDriver::glMinmax(Uint32 ctx, GLenum target, GLenum internalformat, GLboolean sink )
{
	D(bug("nfosmesa: glMinmax"));
	SelectContext(ctx);
	fn.glMinmax(  target,  internalformat,  sink );
}

void OSMesaDriver::glResetMinmax(Uint32 ctx, GLenum target )
{
	D(bug("nfosmesa: glResetMinmax"));
	SelectContext(ctx);
	fn.glResetMinmax(  target );
}

void OSMesaDriver::glGetMinmax(Uint32 ctx, GLenum target, GLboolean reset, GLenum format, GLenum types, GLvoid *values )
{
	D(bug("nfosmesa: glGetMinmax"));
	SelectContext(ctx);
	fn.glGetMinmax(  target,  reset,  format,  types,  values );
}

void OSMesaDriver::glGetMinmaxParameterfv(Uint32 ctx, GLenum target, GLenum pname, GLfloat *params )
{
	D(bug("nfosmesa: glGetMinmaxParameterfv"));
	SelectContext(ctx);
	fn.glGetMinmaxParameterfv(  target,  pname,  params );
}

void OSMesaDriver::glGetMinmaxParameteriv(Uint32 ctx, GLenum target, GLenum pname, GLint *params )
{
	D(bug("nfosmesa: glGetMinmaxParameteriv"));
	SelectContext(ctx);
	fn.glGetMinmaxParameteriv(  target,  pname,  params );
}

void OSMesaDriver::glConvolutionFilter1D(Uint32 ctx, GLenum target, GLenum internalformat, GLsizei width, GLenum format, GLenum type, const GLvoid *image )
{
	D(bug("nfosmesa: glConvolutionFilter1D"));
	SelectContext(ctx);
	fn.glConvolutionFilter1D(  target,  internalformat,  width,  format,  type,  image );
}

void OSMesaDriver::glConvolutionFilter2D(Uint32 ctx, GLenum target, GLenum internalformat, GLsizei width, GLsizei height, GLenum format, GLenum type, const GLvoid *image )
{
	D(bug("nfosmesa: glConvolutionFilter2D"));
	SelectContext(ctx);
	fn.glConvolutionFilter2D(  target,  internalformat,  width,  height,  format,  type,  image );
}

void OSMesaDriver::glConvolutionParameterf(Uint32 ctx, GLenum target, GLenum pname, GLfloat params )
{
	D(bug("nfosmesa: glConvolutionParameterf"));
	SelectContext(ctx);
	fn.glConvolutionParameterf(  target,  pname,  params );
}

void OSMesaDriver::glConvolutionParameterfv(Uint32 ctx, GLenum target, GLenum pname, const GLfloat *params )
{
	D(bug("nfosmesa: glConvolutionParameterfv"));
	SelectContext(ctx);
	fn.glConvolutionParameterfv(  target,  pname,  params );
}

void OSMesaDriver::glConvolutionParameteri(Uint32 ctx, GLenum target, GLenum pname, GLint params )
{
	D(bug("nfosmesa: glConvolutionParameteri"));
	SelectContext(ctx);
	fn.glConvolutionParameteri(  target,  pname,  params );
}

void OSMesaDriver::glConvolutionParameteriv(Uint32 ctx, GLenum target, GLenum pname, const GLint *params )
{
	D(bug("nfosmesa: glConvolutionParameteriv"));
	SelectContext(ctx);
	fn.glConvolutionParameteriv(  target,  pname,  params );
}

void OSMesaDriver::glCopyConvolutionFilter1D(Uint32 ctx, GLenum target, GLenum internalformat, GLint x, GLint y, GLsizei width )
{
	D(bug("nfosmesa: glCopyConvolutionFilter1D"));
	SelectContext(ctx);
	fn.glCopyConvolutionFilter1D(  target,  internalformat,  x,  y,  width );
}

void OSMesaDriver::glCopyConvolutionFilter2D(Uint32 ctx, GLenum target, GLenum internalformat, GLint x, GLint y, GLsizei width, GLsizei height)
{
	D(bug("nfosmesa: glCopyConvolutionFilter2D"));
	SelectContext(ctx);
	fn.glCopyConvolutionFilter2D(  target,  internalformat,  x,  y,  width,  height);
}

void OSMesaDriver::glGetConvolutionFilter(Uint32 ctx, GLenum target, GLenum format, GLenum type, GLvoid *image )
{
	D(bug("nfosmesa: glGetConvolutionFilter"));
	SelectContext(ctx);
	fn.glGetConvolutionFilter(  target,  format,  type,  image );
}

void OSMesaDriver::glGetConvolutionParameterfv(Uint32 ctx, GLenum target, GLenum pname, GLfloat *params )
{
	D(bug("nfosmesa: glGetConvolutionParameterfv"));
	SelectContext(ctx);
	fn.glGetConvolutionParameterfv(  target,  pname,  params );
}

void OSMesaDriver::glGetConvolutionParameteriv(Uint32 ctx, GLenum target, GLenum pname, GLint *params )
{
	D(bug("nfosmesa: glGetConvolutionParameteriv"));
	SelectContext(ctx);
	fn.glGetConvolutionParameteriv(  target,  pname,  params );
}

void OSMesaDriver::glSeparableFilter2D(Uint32 ctx, GLenum target, GLenum internalformat, GLsizei width, GLsizei height, GLenum format, GLenum type, const GLvoid *row, const GLvoid *column )
{
	D(bug("nfosmesa: glSeparableFilter2D"));
	SelectContext(ctx);
	fn.glSeparableFilter2D(  target,  internalformat,  width,  height,  format,  type,  row,  column );
}

void OSMesaDriver::glGetSeparableFilter(Uint32 ctx, GLenum target, GLenum format, GLenum type, GLvoid *row, GLvoid *column, GLvoid *span )
{
	D(bug("nfosmesa: glGetSeparableFilter"));
	SelectContext(ctx);
	fn.glGetSeparableFilter(  target,  format,  type,  row,  column,  span );
}

void OSMesaDriver::glActiveTexture(Uint32 ctx, GLenum texture )
{
	D(bug("nfosmesa: glActiveTexture"));
	SelectContext(ctx);
	fn.glActiveTexture(  texture );
}

void OSMesaDriver::glClientActiveTexture(Uint32 ctx, GLenum texture )
{
	D(bug("nfosmesa: glClientActiveTexture"));
	SelectContext(ctx);
	fn.glClientActiveTexture(  texture );
}

void OSMesaDriver::glCompressedTexImage1D(Uint32 ctx, GLenum target, GLint level, GLenum internalformat, GLsizei width, GLint border, GLsizei imageSize, const GLvoid *data )
{
	D(bug("nfosmesa: glCompressedTexImage1D"));
	SelectContext(ctx);
	fn.glCompressedTexImage1D(  target,  level,  internalformat,  width,  border,  imageSize,  data );
}

void OSMesaDriver::glCompressedTexImage2D(Uint32 ctx, GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLint border, GLsizei imageSize, const GLvoid *data )
{
	D(bug("nfosmesa: glCompressedTexImage2D"));
	SelectContext(ctx);
	fn.glCompressedTexImage2D(  target,  level,  internalformat,  width,  height,  border,  imageSize,  data );
}

void OSMesaDriver::glCompressedTexImage3D(Uint32 ctx, GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth, GLint border, GLsizei imageSize, const GLvoid *data )
{
	D(bug("nfosmesa: glCompressedTexImage3D"));
	SelectContext(ctx);
	fn.glCompressedTexImage3D(  target,  level,  internalformat,  width,  height,  depth,  border,  imageSize,  data );
}

void OSMesaDriver::glCompressedTexSubImage1D(Uint32 ctx, GLenum target, GLint level, GLint xoffset, GLsizei width, GLenum format, GLsizei imageSize, const GLvoid *data )
{
	D(bug("nfosmesa: glCompressedTexSubImage1D"));
	SelectContext(ctx);
	fn.glCompressedTexSubImage1D(  target,  level,  xoffset,  width,  format,  imageSize,  data );
}

void OSMesaDriver::glCompressedTexSubImage2D(Uint32 ctx, GLenum target, GLint level, GLint xoffset, GLint yoffset, GLsizei width, GLsizei height, GLenum format, GLsizei imageSize, const GLvoid *data )
{
	D(bug("nfosmesa: glCompressedTexSubImage2D"));
	SelectContext(ctx);
	fn.glCompressedTexSubImage2D(  target,  level,  xoffset,  yoffset,  width,  height,  format,  imageSize,  data );
}

void OSMesaDriver::glCompressedTexSubImage3D(Uint32 ctx, GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLsizei imageSize, const GLvoid *data )
{
	D(bug("nfosmesa: glCompressedTexSubImage3D"));
	SelectContext(ctx);
	fn.glCompressedTexSubImage3D(  target,  level,  xoffset,  yoffset,  zoffset,  width,  height,  depth,  format,  imageSize,  data );
}

void OSMesaDriver::glGetCompressedTexImage(Uint32 ctx, GLenum target, GLint lod, GLvoid *img )
{
	D(bug("nfosmesa: glGetCompressedTexImage"));
	SelectContext(ctx);
	fn.glGetCompressedTexImage(  target,  lod,  img );
}

void OSMesaDriver::glMultiTexCoord1d(Uint32 ctx, GLenum target, GLdouble s )
{
	D(bug("nfosmesa: glMultiTexCoord1d"));
	SelectContext(ctx);
	fn.glMultiTexCoord1d(  target,  s );
}

void OSMesaDriver::glMultiTexCoord1dv(Uint32 ctx, GLenum target, const GLdouble *v )
{
	D(bug("nfosmesa: glMultiTexCoord1dv"));
	SelectContext(ctx);
	fn.glMultiTexCoord1dv(  target,  v );
}

void OSMesaDriver::glMultiTexCoord1f(Uint32 ctx, GLenum target, GLfloat s )
{
	D(bug("nfosmesa: glMultiTexCoord1f"));
	SelectContext(ctx);
	fn.glMultiTexCoord1f(  target,  s );
}

void OSMesaDriver::glMultiTexCoord1fv(Uint32 ctx, GLenum target, const GLfloat *v )
{
	D(bug("nfosmesa: glMultiTexCoord1fv"));
	SelectContext(ctx);
	fn.glMultiTexCoord1fv(  target,  v );
}

void OSMesaDriver::glMultiTexCoord1i(Uint32 ctx, GLenum target, GLint s )
{
	D(bug("nfosmesa: glMultiTexCoord1i"));
	SelectContext(ctx);
	fn.glMultiTexCoord1i(  target,  s );
}

void OSMesaDriver::glMultiTexCoord1iv(Uint32 ctx, GLenum target, const GLint *v )
{
	D(bug("nfosmesa: glMultiTexCoord1iv"));
	SelectContext(ctx);
	fn.glMultiTexCoord1iv(  target,  v );
}

void OSMesaDriver::glMultiTexCoord1s(Uint32 ctx, GLenum target, GLshort s )
{
	D(bug("nfosmesa: glMultiTexCoord1s"));
	SelectContext(ctx);
	fn.glMultiTexCoord1s(  target,  s );
}

void OSMesaDriver::glMultiTexCoord1sv(Uint32 ctx, GLenum target, const GLshort *v )
{
	D(bug("nfosmesa: glMultiTexCoord1sv"));
	SelectContext(ctx);
	fn.glMultiTexCoord1sv(  target,  v );
}

void OSMesaDriver::glMultiTexCoord2d(Uint32 ctx, GLenum target, GLdouble s, GLdouble t )
{
	D(bug("nfosmesa: glMultiTexCoord2d"));
	SelectContext(ctx);
	fn.glMultiTexCoord2d(  target,  s,  t );
}

void OSMesaDriver::glMultiTexCoord2dv(Uint32 ctx, GLenum target, const GLdouble *v )
{
	D(bug("nfosmesa: glMultiTexCoord2dv"));
	SelectContext(ctx);
	fn.glMultiTexCoord2dv(  target,  v );
}

void OSMesaDriver::glMultiTexCoord2f(Uint32 ctx, GLenum target, GLfloat s, GLfloat t )
{
	D(bug("nfosmesa: glMultiTexCoord2f"));
	SelectContext(ctx);
	fn.glMultiTexCoord2f(  target,  s,  t );
}

void OSMesaDriver::glMultiTexCoord2fv(Uint32 ctx, GLenum target, const GLfloat *v )
{
	D(bug("nfosmesa: glMultiTexCoord2fv"));
	SelectContext(ctx);
	fn.glMultiTexCoord2fv(  target,  v );
}

void OSMesaDriver::glMultiTexCoord2i(Uint32 ctx, GLenum target, GLint s, GLint t )
{
	D(bug("nfosmesa: glMultiTexCoord2i"));
	SelectContext(ctx);
	fn.glMultiTexCoord2i(  target,  s,  t );
}

void OSMesaDriver::glMultiTexCoord2iv(Uint32 ctx, GLenum target, const GLint *v )
{
	D(bug("nfosmesa: glMultiTexCoord2iv"));
	SelectContext(ctx);
	fn.glMultiTexCoord2iv(  target,  v );
}

void OSMesaDriver::glMultiTexCoord2s(Uint32 ctx, GLenum target, GLshort s, GLshort t )
{
	D(bug("nfosmesa: glMultiTexCoord2s"));
	SelectContext(ctx);
	fn.glMultiTexCoord2s(  target,  s,  t );
}

void OSMesaDriver::glMultiTexCoord2sv(Uint32 ctx, GLenum target, const GLshort *v )
{
	D(bug("nfosmesa: glMultiTexCoord2sv"));
	SelectContext(ctx);
	fn.glMultiTexCoord2sv(  target,  v );
}

void OSMesaDriver::glMultiTexCoord3d(Uint32 ctx, GLenum target, GLdouble s, GLdouble t, GLdouble r )
{
	D(bug("nfosmesa: glMultiTexCoord3d"));
	SelectContext(ctx);
	fn.glMultiTexCoord3d(  target,  s,  t,  r );
}

void OSMesaDriver::glMultiTexCoord3dv(Uint32 ctx, GLenum target, const GLdouble *v )
{
	D(bug("nfosmesa: glMultiTexCoord3dv"));
	SelectContext(ctx);
	fn.glMultiTexCoord3dv(  target,  v );
}

void OSMesaDriver::glMultiTexCoord3f(Uint32 ctx, GLenum target, GLfloat s, GLfloat t, GLfloat r )
{
	D(bug("nfosmesa: glMultiTexCoord3f"));
	SelectContext(ctx);
	fn.glMultiTexCoord3f(  target,  s,  t,  r );
}

void OSMesaDriver::glMultiTexCoord3fv(Uint32 ctx, GLenum target, const GLfloat *v )
{
	D(bug("nfosmesa: glMultiTexCoord3fv"));
	SelectContext(ctx);
	fn.glMultiTexCoord3fv(  target,  v );
}

void OSMesaDriver::glMultiTexCoord3i(Uint32 ctx, GLenum target, GLint s, GLint t, GLint r )
{
	D(bug("nfosmesa: glMultiTexCoord3i"));
	SelectContext(ctx);
	fn.glMultiTexCoord3i(  target,  s,  t,  r );
}

void OSMesaDriver::glMultiTexCoord3iv(Uint32 ctx, GLenum target, const GLint *v )
{
	D(bug("nfosmesa: glMultiTexCoord3iv"));
	SelectContext(ctx);
	fn.glMultiTexCoord3iv(  target,  v );
}

void OSMesaDriver::glMultiTexCoord3s(Uint32 ctx, GLenum target, GLshort s, GLshort t, GLshort r )
{
	D(bug("nfosmesa: glMultiTexCoord3s"));
	SelectContext(ctx);
	fn.glMultiTexCoord3s(  target,  s,  t,  r );
}

void OSMesaDriver::glMultiTexCoord3sv(Uint32 ctx, GLenum target, const GLshort *v )
{
	D(bug("nfosmesa: glMultiTexCoord3sv"));
	SelectContext(ctx);
	fn.glMultiTexCoord3sv(  target,  v );
}

void OSMesaDriver::glMultiTexCoord4d(Uint32 ctx, GLenum target, GLdouble s, GLdouble t, GLdouble r, GLdouble q )
{
	D(bug("nfosmesa: glMultiTexCoord4d"));
	SelectContext(ctx);
	fn.glMultiTexCoord4d(  target,  s,  t,  r,  q );
}

void OSMesaDriver::glMultiTexCoord4dv(Uint32 ctx, GLenum target, const GLdouble *v )
{
	D(bug("nfosmesa: glMultiTexCoord4dv"));
	SelectContext(ctx);
	fn.glMultiTexCoord4dv(  target,  v );
}

void OSMesaDriver::glMultiTexCoord4f(Uint32 ctx, GLenum target, GLfloat s, GLfloat t, GLfloat r, GLfloat q )
{
	D(bug("nfosmesa: glMultiTexCoord4f"));
	SelectContext(ctx);
	fn.glMultiTexCoord4f(  target,  s,  t,  r,  q );
}

void OSMesaDriver::glMultiTexCoord4fv(Uint32 ctx, GLenum target, const GLfloat *v )
{
	D(bug("nfosmesa: glMultiTexCoord4fv"));
	SelectContext(ctx);
	fn.glMultiTexCoord4fv(  target,  v );
}

void OSMesaDriver::glMultiTexCoord4i(Uint32 ctx, GLenum target, GLint s, GLint t, GLint r, GLint q )
{
	D(bug("nfosmesa: glMultiTexCoord4i"));
	SelectContext(ctx);
	fn.glMultiTexCoord4i(  target,  s,  t,  r,  q );
}

void OSMesaDriver::glMultiTexCoord4iv(Uint32 ctx, GLenum target, const GLint *v )
{
	D(bug("nfosmesa: glMultiTexCoord4iv"));
	SelectContext(ctx);
	fn.glMultiTexCoord4iv(  target,  v );
}

void OSMesaDriver::glMultiTexCoord4s(Uint32 ctx, GLenum target, GLshort s, GLshort t, GLshort r, GLshort q )
{
	D(bug("nfosmesa: glMultiTexCoord4s"));
	SelectContext(ctx);
	fn.glMultiTexCoord4s(  target,  s,  t,  r,  q );
}

void OSMesaDriver::glMultiTexCoord4sv(Uint32 ctx, GLenum target, const GLshort *v )
{
	D(bug("nfosmesa: glMultiTexCoord4sv"));
	SelectContext(ctx);
	fn.glMultiTexCoord4sv(  target,  v );
}

void OSMesaDriver::glLoadTransposeMatrixd(Uint32 ctx, const GLdouble m[16] )
{
	D(bug("nfosmesa: glLoadTransposeMatrixd"));
	SelectContext(ctx);
	fn.glLoadTransposeMatrixd( const GLdouble m[16] );
}

void OSMesaDriver::glLoadTransposeMatrixf(Uint32 ctx, const GLfloat m[16] )
{
	D(bug("nfosmesa: glLoadTransposeMatrixf"));
	SelectContext(ctx);
	fn.glLoadTransposeMatrixf( const GLfloat m[16] );
}

void OSMesaDriver::glMultTransposeMatrixd(Uint32 ctx, const GLdouble m[16] )
{
	D(bug("nfosmesa: glMultTransposeMatrixd"));
	SelectContext(ctx);
	fn.glMultTransposeMatrixd( const GLdouble m[16] );
}

void OSMesaDriver::glMultTransposeMatrixf(Uint32 ctx, const GLfloat m[16] )
{
	D(bug("nfosmesa: glMultTransposeMatrixf"));
	SelectContext(ctx);
	fn.glMultTransposeMatrixf( const GLfloat m[16] );
}

void OSMesaDriver::glSampleCoverage(Uint32 ctx, GLclampf value, GLboolean invert )
{
	D(bug("nfosmesa: glSampleCoverage"));
	SelectContext(ctx);
	fn.glSampleCoverage(  value,  invert );
}

void OSMesaDriver::glActiveTextureARB(Uint32 ctx,GLenum texture)
{
	D(bug("nfosmesa: glActiveTextureARB"));
	SelectContext(ctx);
	fn.glActiveTextureARB( texture);
}

void OSMesaDriver::glClientActiveTextureARB(Uint32 ctx,GLenum texture)
{
	D(bug("nfosmesa: glClientActiveTextureARB"));
	SelectContext(ctx);
	fn.glClientActiveTextureARB( texture);
}

void OSMesaDriver::glMultiTexCoord1dARB(Uint32 ctx,GLenum target, GLdouble s)
{
	D(bug("nfosmesa: glMultiTexCoord1dARB"));
	SelectContext(ctx);
	fn.glMultiTexCoord1dARB( target,  s);
}

void OSMesaDriver::glMultiTexCoord1dvARB(Uint32 ctx,GLenum target, const GLdouble *v)
{
	D(bug("nfosmesa: glMultiTexCoord1dvARB"));
	SelectContext(ctx);
	fn.glMultiTexCoord1dvARB( target,  v);
}

void OSMesaDriver::glMultiTexCoord1fARB(Uint32 ctx,GLenum target, GLfloat s)
{
	D(bug("nfosmesa: glMultiTexCoord1fARB"));
	SelectContext(ctx);
	fn.glMultiTexCoord1fARB( target,  s);
}

void OSMesaDriver::glMultiTexCoord1fvARB(Uint32 ctx,GLenum target, const GLfloat *v)
{
	D(bug("nfosmesa: glMultiTexCoord1fvARB"));
	SelectContext(ctx);
	fn.glMultiTexCoord1fvARB( target,  v);
}

void OSMesaDriver::glMultiTexCoord1iARB(Uint32 ctx,GLenum target, GLint s)
{
	D(bug("nfosmesa: glMultiTexCoord1iARB"));
	SelectContext(ctx);
	fn.glMultiTexCoord1iARB( target,  s);
}

void OSMesaDriver::glMultiTexCoord1ivARB(Uint32 ctx,GLenum target, const GLint *v)
{
	D(bug("nfosmesa: glMultiTexCoord1ivARB"));
	SelectContext(ctx);
	fn.glMultiTexCoord1ivARB( target,  v);
}

void OSMesaDriver::glMultiTexCoord1sARB(Uint32 ctx,GLenum target, GLshort s)
{
	D(bug("nfosmesa: glMultiTexCoord1sARB"));
	SelectContext(ctx);
	fn.glMultiTexCoord1sARB( target,  s);
}

void OSMesaDriver::glMultiTexCoord1svARB(Uint32 ctx,GLenum target, const GLshort *v)
{
	D(bug("nfosmesa: glMultiTexCoord1svARB"));
	SelectContext(ctx);
	fn.glMultiTexCoord1svARB( target,  v);
}

void OSMesaDriver::glMultiTexCoord2dARB(Uint32 ctx,GLenum target, GLdouble s, GLdouble t)
{
	D(bug("nfosmesa: glMultiTexCoord2dARB"));
	SelectContext(ctx);
	fn.glMultiTexCoord2dARB( target,  s,  t);
}

void OSMesaDriver::glMultiTexCoord2dvARB(Uint32 ctx,GLenum target, const GLdouble *v)
{
	D(bug("nfosmesa: glMultiTexCoord2dvARB"));
	SelectContext(ctx);
	fn.glMultiTexCoord2dvARB( target,  v);
}

void OSMesaDriver::glMultiTexCoord2fARB(Uint32 ctx,GLenum target, GLfloat s, GLfloat t)
{
	D(bug("nfosmesa: glMultiTexCoord2fARB"));
	SelectContext(ctx);
	fn.glMultiTexCoord2fARB( target,  s,  t);
}

void OSMesaDriver::glMultiTexCoord2fvARB(Uint32 ctx,GLenum target, const GLfloat *v)
{
	D(bug("nfosmesa: glMultiTexCoord2fvARB"));
	SelectContext(ctx);
	fn.glMultiTexCoord2fvARB( target,  v);
}

void OSMesaDriver::glMultiTexCoord2iARB(Uint32 ctx,GLenum target, GLint s, GLint t)
{
	D(bug("nfosmesa: glMultiTexCoord2iARB"));
	SelectContext(ctx);
	fn.glMultiTexCoord2iARB( target,  s,  t);
}

void OSMesaDriver::glMultiTexCoord2ivARB(Uint32 ctx,GLenum target, const GLint *v)
{
	D(bug("nfosmesa: glMultiTexCoord2ivARB"));
	SelectContext(ctx);
	fn.glMultiTexCoord2ivARB( target,  v);
}

void OSMesaDriver::glMultiTexCoord2sARB(Uint32 ctx,GLenum target, GLshort s, GLshort t)
{
	D(bug("nfosmesa: glMultiTexCoord2sARB"));
	SelectContext(ctx);
	fn.glMultiTexCoord2sARB( target,  s,  t);
}

void OSMesaDriver::glMultiTexCoord2svARB(Uint32 ctx,GLenum target, const GLshort *v)
{
	D(bug("nfosmesa: glMultiTexCoord2svARB"));
	SelectContext(ctx);
	fn.glMultiTexCoord2svARB( target,  v);
}

void OSMesaDriver::glMultiTexCoord3dARB(Uint32 ctx,GLenum target, GLdouble s, GLdouble t, GLdouble r)
{
	D(bug("nfosmesa: glMultiTexCoord3dARB"));
	SelectContext(ctx);
	fn.glMultiTexCoord3dARB( target,  s,  t,  r);
}

void OSMesaDriver::glMultiTexCoord3dvARB(Uint32 ctx,GLenum target, const GLdouble *v)
{
	D(bug("nfosmesa: glMultiTexCoord3dvARB"));
	SelectContext(ctx);
	fn.glMultiTexCoord3dvARB( target,  v);
}

void OSMesaDriver::glMultiTexCoord3fARB(Uint32 ctx,GLenum target, GLfloat s, GLfloat t, GLfloat r)
{
	D(bug("nfosmesa: glMultiTexCoord3fARB"));
	SelectContext(ctx);
	fn.glMultiTexCoord3fARB( target,  s,  t,  r);
}

void OSMesaDriver::glMultiTexCoord3fvARB(Uint32 ctx,GLenum target, const GLfloat *v)
{
	D(bug("nfosmesa: glMultiTexCoord3fvARB"));
	SelectContext(ctx);
	fn.glMultiTexCoord3fvARB( target,  v);
}

void OSMesaDriver::glMultiTexCoord3iARB(Uint32 ctx,GLenum target, GLint s, GLint t, GLint r)
{
	D(bug("nfosmesa: glMultiTexCoord3iARB"));
	SelectContext(ctx);
	fn.glMultiTexCoord3iARB( target,  s,  t,  r);
}

void OSMesaDriver::glMultiTexCoord3ivARB(Uint32 ctx,GLenum target, const GLint *v)
{
	D(bug("nfosmesa: glMultiTexCoord3ivARB"));
	SelectContext(ctx);
	fn.glMultiTexCoord3ivARB( target,  v);
}

void OSMesaDriver::glMultiTexCoord3sARB(Uint32 ctx,GLenum target, GLshort s, GLshort t, GLshort r)
{
	D(bug("nfosmesa: glMultiTexCoord3sARB"));
	SelectContext(ctx);
	fn.glMultiTexCoord3sARB( target,  s,  t,  r);
}

void OSMesaDriver::glMultiTexCoord3svARB(Uint32 ctx,GLenum target, const GLshort *v)
{
	D(bug("nfosmesa: glMultiTexCoord3svARB"));
	SelectContext(ctx);
	fn.glMultiTexCoord3svARB( target,  v);
}

void OSMesaDriver::glMultiTexCoord4dARB(Uint32 ctx,GLenum target, GLdouble s, GLdouble t, GLdouble r, GLdouble q)
{
	D(bug("nfosmesa: glMultiTexCoord4dARB"));
	SelectContext(ctx);
	fn.glMultiTexCoord4dARB( target,  s,  t,  r,  q);
}

void OSMesaDriver::glMultiTexCoord4dvARB(Uint32 ctx,GLenum target, const GLdouble *v)
{
	D(bug("nfosmesa: glMultiTexCoord4dvARB"));
	SelectContext(ctx);
	fn.glMultiTexCoord4dvARB( target,  v);
}

void OSMesaDriver::glMultiTexCoord4fARB(Uint32 ctx,GLenum target, GLfloat s, GLfloat t, GLfloat r, GLfloat q)
{
	D(bug("nfosmesa: glMultiTexCoord4fARB"));
	SelectContext(ctx);
	fn.glMultiTexCoord4fARB( target,  s,  t,  r,  q);
}

void OSMesaDriver::glMultiTexCoord4fvARB(Uint32 ctx,GLenum target, const GLfloat *v)
{
	D(bug("nfosmesa: glMultiTexCoord4fvARB"));
	SelectContext(ctx);
	fn.glMultiTexCoord4fvARB( target,  v);
}

void OSMesaDriver::glMultiTexCoord4iARB(Uint32 ctx,GLenum target, GLint s, GLint t, GLint r, GLint q)
{
	D(bug("nfosmesa: glMultiTexCoord4iARB"));
	SelectContext(ctx);
	fn.glMultiTexCoord4iARB( target,  s,  t,  r,  q);
}

void OSMesaDriver::glMultiTexCoord4ivARB(Uint32 ctx,GLenum target, const GLint *v)
{
	D(bug("nfosmesa: glMultiTexCoord4ivARB"));
	SelectContext(ctx);
	fn.glMultiTexCoord4ivARB( target,  v);
}

void OSMesaDriver::glMultiTexCoord4sARB(Uint32 ctx,GLenum target, GLshort s, GLshort t, GLshort r, GLshort q)
{
	D(bug("nfosmesa: glMultiTexCoord4sARB"));
	SelectContext(ctx);
	fn.glMultiTexCoord4sARB( target,  s,  t,  r,  q);
}

void OSMesaDriver::glMultiTexCoord4svARB(Uint32 ctx,GLenum target, const GLshort *v)
{
	D(bug("nfosmesa: glMultiTexCoord4svARB"));
	SelectContext(ctx);
	fn.glMultiTexCoord4svARB( target,  v);
}
*/

void OSMesaDriver::glEnableTraceMESA(Uint32 ctx, GLbitfield mask )
{
	D(bug("nfosmesa: glEnableTraceMESA"));
	SelectContext(ctx);
	fn.glEnableTraceMESA(  mask );
}

void OSMesaDriver::glDisableTraceMESA(Uint32 ctx, GLbitfield mask )
{
	D(bug("nfosmesa: glDisableTraceMESA"));
	SelectContext(ctx);
	fn.glDisableTraceMESA(  mask );
}

void OSMesaDriver::glNewTraceMESA(Uint32 ctx, GLbitfield mask, const GLubyte * traceName )
{
	D(bug("nfosmesa: glNewTraceMESA"));
	SelectContext(ctx);
	fn.glNewTraceMESA(  mask,  traceName );
}

void OSMesaDriver::glEndTraceMESA(Uint32 ctx)
{
	D(bug("nfosmesa: glEndTraceMESA"));
	SelectContext(ctx);
	fn.glEndTraceMESA(  );
}

void OSMesaDriver::glTraceAssertAttribMESA(Uint32 ctx, GLbitfield attribMask )
{
	D(bug("nfosmesa: glTraceAssertAttribMESA"));
	SelectContext(ctx);
	fn.glTraceAssertAttribMESA(  attribMask );
}

void OSMesaDriver::glTraceCommentMESA(Uint32 ctx, const GLubyte * comment )
{
	D(bug("nfosmesa: glTraceCommentMESA"));
	SelectContext(ctx);
	fn.glTraceCommentMESA(  comment );
}

void OSMesaDriver::glTraceTextureMESA(Uint32 ctx, GLuint name, const GLubyte* comment )
{
	D(bug("nfosmesa: glTraceTextureMESA"));
	SelectContext(ctx);
	fn.glTraceTextureMESA(  name,  comment );
}

void OSMesaDriver::glTraceListMESA(Uint32 ctx, GLuint name, const GLubyte* comment )
{
	D(bug("nfosmesa: glTraceListMESA"));
	SelectContext(ctx);
	fn.glTraceListMESA(  name,  comment );
}

void OSMesaDriver::glTracePointerMESA(Uint32 ctx, GLvoid* pointer, const GLubyte* comment )
{
	D(bug("nfosmesa: glTracePointerMESA"));
	SelectContext(ctx);
	fn.glTracePointerMESA(  pointer,  comment );
}

void OSMesaDriver::glTracePointerRangeMESA(Uint32 ctx, const GLvoid* first, const GLvoid* last, const GLubyte* comment )
{
	D(bug("nfosmesa: glTracePointerRangeMESA"));
	SelectContext(ctx);
	fn.glTracePointerRangeMESA(  first,  last,  comment );
}

void OSMesaDriver::glBlendEquationSeparateATI(Uint32 ctx, GLenum modeRGB, GLenum modeA )
{
	D(bug("nfosmesa: glBlendEquationSeparateATI"));
	SelectContext(ctx);
	fn.glBlendEquationSeparateATI(  modeRGB,  modeA );
}

/* Functions generated: 465 */
