# sendmail-mailx.sh: send email with sendmail ala POSIX mailx
# 
################################################################
# Copyright (C) 2002 Tom Lord
# 
# See the file "COPYING" for further information about
# the copyright and warranty status of this work.
# 

set -e 

command_line="$*"

################################################################
# special options
# 
# Some options are special:
# 
#       --version | -V
#       --help | -h
# 
if test $# -ne 0 ; then

  for opt in "$@" ; do
    case $opt in

      --version|-V) exec larch --version
                    ;;


      --help|-h)
                printf "send email with sendmail ala POSIX mailx\\n"
                printf "usage: sendmail-mailx [options] recipient"
                printf "\\n"
                printf " -V --version                  print version info\\n"
                printf " -h --help                     display help\\n"
                printf "\\n"
		printf " -s SUBJECT                    set the message subject\\n"
                printf "\\n"
		printf "Send an email notice to RECIPIENT about the newly created\\n"
                printf "\\n"
                exit 0
                ;;

      *)
                ;;
    esac
  done
fi
################################################################
# Ordinary Options
# 
# 

subject="(no subject provided)"

while test $# -ne 0 ; do

  case "$1" in 

    -s)			shift
    			if test $# -eq 0 ; then
			  printf "sendmail-mailx: -s requires an argument\\n" 1>&2
			  printf "try --help\\n" 1>&2
			  exit 1
			fi
			subject="$1"
			shift
			;;

    --)			shift
    			break
			;;

    -*)                 printf "sendmail-mailx: unrecognized option (%s)\\n" "$1" 1>&2
                        printf "try --help\\n" 1>&2
                        exit 1
                        ;;

    *)                  break
                        ;;
  esac

done



################################################################
# Ordinary Arguments
# 

if test $# -ne 1 ; then
  printf "usage: sendmail-mailx [options] recipient\\n" 1>&2
  printf "try --help\\n" 1>&2
  exit 1
fi

recipient="$1"
shift

################################################################
# Send Email
# 

( printf "To: %s\\n" "$recipient" ; \
  printf "Subject: %s\\n" "$subject" ; \
  printf "\\n" ; \
  cat ) \
| $ARCH_SENDMAIL -t


# tag: Tom Lord Sun Jan 20 05:17:53 2002 (notify/sendmail-mailx.sh)
#
