# -*- coding: iso-8859-15 -*-
# generated by wxGlade HG on Tue May 19 21:48:13 2009

#
# ArcJobToolWindow main window class
#

"""
Implements the arcgui main window.
"""

import wx
from wx.lib.dialogs import *


# begin wxGlade: dependencies
# end wxGlade

# begin wxGlade: extracode

# end wxGlade

import sys, shutil

from datetime import datetime

try:
    import arc
except:
    print "ARC1 Python binding not found. Please check search paths."
    sys.exit(-1)

import os, sys, threading, types, shutil

# ArcGUI imports

from arcjobtool.plugins.Plugins import PluginManager

from arcjobtool.ArcUtils import ArcClient, ManagedJobDescription
from arcjobtool.AddOutputFileDialog import AddOutputFileDialog
from arcjobtool.ArcSplash import ArcSplash
from arcjobtool.ClientSettingsDialog import ClientSettingsDialog
from arcjobtool.CertificateInfoWindow import *
from arcjobtool.DefaultServicesDialog import DefaultServicesDialog
from arcjobtool.JobPropertiesDialog import JobPropertiesDialog
from arcjobtool.ProxyDialog import *
from arcjobtool.PlatformUtils import *
from arcjobtool.ArcGuiThreads import *

import arcjobtool.Tasks

class GuiUserAuthentication(UserAuthentication):
    """
    User authentication class with graphical login dialog.
    
    The parentWindow property should be set before the passphrase dialog
    is shown.
    """
    def __init__(self, userConfig):
        """
        Class constructor
        
        Initialises parentWindow property to None.
        """
        UserAuthentication.__init__(self, userConfig)
        self.parentWindow = None
        
    def onPassphrasePrompt(self, prompt=""):
        """
        Passphrase callback (virtual)
        
        Shows a proxy passphrase dialog.
        """
        proxyDialog = ProxyDialog(self.parentWindow)
        proxyDialog.ShowModal()
        if proxyDialog.dialogResult:
            self.period = proxyDialog.proxyLifetime
            self.proxyType = proxyDialog.proxyType
            passphrase = proxyDialog.passphrase
            proxyDialog.Destroy()
            return passphrase
        else:
            proxyDialog.Destroy()
            return ""

class ArcJobToolWindow(wx.Frame):
    """
    Main frame class for arcjobtool.
    """
    def __init__(self, *args, **kwds):
        
        self.__applicationDir = os.path.dirname(sys.argv[0])

        if os.environ.has_key("ARCJOBTOOL_SHARE"):
            self.__imageDir = os.path.join(os.environ["ARCJOBTOOL_SHARE"], "images")
        else:
            self.__imageDir = os.path.join(self.__applicationDir, "../share/arcjobtool/images")
        
        ARCJOBTOOL_NEW_DEFINITON_IMAGE = os.path.join(self.__imageDir, "document-new.png")
        ARCJOBTOOL_EDIT_DEFINITON_IMAGE = os.path.join(self.__imageDir, "gtk-edit.png")
        ARCJOBTOOL_SUBMIT_DEFINITION_IMAGE = os.path.join(self.__imageDir, "system-run.png")
        ARCJOBTOOL_OPEN_RESULTS_IMAGE = os.path.join(self.__imageDir, "folder-open.png")
        ARCJOBTOOL_DELETE_DEFINITION_IMAGE = os.path.join(self.__imageDir, "edit-delete.png")
        ARCJOBTOOL_VIEW_DESCRIPTION = os.path.join(self.__imageDir, "preview-xrsl.png")
        ARCJOBTOOL_REFRESH_JOBS_IMAGE = os.path.join(self.__imageDir, "view-refresh.png")
        ARCJOBTOOL_JOB_INFO_IMAGE = os.path.join(self.__imageDir, "edit-find.png")
        ARCJOBTOOL_DOWNLOAD_JOB_IMAGE = os.path.join(self.__imageDir, "download-job.png")
        ARCJOBTOOL_DOWNLOAD_ALL_IMAGE = os.path.join(self.__imageDir, "download-all.png")
        ARCJOBTOOL_KILL_JOB_BUTTON = os.path.join(self.__imageDir, "process-stop.png")
        ARCJOBTOOL_KILL_THREADS_BUTTON = os.path.join(self.__imageDir, "kill-threads.png")
        ARCJOBTOOL_CLEAN_JOB_BUTTON = os.path.join(self.__imageDir, "edit-delete.png")
        ARCJOBTOOL_REMOVE_DOWNLOADED_JOB_IMAGE = os.path.join(self.__imageDir, "edit-delete.png")
        ARCJOBTOOL_OPEN_URL = os.path.join(self.__imageDir, "folder-open.png")
        
        # begin wxGlade: ArcJobToolWindow.__init__
        kwds["style"] = wx.DEFAULT_FRAME_STYLE
        wx.Frame.__init__(self, *args, **kwds)
        
        # Menu Bar
        self.mainMenuBar = wx.MenuBar()
        self.fileMenu = wx.Menu()
        self.changeWorkingDirMenu = wx.MenuItem(self.fileMenu, wx.NewId(), "Change working directory...\tCtrl+O", "", wx.ITEM_NORMAL)
        self.fileMenu.AppendItem(self.changeWorkingDirMenu)
        self.fileExitMenu = wx.MenuItem(self.fileMenu, wx.NewId(), "&Quit\tCtrl+Q", "", wx.ITEM_NORMAL)
        self.fileMenu.AppendItem(self.fileExitMenu)
        self.mainMenuBar.Append(self.fileMenu, "&File")
        self.sessionMenu = wx.Menu()
        self.sessionCertProxyInfoMenu = wx.MenuItem(self.sessionMenu, wx.NewId(), "&Cert/Proxy information... \tF2", "", wx.ITEM_NORMAL)
        self.sessionMenu.AppendItem(self.sessionCertProxyInfoMenu)
        self.sessionCreateProxyMenu = wx.MenuItem(self.sessionMenu, wx.NewId(), "Create new &proxy certificate...\tCtrl+L", "", wx.ITEM_NORMAL)
        self.sessionMenu.AppendItem(self.sessionCreateProxyMenu)
        self.mainMenuBar.Append(self.sessionMenu, "&Session")
        self.definitionMenu = wx.Menu()
        self.newJobDefinitionMenu = wx.MenuItem(self.definitionMenu, wx.NewId(), "&New...\tCtrl+N", "", wx.ITEM_NORMAL)
        self.definitionMenu.AppendItem(self.newJobDefinitionMenu)
        self.modifyDefinitionMenu = wx.MenuItem(self.definitionMenu, wx.NewId(), "&Modify...\tCtrl+E", "", wx.ITEM_NORMAL)
        self.definitionMenu.AppendItem(self.modifyDefinitionMenu)
        self.submitJobDefinitionMenu = wx.MenuItem(self.definitionMenu, wx.NewId(), "&Submit\tF7", "", wx.ITEM_NORMAL)
        self.definitionMenu.AppendItem(self.submitJobDefinitionMenu)
        self.submittMissingMenu = wx.MenuItem(self.definitionMenu, wx.NewId(), "Submit &missing\tF8", "", wx.ITEM_NORMAL)
        self.definitionMenu.AppendItem(self.submittMissingMenu)
        self.viewResultsMenu = wx.MenuItem(self.definitionMenu, wx.NewId(), "&View result files", "", wx.ITEM_NORMAL)
        self.definitionMenu.AppendItem(self.viewResultsMenu)
        self.cleanResultsMenu = wx.MenuItem(self.definitionMenu, wx.NewId(), "&Clean results", "", wx.ITEM_NORMAL)
        self.definitionMenu.AppendItem(self.cleanResultsMenu)
        self.deleteJobDefinitionMenu = wx.MenuItem(self.definitionMenu, wx.NewId(), "&Delete\tDel", "", wx.ITEM_NORMAL)
        self.definitionMenu.AppendItem(self.deleteJobDefinitionMenu)
        self.viewXRSLMenu = wx.MenuItem(self.definitionMenu, wx.NewId(), "View &XRSL...", "", wx.ITEM_NORMAL)
        self.definitionMenu.AppendItem(self.viewXRSLMenu)
        self.mainMenuBar.Append(self.definitionMenu, "&Definitions")
        self.jobsMenu = wx.Menu()
        self.refreshStatusMenu = wx.MenuItem(self.jobsMenu, wx.NewId(), "&Refresh status\tCtrl+R", "", wx.ITEM_NORMAL)
        self.jobsMenu.AppendItem(self.refreshStatusMenu)
        self.donwloadSelectedMenu = wx.MenuItem(self.jobsMenu, wx.NewId(), "&Download selected...", "", wx.ITEM_NORMAL)
        self.jobsMenu.AppendItem(self.donwloadSelectedMenu)
        self.downloadToDefinitionMenu = wx.MenuItem(self.jobsMenu, wx.NewId(), "Download &all...", "", wx.ITEM_NORMAL)
        self.jobsMenu.AppendItem(self.downloadToDefinitionMenu)
        self.killSelectedMenu = wx.MenuItem(self.jobsMenu, wx.NewId(), "&Kill selected", "", wx.ITEM_NORMAL)
        self.jobsMenu.AppendItem(self.killSelectedMenu)
        self.cleanSelectedMenu = wx.MenuItem(self.jobsMenu, wx.NewId(), "&Clean selected", "", wx.ITEM_NORMAL)
        self.jobsMenu.AppendItem(self.cleanSelectedMenu)
        self.remoteFromJobListMenu = wx.MenuItem(self.jobsMenu, wx.NewId(), "&Remove from job list", "", wx.ITEM_NORMAL)
        self.jobsMenu.AppendItem(self.remoteFromJobListMenu)
        self.mainMenuBar.Append(self.jobsMenu, "&Jobs")
        self.settingsMenu = wx.Menu()
        self.clientSettingsMenu = wx.MenuItem(self.settingsMenu, wx.NewId(), "&Client...\tF3", "", wx.ITEM_NORMAL)
        self.settingsMenu.AppendItem(self.clientSettingsMenu)
        self.servicesSettingsMenu = wx.MenuItem(self.settingsMenu, wx.NewId(), "&Services...\tF4", "", wx.ITEM_NORMAL)
        self.settingsMenu.AppendItem(self.servicesSettingsMenu)
        self.mainMenuBar.Append(self.settingsMenu, "Settings")
        self.helpMenu = wx.Menu()
        self.helpAboutArcGuiMenu = wx.MenuItem(self.helpMenu, wx.NewId(), "&About ARC Job Submission Tool...\tF1", "", wx.ITEM_NORMAL)
        self.helpMenu.AppendItem(self.helpAboutArcGuiMenu)
        self.mainMenuBar.Append(self.helpMenu, "&Help")
        self.SetMenuBar(self.mainMenuBar)
        # Menu Bar end
        self.window_1 = wx.SplitterWindow(self, -1, style=wx.SP_3D|wx.SP_BORDER|wx.SP_LIVE_UPDATE)
        self.mainPanel = wx.Panel(self.window_1, -1)
        self.noteBook = wx.Notebook(self.mainPanel, -1, style=0)
        self.jobDefinitionPane = wx.Panel(self.noteBook, -1)
        self.newDefinitionButton = wx.BitmapButton(self.jobDefinitionPane, -1, wx.Bitmap(ARCJOBTOOL_NEW_DEFINITON_IMAGE,wx.BITMAP_TYPE_ANY), style=wx.NO_BORDER)
        self.editDefinitionButton = wx.BitmapButton(self.jobDefinitionPane, -1, wx.Bitmap(ARCJOBTOOL_EDIT_DEFINITON_IMAGE,wx.BITMAP_TYPE_ANY), style=wx.NO_BORDER)
        self.submitDefinitionButton = wx.BitmapButton(self.jobDefinitionPane, -1, wx.Bitmap(ARCJOBTOOL_SUBMIT_DEFINITION_IMAGE,wx.BITMAP_TYPE_ANY), style=wx.NO_BORDER)
        self.openResultsButton = wx.BitmapButton(self.jobDefinitionPane, -1, wx.Bitmap(ARCJOBTOOL_OPEN_RESULTS_IMAGE,wx.BITMAP_TYPE_ANY), style=wx.NO_BORDER)
        self.deleteDefinitionButton = wx.BitmapButton(self.jobDefinitionPane, -1, wx.Bitmap(ARCJOBTOOL_DELETE_DEFINITION_IMAGE,wx.BITMAP_TYPE_ANY), style=wx.NO_BORDER)
        self.viewDescriptionButton = wx.BitmapButton(self.jobDefinitionPane, -1, wx.Bitmap(ARCJOBTOOL_VIEW_DESCRIPTION,wx.BITMAP_TYPE_ANY), style=wx.NO_BORDER)
        self.jobDefinitionList = wx.ListCtrl(self.jobDefinitionPane, -1, style=wx.LC_ICON|wx.LC_ALIGN_LEFT|wx.LC_AUTOARRANGE|wx.LC_SINGLE_SEL|wx.LC_SORT_ASCENDING|wx.LC_HRULES|wx.SUNKEN_BORDER)
        self.activeJobsPane = wx.Panel(self.noteBook, -1)
        self.refreshJobsButton = wx.BitmapButton(self.activeJobsPane, -1, wx.Bitmap(ARCJOBTOOL_REFRESH_JOBS_IMAGE,wx.BITMAP_TYPE_ANY), style=wx.NO_BORDER)
        self.jobPropertiesButton = wx.BitmapButton(self.activeJobsPane, -1, wx.Bitmap(ARCJOBTOOL_JOB_INFO_IMAGE,wx.BITMAP_TYPE_ANY), style=wx.NO_BORDER)
        self.downloadJobButton = wx.BitmapButton(self.activeJobsPane, -1, wx.Bitmap(ARCJOBTOOL_DOWNLOAD_JOB_IMAGE,wx.BITMAP_TYPE_ANY), style=wx.NO_BORDER)
        self.downloadAllButton = wx.BitmapButton(self.activeJobsPane, -1, wx.Bitmap(ARCJOBTOOL_DOWNLOAD_ALL_IMAGE,wx.BITMAP_TYPE_ANY), style=wx.NO_BORDER)
        self.killJobButton = wx.BitmapButton(self.activeJobsPane, -1, wx.Bitmap(ARCJOBTOOL_KILL_JOB_BUTTON,wx.BITMAP_TYPE_ANY), style=wx.NO_BORDER)
        self.cleanJobButton = wx.BitmapButton(self.activeJobsPane, -1, wx.Bitmap(ARCJOBTOOL_CLEAN_JOB_BUTTON,wx.BITMAP_TYPE_ANY), style=wx.NO_BORDER)
        self.activeJobList = wx.ListCtrl(self.activeJobsPane, -1, style=wx.LC_REPORT|wx.LC_HRULES|wx.LC_VRULES|wx.SUNKEN_BORDER)
        self.downloadedJobsPane = wx.Panel(self.noteBook, -1)
        self.cleanDownloadedJobButton = wx.BitmapButton(self.downloadedJobsPane, -1, wx.Bitmap(ARCJOBTOOL_REMOVE_DOWNLOADED_JOB_IMAGE,wx.BITMAP_TYPE_ANY), style=wx.NO_BORDER)
        self.downloadedJobList = wx.ListCtrl(self.downloadedJobsPane, -1, style=wx.LC_REPORT|wx.LC_HRULES|wx.LC_VRULES|wx.SUNKEN_BORDER)
        self.noteBook_pane_4 = wx.Panel(self.noteBook, -1)
        self.label_3 = wx.StaticText(self.noteBook_pane_4, -1, "URL")
        self.text_ctrl_1 = wx.TextCtrl(self.noteBook_pane_4, -1, "")
        self.bitmap_button_1 = wx.BitmapButton(self.noteBook_pane_4, -1, wx.Bitmap(ARCJOBTOOL_OPEN_URL,wx.BITMAP_TYPE_ANY))
        self.jobDefinitionList_copy = wx.ListCtrl(self.noteBook_pane_4, -1, style=wx.LC_ICON|wx.LC_ALIGN_LEFT|wx.LC_AUTOARRANGE|wx.LC_SINGLE_SEL|wx.LC_SORT_ASCENDING|wx.LC_HRULES|wx.SUNKEN_BORDER)
        self.panel_1 = wx.Panel(self.window_1, -1)
        self.logOutputLabel = wx.StaticText(self.panel_1, -1, "Output")
        self.logOutputText = wx.TextCtrl(self.panel_1, -1, "", style=wx.TE_MULTILINE|wx.HSCROLL|wx.TE_RICH)
        self.static_line_3 = wx.StaticLine(self, -1)
        self.statusText = wx.TextCtrl(self, -1, "", style=wx.TE_READONLY)
        self.statusGauge = wx.Gauge(self, -1, 100)
        self.killThreadsButton = wx.BitmapButton(self, -1, wx.Bitmap(ARCJOBTOOL_KILL_THREADS_BUTTON,wx.BITMAP_TYPE_ANY), style=wx.NO_BORDER)

        self.__set_properties()
        self.__do_layout()

        self.Bind(wx.EVT_MENU, self.onChangeWorkingDir, self.changeWorkingDirMenu)
        self.Bind(wx.EVT_MENU, self.onFileExit, self.fileExitMenu)
        self.Bind(wx.EVT_MENU, self.onCertProxyInfo, self.sessionCertProxyInfoMenu)
        self.Bind(wx.EVT_MENU, self.onCreateProxyCert, self.sessionCreateProxyMenu)
        self.Bind(wx.EVT_MENU, self.onNewJobDefinition, self.newJobDefinitionMenu)
        self.Bind(wx.EVT_MENU, self.onOpenJobDefinition, self.modifyDefinitionMenu)
        self.Bind(wx.EVT_MENU, self.onSubmitJobDefinition, self.submitJobDefinitionMenu)
        self.Bind(wx.EVT_MENU, self.onSubmitMissing, self.submittMissingMenu)
        self.Bind(wx.EVT_MENU, self.onViewOutputFiles, self.viewResultsMenu)
        self.Bind(wx.EVT_MENU, self.onCleanResults, self.cleanResultsMenu)
        self.Bind(wx.EVT_MENU, self.onDeleteJobDefinition, self.deleteJobDefinitionMenu)
        self.Bind(wx.EVT_MENU, self.onShowXrslDescription, self.viewXRSLMenu)
        self.Bind(wx.EVT_MENU, self.onFind, self.refreshStatusMenu)
        self.Bind(wx.EVT_MENU, self.onRetrieve, self.donwloadSelectedMenu)
        self.Bind(wx.EVT_MENU, self.onDownloadToDefinition, self.downloadToDefinitionMenu)
        self.Bind(wx.EVT_MENU, self.onKill, self.killSelectedMenu)
        self.Bind(wx.EVT_MENU, self.onClean, self.cleanSelectedMenu)
        self.Bind(wx.EVT_MENU, self.onDeleteJobList, self.remoteFromJobListMenu)
        self.Bind(wx.EVT_MENU, self.onClientSettings, self.clientSettingsMenu)
        self.Bind(wx.EVT_MENU, self.onServicesSettings, self.servicesSettingsMenu)
        self.Bind(wx.EVT_MENU, self.onAbout, self.helpAboutArcGuiMenu)
        self.Bind(wx.EVT_BUTTON, self.onNewJobDefinition, self.newDefinitionButton)
        self.Bind(wx.EVT_BUTTON, self.onOpenJobDefinition, self.editDefinitionButton)
        self.Bind(wx.EVT_BUTTON, self.onSubmitJobDefinition, self.submitDefinitionButton)
        self.Bind(wx.EVT_BUTTON, self.onViewOutputFiles, self.openResultsButton)
        self.Bind(wx.EVT_BUTTON, self.onDeleteJobDefinition, self.deleteDefinitionButton)
        self.Bind(wx.EVT_BUTTON, self.onShowXrslDescription, self.viewDescriptionButton)
        self.Bind(wx.EVT_LIST_ITEM_DESELECTED, self.onJobDefinitionDeselected, self.jobDefinitionList)
        self.Bind(wx.EVT_LIST_ITEM_SELECTED, self.onJobDefinitionSelected, self.jobDefinitionList)
        self.Bind(wx.EVT_LIST_ITEM_ACTIVATED, self.onJobDefinitionActivated, self.jobDefinitionList)
        self.Bind(wx.EVT_LIST_KEY_DOWN, self.onJobDefinitionKeyDown, self.jobDefinitionList)
        self.Bind(wx.EVT_BUTTON, self.onFind, self.refreshJobsButton)
        self.Bind(wx.EVT_BUTTON, self.onJobProperties, self.jobPropertiesButton)
        self.Bind(wx.EVT_BUTTON, self.onRetrieve, self.downloadJobButton)
        self.Bind(wx.EVT_BUTTON, self.onDownloadToDefinition, self.downloadAllButton)
        self.Bind(wx.EVT_BUTTON, self.onKill, self.killJobButton)
        self.Bind(wx.EVT_BUTTON, self.onClean, self.cleanJobButton)
        self.Bind(wx.EVT_LIST_ITEM_DESELECTED, self.onActiveJobListDeselected, self.activeJobList)
        self.Bind(wx.EVT_LIST_ITEM_SELECTED, self.onActiveJobListSelected, self.activeJobList)
        self.Bind(wx.EVT_LIST_ITEM_ACTIVATED, self.onActiveJobListActivated, self.activeJobList)
        self.Bind(wx.EVT_LIST_COL_CLICK, self.onActiveJobColClick, self.activeJobList)
        self.Bind(wx.EVT_BUTTON, self.onCleanDownloadedJobs, self.cleanDownloadedJobButton)
        self.Bind(wx.EVT_LIST_ITEM_DESELECTED, self.onJobDefinitionDeselected, self.jobDefinitionList_copy)
        self.Bind(wx.EVT_LIST_ITEM_SELECTED, self.onJobDefinitionSelected, self.jobDefinitionList_copy)
        self.Bind(wx.EVT_LIST_ITEM_ACTIVATED, self.onJobDefinitionActivated, self.jobDefinitionList_copy)
        self.Bind(wx.EVT_LIST_KEY_DOWN, self.onJobDefinitionKeyDown, self.jobDefinitionList_copy)
        self.Bind(wx.EVT_NOTEBOOK_PAGE_CHANGED, self.onNoteBookPageChanged, self.noteBook)
        self.Bind(wx.EVT_NOTEBOOK_PAGE_CHANGING, self.onNoteBookPageChanging, self.noteBook)
        self.Bind(wx.EVT_BUTTON, self.onKillThreads, self.killThreadsButton)
        # end wxGlade

    def __set_properties(self):
        # begin wxGlade: ArcJobToolWindow.__set_properties
        self.SetTitle("ARC Job Submission Tool - 0.3.0")
        self.SetSize((709, 684))
        self.newDefinitionButton.SetToolTipString("New job definition")
        self.newDefinitionButton.SetSize(self.newDefinitionButton.GetBestSize())
        self.editDefinitionButton.SetToolTipString("Edit job definition")
        self.editDefinitionButton.SetSize(self.editDefinitionButton.GetBestSize())
        self.submitDefinitionButton.SetToolTipString("Submit job definition")
        self.submitDefinitionButton.SetSize(self.submitDefinitionButton.GetBestSize())
        self.openResultsButton.SetToolTipString("View files")
        self.openResultsButton.SetSize(self.openResultsButton.GetBestSize())
        self.deleteDefinitionButton.SetToolTipString("Delete job definition")
        self.deleteDefinitionButton.SetSize(self.deleteDefinitionButton.GetBestSize())
        self.viewDescriptionButton.SetToolTipString("Preview XRSL")
        self.viewDescriptionButton.SetSize(self.viewDescriptionButton.GetBestSize())
        self.refreshJobsButton.SetToolTipString("Refresh status")
        self.refreshJobsButton.SetSize(self.refreshJobsButton.GetBestSize())
        self.jobPropertiesButton.SetSize(self.jobPropertiesButton.GetBestSize())
        self.downloadJobButton.SetToolTipString("Download selected")
        self.downloadJobButton.SetSize(self.downloadJobButton.GetBestSize())
        self.downloadAllButton.SetToolTipString("Download all")
        self.downloadAllButton.SetSize(self.downloadAllButton.GetBestSize())
        self.killJobButton.SetToolTipString("Kill jobb")
        self.killJobButton.SetSize(self.killJobButton.GetBestSize())
        self.cleanJobButton.SetToolTipString("Clean job")
        self.cleanJobButton.SetSize(self.cleanJobButton.GetBestSize())
        self.cleanDownloadedJobButton.SetToolTipString("Clear download history")
        self.cleanDownloadedJobButton.SetSize(self.cleanDownloadedJobButton.GetBestSize())
        self.bitmap_button_1.SetSize(self.bitmap_button_1.GetBestSize())
        self.noteBook_pane_4.Hide()
        self.logOutputText.SetFont(wx.Font(9, wx.MODERN, wx.NORMAL, wx.NORMAL, 0, ""))
        self.statusText.SetToolTipString("Current processing operation")
        self.statusGauge.SetMinSize((-1, 25))
        self.statusGauge.SetToolTipString("Progress status indicator")
        self.killThreadsButton.SetToolTipString("Kill all running threads")
        self.killThreadsButton.SetSize(self.killThreadsButton.GetBestSize())
        # end wxGlade

    def __do_layout(self):
        # begin wxGlade: ArcJobToolWindow.__do_layout
        mainSizer = wx.BoxSizer(wx.VERTICAL)
        statusPaneSizer = wx.BoxSizer(wx.HORIZONTAL)
        sizer_1_copy = wx.BoxSizer(wx.VERTICAL)
        panelSizer = wx.BoxSizer(wx.VERTICAL)
        sizer_3_copy_copy_copy = wx.BoxSizer(wx.VERTICAL)
        sizer_33 = wx.BoxSizer(wx.HORIZONTAL)
        downloadedJobPaneVSizer = wx.BoxSizer(wx.VERTICAL)
        downloadedJobPaneHSizer = wx.BoxSizer(wx.HORIZONTAL)
        jobPaneVSizer = wx.BoxSizer(wx.VERTICAL)
        jobPaneHSizer = wx.BoxSizer(wx.HORIZONTAL)
        sizer_3_copy_copy = wx.BoxSizer(wx.VERTICAL)
        sizer_9_copy_copy = wx.BoxSizer(wx.HORIZONTAL)
        sizer_9_copy_copy.Add(self.newDefinitionButton, 0, 0, 0)
        sizer_9_copy_copy.Add(self.editDefinitionButton, 0, 0, 0)
        sizer_9_copy_copy.Add(self.submitDefinitionButton, 0, 0, 0)
        sizer_9_copy_copy.Add(self.openResultsButton, 0, 0, 0)
        sizer_9_copy_copy.Add(self.deleteDefinitionButton, 0, 0, 0)
        sizer_9_copy_copy.Add(self.viewDescriptionButton, 0, 0, 0)
        sizer_3_copy_copy.Add(sizer_9_copy_copy, 0, wx.ALL, 3)
        sizer_3_copy_copy.Add(self.jobDefinitionList, 1, wx.ALL|wx.EXPAND, 4)
        self.jobDefinitionPane.SetSizer(sizer_3_copy_copy)
        jobPaneHSizer.Add(self.refreshJobsButton, 0, 0, 0)
        jobPaneHSizer.Add(self.jobPropertiesButton, 0, 0, 0)
        jobPaneHSizer.Add(self.downloadJobButton, 0, 0, 0)
        jobPaneHSizer.Add(self.downloadAllButton, 0, 0, 0)
        jobPaneHSizer.Add(self.killJobButton, 0, 0, 0)
        jobPaneHSizer.Add(self.cleanJobButton, 0, 0, 0)
        jobPaneVSizer.Add(jobPaneHSizer, 0, wx.ALL|wx.EXPAND, 4)
        jobPaneVSizer.Add(self.activeJobList, 1, wx.ALL|wx.EXPAND, 4)
        self.activeJobsPane.SetSizer(jobPaneVSizer)
        downloadedJobPaneHSizer.Add(self.cleanDownloadedJobButton, 0, 0, 0)
        downloadedJobPaneVSizer.Add(downloadedJobPaneHSizer, 0, wx.ALL|wx.EXPAND, 4)
        downloadedJobPaneVSizer.Add(self.downloadedJobList, 1, wx.ALL|wx.EXPAND, 4)
        self.downloadedJobsPane.SetSizer(downloadedJobPaneVSizer)
        sizer_33.Add(self.label_3, 0, wx.LEFT|wx.RIGHT|wx.TOP|wx.ALIGN_CENTER_VERTICAL, 4)
        sizer_33.Add(self.text_ctrl_1, 1, wx.RIGHT|wx.TOP|wx.EXPAND, 4)
        sizer_33.Add(self.bitmap_button_1, 0, wx.TOP, 4)
        sizer_3_copy_copy_copy.Add(sizer_33, 0, wx.RIGHT|wx.EXPAND, 4)
        sizer_3_copy_copy_copy.Add(self.jobDefinitionList_copy, 1, wx.ALL|wx.EXPAND, 4)
        self.noteBook_pane_4.SetSizer(sizer_3_copy_copy_copy)
        self.noteBook.AddPage(self.jobDefinitionPane, "Job definitions")
        self.noteBook.AddPage(self.activeJobsPane, "Active jobs")
        self.noteBook.AddPage(self.downloadedJobsPane, "Downloaded jobs")
        self.noteBook.AddPage(self.noteBook_pane_4, "Storage")
        panelSizer.Add(self.noteBook, 3, wx.ALL|wx.EXPAND, 5)
        self.mainPanel.SetSizer(panelSizer)
        sizer_1_copy.Add(self.logOutputLabel, 0, wx.LEFT|wx.TOP|wx.BOTTOM, 5)
        sizer_1_copy.Add(self.logOutputText, 1, wx.LEFT|wx.RIGHT|wx.EXPAND, 5)
        self.panel_1.SetSizer(sizer_1_copy)
        self.window_1.SplitHorizontally(self.mainPanel, self.panel_1, 462)
        mainSizer.Add(self.window_1, 1, wx.EXPAND, 0)
        mainSizer.Add(self.static_line_3, 0, wx.TOP|wx.EXPAND, 6)
        statusPaneSizer.Add(self.statusText, 1, wx.ALL, 1)
        statusPaneSizer.Add(self.statusGauge, 1, wx.ALL, 2)
        statusPaneSizer.Add(self.killThreadsButton, 0, 0, 0)
        mainSizer.Add(statusPaneSizer, 0, wx.ALL|wx.EXPAND, 3)
        self.SetSizer(mainSizer)
        self.Layout()
        self.Centre()
        # end wxGlade
        
        # Call custom intialisation routine
        
        self.__initApp()
        
    def checkSetup(self):
        """
        Check user setup
        
        Checks for existing configuration files, certificate directories.
        If it is the first time configuration files are created. If a proxy
        certificate not available or expired one is created.
        """
        
        # Check for arc configuration directory
        
        if not os.path.exists(os.path.expanduser("~/.arc")):
            os.mkdir(os.path.expanduser("~/.arc"))
    
        # Check for client configuration file
        
        jobListFilename = os.path.expanduser("~/.arc/jobs.xml")
        userConfigFilename = os.path.expanduser("~/.arc/arcjobtool.conf")
        
        # Check for existing client.conf
        
        self.userConfig = arc.UserConfig(userConfigFilename, jobListFilename)
        self.arcGuiConfig = ArcGuiConfig(self.userConfig, None)
        self.arcGuiConfig.filename = userConfigFilename
        
        if os.path.exists(self.arcGuiConfig.filename):
            self.arcGuiConfig.read()
        else:
            
            # No configuration file found. Create a default config
            
            wx.MessageBox("No ArcGUI configuration found. Please review your settings.")
            self.arcGuiConfig.create()
            self.userConfig = arc.UserConfig(userConfigFilename, jobListFilename)
            
            # Let the user review the default settings
            
            dialog = ClientSettingsDialog(self)
            dialog.arcGuiConfig = self.arcGuiConfig
            dialog.ShowModal()
            dialog.Destroy()
        
        self.caCertificatePath = self.userConfig.CACertificatePath()        
        self.userCertFilename = self.userConfig.CertificatePath()
        self.userKeyFilename = self.userConfig.KeyPath()
        self.proxyFilename = self.userConfig.ProxyPath()
        
        self.historyFile = os.path.expanduser("~/.arc/download_history.log")
              
        if self.userConfig.CredentialsFound():
            self.logInfoMsg("Found credentials")
        else:
            self.logWarningMsg("Credentials not found")
        
        if not os.path.exists(self.proxyFilename):
            
            # Create proxy certificate if not found.
            
            wx.MessageBox("No proxy file found.")   
            userAuth = GuiUserAuthentication(self.userConfig)
            userAuth.parentWindow = self
            authOk = userAuth.createLocalProxy()
            if not authOk:
                if userAuth.errorMessage!="":
                    wx.MessageBox(userAuth.errorMessage)
                return False
            else:
                return True
        else:
            
            # Check proxy expiration
            
            proxyCred = arc.Credential(self.proxyFilename, "", "", "")
            
            if False:
                
                # Test proxy expiration.
                
                monthPeriod = arc.Period("4",arc.PeriodWeeks)
                currTime = arc.Time() + monthPeriod
            else:
                currTime = arc.Time()
            
            endTime = proxyCred.GetEndTime()
            
            # If the existing proxyCert has expired we create a new one.
            
            if endTime<currTime:
                wx.MessageBox("Proxy has expired.")
                userAuth = GuiUserAuthentication(self.userConfig)
                userAuth.parentWindow = self
                authOk = userAuth.createLocalProxy()
                if not authOk:
                    if userAuth.errorMessage!="":
                        wx.MessageBox(userAuth.errorMessage)
                    return False
                else:
                    return True
        return True
    
    def logMsg(self, level, msg):
        """
        Wrapper function for sending messages to log.
        """
        self.logger.msg(level, msg)
        
    def logInfoMsg(self, msg):
        """
        Wrapper function for sending info messages to log.
        """        
        self.logMsg(arc.INFO, msg)
    
    def logDebugMsg(self, msg):
        """
        Wrapper function for sending debug messages to log.
        """        
        self.logMsg(arc.DEBUG, msg)
        
    def logWarningMsg(self, msg):
        """
        Wrapper function for sending warning messages to log.
        """        
        self.logMsg(arc.WARNING, msg)

    def logErrorMsg(self, msg):
        """
        Wrapper function for sending error messages to log.
        """        
        self.logMsg(arc.ERROR, msg)
        
    def __setupLogging(self):
        """
        Sets up logging for arcjobtool.
        """
        logcout = arc.LogStream(self)
        arc.Logger_getRootLogger().removeDestinations()       
        arc.Logger_getRootLogger().addDestination(logcout)
        
        self.logger = arc.Logger(arc.Logger_getRootLogger(), "ArcJobToolWindow")
        
    def __changeWorkingDir(self, workingDir):
        
        self.__sortKey = ""
        self.__outputLine = ""
        self.__selectedJobDefinition = []
        self.__selectedActiveJobs = []
        self.__jobDefinitions = {}
        
        self.__progressCounter = 0
        
        os.chdir(workingDir)
        self.__definitionDir = os.getcwd()
        
        self.logInfoMsg("Initialise job status grid.")
        
        self.__clearGrid()
        self.__updateGrid()
        
        # Initialise job list
        
        self.logInfoMsg("Initialise job definition icon view.")
        
        self.__setupDefinitionDir()
        self.__setupDefinitionList()
        self.__updateJobDefinitionList()
        self.__updateDownloadList()
        
    def __initApp(self):
        """
        Application initialisation
        """
        
        self.__setupLogging()
        self.logLevel = arc.INFO
        
        # Setup user configuration. If no configuration found it will
        # be created when the file is saved with SaveToFile
        
        self.logInfoMsg("Initiating arcjobtool.")
                             
        # Setup instance variables
        
        self.__progressDialog = None
        self.__currentSelection = []
        self.__sortKey = ""
        self.__outputLine = ""
        self.__selectedJobDefinition = []
        self.__selectedActiveJobs = []
        self.__jobDefinitions = {}
        
        self.__progressCounter = 0
        
        self.__definitionDir = os.getcwd()

        # Check setup
        
        if not self.checkSetup():
            self.Destroy()
            sys.exit(-1)
               
        sys.stdout = self
        
        # Show splash window
        
        if self.arcGuiConfig.showSplash:
            arcSplash = ArcSplash(self)
            arcSplash.Show(True)        

        # Create an ArcClient instance
        
        self.logInfoMsg("Creating ArcClient instance.")
        
        self.__arcClient = ArcClient(self.userConfig, sys.stdout)
        self.__arcClient.downloadDir = os.path.abspath(".")
        self.__arcClient.brokerName = self.arcGuiConfig.brokerName
        
        self.arcGuiConfig.arcClient = self.__arcClient
        
        self.__certInfoOpen = False
        
        # Initialise special controls
        
        self.statusGauge.Hide()
        self.statusText.Disable()
        self.killThreadsButton.Disable()
        
        # Initialise menus
        
        self.mainMenuBar.EnableTop(2, True)
        self.mainMenuBar.EnableTop(3, False)
        
        # Initialise timer for progress update
        
        self.logInfoMsg("Initialise progress timer.")
        
        self.__timerID = 100  
        self.__progressTimer = wx.Timer(self, self.__timerID)  # message will be sent to the panel
        wx.EVT_TIMER(self, self.__timerID, self.onProgressTimer)
        
        self.logInfoMsg("Initialise status update timer.")
        
        self.__statusTimerID = 101
        self.__statusTimer = wx.Timer(self, self.__statusTimerID)
        wx.EVT_TIMER(self, self.__statusTimerID, self.onStatusTimer)
        
        self.logInfoMsg("Initialise download update timer.")
        
        self.__downloadTimerID = 102
        self.__downloadTimer = wx.Timer(self, self.__downloadTimerID)
        wx.EVT_TIMER(self, self.__downloadTimerID, self.onDownloadTimer)
        
        # Events for non-blocking arc handling
        
        self.logInfoMsg("Setting up events bindings.")
        
        self.Bind(EVT_UPDATE_STATUS_DONE, self.onUpdateStatusDone)
        self.Bind(EVT_RETRIEVE_JOBS_DONE, self.onRetrieveJobsDone)
        self.Bind(EVT_CLEAN_JOBS_DONE, self.onCleanJobsDone)
        self.Bind(EVT_KILL_JOBS_DONE, self.onKillJobsDone)
        self.Bind(EVT_PROGRESS_UPDATE, self.onProgressUpdate)
        self.Bind(EVT_LOG_UPDATE, self.onLogUpdate)
        self.Bind(EVT_SUBMIT_JOB_DONE, self.onSubmitJobDone)
        self.Bind(EVT_CERTINFO_CLOSE, self.onCertInfoClose)
        self.Bind(wx.EVT_CLOSE, self.onWindowClose)
        
        # Initialise grid
        
        self.logInfoMsg("Initialise job status grid.")
        
        self.__clearGrid()
        self.__updateGrid()
        
        # Initialise job list
        
        self.logInfoMsg("Initialise job definition icon view.")
        
        self.__setupDefinitionDir()
        self.__setupDefinitionList()
        self.__updateJobDefinitionList()
        self.__updateDownloadList()
        
        self.logInfoMsg("Sending of first status update thread.")
        
        self.__updateStatusThread = UpdateStatusThread(self, self.__arcClient)
        self.__updateStatusThread.logger = self.logger
        self.__updateStatusThread.start()
        self.startProgress()
        
        self.__retrieveJobsThread = RetrieveJobsThread(self, self.__arcClient, [], "", self.historyFile)
        self.__retrieveJobsThread.logger = self.logger        
        
        if self.arcGuiConfig.automaticDownload:
            self.logInfoMsg("Download timer started.")
            self.__downloadTimer.Stop()
            self.__downloadTimer.Start(self.arcGuiConfig.automaticDownloadInterval)
        else:
            self.logInfoMsg("Download timer disabled.")
            self.__downloadTimer.Stop()
        
        if self.arcGuiConfig.automaticUpdate:
            self.logInfoMsg("Update timer started.")
            self.__statusTimer.Stop()
            self.__statusTimer.Start(self.arcGuiConfig.automaticUpdateInterval)
        else:
            self.logInfoMsg("Update timer disabled.")
            self.__statusTimer.Stop()
            
    def startProgress(self):
        """
        Start progress counter.
        
        Increases a counter to be able to stop progress update when
        no threads are running. The function will show the status text
        and satus gauge controls.
        """
        if self.__progressCounter == 0:
            self.__progressTimer.Start(100)
            self.statusText.Enable()
            self.statusGauge.Show()
            self.statusGauge.GetParent().GetSizer().Layout()
            self.killThreadsButton.Enable()
        
        self.__progressCounter += 1
        
    def releaseProgress(self):
        """
        Releases a reference to a progress updating thread.
        
        When the progress counter i 0 the progress timer is stopped and
        the status and gauge controls are hidden.
        """
        if self.__progressCounter>0:
            self.__progressCounter -= 1
            
        if self.__progressCounter == 0:
            self.__progressTimer.Stop()
            self.statusText.SetValue("")
            self.statusGauge.Hide()
            self.statusText.Disable()
            self.killThreadsButton.Disable()
            
    def write(self, string):
        """
        Received the log stream from ARC.
        
        Sends an event to the Window, so that it can
        be updated correctly.
        """
        evt = UpdateLogEvent(EVT_LOG_UPDATE_TYPE, -1, string)
        wx.PostEvent(self, evt)
        
    def __clearGrid(self):
        """
        Clear contents of grid.
        """
        self.activeJobList.ClearAll()            
        
    def __clearDownloadList(self):
        """
        Clear contents of download list
        """
        self.downloadedJobList.ClearAll()
        
    def __updateGrid(self):
        """
        Update grid with job information.
        """
        self.__clearGrid()
        
        self.activeJobList.InsertColumn(0, "JobID")
        self.activeJobList.InsertColumn(1, "Name")
        self.activeJobList.InsertColumn(2, "State")
        self.activeJobList.InsertColumn(3, "Error")
        #self.activeJobList.InsertColumn(4, "ExitCode")
                
        sortedKeys = self.__arcClient.sortKeysBy(self.__sortKey)
        
        row = 0
              
        for jobId in sortedKeys:
            self.activeJobList.InsertStringItem(row,jobId)
            if self.__arcClient.jobDict[jobId].has_key("Name"):
                self.activeJobList.SetStringItem(row,1,self.__arcClient.jobDict[jobId]["Name"])
            else:
                self.activeJobList.SetStringItem(row,1,"Unknown")
                
            if self.__arcClient.jobDict[jobId].has_key("State"):
                self.activeJobList.SetStringItem(row,2,self.__arcClient.jobDict[jobId]["State"])
            else:
                self.activeJobList.SetStringItem(row,2,"Unknown")
                
            if self.__arcClient.jobDict[jobId].has_key("Error"):
                self.activeJobList.SetStringItem(row,3,str(self.__arcClient.jobDict[jobId]["Error"]))
            else:
                self.activeJobList.SetStringItem(row,3,"")
                
            #if self.__arcClient.jobDict[jobId].has_key("ExitCode"):
            #    self.activeJobList.SetStringItem(row,4,str(self.__arcClient.jobDict[jobId]["ExitCode"]))
            #else:
            #    self.activeJobList.SetStringItem(row,4,"")
                
            if self.__arcClient.jobDict[jobId].has_key("State"):
                if self.__arcClient.jobDict[jobId]["State"] == "FINISHED":
                    self.activeJobList.SetItemBackgroundColour(row, wx.Colour(192, 255, 192))
                elif self.__arcClient.jobDict[jobId]["State"] == "FAILED":
                    self.activeJobList.SetItemBackgroundColour(row, wx.Colour(255, 192, 192))
                else:
                    self.activeJobList.SetItemBackgroundColour(row, wx.Colour(255, 255, 192))
        
            row += 1
            
        self.activeJobList.SetColumnWidth(0, wx.LIST_AUTOSIZE)
        self.activeJobList.SetColumnWidth(1, wx.LIST_AUTOSIZE)
        self.activeJobList.SetColumnWidth(2, wx.LIST_AUTOSIZE)
        self.activeJobList.SetColumnWidth(3, wx.LIST_AUTOSIZE)
                    
    def __updateStatus(self):
        """
        Update status for grid jobs.
        """  
        
        if not self.__updateStatusThread.isAlive():
            self.__updateStatusThread = UpdateStatusThread(self, self.__arcClient)
            self.__updateStatusThread.logger = self.logger
            self.__updateStatusThread.start()
            self.startProgress()
        
    def __setupDefinitionDir(self):
        """
        Setup definitions dir $HOME/.arcgui
        """
        
        # Check if definition dir exists. If not
        # Create it.
        
        if not os.path.exists(self.__definitionDir):
            os.mkdir(self.__definitionDir)
            
    def __setupDefinitionList(self):
        """
        Sets up the job definition list control.
        
        Loads items and images into the list control.
        """
        self.__pluginMgr = PluginManager()
        
        imageList = wx.ImageList(48,48)
        
        if os.environ.has_key("ARCJOBTOOL_SHARE"):
            arcGuiImagePath = os.path.join(os.environ["ARCJOBTOOL_SHARE"], "images")
            
            bitmapFilename = os.path.join(arcGuiImagePath, "archive.png")
            imageList.Add(wx.Bitmap(bitmapFilename, wx.BITMAP_TYPE_ANY))
                    
            self.jobDefinitionList.AssignImageList(imageList, wx.IMAGE_LIST_NORMAL)
        
    def __updateJobDefinitionList(self):
        """
        Updates the job definition list control.
        """
        
        dirList = os.listdir(self.__definitionDir)
        
        self.jobDefinitionList.ClearAll()
        self.__jobDefinitions = {}
        
        for dirEntry in dirList:
            fullPath = os.path.join(self.__definitionDir, dirEntry)
            if os.path.isdir(fullPath):
                if fullPath.find(".arcdef")!=-1:
                    self.__jobDefinitions[dirEntry.split(".arcdef")[0]] = fullPath
                    self.jobDefinitionList.InsertImageStringItem(0, dirEntry.split(".arcdef")[0], 0)
                    
    def __deleteSelectedJobDefinition(self):
        """
        Deletes the selected job definition from disk.
        """
                    
        if len(self.__selectedJobDefinition)!=0:
            if wx.MessageBox("Delete job definition", "ArcGui", style=wx.YES_NO)==wx.YES:
                definitionName = self.__selectedJobDefinition[1]+".arcdef"
                fullPath = os.path.join(self.__definitionDir, definitionName)
                if os.path.exists(fullPath):
                    shutil.rmtree(fullPath)
                    self.__updateJobDefinitionList()
        else:
            wx.MessageBox("Please select a jobdefinition.")
            
    def __openSelectedJobDefinition(self):
        """
        Open selected job definition.
        """
        if len(self.__selectedJobDefinition)!=0:
            
            # Determine full path of job definition dir
            
            definitionName = self.__selectedJobDefinition[1]+".arcdef"
            fullPath = os.path.join(self.__definitionDir, definitionName)
            
            # Instantiate plugin from work dir using plugin manager
            
            plugin = self.__pluginMgr.pluginFromWorkDir(fullPath)
            
            if plugin==None:
                wx.MessageBox("Failed to load plugin for job definition.")
                return
            
            # Load plugin data from job definition
            
            plugin.onLoad(fullPath)
            
            # Show plugin user interface
            
            plugin.onEdit()
            
            if plugin.onNeedSave():
                self.logInfoMsg("Saving plugin data.")
                plugin.onSave(fullPath)

            plugin.onClean()
            plugin.onSetup()
        else:
            wx.MessageBox("Please select a jobdefinition.")
            
    def __submitSelectedJobDefinition(self):
        """
        Submit selected job definition.
        """
        if len(self.__selectedJobDefinition)!=0:
            
            # Determine full path of job definition dir
            
            definitionName = self.__selectedJobDefinition[1]+".arcdef"
            fullPath = os.path.join(self.__definitionDir, definitionName)
            
            # Instantiate plugin from work dir using plugin manager
            
            plugin = self.__pluginMgr.pluginFromWorkDir(fullPath)
            
            if plugin==None:
                wx.MessageBox("Failed to load plugin for job definition.")
                return
            
            # Load plugin data from job definition
            
            plugin.onLoad(fullPath)
            
            # Get jobList
            
            jobList = plugin.task.jobList
            
            #for job in jobList:
            #    job.Print(True)
            #    print job.UnParse(format="XRSL")
                
            worker = SubmitJobThread(self, self.__arcClient, jobList)
            worker.logger = self.logger
            worker.start()
            self.startProgress()
            
        else:
            wx.MessageBox("Please select a jobdefinition.")
            
    def __submitMissing(self):
        """
        Submit jobs with missing results.
        """
        if len(self.__selectedJobDefinition)!=0:
            
            # Determine full path of job definition dir
            
            definitionName = self.__selectedJobDefinition[1]+".arcdef"
            fullPath = os.path.join(self.__definitionDir, definitionName)
            
            # Instantiate plugin from work dir using plugin manager
            
            plugin = self.__pluginMgr.pluginFromWorkDir(fullPath)
            
            if plugin==None:
                wx.MessageBox("Failed to load plugin for job definition.")
                return
            
            # Load plugin data from job definition
            
            plugin.onLoad(fullPath)
            
            # Get jobList

            jobList = plugin.task.jobList
            jobInfoList = plugin.task.jobInfo
            
            missingJobList = []
            
            for job, jobInfo in zip(jobList, jobInfoList):
                taskName = jobInfo[0]
                resultDir = os.path.join(fullPath, "results")
                taskResultDir = os.path.join(resultDir, taskName)
                
                
                if not os.path.exists(taskResultDir):
                    missingJobList.append(job)
                    
            if len(missingJobList)>0:
                worker = SubmitJobThread(self, self.__arcClient, missingJobList)
                worker.logger = self.logger
                worker.start()
                self.startProgress()
            else:
                wx.MessageBox("Result set is complete. No jobs submitted.")    
            
        else:
            wx.MessageBox("Please select a jobdefinition.")            
            
    def __showSelectedJobXrsl(self):        
        """
        Open selected job definition
        """
        if len(self.__selectedJobDefinition)!=0:
            
            # Determine full path of job definition dir
            
            definitionName = self.__selectedJobDefinition[1]+".arcdef"
            fullPath = os.path.join(self.__definitionDir, definitionName)
            
            # Instantiate plugin from work dir using plugin manager
            
            plugin = self.__pluginMgr.pluginFromWorkDir(fullPath)
            
            if plugin==None:
                wx.MessageBox("Failed to load plugin for job definition.")
                return
            
            # Load plugin data from job definition
            
            plugin.onLoad(fullPath)
            
            # Get jobList
            
            jobList = plugin.task.jobList
            
            wx.MessageBox(jobList[0].UnParse("xrsl"))
            
                
        else:
            wx.MessageBox("Please select a jobdefinition.")

    def __showSelectedJobFiles(self):        
        """
        Open selected job definition
        """
        if len(self.__selectedJobDefinition)!=0:
            
            # Determine full path of job definition dir
            
            definitionName = self.__selectedJobDefinition[1]+".arcdef"
            fullPath = os.path.join(self.__definitionDir, definitionName)
            resultPath = os.path.join(fullPath,"results")
            if os.path.isdir(resultPath):
                showDir(resultPath)
            else:
                wx.MessageBox("No results have been downloaded to job definition.")
                
        else:
            wx.MessageBox("Please select a jobdefinition.")

                    
    def __cleanSelectedResults(self):        
        """
        Open selected job definition
        """
        if len(self.__selectedJobDefinition)!=0:
            
            # Determine full path of job definition dir
            
            definitionName = self.__selectedJobDefinition[1]+".arcdef"
            fullPath = os.path.join(self.__definitionDir, definitionName)
            resultPath = os.path.join(fullPath,"results")
            if os.path.isdir(resultPath):
                shutil.rmtree(resultPath)
            else:
                wx.MessageBox("No results have been downloaded to job definition.")
                
        else:
            wx.MessageBox("Please select a jobdefinition.")
            
    def __downloadSelectedJobs(self):
        """
        Download all finished jobs to specified.
        """
        
        # Make sure there are jobs selected
        
        if len(self.__selectedActiveJobs)==0:
            wx.MessageBox("Please select a job.")
            return
        
        # Don't do anything if there is a running retrieval thread.
               
        if self.__retrieveJobsThread.isAlive():
            wx.MessageBox("Job download already in progress.")
            return
        
        # Create time stamp for downloaded files.
        
        now = datetime.now()     
        downloadStamp = now.strftime("download_%Y_%m_%d_%H_%M")
        
        currentDir = os.getcwd()
        
        jobIds = []
        jobDownloadDirs = []
              
        for selection in self.__selectedActiveJobs:
            
            jobId = str(self.activeJobList.GetItem(selection,0).GetText())
            selectedItem = str(self.activeJobList.GetItem(selection,1).GetText())

            if selectedItem != "":
                if len(selectedItem.split("_"))>2:
                    jobName = "_".join(selectedItem.split("_")[:-1])
                    jobParamId = selectedItem.split("_")[-1]
                else:
                    jobName = selectedItem.split("_")[0]
                    jobParamId = selectedItem.split("_")[1]
    
                if self.__jobDefinitions.has_key(jobName):
                    
                    # Create a results directory if not already there
                    
                    definitionDir = os.path.join(currentDir, self.__jobDefinitions[jobName])
                    resultsDir = os.path.join(definitionDir, "results")
                    if not os.path.isdir(resultsDir):
                        os.mkdir(resultsDir)
                        
                    # Create a timestamped directory for this download.
                    
                    downloadsDir = resultsDir
                    
                    if False:    
                        downloadsDir = os.path.join(resultsDir, downloadStamp)
                        if not os.path.isdir(downloadsDir):
                            os.mkdir(downloadsDir)
                    
                    downloadDir = os.path.join(downloadsDir, "%s_%s" % (jobName, jobParamId))
                    jobIds.append(jobId)
                    jobDownloadDirs.append(downloadDir)
                
        for jobId, jobDownloadDir in zip(jobIds, jobDownloadDirs):
            self.logInfoMsg("Downloading:"+str(jobId)+" to "+str(jobDownloadDir))

        if len(jobDownloadDirs)>0:
            if not self.__retrieveJobsThread.isAlive():
                self.__retrieveJobsThread = RetrieveJobsThread(self, self.__arcClient, jobIds, jobDownloadDirs, self.historyFile)
                self.__retrieveJobsThread.logger = self.logger
                self.__retrieveJobsThread.start()
                self.startProgress()
            
    def __downloadAllJobs(self, silent=True):
        """
        Download all finished jobs to definitions.
        """
        
        # Make sure we are not already downloading jobs.
        
        if self.__retrieveJobsThread.isAlive():
            return
        
        # Create time stamp for downloaded files.
        
        now = datetime.now()     
        downloadStamp = now.strftime("download_%Y_%m_%d_%H_%M")
        
        currentDir = os.getcwd()
        
        jobIds = []
        jobDownloadDirs = []
              
        for selection in range(self.activeJobList.GetItemCount()):
            
            jobId = str(self.activeJobList.GetItem(selection,0).GetText())
            selectedItem = str(self.activeJobList.GetItem(selection,1).GetText())

            if selectedItem != "":
                if len(selectedItem.split("_"))>2:
                    jobName = "_".join(selectedItem.split("_")[:-1])
                    jobParamId = selectedItem.split("_")[-1]
                else:
                    jobName = selectedItem.split("_")[0]
                    jobParamId = selectedItem.split("_")[1]
    
                if self.__jobDefinitions.has_key(jobName):
                    
                    # Create a results directory if not already there
                    
                    definitionDir = os.path.join(currentDir, self.__jobDefinitions[jobName])
                    resultsDir = os.path.join(definitionDir, "results")
                    if not os.path.isdir(resultsDir):
                        os.mkdir(resultsDir)
                        
                    # Create a timestamped directory for this download.
                    
                    downloadsDir = resultsDir
                    
                    if False:    
                        downloadsDir = os.path.join(resultsDir, downloadStamp)
                        if not os.path.isdir(downloadsDir):
                            os.mkdir(downloadsDir)
                    
                    downloadDir = os.path.join(downloadsDir, "%s_%s" % (jobName, jobParamId))
                    jobIds.append(jobId)
                    jobDownloadDirs.append(downloadDir)
                
        for jobId, jobDownloadDir in zip(jobIds, jobDownloadDirs):
            self.logInfoMsg("Downloading: "+str(jobId)+" to "+str(jobDownloadDir))

        if len(jobDownloadDirs)>0:
            if not self.__retrieveJobsThread.isAlive():
                self.__retrieveJobsThread = RetrieveJobsThread(self, self.__arcClient, jobIds, jobDownloadDirs, self.historyFile)
                self.__retrieveJobsThread.logger = self.logger
                self.__retrieveJobsThread.start()
                self.startProgress()
        else:
            if self.activeJobList.GetItemCount()!=0:
                if silent:
                    self.logWarningMsg("Could not find any job definition to download to. Make sure the working directory is correct.")
                else:
                    wx.MessageBox("Could not find any job definition to download to. Make sure the working directory is correct.")
            else:
                if silent:
                    self.logWarningMsg("Nothing to download.")
                else:
                    wx.MessageBox("Nothing to download.")
                
    def __updateDownloadList(self):
        """
        Update grid with job information.
        """
        if not os.path.exists(self.historyFile):
            return

        self.__clearDownloadList()
        
        self.downloadedJobList.InsertColumn(0, "JobID")
        self.downloadedJobList.InsertColumn(1, "Date")
        self.downloadedJobList.InsertColumn(2, "Dir")
        
        # Read download history file
        
        historyFile = open(self.historyFile, "r")
        lines = historyFile.readlines()
        historyFile.close()
        
        # Add lines to history list
        
        history = []
        
        for line in lines:
            history.append(line.split(";"))
                
        row = 0
              
        for download in history:
            try:
                self.downloadedJobList.InsertStringItem(row,download[0])
                self.downloadedJobList.SetStringItem(row,1,download[1])
                self.downloadedJobList.SetStringItem(row,2,download[2])
            except:
                pass
            
            row += 1
            
        self.downloadedJobList.SetColumnWidth(0, wx.LIST_AUTOSIZE)
        self.downloadedJobList.SetColumnWidth(1, wx.LIST_AUTOSIZE)
        self.downloadedJobList.SetColumnWidth(2, wx.LIST_AUTOSIZE)
        
    def __cleanDownloadList(self):
        """
        Clean download history
        """
        
        if os.path.exists(self.historyFile):
            historyFile = open(self.historyFile, "w")
            historyFile.close()
            
            self.__updateDownloadList()

    def onFind(self, event): # wxGlade: ArcJobToolWindow.<event_handler>
        """
        Event handler: updating job status.
        """
        self.__updateStatus()
        
    def onRetrieve(self, event): # wxGlade: ArcJobToolWindow.<event_handler>
        """
        Event handler: Retrieve selected jobs.
        """
        
        self.__downloadSelectedJobs()
                    
    def onDownloadToDefinition(self, event): # wxGlade: ArcJobToolWindow.<event_handler>
        """
        Event handler: Download job directly to job definition directory.
        """
        
        self.__downloadAllJobs(silent = False)
        

    def onKill(self, event): # wxGlade: ArcJobToolWindow.<event_handler>
        """
        Event handler: Kill selected jobs.
        """
        if len(self.__selectedActiveJobs)>0:
            jobIds = []
            for selection in self.__selectedActiveJobs:
                jobIds.append(str(self.activeJobList.GetItem(selection,0).GetText()))
                
            worker = KillJobsThread(self, self.__arcClient, jobIds)
            worker.logger = self.logger
            worker.start()
            self.startProgress()

    def onClean(self, event): # wxGlade: ArcJobToolWindow.<event_handler>
        """
        Event handler: Clean selected jobs.
        """
        if len(self.__selectedActiveJobs)>0:
            jobIds = []
            for selection in self.__selectedActiveJobs:
                jobIds.append(str(self.activeJobList.GetItem(selection,0).GetText()))
                
            worker = CleanJobsThread(self, self.__arcClient, jobIds)
            worker.logger = self.logger
            worker.start()
            self.startProgress()
            
    def onDeleteJobList(self, event): # wxGlade: ArcJobToolWindow.<event_handler>
        """
        Event handler: Clean selected jobs.
        """
        if len(self.__selectedActiveJobs)>0:
            jobIds = []
            for selection in self.__selectedActiveJobs:
                jobIds.append(str(self.activeJobList.GetItem(selection,0).GetText()))
                
            worker = CleanJobsThread(self, self.__arcClient, jobIds, force=True)
            worker.logger = self.logger
            worker.start()
            self.startProgress()
                
    def onFileExit(self, event): # wxGlade: ArcJobToolWindow.<event_handler>
        """
        Close ArcGUI application
        """
        self.Close()

    def onCertProxyInfo(self, event): # wxGlade: ArcJobToolWindow.<event_handler>
        """
        Show certificate information window.
        """
        if not self.__certInfoOpen:
            window = CertificateInfoWindow(self)
            window.userConfig = self.__arcClient.userConfig
            window.Show(True)
            self.__certInfoOpen = True
            
    def onCreateProxyCert(self, event): # wxGlade: ArcJobToolWindow.<event_handler>
        """
        Create proxy certificate.
        """
        
        userAuth = GuiUserAuthentication(self.userConfig)
        userAuth.parentWindow = self
        authOk = userAuth.createLocalProxy()
        if not authOk:
            if userAuth.errorMessage!="":
                wx.MessageBox(userAuth.errorMessage)

    def onClientSettings(self, event): # wxGlade: ArcJobToolWindow.<event_handler>
        """
        Show client settings dialog
        """
        dialog = ClientSettingsDialog(self)
        dialog.arcGuiConfig = self.arcGuiConfig
        dialog.ShowModal()
        dialog.Destroy()
        
        if self.arcGuiConfig.automaticDownload:
            self.logInfoMsg("Download timer interval changed.")
            self.__downloadTimer.Stop()
            self.__downloadTimer.Start(self.arcGuiConfig.automaticDownloadInterval)
        else:
            self.logInfoMsg("Download timer disabled.")
            self.__downloadTimer.Stop()
        
        if self.arcGuiConfig.automaticUpdate:
            self.logInfoMsg("Status update interval changed.")
            self.__statusTimer.Stop()
            self.__statusTimer.Start(self.arcGuiConfig.automaticUpdateInterval)
        else:
            self.logInfoMsg("Status timer disabled.")
            self.__statusTimer.Stop()

    def onServicesSettings(self, event): # wxGlade: ArcJobToolWindow.<event_handler>
        """
        Show default services dialog
        """
        dialog = DefaultServicesDialog(self)
        dialog.arcGuiConfig = self.arcGuiConfig
        dialog.ShowModal()
        dialog.Destroy()
        
    def onCertInfoClose(self, event):
        """
        Handle close notification event from certificate info window.
        """
        self.__certInfoOpen = False
        
    def onWindowClose(self, event):
        """
        Event method handling window close. Ask user if configuration
        should be saved.
        """
        pass
        if wx.MessageBox("Save configuration?", "ARC Job Submission Tool", style=wx.YES_NO)==wx.YES:
            self.arcGuiConfig.write()
        
        self.Destroy()
        
    def onStatusTimer(self, event):
        """
        Event method handling timer event for updating
        job status. Starts a UpdateStatusThread.
        """
        self.logInfoMsg("Update status thread tick.")
        self.__updateStatus()

    def onProgressTimer(self, event):
        """
        Event method handling timer event for updating
        statusGauge when a working thread is active.
        """
        self.statusGauge.Pulse()
        wx.Yield()
        
    def onDownloadTimer(self, event):
        """
        Event method handling timer event for automatic downloading
        of jobs.
        """
        self.logInfoMsg("Download thread tick.")
        self.__downloadAllJobs()
        
    def onUpdateStatusDone(self, event):
        """
        Event method called when job status query is finished.
        """
        self.releaseProgress()
        self.__updateGrid()
        
    def onRetrieveJobsDone(self, event):
        """
        Event method called when all jobs have been downloaded.
        """
        self.releaseProgress()
        self.statusGauge.SetValue(0)
        self.__updateStatus()
        self.__updateDownloadList()
        
    def onCleanJobsDone(self, event):
        """
        Event method called when all jobs have been cleaned.
        """
        self.releaseProgress()
        self.statusGauge.SetValue(0)
        self.__updateStatus()

    def onKillJobsDone(self, event):
        """
        Event method called when all jobs have been killed.
        """
        self.releaseProgress()
        self.statusGauge.SetValue(0)
        self.__updateStatus()
        
    def onSubmitJobDone(self, event):
        """
        Event method called when job submit is finished.
        """
        self.releaseProgress()
        self.statusGauge.SetValue(0)
        
        submitJobCount = 0
        
        for result in event.resultList:
            try:
                a = result==None # This is a hack '==' does not work in arclib
            except:
                submitJobCount += 1
        
        failedJobCount = len(event.resultList)-submitJobCount
              
        i = 1
        submitReport = ""
        submitReport += "%d total jobs. (%d submitted, %d failed submission)." % (
            failedJobCount+submitJobCount, submitJobCount, failedJobCount
        )

        wx.MessageBox(submitReport, "Submitted jobs")
        
        self.__updateStatus()
                
    def onProgressUpdate(self, event):
        """
        Event method for handling status messages.
        """

        self.statusText.SetValue(event.info)
        
    def onLogUpdate(self, event):
        """
        Event method for handling log messages.
        """
        
        # Make sure to collect logs into hole lines
        
        outputLine = ""
        warningLine = ""
        errorLine = ""
        
        if event.output.find("\n")!=-1:
            self.__outputLine += event.output.split("\n")[0]
            outputLine = self.__outputLine
            self.__outputLine = ""
        else:
            self.__outputLine += event.output
            
        if outputLine!="":
            if outputLine.find("INFO")!=-1:
                self.logOutputText.GetDefaultStyle().SetTextColour("blue")
            elif outputLine.find("ERROR")!=-1:
                self.logOutputText.GetDefaultStyle().SetTextColour("red")
                errorLine = outputLine
            elif outputLine.find("WARNING")!=-1:
                self.logOutputText.GetDefaultStyle().SetTextColour("darkyellow")
                warningLine = warningLine
            elif outputLine.find("DEBUG")!=-1:
                self.logOutputText.GetDefaultStyle().SetTextColour("darkgreen")
                
            self.logOutputText.AppendText(str(outputLine+"\n"))
            self.logOutputText.Refresh()
                        
    def onAbout(self, event): # wxGlade: ArcJobToolWindow.<event_handler>
        """
        Event method handling about menu. Shows splash window.
        """
        arcSplash = ArcSplash(self)
        arcSplash.Show(True)

    def onNewJobDefinition(self, event): # wxGlade: ArcJobToolWindow.<event_handler>
        """
        Create a new job defintion
        
        Parses installed plugins and asks the users for which job definition
        to create.
        """
        plugins = self.__pluginMgr.plugins
        
        # Create a plugin name list and an instance dictionary for
        # looking up the correct plugin instance from the seletion
        
        pluginNames = []
        pluginInstances = {}
        
        for pluginClass in plugins:
            plugin = pluginClass()
            pluginNames.append(plugin.shortname)
            pluginInstances[plugin.shortname] = plugin
            
        # Ask user for definition plugin
            
        result = singleChoiceDialog(self, "Select job definition", "New job definition", pluginNames)
        if result.accepted:
            pluginShortname = result.selection
            plugin = pluginInstances[pluginShortname]
            
            # Ask for a definition name
            
            result = textEntryDialog(self, "Definition name", "New job definition", "noname")
            if result.accepted:
                self.logInfoMsg("Creating job definition.")
                
                # Create directory for definition
                
                jobName = result.text
                dirName = os.path.join(self.__definitionDir, jobName+".arcdef")
                
                if not os.path.exists(dirName):
                    
                    # Create job definition directory 
                
                    os.mkdir(dirName)
                    
                    # Add a plugin id file in job definition directory
                    
                    pluginIdFilename = os.path.join(dirName, "plugin.id")
                    pluginIdFile = open(pluginIdFilename, "w")
                    pluginIdFile.write(plugin.__class__.__name__)
                    pluginIdFile.close()                   
                    
                    # Ask the plugin to setup the directory

                    plugin.onSave(dirName)
                    plugin.onSetup()
                    
                    # Update job definition list
                    
                    self.__updateJobDefinitionList()
                    
                else:
                    wx.MessageBox("A job definition with the same name already exists.")

    def onSubmitJobDefinition(self, event): # wxGlade: ArcJobToolWindow.<event_handler>
        """
        Event method: Submit selected job definition.
        """
        self.__submitSelectedJobDefinition()

    def onOpenJobDefinition(self, event): # wxGlade: ArcJobToolWindow.<event_handler>
        """
        Event method for opening a job definition.
        """
        self.__openSelectedJobDefinition()

    def onDeleteJobDefinition(self, event): # wxGlade: ArcJobToolWindow.<event_handler>
        """
        Event method for deleting job definition.
        """
        self.__deleteSelectedJobDefinition() 

    def onJobDefinitionSelected(self, event): # wxGlade: ArcJobToolWindow.<event_handler>
        """
        Event method for setting current job definition selection.
        """
        self.__selectedJobDefinition = [event.GetIndex(), event.GetText()]

    def onJobDefinitionKeyDown(self, event): # wxGlade: ArcJobToolWindow.<event_handler>
        """
        Event method for handling keyboard entry in job definition icon view.
        """
        if event.GetKeyCode() == wx.WXK_DELETE:
            self.__deleteSelectedJobDefinition()

    def onJobDefinitionDeselected(self, event): # wxGlade: ArcJobToolWindow.<event_handler>
        """
        Event method for handling job definition deselection.
        """
        self.__selectedJobDefinition = []

    def onJobDefinitionActivated(self, event): # wxGlade: ArcJobToolWindow.<event_handler>
        """
        Event method for handling job definition activation.
        """
        self.__selectedJobDefinition = [event.GetIndex(), event.GetText()]
        self.__openSelectedJobDefinition()
        
    def onShowXrslDescription(self, event): # wxGlade: ArcJobToolWindow.<event_handler>
        """
        Event method for displaying the xrsl description for the
        selected job definition.
        """
        self.__showSelectedJobXrsl()

    def onActiveJobListDeselected(self, event): # wxGlade: ArcJobToolWindow.<event_handler>
        """
        Event method for handling unselecting an item in the active job list.
        """
        self.__selectedActiveJobs = []
        
    def onActiveJobListSelected(self, event): # wxGlade: ArcJobToolWindow.<event_handler>
        """
        Event method for handling selecting an item in the active job list.
        """
        self.__selectedActiveJobs.append(event.GetIndex())
        
    def onActiveJobListActivated(self, event): # wxGlade: ArcJobToolWindow.<event_handler>
        """
        Event method for handling double click in the active job list.
        """
        dialog = JobPropertiesDialog(self)
        dialog.jobDict = self.__arcClient.jobDict
        dialog.jobId =  str(self.activeJobList.GetItem(self.__selectedActiveJobs[0],0).GetText())
        dialog.ShowModal()
        dialog.Destroy()

    def onViewOutputFiles(self, event): # wxGlade: ArcJobToolWindow.<event_handler>
        """
        Event method for displaying the output files for a job definition.
        """
        self.__showSelectedJobFiles()
        
    def onCleanResults(self, event): # wxGlade: ArcJobToolWindow.<event_handler>
        self.__cleanSelectedResults()

    def onCleanDownloadedJobs(self, event): # wxGlade: ArcJobToolWindow.<event_handler>
        self.__cleanDownloadList()

    def onSubmitMissing(self, event): # wxGlade: ArcJobToolWindow.<event_handler>
        self.__submitMissing()
        
    def onActiveJobColClick(self, event): # wxGlade: ArcJobToolWindow.<event_handler>
        """
        Event method implementing a click on the column header for sorting
        the active jobs according to column header.
        """
        columnItem = self.activeJobList.GetColumn(event.GetColumn())
        fieldName = columnItem.GetText()
        self.__sortKey = fieldName
        self.__updateGrid()
        
    def onChangeWorkingDir(self, event): # wxGlade: ArcJobToolWindow.<event_handler>
        dlg = wx.DirDialog(None, "Choose working dir:", style=wx.DD_DEFAULT_STYLE | wx.DD_CHANGE_DIR)
        if dlg.ShowModal() == wx.ID_OK:
            self.__changeWorkingDir(dlg.GetPath())
        dlg.Destroy()
        
    def onJobProperties(self, event): # wxGlade: ArcJobToolWindow.<event_handler>
        
        if len(self.__selectedActiveJobs)==0:
            wx.MessageBox("Please select an active job.")
            return
        
        dialog = JobPropertiesDialog(self)
        dialog.jobDict = self.__arcClient.jobDict
        dialog.jobId =  str(self.activeJobList.GetItem(self.__selectedActiveJobs[0],0).GetText())
        dialog.ShowModal()
        dialog.Destroy()
        
    def onKillThreads(self, event): # wxGlade: ArcJobToolWindow.<event_handler>
        """
        Kill running threads
        
        Only _really_ affects retrieveJobsThread... 
        """
        if wx.MessageBox("Kill running threads?", "ARC Job Submission Tool", style=wx.YES_NO)==wx.YES:
            if self.__updateStatusThread.isAlive():
                self.__updateStatusThread.stop()
                
            if self.__retrieveJobsThread.isAlive():
                self.__retrieveJobsThread.stop()        
        
    def getLogLevel(self):
        """
        Return the current log level.
        """
        return arc.Logger_getRootLogger().getThreshold()
    
    def setLogLevel(self, level):
        """
        Set the current log level.
        """
        arc.Logger_getRootLogger().setThreshold(level)
        
    logLevel = property(getLogLevel, setLogLevel)


    def onNoteBookPageChanged(self, event): # wxGlade: ArcJobToolWindow.<event_handler>
        """
        Handle tab changing.
        """
        if event.GetSelection()==0:
            self.mainMenuBar.EnableTop(2, True)
            self.mainMenuBar.EnableTop(3, False)
        elif event.GetSelection()==1:
            self.mainMenuBar.EnableTop(2, False)
            self.mainMenuBar.EnableTop(3, True)
        else:
            self.mainMenuBar.EnableTop(2, False)
            self.mainMenuBar.EnableTop(3, False)

    def onNoteBookPageChanging(self, event): # wxGlade: ArcJobToolWindow.<event_handler>
        event.Skip()

# end of class ArcJobToolWindow
