# -*- coding: iso-8859-15 -*-
# generated by wxGlade HG on Fri Aug 28 10:05:56 2009

import wx

# begin wxGlade: extracode
# end wxGlade

from wx.lib.dialogs import *

import os

from arcjobtool.ArcUtils import *
from arcjobtool.Tasks import *
from arcjobtool.plugins.Plugins import *
from arcjobtool.PlatformUtils import *

runScriptTemplate = """#!/bin/sh
chmod +x ./%s
./%s
"""

class XrslTask(BaseTask):
    def __init__(self):
        BaseTask.__init__(self, createRunScript=False)
        
        self.description = "Xrsl"

        # Task specific attributes
        
        self.jobDescriptionFilename = "job.df"
        self.jobDescription = """&(executable="/bin/echo")
(arguments="hello")
(inputFiles=("run.sh" ""))
(outputFiles=("result.txt" ""))
(stdout="stdout.txt")
(stderr="stderr.txt")
(wallTime="5 minutes")
"""
        
    def onCreateRunScript(self, taskName, taskId):
        """
        Abstract routine responsible for returning a
        run-script for the job.
        """
        return runScriptTemplate % (self.__mainFile, self.__mainFile)
        
    def onCreateJobDescription(self, taskName, taskId, taskDir):
        """
        Abstract routines responsible for returning a jobdescription for
        the job.
        """
        
        # Create a managed job description
        
        job = arc.JobDescription();
        job.Parse(str(self.jobDescription % {"id":taskId, "taskdir":taskDir}))
        job.Identification.JobName = str(taskName)
        return job
    
    def loadJobDescription(self):
        """
        Loads the job description file from job definition dir.
        """
        descrFile = open(os.path.join(self.workDir, self.jobDescriptionFilename), "r")
        self.jobDescription = descrFile.read()
        descrFile.close()
        
    def saveJobDescription(self):
        """
        Saves the job definition file to job definition dir.
        """
        descrFile = open(os.path.join(self.workDir, self.jobDescriptionFilename), "w")
        descrFile.write(self.jobDescription)
        descrFile.close()
        
    
    def onSaveConfig(self, config):
        """
        Save configuration data specific to this plugin.
        """
        config.add_section("xrslplugin")
        config.set("xrslplugin", "descrfilename", self.jobDescriptionFilename)
        self.saveJobDescription()
    
    def onLoadConfig(self, config):
        """
        Loads configuration settings specific to this plugin.
        """
        try:
            self.jobDescriptionFilename = config.get("xrslplugin", "descrfilename")
        except:
            return
        
        self.loadJobDescription()
        
class XrslPlugin(PluginBase):
    def onInit(self):
        self.__task = XrslTask()
 
    def onDestroy(self):
        pass
    
    def onEdit(self):
        dlg = XrslPluginDialog(None, -1, "")
        dlg.task = self.__task
        dlg.ShowModal()
        dlg.Destroy()
        self.__task = dlg.task
    
    def onSave(self, workDir):
        (taskLocation, taskDirName) = os.path.split(workDir)
        self.__task.name = taskDirName.split(".")[0]
        self.__task.workDir = workDir
        self.__task.save()
    
    def onLoad(self, workDir):
        (taskLocation, taskDirName) = os.path.split(workDir)
        self.__task.name = taskDirName.split(".")[0]
        self.__task.workDir = workDir
        self.__task.load()
        
    def onClean(self):
        self.__task.clean()        
        
    def onSetup(self):
        self.__task.setup()
               
    def onGetId(self):
        return "XrslPlugin"
    
    def onGetVersion(self):
        return (0,1,0)
        
    def onGetDescription(self):
        return "Xrsl job definition plugin."
    
    def onGetShortName(self):
        return "Xrsl job definition."
    
    def onNeedSave(self):
        return self.__task.dirty
    
    def onGetTask(self):
        return self.__task
        
    id = property(onGetId)
    version = property(onGetVersion)
    shortname = property(onGetShortName)
    description = property(onGetDescription)
    task = property(onGetTask)


class XrslPluginDialog(wx.Dialog):
    def __init__(self, *args, **kwds):
        
        self.__applicationDir = os.path.dirname(sys.argv[0])

        if os.environ.has_key("ARCJOBTOOL_SHARE"):
            self.__imageDir = os.path.join(os.environ["ARCJOBTOOL_SHARE"], "images")
        else:
            self.__imageDir = os.path.join(self.__applicationDir, "../share/arcjobtool/images")
        
        ARCGUI_VALIDATE_XRSL = os.path.join(self.__imageDir, "preview-xrsl.png")
        ARCGUI_EDIT_XRSL = os.path.join(self.__imageDir, "document-new.png")
        ARCGUI_IMPORT_XRSL = os.path.join(self.__imageDir, "folder-open.png")
        
        # begin wxGlade: XrslPluginDialog.__init__
        kwds["style"] = wx.DEFAULT_DIALOG_STYLE|wx.RESIZE_BORDER|wx.THICK_FRAME
        wx.Dialog.__init__(self, *args, **kwds)
        self.notebook_1 = wx.Notebook(self, -1, style=0)
        self.generalPane = wx.Panel(self.notebook_1, -1)
        self.validateDescriptionButton = wx.BitmapButton(self.generalPane, -1, wx.Bitmap(ARCGUI_VALIDATE_XRSL,wx.BITMAP_TYPE_ANY), style=wx.NO_BORDER)
        self.editDescriptionButton = wx.BitmapButton(self.generalPane, -1, wx.Bitmap(ARCGUI_EDIT_XRSL,wx.BITMAP_TYPE_ANY), style=wx.NO_BORDER)
        self.importJobDescriptionButton = wx.BitmapButton(self.generalPane, -1, wx.Bitmap(ARCGUI_IMPORT_XRSL,wx.BITMAP_TYPE_ANY), style=wx.NO_BORDER)
        self.jobDescriptionText = wx.TextCtrl(self.generalPane, -1, "", style=wx.TE_MULTILINE|wx.HSCROLL|wx.TE_RICH)
        self.inputFilePane = wx.Panel(self.notebook_1, -1)
        self.inputFilesLabel = wx.StaticText(self.inputFilePane, -1, "Input files")
        self.inputFileList = wx.ListBox(self.inputFilePane, -1, choices=[])
        self.addFileButton = wx.Button(self.inputFilePane, -1, "Add...")
        self.createFileButton = wx.Button(self.inputFilePane, -1, "Create...")
        self.removeFileButton = wx.Button(self.inputFilePane, -1, "Remove")
        self.clearFilesButton = wx.Button(self.inputFilePane, -1, "Clear")
        self.inputFileEditButton = wx.Button(self.inputFilePane, -1, "Edit...")
        self.parameterPane = wx.Panel(self.notebook_1, -1)
        self.parameterFilesLabel = wx.StaticText(self.parameterPane, -1, "Parameter substitution files")
        self.paramFilesList = wx.ListBox(self.parameterPane, -1, choices=[])
        self.AddParamFileButton = wx.Button(self.parameterPane, -1, "Add...")
        self.removeParamFileButton = wx.Button(self.parameterPane, -1, "Remove")
        self.clearParamFilesButton = wx.Button(self.parameterPane, -1, "Clear")
        self.paramFileEditButton = wx.Button(self.parameterPane, -1, "Edit...")
        self.static_line_1 = wx.StaticLine(self.parameterPane, -1)
        self.sweepSizeLabel = wx.StaticText(self.parameterPane, -1, "Sweep size", style=wx.ALIGN_RIGHT)
        self.sweepSizeSpinner = wx.SpinCtrl(self.parameterPane, -1, "0", min=1, max=1000)
        self.saveButton = wx.Button(self, -1, "Save")
        self.closeButton = wx.Button(self, -1, "Close")

        self.__set_properties()
        self.__do_layout()

        self.Bind(wx.EVT_BUTTON, self.onValidateDescription, self.validateDescriptionButton)
        self.Bind(wx.EVT_BUTTON, self.onEditDescription, self.editDescriptionButton)
        self.Bind(wx.EVT_BUTTON, self.onImportJobDescription, self.importJobDescriptionButton)
        self.Bind(wx.EVT_BUTTON, self.onAddFile, self.addFileButton)
        self.Bind(wx.EVT_BUTTON, self.onCreateFile, self.createFileButton)
        self.Bind(wx.EVT_BUTTON, self.onRemoveFile, self.removeFileButton)
        self.Bind(wx.EVT_BUTTON, self.onClearFiles, self.clearFilesButton)
        self.Bind(wx.EVT_BUTTON, self.onEditInputFile, self.inputFileEditButton)
        self.Bind(wx.EVT_BUTTON, self.onAddParamFile, self.AddParamFileButton)
        self.Bind(wx.EVT_BUTTON, self.onRemoveParamFileButton, self.removeParamFileButton)
        self.Bind(wx.EVT_BUTTON, self.onClearParamFilesButton, self.clearParamFilesButton)
        self.Bind(wx.EVT_BUTTON, self.onEditParamFile, self.paramFileEditButton)
        self.Bind(wx.EVT_BUTTON, self.onSave, self.saveButton)
        self.Bind(wx.EVT_BUTTON, self.onClose, self.closeButton)
        # end wxGlade

    def __set_properties(self):
        # begin wxGlade: XrslPluginDialog.__set_properties
        self.SetTitle("XRSL job definition")
        self.SetSize((488, 421))
        self.validateDescriptionButton.SetToolTipString("Validate job description")
        self.validateDescriptionButton.SetSize(self.validateDescriptionButton.GetBestSize())
        self.editDescriptionButton.SetToolTipString("Edit with external editor")
        self.editDescriptionButton.SetSize(self.editDescriptionButton.GetBestSize())
        self.importJobDescriptionButton.SetToolTipString("Import job description")
        self.importJobDescriptionButton.SetSize(self.importJobDescriptionButton.GetBestSize())
        self.jobDescriptionText.SetFont(wx.Font(10, wx.SCRIPT, wx.NORMAL, wx.NORMAL, 0, "Courier"))
        self.sweepSizeLabel.SetMinSize((120, -1))
        # end wxGlade

    def __do_layout(self):
        # begin wxGlade: XrslPluginDialog.__do_layout
        sizer_1 = wx.BoxSizer(wx.VERTICAL)
        sizer_2 = wx.BoxSizer(wx.HORIZONTAL)
        sizer_11 = wx.BoxSizer(wx.VERTICAL)
        sizer_12 = wx.BoxSizer(wx.HORIZONTAL)
        sizer_13 = wx.BoxSizer(wx.HORIZONTAL)
        sizer_14 = wx.BoxSizer(wx.VERTICAL)
        sizer_9 = wx.BoxSizer(wx.VERTICAL)
        sizer_8 = wx.BoxSizer(wx.HORIZONTAL)
        sizer_9_copy = wx.BoxSizer(wx.VERTICAL)
        sizer_34 = wx.BoxSizer(wx.VERTICAL)
        sizer_35 = wx.BoxSizer(wx.HORIZONTAL)
        sizer_35.Add(self.validateDescriptionButton, 0, wx.ADJUST_MINSIZE, 0)
        sizer_35.Add(self.editDescriptionButton, 0, wx.ADJUST_MINSIZE, 0)
        sizer_35.Add(self.importJobDescriptionButton, 0, wx.ADJUST_MINSIZE, 0)
        sizer_34.Add(sizer_35, 0, wx.ALL|wx.EXPAND, 4)
        sizer_34.Add(self.jobDescriptionText, 1, wx.ALL|wx.EXPAND|wx.ADJUST_MINSIZE, 4)
        self.generalPane.SetSizer(sizer_34)
        sizer_9.Add(self.inputFilesLabel, 0, wx.LEFT|wx.TOP|wx.ADJUST_MINSIZE, 4)
        sizer_8.Add(self.inputFileList, 1, wx.ALL|wx.EXPAND|wx.ADJUST_MINSIZE, 4)
        sizer_9_copy.Add(self.addFileButton, 0, wx.ADJUST_MINSIZE, 0)
        sizer_9_copy.Add(self.createFileButton, 0, wx.ADJUST_MINSIZE, 0)
        sizer_9_copy.Add(self.removeFileButton, 0, wx.ADJUST_MINSIZE, 0)
        sizer_9_copy.Add(self.clearFilesButton, 0, wx.ADJUST_MINSIZE, 0)
        sizer_9_copy.Add(self.inputFileEditButton, 0, wx.TOP|wx.ADJUST_MINSIZE, 7)
        sizer_8.Add(sizer_9_copy, 0, wx.ALL|wx.EXPAND, 4)
        sizer_9.Add(sizer_8, 1, wx.EXPAND, 0)
        self.inputFilePane.SetSizer(sizer_9)
        sizer_11.Add(self.parameterFilesLabel, 0, wx.LEFT|wx.TOP|wx.ADJUST_MINSIZE, 4)
        sizer_13.Add(self.paramFilesList, 1, wx.ALL|wx.EXPAND|wx.ADJUST_MINSIZE, 4)
        sizer_14.Add(self.AddParamFileButton, 0, wx.ADJUST_MINSIZE, 0)
        sizer_14.Add(self.removeParamFileButton, 0, wx.ADJUST_MINSIZE, 0)
        sizer_14.Add(self.clearParamFilesButton, 0, wx.ADJUST_MINSIZE, 0)
        sizer_14.Add(self.paramFileEditButton, 0, wx.TOP|wx.ADJUST_MINSIZE, 7)
        sizer_13.Add(sizer_14, 0, wx.ALL|wx.EXPAND, 4)
        sizer_11.Add(sizer_13, 1, wx.EXPAND, 0)
        sizer_11.Add(self.static_line_1, 0, wx.TOP|wx.EXPAND, 5)
        sizer_12.Add(self.sweepSizeLabel, 0, wx.ALIGN_CENTER_VERTICAL|wx.ADJUST_MINSIZE, 0)
        sizer_12.Add(self.sweepSizeSpinner, 0, wx.TOP|wx.ADJUST_MINSIZE, 2)
        sizer_11.Add(sizer_12, 0, wx.TOP|wx.BOTTOM|wx.EXPAND, 4)
        self.parameterPane.SetSizer(sizer_11)
        self.notebook_1.AddPage(self.generalPane, "XRSL")
        self.notebook_1.AddPage(self.inputFilePane, "Input files")
        self.notebook_1.AddPage(self.parameterPane, "Parameters")
        sizer_1.Add(self.notebook_1, 1, wx.ALL|wx.EXPAND, 8)
        sizer_2.Add(self.saveButton, 0, wx.ADJUST_MINSIZE, 0)
        sizer_2.Add(self.closeButton, 0, wx.ADJUST_MINSIZE, 0)
        sizer_1.Add(sizer_2, 0, wx.LEFT|wx.RIGHT|wx.BOTTOM|wx.ALIGN_CENTER_HORIZONTAL, 4)
        self.SetSizer(sizer_1)
        self.Layout()
        # end wxGlade
        
    def __setupInputFiles(self):
        """
        Setup listbox for input files and choice box
        for selecting main file.
        """
        self.inputFileList.Clear()
        
        filenameDict = {}
        count = 0
        
        # Fill listbox and choice box
        
        if self.__task!=None:
            for inputFile in self.__task.inputFiles.keys():
                self.inputFileList.Append(inputFile)
                filenameDict[inputFile] = count
                count = count + 1 
            
    def __setupSweepFiles(self):

        self.paramFilesList.Clear()
        
        # Fill listbox
        
        if self.__task!=None:
            for sweepFile in self.__task.sweepFiles.keys():
                self.paramFilesList.Append(sweepFile)
                    

    def onSave(self, event): # wxGlade: XrslPluginDialog.<event_handler>
        #self.__task.cpuTime = int(self.cpuTimeText.GetValue())
        #self.__task.notify = self.notifyText.GetValue()
        #self.__task.memory = int(self.memoryText.GetValue())
        self.__task.sweepSize = int(self.sweepSizeSpinner.GetValue())
        self.__task.jobDescription = str(self.jobDescriptionText.GetValue())
        self.__task.dirty = True
        self.Close()

    def onClose(self, event): # wxGlade: XrslPluginDialog.<event_handler>
        self.__task.dirty = False
        self.Close()
        
    def setTask(self, task):
        self.__task = task
        
        #self.jobNameText.SetValue(self.__task.name)
        #self.cpuTimeText.SetValue(str(self.__task.cpuTime))
        #self.notifyText.SetValue(self.__task.notify)
        #self.memoryText.SetValue(str(self.__task.memory))
        self.sweepSizeSpinner.SetValue(int(self.__task.sweepSize))
        self.jobDescriptionText.SetValue(self.task.jobDescription)
        
        self.__setupInputFiles()
        self.__setupSweepFiles()
        
    def getTask(self):
        return self.__task
    
    def onAddFile(self, event): # wxGlade: XrslPluginDialog.<event_handler>
        inputFilename = wx.FileSelector("Add input file", default_path=os.getcwd())
        if inputFilename != "":
            self.__task.addAndCopyInputFile(inputFilename)
            self.__setupInputFiles()

    def onRemoveFile(self, event): # wxGlade: XrslPluginDialog.<event_handler>
        if self.inputFileList.GetStringSelection()!="":
            self.__task.removeInputFile(self.inputFileList.GetStringSelection())
            self.__setupInputFiles()

    def onClearFiles(self, event): # wxGlade: XrslPluginDialog.<event_handler>
        self.__task.clearInputFiles()
        self.__setupInputFiles()

    def onAddParamFile(self, event): # wxGlade: XrslPluginDialog.<event_handler>
        result = singleChoiceDialog(self, "Add file for substitution", "Input files", self.__task.inputFiles)
        if result.accepted:
            self.__task.addSweepFile(result.selection)
            self.__setupSweepFiles()

    def onRemoveParamFileButton(self, event): # wxGlade: XrslPluginDialog.<event_handler>
        if self.paramFilesList.GetStringSelection()!="":
            self.__task.removeSweepFile(self.paramFilesList.GetStringSelection())
            self.__setupSweepFiles()

    def onClearParamFilesButton(self, event): # wxGlade: XrslPluginDialog.<event_handler>
        self.__task.clearSweepFiles()
        self.__setupSweepFiles()

    def onEditInputFile(self, event): # wxGlade: XrslPluginDialog.<event_handler>
        if self.inputFileList.GetStringSelection()!="":
            fullPath = os.path.join(self.__task.workDir,self.inputFileList.GetStringSelection())
            editFile(fullPath)

    def onEditParamFile(self, event): # wxGlade: XrslPluginDialog.<event_handler>
        if self.paramFilesList.GetStringSelection()!="":
            fullPath = os.path.join(self.__task.workDir,self.paramFilesList.GetStringSelection())
            editFile(fullPath)

    def onCreateFile(self, event): # wxGlade: XrslPluginDialog.<event_handler>
        result = textEntryDialog(self, "Create file", "Filename", "noname.txt")
        
        if result.accepted:
            fullPath = os.path.join(self.__task.workDir, str(result.text))
            
            newFile = open(fullPath, "w")
            newFile.close()
            
            editFile(fullPath)

            self.__task.addAndCopyInputFile(fullPath, copyFile = False)
            self.__setupInputFiles()

    def onValidateDescription(self, event): # wxGlade: XrslPluginDialog.<event_handler>
        """
        Validate job description.
        """
        
        currDir = os.getcwd()
        
        os.chdir(self.__task.workDir)
        
        job = ManagedJobDescription()

        self.__task.jobDescription = str(self.jobDescriptionText.GetValue())

        try:
            jobDescription = self.__task.jobDescription % {"taskdir":self.__task.workDir}
        except:
            pass
        
        if job.Parse(str(jobDescription)) and job.UnParse("xrsl"):
            wx.MessageBox("Job description checks out ok.")
        else:
            wx.MessageBox("Job description does not validate. Please check log for more details.")
            
        os.chdir(currDir)

    def onEditDescription(self, event): # wxGlade: XrslPluginDialog.<event_handler>
        """
        Edit job description with external editor.
        """
        editFile(os.path.join(self.__task.workDir, self.__task.jobDescriptionFilename))
        self.__task.loadJobDescription()
        
    def onImportJobDescription(self, event): # wxGlade: XrslPluginDialog.<event_handler>
        inputFilename = wx.FileSelector("Import XRSL file", default_path=os.getcwd())
        if inputFilename != "":
            descrFile = open(inputFilename, "r")
            jobDescription = descrFile.read()
            descrFile.close()
            
            self.jobDescriptionText.SetValue(jobDescription)

    task = property(getTask, setTask)        

            

# end of class XrslPluginDialog

if __name__ == "__main__":
    app = wx.PySimpleApp(0)
    wx.InitAllImageHandlers()
    mainDialog = XrslPluginDialog(None, -1, "")
    app.SetTopWindow(mainDialog)
    mainDialog.Show()
    app.MainLoop()
