// -*- c++ -*-
//  Generated by gtkmmproc from ./../list.gen_h -- DO NOT MODIFY!
#ifndef _GTKMM_LIST_H
#define _GTKMM_LIST_H

/* $Id: list.h,v 1.2 2003/06/17 16:37:40 pbd Exp $ */

/* list.h
 *
 * Copyright (C) 1998-1999 The Gtk-- Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtk--/container.h>
#include <gtk--/listitem.h>
#include <gtk/gtklist.h>

namespace Gtk {
class List;
class List_Class;
}
namespace Gtk { Gtk::List *wrap (GtkList *o); }
namespace Gtk
{

namespace List_Helpers
{

  class ItemList
    {
      public:
        typedef ListItem*                       value_type;
        typedef value_type &                       reference;
        typedef const value_type &                 const_reference;

        typedef G_List_Cpp_Iterator<GtkListItem,ListItem>        iterator;
        typedef G_List_ConstIterator<iterator>     const_iterator;
        typedef G_List_ReverseIterator<iterator>   reverse_iterator;
        typedef G_List_ConstIterator<reverse_iterator>   const_reverse_iterator;

        typedef size_t                             difference_type;
        typedef size_t                             size_type;

      private:
        friend class Gtk::List;
        Gtk::List *parent_;
        explicit ItemList(List* parent): parent_(parent) {}

        GList*& glist() const;      // front of list

        iterator begin_() const;
        iterator end_() const;

      public:
        ~ItemList() {}

        inline iterator begin()
          {return begin_();}
        inline iterator end()
          {return end_();}

        inline const_iterator begin() const
          { return const_iterator(begin_()); }
        inline const_iterator end() const
          { return const_iterator(end_()); }

        inline reverse_iterator rbegin()
          { return reverse_iterator(end_()); }
        inline reverse_iterator rend()
          { return reverse_iterator(begin_()); }

        inline const_reverse_iterator rbegin() const
          { return const_reverse_iterator(reverse_iterator(end_())); }
        inline const_reverse_iterator rend() const
          { return const_reverse_iterator(reverse_iterator(begin_())); }

        size_type size(void) const;
        inline size_type max_size(void) { return size_type(-1); }
        inline bool empty(void) { return glist() == 0; }

        iterator insert(iterator position, ListItem& e);
        template <class InputIterator>
        inline void insert(iterator position, InputIterator first, InputIterator last)
          { for (;first!=last;++first) position=insert(position,*first); }

        inline void push_front(ListItem& e) { insert(begin(), e); }
        inline void push_back(ListItem& e)  { insert(end(), e); }
        inline void pop_front()                  { erase(begin()); }
        inline void pop_back()                   { erase(--end()); }

        void clear();

        iterator erase(iterator);
        void erase(iterator start, iterator stop);
        void remove(const_reference);

        void remove(Widget& w);

     };

  class SelectionList
    {
      public:
        typedef ListItem*                       value_type;
        typedef value_type &                       reference;
        typedef const value_type &                 const_reference;

        typedef G_List_Cpp_Iterator<GtkListItem,ListItem>        iterator;
        typedef G_List_ConstIterator<iterator>     const_iterator;
        typedef G_List_ReverseIterator<iterator>   reverse_iterator;
        typedef G_List_ConstIterator<reverse_iterator>   const_reverse_iterator;

        typedef size_t                             difference_type;
        typedef size_t                             size_type;

      private:
        friend class Gtk::List;
        Gtk::List *parent_;
        explicit SelectionList(List* parent): parent_(parent) {}

        GList*& glist() const;      // front of list

        iterator begin_() const;
        iterator end_() const;

      public:
        ~SelectionList() {}

        inline iterator begin()
          {return begin_();}
        inline iterator end()
          {return end_();}

        inline const_iterator begin() const
          { return const_iterator(begin_()); }
        inline const_iterator end() const
          { return const_iterator(end_()); }

        inline reverse_iterator rbegin()
          { return reverse_iterator(end_()); }
        inline reverse_iterator rend()
          { return reverse_iterator(begin_()); }

        inline const_reverse_iterator rbegin() const
          { return const_reverse_iterator(reverse_iterator(end_())); }
        inline const_reverse_iterator rend() const
          { return const_reverse_iterator(reverse_iterator(begin_())); }

        size_type size(void) const;
        inline size_type max_size(void) { return size_type(-1); }
        inline bool empty(void) { return glist() == 0; }

     };

};

//: Widget for packing a list of selectable items.
//- The {\class Gtk::List} widget is a container whose children are displayed
//- vertically in order, and can be selected. The list has many selection
//- modes, which are programmer selective and depend on how many elements
//- are able to be selected at the same time.
// Gtk_List is somewhat broken. To insert anything useful to list at its
// current state, use Gtk_Container::add(Gtk_Widget*)
class List : public Container {

public:
  typedef List          CppObjectType;
  typedef List_Class    CppClassType;
  typedef GtkList           BaseObjectType;
  typedef GtkListClass      BaseClassType;

private:
  friend class List_Class;
  static CppClassType list_class;

  List(const List&);
  List& operator=(const List&); // not implemented

protected:
  void   initialize_class();
  explicit List(GtkList *castitem);

public:
  static GtkType get_type();
  GtkList* gtkobj()             { return (GtkList*)(gtkobject); }
  const GtkList* gtkobj() const { return (GtkList*)(gtkobject); }
  static bool isA(Object *checkcast);

  // Hook for proxies
  static const char* const signal_names[];

  virtual ~List();

private:

public:
  typedef List_Helpers::ItemList ItemList;
  typedef List_Helpers::SelectionList SelectionList;

  List();



  //: The selection of the widget has just changed.



  //: The child widget has just been selected.





  //: The child widget has just been unselected.




  template <class iterator>
  void append_items(iterator start,iterator stop);
  template <class iterator>
  void prepend_items(iterator start,iterator stop);
  template <class iterator>
  void insert_items(iterator start,iterator stop,int pos);
  template <class iterator>
  void remove_items(iterator start,iterator stop);

  //: Inserts items into the list at the position position.
  //- items: The items.
  //- position: The position to insert items, starting at 0.


  void insert_items(GList* items,gint position);

  //: Adds items to the end of the list.
  //- items: The items.


  void append_items(GList* items);

  //: Inserts items at the beginning of the list.
  //- items: The items.


  void prepend_items(GList* items);

  //: Removes the items from the list.
  //- items: The items to remove.


  void remove_items(GList* items);

  //: Removes the items from the list, without unreferencing them.
  //: It may be useful if you want to move the items from one list to another.
  //- items: The items.


  void remove_items_no_unref(GList* items);

  //: Removes the items between index start (included) and end (excluded) from the list.
  //- If end is negative, or greater than the number of children of list, it's assumed
  //- to be exactly the number of elements. If start is greater than or equal to end,
  //- nothing is done.
  //-
  //- start: The index of the first item to remove.
  //-
  //- end: The index of the lest item to remove plus one.


  void clear_items(gint start,gint end);

  //: Selects the child number item of the list.
  //- Nothing happens if item is out of bounds. The signal {Gtk::List::select-child}
  //- will be emitted.
  //-
  //- item: The index of the child to select.


  void select_item(gint item);

  //: Unselects the child number item of the list.
  //- Nothing happens if item is out of bounds. The signal {Gtk::List::unselect-child}
  //- will be emitted.
  //-
  //- item: The index of the child to unselect.


  void unselect_item(gint item);

  // need to fix gtk+ on the const
  //: Searches the children of list for the index of child.
  //- child: The child to look for.
  //-
  //- Returns: The index of the child, -1 if not found.


  gint child_position(Gtk::Widget& child);

  //: Set the list selection mode.
  //- The selection mode can be any value in {Gtk::SelectionMode}:
  //-
  //- {\enum GTK_SELECTION_SINGLE}: Zero or one element may be selected.
  //-
  //- {\enum GTK_SELECTION_BROWSE}: Exactly one element is always selected (this
  //- can be false after you have changed the selection mode).
  //-
  //- {\enum GTK_SELECTION_MULTIPLE}: Any number of elements may be selected.
  //- Clicks toggle the state of an item.
  //-
  //- {\enum GTK_SELECTION_EXTENDED}: Any number of elements may be selected.
  //- Click-drag selects a range of elements; the Ctrl key may be used to enlarge
  //- the selection, and Shift key to select between the focus and the child pointed
  //- to.
  //-
  //- mode: The new selection mode.


  void set_selection_mode(GtkSelectionMode mode);


  ItemList& items()
    { return reinterpret_cast<ItemList&>(list_self); }
  const ItemList& items() const
    { return reinterpret_cast<const ItemList&>(list_self); }

  SelectionList& selection()
    { return reinterpret_cast<SelectionList&>(list_self); }
  const SelectionList& selection() const
    { return reinterpret_cast<const SelectionList&>(list_self); }

public:

    class Proxy_select_child
      : public Gtk::EmitProxySignal1<void,GtkWidget*,CppObjectType,BaseObjectType,1,&gtk_list_select_child>
      {
          typedef Gtk::EmitProxySignal1<void,GtkWidget*,CppObjectType,BaseObjectType,1,&gtk_list_select_child> BaseType;
        public:
          void operator ()(Gtk::Widget&);
          void emit(Gtk::Widget&);
          Connection connect(const SigC::Slot1<void,Gtk::Widget&> &s);
      };
    class Proxy_unselect_child
      : public Gtk::EmitProxySignal1<void,GtkWidget*,CppObjectType,BaseObjectType,2,&gtk_list_unselect_child>
      {
          typedef Gtk::EmitProxySignal1<void,GtkWidget*,CppObjectType,BaseObjectType,2,&gtk_list_unselect_child> BaseType;
        public:
          void operator ()(Gtk::Widget&);
          void emit(Gtk::Widget&);
          Connection connect(const SigC::Slot1<void,Gtk::Widget&> &s);
      };
  union
    {
      CppObjectType * list_self;
      Gtk::ProxySignal0<void,CppObjectType,BaseObjectType,0> selection_changed;
      Proxy_select_child select_child;
      Proxy_unselect_child unselect_child;
    };

protected:
  // impl functions
    virtual void selection_changed_impl();
    virtual void select_child_impl(Gtk::Widget& p0);
    virtual void unselect_child_impl(Gtk::Widget& p0);

};

template <class iterator>
void List::insert_items(iterator start, iterator stop, gint pos)
  {
    GList* items=gtkmm_build_glist(start,stop);
    if (items) gtk_list_insert_items(gtkobj(),items,pos);
  }

template <class iterator>
void List::prepend_items(iterator start, iterator stop)
  {
    GList* items=gtkmm_build_glist(start,stop);
    if (items) gtk_list_prepend_items(gtkobj(),items);
  }

template <class iterator>
void List::append_items(iterator start, iterator stop)
  {
    GList* items=gtkmm_build_glist(start,stop);
    if (items) gtk_list_append_items(gtkobj(),items);
  }

template <class iterator>
void List::remove_items(iterator start, iterator stop)
  {
    GList* items=gtkmm_build_glist(start,stop);
    if (items) gtk_list_remove_items(gtkobj(),items);
    g_list_free(items);
  }


}


//+ PROPERTIES(Gtk_List)
//. name: children
//. type: GList*
//. get:
//. set:
//. desc:

//. name: selection
//. type: GList*
//. get:
//. set:
//. desc:

//. name: undo_selection
//. type: GList*
//. get:
//. set:
//. desc:

//. name: undo_unselection
//. type: GList*
//. get:
//. set:
//. desc:

//. name: last_focus_child
//. type: Gtk_Widget*
//. get:
//. set:
//. desc:

//. name: undo_focus_child
//. type: Gtk_Widget*
//. get:
//. set:
//. desc:

//. name: htimer
//. type: guint
//. get:
//. set:
//. desc:

//. name: vtimer
//. type: guint
//. get:
//. set:
//. desc:

//. name: anchor
//. type: gint
//. get:
//. set:
//. desc:

//. name: drag_pos
//. type: gint
//. get:
//. set:
//. desc:

//. name: anchor_state
//. type: GtkStateType
//. get:
//. set:
//. desc:

//. name: selection_mode
//. type: guint:2
//. get:
//. set:
//. desc:

//. name: drag_selection
//. type: guint:1
//. get:
//. set:
//. desc:

//. name: add_mode
//. type: guint:1
//. get:
//. set:
//. desc:

#endif
