#include <ardour/curve.h>
#include <ardour/audioregion.h>

#include "region_gain_line.h"
#include "regionview.h"
#include "utils.h"

#include <ardour/session.h>

using namespace std;
using namespace ARDOUR;

AudioRegionGainLine::AudioRegionGainLine (string name, Session& s, AudioRegionView& r, GtkCanvasItem* parent,
					  Curve& c, 
					  gint (*point_callback)(GtkCanvasItem*, GdkEvent*, gpointer),
					  gint (*line_callback)(GtkCanvasItem*, GdkEvent*, gpointer))
	: AutomationLine (name, r.get_time_axis_view(), parent, c, point_callback, line_callback),
	  session (s),
	  rv (r)
{
	gtk_canvas_item_raise_to_top (group);
	set_verbose_cursor_uses_gain_mapping (true);
	terminal_points_can_slide = false;
}

void
AudioRegionGainLine::view_to_model_y (double& y)
{
	y = slider_position_to_gain (y);
	y = max (0.0, y);
	y = min (2.0, y);
}

void
AudioRegionGainLine::model_to_view_y (double& y)
{
	y = gain_to_slider_position (y);
}


