// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GTKMM_COMBOBOXENTRY_H
#define _GTKMM_COMBOBOXENTRY_H

#include <glibmm.h>

/* $Id: comboboxentry.h 4 2005-05-13 20:47:18Z taybin $ */

/* combobox.h
 * 
 * Copyright (C) 2003 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtkmm/combobox.h>
#include <gtkmm/entry.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GtkComboBoxEntry GtkComboBoxEntry;
typedef struct _GtkComboBoxEntryClass GtkComboBoxEntryClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{ class ComboBoxEntry_Class; } // namespace Gtk
namespace Gtk
{

/** A text entry field with a dropdown list
 * A ComboBoxEntry is a widget that allows the user to choose from a list of valid choices or enter a different 
 * value. It is very similar to a ComboBox, but it displays the selected value in an entry to allow modifying it.
 *
 * In contrast to a ComboBox, the underlying model of a ComboBoxEntry must always have a text column (see 
 * set_text_column()), and the entry will show the content of the text column in the selected row.
 *
 * See also ComboBoxEntryText, , which is specialised for a single text column.
 *
 * To add and remove strings from the list, just modify the model using its data manipulation API. You can get the * Entry by using get_child().
 *
 * @ingroup Widgets
 */

class ComboBoxEntry : public ComboBox
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef ComboBoxEntry CppObjectType;
  typedef ComboBoxEntry_Class CppClassType;
  typedef GtkComboBoxEntry BaseObjectType;
  typedef GtkComboBoxEntryClass BaseClassType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  virtual ~ComboBoxEntry();

#ifndef DOXYGEN_SHOULD_SKIP_THIS

private:
  friend class ComboBoxEntry_Class;
  static CppClassType comboboxentry_class_;

  // noncopyable
  ComboBoxEntry(const ComboBoxEntry&);
  ComboBoxEntry& operator=(const ComboBoxEntry&);

protected:
  explicit ComboBoxEntry(const Glib::ConstructParams& construct_params);
  explicit ComboBoxEntry(GtkComboBoxEntry* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GtkObject.
  GtkComboBoxEntry*       gobj()       { return reinterpret_cast<GtkComboBoxEntry*>(gobject_); }

  ///Provides access to the underlying C GtkObject.
  const GtkComboBoxEntry* gobj() const { return reinterpret_cast<GtkComboBoxEntry*>(gobject_); }


public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::


private:

public:
  ComboBoxEntry();
   //See ComboBoxEntryText for an equivalent of gtk_combo_box_entry_new_text().

  /** Creates a new ComboBoxEntry which has an Entry as child and a list of strings as popup. You can get the 
   * Entry from a ComboBoxEntry using get_entry(). To add and remove strings from the list, just modify @a model 
   * using its data manipulation API.
   *
   * @param model A TreeModel.
   * @param text_column A column in @a model to get the strings from.
   */
  explicit ComboBoxEntry(const Glib::RefPtr<TreeModel>& model, const TreeModelColumnBase& text_column);
  
  /** Creates a new ComboBoxEntry which has an Entry as child and a list of strings as popup. You can get the 
   * Entry from a ComboBoxEntry using get_entry(). To add and remove strings from the list, just modify @a model 
   * using its data manipulation API.
   *
   * @param model A TreeModel.
   * @param text_column A column in @a model to get the strings from.
   */
  explicit ComboBoxEntry(const Glib::RefPtr<TreeModel>& model, int text_column = 0);

  
  /** Sets the model column which @a entry_box  should use to get strings from
   * to be @a text_column .
   * 
   * Since: 2.4.
   * @param text_column A column in @a model  to get the strings from.
   */
  void set_text_column(const TreeModelColumnBase& text_column) const;   
  
  /** Sets the model column which @a entry_box  should use to get strings from
   * to be @a text_column .
   * 
   * Since: 2.4.
   * @param text_column A column in @a model  to get the strings from.
   */
  void set_text_column(int text_column) const; 
  
  /** Returns the column which @a entry_box  is using to get the strings from.
   * @return A column in the data source model of @a entry_box .
   * 
   * Since: 2.4.
   */
  int get_text_column() const; 

  //The child is always an entry:

  /** See Bin::get_entry().
   */
  Entry* get_entry();

  /** See Bin::get_entry().
   */
  const Entry* get_entry() const;                                      


};


} // namespace Gtk


namespace Glib
{
  /** @relates Gtk::ComboBoxEntry
   * @param object The C instance
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   */
  Gtk::ComboBoxEntry* wrap(GtkComboBoxEntry* object, bool take_copy = false);
}
#endif /* _GTKMM_COMBOBOXENTRY_H */

