
/*
 * Argus Client Software.  Tools to read, analyze and manage Argus data.
 * Copyright (C) 2000-2001 QoSient, LLC.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 */


#ifndef RaGator_h
#define RaGator_h

#include <stdlib.h>

#include <errno.h>
#include <stdio.h>
#include <string.h>


#include <netinet/in.h>
#include <ctype.h>
#include <argus-namedb.h>

#include <argus_filter.h>
 
#define RA_MODIFIED		1

#define RA_CON			1
#define RA_DONE			2

struct ArgusQueueHeader {
   int status, index;
   struct timeval lasttime, logtime;
};

struct RaQueueStruct {
   unsigned int head, tail, count, size;
   struct ArgusQueueHeader **array;
};


struct ArgusTimeStatsStruct {
   int n;
   long long sumtime;
   double sumsqrd;
};


struct ArgusListObjectStruct {
   struct ArgusListObjectStruct *nxt, *prv;
   void *obj;
};


struct ArgusListStruct {
   struct ArgusListObjectStruct *start;
   unsigned int count;
};


struct ArgusPathRecord {
   struct ArgusQueueHeader qhdr;
   struct RaHashTableHeader *rahtblhdr;
   struct ArgusRecord *argus;
};


struct ArgusRecordStore {
   struct ArgusQueueHeader qhdr;
   struct RaHashTableHeader *rahtblhdr;
   struct RaQueueStruct *queue;
   int status, farhdrstatus;
   struct ArgusFarHeaderStruct *farhdrs[32];
   int  ArgusTimeout;
   struct ArgusRecord *argus;
   struct ArgusAGRStruct agr;
   struct ArgusTimeStatsStruct act, idle;
};


char *RaPolicyError [] = {
   "Malformed String",
   NULL,
};

struct RaCIDRAddr {
   u_int addr, mask;
};

struct RaPolicyStruct {
   u_int RaEntryType, RaPolicyId;
   struct RaCIDRAddr src, dst;
   u_char proto;
   u_short sport, dport;
   u_int RaModelId, ArgusTimeout;
   char *str;
};


struct RaHashTableHeader {
   struct RaHashTableHeader *nxt, *prv;
   unsigned short hash;
   struct ArgusFlow flow;
   struct ArgusRecordStore *storeobj;
};

struct RaHashTableStruct {
   int size, count;
   struct RaHashTableHeader **array;
};

struct RaCIDRAddr RaCIDRBuffer, *RaCIDRPtr = &RaCIDRBuffer;

int RaThisFlowNum = 0;
int RaThisModelNum = 0;
int RaParseError = 0;


struct RaHashTableStruct RaHashTable;

struct RaPolicyStruct  *RaFlowArray[1024];
struct RaPolicyStruct *RaModelArray[1024];

struct RaPolicyStruct *RaFlowModelPolicy = NULL;

struct RaQueueStruct *RaModelerQueue = NULL;

int RaPolicyMatch (struct ArgusRecord *, struct RaPolicyStruct *);

int RaCIDRAddrMatches (u_int, struct RaCIDRAddr *);
int RaProtoMatches (u_short, int);
int RaPortMatches (u_short p1, u_short p2);

unsigned int RaIndexArgusRecord (struct ArgusRecord *, struct ArgusFarHeaderStruct **);

struct RaPolicyStruct *RaFlowModelOverRides (struct ArgusRecord *);
void RaModifyFlow(struct RaPolicyStruct *, struct ArgusRecord *);
void RaModifyDefaultFlow(struct ArgusRecord *);

struct RaHashTableHeader *RaFindHashObject (void);
struct RaHashTableHeader *RaAddHashEntry (struct ArgusRecordStore *);
void RaRemoveHashEntry (struct RaHashTableHeader *);

void RaSendArgusRecord(struct ArgusRecordStore *);

struct ArgusListStruct *ArgusNewList(void);
void ArgusDeleteList(struct ArgusListStruct *);
int ArgusListEmpty (struct ArgusListStruct *);
int ArgusGetListCount (struct ArgusListStruct *);
void *ArgusFrontList (struct ArgusListStruct *);
void ArgusPushFrontList(struct ArgusListStruct *, void *);
void ArgusPopFrontList (struct ArgusListStruct *);
void ArgusPushBackList (struct ArgusListStruct *, void *);
void ArgusPopBackList  (struct ArgusListStruct *);


struct RaQueueStruct *RaNewQueue (int);
void RaDeleteQueue (struct RaQueueStruct *);

int RaGetQueueCount(struct RaQueueStruct *);

void RaPushQueue(struct RaQueueStruct *, struct ArgusQueueHeader *);
void RaAddToQueue(struct RaQueueStruct *, struct ArgusQueueHeader *);

struct ArgusQueueHeader *RaPopQueue(struct RaQueueStruct *);
struct ArgusQueueHeader *RaRemoveFromQueue(struct RaQueueStruct *, struct ArgusQueueHeader *);

void RaEmptyQueue(struct RaQueueStruct *);
 
int RaCheckTimeout(struct ArgusRecordStore *obj);

void RaProcessQueue(struct RaQueueStruct *, unsigned char state);
void RaEmptyQueue(struct RaQueueStruct *);

struct ArgusRecordStore *RaFindArgusRecord (struct ArgusRecord *);
struct ArgusRecordStore *RaNewArgusStore (struct ArgusRecord *, int);
void RaRemoveArgusRecord (struct ArgusRecord *);

void RaMergeArgusRecord (struct ArgusRecord *, struct ArgusRecordStore *);

void RaUpdateArgusStore(struct ArgusRecord *, struct ArgusRecordStore *);
void RaTimeoutArgusStore (struct ArgusRecordStore *);

int RaCreatePolicyEntry (char *);
int RaReadFlowModelFile (void);

struct RaPolicyStruct *RaParsePolicyEntry (char *);

struct RaCIDRAddr *RaParseCIDRAddr (char *);

#endif
