/*
 * Copyright (c) 2000-2001 QoSient, LLC
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

/*
 * Copyright (c) 1990, 1991, 1992, 1993
 *   The Regents of the University of California.  All rights reserved.
 *
 * This code is derived from the Stanford/CMU enet packet filter,
 * (net/enet.c) distributed as part of 4.3BSD, and code contributed
 * to Berkeley by Steven McCanne and Van Jacobson both of Lawrence 
 * Berkeley Laboratory.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *   This product includes software developed by the University of
 *   California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *   @(#)bpf.c   7.5 (Berkeley) 7/15/91
 *
 */


#ifndef ArgusFilter_h
#define ArgusFilter_h

#include <errno.h>
#include <string.h>
#include <stdarg.h>

#include <gencode.h>

#ifndef __GNUC__
#define inline
#endif

/*
 * If a protocol is unknown, PROTO_UNDEF is returned.
 * Also, s_nametoport() returns the protocol along with the port number.
 * If there are ambiguous entried in /etc/services (i.e. domain
 * can be either tcp or udp) PROTO_UNDEF is returned.
 */
#define PROTO_UNDEF             -1



#ifdef ArgusFilter

u_int ArgusThisFarStatus = 0;
struct ArgusFarHeaderStruct *ArgusThisFarHdrs[32];

void ArgusPrintHex (const u_char *, u_int);
int argus_lookupnet(char *, u_int *, u_int *, char *);
char *read_infile(char *);

static inline int xdtoi(int c);
u_int argus_filter (struct bpf_insn *pc, u_char *);
u_int argus_filter_orig (struct bpf_insn *, u_char *, int, int);

static inline int skip_space(FILE *);
static inline int skip_line(FILE *);

static inline int skip_space(FILE *);
static inline int skip_line(FILE *);
struct pcap_etherent *argus_next_etherent(FILE *fp);
char *argus_lookupdev(char *);

int argus_lookupnet(char *, u_int *, u_int *, char *);
char *argus_strerror(int);

void Argusbpf_optimize(struct block **);

struct bpf_insn *Argusicode_to_fcode(struct block *, int *);
static char *bpf_image(struct bpf_insn *, int);
int stoi( char *);

#ifdef NOVFPRINTF
int vfprintf( FILE *, char *, va_list);
#endif

void ArgusDebug (int, char *, ...);
void *ArgusCalloc (int, int);
void ArgusFree (void *);

#if __STDC__
void error(const char *fmt, ...);
#else
void error(const char *fmt, va_dcl);
#endif

#if defined(_LITTLE_ENDIAN)
void ArgusNtoH (struct ArgusRecord *argus);
void ArgusHtoN (struct ArgusRecord *argus);
#endif

char *savestr(const char *);
char *copy_argv( char **);
char *read_infile(char *);
u_int ipaddrtonetmask(u_int);
u_int getnetnumber(u_int);

void bpf_dump(struct bpf_program *, int);

char *intoa(u_int);
static SIGRET nohostname(int);
char * getname(u_char *);
static inline struct enamemem *lookup_emem(const u_char *);
static inline struct enamemem *lookup_nsap(const u_char *);
static inline struct protoidmem *lookup_protoid(const u_char *);

char *etheraddr_string(unsigned char *);
char *etherproto_string(unsigned short port);
char *protoid_string(const u_char *);
char *llcsap_string(unsigned char);
char *isonsap_string(const unsigned char *);
char *tcpport_string(unsigned short);
char *udpport_string(unsigned short);

static void init_servarray(void);
static void init_eprotoarray(void);
static void init_protoidarray(void);
static void init_etherarray(void);
static void init_llcsaparray(void);

void init_addrtoname(int, u_int, u_int);
u_int **argus_nametoaddr(char *);
u_int argus_nametonetaddr(char *);
int argus_nametoport(char *, int *, int *);
int argus_nametoproto(char *);
int argus_nametoeproto(char *);
u_int __argus_atoin(char *, u_int *);
u_int __argus_atodn(char *);

unsigned char *argus_ether_aton(char *);
unsigned char *argus_ether_hostton(char *);
unsigned short __argus_nametodnaddr(char *);


#else

extern u_int ArgusThisFarStatus;
extern struct ArgusFarHeaderStruct *ArgusThisFarHdrs[];

extern void ArgusPrintHex (const u_char *, u_int);
extern int argus_lookupnet(char *, u_int *, u_int *, char *);
extern char *read_infile(char *);

extern u_int argus_filter (struct bpf_insn *pc, u_char *);
extern u_int argus_filter_orig (struct bpf_insn *, u_char *, int, int);

extern struct pcap_etherent *argus_next_etherent(FILE *fp);
extern char *argus_lookupdev(char *);

extern int argus_lookupnet(char *, u_int *, u_int *, char *);
extern char *argus_strerror(int);

extern void Argusbpf_optimize(struct block **);

extern struct bpf_insn *Argusicode_to_fcode(struct block *, int *);
extern int stoi( char *);

#ifdef NOVFPRINTF
extern int vfprintf( FILE *, char *, va_list);
#endif

#if defined(_LITTLE_ENDIAN)
extern void ArgusNtoH (struct ArgusRecord *argus);
extern void ArgusHtoN (struct ArgusRecord *argus);
#endif


extern void ArgusDebug (int, char *, ...);
extern void *ArgusCalloc (int, int);
extern void ArgusFree (void *);

extern void error(va_list);
extern void warning(va_list);

extern char *savestr(const char *);
extern char *copy_argv( char **);
extern char *read_infile(char *);
extern u_int ipaddrtonetmask(u_int);
extern u_int getnetnumber(u_int);

extern void bpf_dump(struct bpf_program *, int);

extern char *intoa(u_int);
extern char * getname(u_char *);

extern char *etheraddr_string(unsigned char *);
extern char *etherproto_string(unsigned short);
extern char *protoid_string(const u_char *);
extern char *llcsap_string(unsigned char);
extern char *isonsap_string(const unsigned char *);
extern char *tcpport_string(unsigned short);
extern char *udpport_string(unsigned short);

extern void init_addrtoname(int, u_int, u_int);
extern u_int **argus_nametoaddr(char *);
extern u_int argus_nametonetaddr(char *);
extern int argus_nametoport(char *, int *, int *);
extern int argus_nametoproto(char *);
extern int argus_nametoeproto(char *);
extern u_int __argus_atoin(char *, u_int *);
extern u_int __argus_atodn(char *);

extern unsigned char *argus_ether_aton(char *);
extern unsigned char *argus_ether_hostton(char *);
extern unsigned short __argus_nametodnaddr(char *);

#endif
#endif  /* ArgusFilter_h */

