/* $Id: ArkLight.h,v 1.4 2003/03/15 17:49:04 mrq Exp $
**
** Ark - Libraries, Tools & Programs for MMORPG developpements.
** Copyright (C) 1999-2000 The Contributors of the Ark Project
** Please see the file "AUTHORS" for a list of contributors
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef ARK_LIGHT_H
#define ARK_LIGHT_H

#include <Ark/ArkMath.h>
#include <Ark/ArkObject.h>
#include <Ark/ArkRenderer.h>

namespace Ark
{
   enum LightType
   {
      LIGHT_AMBIENT, 
      LIGHT_DIRECTIONAL,
      LIGHT_POINT,
      LIGHT_SPOT
   };
    
   enum DecayRate
   {
      DECAY_NONE,
      DECAY_LINEAR,
      DECAY_QUADRATIC,
      DECAY_CUBIC
   };

   class Config;
    
   class ARK_DLL_API Light
   {
      public:
	 Light(LightType type = LIGHT_SPOT);

	 void SetColor (const Color &color) { m_Color = color; };
	 void SetPosition (const Vector3 &pos) { m_Pos = pos; };
	 void SetLightType (const LightType type);
	  
	 void SetAttenuation (float att) { m_Attenuation = att; }
	  
	 const Vector3& GetPosition () const {return m_Pos;};
	 const Color& GetColor () const {return m_Color;};
	 const LightType GetType () const {return m_Type;};
	 const float GetAttenuation () const {return m_Attenuation;}
	  
      protected:
	 /* OpenGL functions dealing with light position expect a 
	  * 4 component vector. m_Inf is the fourth component, so 
	  * keep the following 2 lines together if you reorder stuff there
	  */
	 Vector3 m_Pos;
	 scalar  m_Inf;
	  
	 enum LightType m_Type;
	 Color m_Color;
	 float m_Attenuation;
   };
}


#endif //ARK_LIGHT_H
