//types.h:

/*
 *      Copyright (C) Philipp 'ph3-der-loewe' Schafft - 2010-2012
 *
 *  This file is part of aroarfw, a RoarAudio framework for
 *  embedded systems (Controlers).
 *
 *  This file is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License version 3
 *  or (at your option) any later version as published by
 *  the Free Software Foundation.
 *
 *  aroarfw is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this software; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 51 Franklin Street, Fifth Floor,
 *  Boston, MA 02110-1301, USA.
 */

#ifndef _AROARFW_TYPES_H_
#define _AROARFW_TYPES_H_

#include <stdint.h>

//! Type for client IDs
typedef uint16_t rcid_t;

//! Type for Stream IDs
typedef uint16_t rsid_t;

//! Type for stream positions
typedef uint32_t rpos_t;

//! Type for process IDs
typedef uint32_t rpid_t;

//! Type of IO direction
typedef enum {
 // Invalid value
 RIODIR_INVALID = 0xFF,
 //! This stream has no defined IO direction
 RIODIR_NONE    = 0x00,
 //! This stream is a input stream
 RIODIR_IN      = 0x01,
 //! This stream is an output stream
 RIODIR_OUT     = 0x02,
 //! This stream is bidirectional
 RIODIR_INOUT   = RIODIR_IN|RIODIR_OUT
} riodir_t;

#endif

//ll
