# FindSystem match the operating system and set some
# CFLAGS for compile the source code.
#
# Usage:
#
#  find_package(System)
#
# Variables:
# CMAKE_C_FLAGS - flags to add to the C compiler for buil arpon
#
# Copyright 2014 <Giuseppe Marco Randazzo> gmrandazzo@gmail.com
#
# Redistribution AND use is allowed according to the terms of the BSD 3 clause

# GET LINUX DISTRIBUTION FOR PREPROCESSOR -DDEBIAN DIRECTIVE USED BY UBUNTU AND DEBIAN
macro(GET_DISTRO)
  set(ID_RELEASE)
  find_program(LSB_RELEASE NAMES lsb_release PATHS /bin
  /sbin
  /usr/bin
  /usr/sbin
  /usr/local/bin
  /usr/local/sbin)
  if(LSB_RELEASE)
    execute_process(COMMAND ${LSB_RELEASE} -i
      OUTPUT_VARIABLE ID_RELEASE)
    string(REGEX REPLACE ".*:" "" ID_RELEASE "${ID_RELEASE}")

    if(${ID_RELEASE} MATCHES "Ubuntu" OR ${ID_RELEASE} MATCHES "Debian" OR ${ID_RELEASE} MATCHES "LinuxMint")
      set( UBUNTU TRUE )
      set( DEBIAN TRUE )
      add_definitions( -DDEBIAN )
    endif(${ID_RELEASE} MATCHES "Ubuntu" OR ${ID_RELEASE} MATCHES "Debian" OR ${ID_RELEASE} MATCHES "LinuxMint")
  endif(LSB_RELEASE)
endmacro(GET_DISTRO)

if(APPLE)
  # Mac OS X specific code
  message(STATUS "Operating System Found: OS X")
elseif(UNIX)
  if(${CMAKE_SYSTEM_NAME} MATCHES "FreeBSD")
    # FreeBSD specific code
    message(STATUS "Operating System Found: FreeBSD")
    set(CMAKE_C_FLAGS "${CMAKE_C_FLAGS} -DFREEBSD")
  endif(${CMAKE_SYSTEM_NAME} MATCHES "FreeBSD")

  if(${CMAKE_SYSTEM_NAME} MATCHES "NetBSD")
    # NetBSD specific code
    message(STATUS "Operating System Found: NetBSD")
    set(CMAKE_C_FLAGS "${CMAKE_C_FLAGS} -DNETBSD")
  endif(${CMAKE_SYSTEM_NAME} MATCHES "NetBSD")

  if(${CMAKE_SYSTEM_NAME} MATCHES "OpenBSD")
    # OpenBSD specific code
    message(STATUS "Operating System Found: OpenBSD")
    set(CMAKE_C_FLAGS "${CMAKE_C_FLAGS} -DOPENBSD")
  endif(${CMAKE_SYSTEM_NAME} MATCHES "OpenBSD")

  if(${CMAKE_SYSTEM_NAME} MATCHES "DragonFly")
    # DragonFly BSD specific code
    message(STATUS "Operating System Found: DragonFly BSD")
    set(CMAKE_C_FLAGS "${CMAKE_C_FLAGS} -DFREEBSD")
  endif(${CMAKE_SYSTEM_NAME} MATCHES "DragonFly")

  if(${CMAKE_SYSTEM_NAME} MATCHES "SunOS")
    # Solaris specific code
    message(STATUS "Operating System Found: Solaris")
    set(CMAKE_C_FLAGS "${CMAKE_C_FLAGS} -DSOLARIS -lsocket -lresolv -lnsl")
  endif(${CMAKE_SYSTEM_NAME} MATCHES "SunOS")

  if(${CMAKE_SYSTEM_NAME} MATCHES "Linux")
    # Linux specific code
    message(STATUS "Operating System Found: Linux")
    set(CMAKE_C_FLAGS "${CMAKE_C_FLAGS} -DLINUX")
    GET_DISTRO()
  endif(${CMAKE_SYSTEM_NAME} MATCHES "Linux")
elseif(WIN32)
  message(FATAL_ERROR "Windows Operating System Not Supported")
else(APPLE)
  message(FATAL_ERROR "Operating System Not Supported")
endif(APPLE)
