/*
 * Copyright (c) 2001,2002 Tony Sideris
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*================================================*/
/*	Reads a user's config file from global and
 *	local locations.
 *
 *	by Tony Sideris	(09:36AM Mar 25, 2002)
 *================================================*/
#include "arson.h"

#include <kstddirs.h>
#include <kglobal.h>
#include <kurl.h>

#include "usercfg.h"

/*========================================================*/

int ArsonUserCfg::readConfig (const char *fname, bool userOnly)
{
	int res = 0;
	
	if (!userOnly)
	{
#ifdef ARSONDBG
		const QString cfg = fname;
#else
		const QString cfg = KGlobal::dirs()->findResource("config", fname);
#endif	//	ARSONDBG

		if (readCfg(cfg))
			res |= global;
	}

	if (readCfg(locateLocal("config", fname)))
		res |= local;

	return res;
}

/*========================================================*/

bool ArsonUserCfg::readCfg (const char *fname)
{
	Trace("ArsonUserCfg::readCfg reading %s\n", fname);

	try { return arsonParseXml(KURL(QString("file:") + fname), this); }
	catch (ArsonError &err) { return false; }
}

/*========================================================*/
