#include <pthread.h>

#include "notify.h"
#include "asdutil.h"

void notify_init(Notify *n)
{
  g_assert(n); 
  n->cond = g_cond_new(); 
  n->mutex = g_mutex_new(); 
  n->queued = FALSE; 
}

void notify_done(Notify *n) 
{ 
  g_assert(n); 
  g_cond_free(n->cond); 
  g_mutex_free(n->mutex); 
}

void notify_wait(Notify *n) 
{ 
  g_assert(n); 
  g_mutex_lock(n->mutex); 
  pthread_cleanup_push(g_mutex_unlock_cleanup_handler, n->mutex);

  if (!n->queued) 
    g_cond_wait(n->cond, n->mutex); 

  n->queued = FALSE; 
  pthread_cleanup_pop(1);    
}

void notify_signal(Notify *n) 
{ 
  g_assert(n); 
  // g_message("NOTIFY: %p", n);

  g_mutex_lock(n->mutex);
  n->queued = TRUE; 
  g_cond_broadcast(n->cond); 
  g_mutex_unlock(n->mutex); 
}
