#ifndef namespaceh
#define namespaceh

#include <glib.h>

#define NAMESPACE_ANY    0
#define NAMESPACE_SOURCE 1
#define NAMESPACE_SINK   2

gboolean namespace_register(gchar *name);
void namespace_unregister(gchar *name);

gboolean namespace_exists(gchar *name);
gpointer namespace_lookup_with_type(gchar *name, guint32 type);

#define namespace_lookup(name) namespace_lookup_with_type(name, NAMESPACE_ANY)

void namespace_set(gchar *name, gpointer ptr, guint32 type);

typedef void (*namespace_foreach_proc) (gchar *name, gpointer data, gpointer userdata);
void namespace_foreach(namespace_foreach_proc proc, guint32 type, gpointer userdata);

#endif
