------------------------------------------------------------------------------
--                                                                          --
--                            GNATPP COMPONENTS                             --
--                                                                          --
--              G N A T P P . S O U R C E _ T R A V E R S A L               --
--                                                                          --
--                                 S p e c                                  --
--                                                                          --
--                            1.4
--                                                                          --
--                   Copyright (C) 2001-2002, ACT Europe                    --
--                                                                          --
-- GNATPP is free software; you can redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion.  GNATPP is  distributed in the  hope that it will  be  useful, but --
-- WITHOUT ANY WARRANTY; without even the implied warranty of  MERCHANTABI- --
-- LITY or  FITNESS  FOR A  PARTICULAR  PURPOSE. See the GNU General Public --
-- License  for more details. You  should  have  received a copy of the GNU --
-- General Public License  distributed with GNAT; see file COPYING. If not, --
-- write  to  the Free  Software  Foundation,  59 Temple Place - Suite 330, --
-- Boston,                                                                  --
--                                                                          --
-- GNATPP is maintained by ACT Europe (http://www.act-europe.fr).           --
--                                                                          --
------------------------------------------------------------------------------

--  This package defines the main traversal engine for GNATPP.

with Asis;          use Asis;
with Asis.Iterator; use Asis.Iterator;

package GNATPP.Source_Traversal is

   type Source_Traversal_State is record
      Put_Postponed_Space : Boolean := True;
      --  Flag needed to control postponed spaces
   end record;

   Initial_State : constant Source_Traversal_State :=
      (Put_Postponed_Space => True);

   procedure Pre_Operation
     (Element : in     Asis.Element;
      Control : in out Traverse_Control;
      State   : in out Source_Traversal_State);
   --  Pre-operation for traversal. The general idea is to start
   --  pretty-printing of the Element being visited. See the body for more
   --  information

   procedure Post_Operation
     (Element : in     Asis.Element;
      Control : in out Traverse_Control;
      State   : in out Source_Traversal_State);
   --  Post-operation for traversal. The general idea is to complete
   --  pretty-printing of the Element being visited. See the body for more
   --  information

   procedure Traverse_Source is new Traverse_Element
     (State_Information => Source_Traversal_State);

   type Op_Access is access
      procedure
        (Element : in     Asis.Element;
         Control : in out Traverse_Control;
         State   : in out Source_Traversal_State);
   --  Used for look-up tables for specific pre- and post-operations

   procedure Nothing_To_Do
     (Element : in     Asis.Element;
      Control : in out Traverse_Control;
      State   : in out Source_Traversal_State);
   --  Does nothing, may be used as Pre- or Post-Operation

end GNATPP.Source_Traversal;
