------------------------------------------------------------------------------
--                                                                          --
--                      DISPLAY_SOURCE COMPONENTS                           --
--                                                                          --
--                              S T A C K S                                 --
--                                                                          --
--                                 B o d y                                  --
--                                                                          --
--            Copyright (c) 1995-1999, Free Software Foundation, Inc.       --
--                                                                          --
-- Display_Source is free software; you can redistribute it and/or modify it--
-- under terms of the  GNU General Public License  as published by the Free --
-- Software Foundation;  either version 2,  or  (at your option)  any later --
-- version. Display_Source is distributed in the hope  that it will be use- --
-- ful, but WITHOUT ANY WARRANTY; without even the implied warranty of MER- --
-- CHANTABILITY or  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General  --
-- Public License for more details. You should have received a copy of the  --
-- GNU General Public License distributed with GNAT; see file COPYING. If   --
-- not, write to the Free Software Foundation, 59 Temple Place Suite 330,   --
-- Boston, MA 02111-1307, USA.                                              --
--                                                                          --
-- Display_Source is distributed as a part of the ASIS implementation for   --
-- GNAT (ASIS-for-GNAT).                                                     --
--                                                                          --
-- The   original   version   of  Display_Source  has  been  developed  by  --
-- Jean-Charles  Marteau and Serge Reboul,  ENSIMAG  High School Graduates  --
-- (Computer sciences)  Grenoble,  France  in  Sema Group Grenoble, France. --
--                                                                          --
-- Display_Source is now maintained by Ada Core Technologies Inc            --
-- (http://www.gnat.com).                                                   --
------------------------------------------------------------------------------

-----------------------------------------------------------------
-- This package is part of the ASIS application display_source --
-----------------------------------------------------------------
package body Stacks is

   type T_Node is
      record
         Elem : aliased T_Elem;
         Next : Stack;
      end record;

   --  I don't like allocating new records to get rid
   --  of them in the next minute, so there is a record
   --  provider here that gets the old ones and give
   --  them back when needed. That means unemployment for
   --  garbage collectors ...  :)
   Stock : array (1 .. Initial_Number) of aliased T_Node;
   --  He he this is a stock of stack ...  :)

   Is_Provider_Initialized : Boolean := False;

   Provider : Stack := Stock (1)'Access;

   procedure Init_Provider;

   procedure Init_Provider is
   begin
      for I in 2 .. Initial_Number loop
         Stock (I - 1).Next := Stock (I)'Access;
      end loop;
      Stock (Initial_Number).Next := Empty_Stack;
   end Init_Provider;

   --  standard functions for a stack :
   --   Push puts an Elem on the top of the stack
   --   Pop gets the last pushed element of the stack
   procedure Push (St : in out Stack; Elem : in T_Elem) is
      Neu : Stack := Provider;
      --  Well as new is a reserved word, i use neu which is
      --  new in valencian, a language spoken in a spanish
      --  city on the east coast (east coast of spain ...)
      --  Isn't that exotic ?
   begin
      if Neu = Empty_Stack then
         --  Arg ! We got to do it !!!
         Neu := new T_Node;
      else
         Provider := Provider.Next;
      end if;
      Neu.Elem := Elem;
      Neu.Next := St;
      St := Neu;
   end Push;

   procedure Pop (St : in out Stack; Elem : out T_Elem) is
      Old : Stack := St;
   begin
      if St = Empty_Stack then
         raise Stack_Error;
      end if;
      Elem := St.Elem;
      St := St.Next;
      Old.Next := Provider;
      Provider := Old;
   end Pop;

   --  Upper lets you have access to the first Elem
   --  on the top of the stack.
   function Upper (St : in Stack) return A_Elem is
   begin
      if St = Empty_Stack then
         return null;
      else
         return St.Elem'Access;
      end if;
   end Upper;

   function Size_Of_Stack (St : in Stack) return Natural is
      Result : Natural := 0;
      Current : Stack := St;
   begin
      while Current /= Empty_Stack loop
         Result := Result + 1;
         Current := Current.Next;
      end loop;
      return Result;
   end Size_Of_Stack;

   function Is_Empty (St : in Stack) return Boolean is
   begin
      return St = Empty_Stack;
   end Is_Empty;

begin
   Init_Provider;
end Stacks;