/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicReference;
import org.cojen.classfile.ClassFile;
import org.cojen.classfile.CodeBuilder;
import org.cojen.classfile.Label;
import org.cojen.classfile.MethodDesc;
import org.cojen.classfile.Modifiers;
import org.cojen.classfile.RuntimeClassFile;
import org.cojen.classfile.TypeDesc;
import org.cojen.util.Cache;
import org.cojen.util.SoftValueCache;
import org.cojen.util.ThrowUnchecked;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BelatedCreator<T, E extends Exception> {
    private static final String REF_FIELD_NAME = "ref";
    private static final Cache<Class<?>, Class<?>> cWrapperCache = new SoftValueCache(17);
    private static final ExecutorService cThreadPool = Executors.newCachedThreadPool(new TFactory());
    private final Class<T> mType;
    final int mMinRetryDelayMillis;
    private T mReal;
    private boolean mFailed;
    private Throwable mFailedError;
    private T mBogus;
    private AtomicReference<T> mRef;
    private CreateThread mCreateThread;

    protected BelatedCreator(Class<T> type, int minRetryDelayMillis) {
        if (type == null) {
            throw new IllegalArgumentException("Type is null");
        }
        if (!type.isInterface()) {
            throw new IllegalArgumentException("Type must be an interface: " + type);
        }
        this.mType = type;
        this.mMinRetryDelayMillis = minRetryDelayMillis;
    }

    public synchronized T get(int timeoutMillis) throws E {
        if (this.mReal != null) {
            return this.mReal;
        }
        if (this.mBogus != null && this.mMinRetryDelayMillis < 0) {
            return this.mBogus;
        }
        if (this.mCreateThread == null) {
            this.mCreateThread = new CreateThread();
            cThreadPool.submit(this.mCreateThread);
        }
        if (timeoutMillis != 0) {
            long start;
            block13: {
                start = System.nanoTime();
                try {
                    if (timeoutMillis < 0) {
                        while (this.mReal == null && this.mCreateThread != null) {
                            if (timeoutMillis >= 0) continue;
                            this.wait();
                        }
                        break block13;
                    }
                    long remaining = timeoutMillis;
                    while (this.mReal == null && this.mCreateThread != null && !this.mFailed) {
                        this.wait(remaining);
                        long elapsed = (System.nanoTime() - start) / 1000000L;
                        if ((remaining -= elapsed) > 0L) continue;
                        break;
                    }
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
            if (this.mReal != null) {
                return this.mReal;
            }
            long elapsed = (System.nanoTime() - start) / 1000000L;
            if (elapsed >= (long)timeoutMillis) {
                this.timedOutNotification(elapsed);
            }
        }
        if (this.mFailedError != null) {
            Throwable error = this.mFailedError;
            this.mFailedError = null;
            StackTraceElement[] trace = error.getStackTrace();
            error.fillInStackTrace();
            StackTraceElement[] localTrace = error.getStackTrace();
            StackTraceElement[] completeTrace = new StackTraceElement[trace.length + localTrace.length];
            System.arraycopy(trace, 0, completeTrace, 0, trace.length);
            System.arraycopy(localTrace, 0, completeTrace, trace.length, localTrace.length);
            error.setStackTrace(completeTrace);
            ThrowUnchecked.fire(error);
        }
        if (this.mBogus == null) {
            this.mRef = new AtomicReference<T>(this.createBogus());
            this.mBogus = AccessController.doPrivileged(new PrivilegedAction<T>(){

                @Override
                public T run() {
                    try {
                        return BelatedCreator.this.getWrapper().newInstance(BelatedCreator.this.mRef);
                    }
                    catch (Exception e) {
                        ThrowUnchecked.fire(e);
                        return null;
                    }
                }
            });
        }
        return this.mBogus;
    }

    protected abstract T createReal() throws E;

    protected abstract T createBogus();

    protected abstract void timedOutNotification(long var1);

    protected void createdNotification(T object) {
    }

    synchronized void created(T object) {
        this.mReal = object;
        if (this.mBogus != null) {
            this.mBogus = null;
            if (this.mRef != null) {
                this.mRef.set(object);
            }
        }
        this.mFailed = false;
        this.notifyAll();
        this.createdNotification(object);
    }

    synchronized void failed() {
        if (this.mReal == null) {
            this.mFailed = true;
        }
        this.notifyAll();
    }

    synchronized void handleThreadExit(Throwable error) {
        if (this.mReal == null) {
            this.mFailed = true;
            if (error != null) {
                this.mFailedError = error;
            }
        }
        this.mCreateThread = null;
        this.notifyAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Constructor<T> getWrapper() {
        Class<Object> clazz;
        Cache<Class<?>, Class<?>> cache = cWrapperCache;
        synchronized (cache) {
            clazz = cWrapperCache.get(this.mType);
            if (clazz == null) {
                clazz = this.createWrapper();
                cWrapperCache.put(this.mType, clazz);
            }
        }
        try {
            return clazz.getConstructor(AtomicReference.class);
        }
        catch (NoSuchMethodException e) {
            ThrowUnchecked.fire(e);
            return null;
        }
    }

    private Class<T> createWrapper() {
        RuntimeClassFile cf = new RuntimeClassFile(this.mType.getName());
        cf.addInterface(this.mType);
        cf.markSynthetic();
        cf.setSourceFile(BelatedCreator.class.getName());
        cf.setTarget("1.5");
        TypeDesc atomicRefType = TypeDesc.forClass(AtomicReference.class);
        cf.addField(Modifiers.PRIVATE.toFinal(true), REF_FIELD_NAME, atomicRefType);
        CodeBuilder b = new CodeBuilder(cf.addConstructor(Modifiers.PUBLIC, new TypeDesc[]{atomicRefType}));
        b.loadThis();
        b.invokeSuperConstructor(null);
        b.loadThis();
        b.loadLocal(b.getParameter(0));
        b.storeField(REF_FIELD_NAME, atomicRefType);
        b.returnVoid();
        for (Method m : this.mType.getMethods()) {
            try {
                Object.class.getMethod(m.getName(), m.getParameterTypes());
            }
            catch (NoSuchMethodException e) {
                this.addWrappedCall(cf, new CodeBuilder(cf.addMethod(m)), m);
            }
        }
        for (Method m : Object.class.getMethods()) {
            int modifiers = m.getModifiers();
            if (Modifier.isFinal(modifiers) || !Modifier.isPublic(modifiers)) continue;
            b = new CodeBuilder(cf.addMethod(Modifiers.PUBLIC, m.getName(), MethodDesc.forMethod(m)));
            this.addWrappedCall(cf, b, m);
        }
        Class clazz = cf.defineClass();
        return clazz;
    }

    private void addWrappedCall(ClassFile cf, CodeBuilder b, Method m) {
        boolean isEqualsMethod = false;
        if (m.getName().equals("equals") && m.getReturnType().equals(Boolean.TYPE)) {
            Class<?>[] paramTypes = m.getParameterTypes();
            boolean bl = isEqualsMethod = paramTypes.length == 1 && paramTypes[0].equals(Object.class);
        }
        if (isEqualsMethod) {
            b.loadThis();
            b.loadLocal(b.getParameter(0));
            Label notEqual = b.createLabel();
            b.ifEqualBranch(notEqual, false);
            b.loadConstant(true);
            b.returnValue(TypeDesc.BOOLEAN);
            notEqual.setLocation();
            b.loadLocal(b.getParameter(0));
            b.instanceOf(cf.getType());
            Label isInstance = b.createLabel();
            b.ifZeroComparisonBranch(isInstance, "!=");
            b.loadConstant(false);
            b.returnValue(TypeDesc.BOOLEAN);
            isInstance.setLocation();
        }
        TypeDesc atomicRefType = TypeDesc.forClass(AtomicReference.class);
        b.loadThis();
        b.loadField(REF_FIELD_NAME, atomicRefType);
        b.invokeVirtual(atomicRefType, "get", TypeDesc.OBJECT, null);
        b.checkCast(TypeDesc.forClass(this.mType));
        for (int i = 0; i < b.getParameterCount(); ++i) {
            b.loadLocal(b.getParameter(i));
        }
        if (isEqualsMethod) {
            b.checkCast(cf.getType());
            b.loadField(REF_FIELD_NAME, atomicRefType);
            b.invokeVirtual(atomicRefType, "get", TypeDesc.OBJECT, null);
            b.checkCast(TypeDesc.forClass(this.mType));
        }
        b.invoke(m);
        if (m.getReturnType() == Void.TYPE) {
            b.returnVoid();
        } else {
            b.returnValue(TypeDesc.forClass(m.getReturnType()));
        }
    }

    private static class TFactory
    implements ThreadFactory {
        private static int cCount;

        private TFactory() {
        }

        private static synchronized int nextID() {
            return ++cCount;
        }

        public Thread newThread(Runnable r) {
            Thread t = new Thread(r);
            t.setDaemon(true);
            t.setName("BelatedCreator-" + TFactory.nextID());
            return t;
        }
    }

    private class CreateThread
    implements Runnable {
        private CreateThread() {
        }

        public void run() {
            try {
                while (true) {
                    Object real;
                    if ((real = BelatedCreator.this.createReal()) != null) {
                        BelatedCreator.this.created(real);
                        break;
                    }
                    BelatedCreator.this.failed();
                    if (BelatedCreator.this.mMinRetryDelayMillis < 0) break;
                    try {
                        Thread.sleep(BelatedCreator.this.mMinRetryDelayMillis);
                    }
                    catch (InterruptedException e) {
                        break;
                    }
                }
                BelatedCreator.this.handleThreadExit(null);
            }
            catch (Throwable e) {
                BelatedCreator.this.handleThreadExit(e);
            }
        }
    }
}

