#include "string_map.hh"
#include "repl-t.hh"
#include "hash_repl-p.hh"
#include "map_repl.hh"
#include "map_repl_read.hh"

namespace afilter {

  typedef const string &   Name;
  typedef FilterItrPart    Filter;
  typedef ConfigData &      Opts;

  static Filter * get_simple();
  static Filter * get_direct(Name in, Name out, Opts);
  static Filter * get_direct_map_ri(Name in, Name out, Opts);
  static Filter * get_dual_repl(Name in, Name out, Opts);

  FilterItrPart * get_repl_itr(Name in, Name out, Opts opts) {
    if (in == out) return get_simple();

    FilterItrPart * i;
  
    // check if there is a direct filter from in to out
    i = get_direct(in, out, opts);
    if (i) return i;

    // check if it is possible to make a direct map
    i = get_direct_map_ri(in, out, opts);
    if (i) return i;

    // finally resort to combining two using the dual_repl
    i = get_dual_repl(in,out,opts);
    if (i) return i;

    // if that is not possable return 0;
    return 0;
  }

  static Filter * get_simple() {
    return new ReplItr<straight_through<char2char>,1,1>();
  }

  struct DirectItem {
    string from;
    string to;
    FilterItrPart * (*func) ();
  };


  static Filter * get_direct(Name in, Name out, Opts opts) {
    return 0;
  }

  template <typename T> class SingleRepl;
  template <typename T> class SubstrRepl;

  static Filter * get_direct_map_ri(Name in, Name out, Opts opts) 
  {
    MapReplData from_data, to_data;
    if (!get_map(in ,opts,from_data)) return 0;
    if (!get_map(out,opts,to_data  )) return 0;
    FilterItrPart * i; 
#define get_ri(Type,Parms) \
    CharReplBase<char2char> * j = \
      get_repl<Type##Repl<char2char>, char2char>(&opts,Parms);\
    get_map(from_data, to_data, opts, \
            *dynamic_cast<MapReplBase<char,char> *>(j)); \
    i = get_filter<Type##Repl<char2char>, char2char>(*j); \
    delete j;

    if (from_data.stats.max_size == 1) {
      get_ri(Single,0);
    } else if (from_data.stats.first_same && from_data.stats.last_same) {
      HashReplOpts o(from_data.stats.first_char, from_data.stats.last_char);
      get_ri(Hash, &o);
    } else {
      get_ri(Substr,0);
    }
#undef get_ri

    return i;
  }

  typedef CharReplBase<char2uni>  ToUni;
  typedef CharReplBase<uni2char>  FromUni;
  typedef DualRepl<ToUni,FromUni> Dual;

  static ToUni   * get_to_uni   (Name, Opts);
  static FromUni * get_from_uni (Name, Opts);

  static Filter * get_dual_repl(Name in, Name out, Opts opts) {

    ToUni   * i = get_to_uni(in, opts);
    FromUni * j = get_from_uni(out, opts);

    if (i && j)
      return new ReplItr<Dual>(Dual(i,j,opts));
    else
      return 0;
  }

  typedef PairToUniRepl<PairReplVirtual<char2uni> > ToUniDual;
  static ToUni * get_to_uni_simple(Name, Opts);

  static ToUni * get_to_uni(Name name, Opts opts) {
    string::size_type pos = name.find('&');
    if (pos == string::npos) {

      return get_to_uni_simple(name, opts);

    } else {
    
      ToUni * i = get_to_uni_simple(name.substr(0,pos),opts);
      ToUni * j = get_to_uni_simple(name.substr(pos+1),opts);

      if (i && j)
	return new ToUniDual(i,j,opts);
      else
	return 0;
    }
  }

  typedef PairFromUniRepl<PairReplVirtual<uni2char> > FromUniDual;
  static FromUni * get_from_uni_simple(Name, Opts);

  static FromUni * get_from_uni(Name name, Opts opts) {
    string::size_type pos = name.find('&');
    if (pos == string::npos) {

      return get_from_uni_simple(name, opts);

    } else {
    
      FromUni * i = get_from_uni_simple(name.substr(0,pos),opts);
      FromUni * j = get_from_uni_simple(name.substr(pos+1),opts);

      if (i && j)
	return new FromUniDual(i,j,opts);
      else
	return 0;
    }
  }

  struct ToUniItem {
    string from;
    ToUni * (*func) ();
  };

  static ToUni * get_to_uni_simple(Name name, Opts opts) {
    MapReplData data;
    if (!get_map(name,opts,data)) return 0;

#define get_ri(Type,Parms) \
    ToUni * j = get_repl<Type##Repl<char2uni>, char2uni>(&opts,Parms); \
    get_map(data, opts, *dynamic_cast<MapReplBase<char,unichar> *>(j)); \
    return j

    if (data.stats.max_size == 1) {
      get_ri(Single,0);
    } else if (data.stats.first_same && data.stats.last_same) {
      HashReplOpts o(data.stats.first_char, data.stats.last_char);
      get_ri(Hash, &o);
    } else {
      get_ri(Substr,0);
    }
#undef get_ri

    return 0;
  }

  struct FromUniItem {
    string to;
    FromUni * (*func) ();
  };

  static FromUni * get_from_uni_simple(Name name, Opts opts) {
    MapReplData data;
    if (!get_map(name,opts,data)) return 0;
    FromUni * j = get_repl<SingleRepl<uni2char>, uni2char>(&opts, 0);
    get_map(data, opts, *dynamic_cast<MapReplBase<unichar,char> *>(j));
    return j;
  }
}


  
