
#ifndef as_check_t__
#define as_check_t__

#include "urlskip.hh"

namespace afilter {

  template <typename T>
  void UrlSkip<T>::scan(char c, Itr * cur, bool & blank_out)
  {
    enum {slash, who_cares} prev_char = who_cares;
    enum {wbegin, wmiddle, wend} word_pos = wbegin;
    blank_out = false;
    int point_chars = 0;
    Itr * next = cur->clone();
    char next_char;
    if (c == 0) return;
    for (;;) {
      if (word_pos == wend) break;
      next->assign(cur); 
      next_char = next->next();
      if (next_char == 0 || next_char == ' ' || 
	  next_char == '\n' || next_char == '\t')
	word_pos = wend;
      if (word_pos == wmiddle) {
	switch (c) {
	case '@':
	  blank_out = true;
	  prev_char = who_cares;
	  break;
	case '.':
	  ++point_chars;
	  prev_char = who_cares;
	  break;
	case '/':
	  if (prev_char == slash) blank_out = true;
	  prev_char = slash;
	  break;
	default:
	  prev_char = who_cares;
	}
      }
      c = cur->next();
      if (word_pos == wbegin) word_pos = wmiddle;
    }
    if (point_chars > 1) blank_out = true;
    delete next;
  }
}

#endif
