// Copyright (c) 2000
// Kevin Atkinson
//
// Permission to use, copy, modify, distribute and sell this software
// and its documentation for any purpose is hereby granted without
// fee, provided that the above copyright notice appear in all copies
// and that both that copyright notice and this permission notice
// appear in supporting documentation. Kevin Atkinson makes no
// representations about the suitability of this software for any
// purpose.  It is provided "as is" without express or implied
// warranty.

// hash_string

#ifndef __autil_hash_string_hh__
#define __autil_hash_string_hh__

namespace autil {

  template<class String>
  struct HashString {
    typedef size_t         result_type;
    typedef const String & argument_type;
    
    inline size_t operator() (const String &str) const {
      size_t h = 0;
      for (typename String::const_iterator s = str.begin(); 
	   s != str.end(); 
	   ++s)
	h=5*h + *s;
      return h;
    }
  };
  
  template<>
  struct HashString<const char *> {
    typedef size_t       result_type;
    typedef const char * argument_type;
    
    inline size_t operator() (const char * s) const {
      size_t h = 0;
      for (; *s; ++s)
	h=5*h + *s;
      return h;
    }
  };

}

#endif
