#ifndef	ENVIRONMENT_DEFINE
#define	ENVIRONMENT_DEFINE

/*
 * atanks - obliterate each other with oversize weapons
 * Copyright (C) 2003  Thomas Hudson
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License 
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * */


#include "main.h"

enum landscapeTypes {
	LANDTYPE_RANDOM,
	LANDTYPE_CANYONS,
	LANDTYPE_MOUNTAINS,
	LANDTYPE_VALLEYS,
	LANDTYPE_HILLS,
	LANDTYPE_FOOTHILLS,
	LANDTYPE_PLAIN,
        LANDTYPE_NONE
};

enum landSlideTypes {
	LANDSLIDE_NONE,       // gravity does not exist
        LANDSLIDE_TANK_ONLY,  // dirt falls, tank does not
	LANDSLIDE_INSTANT,    // dirt falls without you seeing it
	LANDSLIDE_GRAVITY,    // normal
        LANDSLIDE_CARTOON     // gravity is delayed
};

#ifndef MAX_GRAVITY_DELAY
#define GRAVITY_DELAY 200
#define MAX_GRAVITY_DELAY 3
#endif

enum wallTypes {
        WALL_RUBBER,
	WALL_STEEL,
	WALL_SPRING,
        WALL_WRAP,
        WALL_RANDOM
};


// stages
#define STAGE_AIM 0
#define STAGE_ENDGAME 3


#define SPRING_CHANGE 1.25

// size of satellite laser
#define LASER_NONE 0.0
#define LASER_WEAK 1.0
#define LASER_STRONG 2.0
#define LASER_SUPER 3.0


class TANK;
class MISSILE;
class FLOATTEXT;
class GLOBALDATA;
class VIRTUAL_OBJECT;
class ENVIRONMENT {
	protected:
	GLOBALDATA	*_global;

	public:
	TANK	*order[MAXPLAYERS * 3];
	VIRTUAL_OBJECT	*objects[MAX_OBJECTS];
	int	availableItems[THINGS];
	int	numAvailable;
	int	realm, am;
	double	wind, lastwind;
	double	windstrength, windvariation;
	double	viscosity;
	double	gravity;
	double	weapontechLevel, itemtechLevel;
	double	meteors;
	double	lightning;
        double  falling_dirt_balls;
	double	fog;
	int	oldFogX, oldFogY;
	double	landType;
	double	landSlideType;
        double  landSlideDelay;
	char	*done;
	int	*fp;
	int	*h;
	int	*surface;
	int	*dropTo;
	double	*velocity;
	double	*dropIncr;
	double	*height;
	BITMAP	*db, *terrain, *sky;
	int	pclock, mouseclock;
	int	stage;
	int	combineUpdates;
        double  wallType;
        int     current_wallType, wallColour;
        int     time_to_fall;    // amount of time dirt will hover
        double  satellite;
        int     naturals_since_last_shot;

	ENVIRONMENT () {};
	ENVIRONMENT (GLOBALDATA *global);
	void initialise ();
	void setGlobaldata (GLOBALDATA *global) {_global = global;};
	void generateAvailableItemsList ();
	int isItemAvailable (int itemNum);
	int addObject (VIRTUAL_OBJECT *object);
	int removeObject (VIRTUAL_OBJECT *object);
	VIRTUAL_OBJECT *getNextOfClass (int classNum, int *index);
	void newRound ();
	int ingamemenu ();
	void do_updates ();
	void replaceCanvas ();
	void make_update (int x, int y, int w, int h);
	void make_bgupdate (int x, int y, int w, int h);

        int saveToFile_Text (FILE *file);
        int loadFromFile_Text (FILE *file);
};

#endif

