void ATL_USERMM
   (const int M, const int N, const int K, const double alpha, const double *A, const int lda, const double *B, const int ldb, const double beta, double *C, const int ldc)
{
   register double b0, b1, c0;
   const double *pA, *pC=C;
   register int i, j, k;

   for (j=0; j != NB; j++)
   {
      pC = C;
      pA = A;
      for (k=0; k != KB; k += 2)
      {
         b0 = B[k];
         b1 = B[k+1];
         for (i=0; i != M; i++) pC[i] += pA[i*lda] * b0 + pA[i*lda+1] * b1;
         pC += ldc;
         pA += 2;
      }
      B += ldb;
   }
}
