CMAKE_MINIMUM_REQUIRED(VERSION 3.7.1)

FUNCTION(READ_REVISION _var _regex _files)
	FOREACH(file ${_files})
		IF(EXISTS "${file}")
			FILE(READ "${file}" content)
			STRING(REGEX MATCH "${_regex}" _unused "${content}")
			SET(${_var} ${CMAKE_MATCH_1} PARENT_SCOPE)
			RETURN()
		ENDIF()
	ENDFOREACH()
ENDFUNCTION()

IF(NOT CMAKE_ANDROID_NDK)
	SET(_ndk_dest $ENV{ANDROID_NDK_ROOT} $ENV{ANDROID_NDK_HOME} $ENV{ANDROID_NDK})
	FOREACH(_ndk ${_ndk_dest})
		IF(EXISTS "${_ndk}")
			SET(CMAKE_ANDROID_NDK ${_ndk})
		ENDIF()
	ENDFOREACH()

	IF(NOT CMAKE_ANDROID_NDK)
		MESSAGE(FATAL_ERROR "Cannot find ANDROID_NDK_ROOT")
	ENDIF()
ENDIF()

SET(ANDROID_SDK $ENV{ANDROID_SDK_ROOT})
SET(ANDROID_BUILD_TOOLS_REVISION $ENV{ANDROID_BUILD_TOOLS_REVISION})

IF(NOT EXISTS "${ANDROID_SDK}")
	MESSAGE(FATAL_ERROR "Environment variable ANDROID_SDK_ROOT is undefined")
ENDIF()

IF(NOT ANDROID_BUILD_TOOLS_REVISION)
	SET(_android_build_tools_dir "${ANDROID_SDK}/build-tools")

	FILE(GLOB build_tools_list ${_android_build_tools_dir}/*)
	LIST(LENGTH build_tools_list build_tools_len)
	IF(build_tools_len GREATER 0)
		LIST(SORT build_tools_list)
		LIST(GET build_tools_list -1 build_tools)
	ENDIF()

	IF(NOT build_tools)
		MESSAGE(FATAL_ERROR "Cannot determine ANDROID_BUILD_TOOLS_REVISION: ${_android_build_tools_dir}")
	ENDIF()

	GET_FILENAME_COMPONENT(ANDROID_BUILD_TOOLS_REVISION "${build_tools}" NAME)
ENDIF()

READ_REVISION(ANDROID_NDK_REVISION ".*Revision = ([0-9|\\.]+)" "${CMAKE_ANDROID_NDK}/source.properties")
READ_REVISION(ANDROID_SDK_REVISION ".*Revision=([0-9|\\.]+)" "${ANDROID_SDK}/tools/source.properties;${ANDROID_SDK}/cmdline-tools/latest/source.properties")

IF(NOT CMAKE_ANDROID_NDK_TOOLCHAIN_VERSION AND (ANDROID_NDK_REVISION VERSION_GREATER_EQUAL "11" OR NOT ANDROID_NDK_REVISION))
	SET(CMAKE_ANDROID_NDK_TOOLCHAIN_VERSION clang)
ENDIF()

IF(ANDROID_NDK_REVISION VERSION_GREATER_EQUAL "19")
	CMAKE_MINIMUM_REQUIRED(VERSION 3.16.0)
	IF(CMAKE_VERSION VERSION_LESS "3.16.4")
		MESSAGE(WARNING "Check your cmake: https://gitlab.kitware.com/cmake/cmake/commit/e3d3b7ddeb5922a4d17b962984e698e6387f7544")
	ENDIF()

	SET(ANDROID_USE_LLVM true)
ELSE()
	SET(ANDROID_USE_LLVM false)
ENDIF()

SET(ANDROID_NDK_TOOLCHAIN_VERSION 4.9)

SET(CMAKE_SYSTEM_NAME Android)
SET(CMAKE_SYSTEM_VERSION 21)

IF(CMAKE_ANDROID_NDK_TOOLCHAIN_VERSION MATCHES "clang")
	SET(CMAKE_ANDROID_STL_TYPE c++_shared)
ELSE()
	SET(CMAKE_ANDROID_STL_TYPE gnustl_shared)
ENDIF()

IF(NOT CMAKE_ANDROID_ARCH_ABI)
	SET(CMAKE_ANDROID_ARCH_ABI armeabi-v7a)
ENDIF()


SET(CMAKE_FIND_ROOT_PATH ${CMAKE_PREFIX_PATH} CACHE STRING "android find search path root")
SET(CMAKE_FIND_ROOT_PATH_MODE_LIBRARY ONLY)
SET(CMAKE_FIND_ROOT_PATH_MODE_INCLUDE ONLY)
SET(CMAKE_FIND_ROOT_PATH_MODE_PACKAGE ONLY)
