/* dock-manager-api.c generated by valac, the Vala compiler
 * generated from dock-manager-api.vala, do not modify */

/*
 * Copyright (C) 2010 Michal Hruby <michal.mhr@gmail.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301  USA.
 *
 * Authored by Michal Hruby <michal.mhr@gmail.com>
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <dbus/dbus-glib-lowlevel.h>
#include <dbus/dbus-glib.h>
#include <task-manager.h>
#include <task-icon.h>
#include <task-window.h>
#include <task-launcher.h>
#include <gtk/gtk.h>
#include <task-item.h>
#include <dbus/dbus.h>


#define TYPE_DOCK_MANAGER_DBUS_INTERFACE (dock_manager_dbus_interface_get_type ())
#define DOCK_MANAGER_DBUS_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCK_MANAGER_DBUS_INTERFACE, DockManagerDBusInterface))
#define IS_DOCK_MANAGER_DBUS_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCK_MANAGER_DBUS_INTERFACE))
#define DOCK_MANAGER_DBUS_INTERFACE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_DOCK_MANAGER_DBUS_INTERFACE, DockManagerDBusInterfaceIface))

typedef struct _DockManagerDBusInterface DockManagerDBusInterface;
typedef struct _DockManagerDBusInterfaceIface DockManagerDBusInterfaceIface;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _DockManagerDBusInterfaceDBusProxy DockManagerDBusInterfaceDBusProxy;
typedef DBusGProxyClass DockManagerDBusInterfaceDBusProxyClass;

#define TYPE_DOCK_ITEM_DBUS_INTERFACE (dock_item_dbus_interface_get_type ())
#define DOCK_ITEM_DBUS_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCK_ITEM_DBUS_INTERFACE, DockItemDBusInterface))
#define IS_DOCK_ITEM_DBUS_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCK_ITEM_DBUS_INTERFACE))
#define DOCK_ITEM_DBUS_INTERFACE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_DOCK_ITEM_DBUS_INTERFACE, DockItemDBusInterfaceIface))

typedef struct _DockItemDBusInterface DockItemDBusInterface;
typedef struct _DockItemDBusInterfaceIface DockItemDBusInterfaceIface;
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
typedef struct _DockItemDBusInterfaceDBusProxy DockItemDBusInterfaceDBusProxy;
typedef DBusGProxyClass DockItemDBusInterfaceDBusProxyClass;

#define TYPE_TASK_MANAGER_DISPATCHER (task_manager_dispatcher_get_type ())
#define TASK_MANAGER_DISPATCHER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TASK_MANAGER_DISPATCHER, TaskManagerDispatcher))
#define TASK_MANAGER_DISPATCHER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TASK_MANAGER_DISPATCHER, TaskManagerDispatcherClass))
#define IS_TASK_MANAGER_DISPATCHER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TASK_MANAGER_DISPATCHER))
#define IS_TASK_MANAGER_DISPATCHER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TASK_MANAGER_DISPATCHER))
#define TASK_MANAGER_DISPATCHER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TASK_MANAGER_DISPATCHER, TaskManagerDispatcherClass))

typedef struct _TaskManagerDispatcher TaskManagerDispatcher;
typedef struct _TaskManagerDispatcherClass TaskManagerDispatcherClass;
typedef struct _TaskManagerDispatcherPrivate TaskManagerDispatcherPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _dbus_g_connection_unref0(var) ((var == NULL) ? NULL : (var = (dbus_g_connection_unref (var), NULL)))

#define TYPE_TASK_ICON_DISPATCHER (task_icon_dispatcher_get_type ())
#define TASK_ICON_DISPATCHER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TASK_ICON_DISPATCHER, TaskIconDispatcher))
#define TASK_ICON_DISPATCHER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TASK_ICON_DISPATCHER, TaskIconDispatcherClass))
#define IS_TASK_ICON_DISPATCHER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TASK_ICON_DISPATCHER))
#define IS_TASK_ICON_DISPATCHER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TASK_ICON_DISPATCHER))
#define TASK_ICON_DISPATCHER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TASK_ICON_DISPATCHER, TaskIconDispatcherClass))

typedef struct _TaskIconDispatcher TaskIconDispatcher;
typedef struct _TaskIconDispatcherClass TaskIconDispatcherClass;
#define _g_slist_free0(var) ((var == NULL) ? NULL : (var = (g_slist_free (var), NULL)))
typedef struct _TaskIconDispatcherPrivate TaskIconDispatcherPrivate;
typedef struct _Block1Data Block1Data;
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _DBusObjectVTable _DBusObjectVTable;

struct _DockManagerDBusInterfaceIface {
	GTypeInterface parent_iface;
	char** (*get_capabilities) (DockManagerDBusInterface* self, int* result_length1, GError** error);
	char** (*get_items) (DockManagerDBusInterface* self, int* result_length1, GError** error);
	char** (*get_items_by_name) (DockManagerDBusInterface* self, const char* name, int* result_length1, GError** error);
	char** (*get_items_by_desktop_file) (DockManagerDBusInterface* self, const char* desktop_file, int* result_length1, GError** error);
	char** (*get_items_by_pid) (DockManagerDBusInterface* self, gint pid, int* result_length1, GError** error);
	char* (*get_item_by_xid) (DockManagerDBusInterface* self, gint64 xid, GError** error);
	void (*awn_set_visibility) (DockManagerDBusInterface* self, const char* win_name, gboolean visible, GError** error);
	char* (*awn_register_proxy_item) (DockManagerDBusInterface* self, const char* desktop_file, const char* uri, GError** error);
};

struct _DockManagerDBusInterfaceDBusProxy {
	DBusGProxy parent_instance;
	gboolean disposed;
};

struct _DockItemDBusInterfaceIface {
	GTypeInterface parent_iface;
	gint (*add_menu_item) (DockItemDBusInterface* self, GHashTable* menu_hints, GError** error);
	void (*remove_menu_item) (DockItemDBusInterface* self, gint id, GError** error);
	void (*update_dock_item) (DockItemDBusInterface* self, GHashTable* hints, GError** error);
	char* (*get_desktop_file) (DockItemDBusInterface* self);
	char* (*get_uri) (DockItemDBusInterface* self);
};

struct _DockItemDBusInterfaceDBusProxy {
	DBusGProxy parent_instance;
	gboolean disposed;
};

struct _TaskManagerDispatcher {
	GObject parent_instance;
	TaskManagerDispatcherPrivate * priv;
};

struct _TaskManagerDispatcherClass {
	GObjectClass parent_class;
};

struct _TaskManagerDispatcherPrivate {
	TaskManager* _manager;
};

struct _TaskIconDispatcher {
	GObject parent_instance;
	TaskIconDispatcherPrivate * priv;
};

struct _TaskIconDispatcherClass {
	GObjectClass parent_class;
};

struct _TaskIconDispatcherPrivate {
	TaskIcon* icon;
	char* _object_path;
};

struct _Block1Data {
	int _ref_count_;
	TaskIconDispatcher * self;
	gint id;
};

struct _DBusObjectVTable {
	void (*register_object) (DBusConnection*, const char*, void*);
};


static gpointer task_manager_dispatcher_parent_class = NULL;
static DockManagerDBusInterfaceIface* task_manager_dispatcher_dock_manager_dbus_interface_parent_iface = NULL;
static gint task_icon_dispatcher_counter;
static gint task_icon_dispatcher_counter = 1;
static gpointer task_icon_dispatcher_parent_class = NULL;
static DockItemDBusInterfaceIface* task_icon_dispatcher_dock_item_dbus_interface_parent_iface = NULL;

GType dock_manager_dbus_interface_get_type (void);
char** dock_manager_dbus_interface_get_capabilities (DockManagerDBusInterface* self, int* result_length1, GError** error);
char** dock_manager_dbus_interface_get_items (DockManagerDBusInterface* self, int* result_length1, GError** error);
char** dock_manager_dbus_interface_get_items_by_name (DockManagerDBusInterface* self, const char* name, int* result_length1, GError** error);
char** dock_manager_dbus_interface_get_items_by_desktop_file (DockManagerDBusInterface* self, const char* desktop_file, int* result_length1, GError** error);
char** dock_manager_dbus_interface_get_items_by_pid (DockManagerDBusInterface* self, gint pid, int* result_length1, GError** error);
char* dock_manager_dbus_interface_get_item_by_xid (DockManagerDBusInterface* self, gint64 xid, GError** error);
void dock_manager_dbus_interface_awn_set_visibility (DockManagerDBusInterface* self, const char* win_name, gboolean visible, GError** error);
char* dock_manager_dbus_interface_awn_register_proxy_item (DockManagerDBusInterface* self, const char* desktop_file, const char* uri, GError** error);
void dock_manager_dbus_interface_dbus_register_object (DBusConnection* connection, const char* path, void* object);
void _dock_manager_dbus_interface_dbus_unregister (DBusConnection* connection, void* _user_data_);
DBusHandlerResult dock_manager_dbus_interface_dbus_message (DBusConnection* connection, DBusMessage* message, void* object);
static DBusHandlerResult _dbus_dock_manager_dbus_interface_introspect (DockManagerDBusInterface* self, DBusConnection* connection, DBusMessage* message);
static DBusHandlerResult _dbus_dock_manager_dbus_interface_property_get_all (DockManagerDBusInterface* self, DBusConnection* connection, DBusMessage* message);
static DBusHandlerResult _dbus_dock_manager_dbus_interface_get_capabilities (DockManagerDBusInterface* self, DBusConnection* connection, DBusMessage* message);
static DBusHandlerResult _dbus_dock_manager_dbus_interface_get_items (DockManagerDBusInterface* self, DBusConnection* connection, DBusMessage* message);
static DBusHandlerResult _dbus_dock_manager_dbus_interface_get_items_by_name (DockManagerDBusInterface* self, DBusConnection* connection, DBusMessage* message);
static DBusHandlerResult _dbus_dock_manager_dbus_interface_get_items_by_desktop_file (DockManagerDBusInterface* self, DBusConnection* connection, DBusMessage* message);
static DBusHandlerResult _dbus_dock_manager_dbus_interface_get_items_by_pid (DockManagerDBusInterface* self, DBusConnection* connection, DBusMessage* message);
static DBusHandlerResult _dbus_dock_manager_dbus_interface_get_item_by_xid (DockManagerDBusInterface* self, DBusConnection* connection, DBusMessage* message);
static DBusHandlerResult _dbus_dock_manager_dbus_interface_awn_set_visibility (DockManagerDBusInterface* self, DBusConnection* connection, DBusMessage* message);
static DBusHandlerResult _dbus_dock_manager_dbus_interface_awn_register_proxy_item (DockManagerDBusInterface* self, DBusConnection* connection, DBusMessage* message);
static void _dbus_dock_manager_dbus_interface_item_added (GObject* _sender, const char* path, DBusConnection* _connection);
static void _dbus_dock_manager_dbus_interface_item_removed (GObject* _sender, const char* path, DBusConnection* _connection);
GType dock_manager_dbus_interface_dbus_proxy_get_type (void);
DockManagerDBusInterface* dock_manager_dbus_interface_dbus_proxy_new (DBusGConnection* connection, const char* name, const char* path);
static void _dbus_handle_dock_manager_dbus_interface_item_added (DockManagerDBusInterface* self, DBusConnection* connection, DBusMessage* message);
static void _dbus_handle_dock_manager_dbus_interface_item_removed (DockManagerDBusInterface* self, DBusConnection* connection, DBusMessage* message);
DBusHandlerResult dock_manager_dbus_interface_dbus_proxy_filter (DBusConnection* connection, DBusMessage* message, void* user_data);
enum  {
	DOCK_MANAGER_DBUS_INTERFACE_DBUS_PROXY_DUMMY_PROPERTY
};
static char** dock_manager_dbus_interface_dbus_proxy_get_capabilities (DockManagerDBusInterface* self, int* result_length1, GError** error);
static char** dock_manager_dbus_interface_dbus_proxy_get_items (DockManagerDBusInterface* self, int* result_length1, GError** error);
static char** dock_manager_dbus_interface_dbus_proxy_get_items_by_name (DockManagerDBusInterface* self, const char* name, int* result_length1, GError** error);
static char** dock_manager_dbus_interface_dbus_proxy_get_items_by_desktop_file (DockManagerDBusInterface* self, const char* desktop_file, int* result_length1, GError** error);
static char** dock_manager_dbus_interface_dbus_proxy_get_items_by_pid (DockManagerDBusInterface* self, gint pid, int* result_length1, GError** error);
static char* dock_manager_dbus_interface_dbus_proxy_get_item_by_xid (DockManagerDBusInterface* self, gint64 xid, GError** error);
static void dock_manager_dbus_interface_dbus_proxy_awn_set_visibility (DockManagerDBusInterface* self, const char* win_name, gboolean visible, GError** error);
static char* dock_manager_dbus_interface_dbus_proxy_awn_register_proxy_item (DockManagerDBusInterface* self, const char* desktop_file, const char* uri, GError** error);
static void dock_manager_dbus_interface_dbus_proxy_dock_manager_dbus_interface__interface_init (DockManagerDBusInterfaceIface* iface);
static void dock_manager_dbus_interface_dbus_proxy_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void dock_manager_dbus_interface_dbus_proxy_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
GType dock_item_dbus_interface_get_type (void);
gint dock_item_dbus_interface_add_menu_item (DockItemDBusInterface* self, GHashTable* menu_hints, GError** error);
void dock_item_dbus_interface_remove_menu_item (DockItemDBusInterface* self, gint id, GError** error);
void dock_item_dbus_interface_update_dock_item (DockItemDBusInterface* self, GHashTable* hints, GError** error);
char* dock_item_dbus_interface_get_desktop_file (DockItemDBusInterface* self);
char* dock_item_dbus_interface_get_uri (DockItemDBusInterface* self);
void dock_item_dbus_interface_dbus_register_object (DBusConnection* connection, const char* path, void* object);
void _dock_item_dbus_interface_dbus_unregister (DBusConnection* connection, void* _user_data_);
DBusHandlerResult dock_item_dbus_interface_dbus_message (DBusConnection* connection, DBusMessage* message, void* object);
static DBusHandlerResult _dbus_dock_item_dbus_interface_introspect (DockItemDBusInterface* self, DBusConnection* connection, DBusMessage* message);
static DBusHandlerResult _dbus_dock_item_dbus_interface_property_get (DockItemDBusInterface* self, DBusConnection* connection, DBusMessage* message);
static DBusHandlerResult _dbus_dock_item_dbus_interface_property_get_all (DockItemDBusInterface* self, DBusConnection* connection, DBusMessage* message);
static DBusHandlerResult _dbus_dock_item_dbus_interface_add_menu_item (DockItemDBusInterface* self, DBusConnection* connection, DBusMessage* message);
static DBusHandlerResult _dbus_dock_item_dbus_interface_remove_menu_item (DockItemDBusInterface* self, DBusConnection* connection, DBusMessage* message);
static DBusHandlerResult _dbus_dock_item_dbus_interface_update_dock_item (DockItemDBusInterface* self, DBusConnection* connection, DBusMessage* message);
static void _dbus_dock_item_dbus_interface_menu_item_activated (GObject* _sender, gint id, DBusConnection* _connection);
GType dock_item_dbus_interface_dbus_proxy_get_type (void);
DockItemDBusInterface* dock_item_dbus_interface_dbus_proxy_new (DBusGConnection* connection, const char* name, const char* path);
static void _dbus_handle_dock_item_dbus_interface_menu_item_activated (DockItemDBusInterface* self, DBusConnection* connection, DBusMessage* message);
DBusHandlerResult dock_item_dbus_interface_dbus_proxy_filter (DBusConnection* connection, DBusMessage* message, void* user_data);
enum  {
	DOCK_ITEM_DBUS_INTERFACE_DBUS_PROXY_DUMMY_PROPERTY,
	DOCK_ITEM_DBUS_INTERFACE_DBUS_PROXY_DESKTOP_FILE,
	DOCK_ITEM_DBUS_INTERFACE_DBUS_PROXY_URI
};
static gint dock_item_dbus_interface_dbus_proxy_add_menu_item (DockItemDBusInterface* self, GHashTable* menu_hints, GError** error);
static void dock_item_dbus_interface_dbus_proxy_remove_menu_item (DockItemDBusInterface* self, gint id, GError** error);
static void dock_item_dbus_interface_dbus_proxy_update_dock_item (DockItemDBusInterface* self, GHashTable* hints, GError** error);
static char* dock_item_dbus_interface_dbus_proxy_get_desktop_file (DockItemDBusInterface* self);
static char* dock_item_dbus_interface_dbus_proxy_get_uri (DockItemDBusInterface* self);
static void dock_item_dbus_interface_dbus_proxy_dock_item_dbus_interface__interface_init (DockItemDBusInterfaceIface* iface);
static void dock_item_dbus_interface_dbus_proxy_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void dock_item_dbus_interface_dbus_proxy_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
GType task_manager_dispatcher_get_type (void);
#define TASK_MANAGER_DISPATCHER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_TASK_MANAGER_DISPATCHER, TaskManagerDispatcherPrivate))
enum  {
	TASK_MANAGER_DISPATCHER_DUMMY_PROPERTY,
	TASK_MANAGER_DISPATCHER_MANAGER
};
TaskManagerDispatcher* task_manager_dispatcher_new (TaskManager* manager);
TaskManagerDispatcher* task_manager_dispatcher_construct (GType object_type, TaskManager* manager);
GType task_icon_dispatcher_get_type (void);
const char* task_icon_dispatcher_get_object_path (TaskIconDispatcher* self);
static char** task_manager_dispatcher_list_to_object_path_array (GSList* list, int* result_length1);
static char** task_manager_dispatcher_real_get_capabilities (DockManagerDBusInterface* base, int* result_length1, GError** error);
TaskManager* task_manager_dispatcher_get_manager (TaskManagerDispatcher* self);
static char** task_manager_dispatcher_real_get_items (DockManagerDBusInterface* base, int* result_length1, GError** error);
static char** task_manager_dispatcher_real_get_items_by_name (DockManagerDBusInterface* base, const char* name, int* result_length1, GError** error);
static char** task_manager_dispatcher_real_get_items_by_desktop_file (DockManagerDBusInterface* base, const char* desktop_file, int* result_length1, GError** error);
static char** task_manager_dispatcher_real_get_items_by_pid (DockManagerDBusInterface* base, gint pid, int* result_length1, GError** error);
static char* task_manager_dispatcher_real_get_item_by_xid (DockManagerDBusInterface* base, gint64 xid, GError** error);
static void task_manager_dispatcher_real_awn_set_visibility (DockManagerDBusInterface* base, const char* win_name, gboolean visible, GError** error);
static char* task_manager_dispatcher_real_awn_register_proxy_item (DockManagerDBusInterface* base, const char* desktop_file, const char* uri, GError** error);
static void task_manager_dispatcher_set_manager (TaskManagerDispatcher* self, TaskManager* value);
void task_manager_dispatcher_dbus_register_object (DBusConnection* connection, const char* path, void* object);
void _task_manager_dispatcher_dbus_unregister (DBusConnection* connection, void* _user_data_);
DBusHandlerResult task_manager_dispatcher_dbus_message (DBusConnection* connection, DBusMessage* message, void* object);
static DBusHandlerResult _dbus_task_manager_dispatcher_introspect (TaskManagerDispatcher* self, DBusConnection* connection, DBusMessage* message);
static void task_manager_dispatcher_finalize (GObject* obj);
static void task_manager_dispatcher_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void task_manager_dispatcher_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
#define TASK_ICON_DISPATCHER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_TASK_ICON_DISPATCHER, TaskIconDispatcherPrivate))
enum  {
	TASK_ICON_DISPATCHER_DUMMY_PROPERTY,
	TASK_ICON_DISPATCHER_OBJECT_PATH,
	TASK_ICON_DISPATCHER_DESKTOP_FILE,
	TASK_ICON_DISPATCHER_URI
};
void task_icon_dispatcher_set_object_path (TaskIconDispatcher* self, const char* value);
static void task_icon_dispatcher_emit_item_added (TaskIconDispatcher* self);
TaskIconDispatcher* task_icon_dispatcher_new (TaskIcon* icon);
TaskIconDispatcher* task_icon_dispatcher_construct (GType object_type, TaskIcon* icon);
static TaskManagerDispatcher* task_icon_dispatcher_get_manager_proxy (TaskIconDispatcher* self);
static void _lambda0_ (GtkMenuItem* w, Block1Data* _data1_);
static void __lambda0__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (Block1Data* _data1_);
static gint task_icon_dispatcher_real_add_menu_item (DockItemDBusInterface* base, GHashTable* menu_hints, GError** error);
static void task_icon_dispatcher_real_remove_menu_item (DockItemDBusInterface* base, gint id, GError** error);
static void task_icon_dispatcher_real_update_dock_item (DockItemDBusInterface* base, GHashTable* hints, GError** error);
void task_icon_dispatcher_dbus_register_object (DBusConnection* connection, const char* path, void* object);
void _task_icon_dispatcher_dbus_unregister (DBusConnection* connection, void* _user_data_);
DBusHandlerResult task_icon_dispatcher_dbus_message (DBusConnection* connection, DBusMessage* message, void* object);
static DBusHandlerResult _dbus_task_icon_dispatcher_introspect (TaskIconDispatcher* self, DBusConnection* connection, DBusMessage* message);
static void task_icon_dispatcher_finalize (GObject* obj);
static void task_icon_dispatcher_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void task_icon_dispatcher_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static int _vala_strcmp0 (const char * str1, const char * str2);
static void _vala_dbus_register_object (DBusConnection* connection, const char* path, void* object);
static void _vala_dbus_unregister_object (gpointer connection, GObject* object);

static const DBusObjectPathVTable _dock_manager_dbus_interface_dbus_path_vtable = {_dock_manager_dbus_interface_dbus_unregister, dock_manager_dbus_interface_dbus_message};
static const _DBusObjectVTable _dock_manager_dbus_interface_dbus_vtable = {dock_manager_dbus_interface_dbus_register_object};
static const DBusObjectPathVTable _dock_item_dbus_interface_dbus_path_vtable = {_dock_item_dbus_interface_dbus_unregister, dock_item_dbus_interface_dbus_message};
static const _DBusObjectVTable _dock_item_dbus_interface_dbus_vtable = {dock_item_dbus_interface_dbus_register_object};
static const DBusObjectPathVTable _task_manager_dispatcher_dbus_path_vtable = {_task_manager_dispatcher_dbus_unregister, task_manager_dispatcher_dbus_message};
static const _DBusObjectVTable _task_manager_dispatcher_dbus_vtable = {task_manager_dispatcher_dbus_register_object};
static const DBusObjectPathVTable _task_icon_dispatcher_dbus_path_vtable = {_task_icon_dispatcher_dbus_unregister, task_icon_dispatcher_dbus_message};
static const _DBusObjectVTable _task_icon_dispatcher_dbus_vtable = {task_icon_dispatcher_dbus_register_object};

static void g_cclosure_user_marshal_VOID__BOXED (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);

char** dock_manager_dbus_interface_get_capabilities (DockManagerDBusInterface* self, int* result_length1, GError** error) {
	return DOCK_MANAGER_DBUS_INTERFACE_GET_INTERFACE (self)->get_capabilities (self, result_length1, error);
}


char** dock_manager_dbus_interface_get_items (DockManagerDBusInterface* self, int* result_length1, GError** error) {
	return DOCK_MANAGER_DBUS_INTERFACE_GET_INTERFACE (self)->get_items (self, result_length1, error);
}


char** dock_manager_dbus_interface_get_items_by_name (DockManagerDBusInterface* self, const char* name, int* result_length1, GError** error) {
	return DOCK_MANAGER_DBUS_INTERFACE_GET_INTERFACE (self)->get_items_by_name (self, name, result_length1, error);
}


char** dock_manager_dbus_interface_get_items_by_desktop_file (DockManagerDBusInterface* self, const char* desktop_file, int* result_length1, GError** error) {
	return DOCK_MANAGER_DBUS_INTERFACE_GET_INTERFACE (self)->get_items_by_desktop_file (self, desktop_file, result_length1, error);
}


char** dock_manager_dbus_interface_get_items_by_pid (DockManagerDBusInterface* self, gint pid, int* result_length1, GError** error) {
	return DOCK_MANAGER_DBUS_INTERFACE_GET_INTERFACE (self)->get_items_by_pid (self, pid, result_length1, error);
}


char* dock_manager_dbus_interface_get_item_by_xid (DockManagerDBusInterface* self, gint64 xid, GError** error) {
	return DOCK_MANAGER_DBUS_INTERFACE_GET_INTERFACE (self)->get_item_by_xid (self, xid, error);
}


void dock_manager_dbus_interface_awn_set_visibility (DockManagerDBusInterface* self, const char* win_name, gboolean visible, GError** error) {
	DOCK_MANAGER_DBUS_INTERFACE_GET_INTERFACE (self)->awn_set_visibility (self, win_name, visible, error);
}


char* dock_manager_dbus_interface_awn_register_proxy_item (DockManagerDBusInterface* self, const char* desktop_file, const char* uri, GError** error) {
	return DOCK_MANAGER_DBUS_INTERFACE_GET_INTERFACE (self)->awn_register_proxy_item (self, desktop_file, uri, error);
}


void _dock_manager_dbus_interface_dbus_unregister (DBusConnection* connection, void* _user_data_) {
}


static DBusHandlerResult _dbus_dock_manager_dbus_interface_introspect (DockManagerDBusInterface* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessage* reply;
	DBusMessageIter iter;
	GString* xml_data;
	char** children;
	int i;
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	xml_data = g_string_new ("<!DOCTYPE node PUBLIC \"-//freedesktop//DTD D-BUS Object Introspection 1.0//EN\" \"http://www.freedesktop.org/standards/dbus/1.0/introspect.dtd\">\n");
	g_string_append (xml_data, "<node>\n<interface name=\"org.freedesktop.DBus.Introspectable\">\n  <method name=\"Introspect\">\n    <arg name=\"data\" direction=\"out\" type=\"s\"/>\n  </method>\n</interface>\n<interface name=\"org.freedesktop.DBus.Properties\">\n  <method name=\"Get\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"propname\" direction=\"in\" type=\"s\"/>\n    <arg name=\"value\" direction=\"out\" type=\"v\"/>\n  </method>\n  <method name=\"Set\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"propname\" direction=\"in\" type=\"s\"/>\n    <arg name=\"value\" direction=\"in\" type=\"v\"/>\n  </method>\n  <method name=\"GetAll\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"props\" direction=\"out\" type=\"a{sv}\"/>\n  </method>\n</interface>\n<interface name=\"org.freedesktop.DockManager\">\n  <method name=\"GetCapabilities\">\n    <arg name=\"result\" type=\"as\" direction=\"out\"/>\n  </method>\n  <method name=\"GetItems\">\n    <arg name=\"result\" type=\"ao\" direction=\"out\"/>\n  </method>\n  <method name=\"GetItemsByName\">\n    <arg name=\"name\" type=\"s\" direction=\"in\"/>\n    <arg name=\"result\" type=\"ao\" direction=\"out\"/>\n  </method>\n  <method name=\"GetItemsByDesktopFile\">\n    <arg name=\"desktop_file\" type=\"s\" direction=\"in\"/>\n    <arg name=\"result\" type=\"ao\" direction=\"out\"/>\n  </method>\n  <method name=\"GetItemsByPid\">\n    <arg name=\"pid\" type=\"i\" direction=\"in\"/>\n    <arg name=\"result\" type=\"ao\" direction=\"out\"/>\n  </method>\n  <method name=\"GetItemByXid\">\n    <arg name=\"xid\" type=\"x\" direction=\"in\"/>\n    <arg name=\"result\" type=\"o\" direction=\"out\"/>\n  </method>\n  <method name=\"AwnSetVisibility\">\n    <arg name=\"win_name\" type=\"s\" direction=\"in\"/>\n    <arg name=\"visible\" type=\"b\" direction=\"in\"/>\n  </method>\n  <method name=\"AwnRegisterProxyItem\">\n    <arg name=\"desktop_file\" type=\"s\" direction=\"in\"/>\n    <arg name=\"uri\" type=\"s\" direction=\"in\"/>\n    <arg name=\"result\" type=\"o\" direction=\"out\"/>\n  </method>\n  <signal name=\"ItemAdded\">\n    <arg name=\"path\" type=\"o\"/>\n  </signal>\n  <signal name=\"ItemRemoved\">\n    <arg name=\"path\" type=\"o\"/>\n  </signal>\n</interface>\n");
	dbus_connection_list_registered (connection, g_object_get_data ((GObject *) self, "dbus_object_path"), &children);
	for (i = 0; children[i]; i++) {
		g_string_append_printf (xml_data, "<node name=\"%s\"/>\n", children[i]);
	}
	dbus_free_string_array (children);
	g_string_append (xml_data, "</node>\n");
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_STRING, &xml_data->str);
	g_string_free (xml_data, TRUE);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static DBusHandlerResult _dbus_dock_manager_dbus_interface_property_get_all (DockManagerDBusInterface* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessage* reply;
	DBusMessageIter iter, reply_iter, subiter;
	char* interface_name;
	const char* _tmp0_;
	if (strcmp (dbus_message_get_signature (message), "s")) {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
	dbus_message_iter_init (message, &iter);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &reply_iter);
	dbus_message_iter_get_basic (&iter, &_tmp0_);
	dbus_message_iter_next (&iter);
	interface_name = g_strdup (_tmp0_);
	if (strcmp (interface_name, "org.freedesktop.DockManager") == 0) {
		dbus_message_iter_open_container (&reply_iter, DBUS_TYPE_ARRAY, "{sv}", &subiter);
		dbus_message_iter_close_container (&reply_iter, &subiter);
	} else {
		dbus_message_unref (reply);
		reply = NULL;
	}
	g_free (interface_name);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static DBusHandlerResult _dbus_dock_manager_dbus_interface_get_capabilities (DockManagerDBusInterface* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	char** result;
	int result_length1;
	DBusMessage* reply;
	char** _tmp1_;
	DBusMessageIter _tmp2_;
	int _tmp3_;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "")) {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
	dbus_message_iter_init (message, &iter);
	result_length1 = 0;
	result = dock_manager_dbus_interface_get_capabilities (self, &result_length1, &error);
	if (error) {
		if (error->domain == DBUS_GERROR) {
			switch (error->code) {
				case DBUS_GERROR_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Failed", error->message);
				break;
				case DBUS_GERROR_NO_MEMORY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoMemory", error->message);
				break;
				case DBUS_GERROR_SERVICE_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.ServiceUnknown", error->message);
				break;
				case DBUS_GERROR_NAME_HAS_NO_OWNER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NameHasNoOwner", error->message);
				break;
				case DBUS_GERROR_NO_REPLY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoReply", error->message);
				break;
				case DBUS_GERROR_IO_ERROR:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.IOError", error->message);
				break;
				case DBUS_GERROR_BAD_ADDRESS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.BadAddress", error->message);
				break;
				case DBUS_GERROR_NOT_SUPPORTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NotSupported", error->message);
				break;
				case DBUS_GERROR_LIMITS_EXCEEDED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.LimitsExceeded", error->message);
				break;
				case DBUS_GERROR_ACCESS_DENIED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AccessDenied", error->message);
				break;
				case DBUS_GERROR_AUTH_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AuthFailed", error->message);
				break;
				case DBUS_GERROR_NO_SERVER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoServer", error->message);
				break;
				case DBUS_GERROR_TIMEOUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Timeout", error->message);
				break;
				case DBUS_GERROR_NO_NETWORK:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoNetwork", error->message);
				break;
				case DBUS_GERROR_ADDRESS_IN_USE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AddressInUse", error->message);
				break;
				case DBUS_GERROR_DISCONNECTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Disconnected", error->message);
				break;
				case DBUS_GERROR_INVALID_ARGS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidArgs", error->message);
				break;
				case DBUS_GERROR_FILE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileNotFound", error->message);
				break;
				case DBUS_GERROR_FILE_EXISTS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileExists", error->message);
				break;
				case DBUS_GERROR_UNKNOWN_METHOD:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnknownMethod", error->message);
				break;
				case DBUS_GERROR_TIMED_OUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.TimedOut", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleNotFound", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_INVALID:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleInvalid", error->message);
				break;
				case DBUS_GERROR_SPAWN_EXEC_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ExecFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_FORK_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ForkFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_EXITED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildExited", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_SIGNALED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildSignaled", error->message);
				break;
				case DBUS_GERROR_SPAWN_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.Failed", error->message);
				break;
				case DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnixProcessIdUnknown", error->message);
				break;
				case DBUS_GERROR_INVALID_SIGNATURE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidSignature", error->message);
				break;
				case DBUS_GERROR_INVALID_FILE_CONTENT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidFileContent", error->message);
				break;
				case DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.SELinuxSecurityContextUnknown", error->message);
				break;
				case DBUS_GERROR_REMOTE_EXCEPTION:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.RemoteException", error->message);
				break;
			}
		}
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	}
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	_tmp1_ = result;
	dbus_message_iter_open_container (&iter, DBUS_TYPE_ARRAY, "s", &_tmp2_);
	for (_tmp3_ = 0; _tmp3_ < result_length1; _tmp3_++) {
		const char* _tmp4_;
		_tmp4_ = *_tmp1_;
		dbus_message_iter_append_basic (&_tmp2_, DBUS_TYPE_STRING, &_tmp4_);
		_tmp1_++;
	}
	dbus_message_iter_close_container (&iter, &_tmp2_);
	result = (_vala_array_free (result,  result_length1, (GDestroyNotify) g_free), NULL);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static DBusHandlerResult _dbus_dock_manager_dbus_interface_get_items (DockManagerDBusInterface* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	char** result;
	int result_length1;
	DBusMessage* reply;
	char** _tmp5_;
	DBusMessageIter _tmp6_;
	int _tmp7_;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "")) {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
	dbus_message_iter_init (message, &iter);
	result_length1 = 0;
	result = dock_manager_dbus_interface_get_items (self, &result_length1, &error);
	if (error) {
		if (error->domain == DBUS_GERROR) {
			switch (error->code) {
				case DBUS_GERROR_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Failed", error->message);
				break;
				case DBUS_GERROR_NO_MEMORY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoMemory", error->message);
				break;
				case DBUS_GERROR_SERVICE_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.ServiceUnknown", error->message);
				break;
				case DBUS_GERROR_NAME_HAS_NO_OWNER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NameHasNoOwner", error->message);
				break;
				case DBUS_GERROR_NO_REPLY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoReply", error->message);
				break;
				case DBUS_GERROR_IO_ERROR:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.IOError", error->message);
				break;
				case DBUS_GERROR_BAD_ADDRESS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.BadAddress", error->message);
				break;
				case DBUS_GERROR_NOT_SUPPORTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NotSupported", error->message);
				break;
				case DBUS_GERROR_LIMITS_EXCEEDED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.LimitsExceeded", error->message);
				break;
				case DBUS_GERROR_ACCESS_DENIED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AccessDenied", error->message);
				break;
				case DBUS_GERROR_AUTH_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AuthFailed", error->message);
				break;
				case DBUS_GERROR_NO_SERVER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoServer", error->message);
				break;
				case DBUS_GERROR_TIMEOUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Timeout", error->message);
				break;
				case DBUS_GERROR_NO_NETWORK:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoNetwork", error->message);
				break;
				case DBUS_GERROR_ADDRESS_IN_USE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AddressInUse", error->message);
				break;
				case DBUS_GERROR_DISCONNECTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Disconnected", error->message);
				break;
				case DBUS_GERROR_INVALID_ARGS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidArgs", error->message);
				break;
				case DBUS_GERROR_FILE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileNotFound", error->message);
				break;
				case DBUS_GERROR_FILE_EXISTS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileExists", error->message);
				break;
				case DBUS_GERROR_UNKNOWN_METHOD:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnknownMethod", error->message);
				break;
				case DBUS_GERROR_TIMED_OUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.TimedOut", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleNotFound", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_INVALID:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleInvalid", error->message);
				break;
				case DBUS_GERROR_SPAWN_EXEC_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ExecFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_FORK_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ForkFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_EXITED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildExited", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_SIGNALED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildSignaled", error->message);
				break;
				case DBUS_GERROR_SPAWN_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.Failed", error->message);
				break;
				case DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnixProcessIdUnknown", error->message);
				break;
				case DBUS_GERROR_INVALID_SIGNATURE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidSignature", error->message);
				break;
				case DBUS_GERROR_INVALID_FILE_CONTENT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidFileContent", error->message);
				break;
				case DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.SELinuxSecurityContextUnknown", error->message);
				break;
				case DBUS_GERROR_REMOTE_EXCEPTION:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.RemoteException", error->message);
				break;
			}
		}
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	}
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	_tmp5_ = result;
	dbus_message_iter_open_container (&iter, DBUS_TYPE_ARRAY, "o", &_tmp6_);
	for (_tmp7_ = 0; _tmp7_ < result_length1; _tmp7_++) {
		const char* _tmp8_;
		_tmp8_ = *_tmp5_;
		dbus_message_iter_append_basic (&_tmp6_, DBUS_TYPE_OBJECT_PATH, &_tmp8_);
		_tmp5_++;
	}
	dbus_message_iter_close_container (&iter, &_tmp6_);
	result = (_vala_array_free (result,  result_length1, (GDestroyNotify) g_free), NULL);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static DBusHandlerResult _dbus_dock_manager_dbus_interface_get_items_by_name (DockManagerDBusInterface* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	char* name = NULL;
	const char* _tmp9_;
	char** result;
	int result_length1;
	DBusMessage* reply;
	char** _tmp10_;
	DBusMessageIter _tmp11_;
	int _tmp12_;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "s")) {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
	dbus_message_iter_init (message, &iter);
	dbus_message_iter_get_basic (&iter, &_tmp9_);
	dbus_message_iter_next (&iter);
	name = g_strdup (_tmp9_);
	result_length1 = 0;
	result = dock_manager_dbus_interface_get_items_by_name (self, name, &result_length1, &error);
	if (error) {
		if (error->domain == DBUS_GERROR) {
			switch (error->code) {
				case DBUS_GERROR_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Failed", error->message);
				break;
				case DBUS_GERROR_NO_MEMORY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoMemory", error->message);
				break;
				case DBUS_GERROR_SERVICE_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.ServiceUnknown", error->message);
				break;
				case DBUS_GERROR_NAME_HAS_NO_OWNER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NameHasNoOwner", error->message);
				break;
				case DBUS_GERROR_NO_REPLY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoReply", error->message);
				break;
				case DBUS_GERROR_IO_ERROR:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.IOError", error->message);
				break;
				case DBUS_GERROR_BAD_ADDRESS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.BadAddress", error->message);
				break;
				case DBUS_GERROR_NOT_SUPPORTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NotSupported", error->message);
				break;
				case DBUS_GERROR_LIMITS_EXCEEDED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.LimitsExceeded", error->message);
				break;
				case DBUS_GERROR_ACCESS_DENIED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AccessDenied", error->message);
				break;
				case DBUS_GERROR_AUTH_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AuthFailed", error->message);
				break;
				case DBUS_GERROR_NO_SERVER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoServer", error->message);
				break;
				case DBUS_GERROR_TIMEOUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Timeout", error->message);
				break;
				case DBUS_GERROR_NO_NETWORK:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoNetwork", error->message);
				break;
				case DBUS_GERROR_ADDRESS_IN_USE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AddressInUse", error->message);
				break;
				case DBUS_GERROR_DISCONNECTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Disconnected", error->message);
				break;
				case DBUS_GERROR_INVALID_ARGS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidArgs", error->message);
				break;
				case DBUS_GERROR_FILE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileNotFound", error->message);
				break;
				case DBUS_GERROR_FILE_EXISTS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileExists", error->message);
				break;
				case DBUS_GERROR_UNKNOWN_METHOD:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnknownMethod", error->message);
				break;
				case DBUS_GERROR_TIMED_OUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.TimedOut", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleNotFound", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_INVALID:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleInvalid", error->message);
				break;
				case DBUS_GERROR_SPAWN_EXEC_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ExecFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_FORK_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ForkFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_EXITED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildExited", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_SIGNALED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildSignaled", error->message);
				break;
				case DBUS_GERROR_SPAWN_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.Failed", error->message);
				break;
				case DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnixProcessIdUnknown", error->message);
				break;
				case DBUS_GERROR_INVALID_SIGNATURE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidSignature", error->message);
				break;
				case DBUS_GERROR_INVALID_FILE_CONTENT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidFileContent", error->message);
				break;
				case DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.SELinuxSecurityContextUnknown", error->message);
				break;
				case DBUS_GERROR_REMOTE_EXCEPTION:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.RemoteException", error->message);
				break;
			}
		}
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	}
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	_g_free0 (name);
	_tmp10_ = result;
	dbus_message_iter_open_container (&iter, DBUS_TYPE_ARRAY, "o", &_tmp11_);
	for (_tmp12_ = 0; _tmp12_ < result_length1; _tmp12_++) {
		const char* _tmp13_;
		_tmp13_ = *_tmp10_;
		dbus_message_iter_append_basic (&_tmp11_, DBUS_TYPE_OBJECT_PATH, &_tmp13_);
		_tmp10_++;
	}
	dbus_message_iter_close_container (&iter, &_tmp11_);
	result = (_vala_array_free (result,  result_length1, (GDestroyNotify) g_free), NULL);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static DBusHandlerResult _dbus_dock_manager_dbus_interface_get_items_by_desktop_file (DockManagerDBusInterface* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	char* desktop_file = NULL;
	const char* _tmp14_;
	char** result;
	int result_length1;
	DBusMessage* reply;
	char** _tmp15_;
	DBusMessageIter _tmp16_;
	int _tmp17_;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "s")) {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
	dbus_message_iter_init (message, &iter);
	dbus_message_iter_get_basic (&iter, &_tmp14_);
	dbus_message_iter_next (&iter);
	desktop_file = g_strdup (_tmp14_);
	result_length1 = 0;
	result = dock_manager_dbus_interface_get_items_by_desktop_file (self, desktop_file, &result_length1, &error);
	if (error) {
		if (error->domain == DBUS_GERROR) {
			switch (error->code) {
				case DBUS_GERROR_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Failed", error->message);
				break;
				case DBUS_GERROR_NO_MEMORY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoMemory", error->message);
				break;
				case DBUS_GERROR_SERVICE_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.ServiceUnknown", error->message);
				break;
				case DBUS_GERROR_NAME_HAS_NO_OWNER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NameHasNoOwner", error->message);
				break;
				case DBUS_GERROR_NO_REPLY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoReply", error->message);
				break;
				case DBUS_GERROR_IO_ERROR:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.IOError", error->message);
				break;
				case DBUS_GERROR_BAD_ADDRESS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.BadAddress", error->message);
				break;
				case DBUS_GERROR_NOT_SUPPORTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NotSupported", error->message);
				break;
				case DBUS_GERROR_LIMITS_EXCEEDED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.LimitsExceeded", error->message);
				break;
				case DBUS_GERROR_ACCESS_DENIED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AccessDenied", error->message);
				break;
				case DBUS_GERROR_AUTH_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AuthFailed", error->message);
				break;
				case DBUS_GERROR_NO_SERVER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoServer", error->message);
				break;
				case DBUS_GERROR_TIMEOUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Timeout", error->message);
				break;
				case DBUS_GERROR_NO_NETWORK:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoNetwork", error->message);
				break;
				case DBUS_GERROR_ADDRESS_IN_USE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AddressInUse", error->message);
				break;
				case DBUS_GERROR_DISCONNECTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Disconnected", error->message);
				break;
				case DBUS_GERROR_INVALID_ARGS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidArgs", error->message);
				break;
				case DBUS_GERROR_FILE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileNotFound", error->message);
				break;
				case DBUS_GERROR_FILE_EXISTS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileExists", error->message);
				break;
				case DBUS_GERROR_UNKNOWN_METHOD:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnknownMethod", error->message);
				break;
				case DBUS_GERROR_TIMED_OUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.TimedOut", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleNotFound", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_INVALID:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleInvalid", error->message);
				break;
				case DBUS_GERROR_SPAWN_EXEC_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ExecFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_FORK_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ForkFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_EXITED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildExited", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_SIGNALED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildSignaled", error->message);
				break;
				case DBUS_GERROR_SPAWN_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.Failed", error->message);
				break;
				case DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnixProcessIdUnknown", error->message);
				break;
				case DBUS_GERROR_INVALID_SIGNATURE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidSignature", error->message);
				break;
				case DBUS_GERROR_INVALID_FILE_CONTENT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidFileContent", error->message);
				break;
				case DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.SELinuxSecurityContextUnknown", error->message);
				break;
				case DBUS_GERROR_REMOTE_EXCEPTION:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.RemoteException", error->message);
				break;
			}
		}
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	}
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	_g_free0 (desktop_file);
	_tmp15_ = result;
	dbus_message_iter_open_container (&iter, DBUS_TYPE_ARRAY, "o", &_tmp16_);
	for (_tmp17_ = 0; _tmp17_ < result_length1; _tmp17_++) {
		const char* _tmp18_;
		_tmp18_ = *_tmp15_;
		dbus_message_iter_append_basic (&_tmp16_, DBUS_TYPE_OBJECT_PATH, &_tmp18_);
		_tmp15_++;
	}
	dbus_message_iter_close_container (&iter, &_tmp16_);
	result = (_vala_array_free (result,  result_length1, (GDestroyNotify) g_free), NULL);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static DBusHandlerResult _dbus_dock_manager_dbus_interface_get_items_by_pid (DockManagerDBusInterface* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	gint pid = 0;
	dbus_int32_t _tmp19_;
	char** result;
	int result_length1;
	DBusMessage* reply;
	char** _tmp20_;
	DBusMessageIter _tmp21_;
	int _tmp22_;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "i")) {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
	dbus_message_iter_init (message, &iter);
	dbus_message_iter_get_basic (&iter, &_tmp19_);
	dbus_message_iter_next (&iter);
	pid = _tmp19_;
	result_length1 = 0;
	result = dock_manager_dbus_interface_get_items_by_pid (self, pid, &result_length1, &error);
	if (error) {
		if (error->domain == DBUS_GERROR) {
			switch (error->code) {
				case DBUS_GERROR_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Failed", error->message);
				break;
				case DBUS_GERROR_NO_MEMORY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoMemory", error->message);
				break;
				case DBUS_GERROR_SERVICE_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.ServiceUnknown", error->message);
				break;
				case DBUS_GERROR_NAME_HAS_NO_OWNER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NameHasNoOwner", error->message);
				break;
				case DBUS_GERROR_NO_REPLY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoReply", error->message);
				break;
				case DBUS_GERROR_IO_ERROR:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.IOError", error->message);
				break;
				case DBUS_GERROR_BAD_ADDRESS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.BadAddress", error->message);
				break;
				case DBUS_GERROR_NOT_SUPPORTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NotSupported", error->message);
				break;
				case DBUS_GERROR_LIMITS_EXCEEDED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.LimitsExceeded", error->message);
				break;
				case DBUS_GERROR_ACCESS_DENIED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AccessDenied", error->message);
				break;
				case DBUS_GERROR_AUTH_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AuthFailed", error->message);
				break;
				case DBUS_GERROR_NO_SERVER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoServer", error->message);
				break;
				case DBUS_GERROR_TIMEOUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Timeout", error->message);
				break;
				case DBUS_GERROR_NO_NETWORK:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoNetwork", error->message);
				break;
				case DBUS_GERROR_ADDRESS_IN_USE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AddressInUse", error->message);
				break;
				case DBUS_GERROR_DISCONNECTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Disconnected", error->message);
				break;
				case DBUS_GERROR_INVALID_ARGS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidArgs", error->message);
				break;
				case DBUS_GERROR_FILE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileNotFound", error->message);
				break;
				case DBUS_GERROR_FILE_EXISTS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileExists", error->message);
				break;
				case DBUS_GERROR_UNKNOWN_METHOD:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnknownMethod", error->message);
				break;
				case DBUS_GERROR_TIMED_OUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.TimedOut", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleNotFound", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_INVALID:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleInvalid", error->message);
				break;
				case DBUS_GERROR_SPAWN_EXEC_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ExecFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_FORK_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ForkFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_EXITED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildExited", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_SIGNALED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildSignaled", error->message);
				break;
				case DBUS_GERROR_SPAWN_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.Failed", error->message);
				break;
				case DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnixProcessIdUnknown", error->message);
				break;
				case DBUS_GERROR_INVALID_SIGNATURE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidSignature", error->message);
				break;
				case DBUS_GERROR_INVALID_FILE_CONTENT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidFileContent", error->message);
				break;
				case DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.SELinuxSecurityContextUnknown", error->message);
				break;
				case DBUS_GERROR_REMOTE_EXCEPTION:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.RemoteException", error->message);
				break;
			}
		}
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	}
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	_tmp20_ = result;
	dbus_message_iter_open_container (&iter, DBUS_TYPE_ARRAY, "o", &_tmp21_);
	for (_tmp22_ = 0; _tmp22_ < result_length1; _tmp22_++) {
		const char* _tmp23_;
		_tmp23_ = *_tmp20_;
		dbus_message_iter_append_basic (&_tmp21_, DBUS_TYPE_OBJECT_PATH, &_tmp23_);
		_tmp20_++;
	}
	dbus_message_iter_close_container (&iter, &_tmp21_);
	result = (_vala_array_free (result,  result_length1, (GDestroyNotify) g_free), NULL);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static DBusHandlerResult _dbus_dock_manager_dbus_interface_get_item_by_xid (DockManagerDBusInterface* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	gint64 xid = 0LL;
	dbus_int64_t _tmp24_;
	char* result;
	DBusMessage* reply;
	const char* _tmp25_;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "x")) {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
	dbus_message_iter_init (message, &iter);
	dbus_message_iter_get_basic (&iter, &_tmp24_);
	dbus_message_iter_next (&iter);
	xid = _tmp24_;
	result = dock_manager_dbus_interface_get_item_by_xid (self, xid, &error);
	if (error) {
		if (error->domain == DBUS_GERROR) {
			switch (error->code) {
				case DBUS_GERROR_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Failed", error->message);
				break;
				case DBUS_GERROR_NO_MEMORY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoMemory", error->message);
				break;
				case DBUS_GERROR_SERVICE_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.ServiceUnknown", error->message);
				break;
				case DBUS_GERROR_NAME_HAS_NO_OWNER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NameHasNoOwner", error->message);
				break;
				case DBUS_GERROR_NO_REPLY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoReply", error->message);
				break;
				case DBUS_GERROR_IO_ERROR:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.IOError", error->message);
				break;
				case DBUS_GERROR_BAD_ADDRESS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.BadAddress", error->message);
				break;
				case DBUS_GERROR_NOT_SUPPORTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NotSupported", error->message);
				break;
				case DBUS_GERROR_LIMITS_EXCEEDED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.LimitsExceeded", error->message);
				break;
				case DBUS_GERROR_ACCESS_DENIED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AccessDenied", error->message);
				break;
				case DBUS_GERROR_AUTH_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AuthFailed", error->message);
				break;
				case DBUS_GERROR_NO_SERVER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoServer", error->message);
				break;
				case DBUS_GERROR_TIMEOUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Timeout", error->message);
				break;
				case DBUS_GERROR_NO_NETWORK:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoNetwork", error->message);
				break;
				case DBUS_GERROR_ADDRESS_IN_USE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AddressInUse", error->message);
				break;
				case DBUS_GERROR_DISCONNECTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Disconnected", error->message);
				break;
				case DBUS_GERROR_INVALID_ARGS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidArgs", error->message);
				break;
				case DBUS_GERROR_FILE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileNotFound", error->message);
				break;
				case DBUS_GERROR_FILE_EXISTS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileExists", error->message);
				break;
				case DBUS_GERROR_UNKNOWN_METHOD:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnknownMethod", error->message);
				break;
				case DBUS_GERROR_TIMED_OUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.TimedOut", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleNotFound", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_INVALID:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleInvalid", error->message);
				break;
				case DBUS_GERROR_SPAWN_EXEC_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ExecFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_FORK_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ForkFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_EXITED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildExited", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_SIGNALED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildSignaled", error->message);
				break;
				case DBUS_GERROR_SPAWN_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.Failed", error->message);
				break;
				case DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnixProcessIdUnknown", error->message);
				break;
				case DBUS_GERROR_INVALID_SIGNATURE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidSignature", error->message);
				break;
				case DBUS_GERROR_INVALID_FILE_CONTENT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidFileContent", error->message);
				break;
				case DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.SELinuxSecurityContextUnknown", error->message);
				break;
				case DBUS_GERROR_REMOTE_EXCEPTION:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.RemoteException", error->message);
				break;
			}
		}
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	}
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	_tmp25_ = result;
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_OBJECT_PATH, &_tmp25_);
	_g_free0 (result);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static DBusHandlerResult _dbus_dock_manager_dbus_interface_awn_set_visibility (DockManagerDBusInterface* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	char* win_name = NULL;
	const char* _tmp26_;
	gboolean visible = FALSE;
	dbus_bool_t _tmp27_;
	DBusMessage* reply;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "sb")) {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
	dbus_message_iter_init (message, &iter);
	dbus_message_iter_get_basic (&iter, &_tmp26_);
	dbus_message_iter_next (&iter);
	win_name = g_strdup (_tmp26_);
	dbus_message_iter_get_basic (&iter, &_tmp27_);
	dbus_message_iter_next (&iter);
	visible = _tmp27_;
	dock_manager_dbus_interface_awn_set_visibility (self, win_name, visible, &error);
	if (error) {
		if (error->domain == DBUS_GERROR) {
			switch (error->code) {
				case DBUS_GERROR_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Failed", error->message);
				break;
				case DBUS_GERROR_NO_MEMORY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoMemory", error->message);
				break;
				case DBUS_GERROR_SERVICE_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.ServiceUnknown", error->message);
				break;
				case DBUS_GERROR_NAME_HAS_NO_OWNER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NameHasNoOwner", error->message);
				break;
				case DBUS_GERROR_NO_REPLY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoReply", error->message);
				break;
				case DBUS_GERROR_IO_ERROR:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.IOError", error->message);
				break;
				case DBUS_GERROR_BAD_ADDRESS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.BadAddress", error->message);
				break;
				case DBUS_GERROR_NOT_SUPPORTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NotSupported", error->message);
				break;
				case DBUS_GERROR_LIMITS_EXCEEDED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.LimitsExceeded", error->message);
				break;
				case DBUS_GERROR_ACCESS_DENIED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AccessDenied", error->message);
				break;
				case DBUS_GERROR_AUTH_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AuthFailed", error->message);
				break;
				case DBUS_GERROR_NO_SERVER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoServer", error->message);
				break;
				case DBUS_GERROR_TIMEOUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Timeout", error->message);
				break;
				case DBUS_GERROR_NO_NETWORK:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoNetwork", error->message);
				break;
				case DBUS_GERROR_ADDRESS_IN_USE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AddressInUse", error->message);
				break;
				case DBUS_GERROR_DISCONNECTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Disconnected", error->message);
				break;
				case DBUS_GERROR_INVALID_ARGS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidArgs", error->message);
				break;
				case DBUS_GERROR_FILE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileNotFound", error->message);
				break;
				case DBUS_GERROR_FILE_EXISTS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileExists", error->message);
				break;
				case DBUS_GERROR_UNKNOWN_METHOD:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnknownMethod", error->message);
				break;
				case DBUS_GERROR_TIMED_OUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.TimedOut", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleNotFound", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_INVALID:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleInvalid", error->message);
				break;
				case DBUS_GERROR_SPAWN_EXEC_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ExecFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_FORK_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ForkFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_EXITED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildExited", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_SIGNALED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildSignaled", error->message);
				break;
				case DBUS_GERROR_SPAWN_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.Failed", error->message);
				break;
				case DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnixProcessIdUnknown", error->message);
				break;
				case DBUS_GERROR_INVALID_SIGNATURE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidSignature", error->message);
				break;
				case DBUS_GERROR_INVALID_FILE_CONTENT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidFileContent", error->message);
				break;
				case DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.SELinuxSecurityContextUnknown", error->message);
				break;
				case DBUS_GERROR_REMOTE_EXCEPTION:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.RemoteException", error->message);
				break;
			}
		}
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	}
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	_g_free0 (win_name);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static DBusHandlerResult _dbus_dock_manager_dbus_interface_awn_register_proxy_item (DockManagerDBusInterface* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	char* desktop_file = NULL;
	const char* _tmp28_;
	char* uri = NULL;
	const char* _tmp29_;
	char* result;
	DBusMessage* reply;
	const char* _tmp30_;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "ss")) {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
	dbus_message_iter_init (message, &iter);
	dbus_message_iter_get_basic (&iter, &_tmp28_);
	dbus_message_iter_next (&iter);
	desktop_file = g_strdup (_tmp28_);
	dbus_message_iter_get_basic (&iter, &_tmp29_);
	dbus_message_iter_next (&iter);
	uri = g_strdup (_tmp29_);
	result = dock_manager_dbus_interface_awn_register_proxy_item (self, desktop_file, uri, &error);
	if (error) {
		if (error->domain == DBUS_GERROR) {
			switch (error->code) {
				case DBUS_GERROR_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Failed", error->message);
				break;
				case DBUS_GERROR_NO_MEMORY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoMemory", error->message);
				break;
				case DBUS_GERROR_SERVICE_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.ServiceUnknown", error->message);
				break;
				case DBUS_GERROR_NAME_HAS_NO_OWNER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NameHasNoOwner", error->message);
				break;
				case DBUS_GERROR_NO_REPLY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoReply", error->message);
				break;
				case DBUS_GERROR_IO_ERROR:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.IOError", error->message);
				break;
				case DBUS_GERROR_BAD_ADDRESS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.BadAddress", error->message);
				break;
				case DBUS_GERROR_NOT_SUPPORTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NotSupported", error->message);
				break;
				case DBUS_GERROR_LIMITS_EXCEEDED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.LimitsExceeded", error->message);
				break;
				case DBUS_GERROR_ACCESS_DENIED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AccessDenied", error->message);
				break;
				case DBUS_GERROR_AUTH_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AuthFailed", error->message);
				break;
				case DBUS_GERROR_NO_SERVER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoServer", error->message);
				break;
				case DBUS_GERROR_TIMEOUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Timeout", error->message);
				break;
				case DBUS_GERROR_NO_NETWORK:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoNetwork", error->message);
				break;
				case DBUS_GERROR_ADDRESS_IN_USE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AddressInUse", error->message);
				break;
				case DBUS_GERROR_DISCONNECTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Disconnected", error->message);
				break;
				case DBUS_GERROR_INVALID_ARGS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidArgs", error->message);
				break;
				case DBUS_GERROR_FILE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileNotFound", error->message);
				break;
				case DBUS_GERROR_FILE_EXISTS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileExists", error->message);
				break;
				case DBUS_GERROR_UNKNOWN_METHOD:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnknownMethod", error->message);
				break;
				case DBUS_GERROR_TIMED_OUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.TimedOut", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleNotFound", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_INVALID:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleInvalid", error->message);
				break;
				case DBUS_GERROR_SPAWN_EXEC_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ExecFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_FORK_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ForkFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_EXITED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildExited", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_SIGNALED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildSignaled", error->message);
				break;
				case DBUS_GERROR_SPAWN_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.Failed", error->message);
				break;
				case DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnixProcessIdUnknown", error->message);
				break;
				case DBUS_GERROR_INVALID_SIGNATURE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidSignature", error->message);
				break;
				case DBUS_GERROR_INVALID_FILE_CONTENT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidFileContent", error->message);
				break;
				case DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.SELinuxSecurityContextUnknown", error->message);
				break;
				case DBUS_GERROR_REMOTE_EXCEPTION:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.RemoteException", error->message);
				break;
			}
		}
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	}
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	_g_free0 (desktop_file);
	_g_free0 (uri);
	_tmp30_ = result;
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_OBJECT_PATH, &_tmp30_);
	_g_free0 (result);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


DBusHandlerResult dock_manager_dbus_interface_dbus_message (DBusConnection* connection, DBusMessage* message, void* object) {
	DBusHandlerResult result;
	result = DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	if (dbus_message_is_method_call (message, "org.freedesktop.DBus.Introspectable", "Introspect")) {
		result = _dbus_dock_manager_dbus_interface_introspect (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.freedesktop.DBus.Properties", "GetAll")) {
		result = _dbus_dock_manager_dbus_interface_property_get_all (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.freedesktop.DockManager", "GetCapabilities")) {
		result = _dbus_dock_manager_dbus_interface_get_capabilities (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.freedesktop.DockManager", "GetItems")) {
		result = _dbus_dock_manager_dbus_interface_get_items (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.freedesktop.DockManager", "GetItemsByName")) {
		result = _dbus_dock_manager_dbus_interface_get_items_by_name (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.freedesktop.DockManager", "GetItemsByDesktopFile")) {
		result = _dbus_dock_manager_dbus_interface_get_items_by_desktop_file (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.freedesktop.DockManager", "GetItemsByPid")) {
		result = _dbus_dock_manager_dbus_interface_get_items_by_pid (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.freedesktop.DockManager", "GetItemByXid")) {
		result = _dbus_dock_manager_dbus_interface_get_item_by_xid (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.freedesktop.DockManager", "AwnSetVisibility")) {
		result = _dbus_dock_manager_dbus_interface_awn_set_visibility (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.freedesktop.DockManager", "AwnRegisterProxyItem")) {
		result = _dbus_dock_manager_dbus_interface_awn_register_proxy_item (object, connection, message);
	}
	if (result == DBUS_HANDLER_RESULT_HANDLED) {
		return result;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static void _dbus_dock_manager_dbus_interface_item_added (GObject* _sender, const char* path, DBusConnection* _connection) {
	const char * _path;
	DBusMessage *_message;
	DBusMessageIter _iter;
	const char* _tmp31_;
	_path = g_object_get_data (_sender, "dbus_object_path");
	_message = dbus_message_new_signal (_path, "org.freedesktop.DockManager", "ItemAdded");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp31_ = path;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_OBJECT_PATH, &_tmp31_);
	dbus_connection_send (_connection, _message, NULL);
	dbus_message_unref (_message);
}


static void _dbus_dock_manager_dbus_interface_item_removed (GObject* _sender, const char* path, DBusConnection* _connection) {
	const char * _path;
	DBusMessage *_message;
	DBusMessageIter _iter;
	const char* _tmp32_;
	_path = g_object_get_data (_sender, "dbus_object_path");
	_message = dbus_message_new_signal (_path, "org.freedesktop.DockManager", "ItemRemoved");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp32_ = path;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_OBJECT_PATH, &_tmp32_);
	dbus_connection_send (_connection, _message, NULL);
	dbus_message_unref (_message);
}


void dock_manager_dbus_interface_dbus_register_object (DBusConnection* connection, const char* path, void* object) {
	if (!g_object_get_data (object, "dbus_object_path")) {
		g_object_set_data (object, "dbus_object_path", g_strdup (path));
		dbus_connection_register_object_path (connection, path, &_dock_manager_dbus_interface_dbus_path_vtable, object);
		g_object_weak_ref (object, _vala_dbus_unregister_object, connection);
	}
	g_signal_connect (object, "item-added", (GCallback) _dbus_dock_manager_dbus_interface_item_added, connection);
	g_signal_connect (object, "item-removed", (GCallback) _dbus_dock_manager_dbus_interface_item_removed, connection);
}


static void dock_manager_dbus_interface_base_init (DockManagerDBusInterfaceIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
		g_signal_new ("item_added", TYPE_DOCK_MANAGER_DBUS_INTERFACE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__BOXED, G_TYPE_NONE, 1, DBUS_TYPE_G_OBJECT_PATH);
		g_signal_new ("item_removed", TYPE_DOCK_MANAGER_DBUS_INTERFACE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__BOXED, G_TYPE_NONE, 1, DBUS_TYPE_G_OBJECT_PATH);
		g_type_set_qdata (TYPE_DOCK_MANAGER_DBUS_INTERFACE, g_quark_from_static_string ("DBusObjectVTable"), (void*) (&_dock_manager_dbus_interface_dbus_vtable));
	}
}


GType dock_manager_dbus_interface_get_type (void) {
	static volatile gsize dock_manager_dbus_interface_type_id__volatile = 0;
	if (g_once_init_enter (&dock_manager_dbus_interface_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DockManagerDBusInterfaceIface), (GBaseInitFunc) dock_manager_dbus_interface_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType dock_manager_dbus_interface_type_id;
		dock_manager_dbus_interface_type_id = g_type_register_static (G_TYPE_INTERFACE, "DockManagerDBusInterface", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (dock_manager_dbus_interface_type_id, G_TYPE_OBJECT);
		g_type_set_qdata (dock_manager_dbus_interface_type_id, g_quark_from_string ("ValaDBusInterfaceProxyType"), &dock_manager_dbus_interface_dbus_proxy_get_type);
		g_once_init_leave (&dock_manager_dbus_interface_type_id__volatile, dock_manager_dbus_interface_type_id);
	}
	return dock_manager_dbus_interface_type_id__volatile;
}


G_DEFINE_TYPE_EXTENDED (DockManagerDBusInterfaceDBusProxy, dock_manager_dbus_interface_dbus_proxy, DBUS_TYPE_G_PROXY, 0, G_IMPLEMENT_INTERFACE (TYPE_DOCK_MANAGER_DBUS_INTERFACE, dock_manager_dbus_interface_dbus_proxy_dock_manager_dbus_interface__interface_init) );
DockManagerDBusInterface* dock_manager_dbus_interface_dbus_proxy_new (DBusGConnection* connection, const char* name, const char* path) {
	DockManagerDBusInterface* self;
	self = g_object_new (dock_manager_dbus_interface_dbus_proxy_get_type (), "connection", connection, "name", name, "path", path, "interface", "org.freedesktop.DockManager", NULL);
	return self;
}


static GObject* dock_manager_dbus_interface_dbus_proxy_construct (GType gtype, guint n_properties, GObjectConstructParam* properties) {
	GObject* self;
	DBusGConnection *connection;
	char* path;
	char* filter;
	self = G_OBJECT_CLASS (dock_manager_dbus_interface_dbus_proxy_parent_class)->constructor (gtype, n_properties, properties);
	g_object_get (self, "connection", &connection, NULL);
	g_object_get (self, "path", &path, NULL);
	dbus_connection_add_filter (dbus_g_connection_get_connection (connection), dock_manager_dbus_interface_dbus_proxy_filter, self, NULL);
	filter = g_strdup_printf ("type='signal',path='%s'", path);
	dbus_bus_add_match (dbus_g_connection_get_connection (connection), filter, NULL);
	dbus_g_connection_unref (connection);
	g_free (path);
	g_free (filter);
	return self;
}


static void _dbus_handle_dock_manager_dbus_interface_item_added (DockManagerDBusInterface* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	char* path = NULL;
	const char* _tmp33_;
	DBusMessage* reply;
	if (strcmp (dbus_message_get_signature (message), "o")) {
		return;
	}
	dbus_message_iter_init (message, &iter);
	dbus_message_iter_get_basic (&iter, &_tmp33_);
	dbus_message_iter_next (&iter);
	path = g_strdup (_tmp33_);
	g_signal_emit_by_name (self, "item-added", path);
	_g_free0 (path);
}


static void _dbus_handle_dock_manager_dbus_interface_item_removed (DockManagerDBusInterface* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	char* path = NULL;
	const char* _tmp34_;
	DBusMessage* reply;
	if (strcmp (dbus_message_get_signature (message), "o")) {
		return;
	}
	dbus_message_iter_init (message, &iter);
	dbus_message_iter_get_basic (&iter, &_tmp34_);
	dbus_message_iter_next (&iter);
	path = g_strdup (_tmp34_);
	g_signal_emit_by_name (self, "item-removed", path);
	_g_free0 (path);
}


DBusHandlerResult dock_manager_dbus_interface_dbus_proxy_filter (DBusConnection* connection, DBusMessage* message, void* user_data) {
	if (dbus_message_has_path (message, dbus_g_proxy_get_path (user_data))) {
		if (dbus_message_is_signal (message, "org.freedesktop.DockManager", "ItemAdded")) {
			_dbus_handle_dock_manager_dbus_interface_item_added (user_data, connection, message);
		} else if (dbus_message_is_signal (message, "org.freedesktop.DockManager", "ItemRemoved")) {
			_dbus_handle_dock_manager_dbus_interface_item_removed (user_data, connection, message);
		}
	}
	return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
}


static void dock_manager_dbus_interface_dbus_proxy_dispose (GObject* self) {
	DBusGConnection *connection;
	if (((DockManagerDBusInterfaceDBusProxy*) self)->disposed) {
		return;
	}
	((DockManagerDBusInterfaceDBusProxy*) self)->disposed = TRUE;
	g_object_get (self, "connection", &connection, NULL);
	dbus_connection_remove_filter (dbus_g_connection_get_connection (connection), dock_manager_dbus_interface_dbus_proxy_filter, self);
	G_OBJECT_CLASS (dock_manager_dbus_interface_dbus_proxy_parent_class)->dispose (self);
}


static void dock_manager_dbus_interface_dbus_proxy_class_init (DockManagerDBusInterfaceDBusProxyClass* klass) {
	G_OBJECT_CLASS (klass)->constructor = dock_manager_dbus_interface_dbus_proxy_construct;
	G_OBJECT_CLASS (klass)->dispose = dock_manager_dbus_interface_dbus_proxy_dispose;
	G_OBJECT_CLASS (klass)->get_property = dock_manager_dbus_interface_dbus_proxy_get_property;
	G_OBJECT_CLASS (klass)->set_property = dock_manager_dbus_interface_dbus_proxy_set_property;
}


static void dock_manager_dbus_interface_dbus_proxy_init (DockManagerDBusInterfaceDBusProxy* self) {
}


static char** dock_manager_dbus_interface_dbus_proxy_get_capabilities (DockManagerDBusInterface* self, int* result_length1, GError** error) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	char** _result;
	int _result_length1;
	char** _tmp35_;
	int _tmp35__length;
	int _tmp35__size;
	int _tmp35__length1;
	DBusMessageIter _tmp36_;
	if (((DockManagerDBusInterfaceDBusProxy*) self)->disposed) {
		g_set_error (error, DBUS_GERROR, DBUS_GERROR_DISCONNECTED, "%s", "Connection is closed");
		return NULL;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.freedesktop.DockManager", "GetCapabilities");
	dbus_message_iter_init_append (_message, &_iter);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		GQuark _edomain;
		gint _ecode;
		if (strstr (_dbus_error.name, "org.freedesktop.DBus.Error") == _dbus_error.name) {
			const char* _tmp38_;
			_edomain = DBUS_GERROR;
			_tmp38_ = _dbus_error.name + 27;
			if (strcmp (_tmp38_, "Failed") == 0) {
				_ecode = DBUS_GERROR_FAILED;
			} else if (strcmp (_tmp38_, "NoMemory") == 0) {
				_ecode = DBUS_GERROR_NO_MEMORY;
			} else if (strcmp (_tmp38_, "ServiceUnknown") == 0) {
				_ecode = DBUS_GERROR_SERVICE_UNKNOWN;
			} else if (strcmp (_tmp38_, "NameHasNoOwner") == 0) {
				_ecode = DBUS_GERROR_NAME_HAS_NO_OWNER;
			} else if (strcmp (_tmp38_, "NoReply") == 0) {
				_ecode = DBUS_GERROR_NO_REPLY;
			} else if (strcmp (_tmp38_, "IOError") == 0) {
				_ecode = DBUS_GERROR_IO_ERROR;
			} else if (strcmp (_tmp38_, "BadAddress") == 0) {
				_ecode = DBUS_GERROR_BAD_ADDRESS;
			} else if (strcmp (_tmp38_, "NotSupported") == 0) {
				_ecode = DBUS_GERROR_NOT_SUPPORTED;
			} else if (strcmp (_tmp38_, "LimitsExceeded") == 0) {
				_ecode = DBUS_GERROR_LIMITS_EXCEEDED;
			} else if (strcmp (_tmp38_, "AccessDenied") == 0) {
				_ecode = DBUS_GERROR_ACCESS_DENIED;
			} else if (strcmp (_tmp38_, "AuthFailed") == 0) {
				_ecode = DBUS_GERROR_AUTH_FAILED;
			} else if (strcmp (_tmp38_, "NoServer") == 0) {
				_ecode = DBUS_GERROR_NO_SERVER;
			} else if (strcmp (_tmp38_, "Timeout") == 0) {
				_ecode = DBUS_GERROR_TIMEOUT;
			} else if (strcmp (_tmp38_, "NoNetwork") == 0) {
				_ecode = DBUS_GERROR_NO_NETWORK;
			} else if (strcmp (_tmp38_, "AddressInUse") == 0) {
				_ecode = DBUS_GERROR_ADDRESS_IN_USE;
			} else if (strcmp (_tmp38_, "Disconnected") == 0) {
				_ecode = DBUS_GERROR_DISCONNECTED;
			} else if (strcmp (_tmp38_, "InvalidArgs") == 0) {
				_ecode = DBUS_GERROR_INVALID_ARGS;
			} else if (strcmp (_tmp38_, "FileNotFound") == 0) {
				_ecode = DBUS_GERROR_FILE_NOT_FOUND;
			} else if (strcmp (_tmp38_, "FileExists") == 0) {
				_ecode = DBUS_GERROR_FILE_EXISTS;
			} else if (strcmp (_tmp38_, "UnknownMethod") == 0) {
				_ecode = DBUS_GERROR_UNKNOWN_METHOD;
			} else if (strcmp (_tmp38_, "TimedOut") == 0) {
				_ecode = DBUS_GERROR_TIMED_OUT;
			} else if (strcmp (_tmp38_, "MatchRuleNotFound") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_NOT_FOUND;
			} else if (strcmp (_tmp38_, "MatchRuleInvalid") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_INVALID;
			} else if (strcmp (_tmp38_, "Spawn.ExecFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_EXEC_FAILED;
			} else if (strcmp (_tmp38_, "Spawn.ForkFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FORK_FAILED;
			} else if (strcmp (_tmp38_, "Spawn.ChildExited") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_EXITED;
			} else if (strcmp (_tmp38_, "Spawn.ChildSignaled") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_SIGNALED;
			} else if (strcmp (_tmp38_, "Spawn.Failed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FAILED;
			} else if (strcmp (_tmp38_, "UnixProcessIdUnknown") == 0) {
				_ecode = DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN;
			} else if (strcmp (_tmp38_, "InvalidSignature") == 0) {
				_ecode = DBUS_GERROR_INVALID_SIGNATURE;
			} else if (strcmp (_tmp38_, "InvalidFileContent") == 0) {
				_ecode = DBUS_GERROR_INVALID_FILE_CONTENT;
			} else if (strcmp (_tmp38_, "SELinuxSecurityContextUnknown") == 0) {
				_ecode = DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN;
			} else if (strcmp (_tmp38_, "RemoteException") == 0) {
				_ecode = DBUS_GERROR_REMOTE_EXCEPTION;
			}
		}
		g_set_error (error, _edomain, _ecode, "%s", _dbus_error.message);
		dbus_error_free (&_dbus_error);
		return NULL;
	}
	if (strcmp (dbus_message_get_signature (_reply), "as")) {
		g_set_error (error, DBUS_GERROR, DBUS_GERROR_INVALID_SIGNATURE, "Invalid signature, expected \"%s\", got \"%s\"", "as", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return NULL;
	}
	dbus_message_iter_init (_reply, &_iter);
	_result_length1 = 0;
	_tmp35_ = g_new (char*, 5);
	_tmp35__length = 0;
	_tmp35__size = 4;
	_tmp35__length1 = 0;
	dbus_message_iter_recurse (&_iter, &_tmp36_);
	for (; dbus_message_iter_get_arg_type (&_tmp36_); _tmp35__length1++) {
		const char* _tmp37_;
		if (_tmp35__size == _tmp35__length) {
			_tmp35__size = 2 * _tmp35__size;
			_tmp35_ = g_renew (char*, _tmp35_, _tmp35__size + 1);
		}
		dbus_message_iter_get_basic (&_tmp36_, &_tmp37_);
		dbus_message_iter_next (&_tmp36_);
		_tmp35_[_tmp35__length++] = g_strdup (_tmp37_);
	}
	_result_length1 = _tmp35__length1;
	_tmp35_[_tmp35__length] = NULL;
	dbus_message_iter_next (&_iter);
	_result = _tmp35_;
	*result_length1 = _result_length1;
	dbus_message_unref (_reply);
	return _result;
}


static char** dock_manager_dbus_interface_dbus_proxy_get_items (DockManagerDBusInterface* self, int* result_length1, GError** error) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	char** _result;
	int _result_length1;
	char** _tmp39_;
	int _tmp39__length;
	int _tmp39__size;
	int _tmp39__length1;
	DBusMessageIter _tmp40_;
	if (((DockManagerDBusInterfaceDBusProxy*) self)->disposed) {
		g_set_error (error, DBUS_GERROR, DBUS_GERROR_DISCONNECTED, "%s", "Connection is closed");
		return NULL;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.freedesktop.DockManager", "GetItems");
	dbus_message_iter_init_append (_message, &_iter);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		GQuark _edomain;
		gint _ecode;
		if (strstr (_dbus_error.name, "org.freedesktop.DBus.Error") == _dbus_error.name) {
			const char* _tmp42_;
			_edomain = DBUS_GERROR;
			_tmp42_ = _dbus_error.name + 27;
			if (strcmp (_tmp42_, "Failed") == 0) {
				_ecode = DBUS_GERROR_FAILED;
			} else if (strcmp (_tmp42_, "NoMemory") == 0) {
				_ecode = DBUS_GERROR_NO_MEMORY;
			} else if (strcmp (_tmp42_, "ServiceUnknown") == 0) {
				_ecode = DBUS_GERROR_SERVICE_UNKNOWN;
			} else if (strcmp (_tmp42_, "NameHasNoOwner") == 0) {
				_ecode = DBUS_GERROR_NAME_HAS_NO_OWNER;
			} else if (strcmp (_tmp42_, "NoReply") == 0) {
				_ecode = DBUS_GERROR_NO_REPLY;
			} else if (strcmp (_tmp42_, "IOError") == 0) {
				_ecode = DBUS_GERROR_IO_ERROR;
			} else if (strcmp (_tmp42_, "BadAddress") == 0) {
				_ecode = DBUS_GERROR_BAD_ADDRESS;
			} else if (strcmp (_tmp42_, "NotSupported") == 0) {
				_ecode = DBUS_GERROR_NOT_SUPPORTED;
			} else if (strcmp (_tmp42_, "LimitsExceeded") == 0) {
				_ecode = DBUS_GERROR_LIMITS_EXCEEDED;
			} else if (strcmp (_tmp42_, "AccessDenied") == 0) {
				_ecode = DBUS_GERROR_ACCESS_DENIED;
			} else if (strcmp (_tmp42_, "AuthFailed") == 0) {
				_ecode = DBUS_GERROR_AUTH_FAILED;
			} else if (strcmp (_tmp42_, "NoServer") == 0) {
				_ecode = DBUS_GERROR_NO_SERVER;
			} else if (strcmp (_tmp42_, "Timeout") == 0) {
				_ecode = DBUS_GERROR_TIMEOUT;
			} else if (strcmp (_tmp42_, "NoNetwork") == 0) {
				_ecode = DBUS_GERROR_NO_NETWORK;
			} else if (strcmp (_tmp42_, "AddressInUse") == 0) {
				_ecode = DBUS_GERROR_ADDRESS_IN_USE;
			} else if (strcmp (_tmp42_, "Disconnected") == 0) {
				_ecode = DBUS_GERROR_DISCONNECTED;
			} else if (strcmp (_tmp42_, "InvalidArgs") == 0) {
				_ecode = DBUS_GERROR_INVALID_ARGS;
			} else if (strcmp (_tmp42_, "FileNotFound") == 0) {
				_ecode = DBUS_GERROR_FILE_NOT_FOUND;
			} else if (strcmp (_tmp42_, "FileExists") == 0) {
				_ecode = DBUS_GERROR_FILE_EXISTS;
			} else if (strcmp (_tmp42_, "UnknownMethod") == 0) {
				_ecode = DBUS_GERROR_UNKNOWN_METHOD;
			} else if (strcmp (_tmp42_, "TimedOut") == 0) {
				_ecode = DBUS_GERROR_TIMED_OUT;
			} else if (strcmp (_tmp42_, "MatchRuleNotFound") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_NOT_FOUND;
			} else if (strcmp (_tmp42_, "MatchRuleInvalid") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_INVALID;
			} else if (strcmp (_tmp42_, "Spawn.ExecFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_EXEC_FAILED;
			} else if (strcmp (_tmp42_, "Spawn.ForkFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FORK_FAILED;
			} else if (strcmp (_tmp42_, "Spawn.ChildExited") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_EXITED;
			} else if (strcmp (_tmp42_, "Spawn.ChildSignaled") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_SIGNALED;
			} else if (strcmp (_tmp42_, "Spawn.Failed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FAILED;
			} else if (strcmp (_tmp42_, "UnixProcessIdUnknown") == 0) {
				_ecode = DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN;
			} else if (strcmp (_tmp42_, "InvalidSignature") == 0) {
				_ecode = DBUS_GERROR_INVALID_SIGNATURE;
			} else if (strcmp (_tmp42_, "InvalidFileContent") == 0) {
				_ecode = DBUS_GERROR_INVALID_FILE_CONTENT;
			} else if (strcmp (_tmp42_, "SELinuxSecurityContextUnknown") == 0) {
				_ecode = DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN;
			} else if (strcmp (_tmp42_, "RemoteException") == 0) {
				_ecode = DBUS_GERROR_REMOTE_EXCEPTION;
			}
		}
		g_set_error (error, _edomain, _ecode, "%s", _dbus_error.message);
		dbus_error_free (&_dbus_error);
		return NULL;
	}
	if (strcmp (dbus_message_get_signature (_reply), "ao")) {
		g_set_error (error, DBUS_GERROR, DBUS_GERROR_INVALID_SIGNATURE, "Invalid signature, expected \"%s\", got \"%s\"", "ao", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return NULL;
	}
	dbus_message_iter_init (_reply, &_iter);
	_result_length1 = 0;
	_tmp39_ = g_new (char*, 5);
	_tmp39__length = 0;
	_tmp39__size = 4;
	_tmp39__length1 = 0;
	dbus_message_iter_recurse (&_iter, &_tmp40_);
	for (; dbus_message_iter_get_arg_type (&_tmp40_); _tmp39__length1++) {
		const char* _tmp41_;
		if (_tmp39__size == _tmp39__length) {
			_tmp39__size = 2 * _tmp39__size;
			_tmp39_ = g_renew (char*, _tmp39_, _tmp39__size + 1);
		}
		dbus_message_iter_get_basic (&_tmp40_, &_tmp41_);
		dbus_message_iter_next (&_tmp40_);
		_tmp39_[_tmp39__length++] = g_strdup (_tmp41_);
	}
	_result_length1 = _tmp39__length1;
	_tmp39_[_tmp39__length] = NULL;
	dbus_message_iter_next (&_iter);
	_result = _tmp39_;
	*result_length1 = _result_length1;
	dbus_message_unref (_reply);
	return _result;
}


static char** dock_manager_dbus_interface_dbus_proxy_get_items_by_name (DockManagerDBusInterface* self, const char* name, int* result_length1, GError** error) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	const char* _tmp43_;
	char** _result;
	int _result_length1;
	char** _tmp44_;
	int _tmp44__length;
	int _tmp44__size;
	int _tmp44__length1;
	DBusMessageIter _tmp45_;
	if (((DockManagerDBusInterfaceDBusProxy*) self)->disposed) {
		g_set_error (error, DBUS_GERROR, DBUS_GERROR_DISCONNECTED, "%s", "Connection is closed");
		return NULL;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.freedesktop.DockManager", "GetItemsByName");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp43_ = name;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp43_);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		GQuark _edomain;
		gint _ecode;
		if (strstr (_dbus_error.name, "org.freedesktop.DBus.Error") == _dbus_error.name) {
			const char* _tmp47_;
			_edomain = DBUS_GERROR;
			_tmp47_ = _dbus_error.name + 27;
			if (strcmp (_tmp47_, "Failed") == 0) {
				_ecode = DBUS_GERROR_FAILED;
			} else if (strcmp (_tmp47_, "NoMemory") == 0) {
				_ecode = DBUS_GERROR_NO_MEMORY;
			} else if (strcmp (_tmp47_, "ServiceUnknown") == 0) {
				_ecode = DBUS_GERROR_SERVICE_UNKNOWN;
			} else if (strcmp (_tmp47_, "NameHasNoOwner") == 0) {
				_ecode = DBUS_GERROR_NAME_HAS_NO_OWNER;
			} else if (strcmp (_tmp47_, "NoReply") == 0) {
				_ecode = DBUS_GERROR_NO_REPLY;
			} else if (strcmp (_tmp47_, "IOError") == 0) {
				_ecode = DBUS_GERROR_IO_ERROR;
			} else if (strcmp (_tmp47_, "BadAddress") == 0) {
				_ecode = DBUS_GERROR_BAD_ADDRESS;
			} else if (strcmp (_tmp47_, "NotSupported") == 0) {
				_ecode = DBUS_GERROR_NOT_SUPPORTED;
			} else if (strcmp (_tmp47_, "LimitsExceeded") == 0) {
				_ecode = DBUS_GERROR_LIMITS_EXCEEDED;
			} else if (strcmp (_tmp47_, "AccessDenied") == 0) {
				_ecode = DBUS_GERROR_ACCESS_DENIED;
			} else if (strcmp (_tmp47_, "AuthFailed") == 0) {
				_ecode = DBUS_GERROR_AUTH_FAILED;
			} else if (strcmp (_tmp47_, "NoServer") == 0) {
				_ecode = DBUS_GERROR_NO_SERVER;
			} else if (strcmp (_tmp47_, "Timeout") == 0) {
				_ecode = DBUS_GERROR_TIMEOUT;
			} else if (strcmp (_tmp47_, "NoNetwork") == 0) {
				_ecode = DBUS_GERROR_NO_NETWORK;
			} else if (strcmp (_tmp47_, "AddressInUse") == 0) {
				_ecode = DBUS_GERROR_ADDRESS_IN_USE;
			} else if (strcmp (_tmp47_, "Disconnected") == 0) {
				_ecode = DBUS_GERROR_DISCONNECTED;
			} else if (strcmp (_tmp47_, "InvalidArgs") == 0) {
				_ecode = DBUS_GERROR_INVALID_ARGS;
			} else if (strcmp (_tmp47_, "FileNotFound") == 0) {
				_ecode = DBUS_GERROR_FILE_NOT_FOUND;
			} else if (strcmp (_tmp47_, "FileExists") == 0) {
				_ecode = DBUS_GERROR_FILE_EXISTS;
			} else if (strcmp (_tmp47_, "UnknownMethod") == 0) {
				_ecode = DBUS_GERROR_UNKNOWN_METHOD;
			} else if (strcmp (_tmp47_, "TimedOut") == 0) {
				_ecode = DBUS_GERROR_TIMED_OUT;
			} else if (strcmp (_tmp47_, "MatchRuleNotFound") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_NOT_FOUND;
			} else if (strcmp (_tmp47_, "MatchRuleInvalid") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_INVALID;
			} else if (strcmp (_tmp47_, "Spawn.ExecFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_EXEC_FAILED;
			} else if (strcmp (_tmp47_, "Spawn.ForkFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FORK_FAILED;
			} else if (strcmp (_tmp47_, "Spawn.ChildExited") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_EXITED;
			} else if (strcmp (_tmp47_, "Spawn.ChildSignaled") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_SIGNALED;
			} else if (strcmp (_tmp47_, "Spawn.Failed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FAILED;
			} else if (strcmp (_tmp47_, "UnixProcessIdUnknown") == 0) {
				_ecode = DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN;
			} else if (strcmp (_tmp47_, "InvalidSignature") == 0) {
				_ecode = DBUS_GERROR_INVALID_SIGNATURE;
			} else if (strcmp (_tmp47_, "InvalidFileContent") == 0) {
				_ecode = DBUS_GERROR_INVALID_FILE_CONTENT;
			} else if (strcmp (_tmp47_, "SELinuxSecurityContextUnknown") == 0) {
				_ecode = DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN;
			} else if (strcmp (_tmp47_, "RemoteException") == 0) {
				_ecode = DBUS_GERROR_REMOTE_EXCEPTION;
			}
		}
		g_set_error (error, _edomain, _ecode, "%s", _dbus_error.message);
		dbus_error_free (&_dbus_error);
		return NULL;
	}
	if (strcmp (dbus_message_get_signature (_reply), "ao")) {
		g_set_error (error, DBUS_GERROR, DBUS_GERROR_INVALID_SIGNATURE, "Invalid signature, expected \"%s\", got \"%s\"", "ao", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return NULL;
	}
	dbus_message_iter_init (_reply, &_iter);
	_result_length1 = 0;
	_tmp44_ = g_new (char*, 5);
	_tmp44__length = 0;
	_tmp44__size = 4;
	_tmp44__length1 = 0;
	dbus_message_iter_recurse (&_iter, &_tmp45_);
	for (; dbus_message_iter_get_arg_type (&_tmp45_); _tmp44__length1++) {
		const char* _tmp46_;
		if (_tmp44__size == _tmp44__length) {
			_tmp44__size = 2 * _tmp44__size;
			_tmp44_ = g_renew (char*, _tmp44_, _tmp44__size + 1);
		}
		dbus_message_iter_get_basic (&_tmp45_, &_tmp46_);
		dbus_message_iter_next (&_tmp45_);
		_tmp44_[_tmp44__length++] = g_strdup (_tmp46_);
	}
	_result_length1 = _tmp44__length1;
	_tmp44_[_tmp44__length] = NULL;
	dbus_message_iter_next (&_iter);
	_result = _tmp44_;
	*result_length1 = _result_length1;
	dbus_message_unref (_reply);
	return _result;
}


static char** dock_manager_dbus_interface_dbus_proxy_get_items_by_desktop_file (DockManagerDBusInterface* self, const char* desktop_file, int* result_length1, GError** error) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	const char* _tmp48_;
	char** _result;
	int _result_length1;
	char** _tmp49_;
	int _tmp49__length;
	int _tmp49__size;
	int _tmp49__length1;
	DBusMessageIter _tmp50_;
	if (((DockManagerDBusInterfaceDBusProxy*) self)->disposed) {
		g_set_error (error, DBUS_GERROR, DBUS_GERROR_DISCONNECTED, "%s", "Connection is closed");
		return NULL;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.freedesktop.DockManager", "GetItemsByDesktopFile");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp48_ = desktop_file;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp48_);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		GQuark _edomain;
		gint _ecode;
		if (strstr (_dbus_error.name, "org.freedesktop.DBus.Error") == _dbus_error.name) {
			const char* _tmp52_;
			_edomain = DBUS_GERROR;
			_tmp52_ = _dbus_error.name + 27;
			if (strcmp (_tmp52_, "Failed") == 0) {
				_ecode = DBUS_GERROR_FAILED;
			} else if (strcmp (_tmp52_, "NoMemory") == 0) {
				_ecode = DBUS_GERROR_NO_MEMORY;
			} else if (strcmp (_tmp52_, "ServiceUnknown") == 0) {
				_ecode = DBUS_GERROR_SERVICE_UNKNOWN;
			} else if (strcmp (_tmp52_, "NameHasNoOwner") == 0) {
				_ecode = DBUS_GERROR_NAME_HAS_NO_OWNER;
			} else if (strcmp (_tmp52_, "NoReply") == 0) {
				_ecode = DBUS_GERROR_NO_REPLY;
			} else if (strcmp (_tmp52_, "IOError") == 0) {
				_ecode = DBUS_GERROR_IO_ERROR;
			} else if (strcmp (_tmp52_, "BadAddress") == 0) {
				_ecode = DBUS_GERROR_BAD_ADDRESS;
			} else if (strcmp (_tmp52_, "NotSupported") == 0) {
				_ecode = DBUS_GERROR_NOT_SUPPORTED;
			} else if (strcmp (_tmp52_, "LimitsExceeded") == 0) {
				_ecode = DBUS_GERROR_LIMITS_EXCEEDED;
			} else if (strcmp (_tmp52_, "AccessDenied") == 0) {
				_ecode = DBUS_GERROR_ACCESS_DENIED;
			} else if (strcmp (_tmp52_, "AuthFailed") == 0) {
				_ecode = DBUS_GERROR_AUTH_FAILED;
			} else if (strcmp (_tmp52_, "NoServer") == 0) {
				_ecode = DBUS_GERROR_NO_SERVER;
			} else if (strcmp (_tmp52_, "Timeout") == 0) {
				_ecode = DBUS_GERROR_TIMEOUT;
			} else if (strcmp (_tmp52_, "NoNetwork") == 0) {
				_ecode = DBUS_GERROR_NO_NETWORK;
			} else if (strcmp (_tmp52_, "AddressInUse") == 0) {
				_ecode = DBUS_GERROR_ADDRESS_IN_USE;
			} else if (strcmp (_tmp52_, "Disconnected") == 0) {
				_ecode = DBUS_GERROR_DISCONNECTED;
			} else if (strcmp (_tmp52_, "InvalidArgs") == 0) {
				_ecode = DBUS_GERROR_INVALID_ARGS;
			} else if (strcmp (_tmp52_, "FileNotFound") == 0) {
				_ecode = DBUS_GERROR_FILE_NOT_FOUND;
			} else if (strcmp (_tmp52_, "FileExists") == 0) {
				_ecode = DBUS_GERROR_FILE_EXISTS;
			} else if (strcmp (_tmp52_, "UnknownMethod") == 0) {
				_ecode = DBUS_GERROR_UNKNOWN_METHOD;
			} else if (strcmp (_tmp52_, "TimedOut") == 0) {
				_ecode = DBUS_GERROR_TIMED_OUT;
			} else if (strcmp (_tmp52_, "MatchRuleNotFound") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_NOT_FOUND;
			} else if (strcmp (_tmp52_, "MatchRuleInvalid") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_INVALID;
			} else if (strcmp (_tmp52_, "Spawn.ExecFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_EXEC_FAILED;
			} else if (strcmp (_tmp52_, "Spawn.ForkFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FORK_FAILED;
			} else if (strcmp (_tmp52_, "Spawn.ChildExited") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_EXITED;
			} else if (strcmp (_tmp52_, "Spawn.ChildSignaled") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_SIGNALED;
			} else if (strcmp (_tmp52_, "Spawn.Failed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FAILED;
			} else if (strcmp (_tmp52_, "UnixProcessIdUnknown") == 0) {
				_ecode = DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN;
			} else if (strcmp (_tmp52_, "InvalidSignature") == 0) {
				_ecode = DBUS_GERROR_INVALID_SIGNATURE;
			} else if (strcmp (_tmp52_, "InvalidFileContent") == 0) {
				_ecode = DBUS_GERROR_INVALID_FILE_CONTENT;
			} else if (strcmp (_tmp52_, "SELinuxSecurityContextUnknown") == 0) {
				_ecode = DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN;
			} else if (strcmp (_tmp52_, "RemoteException") == 0) {
				_ecode = DBUS_GERROR_REMOTE_EXCEPTION;
			}
		}
		g_set_error (error, _edomain, _ecode, "%s", _dbus_error.message);
		dbus_error_free (&_dbus_error);
		return NULL;
	}
	if (strcmp (dbus_message_get_signature (_reply), "ao")) {
		g_set_error (error, DBUS_GERROR, DBUS_GERROR_INVALID_SIGNATURE, "Invalid signature, expected \"%s\", got \"%s\"", "ao", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return NULL;
	}
	dbus_message_iter_init (_reply, &_iter);
	_result_length1 = 0;
	_tmp49_ = g_new (char*, 5);
	_tmp49__length = 0;
	_tmp49__size = 4;
	_tmp49__length1 = 0;
	dbus_message_iter_recurse (&_iter, &_tmp50_);
	for (; dbus_message_iter_get_arg_type (&_tmp50_); _tmp49__length1++) {
		const char* _tmp51_;
		if (_tmp49__size == _tmp49__length) {
			_tmp49__size = 2 * _tmp49__size;
			_tmp49_ = g_renew (char*, _tmp49_, _tmp49__size + 1);
		}
		dbus_message_iter_get_basic (&_tmp50_, &_tmp51_);
		dbus_message_iter_next (&_tmp50_);
		_tmp49_[_tmp49__length++] = g_strdup (_tmp51_);
	}
	_result_length1 = _tmp49__length1;
	_tmp49_[_tmp49__length] = NULL;
	dbus_message_iter_next (&_iter);
	_result = _tmp49_;
	*result_length1 = _result_length1;
	dbus_message_unref (_reply);
	return _result;
}


static char** dock_manager_dbus_interface_dbus_proxy_get_items_by_pid (DockManagerDBusInterface* self, gint pid, int* result_length1, GError** error) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	dbus_int32_t _tmp53_;
	char** _result;
	int _result_length1;
	char** _tmp54_;
	int _tmp54__length;
	int _tmp54__size;
	int _tmp54__length1;
	DBusMessageIter _tmp55_;
	if (((DockManagerDBusInterfaceDBusProxy*) self)->disposed) {
		g_set_error (error, DBUS_GERROR, DBUS_GERROR_DISCONNECTED, "%s", "Connection is closed");
		return NULL;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.freedesktop.DockManager", "GetItemsByPid");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp53_ = pid;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_INT32, &_tmp53_);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		GQuark _edomain;
		gint _ecode;
		if (strstr (_dbus_error.name, "org.freedesktop.DBus.Error") == _dbus_error.name) {
			const char* _tmp57_;
			_edomain = DBUS_GERROR;
			_tmp57_ = _dbus_error.name + 27;
			if (strcmp (_tmp57_, "Failed") == 0) {
				_ecode = DBUS_GERROR_FAILED;
			} else if (strcmp (_tmp57_, "NoMemory") == 0) {
				_ecode = DBUS_GERROR_NO_MEMORY;
			} else if (strcmp (_tmp57_, "ServiceUnknown") == 0) {
				_ecode = DBUS_GERROR_SERVICE_UNKNOWN;
			} else if (strcmp (_tmp57_, "NameHasNoOwner") == 0) {
				_ecode = DBUS_GERROR_NAME_HAS_NO_OWNER;
			} else if (strcmp (_tmp57_, "NoReply") == 0) {
				_ecode = DBUS_GERROR_NO_REPLY;
			} else if (strcmp (_tmp57_, "IOError") == 0) {
				_ecode = DBUS_GERROR_IO_ERROR;
			} else if (strcmp (_tmp57_, "BadAddress") == 0) {
				_ecode = DBUS_GERROR_BAD_ADDRESS;
			} else if (strcmp (_tmp57_, "NotSupported") == 0) {
				_ecode = DBUS_GERROR_NOT_SUPPORTED;
			} else if (strcmp (_tmp57_, "LimitsExceeded") == 0) {
				_ecode = DBUS_GERROR_LIMITS_EXCEEDED;
			} else if (strcmp (_tmp57_, "AccessDenied") == 0) {
				_ecode = DBUS_GERROR_ACCESS_DENIED;
			} else if (strcmp (_tmp57_, "AuthFailed") == 0) {
				_ecode = DBUS_GERROR_AUTH_FAILED;
			} else if (strcmp (_tmp57_, "NoServer") == 0) {
				_ecode = DBUS_GERROR_NO_SERVER;
			} else if (strcmp (_tmp57_, "Timeout") == 0) {
				_ecode = DBUS_GERROR_TIMEOUT;
			} else if (strcmp (_tmp57_, "NoNetwork") == 0) {
				_ecode = DBUS_GERROR_NO_NETWORK;
			} else if (strcmp (_tmp57_, "AddressInUse") == 0) {
				_ecode = DBUS_GERROR_ADDRESS_IN_USE;
			} else if (strcmp (_tmp57_, "Disconnected") == 0) {
				_ecode = DBUS_GERROR_DISCONNECTED;
			} else if (strcmp (_tmp57_, "InvalidArgs") == 0) {
				_ecode = DBUS_GERROR_INVALID_ARGS;
			} else if (strcmp (_tmp57_, "FileNotFound") == 0) {
				_ecode = DBUS_GERROR_FILE_NOT_FOUND;
			} else if (strcmp (_tmp57_, "FileExists") == 0) {
				_ecode = DBUS_GERROR_FILE_EXISTS;
			} else if (strcmp (_tmp57_, "UnknownMethod") == 0) {
				_ecode = DBUS_GERROR_UNKNOWN_METHOD;
			} else if (strcmp (_tmp57_, "TimedOut") == 0) {
				_ecode = DBUS_GERROR_TIMED_OUT;
			} else if (strcmp (_tmp57_, "MatchRuleNotFound") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_NOT_FOUND;
			} else if (strcmp (_tmp57_, "MatchRuleInvalid") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_INVALID;
			} else if (strcmp (_tmp57_, "Spawn.ExecFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_EXEC_FAILED;
			} else if (strcmp (_tmp57_, "Spawn.ForkFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FORK_FAILED;
			} else if (strcmp (_tmp57_, "Spawn.ChildExited") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_EXITED;
			} else if (strcmp (_tmp57_, "Spawn.ChildSignaled") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_SIGNALED;
			} else if (strcmp (_tmp57_, "Spawn.Failed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FAILED;
			} else if (strcmp (_tmp57_, "UnixProcessIdUnknown") == 0) {
				_ecode = DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN;
			} else if (strcmp (_tmp57_, "InvalidSignature") == 0) {
				_ecode = DBUS_GERROR_INVALID_SIGNATURE;
			} else if (strcmp (_tmp57_, "InvalidFileContent") == 0) {
				_ecode = DBUS_GERROR_INVALID_FILE_CONTENT;
			} else if (strcmp (_tmp57_, "SELinuxSecurityContextUnknown") == 0) {
				_ecode = DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN;
			} else if (strcmp (_tmp57_, "RemoteException") == 0) {
				_ecode = DBUS_GERROR_REMOTE_EXCEPTION;
			}
		}
		g_set_error (error, _edomain, _ecode, "%s", _dbus_error.message);
		dbus_error_free (&_dbus_error);
		return NULL;
	}
	if (strcmp (dbus_message_get_signature (_reply), "ao")) {
		g_set_error (error, DBUS_GERROR, DBUS_GERROR_INVALID_SIGNATURE, "Invalid signature, expected \"%s\", got \"%s\"", "ao", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return NULL;
	}
	dbus_message_iter_init (_reply, &_iter);
	_result_length1 = 0;
	_tmp54_ = g_new (char*, 5);
	_tmp54__length = 0;
	_tmp54__size = 4;
	_tmp54__length1 = 0;
	dbus_message_iter_recurse (&_iter, &_tmp55_);
	for (; dbus_message_iter_get_arg_type (&_tmp55_); _tmp54__length1++) {
		const char* _tmp56_;
		if (_tmp54__size == _tmp54__length) {
			_tmp54__size = 2 * _tmp54__size;
			_tmp54_ = g_renew (char*, _tmp54_, _tmp54__size + 1);
		}
		dbus_message_iter_get_basic (&_tmp55_, &_tmp56_);
		dbus_message_iter_next (&_tmp55_);
		_tmp54_[_tmp54__length++] = g_strdup (_tmp56_);
	}
	_result_length1 = _tmp54__length1;
	_tmp54_[_tmp54__length] = NULL;
	dbus_message_iter_next (&_iter);
	_result = _tmp54_;
	*result_length1 = _result_length1;
	dbus_message_unref (_reply);
	return _result;
}


static char* dock_manager_dbus_interface_dbus_proxy_get_item_by_xid (DockManagerDBusInterface* self, gint64 xid, GError** error) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	dbus_int64_t _tmp58_;
	char* _result;
	const char* _tmp59_;
	if (((DockManagerDBusInterfaceDBusProxy*) self)->disposed) {
		g_set_error (error, DBUS_GERROR, DBUS_GERROR_DISCONNECTED, "%s", "Connection is closed");
		return NULL;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.freedesktop.DockManager", "GetItemByXid");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp58_ = xid;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_INT64, &_tmp58_);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		GQuark _edomain;
		gint _ecode;
		if (strstr (_dbus_error.name, "org.freedesktop.DBus.Error") == _dbus_error.name) {
			const char* _tmp60_;
			_edomain = DBUS_GERROR;
			_tmp60_ = _dbus_error.name + 27;
			if (strcmp (_tmp60_, "Failed") == 0) {
				_ecode = DBUS_GERROR_FAILED;
			} else if (strcmp (_tmp60_, "NoMemory") == 0) {
				_ecode = DBUS_GERROR_NO_MEMORY;
			} else if (strcmp (_tmp60_, "ServiceUnknown") == 0) {
				_ecode = DBUS_GERROR_SERVICE_UNKNOWN;
			} else if (strcmp (_tmp60_, "NameHasNoOwner") == 0) {
				_ecode = DBUS_GERROR_NAME_HAS_NO_OWNER;
			} else if (strcmp (_tmp60_, "NoReply") == 0) {
				_ecode = DBUS_GERROR_NO_REPLY;
			} else if (strcmp (_tmp60_, "IOError") == 0) {
				_ecode = DBUS_GERROR_IO_ERROR;
			} else if (strcmp (_tmp60_, "BadAddress") == 0) {
				_ecode = DBUS_GERROR_BAD_ADDRESS;
			} else if (strcmp (_tmp60_, "NotSupported") == 0) {
				_ecode = DBUS_GERROR_NOT_SUPPORTED;
			} else if (strcmp (_tmp60_, "LimitsExceeded") == 0) {
				_ecode = DBUS_GERROR_LIMITS_EXCEEDED;
			} else if (strcmp (_tmp60_, "AccessDenied") == 0) {
				_ecode = DBUS_GERROR_ACCESS_DENIED;
			} else if (strcmp (_tmp60_, "AuthFailed") == 0) {
				_ecode = DBUS_GERROR_AUTH_FAILED;
			} else if (strcmp (_tmp60_, "NoServer") == 0) {
				_ecode = DBUS_GERROR_NO_SERVER;
			} else if (strcmp (_tmp60_, "Timeout") == 0) {
				_ecode = DBUS_GERROR_TIMEOUT;
			} else if (strcmp (_tmp60_, "NoNetwork") == 0) {
				_ecode = DBUS_GERROR_NO_NETWORK;
			} else if (strcmp (_tmp60_, "AddressInUse") == 0) {
				_ecode = DBUS_GERROR_ADDRESS_IN_USE;
			} else if (strcmp (_tmp60_, "Disconnected") == 0) {
				_ecode = DBUS_GERROR_DISCONNECTED;
			} else if (strcmp (_tmp60_, "InvalidArgs") == 0) {
				_ecode = DBUS_GERROR_INVALID_ARGS;
			} else if (strcmp (_tmp60_, "FileNotFound") == 0) {
				_ecode = DBUS_GERROR_FILE_NOT_FOUND;
			} else if (strcmp (_tmp60_, "FileExists") == 0) {
				_ecode = DBUS_GERROR_FILE_EXISTS;
			} else if (strcmp (_tmp60_, "UnknownMethod") == 0) {
				_ecode = DBUS_GERROR_UNKNOWN_METHOD;
			} else if (strcmp (_tmp60_, "TimedOut") == 0) {
				_ecode = DBUS_GERROR_TIMED_OUT;
			} else if (strcmp (_tmp60_, "MatchRuleNotFound") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_NOT_FOUND;
			} else if (strcmp (_tmp60_, "MatchRuleInvalid") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_INVALID;
			} else if (strcmp (_tmp60_, "Spawn.ExecFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_EXEC_FAILED;
			} else if (strcmp (_tmp60_, "Spawn.ForkFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FORK_FAILED;
			} else if (strcmp (_tmp60_, "Spawn.ChildExited") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_EXITED;
			} else if (strcmp (_tmp60_, "Spawn.ChildSignaled") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_SIGNALED;
			} else if (strcmp (_tmp60_, "Spawn.Failed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FAILED;
			} else if (strcmp (_tmp60_, "UnixProcessIdUnknown") == 0) {
				_ecode = DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN;
			} else if (strcmp (_tmp60_, "InvalidSignature") == 0) {
				_ecode = DBUS_GERROR_INVALID_SIGNATURE;
			} else if (strcmp (_tmp60_, "InvalidFileContent") == 0) {
				_ecode = DBUS_GERROR_INVALID_FILE_CONTENT;
			} else if (strcmp (_tmp60_, "SELinuxSecurityContextUnknown") == 0) {
				_ecode = DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN;
			} else if (strcmp (_tmp60_, "RemoteException") == 0) {
				_ecode = DBUS_GERROR_REMOTE_EXCEPTION;
			}
		}
		g_set_error (error, _edomain, _ecode, "%s", _dbus_error.message);
		dbus_error_free (&_dbus_error);
		return NULL;
	}
	if (strcmp (dbus_message_get_signature (_reply), "o")) {
		g_set_error (error, DBUS_GERROR, DBUS_GERROR_INVALID_SIGNATURE, "Invalid signature, expected \"%s\", got \"%s\"", "o", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return NULL;
	}
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_get_basic (&_iter, &_tmp59_);
	dbus_message_iter_next (&_iter);
	_result = g_strdup (_tmp59_);
	dbus_message_unref (_reply);
	return _result;
}


static void dock_manager_dbus_interface_dbus_proxy_awn_set_visibility (DockManagerDBusInterface* self, const char* win_name, gboolean visible, GError** error) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	const char* _tmp61_;
	dbus_bool_t _tmp62_;
	if (((DockManagerDBusInterfaceDBusProxy*) self)->disposed) {
		g_set_error (error, DBUS_GERROR, DBUS_GERROR_DISCONNECTED, "%s", "Connection is closed");
		return;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.freedesktop.DockManager", "AwnSetVisibility");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp61_ = win_name;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp61_);
	_tmp62_ = visible;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_BOOLEAN, &_tmp62_);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		GQuark _edomain;
		gint _ecode;
		if (strstr (_dbus_error.name, "org.freedesktop.DBus.Error") == _dbus_error.name) {
			const char* _tmp63_;
			_edomain = DBUS_GERROR;
			_tmp63_ = _dbus_error.name + 27;
			if (strcmp (_tmp63_, "Failed") == 0) {
				_ecode = DBUS_GERROR_FAILED;
			} else if (strcmp (_tmp63_, "NoMemory") == 0) {
				_ecode = DBUS_GERROR_NO_MEMORY;
			} else if (strcmp (_tmp63_, "ServiceUnknown") == 0) {
				_ecode = DBUS_GERROR_SERVICE_UNKNOWN;
			} else if (strcmp (_tmp63_, "NameHasNoOwner") == 0) {
				_ecode = DBUS_GERROR_NAME_HAS_NO_OWNER;
			} else if (strcmp (_tmp63_, "NoReply") == 0) {
				_ecode = DBUS_GERROR_NO_REPLY;
			} else if (strcmp (_tmp63_, "IOError") == 0) {
				_ecode = DBUS_GERROR_IO_ERROR;
			} else if (strcmp (_tmp63_, "BadAddress") == 0) {
				_ecode = DBUS_GERROR_BAD_ADDRESS;
			} else if (strcmp (_tmp63_, "NotSupported") == 0) {
				_ecode = DBUS_GERROR_NOT_SUPPORTED;
			} else if (strcmp (_tmp63_, "LimitsExceeded") == 0) {
				_ecode = DBUS_GERROR_LIMITS_EXCEEDED;
			} else if (strcmp (_tmp63_, "AccessDenied") == 0) {
				_ecode = DBUS_GERROR_ACCESS_DENIED;
			} else if (strcmp (_tmp63_, "AuthFailed") == 0) {
				_ecode = DBUS_GERROR_AUTH_FAILED;
			} else if (strcmp (_tmp63_, "NoServer") == 0) {
				_ecode = DBUS_GERROR_NO_SERVER;
			} else if (strcmp (_tmp63_, "Timeout") == 0) {
				_ecode = DBUS_GERROR_TIMEOUT;
			} else if (strcmp (_tmp63_, "NoNetwork") == 0) {
				_ecode = DBUS_GERROR_NO_NETWORK;
			} else if (strcmp (_tmp63_, "AddressInUse") == 0) {
				_ecode = DBUS_GERROR_ADDRESS_IN_USE;
			} else if (strcmp (_tmp63_, "Disconnected") == 0) {
				_ecode = DBUS_GERROR_DISCONNECTED;
			} else if (strcmp (_tmp63_, "InvalidArgs") == 0) {
				_ecode = DBUS_GERROR_INVALID_ARGS;
			} else if (strcmp (_tmp63_, "FileNotFound") == 0) {
				_ecode = DBUS_GERROR_FILE_NOT_FOUND;
			} else if (strcmp (_tmp63_, "FileExists") == 0) {
				_ecode = DBUS_GERROR_FILE_EXISTS;
			} else if (strcmp (_tmp63_, "UnknownMethod") == 0) {
				_ecode = DBUS_GERROR_UNKNOWN_METHOD;
			} else if (strcmp (_tmp63_, "TimedOut") == 0) {
				_ecode = DBUS_GERROR_TIMED_OUT;
			} else if (strcmp (_tmp63_, "MatchRuleNotFound") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_NOT_FOUND;
			} else if (strcmp (_tmp63_, "MatchRuleInvalid") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_INVALID;
			} else if (strcmp (_tmp63_, "Spawn.ExecFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_EXEC_FAILED;
			} else if (strcmp (_tmp63_, "Spawn.ForkFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FORK_FAILED;
			} else if (strcmp (_tmp63_, "Spawn.ChildExited") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_EXITED;
			} else if (strcmp (_tmp63_, "Spawn.ChildSignaled") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_SIGNALED;
			} else if (strcmp (_tmp63_, "Spawn.Failed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FAILED;
			} else if (strcmp (_tmp63_, "UnixProcessIdUnknown") == 0) {
				_ecode = DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN;
			} else if (strcmp (_tmp63_, "InvalidSignature") == 0) {
				_ecode = DBUS_GERROR_INVALID_SIGNATURE;
			} else if (strcmp (_tmp63_, "InvalidFileContent") == 0) {
				_ecode = DBUS_GERROR_INVALID_FILE_CONTENT;
			} else if (strcmp (_tmp63_, "SELinuxSecurityContextUnknown") == 0) {
				_ecode = DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN;
			} else if (strcmp (_tmp63_, "RemoteException") == 0) {
				_ecode = DBUS_GERROR_REMOTE_EXCEPTION;
			}
		}
		g_set_error (error, _edomain, _ecode, "%s", _dbus_error.message);
		dbus_error_free (&_dbus_error);
		return;
	}
	if (strcmp (dbus_message_get_signature (_reply), "")) {
		g_set_error (error, DBUS_GERROR, DBUS_GERROR_INVALID_SIGNATURE, "Invalid signature, expected \"%s\", got \"%s\"", "", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return;
	}
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_unref (_reply);
}


static char* dock_manager_dbus_interface_dbus_proxy_awn_register_proxy_item (DockManagerDBusInterface* self, const char* desktop_file, const char* uri, GError** error) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	const char* _tmp64_;
	const char* _tmp65_;
	char* _result;
	const char* _tmp66_;
	if (((DockManagerDBusInterfaceDBusProxy*) self)->disposed) {
		g_set_error (error, DBUS_GERROR, DBUS_GERROR_DISCONNECTED, "%s", "Connection is closed");
		return NULL;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.freedesktop.DockManager", "AwnRegisterProxyItem");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp64_ = desktop_file;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp64_);
	_tmp65_ = uri;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp65_);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		GQuark _edomain;
		gint _ecode;
		if (strstr (_dbus_error.name, "org.freedesktop.DBus.Error") == _dbus_error.name) {
			const char* _tmp67_;
			_edomain = DBUS_GERROR;
			_tmp67_ = _dbus_error.name + 27;
			if (strcmp (_tmp67_, "Failed") == 0) {
				_ecode = DBUS_GERROR_FAILED;
			} else if (strcmp (_tmp67_, "NoMemory") == 0) {
				_ecode = DBUS_GERROR_NO_MEMORY;
			} else if (strcmp (_tmp67_, "ServiceUnknown") == 0) {
				_ecode = DBUS_GERROR_SERVICE_UNKNOWN;
			} else if (strcmp (_tmp67_, "NameHasNoOwner") == 0) {
				_ecode = DBUS_GERROR_NAME_HAS_NO_OWNER;
			} else if (strcmp (_tmp67_, "NoReply") == 0) {
				_ecode = DBUS_GERROR_NO_REPLY;
			} else if (strcmp (_tmp67_, "IOError") == 0) {
				_ecode = DBUS_GERROR_IO_ERROR;
			} else if (strcmp (_tmp67_, "BadAddress") == 0) {
				_ecode = DBUS_GERROR_BAD_ADDRESS;
			} else if (strcmp (_tmp67_, "NotSupported") == 0) {
				_ecode = DBUS_GERROR_NOT_SUPPORTED;
			} else if (strcmp (_tmp67_, "LimitsExceeded") == 0) {
				_ecode = DBUS_GERROR_LIMITS_EXCEEDED;
			} else if (strcmp (_tmp67_, "AccessDenied") == 0) {
				_ecode = DBUS_GERROR_ACCESS_DENIED;
			} else if (strcmp (_tmp67_, "AuthFailed") == 0) {
				_ecode = DBUS_GERROR_AUTH_FAILED;
			} else if (strcmp (_tmp67_, "NoServer") == 0) {
				_ecode = DBUS_GERROR_NO_SERVER;
			} else if (strcmp (_tmp67_, "Timeout") == 0) {
				_ecode = DBUS_GERROR_TIMEOUT;
			} else if (strcmp (_tmp67_, "NoNetwork") == 0) {
				_ecode = DBUS_GERROR_NO_NETWORK;
			} else if (strcmp (_tmp67_, "AddressInUse") == 0) {
				_ecode = DBUS_GERROR_ADDRESS_IN_USE;
			} else if (strcmp (_tmp67_, "Disconnected") == 0) {
				_ecode = DBUS_GERROR_DISCONNECTED;
			} else if (strcmp (_tmp67_, "InvalidArgs") == 0) {
				_ecode = DBUS_GERROR_INVALID_ARGS;
			} else if (strcmp (_tmp67_, "FileNotFound") == 0) {
				_ecode = DBUS_GERROR_FILE_NOT_FOUND;
			} else if (strcmp (_tmp67_, "FileExists") == 0) {
				_ecode = DBUS_GERROR_FILE_EXISTS;
			} else if (strcmp (_tmp67_, "UnknownMethod") == 0) {
				_ecode = DBUS_GERROR_UNKNOWN_METHOD;
			} else if (strcmp (_tmp67_, "TimedOut") == 0) {
				_ecode = DBUS_GERROR_TIMED_OUT;
			} else if (strcmp (_tmp67_, "MatchRuleNotFound") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_NOT_FOUND;
			} else if (strcmp (_tmp67_, "MatchRuleInvalid") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_INVALID;
			} else if (strcmp (_tmp67_, "Spawn.ExecFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_EXEC_FAILED;
			} else if (strcmp (_tmp67_, "Spawn.ForkFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FORK_FAILED;
			} else if (strcmp (_tmp67_, "Spawn.ChildExited") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_EXITED;
			} else if (strcmp (_tmp67_, "Spawn.ChildSignaled") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_SIGNALED;
			} else if (strcmp (_tmp67_, "Spawn.Failed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FAILED;
			} else if (strcmp (_tmp67_, "UnixProcessIdUnknown") == 0) {
				_ecode = DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN;
			} else if (strcmp (_tmp67_, "InvalidSignature") == 0) {
				_ecode = DBUS_GERROR_INVALID_SIGNATURE;
			} else if (strcmp (_tmp67_, "InvalidFileContent") == 0) {
				_ecode = DBUS_GERROR_INVALID_FILE_CONTENT;
			} else if (strcmp (_tmp67_, "SELinuxSecurityContextUnknown") == 0) {
				_ecode = DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN;
			} else if (strcmp (_tmp67_, "RemoteException") == 0) {
				_ecode = DBUS_GERROR_REMOTE_EXCEPTION;
			}
		}
		g_set_error (error, _edomain, _ecode, "%s", _dbus_error.message);
		dbus_error_free (&_dbus_error);
		return NULL;
	}
	if (strcmp (dbus_message_get_signature (_reply), "o")) {
		g_set_error (error, DBUS_GERROR, DBUS_GERROR_INVALID_SIGNATURE, "Invalid signature, expected \"%s\", got \"%s\"", "o", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return NULL;
	}
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_get_basic (&_iter, &_tmp66_);
	dbus_message_iter_next (&_iter);
	_result = g_strdup (_tmp66_);
	dbus_message_unref (_reply);
	return _result;
}


static void dock_manager_dbus_interface_dbus_proxy_dock_manager_dbus_interface__interface_init (DockManagerDBusInterfaceIface* iface) {
	iface->get_capabilities = dock_manager_dbus_interface_dbus_proxy_get_capabilities;
	iface->get_items = dock_manager_dbus_interface_dbus_proxy_get_items;
	iface->get_items_by_name = dock_manager_dbus_interface_dbus_proxy_get_items_by_name;
	iface->get_items_by_desktop_file = dock_manager_dbus_interface_dbus_proxy_get_items_by_desktop_file;
	iface->get_items_by_pid = dock_manager_dbus_interface_dbus_proxy_get_items_by_pid;
	iface->get_item_by_xid = dock_manager_dbus_interface_dbus_proxy_get_item_by_xid;
	iface->awn_set_visibility = dock_manager_dbus_interface_dbus_proxy_awn_set_visibility;
	iface->awn_register_proxy_item = dock_manager_dbus_interface_dbus_proxy_awn_register_proxy_item;
}


static void dock_manager_dbus_interface_dbus_proxy_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
}


static void dock_manager_dbus_interface_dbus_proxy_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
}


gint dock_item_dbus_interface_add_menu_item (DockItemDBusInterface* self, GHashTable* menu_hints, GError** error) {
	return DOCK_ITEM_DBUS_INTERFACE_GET_INTERFACE (self)->add_menu_item (self, menu_hints, error);
}


void dock_item_dbus_interface_remove_menu_item (DockItemDBusInterface* self, gint id, GError** error) {
	DOCK_ITEM_DBUS_INTERFACE_GET_INTERFACE (self)->remove_menu_item (self, id, error);
}


void dock_item_dbus_interface_update_dock_item (DockItemDBusInterface* self, GHashTable* hints, GError** error) {
	DOCK_ITEM_DBUS_INTERFACE_GET_INTERFACE (self)->update_dock_item (self, hints, error);
}


char* dock_item_dbus_interface_get_desktop_file (DockItemDBusInterface* self) {
	return DOCK_ITEM_DBUS_INTERFACE_GET_INTERFACE (self)->get_desktop_file (self);
}


char* dock_item_dbus_interface_get_uri (DockItemDBusInterface* self) {
	return DOCK_ITEM_DBUS_INTERFACE_GET_INTERFACE (self)->get_uri (self);
}


void _dock_item_dbus_interface_dbus_unregister (DBusConnection* connection, void* _user_data_) {
}


static DBusHandlerResult _dbus_dock_item_dbus_interface_introspect (DockItemDBusInterface* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessage* reply;
	DBusMessageIter iter;
	GString* xml_data;
	char** children;
	int i;
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	xml_data = g_string_new ("<!DOCTYPE node PUBLIC \"-//freedesktop//DTD D-BUS Object Introspection 1.0//EN\" \"http://www.freedesktop.org/standards/dbus/1.0/introspect.dtd\">\n");
	g_string_append (xml_data, "<node>\n<interface name=\"org.freedesktop.DBus.Introspectable\">\n  <method name=\"Introspect\">\n    <arg name=\"data\" direction=\"out\" type=\"s\"/>\n  </method>\n</interface>\n<interface name=\"org.freedesktop.DBus.Properties\">\n  <method name=\"Get\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"propname\" direction=\"in\" type=\"s\"/>\n    <arg name=\"value\" direction=\"out\" type=\"v\"/>\n  </method>\n  <method name=\"Set\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"propname\" direction=\"in\" type=\"s\"/>\n    <arg name=\"value\" direction=\"in\" type=\"v\"/>\n  </method>\n  <method name=\"GetAll\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"props\" direction=\"out\" type=\"a{sv}\"/>\n  </method>\n</interface>\n<interface name=\"org.freedesktop.DockItem\">\n  <method name=\"AddMenuItem\">\n    <arg name=\"menu_hints\" type=\"a{sv}\" direction=\"in\"/>\n    <arg name=\"result\" type=\"i\" direction=\"out\"/>\n  </method>\n  <method name=\"RemoveMenuItem\">\n    <arg name=\"id\" type=\"i\" direction=\"in\"/>\n  </method>\n  <method name=\"UpdateDockItem\">\n    <arg name=\"hints\" type=\"a{sv}\" direction=\"in\"/>\n  </method>\n  <property name=\"DesktopFile\" type=\"s\" access=\"read\"/>\n  <property name=\"Uri\" type=\"s\" access=\"read\"/>\n  <signal name=\"MenuItemActivated\">\n    <arg name=\"id\" type=\"i\"/>\n  </signal>\n</interface>\n");
	dbus_connection_list_registered (connection, g_object_get_data ((GObject *) self, "dbus_object_path"), &children);
	for (i = 0; children[i]; i++) {
		g_string_append_printf (xml_data, "<node name=\"%s\"/>\n", children[i]);
	}
	dbus_free_string_array (children);
	g_string_append (xml_data, "</node>\n");
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_STRING, &xml_data->str);
	g_string_free (xml_data, TRUE);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static DBusHandlerResult _dbus_dock_item_dbus_interface_property_get (DockItemDBusInterface* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessage* reply;
	DBusMessageIter iter, reply_iter, subiter;
	char* interface_name;
	const char* _tmp68_;
	char* property_name;
	const char* _tmp69_;
	if (strcmp (dbus_message_get_signature (message), "ss")) {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
	dbus_message_iter_init (message, &iter);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &reply_iter);
	dbus_message_iter_get_basic (&iter, &_tmp68_);
	dbus_message_iter_next (&iter);
	interface_name = g_strdup (_tmp68_);
	dbus_message_iter_get_basic (&iter, &_tmp69_);
	dbus_message_iter_next (&iter);
	property_name = g_strdup (_tmp69_);
	if ((strcmp (interface_name, "org.freedesktop.DockItem") == 0) && (strcmp (property_name, "DesktopFile") == 0)) {
		char* result;
		const char* _tmp70_;
		dbus_message_iter_open_container (&reply_iter, DBUS_TYPE_VARIANT, "s", &subiter);
		result = dock_item_dbus_interface_get_desktop_file (self);
		_tmp70_ = result;
		dbus_message_iter_append_basic (&subiter, DBUS_TYPE_STRING, &_tmp70_);
		_g_free0 (result);
		dbus_message_iter_close_container (&reply_iter, &subiter);
	} else if ((strcmp (interface_name, "org.freedesktop.DockItem") == 0) && (strcmp (property_name, "Uri") == 0)) {
		char* result;
		const char* _tmp71_;
		dbus_message_iter_open_container (&reply_iter, DBUS_TYPE_VARIANT, "s", &subiter);
		result = dock_item_dbus_interface_get_uri (self);
		_tmp71_ = result;
		dbus_message_iter_append_basic (&subiter, DBUS_TYPE_STRING, &_tmp71_);
		_g_free0 (result);
		dbus_message_iter_close_container (&reply_iter, &subiter);
	} else {
		dbus_message_unref (reply);
		reply = NULL;
	}
	g_free (interface_name);
	g_free (property_name);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static DBusHandlerResult _dbus_dock_item_dbus_interface_property_get_all (DockItemDBusInterface* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessage* reply;
	DBusMessageIter iter, reply_iter, subiter, entry_iter, value_iter;
	char* interface_name;
	const char* _tmp72_;
	const char* property_name;
	if (strcmp (dbus_message_get_signature (message), "s")) {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
	dbus_message_iter_init (message, &iter);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &reply_iter);
	dbus_message_iter_get_basic (&iter, &_tmp72_);
	dbus_message_iter_next (&iter);
	interface_name = g_strdup (_tmp72_);
	if (strcmp (interface_name, "org.freedesktop.DockItem") == 0) {
		dbus_message_iter_open_container (&reply_iter, DBUS_TYPE_ARRAY, "{sv}", &subiter);
		{
			char* result;
			const char* _tmp73_;
			dbus_message_iter_open_container (&subiter, DBUS_TYPE_DICT_ENTRY, NULL, &entry_iter);
			property_name = "DesktopFile";
			dbus_message_iter_append_basic (&entry_iter, DBUS_TYPE_STRING, &property_name);
			dbus_message_iter_open_container (&entry_iter, DBUS_TYPE_VARIANT, "s", &value_iter);
			result = dock_item_dbus_interface_get_desktop_file (self);
			_tmp73_ = result;
			dbus_message_iter_append_basic (&value_iter, DBUS_TYPE_STRING, &_tmp73_);
			_g_free0 (result);
			dbus_message_iter_close_container (&entry_iter, &value_iter);
			dbus_message_iter_close_container (&subiter, &entry_iter);
		}
		{
			char* result;
			const char* _tmp74_;
			dbus_message_iter_open_container (&subiter, DBUS_TYPE_DICT_ENTRY, NULL, &entry_iter);
			property_name = "Uri";
			dbus_message_iter_append_basic (&entry_iter, DBUS_TYPE_STRING, &property_name);
			dbus_message_iter_open_container (&entry_iter, DBUS_TYPE_VARIANT, "s", &value_iter);
			result = dock_item_dbus_interface_get_uri (self);
			_tmp74_ = result;
			dbus_message_iter_append_basic (&value_iter, DBUS_TYPE_STRING, &_tmp74_);
			_g_free0 (result);
			dbus_message_iter_close_container (&entry_iter, &value_iter);
			dbus_message_iter_close_container (&subiter, &entry_iter);
		}
		dbus_message_iter_close_container (&reply_iter, &subiter);
	} else {
		dbus_message_unref (reply);
		reply = NULL;
	}
	g_free (interface_name);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static DBusHandlerResult _dbus_dock_item_dbus_interface_add_menu_item (DockItemDBusInterface* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	GHashTable* menu_hints = NULL;
	GHashTable* _tmp75_;
	DBusMessageIter _tmp76_;
	DBusMessageIter _tmp77_;
	gint result;
	DBusMessage* reply;
	dbus_int32_t _tmp93_;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "a{sv}")) {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
	dbus_message_iter_init (message, &iter);
	_tmp75_ = g_hash_table_new_full (g_str_hash, g_str_equal, g_free, NULL);
	dbus_message_iter_recurse (&iter, &_tmp76_);
	while (dbus_message_iter_get_arg_type (&_tmp76_)) {
		char* _key;
		GValue* _value;
		const char* _tmp78_;
		GValue _tmp79_ = {0};
		DBusMessageIter _tmp80_;
		dbus_message_iter_recurse (&_tmp76_, &_tmp77_);
		dbus_message_iter_get_basic (&_tmp77_, &_tmp78_);
		dbus_message_iter_next (&_tmp77_);
		_key = g_strdup (_tmp78_);
		dbus_message_iter_recurse (&_tmp77_, &_tmp80_);
		if (dbus_message_iter_get_arg_type (&_tmp80_) == DBUS_TYPE_BYTE) {
			guint8 _tmp81_;
			dbus_message_iter_get_basic (&_tmp80_, &_tmp81_);
			g_value_init (&_tmp79_, G_TYPE_UCHAR);
			g_value_set_uchar (&_tmp79_, _tmp81_);
		} else if (dbus_message_iter_get_arg_type (&_tmp80_) == DBUS_TYPE_BOOLEAN) {
			dbus_bool_t _tmp82_;
			dbus_message_iter_get_basic (&_tmp80_, &_tmp82_);
			g_value_init (&_tmp79_, G_TYPE_BOOLEAN);
			g_value_set_boolean (&_tmp79_, _tmp82_);
		} else if (dbus_message_iter_get_arg_type (&_tmp80_) == DBUS_TYPE_INT16) {
			dbus_int16_t _tmp83_;
			dbus_message_iter_get_basic (&_tmp80_, &_tmp83_);
			g_value_init (&_tmp79_, G_TYPE_INT);
			g_value_set_int (&_tmp79_, _tmp83_);
		} else if (dbus_message_iter_get_arg_type (&_tmp80_) == DBUS_TYPE_UINT16) {
			dbus_uint16_t _tmp84_;
			dbus_message_iter_get_basic (&_tmp80_, &_tmp84_);
			g_value_init (&_tmp79_, G_TYPE_UINT);
			g_value_set_uint (&_tmp79_, _tmp84_);
		} else if (dbus_message_iter_get_arg_type (&_tmp80_) == DBUS_TYPE_INT32) {
			dbus_int32_t _tmp85_;
			dbus_message_iter_get_basic (&_tmp80_, &_tmp85_);
			g_value_init (&_tmp79_, G_TYPE_INT);
			g_value_set_int (&_tmp79_, _tmp85_);
		} else if (dbus_message_iter_get_arg_type (&_tmp80_) == DBUS_TYPE_UINT32) {
			dbus_uint32_t _tmp86_;
			dbus_message_iter_get_basic (&_tmp80_, &_tmp86_);
			g_value_init (&_tmp79_, G_TYPE_UINT);
			g_value_set_uint (&_tmp79_, _tmp86_);
		} else if (dbus_message_iter_get_arg_type (&_tmp80_) == DBUS_TYPE_INT64) {
			dbus_int64_t _tmp87_;
			dbus_message_iter_get_basic (&_tmp80_, &_tmp87_);
			g_value_init (&_tmp79_, G_TYPE_INT64);
			g_value_set_int64 (&_tmp79_, _tmp87_);
		} else if (dbus_message_iter_get_arg_type (&_tmp80_) == DBUS_TYPE_UINT64) {
			dbus_uint64_t _tmp88_;
			dbus_message_iter_get_basic (&_tmp80_, &_tmp88_);
			g_value_init (&_tmp79_, G_TYPE_UINT64);
			g_value_set_uint64 (&_tmp79_, _tmp88_);
		} else if (dbus_message_iter_get_arg_type (&_tmp80_) == DBUS_TYPE_DOUBLE) {
			double _tmp89_;
			dbus_message_iter_get_basic (&_tmp80_, &_tmp89_);
			g_value_init (&_tmp79_, G_TYPE_DOUBLE);
			g_value_set_double (&_tmp79_, _tmp89_);
		} else if (dbus_message_iter_get_arg_type (&_tmp80_) == DBUS_TYPE_STRING) {
			const char* _tmp90_;
			dbus_message_iter_get_basic (&_tmp80_, &_tmp90_);
			g_value_init (&_tmp79_, G_TYPE_STRING);
			g_value_take_string (&_tmp79_, g_strdup (_tmp90_));
		} else if (dbus_message_iter_get_arg_type (&_tmp80_) == DBUS_TYPE_OBJECT_PATH) {
			const char* _tmp91_;
			dbus_message_iter_get_basic (&_tmp80_, &_tmp91_);
			g_value_init (&_tmp79_, G_TYPE_STRING);
			g_value_take_string (&_tmp79_, g_strdup (_tmp91_));
		} else if (dbus_message_iter_get_arg_type (&_tmp80_) == DBUS_TYPE_SIGNATURE) {
			const char* _tmp92_;
			dbus_message_iter_get_basic (&_tmp80_, &_tmp92_);
			g_value_init (&_tmp79_, G_TYPE_STRING);
			g_value_take_string (&_tmp79_, g_strdup (_tmp92_));
		}
		dbus_message_iter_next (&_tmp77_);
		_value = g_memdup (&_tmp79_, sizeof (GValue));
		g_hash_table_insert (_tmp75_, _key, _value);
		dbus_message_iter_next (&_tmp76_);
	}
	dbus_message_iter_next (&iter);
	menu_hints = _tmp75_;
	result = dock_item_dbus_interface_add_menu_item (self, menu_hints, &error);
	if (error) {
		if (error->domain == DBUS_GERROR) {
			switch (error->code) {
				case DBUS_GERROR_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Failed", error->message);
				break;
				case DBUS_GERROR_NO_MEMORY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoMemory", error->message);
				break;
				case DBUS_GERROR_SERVICE_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.ServiceUnknown", error->message);
				break;
				case DBUS_GERROR_NAME_HAS_NO_OWNER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NameHasNoOwner", error->message);
				break;
				case DBUS_GERROR_NO_REPLY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoReply", error->message);
				break;
				case DBUS_GERROR_IO_ERROR:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.IOError", error->message);
				break;
				case DBUS_GERROR_BAD_ADDRESS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.BadAddress", error->message);
				break;
				case DBUS_GERROR_NOT_SUPPORTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NotSupported", error->message);
				break;
				case DBUS_GERROR_LIMITS_EXCEEDED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.LimitsExceeded", error->message);
				break;
				case DBUS_GERROR_ACCESS_DENIED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AccessDenied", error->message);
				break;
				case DBUS_GERROR_AUTH_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AuthFailed", error->message);
				break;
				case DBUS_GERROR_NO_SERVER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoServer", error->message);
				break;
				case DBUS_GERROR_TIMEOUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Timeout", error->message);
				break;
				case DBUS_GERROR_NO_NETWORK:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoNetwork", error->message);
				break;
				case DBUS_GERROR_ADDRESS_IN_USE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AddressInUse", error->message);
				break;
				case DBUS_GERROR_DISCONNECTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Disconnected", error->message);
				break;
				case DBUS_GERROR_INVALID_ARGS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidArgs", error->message);
				break;
				case DBUS_GERROR_FILE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileNotFound", error->message);
				break;
				case DBUS_GERROR_FILE_EXISTS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileExists", error->message);
				break;
				case DBUS_GERROR_UNKNOWN_METHOD:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnknownMethod", error->message);
				break;
				case DBUS_GERROR_TIMED_OUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.TimedOut", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleNotFound", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_INVALID:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleInvalid", error->message);
				break;
				case DBUS_GERROR_SPAWN_EXEC_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ExecFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_FORK_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ForkFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_EXITED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildExited", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_SIGNALED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildSignaled", error->message);
				break;
				case DBUS_GERROR_SPAWN_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.Failed", error->message);
				break;
				case DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnixProcessIdUnknown", error->message);
				break;
				case DBUS_GERROR_INVALID_SIGNATURE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidSignature", error->message);
				break;
				case DBUS_GERROR_INVALID_FILE_CONTENT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidFileContent", error->message);
				break;
				case DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.SELinuxSecurityContextUnknown", error->message);
				break;
				case DBUS_GERROR_REMOTE_EXCEPTION:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.RemoteException", error->message);
				break;
			}
		}
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	}
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	_g_hash_table_unref0 (menu_hints);
	_tmp93_ = result;
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_INT32, &_tmp93_);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static DBusHandlerResult _dbus_dock_item_dbus_interface_remove_menu_item (DockItemDBusInterface* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	gint id = 0;
	dbus_int32_t _tmp94_;
	DBusMessage* reply;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "i")) {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
	dbus_message_iter_init (message, &iter);
	dbus_message_iter_get_basic (&iter, &_tmp94_);
	dbus_message_iter_next (&iter);
	id = _tmp94_;
	dock_item_dbus_interface_remove_menu_item (self, id, &error);
	if (error) {
		if (error->domain == DBUS_GERROR) {
			switch (error->code) {
				case DBUS_GERROR_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Failed", error->message);
				break;
				case DBUS_GERROR_NO_MEMORY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoMemory", error->message);
				break;
				case DBUS_GERROR_SERVICE_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.ServiceUnknown", error->message);
				break;
				case DBUS_GERROR_NAME_HAS_NO_OWNER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NameHasNoOwner", error->message);
				break;
				case DBUS_GERROR_NO_REPLY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoReply", error->message);
				break;
				case DBUS_GERROR_IO_ERROR:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.IOError", error->message);
				break;
				case DBUS_GERROR_BAD_ADDRESS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.BadAddress", error->message);
				break;
				case DBUS_GERROR_NOT_SUPPORTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NotSupported", error->message);
				break;
				case DBUS_GERROR_LIMITS_EXCEEDED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.LimitsExceeded", error->message);
				break;
				case DBUS_GERROR_ACCESS_DENIED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AccessDenied", error->message);
				break;
				case DBUS_GERROR_AUTH_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AuthFailed", error->message);
				break;
				case DBUS_GERROR_NO_SERVER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoServer", error->message);
				break;
				case DBUS_GERROR_TIMEOUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Timeout", error->message);
				break;
				case DBUS_GERROR_NO_NETWORK:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoNetwork", error->message);
				break;
				case DBUS_GERROR_ADDRESS_IN_USE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AddressInUse", error->message);
				break;
				case DBUS_GERROR_DISCONNECTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Disconnected", error->message);
				break;
				case DBUS_GERROR_INVALID_ARGS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidArgs", error->message);
				break;
				case DBUS_GERROR_FILE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileNotFound", error->message);
				break;
				case DBUS_GERROR_FILE_EXISTS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileExists", error->message);
				break;
				case DBUS_GERROR_UNKNOWN_METHOD:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnknownMethod", error->message);
				break;
				case DBUS_GERROR_TIMED_OUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.TimedOut", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleNotFound", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_INVALID:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleInvalid", error->message);
				break;
				case DBUS_GERROR_SPAWN_EXEC_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ExecFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_FORK_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ForkFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_EXITED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildExited", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_SIGNALED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildSignaled", error->message);
				break;
				case DBUS_GERROR_SPAWN_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.Failed", error->message);
				break;
				case DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnixProcessIdUnknown", error->message);
				break;
				case DBUS_GERROR_INVALID_SIGNATURE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidSignature", error->message);
				break;
				case DBUS_GERROR_INVALID_FILE_CONTENT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidFileContent", error->message);
				break;
				case DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.SELinuxSecurityContextUnknown", error->message);
				break;
				case DBUS_GERROR_REMOTE_EXCEPTION:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.RemoteException", error->message);
				break;
			}
		}
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	}
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static DBusHandlerResult _dbus_dock_item_dbus_interface_update_dock_item (DockItemDBusInterface* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	GHashTable* hints = NULL;
	GHashTable* _tmp95_;
	DBusMessageIter _tmp96_;
	DBusMessageIter _tmp97_;
	DBusMessage* reply;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "a{sv}")) {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
	dbus_message_iter_init (message, &iter);
	_tmp95_ = g_hash_table_new_full (g_str_hash, g_str_equal, g_free, NULL);
	dbus_message_iter_recurse (&iter, &_tmp96_);
	while (dbus_message_iter_get_arg_type (&_tmp96_)) {
		char* _key;
		GValue* _value;
		const char* _tmp98_;
		GValue _tmp99_ = {0};
		DBusMessageIter _tmp100_;
		dbus_message_iter_recurse (&_tmp96_, &_tmp97_);
		dbus_message_iter_get_basic (&_tmp97_, &_tmp98_);
		dbus_message_iter_next (&_tmp97_);
		_key = g_strdup (_tmp98_);
		dbus_message_iter_recurse (&_tmp97_, &_tmp100_);
		if (dbus_message_iter_get_arg_type (&_tmp100_) == DBUS_TYPE_BYTE) {
			guint8 _tmp101_;
			dbus_message_iter_get_basic (&_tmp100_, &_tmp101_);
			g_value_init (&_tmp99_, G_TYPE_UCHAR);
			g_value_set_uchar (&_tmp99_, _tmp101_);
		} else if (dbus_message_iter_get_arg_type (&_tmp100_) == DBUS_TYPE_BOOLEAN) {
			dbus_bool_t _tmp102_;
			dbus_message_iter_get_basic (&_tmp100_, &_tmp102_);
			g_value_init (&_tmp99_, G_TYPE_BOOLEAN);
			g_value_set_boolean (&_tmp99_, _tmp102_);
		} else if (dbus_message_iter_get_arg_type (&_tmp100_) == DBUS_TYPE_INT16) {
			dbus_int16_t _tmp103_;
			dbus_message_iter_get_basic (&_tmp100_, &_tmp103_);
			g_value_init (&_tmp99_, G_TYPE_INT);
			g_value_set_int (&_tmp99_, _tmp103_);
		} else if (dbus_message_iter_get_arg_type (&_tmp100_) == DBUS_TYPE_UINT16) {
			dbus_uint16_t _tmp104_;
			dbus_message_iter_get_basic (&_tmp100_, &_tmp104_);
			g_value_init (&_tmp99_, G_TYPE_UINT);
			g_value_set_uint (&_tmp99_, _tmp104_);
		} else if (dbus_message_iter_get_arg_type (&_tmp100_) == DBUS_TYPE_INT32) {
			dbus_int32_t _tmp105_;
			dbus_message_iter_get_basic (&_tmp100_, &_tmp105_);
			g_value_init (&_tmp99_, G_TYPE_INT);
			g_value_set_int (&_tmp99_, _tmp105_);
		} else if (dbus_message_iter_get_arg_type (&_tmp100_) == DBUS_TYPE_UINT32) {
			dbus_uint32_t _tmp106_;
			dbus_message_iter_get_basic (&_tmp100_, &_tmp106_);
			g_value_init (&_tmp99_, G_TYPE_UINT);
			g_value_set_uint (&_tmp99_, _tmp106_);
		} else if (dbus_message_iter_get_arg_type (&_tmp100_) == DBUS_TYPE_INT64) {
			dbus_int64_t _tmp107_;
			dbus_message_iter_get_basic (&_tmp100_, &_tmp107_);
			g_value_init (&_tmp99_, G_TYPE_INT64);
			g_value_set_int64 (&_tmp99_, _tmp107_);
		} else if (dbus_message_iter_get_arg_type (&_tmp100_) == DBUS_TYPE_UINT64) {
			dbus_uint64_t _tmp108_;
			dbus_message_iter_get_basic (&_tmp100_, &_tmp108_);
			g_value_init (&_tmp99_, G_TYPE_UINT64);
			g_value_set_uint64 (&_tmp99_, _tmp108_);
		} else if (dbus_message_iter_get_arg_type (&_tmp100_) == DBUS_TYPE_DOUBLE) {
			double _tmp109_;
			dbus_message_iter_get_basic (&_tmp100_, &_tmp109_);
			g_value_init (&_tmp99_, G_TYPE_DOUBLE);
			g_value_set_double (&_tmp99_, _tmp109_);
		} else if (dbus_message_iter_get_arg_type (&_tmp100_) == DBUS_TYPE_STRING) {
			const char* _tmp110_;
			dbus_message_iter_get_basic (&_tmp100_, &_tmp110_);
			g_value_init (&_tmp99_, G_TYPE_STRING);
			g_value_take_string (&_tmp99_, g_strdup (_tmp110_));
		} else if (dbus_message_iter_get_arg_type (&_tmp100_) == DBUS_TYPE_OBJECT_PATH) {
			const char* _tmp111_;
			dbus_message_iter_get_basic (&_tmp100_, &_tmp111_);
			g_value_init (&_tmp99_, G_TYPE_STRING);
			g_value_take_string (&_tmp99_, g_strdup (_tmp111_));
		} else if (dbus_message_iter_get_arg_type (&_tmp100_) == DBUS_TYPE_SIGNATURE) {
			const char* _tmp112_;
			dbus_message_iter_get_basic (&_tmp100_, &_tmp112_);
			g_value_init (&_tmp99_, G_TYPE_STRING);
			g_value_take_string (&_tmp99_, g_strdup (_tmp112_));
		}
		dbus_message_iter_next (&_tmp97_);
		_value = g_memdup (&_tmp99_, sizeof (GValue));
		g_hash_table_insert (_tmp95_, _key, _value);
		dbus_message_iter_next (&_tmp96_);
	}
	dbus_message_iter_next (&iter);
	hints = _tmp95_;
	dock_item_dbus_interface_update_dock_item (self, hints, &error);
	if (error) {
		if (error->domain == DBUS_GERROR) {
			switch (error->code) {
				case DBUS_GERROR_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Failed", error->message);
				break;
				case DBUS_GERROR_NO_MEMORY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoMemory", error->message);
				break;
				case DBUS_GERROR_SERVICE_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.ServiceUnknown", error->message);
				break;
				case DBUS_GERROR_NAME_HAS_NO_OWNER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NameHasNoOwner", error->message);
				break;
				case DBUS_GERROR_NO_REPLY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoReply", error->message);
				break;
				case DBUS_GERROR_IO_ERROR:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.IOError", error->message);
				break;
				case DBUS_GERROR_BAD_ADDRESS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.BadAddress", error->message);
				break;
				case DBUS_GERROR_NOT_SUPPORTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NotSupported", error->message);
				break;
				case DBUS_GERROR_LIMITS_EXCEEDED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.LimitsExceeded", error->message);
				break;
				case DBUS_GERROR_ACCESS_DENIED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AccessDenied", error->message);
				break;
				case DBUS_GERROR_AUTH_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AuthFailed", error->message);
				break;
				case DBUS_GERROR_NO_SERVER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoServer", error->message);
				break;
				case DBUS_GERROR_TIMEOUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Timeout", error->message);
				break;
				case DBUS_GERROR_NO_NETWORK:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoNetwork", error->message);
				break;
				case DBUS_GERROR_ADDRESS_IN_USE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AddressInUse", error->message);
				break;
				case DBUS_GERROR_DISCONNECTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Disconnected", error->message);
				break;
				case DBUS_GERROR_INVALID_ARGS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidArgs", error->message);
				break;
				case DBUS_GERROR_FILE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileNotFound", error->message);
				break;
				case DBUS_GERROR_FILE_EXISTS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileExists", error->message);
				break;
				case DBUS_GERROR_UNKNOWN_METHOD:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnknownMethod", error->message);
				break;
				case DBUS_GERROR_TIMED_OUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.TimedOut", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleNotFound", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_INVALID:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleInvalid", error->message);
				break;
				case DBUS_GERROR_SPAWN_EXEC_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ExecFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_FORK_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ForkFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_EXITED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildExited", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_SIGNALED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildSignaled", error->message);
				break;
				case DBUS_GERROR_SPAWN_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.Failed", error->message);
				break;
				case DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnixProcessIdUnknown", error->message);
				break;
				case DBUS_GERROR_INVALID_SIGNATURE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidSignature", error->message);
				break;
				case DBUS_GERROR_INVALID_FILE_CONTENT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidFileContent", error->message);
				break;
				case DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.SELinuxSecurityContextUnknown", error->message);
				break;
				case DBUS_GERROR_REMOTE_EXCEPTION:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.RemoteException", error->message);
				break;
			}
		}
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	}
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	_g_hash_table_unref0 (hints);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


DBusHandlerResult dock_item_dbus_interface_dbus_message (DBusConnection* connection, DBusMessage* message, void* object) {
	DBusHandlerResult result;
	result = DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	if (dbus_message_is_method_call (message, "org.freedesktop.DBus.Introspectable", "Introspect")) {
		result = _dbus_dock_item_dbus_interface_introspect (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.freedesktop.DBus.Properties", "Get")) {
		result = _dbus_dock_item_dbus_interface_property_get (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.freedesktop.DBus.Properties", "GetAll")) {
		result = _dbus_dock_item_dbus_interface_property_get_all (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.freedesktop.DockItem", "AddMenuItem")) {
		result = _dbus_dock_item_dbus_interface_add_menu_item (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.freedesktop.DockItem", "RemoveMenuItem")) {
		result = _dbus_dock_item_dbus_interface_remove_menu_item (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.freedesktop.DockItem", "UpdateDockItem")) {
		result = _dbus_dock_item_dbus_interface_update_dock_item (object, connection, message);
	}
	if (result == DBUS_HANDLER_RESULT_HANDLED) {
		return result;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static void _dbus_dock_item_dbus_interface_menu_item_activated (GObject* _sender, gint id, DBusConnection* _connection) {
	const char * _path;
	DBusMessage *_message;
	DBusMessageIter _iter;
	dbus_int32_t _tmp113_;
	_path = g_object_get_data (_sender, "dbus_object_path");
	_message = dbus_message_new_signal (_path, "org.freedesktop.DockItem", "MenuItemActivated");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp113_ = id;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_INT32, &_tmp113_);
	dbus_connection_send (_connection, _message, NULL);
	dbus_message_unref (_message);
}


void dock_item_dbus_interface_dbus_register_object (DBusConnection* connection, const char* path, void* object) {
	if (!g_object_get_data (object, "dbus_object_path")) {
		g_object_set_data (object, "dbus_object_path", g_strdup (path));
		dbus_connection_register_object_path (connection, path, &_dock_item_dbus_interface_dbus_path_vtable, object);
		g_object_weak_ref (object, _vala_dbus_unregister_object, connection);
	}
	g_signal_connect (object, "menu-item-activated", (GCallback) _dbus_dock_item_dbus_interface_menu_item_activated, connection);
}


static void dock_item_dbus_interface_base_init (DockItemDBusInterfaceIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
		g_object_interface_install_property (iface, g_param_spec_string ("desktop-file", "desktop-file", "desktop-file", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
		g_object_interface_install_property (iface, g_param_spec_string ("uri", "uri", "uri", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
		g_signal_new ("menu_item_activated", TYPE_DOCK_ITEM_DBUS_INTERFACE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__INT, G_TYPE_NONE, 1, G_TYPE_INT);
		g_type_set_qdata (TYPE_DOCK_ITEM_DBUS_INTERFACE, g_quark_from_static_string ("DBusObjectVTable"), (void*) (&_dock_item_dbus_interface_dbus_vtable));
	}
}


GType dock_item_dbus_interface_get_type (void) {
	static volatile gsize dock_item_dbus_interface_type_id__volatile = 0;
	if (g_once_init_enter (&dock_item_dbus_interface_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DockItemDBusInterfaceIface), (GBaseInitFunc) dock_item_dbus_interface_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType dock_item_dbus_interface_type_id;
		dock_item_dbus_interface_type_id = g_type_register_static (G_TYPE_INTERFACE, "DockItemDBusInterface", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (dock_item_dbus_interface_type_id, G_TYPE_OBJECT);
		g_type_set_qdata (dock_item_dbus_interface_type_id, g_quark_from_string ("ValaDBusInterfaceProxyType"), &dock_item_dbus_interface_dbus_proxy_get_type);
		g_once_init_leave (&dock_item_dbus_interface_type_id__volatile, dock_item_dbus_interface_type_id);
	}
	return dock_item_dbus_interface_type_id__volatile;
}


G_DEFINE_TYPE_EXTENDED (DockItemDBusInterfaceDBusProxy, dock_item_dbus_interface_dbus_proxy, DBUS_TYPE_G_PROXY, 0, G_IMPLEMENT_INTERFACE (TYPE_DOCK_ITEM_DBUS_INTERFACE, dock_item_dbus_interface_dbus_proxy_dock_item_dbus_interface__interface_init) );
DockItemDBusInterface* dock_item_dbus_interface_dbus_proxy_new (DBusGConnection* connection, const char* name, const char* path) {
	DockItemDBusInterface* self;
	self = g_object_new (dock_item_dbus_interface_dbus_proxy_get_type (), "connection", connection, "name", name, "path", path, "interface", "org.freedesktop.DockItem", NULL);
	return self;
}


static GObject* dock_item_dbus_interface_dbus_proxy_construct (GType gtype, guint n_properties, GObjectConstructParam* properties) {
	GObject* self;
	DBusGConnection *connection;
	char* path;
	char* filter;
	self = G_OBJECT_CLASS (dock_item_dbus_interface_dbus_proxy_parent_class)->constructor (gtype, n_properties, properties);
	g_object_get (self, "connection", &connection, NULL);
	g_object_get (self, "path", &path, NULL);
	dbus_connection_add_filter (dbus_g_connection_get_connection (connection), dock_item_dbus_interface_dbus_proxy_filter, self, NULL);
	filter = g_strdup_printf ("type='signal',path='%s'", path);
	dbus_bus_add_match (dbus_g_connection_get_connection (connection), filter, NULL);
	dbus_g_connection_unref (connection);
	g_free (path);
	g_free (filter);
	return self;
}


static void _dbus_handle_dock_item_dbus_interface_menu_item_activated (DockItemDBusInterface* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	gint id = 0;
	dbus_int32_t _tmp114_;
	DBusMessage* reply;
	if (strcmp (dbus_message_get_signature (message), "i")) {
		return;
	}
	dbus_message_iter_init (message, &iter);
	dbus_message_iter_get_basic (&iter, &_tmp114_);
	dbus_message_iter_next (&iter);
	id = _tmp114_;
	g_signal_emit_by_name (self, "menu-item-activated", id);
}


DBusHandlerResult dock_item_dbus_interface_dbus_proxy_filter (DBusConnection* connection, DBusMessage* message, void* user_data) {
	if (dbus_message_has_path (message, dbus_g_proxy_get_path (user_data))) {
		if (dbus_message_is_signal (message, "org.freedesktop.DockItem", "MenuItemActivated")) {
			_dbus_handle_dock_item_dbus_interface_menu_item_activated (user_data, connection, message);
		}
	}
	return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
}


static void dock_item_dbus_interface_dbus_proxy_dispose (GObject* self) {
	DBusGConnection *connection;
	if (((DockItemDBusInterfaceDBusProxy*) self)->disposed) {
		return;
	}
	((DockItemDBusInterfaceDBusProxy*) self)->disposed = TRUE;
	g_object_get (self, "connection", &connection, NULL);
	dbus_connection_remove_filter (dbus_g_connection_get_connection (connection), dock_item_dbus_interface_dbus_proxy_filter, self);
	G_OBJECT_CLASS (dock_item_dbus_interface_dbus_proxy_parent_class)->dispose (self);
}


static void dock_item_dbus_interface_dbus_proxy_class_init (DockItemDBusInterfaceDBusProxyClass* klass) {
	G_OBJECT_CLASS (klass)->constructor = dock_item_dbus_interface_dbus_proxy_construct;
	G_OBJECT_CLASS (klass)->dispose = dock_item_dbus_interface_dbus_proxy_dispose;
	G_OBJECT_CLASS (klass)->get_property = dock_item_dbus_interface_dbus_proxy_get_property;
	G_OBJECT_CLASS (klass)->set_property = dock_item_dbus_interface_dbus_proxy_set_property;
	g_object_class_override_property (G_OBJECT_CLASS (klass), DOCK_ITEM_DBUS_INTERFACE_DBUS_PROXY_DESKTOP_FILE, "desktop-file");
	g_object_class_override_property (G_OBJECT_CLASS (klass), DOCK_ITEM_DBUS_INTERFACE_DBUS_PROXY_URI, "uri");
}


static void dock_item_dbus_interface_dbus_proxy_init (DockItemDBusInterfaceDBusProxy* self) {
}


static gint dock_item_dbus_interface_dbus_proxy_add_menu_item (DockItemDBusInterface* self, GHashTable* menu_hints, GError** error) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	DBusMessageIter _tmp115_, _tmp116_;
	GHashTableIter _tmp117_;
	gpointer _tmp118_, _tmp119_;
	gint _result;
	dbus_int32_t _tmp130_;
	if (((DockItemDBusInterfaceDBusProxy*) self)->disposed) {
		g_set_error (error, DBUS_GERROR, DBUS_GERROR_DISCONNECTED, "%s", "Connection is closed");
		return 0;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.freedesktop.DockItem", "AddMenuItem");
	dbus_message_iter_init_append (_message, &_iter);
	dbus_message_iter_open_container (&_iter, DBUS_TYPE_ARRAY, "{sv}", &_tmp115_);
	g_hash_table_iter_init (&_tmp117_, menu_hints);
	while (g_hash_table_iter_next (&_tmp117_, &_tmp118_, &_tmp119_)) {
		char* _key;
		GValue* _value;
		const char* _tmp120_;
		DBusMessageIter _tmp121_;
		dbus_message_iter_open_container (&_tmp115_, DBUS_TYPE_DICT_ENTRY, NULL, &_tmp116_);
		_key = (char*) _tmp118_;
		_value = (GValue*) _tmp119_;
		_tmp120_ = _key;
		dbus_message_iter_append_basic (&_tmp116_, DBUS_TYPE_STRING, &_tmp120_);
		if (G_VALUE_TYPE (_value) == G_TYPE_UCHAR) {
			guint8 _tmp122_;
			dbus_message_iter_open_container (&_tmp116_, DBUS_TYPE_VARIANT, "y", &_tmp121_);
			_tmp122_ = g_value_get_uchar (_value);
			dbus_message_iter_append_basic (&_tmp121_, DBUS_TYPE_BYTE, &_tmp122_);
			dbus_message_iter_close_container (&_tmp116_, &_tmp121_);
		} else if (G_VALUE_TYPE (_value) == G_TYPE_BOOLEAN) {
			dbus_bool_t _tmp123_;
			dbus_message_iter_open_container (&_tmp116_, DBUS_TYPE_VARIANT, "b", &_tmp121_);
			_tmp123_ = g_value_get_boolean (_value);
			dbus_message_iter_append_basic (&_tmp121_, DBUS_TYPE_BOOLEAN, &_tmp123_);
			dbus_message_iter_close_container (&_tmp116_, &_tmp121_);
		} else if (G_VALUE_TYPE (_value) == G_TYPE_INT) {
			dbus_int32_t _tmp124_;
			dbus_message_iter_open_container (&_tmp116_, DBUS_TYPE_VARIANT, "i", &_tmp121_);
			_tmp124_ = g_value_get_int (_value);
			dbus_message_iter_append_basic (&_tmp121_, DBUS_TYPE_INT32, &_tmp124_);
			dbus_message_iter_close_container (&_tmp116_, &_tmp121_);
		} else if (G_VALUE_TYPE (_value) == G_TYPE_UINT) {
			dbus_uint32_t _tmp125_;
			dbus_message_iter_open_container (&_tmp116_, DBUS_TYPE_VARIANT, "u", &_tmp121_);
			_tmp125_ = g_value_get_uint (_value);
			dbus_message_iter_append_basic (&_tmp121_, DBUS_TYPE_UINT32, &_tmp125_);
			dbus_message_iter_close_container (&_tmp116_, &_tmp121_);
		} else if (G_VALUE_TYPE (_value) == G_TYPE_INT64) {
			dbus_int64_t _tmp126_;
			dbus_message_iter_open_container (&_tmp116_, DBUS_TYPE_VARIANT, "x", &_tmp121_);
			_tmp126_ = g_value_get_int64 (_value);
			dbus_message_iter_append_basic (&_tmp121_, DBUS_TYPE_INT64, &_tmp126_);
			dbus_message_iter_close_container (&_tmp116_, &_tmp121_);
		} else if (G_VALUE_TYPE (_value) == G_TYPE_UINT64) {
			dbus_uint64_t _tmp127_;
			dbus_message_iter_open_container (&_tmp116_, DBUS_TYPE_VARIANT, "t", &_tmp121_);
			_tmp127_ = g_value_get_uint64 (_value);
			dbus_message_iter_append_basic (&_tmp121_, DBUS_TYPE_UINT64, &_tmp127_);
			dbus_message_iter_close_container (&_tmp116_, &_tmp121_);
		} else if (G_VALUE_TYPE (_value) == G_TYPE_DOUBLE) {
			double _tmp128_;
			dbus_message_iter_open_container (&_tmp116_, DBUS_TYPE_VARIANT, "d", &_tmp121_);
			_tmp128_ = g_value_get_double (_value);
			dbus_message_iter_append_basic (&_tmp121_, DBUS_TYPE_DOUBLE, &_tmp128_);
			dbus_message_iter_close_container (&_tmp116_, &_tmp121_);
		} else if (G_VALUE_TYPE (_value) == G_TYPE_STRING) {
			const char* _tmp129_;
			dbus_message_iter_open_container (&_tmp116_, DBUS_TYPE_VARIANT, "s", &_tmp121_);
			_tmp129_ = g_value_get_string (_value);
			dbus_message_iter_append_basic (&_tmp121_, DBUS_TYPE_STRING, &_tmp129_);
			dbus_message_iter_close_container (&_tmp116_, &_tmp121_);
		}
		dbus_message_iter_close_container (&_tmp115_, &_tmp116_);
	}
	dbus_message_iter_close_container (&_iter, &_tmp115_);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		GQuark _edomain;
		gint _ecode;
		if (strstr (_dbus_error.name, "org.freedesktop.DBus.Error") == _dbus_error.name) {
			const char* _tmp131_;
			_edomain = DBUS_GERROR;
			_tmp131_ = _dbus_error.name + 27;
			if (strcmp (_tmp131_, "Failed") == 0) {
				_ecode = DBUS_GERROR_FAILED;
			} else if (strcmp (_tmp131_, "NoMemory") == 0) {
				_ecode = DBUS_GERROR_NO_MEMORY;
			} else if (strcmp (_tmp131_, "ServiceUnknown") == 0) {
				_ecode = DBUS_GERROR_SERVICE_UNKNOWN;
			} else if (strcmp (_tmp131_, "NameHasNoOwner") == 0) {
				_ecode = DBUS_GERROR_NAME_HAS_NO_OWNER;
			} else if (strcmp (_tmp131_, "NoReply") == 0) {
				_ecode = DBUS_GERROR_NO_REPLY;
			} else if (strcmp (_tmp131_, "IOError") == 0) {
				_ecode = DBUS_GERROR_IO_ERROR;
			} else if (strcmp (_tmp131_, "BadAddress") == 0) {
				_ecode = DBUS_GERROR_BAD_ADDRESS;
			} else if (strcmp (_tmp131_, "NotSupported") == 0) {
				_ecode = DBUS_GERROR_NOT_SUPPORTED;
			} else if (strcmp (_tmp131_, "LimitsExceeded") == 0) {
				_ecode = DBUS_GERROR_LIMITS_EXCEEDED;
			} else if (strcmp (_tmp131_, "AccessDenied") == 0) {
				_ecode = DBUS_GERROR_ACCESS_DENIED;
			} else if (strcmp (_tmp131_, "AuthFailed") == 0) {
				_ecode = DBUS_GERROR_AUTH_FAILED;
			} else if (strcmp (_tmp131_, "NoServer") == 0) {
				_ecode = DBUS_GERROR_NO_SERVER;
			} else if (strcmp (_tmp131_, "Timeout") == 0) {
				_ecode = DBUS_GERROR_TIMEOUT;
			} else if (strcmp (_tmp131_, "NoNetwork") == 0) {
				_ecode = DBUS_GERROR_NO_NETWORK;
			} else if (strcmp (_tmp131_, "AddressInUse") == 0) {
				_ecode = DBUS_GERROR_ADDRESS_IN_USE;
			} else if (strcmp (_tmp131_, "Disconnected") == 0) {
				_ecode = DBUS_GERROR_DISCONNECTED;
			} else if (strcmp (_tmp131_, "InvalidArgs") == 0) {
				_ecode = DBUS_GERROR_INVALID_ARGS;
			} else if (strcmp (_tmp131_, "FileNotFound") == 0) {
				_ecode = DBUS_GERROR_FILE_NOT_FOUND;
			} else if (strcmp (_tmp131_, "FileExists") == 0) {
				_ecode = DBUS_GERROR_FILE_EXISTS;
			} else if (strcmp (_tmp131_, "UnknownMethod") == 0) {
				_ecode = DBUS_GERROR_UNKNOWN_METHOD;
			} else if (strcmp (_tmp131_, "TimedOut") == 0) {
				_ecode = DBUS_GERROR_TIMED_OUT;
			} else if (strcmp (_tmp131_, "MatchRuleNotFound") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_NOT_FOUND;
			} else if (strcmp (_tmp131_, "MatchRuleInvalid") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_INVALID;
			} else if (strcmp (_tmp131_, "Spawn.ExecFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_EXEC_FAILED;
			} else if (strcmp (_tmp131_, "Spawn.ForkFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FORK_FAILED;
			} else if (strcmp (_tmp131_, "Spawn.ChildExited") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_EXITED;
			} else if (strcmp (_tmp131_, "Spawn.ChildSignaled") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_SIGNALED;
			} else if (strcmp (_tmp131_, "Spawn.Failed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FAILED;
			} else if (strcmp (_tmp131_, "UnixProcessIdUnknown") == 0) {
				_ecode = DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN;
			} else if (strcmp (_tmp131_, "InvalidSignature") == 0) {
				_ecode = DBUS_GERROR_INVALID_SIGNATURE;
			} else if (strcmp (_tmp131_, "InvalidFileContent") == 0) {
				_ecode = DBUS_GERROR_INVALID_FILE_CONTENT;
			} else if (strcmp (_tmp131_, "SELinuxSecurityContextUnknown") == 0) {
				_ecode = DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN;
			} else if (strcmp (_tmp131_, "RemoteException") == 0) {
				_ecode = DBUS_GERROR_REMOTE_EXCEPTION;
			}
		}
		g_set_error (error, _edomain, _ecode, "%s", _dbus_error.message);
		dbus_error_free (&_dbus_error);
		return 0;
	}
	if (strcmp (dbus_message_get_signature (_reply), "i")) {
		g_set_error (error, DBUS_GERROR, DBUS_GERROR_INVALID_SIGNATURE, "Invalid signature, expected \"%s\", got \"%s\"", "i", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return 0;
	}
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_get_basic (&_iter, &_tmp130_);
	dbus_message_iter_next (&_iter);
	_result = _tmp130_;
	dbus_message_unref (_reply);
	return _result;
}


static void dock_item_dbus_interface_dbus_proxy_remove_menu_item (DockItemDBusInterface* self, gint id, GError** error) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	dbus_int32_t _tmp132_;
	if (((DockItemDBusInterfaceDBusProxy*) self)->disposed) {
		g_set_error (error, DBUS_GERROR, DBUS_GERROR_DISCONNECTED, "%s", "Connection is closed");
		return;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.freedesktop.DockItem", "RemoveMenuItem");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp132_ = id;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_INT32, &_tmp132_);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		GQuark _edomain;
		gint _ecode;
		if (strstr (_dbus_error.name, "org.freedesktop.DBus.Error") == _dbus_error.name) {
			const char* _tmp133_;
			_edomain = DBUS_GERROR;
			_tmp133_ = _dbus_error.name + 27;
			if (strcmp (_tmp133_, "Failed") == 0) {
				_ecode = DBUS_GERROR_FAILED;
			} else if (strcmp (_tmp133_, "NoMemory") == 0) {
				_ecode = DBUS_GERROR_NO_MEMORY;
			} else if (strcmp (_tmp133_, "ServiceUnknown") == 0) {
				_ecode = DBUS_GERROR_SERVICE_UNKNOWN;
			} else if (strcmp (_tmp133_, "NameHasNoOwner") == 0) {
				_ecode = DBUS_GERROR_NAME_HAS_NO_OWNER;
			} else if (strcmp (_tmp133_, "NoReply") == 0) {
				_ecode = DBUS_GERROR_NO_REPLY;
			} else if (strcmp (_tmp133_, "IOError") == 0) {
				_ecode = DBUS_GERROR_IO_ERROR;
			} else if (strcmp (_tmp133_, "BadAddress") == 0) {
				_ecode = DBUS_GERROR_BAD_ADDRESS;
			} else if (strcmp (_tmp133_, "NotSupported") == 0) {
				_ecode = DBUS_GERROR_NOT_SUPPORTED;
			} else if (strcmp (_tmp133_, "LimitsExceeded") == 0) {
				_ecode = DBUS_GERROR_LIMITS_EXCEEDED;
			} else if (strcmp (_tmp133_, "AccessDenied") == 0) {
				_ecode = DBUS_GERROR_ACCESS_DENIED;
			} else if (strcmp (_tmp133_, "AuthFailed") == 0) {
				_ecode = DBUS_GERROR_AUTH_FAILED;
			} else if (strcmp (_tmp133_, "NoServer") == 0) {
				_ecode = DBUS_GERROR_NO_SERVER;
			} else if (strcmp (_tmp133_, "Timeout") == 0) {
				_ecode = DBUS_GERROR_TIMEOUT;
			} else if (strcmp (_tmp133_, "NoNetwork") == 0) {
				_ecode = DBUS_GERROR_NO_NETWORK;
			} else if (strcmp (_tmp133_, "AddressInUse") == 0) {
				_ecode = DBUS_GERROR_ADDRESS_IN_USE;
			} else if (strcmp (_tmp133_, "Disconnected") == 0) {
				_ecode = DBUS_GERROR_DISCONNECTED;
			} else if (strcmp (_tmp133_, "InvalidArgs") == 0) {
				_ecode = DBUS_GERROR_INVALID_ARGS;
			} else if (strcmp (_tmp133_, "FileNotFound") == 0) {
				_ecode = DBUS_GERROR_FILE_NOT_FOUND;
			} else if (strcmp (_tmp133_, "FileExists") == 0) {
				_ecode = DBUS_GERROR_FILE_EXISTS;
			} else if (strcmp (_tmp133_, "UnknownMethod") == 0) {
				_ecode = DBUS_GERROR_UNKNOWN_METHOD;
			} else if (strcmp (_tmp133_, "TimedOut") == 0) {
				_ecode = DBUS_GERROR_TIMED_OUT;
			} else if (strcmp (_tmp133_, "MatchRuleNotFound") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_NOT_FOUND;
			} else if (strcmp (_tmp133_, "MatchRuleInvalid") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_INVALID;
			} else if (strcmp (_tmp133_, "Spawn.ExecFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_EXEC_FAILED;
			} else if (strcmp (_tmp133_, "Spawn.ForkFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FORK_FAILED;
			} else if (strcmp (_tmp133_, "Spawn.ChildExited") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_EXITED;
			} else if (strcmp (_tmp133_, "Spawn.ChildSignaled") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_SIGNALED;
			} else if (strcmp (_tmp133_, "Spawn.Failed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FAILED;
			} else if (strcmp (_tmp133_, "UnixProcessIdUnknown") == 0) {
				_ecode = DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN;
			} else if (strcmp (_tmp133_, "InvalidSignature") == 0) {
				_ecode = DBUS_GERROR_INVALID_SIGNATURE;
			} else if (strcmp (_tmp133_, "InvalidFileContent") == 0) {
				_ecode = DBUS_GERROR_INVALID_FILE_CONTENT;
			} else if (strcmp (_tmp133_, "SELinuxSecurityContextUnknown") == 0) {
				_ecode = DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN;
			} else if (strcmp (_tmp133_, "RemoteException") == 0) {
				_ecode = DBUS_GERROR_REMOTE_EXCEPTION;
			}
		}
		g_set_error (error, _edomain, _ecode, "%s", _dbus_error.message);
		dbus_error_free (&_dbus_error);
		return;
	}
	if (strcmp (dbus_message_get_signature (_reply), "")) {
		g_set_error (error, DBUS_GERROR, DBUS_GERROR_INVALID_SIGNATURE, "Invalid signature, expected \"%s\", got \"%s\"", "", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return;
	}
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_unref (_reply);
}


static void dock_item_dbus_interface_dbus_proxy_update_dock_item (DockItemDBusInterface* self, GHashTable* hints, GError** error) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	DBusMessageIter _tmp134_, _tmp135_;
	GHashTableIter _tmp136_;
	gpointer _tmp137_, _tmp138_;
	if (((DockItemDBusInterfaceDBusProxy*) self)->disposed) {
		g_set_error (error, DBUS_GERROR, DBUS_GERROR_DISCONNECTED, "%s", "Connection is closed");
		return;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.freedesktop.DockItem", "UpdateDockItem");
	dbus_message_iter_init_append (_message, &_iter);
	dbus_message_iter_open_container (&_iter, DBUS_TYPE_ARRAY, "{sv}", &_tmp134_);
	g_hash_table_iter_init (&_tmp136_, hints);
	while (g_hash_table_iter_next (&_tmp136_, &_tmp137_, &_tmp138_)) {
		char* _key;
		GValue* _value;
		const char* _tmp139_;
		DBusMessageIter _tmp140_;
		dbus_message_iter_open_container (&_tmp134_, DBUS_TYPE_DICT_ENTRY, NULL, &_tmp135_);
		_key = (char*) _tmp137_;
		_value = (GValue*) _tmp138_;
		_tmp139_ = _key;
		dbus_message_iter_append_basic (&_tmp135_, DBUS_TYPE_STRING, &_tmp139_);
		if (G_VALUE_TYPE (_value) == G_TYPE_UCHAR) {
			guint8 _tmp141_;
			dbus_message_iter_open_container (&_tmp135_, DBUS_TYPE_VARIANT, "y", &_tmp140_);
			_tmp141_ = g_value_get_uchar (_value);
			dbus_message_iter_append_basic (&_tmp140_, DBUS_TYPE_BYTE, &_tmp141_);
			dbus_message_iter_close_container (&_tmp135_, &_tmp140_);
		} else if (G_VALUE_TYPE (_value) == G_TYPE_BOOLEAN) {
			dbus_bool_t _tmp142_;
			dbus_message_iter_open_container (&_tmp135_, DBUS_TYPE_VARIANT, "b", &_tmp140_);
			_tmp142_ = g_value_get_boolean (_value);
			dbus_message_iter_append_basic (&_tmp140_, DBUS_TYPE_BOOLEAN, &_tmp142_);
			dbus_message_iter_close_container (&_tmp135_, &_tmp140_);
		} else if (G_VALUE_TYPE (_value) == G_TYPE_INT) {
			dbus_int32_t _tmp143_;
			dbus_message_iter_open_container (&_tmp135_, DBUS_TYPE_VARIANT, "i", &_tmp140_);
			_tmp143_ = g_value_get_int (_value);
			dbus_message_iter_append_basic (&_tmp140_, DBUS_TYPE_INT32, &_tmp143_);
			dbus_message_iter_close_container (&_tmp135_, &_tmp140_);
		} else if (G_VALUE_TYPE (_value) == G_TYPE_UINT) {
			dbus_uint32_t _tmp144_;
			dbus_message_iter_open_container (&_tmp135_, DBUS_TYPE_VARIANT, "u", &_tmp140_);
			_tmp144_ = g_value_get_uint (_value);
			dbus_message_iter_append_basic (&_tmp140_, DBUS_TYPE_UINT32, &_tmp144_);
			dbus_message_iter_close_container (&_tmp135_, &_tmp140_);
		} else if (G_VALUE_TYPE (_value) == G_TYPE_INT64) {
			dbus_int64_t _tmp145_;
			dbus_message_iter_open_container (&_tmp135_, DBUS_TYPE_VARIANT, "x", &_tmp140_);
			_tmp145_ = g_value_get_int64 (_value);
			dbus_message_iter_append_basic (&_tmp140_, DBUS_TYPE_INT64, &_tmp145_);
			dbus_message_iter_close_container (&_tmp135_, &_tmp140_);
		} else if (G_VALUE_TYPE (_value) == G_TYPE_UINT64) {
			dbus_uint64_t _tmp146_;
			dbus_message_iter_open_container (&_tmp135_, DBUS_TYPE_VARIANT, "t", &_tmp140_);
			_tmp146_ = g_value_get_uint64 (_value);
			dbus_message_iter_append_basic (&_tmp140_, DBUS_TYPE_UINT64, &_tmp146_);
			dbus_message_iter_close_container (&_tmp135_, &_tmp140_);
		} else if (G_VALUE_TYPE (_value) == G_TYPE_DOUBLE) {
			double _tmp147_;
			dbus_message_iter_open_container (&_tmp135_, DBUS_TYPE_VARIANT, "d", &_tmp140_);
			_tmp147_ = g_value_get_double (_value);
			dbus_message_iter_append_basic (&_tmp140_, DBUS_TYPE_DOUBLE, &_tmp147_);
			dbus_message_iter_close_container (&_tmp135_, &_tmp140_);
		} else if (G_VALUE_TYPE (_value) == G_TYPE_STRING) {
			const char* _tmp148_;
			dbus_message_iter_open_container (&_tmp135_, DBUS_TYPE_VARIANT, "s", &_tmp140_);
			_tmp148_ = g_value_get_string (_value);
			dbus_message_iter_append_basic (&_tmp140_, DBUS_TYPE_STRING, &_tmp148_);
			dbus_message_iter_close_container (&_tmp135_, &_tmp140_);
		}
		dbus_message_iter_close_container (&_tmp134_, &_tmp135_);
	}
	dbus_message_iter_close_container (&_iter, &_tmp134_);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		GQuark _edomain;
		gint _ecode;
		if (strstr (_dbus_error.name, "org.freedesktop.DBus.Error") == _dbus_error.name) {
			const char* _tmp149_;
			_edomain = DBUS_GERROR;
			_tmp149_ = _dbus_error.name + 27;
			if (strcmp (_tmp149_, "Failed") == 0) {
				_ecode = DBUS_GERROR_FAILED;
			} else if (strcmp (_tmp149_, "NoMemory") == 0) {
				_ecode = DBUS_GERROR_NO_MEMORY;
			} else if (strcmp (_tmp149_, "ServiceUnknown") == 0) {
				_ecode = DBUS_GERROR_SERVICE_UNKNOWN;
			} else if (strcmp (_tmp149_, "NameHasNoOwner") == 0) {
				_ecode = DBUS_GERROR_NAME_HAS_NO_OWNER;
			} else if (strcmp (_tmp149_, "NoReply") == 0) {
				_ecode = DBUS_GERROR_NO_REPLY;
			} else if (strcmp (_tmp149_, "IOError") == 0) {
				_ecode = DBUS_GERROR_IO_ERROR;
			} else if (strcmp (_tmp149_, "BadAddress") == 0) {
				_ecode = DBUS_GERROR_BAD_ADDRESS;
			} else if (strcmp (_tmp149_, "NotSupported") == 0) {
				_ecode = DBUS_GERROR_NOT_SUPPORTED;
			} else if (strcmp (_tmp149_, "LimitsExceeded") == 0) {
				_ecode = DBUS_GERROR_LIMITS_EXCEEDED;
			} else if (strcmp (_tmp149_, "AccessDenied") == 0) {
				_ecode = DBUS_GERROR_ACCESS_DENIED;
			} else if (strcmp (_tmp149_, "AuthFailed") == 0) {
				_ecode = DBUS_GERROR_AUTH_FAILED;
			} else if (strcmp (_tmp149_, "NoServer") == 0) {
				_ecode = DBUS_GERROR_NO_SERVER;
			} else if (strcmp (_tmp149_, "Timeout") == 0) {
				_ecode = DBUS_GERROR_TIMEOUT;
			} else if (strcmp (_tmp149_, "NoNetwork") == 0) {
				_ecode = DBUS_GERROR_NO_NETWORK;
			} else if (strcmp (_tmp149_, "AddressInUse") == 0) {
				_ecode = DBUS_GERROR_ADDRESS_IN_USE;
			} else if (strcmp (_tmp149_, "Disconnected") == 0) {
				_ecode = DBUS_GERROR_DISCONNECTED;
			} else if (strcmp (_tmp149_, "InvalidArgs") == 0) {
				_ecode = DBUS_GERROR_INVALID_ARGS;
			} else if (strcmp (_tmp149_, "FileNotFound") == 0) {
				_ecode = DBUS_GERROR_FILE_NOT_FOUND;
			} else if (strcmp (_tmp149_, "FileExists") == 0) {
				_ecode = DBUS_GERROR_FILE_EXISTS;
			} else if (strcmp (_tmp149_, "UnknownMethod") == 0) {
				_ecode = DBUS_GERROR_UNKNOWN_METHOD;
			} else if (strcmp (_tmp149_, "TimedOut") == 0) {
				_ecode = DBUS_GERROR_TIMED_OUT;
			} else if (strcmp (_tmp149_, "MatchRuleNotFound") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_NOT_FOUND;
			} else if (strcmp (_tmp149_, "MatchRuleInvalid") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_INVALID;
			} else if (strcmp (_tmp149_, "Spawn.ExecFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_EXEC_FAILED;
			} else if (strcmp (_tmp149_, "Spawn.ForkFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FORK_FAILED;
			} else if (strcmp (_tmp149_, "Spawn.ChildExited") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_EXITED;
			} else if (strcmp (_tmp149_, "Spawn.ChildSignaled") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_SIGNALED;
			} else if (strcmp (_tmp149_, "Spawn.Failed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FAILED;
			} else if (strcmp (_tmp149_, "UnixProcessIdUnknown") == 0) {
				_ecode = DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN;
			} else if (strcmp (_tmp149_, "InvalidSignature") == 0) {
				_ecode = DBUS_GERROR_INVALID_SIGNATURE;
			} else if (strcmp (_tmp149_, "InvalidFileContent") == 0) {
				_ecode = DBUS_GERROR_INVALID_FILE_CONTENT;
			} else if (strcmp (_tmp149_, "SELinuxSecurityContextUnknown") == 0) {
				_ecode = DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN;
			} else if (strcmp (_tmp149_, "RemoteException") == 0) {
				_ecode = DBUS_GERROR_REMOTE_EXCEPTION;
			}
		}
		g_set_error (error, _edomain, _ecode, "%s", _dbus_error.message);
		dbus_error_free (&_dbus_error);
		return;
	}
	if (strcmp (dbus_message_get_signature (_reply), "")) {
		g_set_error (error, DBUS_GERROR, DBUS_GERROR_INVALID_SIGNATURE, "Invalid signature, expected \"%s\", got \"%s\"", "", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return;
	}
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_unref (_reply);
}


static char* dock_item_dbus_interface_dbus_proxy_get_desktop_file (DockItemDBusInterface* self) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter, _subiter;
	const char* _tmp150_;
	const char* _tmp151_;
	char* _result;
	const char* _tmp152_;
	if (((DockItemDBusInterfaceDBusProxy*) self)->disposed) {
		return NULL;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.freedesktop.DBus.Properties", "Get");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp150_ = "org.freedesktop.DockItem";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp150_);
	_tmp151_ = "DesktopFile";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp151_);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s)", __FILE__, __LINE__, _dbus_error.message, _dbus_error.name);
		dbus_error_free (&_dbus_error);
		return NULL;
	}
	if (strcmp (dbus_message_get_signature (_reply), "v")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "v", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return NULL;
	}
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_recurse (&_iter, &_subiter);
	if (strcmp (dbus_message_iter_get_signature (&_subiter), "s")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "s", dbus_message_iter_get_signature (&_subiter));
		dbus_message_unref (_reply);
		return NULL;
	}
	dbus_message_iter_get_basic (&_subiter, &_tmp152_);
	dbus_message_iter_next (&_subiter);
	_result = g_strdup (_tmp152_);
	dbus_message_unref (_reply);
	return _result;
}


static char* dock_item_dbus_interface_dbus_proxy_get_uri (DockItemDBusInterface* self) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter, _subiter;
	const char* _tmp153_;
	const char* _tmp154_;
	char* _result;
	const char* _tmp155_;
	if (((DockItemDBusInterfaceDBusProxy*) self)->disposed) {
		return NULL;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.freedesktop.DBus.Properties", "Get");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp153_ = "org.freedesktop.DockItem";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp153_);
	_tmp154_ = "Uri";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp154_);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s)", __FILE__, __LINE__, _dbus_error.message, _dbus_error.name);
		dbus_error_free (&_dbus_error);
		return NULL;
	}
	if (strcmp (dbus_message_get_signature (_reply), "v")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "v", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return NULL;
	}
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_recurse (&_iter, &_subiter);
	if (strcmp (dbus_message_iter_get_signature (&_subiter), "s")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "s", dbus_message_iter_get_signature (&_subiter));
		dbus_message_unref (_reply);
		return NULL;
	}
	dbus_message_iter_get_basic (&_subiter, &_tmp155_);
	dbus_message_iter_next (&_subiter);
	_result = g_strdup (_tmp155_);
	dbus_message_unref (_reply);
	return _result;
}


static void dock_item_dbus_interface_dbus_proxy_dock_item_dbus_interface__interface_init (DockItemDBusInterfaceIface* iface) {
	iface->add_menu_item = dock_item_dbus_interface_dbus_proxy_add_menu_item;
	iface->remove_menu_item = dock_item_dbus_interface_dbus_proxy_remove_menu_item;
	iface->update_dock_item = dock_item_dbus_interface_dbus_proxy_update_dock_item;
	iface->get_desktop_file = dock_item_dbus_interface_dbus_proxy_get_desktop_file;
	iface->get_uri = dock_item_dbus_interface_dbus_proxy_get_uri;
}


static void dock_item_dbus_interface_dbus_proxy_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
}


static void dock_item_dbus_interface_dbus_proxy_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
}


TaskManagerDispatcher* task_manager_dispatcher_construct (GType object_type, TaskManager* manager) {
	GError * _inner_error_;
	TaskManagerDispatcher * self;
	DBusGConnection* conn;
	char* obj_path;
	g_return_val_if_fail (manager != NULL, NULL);
	_inner_error_ = NULL;
	self = (TaskManagerDispatcher*) g_object_new (object_type, "manager", manager, NULL);
	conn = dbus_g_bus_get (DBUS_BUS_SESSION, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	obj_path = g_strdup ("/org/freedesktop/DockManager");
	_vala_dbus_register_object (dbus_g_connection_get_connection (conn), obj_path, (GObject*) self);
	_dbus_g_connection_unref0 (conn);
	_g_free0 (obj_path);
	return self;
}


TaskManagerDispatcher* task_manager_dispatcher_new (TaskManager* manager) {
	return task_manager_dispatcher_construct (TYPE_TASK_MANAGER_DISPATCHER, manager);
}


static char** task_manager_dispatcher_list_to_object_path_array (GSList* list, int* result_length1) {
	char** result = NULL;
	char** _tmp1_;
	gint __result__size_;
	gint _result__length1;
	gint _tmp0_;
	char** _result_;
	gint i;
	char** _tmp5_;
	_result_ = (_tmp1_ = g_new0 (char*, (_tmp0_ = g_slist_length (list)) + 1), _result__length1 = _tmp0_, __result__size_ = _result__length1, _tmp1_);
	i = 0;
	{
		GSList* icon_collection;
		GSList* icon_it;
		icon_collection = list;
		for (icon_it = icon_collection; icon_it != NULL; icon_it = icon_it->next) {
			TaskIcon* icon;
			icon = (TaskIcon*) icon_it->data;
			{
				TaskIconDispatcher* dispatcher;
				GObject* _tmp2_;
				char* _tmp4_;
				char* *_tmp3_;
				dispatcher = NULL;
				dispatcher = (_tmp2_ = task_icon_get_dbus_dispatcher (icon), IS_TASK_ICON_DISPATCHER (_tmp2_) ? ((TaskIconDispatcher*) _tmp2_) : NULL);
				_tmp3_ = &_result_[i++];
				(*_tmp3_) = (_tmp4_ = g_strdup (task_icon_dispatcher_get_object_path (dispatcher)), _g_free0 ((*_tmp3_)), _tmp4_);
			}
		}
	}
	result = (_tmp5_ = _result_, *result_length1 = _result__length1, _tmp5_);
	return result;
	_result_ = (_vala_array_free (_result_, _result__length1, (GDestroyNotify) g_free), NULL);
}


static char** task_manager_dispatcher_real_get_capabilities (DockManagerDBusInterface* base, int* result_length1, GError** error) {
	TaskManagerDispatcher * self;
	char** result = NULL;
	char** _tmp1_;
	gint _capabilities_size_;
	gint capabilities_length1;
	char** _tmp0_ = NULL;
	char** capabilities;
	char** _tmp2_;
	self = (TaskManagerDispatcher*) base;
	capabilities = (_tmp1_ = (_tmp0_ = g_new0 (char*, 8 + 1), _tmp0_[0] = g_strdup ("dock-item-badge"), _tmp0_[1] = g_strdup ("dock-item-message"), _tmp0_[2] = g_strdup ("dock-item-progress"), _tmp0_[3] = g_strdup ("dock-item-icon-file"), _tmp0_[4] = g_strdup ("menu-item-with-label"), _tmp0_[5] = g_strdup ("menu-item-icon-name"), _tmp0_[6] = g_strdup ("menu-item-icon-file"), _tmp0_[7] = g_strdup ("x-awn-set-visibility"), _tmp0_), capabilities_length1 = 8, _capabilities_size_ = capabilities_length1, _tmp1_);
	result = (_tmp2_ = capabilities, *result_length1 = capabilities_length1, _tmp2_);
	return result;
	capabilities = (_vala_array_free (capabilities, capabilities_length1, (GDestroyNotify) g_free), NULL);
}


static char** task_manager_dispatcher_real_get_items (DockManagerDBusInterface* base, int* result_length1, GError** error) {
	TaskManagerDispatcher * self;
	char** result = NULL;
	gint _tmp0_;
	char** _tmp1_;
	self = (TaskManagerDispatcher*) base;
	result = (_tmp1_ = task_manager_dispatcher_list_to_object_path_array (task_manager_get_icons (self->priv->_manager), &_tmp0_), *result_length1 = _tmp0_, _tmp1_);
	return result;
}


static char** task_manager_dispatcher_real_get_items_by_name (DockManagerDBusInterface* base, const char* name, int* result_length1, GError** error) {
	TaskManagerDispatcher * self;
	char** result = NULL;
	GSList* icons;
	GSList* matches;
	gint _tmp1_;
	char** _tmp2_;
	self = (TaskManagerDispatcher*) base;
	g_return_val_if_fail (name != NULL, NULL);
	icons = task_manager_get_icons (self->priv->_manager);
	matches = NULL;
	{
		GSList* icon_collection;
		GSList* icon_it;
		icon_collection = icons;
		for (icon_it = icon_collection; icon_it != NULL; icon_it = icon_it->next) {
			TaskIcon* icon;
			icon = (TaskIcon*) icon_it->data;
			{
				{
					GSList* item_collection;
					GSList* item_it;
					item_collection = task_icon_get_items (icon);
					for (item_it = item_collection; item_it != NULL; item_it = item_it->next) {
						TaskItem* item;
						item = (TaskItem*) item_it->data;
						{
							TaskItem* _tmp0_;
							TaskWindow* window;
							window = (_tmp0_ = item, TASK_IS_WINDOW (_tmp0_) ? ((TaskWindow*) _tmp0_) : NULL);
							if (window != NULL) {
								if (task_window_matches_wmclass (window, name)) {
									matches = g_slist_append (matches, icon);
									break;
								}
							}
						}
					}
				}
			}
		}
	}
	result = (_tmp2_ = task_manager_dispatcher_list_to_object_path_array (matches, &_tmp1_), *result_length1 = _tmp1_, _tmp2_);
	_g_slist_free0 (matches);
	return result;
	_g_slist_free0 (matches);
}


static char** task_manager_dispatcher_real_get_items_by_desktop_file (DockManagerDBusInterface* base, const char* desktop_file, int* result_length1, GError** error) {
	TaskManagerDispatcher * self;
	char** result = NULL;
	GSList* icons;
	GSList* matches;
	gint _tmp1_;
	char** _tmp2_;
	self = (TaskManagerDispatcher*) base;
	g_return_val_if_fail (desktop_file != NULL, NULL);
	icons = task_manager_get_icons (self->priv->_manager);
	matches = NULL;
	{
		GSList* icon_collection;
		GSList* icon_it;
		icon_collection = icons;
		for (icon_it = icon_collection; icon_it != NULL; icon_it = icon_it->next) {
			TaskIcon* icon;
			icon = (TaskIcon*) icon_it->data;
			{
				TaskItem* _tmp0_;
				TaskLauncher* launcher;
				launcher = (_tmp0_ = task_icon_get_launcher (icon), TASK_IS_LAUNCHER (_tmp0_) ? ((TaskLauncher*) _tmp0_) : NULL);
				if (launcher != NULL) {
					if (g_str_has_suffix (task_launcher_get_desktop_path (launcher), desktop_file)) {
						matches = g_slist_append (matches, icon);
					}
				}
			}
		}
	}
	result = (_tmp2_ = task_manager_dispatcher_list_to_object_path_array (matches, &_tmp1_), *result_length1 = _tmp1_, _tmp2_);
	_g_slist_free0 (matches);
	return result;
	_g_slist_free0 (matches);
}


static char** task_manager_dispatcher_real_get_items_by_pid (DockManagerDBusInterface* base, gint pid, int* result_length1, GError** error) {
	TaskManagerDispatcher * self;
	char** result = NULL;
	GSList* icons;
	GSList* matches;
	gint _tmp1_;
	char** _tmp2_;
	self = (TaskManagerDispatcher*) base;
	icons = task_manager_get_icons (self->priv->_manager);
	matches = NULL;
	{
		GSList* icon_collection;
		GSList* icon_it;
		icon_collection = icons;
		for (icon_it = icon_collection; icon_it != NULL; icon_it = icon_it->next) {
			TaskIcon* icon;
			icon = (TaskIcon*) icon_it->data;
			{
				{
					GSList* item_collection;
					GSList* item_it;
					item_collection = task_icon_get_items (icon);
					for (item_it = item_collection; item_it != NULL; item_it = item_it->next) {
						TaskItem* item;
						item = (TaskItem*) item_it->data;
						{
							if (TASK_IS_WINDOW (item)) {
								TaskItem* _tmp0_;
								TaskWindow* window;
								window = (_tmp0_ = item, TASK_IS_WINDOW (_tmp0_) ? ((TaskWindow*) _tmp0_) : NULL);
								if (task_window_get_pid (window) == pid) {
									matches = g_slist_append (matches, icon);
									break;
								}
							}
						}
					}
				}
			}
		}
	}
	result = (_tmp2_ = task_manager_dispatcher_list_to_object_path_array (matches, &_tmp1_), *result_length1 = _tmp1_, _tmp2_);
	_g_slist_free0 (matches);
	return result;
	_g_slist_free0 (matches);
}


static char* task_manager_dispatcher_real_get_item_by_xid (DockManagerDBusInterface* base, gint64 xid, GError** error) {
	TaskManagerDispatcher * self;
	char* result = NULL;
	TaskIcon* icon;
	self = (TaskManagerDispatcher*) base;
	icon = task_manager_get_icon_by_xid (self->priv->_manager, xid);
	if (icon != NULL) {
		TaskIconDispatcher* dispatcher;
		GObject* _tmp0_;
		dispatcher = NULL;
		dispatcher = (_tmp0_ = task_icon_get_dbus_dispatcher (icon), IS_TASK_ICON_DISPATCHER (_tmp0_) ? ((TaskIconDispatcher*) _tmp0_) : NULL);
		result = g_strdup (task_icon_dispatcher_get_object_path (dispatcher));
		return result;
	}
	result = NULL;
	return result;
}


static void task_manager_dispatcher_real_awn_set_visibility (DockManagerDBusInterface* base, const char* win_name, gboolean visible, GError** error) {
	TaskManagerDispatcher * self;
	GError * _inner_error_;
	GHashTable* hints;
	GHashTable* _tmp0_;
	GValue* _tmp1_ = NULL;
	GValue _tmp3_;
	GValue _tmp2_ = {0};
	self = (TaskManagerDispatcher*) base;
	g_return_if_fail (win_name != NULL);
	_inner_error_ = NULL;
	hints = NULL;
	hints = (_tmp0_ = g_hash_table_new (g_str_hash, g_str_equal), _g_hash_table_unref0 (hints), _tmp0_);
	g_hash_table_insert (hints, g_strdup ("visible"), (_tmp1_ = g_new0 (GValue, 1), g_value_init (_tmp1_, G_TYPE_BOOLEAN), g_value_set_boolean (_tmp1_, visible), _tmp1_));
	task_manager_update (self->priv->_manager, (_tmp3_ = (g_value_init (&_tmp2_, G_TYPE_STRING), g_value_set_string (&_tmp2_, win_name), _tmp2_), &_tmp3_), hints, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == DBUS_GERROR) {
			g_propagate_error (error, _inner_error_);
			_g_hash_table_unref0 (hints);
			return;
		} else {
			_g_hash_table_unref0 (hints);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_g_hash_table_unref0 (hints);
}


static char* task_manager_dispatcher_real_awn_register_proxy_item (DockManagerDBusInterface* base, const char* desktop_file, const char* uri, GError** error) {
	TaskManagerDispatcher * self;
	char* result = NULL;
	self = (TaskManagerDispatcher*) base;
	g_return_val_if_fail (desktop_file != NULL, NULL);
	g_return_val_if_fail (uri != NULL, NULL);
	result = g_strdup ("/not/yet/implemented");
	return result;
}


TaskManager* task_manager_dispatcher_get_manager (TaskManagerDispatcher* self) {
	TaskManager* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_manager;
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void task_manager_dispatcher_set_manager (TaskManagerDispatcher* self, TaskManager* value) {
	TaskManager* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_manager = (_tmp0_ = _g_object_ref0 (value), _g_object_unref0 (self->priv->_manager), _tmp0_);
	g_object_notify ((GObject *) self, "manager");
}


void _task_manager_dispatcher_dbus_unregister (DBusConnection* connection, void* _user_data_) {
}


static DBusHandlerResult _dbus_task_manager_dispatcher_introspect (TaskManagerDispatcher* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessage* reply;
	DBusMessageIter iter;
	GString* xml_data;
	char** children;
	int i;
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	xml_data = g_string_new ("<!DOCTYPE node PUBLIC \"-//freedesktop//DTD D-BUS Object Introspection 1.0//EN\" \"http://www.freedesktop.org/standards/dbus/1.0/introspect.dtd\">\n");
	g_string_append (xml_data, "<node>\n<interface name=\"org.freedesktop.DBus.Introspectable\">\n  <method name=\"Introspect\">\n    <arg name=\"data\" direction=\"out\" type=\"s\"/>\n  </method>\n</interface>\n<interface name=\"org.freedesktop.DBus.Properties\">\n  <method name=\"Get\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"propname\" direction=\"in\" type=\"s\"/>\n    <arg name=\"value\" direction=\"out\" type=\"v\"/>\n  </method>\n  <method name=\"Set\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"propname\" direction=\"in\" type=\"s\"/>\n    <arg name=\"value\" direction=\"in\" type=\"v\"/>\n  </method>\n  <method name=\"GetAll\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"props\" direction=\"out\" type=\"a{sv}\"/>\n  </method>\n</interface>\n<interface name=\"org.freedesktop.DockManager\">\n  <method name=\"GetCapabilities\">\n    <arg name=\"result\" type=\"as\" direction=\"out\"/>\n  </method>\n  <method name=\"GetItems\">\n    <arg name=\"result\" type=\"ao\" direction=\"out\"/>\n  </method>\n  <method name=\"GetItemsByName\">\n    <arg name=\"name\" type=\"s\" direction=\"in\"/>\n    <arg name=\"result\" type=\"ao\" direction=\"out\"/>\n  </method>\n  <method name=\"GetItemsByDesktopFile\">\n    <arg name=\"desktop_file\" type=\"s\" direction=\"in\"/>\n    <arg name=\"result\" type=\"ao\" direction=\"out\"/>\n  </method>\n  <method name=\"GetItemsByPid\">\n    <arg name=\"pid\" type=\"i\" direction=\"in\"/>\n    <arg name=\"result\" type=\"ao\" direction=\"out\"/>\n  </method>\n  <method name=\"GetItemByXid\">\n    <arg name=\"xid\" type=\"x\" direction=\"in\"/>\n    <arg name=\"result\" type=\"o\" direction=\"out\"/>\n  </method>\n  <method name=\"AwnSetVisibility\">\n    <arg name=\"win_name\" type=\"s\" direction=\"in\"/>\n    <arg name=\"visible\" type=\"b\" direction=\"in\"/>\n  </method>\n  <method name=\"AwnRegisterProxyItem\">\n    <arg name=\"desktop_file\" type=\"s\" direction=\"in\"/>\n    <arg name=\"uri\" type=\"s\" direction=\"in\"/>\n    <arg name=\"result\" type=\"o\" direction=\"out\"/>\n  </method>\n  <signal name=\"ItemAdded\">\n    <arg name=\"path\" type=\"o\"/>\n  </signal>\n  <signal name=\"ItemRemoved\">\n    <arg name=\"path\" type=\"o\"/>\n  </signal>\n</interface>\n");
	dbus_connection_list_registered (connection, g_object_get_data ((GObject *) self, "dbus_object_path"), &children);
	for (i = 0; children[i]; i++) {
		g_string_append_printf (xml_data, "<node name=\"%s\"/>\n", children[i]);
	}
	dbus_free_string_array (children);
	g_string_append (xml_data, "</node>\n");
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_STRING, &xml_data->str);
	g_string_free (xml_data, TRUE);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


DBusHandlerResult task_manager_dispatcher_dbus_message (DBusConnection* connection, DBusMessage* message, void* object) {
	DBusHandlerResult result;
	result = DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	if (dbus_message_is_method_call (message, "org.freedesktop.DBus.Introspectable", "Introspect")) {
		result = _dbus_task_manager_dispatcher_introspect (object, connection, message);
	}
	if (result == DBUS_HANDLER_RESULT_HANDLED) {
		return result;
	} else if (dock_manager_dbus_interface_dbus_message (connection, message, object) == DBUS_HANDLER_RESULT_HANDLED) {
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


void task_manager_dispatcher_dbus_register_object (DBusConnection* connection, const char* path, void* object) {
	if (!g_object_get_data (object, "dbus_object_path")) {
		g_object_set_data (object, "dbus_object_path", g_strdup (path));
		dbus_connection_register_object_path (connection, path, &_task_manager_dispatcher_dbus_path_vtable, object);
		g_object_weak_ref (object, _vala_dbus_unregister_object, connection);
	}
	dock_manager_dbus_interface_dbus_register_object (connection, path, object);
}


static void task_manager_dispatcher_class_init (TaskManagerDispatcherClass * klass) {
	task_manager_dispatcher_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (TaskManagerDispatcherPrivate));
	G_OBJECT_CLASS (klass)->get_property = task_manager_dispatcher_get_property;
	G_OBJECT_CLASS (klass)->set_property = task_manager_dispatcher_set_property;
	G_OBJECT_CLASS (klass)->finalize = task_manager_dispatcher_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), TASK_MANAGER_DISPATCHER_MANAGER, g_param_spec_object ("manager", "manager", "manager", TASK_TYPE_MANAGER, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_type_set_qdata (TYPE_TASK_MANAGER_DISPATCHER, g_quark_from_static_string ("DBusObjectVTable"), (void*) (&_task_manager_dispatcher_dbus_vtable));
}


static void task_manager_dispatcher_dock_manager_dbus_interface_interface_init (DockManagerDBusInterfaceIface * iface) {
	task_manager_dispatcher_dock_manager_dbus_interface_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_capabilities = task_manager_dispatcher_real_get_capabilities;
	iface->get_items = task_manager_dispatcher_real_get_items;
	iface->get_items_by_name = task_manager_dispatcher_real_get_items_by_name;
	iface->get_items_by_desktop_file = task_manager_dispatcher_real_get_items_by_desktop_file;
	iface->get_items_by_pid = task_manager_dispatcher_real_get_items_by_pid;
	iface->get_item_by_xid = task_manager_dispatcher_real_get_item_by_xid;
	iface->awn_set_visibility = task_manager_dispatcher_real_awn_set_visibility;
	iface->awn_register_proxy_item = task_manager_dispatcher_real_awn_register_proxy_item;
}


static void task_manager_dispatcher_instance_init (TaskManagerDispatcher * self) {
	self->priv = TASK_MANAGER_DISPATCHER_GET_PRIVATE (self);
}


static void task_manager_dispatcher_finalize (GObject* obj) {
	TaskManagerDispatcher * self;
	self = TASK_MANAGER_DISPATCHER (obj);
	_g_object_unref0 (self->priv->_manager);
	G_OBJECT_CLASS (task_manager_dispatcher_parent_class)->finalize (obj);
}


GType task_manager_dispatcher_get_type (void) {
	static volatile gsize task_manager_dispatcher_type_id__volatile = 0;
	if (g_once_init_enter (&task_manager_dispatcher_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TaskManagerDispatcherClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) task_manager_dispatcher_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TaskManagerDispatcher), 0, (GInstanceInitFunc) task_manager_dispatcher_instance_init, NULL };
		static const GInterfaceInfo dock_manager_dbus_interface_info = { (GInterfaceInitFunc) task_manager_dispatcher_dock_manager_dbus_interface_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType task_manager_dispatcher_type_id;
		task_manager_dispatcher_type_id = g_type_register_static (G_TYPE_OBJECT, "TaskManagerDispatcher", &g_define_type_info, 0);
		g_type_add_interface_static (task_manager_dispatcher_type_id, TYPE_DOCK_MANAGER_DBUS_INTERFACE, &dock_manager_dbus_interface_info);
		g_once_init_leave (&task_manager_dispatcher_type_id__volatile, task_manager_dispatcher_type_id);
	}
	return task_manager_dispatcher_type_id__volatile;
}


static void task_manager_dispatcher_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	TaskManagerDispatcher * self;
	self = TASK_MANAGER_DISPATCHER (object);
	switch (property_id) {
		case TASK_MANAGER_DISPATCHER_MANAGER:
		g_value_set_object (value, task_manager_dispatcher_get_manager (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void task_manager_dispatcher_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	TaskManagerDispatcher * self;
	self = TASK_MANAGER_DISPATCHER (object);
	switch (property_id) {
		case TASK_MANAGER_DISPATCHER_MANAGER:
		task_manager_dispatcher_set_manager (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


TaskIconDispatcher* task_icon_dispatcher_construct (GType object_type, TaskIcon* icon) {
	GError * _inner_error_;
	TaskIconDispatcher * self;
	DBusGConnection* conn;
	char* _tmp0_;
	g_return_val_if_fail (icon != NULL, NULL);
	_inner_error_ = NULL;
	self = (TaskIconDispatcher*) g_object_new (object_type, NULL);
	self->priv->icon = icon;
	conn = dbus_g_bus_get (DBUS_BUS_SESSION, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	task_icon_dispatcher_set_object_path (self, _tmp0_ = g_strdup_printf ("/org/freedesktop/DockManager/Item%d", task_icon_dispatcher_counter++));
	_g_free0 (_tmp0_);
	_vala_dbus_register_object (dbus_g_connection_get_connection (conn), self->priv->_object_path, (GObject*) self);
	task_icon_dispatcher_emit_item_added (self);
	_dbus_g_connection_unref0 (conn);
	return self;
}


TaskIconDispatcher* task_icon_dispatcher_new (TaskIcon* icon) {
	return task_icon_dispatcher_construct (TYPE_TASK_ICON_DISPATCHER, icon);
}


static TaskManagerDispatcher* task_icon_dispatcher_get_manager_proxy (TaskIconDispatcher* self) {
	TaskManagerDispatcher* result = NULL;
	TaskManagerDispatcher* proxy;
	AwnApplet* _tmp0_;
	TaskManager* manager;
	GObject* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	proxy = NULL;
	manager = (_tmp0_ = task_icon_get_applet (self->priv->icon), TASK_IS_MANAGER (_tmp0_) ? ((TaskManager*) _tmp0_) : NULL);
	proxy = (_tmp1_ = task_manager_get_dbus_dispatcher (manager), IS_TASK_MANAGER_DISPATCHER (_tmp1_) ? ((TaskManagerDispatcher*) _tmp1_) : NULL);
	result = proxy;
	return result;
}


static void task_icon_dispatcher_emit_item_added (TaskIconDispatcher* self) {
	TaskManagerDispatcher* proxy;
	g_return_if_fail (self != NULL);
	proxy = task_icon_dispatcher_get_manager_proxy (self);
	if (proxy != NULL) {
		char* _tmp0_;
		g_signal_emit_by_name ((DockManagerDBusInterface*) proxy, "item-added", _tmp0_ = g_strdup (self->priv->_object_path));
		_g_free0 (_tmp0_);
	}
}


static void _lambda0_ (GtkMenuItem* w, Block1Data* _data1_) {
	TaskIconDispatcher * self;
	self = _data1_->self;
	g_return_if_fail (w != NULL);
	g_signal_emit_by_name ((DockItemDBusInterface*) self, "menu-item-activated", _data1_->id);
}


static void __lambda0__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	_lambda0_ (_sender, self);
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
	++_data1_->_ref_count_;
	return _data1_;
}


static void block1_data_unref (Block1Data* _data1_) {
	if ((--_data1_->_ref_count_) == 0) {
		_g_object_unref0 (_data1_->self);
		g_slice_free (Block1Data, _data1_);
	}
}


static gint task_icon_dispatcher_real_add_menu_item (DockItemDBusInterface* base, GHashTable* menu_hints, GError** error) {
	TaskIconDispatcher * self;
	gint result = 0;
	GtkImageMenuItem* item;
	GtkImage* image;
	GHashTableIter iter = {0};
	const char* key;
	GValue* value = NULL;
	self = (TaskIconDispatcher*) base;
	g_return_val_if_fail (menu_hints != NULL, 0);
	item = NULL;
	image = NULL;
	g_hash_table_iter_init (&iter, menu_hints);
	key = NULL;
	while (TRUE) {
		if (!g_hash_table_iter_next (&iter, &key, &value)) {
			break;
		}
		if (_vala_strcmp0 (key, "label") == 0) {
			GtkImageMenuItem* _tmp0_;
			item = (_tmp0_ = g_object_ref_sink ((GtkImageMenuItem*) gtk_image_menu_item_new_with_label (g_value_get_string (value))), _g_object_unref0 (item), _tmp0_);
		} else {
			if (_vala_strcmp0 (key, "icon-name") == 0) {
				GtkImage* _tmp1_;
				image = (_tmp1_ = g_object_ref_sink ((GtkImage*) gtk_image_new_from_icon_name (g_value_get_string (value), GTK_ICON_SIZE_MENU)), _g_object_unref0 (image), _tmp1_);
			} else {
				if (_vala_strcmp0 (key, "icon-file") == 0) {
					GtkImage* _tmp2_;
					image = (_tmp2_ = g_object_ref_sink ((GtkImage*) gtk_image_new_from_file (g_value_get_string (value))), _g_object_unref0 (image), _tmp2_);
				} else {
					if (_vala_strcmp0 (key, "uri") == 0) {
					}
				}
			}
		}
	}
	if (item != NULL) {
		Block1Data* _data1_;
		_data1_ = g_slice_new0 (Block1Data);
		_data1_->_ref_count_ = 1;
		_data1_->self = g_object_ref (self);
		if (image != NULL) {
			gtk_image_menu_item_set_image (item, (GtkWidget*) image);
		}
		_data1_->id = task_icon_add_menu_item (self->priv->icon, (GtkMenuItem*) item);
		gtk_widget_show ((GtkWidget*) item);
		g_signal_connect_data ((GtkMenuItem*) item, "activate", (GCallback) __lambda0__gtk_menu_item_activate, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
		result = _data1_->id;
		block1_data_unref (_data1_);
		_g_object_unref0 (item);
		_g_object_unref0 (image);
		return result;
	}
	result = 0;
	_g_object_unref0 (item);
	_g_object_unref0 (image);
	return result;
}


static void task_icon_dispatcher_real_remove_menu_item (DockItemDBusInterface* base, gint id, GError** error) {
	TaskIconDispatcher * self;
	self = (TaskIconDispatcher*) base;
	task_icon_remove_menu_item (self->priv->icon, id);
}


static void task_icon_dispatcher_real_update_dock_item (DockItemDBusInterface* base, GHashTable* hints, GError** error) {
	TaskIconDispatcher * self;
	GHashTableIter iter = {0};
	const char* key;
	GValue* value = NULL;
	self = (TaskIconDispatcher*) base;
	g_return_if_fail (hints != NULL);
	g_hash_table_iter_init (&iter, hints);
	key = NULL;
	while (TRUE) {
		GSList* items;
		if (!g_hash_table_iter_next (&iter, &key, &value)) {
			break;
		}
		items = task_icon_get_items (self->priv->icon);
		{
			GSList* item_collection;
			GSList* item_it;
			item_collection = items;
			for (item_it = item_collection; item_it != NULL; item_it = item_it->next) {
				TaskItem* item;
				item = (TaskItem*) item_it->data;
				{
					if (TASK_IS_LAUNCHER (item)) {
						continue;
					}
					task_item_update_overlay (item, key, value);
				}
			}
		}
	}
}


const char* task_icon_dispatcher_get_object_path (TaskIconDispatcher* self) {
	const char* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_object_path;
	return result;
}


void task_icon_dispatcher_set_object_path (TaskIconDispatcher* self, const char* value) {
	char* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_object_path = (_tmp0_ = g_strdup (value), _g_free0 (self->priv->_object_path), _tmp0_);
	g_object_notify ((GObject *) self, "object-path");
}


static char* string_replace (const char* self, const char* old, const char* replacement) {
	char* result = NULL;
	GError * _inner_error_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	_inner_error_ = NULL;
	{
		char* _tmp0_;
		GRegex* _tmp1_;
		GRegex* regex;
		char* _tmp2_;
		regex = (_tmp1_ = g_regex_new (_tmp0_ = g_regex_escape_string (old, -1), 0, 0, &_inner_error_), _g_free0 (_tmp0_), _tmp1_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp2_ = g_regex_replace_literal (regex, self, (gssize) (-1), 0, replacement, 0, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_regex_unref0 (regex);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		result = _tmp2_;
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			g_assert_not_reached ();
			_g_error_free0 (e);
		}
	}
	__finally0:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


static char* task_icon_dispatcher_real_get_desktop_file (DockItemDBusInterface* base) {
	char* result;
	TaskIconDispatcher* self;
	char* path;
	TaskLauncher* launcher;
	TaskItem* _tmp0_;
	self = (TaskIconDispatcher*) base;
	path = g_strdup ("");
	launcher = NULL;
	launcher = (_tmp0_ = task_icon_get_launcher (self->priv->icon), TASK_IS_LAUNCHER (_tmp0_) ? ((TaskLauncher*) _tmp0_) : NULL);
	if (launcher != NULL) {
		char* _tmp1_;
		char* _tmp2_;
		path = (_tmp1_ = g_strdup (task_launcher_get_desktop_path (launcher)), _g_free0 (path), _tmp1_);
		path = (_tmp2_ = string_replace (path, "//", "/"), _g_free0 (path), _tmp2_);
	}
	result = path;
	return result;
}


static char* task_icon_dispatcher_real_get_uri (DockItemDBusInterface* base) {
	char* result;
	TaskIconDispatcher* self;
	self = (TaskIconDispatcher*) base;
	result = g_strdup ("");
	return result;
}


void _task_icon_dispatcher_dbus_unregister (DBusConnection* connection, void* _user_data_) {
}


static DBusHandlerResult _dbus_task_icon_dispatcher_introspect (TaskIconDispatcher* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessage* reply;
	DBusMessageIter iter;
	GString* xml_data;
	char** children;
	int i;
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	xml_data = g_string_new ("<!DOCTYPE node PUBLIC \"-//freedesktop//DTD D-BUS Object Introspection 1.0//EN\" \"http://www.freedesktop.org/standards/dbus/1.0/introspect.dtd\">\n");
	g_string_append (xml_data, "<node>\n<interface name=\"org.freedesktop.DBus.Introspectable\">\n  <method name=\"Introspect\">\n    <arg name=\"data\" direction=\"out\" type=\"s\"/>\n  </method>\n</interface>\n<interface name=\"org.freedesktop.DBus.Properties\">\n  <method name=\"Get\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"propname\" direction=\"in\" type=\"s\"/>\n    <arg name=\"value\" direction=\"out\" type=\"v\"/>\n  </method>\n  <method name=\"Set\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"propname\" direction=\"in\" type=\"s\"/>\n    <arg name=\"value\" direction=\"in\" type=\"v\"/>\n  </method>\n  <method name=\"GetAll\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"props\" direction=\"out\" type=\"a{sv}\"/>\n  </method>\n</interface>\n<interface name=\"org.freedesktop.DockItem\">\n  <method name=\"AddMenuItem\">\n    <arg name=\"menu_hints\" type=\"a{sv}\" direction=\"in\"/>\n    <arg name=\"result\" type=\"i\" direction=\"out\"/>\n  </method>\n  <method name=\"RemoveMenuItem\">\n    <arg name=\"id\" type=\"i\" direction=\"in\"/>\n  </method>\n  <method name=\"UpdateDockItem\">\n    <arg name=\"hints\" type=\"a{sv}\" direction=\"in\"/>\n  </method>\n  <property name=\"DesktopFile\" type=\"s\" access=\"read\"/>\n  <property name=\"Uri\" type=\"s\" access=\"read\"/>\n  <signal name=\"MenuItemActivated\">\n    <arg name=\"id\" type=\"i\"/>\n  </signal>\n</interface>\n");
	dbus_connection_list_registered (connection, g_object_get_data ((GObject *) self, "dbus_object_path"), &children);
	for (i = 0; children[i]; i++) {
		g_string_append_printf (xml_data, "<node name=\"%s\"/>\n", children[i]);
	}
	dbus_free_string_array (children);
	g_string_append (xml_data, "</node>\n");
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_STRING, &xml_data->str);
	g_string_free (xml_data, TRUE);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


DBusHandlerResult task_icon_dispatcher_dbus_message (DBusConnection* connection, DBusMessage* message, void* object) {
	DBusHandlerResult result;
	result = DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	if (dbus_message_is_method_call (message, "org.freedesktop.DBus.Introspectable", "Introspect")) {
		result = _dbus_task_icon_dispatcher_introspect (object, connection, message);
	}
	if (result == DBUS_HANDLER_RESULT_HANDLED) {
		return result;
	} else if (dock_item_dbus_interface_dbus_message (connection, message, object) == DBUS_HANDLER_RESULT_HANDLED) {
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


void task_icon_dispatcher_dbus_register_object (DBusConnection* connection, const char* path, void* object) {
	if (!g_object_get_data (object, "dbus_object_path")) {
		g_object_set_data (object, "dbus_object_path", g_strdup (path));
		dbus_connection_register_object_path (connection, path, &_task_icon_dispatcher_dbus_path_vtable, object);
		g_object_weak_ref (object, _vala_dbus_unregister_object, connection);
	}
	dock_item_dbus_interface_dbus_register_object (connection, path, object);
}


static void task_icon_dispatcher_class_init (TaskIconDispatcherClass * klass) {
	task_icon_dispatcher_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (TaskIconDispatcherPrivate));
	G_OBJECT_CLASS (klass)->get_property = task_icon_dispatcher_get_property;
	G_OBJECT_CLASS (klass)->set_property = task_icon_dispatcher_set_property;
	G_OBJECT_CLASS (klass)->finalize = task_icon_dispatcher_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), TASK_ICON_DISPATCHER_OBJECT_PATH, g_param_spec_string ("object-path", "object-path", "object-path", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_override_property (G_OBJECT_CLASS (klass), TASK_ICON_DISPATCHER_DESKTOP_FILE, "desktop-file");
	g_object_class_override_property (G_OBJECT_CLASS (klass), TASK_ICON_DISPATCHER_URI, "uri");
	g_type_set_qdata (TYPE_TASK_ICON_DISPATCHER, g_quark_from_static_string ("DBusObjectVTable"), (void*) (&_task_icon_dispatcher_dbus_vtable));
}


static void task_icon_dispatcher_dock_item_dbus_interface_interface_init (DockItemDBusInterfaceIface * iface) {
	task_icon_dispatcher_dock_item_dbus_interface_parent_iface = g_type_interface_peek_parent (iface);
	iface->add_menu_item = task_icon_dispatcher_real_add_menu_item;
	iface->remove_menu_item = task_icon_dispatcher_real_remove_menu_item;
	iface->update_dock_item = task_icon_dispatcher_real_update_dock_item;
	iface->get_desktop_file = task_icon_dispatcher_real_get_desktop_file;
	iface->get_uri = task_icon_dispatcher_real_get_uri;
}


static void task_icon_dispatcher_instance_init (TaskIconDispatcher * self) {
	self->priv = TASK_ICON_DISPATCHER_GET_PRIVATE (self);
}


static void task_icon_dispatcher_finalize (GObject* obj) {
	TaskIconDispatcher * self;
	self = TASK_ICON_DISPATCHER (obj);
	{
		TaskManagerDispatcher* proxy;
		proxy = task_icon_dispatcher_get_manager_proxy (self);
		if (proxy != NULL) {
			char* _tmp156_;
			g_signal_emit_by_name ((DockManagerDBusInterface*) proxy, "item-removed", _tmp156_ = g_strdup (self->priv->_object_path));
			_g_free0 (_tmp156_);
		}
	}
	_g_free0 (self->priv->_object_path);
	G_OBJECT_CLASS (task_icon_dispatcher_parent_class)->finalize (obj);
}


GType task_icon_dispatcher_get_type (void) {
	static volatile gsize task_icon_dispatcher_type_id__volatile = 0;
	if (g_once_init_enter (&task_icon_dispatcher_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TaskIconDispatcherClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) task_icon_dispatcher_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TaskIconDispatcher), 0, (GInstanceInitFunc) task_icon_dispatcher_instance_init, NULL };
		static const GInterfaceInfo dock_item_dbus_interface_info = { (GInterfaceInitFunc) task_icon_dispatcher_dock_item_dbus_interface_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType task_icon_dispatcher_type_id;
		task_icon_dispatcher_type_id = g_type_register_static (G_TYPE_OBJECT, "TaskIconDispatcher", &g_define_type_info, 0);
		g_type_add_interface_static (task_icon_dispatcher_type_id, TYPE_DOCK_ITEM_DBUS_INTERFACE, &dock_item_dbus_interface_info);
		g_once_init_leave (&task_icon_dispatcher_type_id__volatile, task_icon_dispatcher_type_id);
	}
	return task_icon_dispatcher_type_id__volatile;
}


static void task_icon_dispatcher_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	TaskIconDispatcher * self;
	self = TASK_ICON_DISPATCHER (object);
	switch (property_id) {
		case TASK_ICON_DISPATCHER_OBJECT_PATH:
		g_value_set_string (value, task_icon_dispatcher_get_object_path (self));
		break;
		case TASK_ICON_DISPATCHER_DESKTOP_FILE:
		g_value_take_string (value, dock_item_dbus_interface_get_desktop_file ((DockItemDBusInterface*) self));
		break;
		case TASK_ICON_DISPATCHER_URI:
		g_value_take_string (value, dock_item_dbus_interface_get_uri ((DockItemDBusInterface*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void task_icon_dispatcher_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	TaskIconDispatcher * self;
	self = TASK_ICON_DISPATCHER (object);
	switch (property_id) {
		case TASK_ICON_DISPATCHER_OBJECT_PATH:
		task_icon_dispatcher_set_object_path (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}


static void _vala_dbus_register_object (DBusConnection* connection, const char* path, void* object) {
	const _DBusObjectVTable * vtable;
	vtable = g_type_get_qdata (G_TYPE_FROM_INSTANCE (object), g_quark_from_static_string ("DBusObjectVTable"));
	if (vtable) {
		vtable->register_object (connection, path, object);
	} else {
		g_warning ("Object does not implement any D-Bus interface");
	}
}


static void _vala_dbus_unregister_object (gpointer connection, GObject* object) {
	char* path;
	path = g_object_steal_data ((GObject*) object, "dbus_object_path");
	dbus_connection_unregister_object_path (connection, path);
	g_free (path);
}



static void g_cclosure_user_marshal_VOID__BOXED (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__BOXED) (gpointer data1, gpointer arg_1, gpointer data2);
	register GMarshalFunc_VOID__BOXED callback;
	register GCClosure * cc;
	register gpointer data1, data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 2);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__BOXED) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_boxed (param_values + 1), data2);
}



