
#include <stdio.h>
#include <string.h>
#include <math.h>

static double inline sinc(double x)
{
    x *= M_PI;
    if(x != 0)
    {
	//printf("sinc %f => %f", x,sin(x) / x);
	return(sin(x) / x);
    }
    return(1.0);
}


#define ML 5
void resize(unsigned char* out, unsigned char* in, int outsz, int insz)
{
    double step = insz / (double)outsz;
    double x = 0;
    int y = 0;
    for (x = 0; x < insz; x += step)
    {
	double s = 0;
	int i = int(x);

	printf("%d  %d   %f -  %f  %f\n", i, in[i], step, x, s);

	for (int j = i > ML ? -ML : -i ; j < ((i + ML < insz) ? ML : insz - i); j++)
	{
	    s += sinc(-x + i + j) * in[i + j];
	    //printf("   %f   sinc: %f    %d %f\n", x - i + j, sinc(x - i + j),  j, s);
	}
	out[y++] = s;
    }
}

int main(int argc, char* argv[])
{
    int insz = 20;
    int outsz = 40;
    int msz = (insz > outsz) ? insz : outsz;
    unsigned char inb[msz];
    unsigned char outb[msz];

    memset(inb, 0, msz);
    memset(outb, 0, msz);

    for (int i = 0; i < insz; i++)
    {
	inb[i] = i;
    }

    resize(outb, inb, outsz, insz);

    for (int i = 0; i < msz; i++)
    {
        printf("%d  %d   %d\n", i, inb[i], outb[i]);
    }
}
