/* Test of atan2() function. 500 random cases.
   $Id: atan2-500.c,v 1.1 2007/02/05 21:35:58 dmix Exp $
 */
#include <math.h>
#include <stdio.h>
#include <stdlib.h>
#include "progmem.h"

union lofl_u {
    long lo;
    float fl;
};

volatile union lofl_u v = { .lo = 1 };

PROGMEM const struct {		/* Table of test cases.	*/
    long y;		/* first argument	*/
    long x;		/* second argument	*/
    long z;		/* atan2(y,x)	*/
} t[] = {

    /* y, x, atan2(y,x)	*/
    { 0xbf9d7ac2,0xbf2658d5,0xc003a12f }, /*   1: -1.2303088e+00 -6.4979297e-01 -2.0567129e+00 */
    { 0x3fdd4ebf,0xc0555b03,0x402a7104 }, /*   2:  1.7289656e+00 -3.3336799e+00  2.6631479e+00 */
    { 0xbfe3bf49,0xbf952b63,0xc009a478 }, /*   3: -1.7792751e+00 -1.1653866e+00 -2.1506634e+00 */
    { 0xbf65a6d0,0xbd2df98d,0xbfcf1e2e }, /*   4: -8.9707661e-01 -4.2474318e-02 -1.6181085e+00 */
    { 0xbf98e999,0x3fe44d1b,0xbf171493 }, /*   5: -1.1946288e+00  1.7836031e+00 -5.9015769e-01 */
    { 0xbf69511e,0x3f108be5,0xbf8210ea }, /*   6: -9.1139400e-01  5.6463462e-01 -1.0161412e+00 */
    { 0xc004c72a,0xc101c133,0xc039086d }, /*   7: -2.0746560e+00 -8.1096678e+00 -2.8911393e+00 */
    { 0xbec871b1,0xc179d1e6,0xc0477522 }, /*   8: -3.9149240e-01 -1.5613745e+01 -3.1165242e+00 */
    { 0xbf06c515,0xbf2ee63c,0xc01f0b4c }, /*   9: -5.2644473e-01 -6.8320060e-01 -2.4850645e+00 */
    { 0xbfc1d9d7,0xbf9bd6b2,0xc00fddde }, /*  10: -1.5144604e+00 -1.2174895e+00 -2.2479167e+00 */
    { 0x3f978fdb,0xbf99c0bd,0x40174176 }, /*  11:  1.1840776e+00 -1.2011944e+00  2.3633704e+00 */
    { 0x3f60bd9e,0x9cd02adc,0x3fc90fdb }, /*  12:  8.7789333e-01 -1.3775364e-21  1.5707964e+00 */
    { 0xc000443d,0x3f753766,0xbf8ffe59 }, /*  13: -2.0041649e+00  9.5787656e-01 -1.1249496e+00 */
    { 0x3c53c938,0x43011bbd,0x38d1f7c8 }, /*  14:  1.2926392e-02  1.2910835e+02  1.0012049e-04 */
    { 0x406d8359,0xc0a9d16a,0x4022013d }, /*  15:  3.7111418e+00 -5.3068132e+00  2.5313256e+00 */
    { 0xbf605b24,0x3f78726b,0xbf3c0775 }, /*  16: -8.7639070e-01  9.7049588e-01 -7.3448879e-01 */
    { 0xbfe45efa,0xc066eb99,0xc02babf6 }, /*  17: -1.7841485e+00 -3.6081297e+00 -2.6823707e+00 */
    { 0xbc733dfb,0x401d9027,0xbbc599d6 }, /*  18: -1.4846320e-02  2.4619234e+00 -6.0303016e-03 */
    { 0x3f64c72e,0x40a71342,0x3e2d96f7 }, /*  19:  8.9366424e-01  5.2211008e+00  1.6952120e-01 */
    { 0x3fee14fe,0xbf1bb09b,0x3ff182dd }, /*  20:  1.8600156e+00 -6.0816354e-01  1.8868061e+00 */
    { 0xbfe66109,0x3fe1c118,0xbf4ba84e }, /*  21: -1.7998363e+00  1.7637053e+00 -7.9553688e-01 */
    { 0x3f60850b,0x3fbb35b1,0x3f0a47f2 }, /*  22:  8.7703007e-01  1.4625760e+00  5.4016030e-01 */
    { 0xbeef51b4,0x3f8fe139,0xbec9c4cc }, /*  23: -4.6742022e-01  1.1240608e+00 -3.9407957e-01 */
    { 0x3ee17aa6,0x3ff8aab8,0x3e644542 }, /*  24:  4.4038886e-01  1.9427099e+00  2.2292045e-01 */
    { 0xbfd4d478,0xc15f2566,0xc04177b6 }, /*  25: -1.6627340e+00 -1.3946630e+01 -3.0229316e+00 */
    { 0x3f123c87,0x3ef658a7,0x3f5eec89 }, /*  26:  5.7123607e-01  4.8114511e-01  8.7079674e-01 */
    { 0xbeee2ddf,0xbede817a,0xc0149eb0 }, /*  27: -4.6519372e-01 -4.3458158e-01 -2.3221855e+00 */
    { 0xbf92638e,0x3f6d769d,0xbf63abe4 }, /*  28: -1.1436632e+00  9.2759115e-01 -8.8934159e-01 */
    { 0xbf61f36a,0x3f679c75,0xbf45e52d }, /*  29: -8.8262045e-01  9.0473109e-01 -7.7302819e-01 */
    { 0x3d2a3388,0xbe69415e,0x403d8399 }, /*  30:  4.1553050e-02 -2.2778842e-01  2.9611571e+00 */
    { 0xbeb18deb,0xbfec0ea9,0xc03d2a8b }, /*  31: -3.4678587e-01 -1.8441974e+00 -2.9557216e+00 */
    { 0x3ed61870,0xbf910049,0x40326e46 }, /*  32:  4.1815519e-01 -1.1328212e+00  2.7879806e+00 */
    { 0x3f15aa9f,0x3f3ec171,0x3f2a4fb4 }, /*  33:  5.8463472e-01  7.4513918e-01  6.6527867e-01 */
    { 0x42e0eb07,0x38e766ea,0x3fc90fd2 }, /*  34:  1.1245904e+02  1.1034108e-04  1.5707953e+00 */
    { 0x3fd8d99d,0xbe563538,0x3fd8c992 }, /*  35:  1.6941410e+00 -2.0918739e-01  1.6936514e+00 */
    { 0xbbbced01,0x3bc07c42,0xbf46ac3f }, /*  36: -5.7655578e-03  5.8741877e-03 -7.7606577e-01 */
    { 0x3c3b3354,0x3f951a78,0x3c20b32b }, /*  37:  1.1425812e-02  1.1648703e+00  9.8083420e-03 */
    { 0xc0cfe7df,0xbf710e6e,0xbfdb7c20 }, /*  38: -6.4970546e+00 -9.4162643e-01 -1.7147255e+00 */
    { 0x3fdfc061,0x40a4d0eb,0x3ea78654 }, /*  39:  1.7480584e+00  5.1505027e+00  3.2719672e-01 */
    { 0xbfce5f10,0xeb2595f1,0xc0490fdb }, /*  40: -1.6122761e+00 -2.0018084e+26 -3.1415927e+00 */
    { 0xbf2d3502,0xbebee502,0xc004c3d3 }, /*  41: -6.7659009e-01 -3.7284094e-01 -2.0744522e+00 */
    { 0x404699a7,0x3fffc3b7,0x3f7fab5d }, /*  42:  3.1031282e+00  1.9981602e+00  9.9870855e-01 */
    { 0xbcb4691e,0xbfc96caa,0xc0482a94 }, /*  43: -2.2022780e-02 -1.5736287e+00 -3.1275988e+00 */
    { 0x3f96bd85,0x41879531,0x3d8e14d8 }, /*  44:  1.1776587e+00  1.6947847e+01  6.9375694e-02 */
    { 0xbf0a6fc8,0xc0e74a0c,0xc0444851 }, /*  45: -5.4076815e-01 -7.2277889e+00 -3.0669138e+00 */
    { 0xbe9ecf09,0x3f24da02,0xbee5d351 }, /*  46: -3.1017330e-01  6.4395154e-01 -4.4887784e-01 */
    { 0x3fa0998c,0x3f637ed9,0x3f745ce8 }, /*  47:  1.2546859e+00  8.8865429e-01  9.5454264e-01 */
    { 0xbf9e3f18,0x3f6086c5,0xbf742aab }, /*  48: -1.2363005e+00  8.7705642e-01 -9.5377606e-01 */
    { 0xbf71d748,0x3f632a6a,0xbf5111d0 }, /*  49: -9.4469118e-01  8.8736594e-01 -8.1667805e-01 */
    { 0xbf6c1505,0x3f96f3f7,0xbf29e50e }, /*  50: -9.2219573e-01  1.1793202e+00 -6.6365135e-01 */
    { 0xbf96161e,0xbf0e84d3,0xc000e692 }, /*  51: -1.1725500e+00 -5.5671424e-01 -2.0140729e+00 */
    { 0xbfe1b003,0xbf684232,0xc002f207 }, /*  52: -1.7631840e+00 -9.0726006e-01 -2.0460222e+00 */
    { 0x3f967c16,0xc0213076,0x402d1c6e }, /*  53:  1.1756618e+00 -2.5185828e+00  2.7048602e+00 */
    { 0xb91d07a3,0x3c42438e,0xbc4eec12 }, /*  54: -1.4975532e-04  1.1856927e-02 -1.2629526e-02 */
    { 0x3f379720,0x3f581160,0x3f344ddc }, /*  55:  7.1714973e-01  8.4401512e-01  7.0431304e-01 */
    { 0x3f9782a4,0x3f70288a,0x3f668ec4 }, /*  56:  1.1836743e+00  9.3811858e-01  9.0061593e-01 */
    { 0x3da3f903,0xbf9a8d33,0x4044d305 }, /*  57:  8.0064796e-02 -1.2074341e+00  3.0753796e+00 */
    { 0xbff8e53d,0x3f9a7af9,0xbf81f60d }, /*  58: -1.9444958e+00  1.2068778e+00 -1.0153214e+00 */
    { 0x3fc2b7df,0x3f6cdf26,0x3f831d86 }, /*  59:  1.5212363e+00  9.2527997e-01  1.0243385e+00 */
    { 0xbf9bf79b,0x4009afd9,0xbf03ecfa }, /*  60: -1.2184938e+00  2.1513579e+00 -5.1533473e-01 */
    { 0x3f2fab98,0x3f6f0e91,0x3f223c4c }, /*  61:  6.8621206e-01  9.3381602e-01  6.3373256e-01 */
    { 0x3fd4c418,0xbf9063cf,0x400ab0bd }, /*  62:  1.6622343e+00 -1.1280459e+00  2.1670372e+00 */
    { 0x3f1a6636,0xbf65a494,0x40232dc7 }, /*  63:  6.0312212e-01 -8.9704251e-01  2.5496690e+00 */
    { 0xbfe44464,0x3e3c1e91,0xbfbbec20 }, /*  64: -1.7833371e+00  1.8371035e-01 -1.4681435e+00 */
    { 0xbe051ac2,0xbfd7903c,0xc04421c6 }, /*  65: -1.2998489e-01 -1.6840892e+00 -3.0645614e+00 */
    { 0x407e4109,0x3f98a85f,0x3fa3bb2d }, /*  66:  3.9727194e+00  1.1926383e+00  1.2791497e+00 */
    { 0xb8e1bda3,0x3fe98863,0xb8777558 }, /*  67: -1.0764159e-04  1.8244747e+00 -5.8998674e-05 */
    { 0xbf1d0f1e,0x3f59c720,0xbf1ff348 }, /*  68: -6.1351192e-01  8.5069466e-01 -6.2480593e-01 */
    { 0xbf61b837,0xbf0121a1,0xc005c9c1 }, /*  69: -8.8171715e-01 -5.0441939e-01 -2.0904391e+00 */
    { 0x3f678bf1,0x3f396fc0,0x3f654185 }, /*  70:  9.0447909e-01  7.2436142e-01  8.9553100e-01 */
    { 0xbf976d67,0x3f2dde70,0xbf865a8f }, /*  71: -1.1830262e+00  6.7917538e-01 -1.0496386e+00 */
    { 0x3f2c7feb,0xbefe0731,0x400d269a }, /*  72:  6.7382687e-01 -4.9614862e-01  2.2054811e+00 */
    { 0xbf425689,0x3fe3aab7,0xbece8a16 }, /*  73: -7.5913292e-01  1.7786473e+00 -4.0339726e-01 */
    { 0xbf6d87c2,0x3f932675,0xbf2dd69f }, /*  74: -9.2785275e-01  1.1496111e+00 -6.7905611e-01 */
    { 0x3ef19ff3,0x3f677bf2,0x3ef647cb }, /*  75:  4.7192344e-01  9.0423501e-01  4.8101649e-01 */
    { 0xbcb18229,0x4008a0d4,0xbc264af9 }, /*  76: -2.1668511e-02  2.1348162e+00 -1.0149711e-02 */
    { 0xbf2bf629,0x3d868980,0xbfbc956f }, /*  77: -6.7172486e-01  6.5691948e-02 -1.4733104e+00 */
    { 0x3df5e2f8,0x3f2df6c6,0x3e331252 }, /*  78:  1.2006181e-01  6.7954671e-01  1.7487457e-01 */
    { 0xc07b2291,0xbf1497cc,0xbfdbdc0c }, /*  79: -3.9239848e+00 -5.8044124e-01 -1.7176528e+00 */
    { 0x3edfb648,0xc0006bbf,0x403b5707 }, /*  80:  4.3693757e-01 -2.0065763e+00  2.9271867e+00 */
    { 0x4063977f,0xbed6cab6,0x3fd817b5 }, /*  81:  3.5561216e+00 -4.1951531e-01  1.6882235e+00 */
    { 0x3f620b2f,0x3fcacf6b,0x3f022772 }, /*  82:  8.8298315e-01  1.5844549e+00  5.0841439e-01 */
    { 0x3f69f7f7,0xbee21ec6,0x40015705 }, /*  83:  9.1393989e-01 -4.4164103e-01  2.0209363e+00 */
    { 0x3f0f330c,0xb0c9a357,0x3fc90fdb }, /*  84:  5.5937266e-01 -1.4671099e-09  1.5707964e+00 */
    { 0x3f9a484f,0xbf946716,0x40158daa }, /*  85:  1.2053317e+00 -1.1593959e+00  2.3367715e+00 */
    { 0xbf372434,0xbf111f00,0xc00f6aaa }, /*  86: -7.1539617e-01 -5.6687927e-01 -2.2408853e+00 */
    { 0xbfcfeef1,0x3fcd781a,0xbf4a967f }, /*  87: -1.6244794e+00  1.6052277e+00 -7.9135889e-01 */
    { 0x3f62b853,0x4418f90b,0x3abdb534 }, /*  88:  8.8562506e-01  6.1189130e+02  1.4473558e-03 */
    { 0xbeeb8fcb,0x3feb2501,0xbe7b4919 }, /*  89: -4.6008143e-01  1.8370668e+00 -2.4539603e-01 */
    { 0xbf140724,0xbf1f33f2,0xc0191f92 }, /*  90: -5.7823396e-01 -6.2188637e-01 -2.3925519e+00 */
    { 0x52fd384a,0xc020413c,0x3fc90fdb }, /*  91:  5.4378555e+11 -2.5039816e+00  1.5707964e+00 */
    { 0xbfcca61c,0xbf639247,0xc00501d9 }, /*  92: -1.5988193e+00 -8.8895077e-01 -2.0782378e+00 */
    { 0xbf99b4dd,0xc0e55864,0xc03e6ffe }, /*  93: -1.2008320e+00 -7.1670399e+00 -2.9755855e+00 */
    { 0xb9b7500a,0x40019b35,0xb9350a6f }, /*  94: -3.4964114e-04  2.0250981e+00 -1.7265392e-04 */
    { 0xbf30a39a,0xbfe0135b,0xc031086c }, /*  95: -6.8999636e-01 -1.7505907e+00 -2.7661390e+00 */
    { 0xbf646449,0xc830605f,0xc0490fc6 }, /*  96: -8.9215523e-01 -1.8060948e+05 -3.1415877e+00 */
    { 0x3f9a2881,0xbf6de2f4,0x400e96db }, /*  97:  1.2043611e+00 -9.2924428e-01  2.2279575e+00 */
    { 0x40f927b0,0xbf2e6bbf,0x3fd43bf9 }, /*  98:  7.7860947e+00 -6.8133157e-01  1.6580802e+00 */
    { 0xc00a03af,0x40c80f3a,0xbeaa1018 }, /*  99: -2.1564748e+00  6.2518587e+00 -3.3215404e-01 */
    { 0xbee5692a,0x3ff50afb,0xbe6b6e55 }, /* 100: -4.4806796e-01  1.9143976e+00 -2.2991307e-01 */
    { 0xbee7431a,0xbfcfa025,0xc037ae47 }, /* 101: -4.5168382e-01 -1.6220747e+00 -2.8700120e+00 */
    { 0x3d468793,0x3f918158,0x3d2e8a19 }, /* 102:  4.8469137e-02  1.1367598e+00  4.2612169e-02 */
    { 0xbecaeb9e,0xbff53e7a,0xc03c01de }, /* 103: -3.9632887e-01 -1.9159691e+00 -2.9376140e+00 */
    { 0x3f0f6ac5,0xc00afbd2,0x4038e763 }, /* 104:  5.6022292e-01 -2.1716199e+00  2.8891227e+00 */
    { 0x3f9752c3,0x3e968457,0x3fa9dd7d }, /* 105:  1.1822132e+00  2.9397842e-01  1.3270718e+00 */
    { 0xbfc06f9f,0xbf99bb81,0xc00faba5 }, /* 106: -1.5034064e+00 -1.2010347e+00 -2.2448514e+00 */
    { 0xc06623f5,0x3cb55868,0xbfc84622 }, /* 107: -3.5959446e+00  2.2136882e-02 -1.5646403e+00 */
    { 0xc03ffcd0,0xbf97bf73,0xbff93c89 }, /* 108: -2.9998055e+00 -1.1855301e+00 -1.9471599e+00 */
    { 0x3f6d6920,0x448086cf,0x3a6c7018 }, /* 109:  9.2738533e-01  1.0282128e+03  9.0193888e-04 */
    { 0xbf633aa8,0x3564a105,0xbfc90fd3 }, /* 110: -8.8761377e-01  8.5170933e-07 -1.5707954e+00 */
    { 0x3f9946cf,0xbbb99bb0,0x3fc9aada }, /* 111:  1.1974734e+00 -5.6643113e-03  1.5755265e+00 */
    { 0x3f95f651,0xbf65937d,0x400e57d3 }, /* 112:  1.1715795e+00 -8.9678174e-01  2.2241104e+00 */
    { 0x3f95a7bb,0x3f99e552,0x3f457c61 }, /* 113:  1.1691812e+00  1.2023108e+00  7.7142912e-01 */
    { 0xbf4a6d1e,0x3e94152b,0xbf9c2da2 }, /* 114: -7.9072750e-01  2.8922400e-01 -1.2201426e+00 */
    { 0x3f8caa94,0x3d2a394a,0x3fc43947 }, /* 115:  1.0989556e+00  4.1558541e-02  1.5329980e+00 */
    { 0x3f9b4162,0xbf6f98c9,0x400e976d }, /* 116:  1.2129328e+00 -9.3592507e-01  2.2279923e+00 */
    { 0xbeece8f7,0x3ea89f8a,0xbf73c4c0 }, /* 117: -4.6271488e-01  3.2934219e-01 -9.5222092e-01 */
    { 0x3e3c7f94,0xbfe3755e,0x404274ad }, /* 118:  1.8408042e-01 -1.7770193e+00  3.0383713e+00 */
    { 0xbf2e2cdf,0xbf25a574,0xc01530c4 }, /* 119: -6.8037218e-01 -6.4705586e-01 -2.3311014e+00 */
    { 0xbfe8cbe9,0x3fdad525,0xbf50f984 }, /* 120: -1.8187228e+00  1.7096297e+00 -8.1630731e-01 */
    { 0xc0237e89,0x3eaaeab9,0xbfb86e06 }, /* 121: -2.5545981e+00  3.3382204e-01 -1.4408576e+00 */
    { 0x4025e8a9,0xbf3d09ef,0x3fec9518 }, /* 122:  2.5923254e+00 -7.3843282e-01  1.8483000e+00 */
    { 0x41971cdb,0x3fe3c915,0x3fbd09cf }, /* 123:  1.8889090e+01  1.7795740e+00  1.4768618e+00 */
    { 0xbffd5aa1,0xbfec2dc0,0xc0148d4b }, /* 124: -1.9793283e+00 -1.8451462e+00 -2.3211238e+00 */
    { 0xbf66eda7,0xbf1841bb,0xc009d634 }, /* 125: -9.0206379e-01 -5.9475297e-01 -2.1536989e+00 */
    { 0x3f1a0108,0xbf453424,0x401ea11a }, /* 126:  6.0157824e-01 -7.7032685e-01  2.4785829e+00 */
    { 0xc1333bc5,0x3d4f14c1,0xbfc87bf8 }, /* 127: -1.1202092e+01  5.0556902e-02 -1.5662832e+00 */
    { 0x3fbc8f88,0x4110671b,0x3e25ae52 }, /* 128:  1.4731302e+00  9.0251722e+00  1.6179779e-01 */
    { 0x3f0e3a4c,0xbf9d269f,0x402ddd84 }, /* 129:  5.5557704e-01 -1.2277411e+00  2.7166452e+00 */
    { 0x3f9bd784,0xbff57baa,0x4024dc5f }, /* 130:  1.2175145e+00 -1.9178364e+00  2.5759504e+00 */
    { 0xbf667360,0xbff1364f,0xc02c8a6f }, /* 131: -9.0019798e-01 -1.8844699e+00 -2.6959493e+00 */
    { 0x3f9a803e,0x3d21601f,0x3fc4e2ac }, /* 132:  1.2070386e+00  3.9398309e-02  1.5381675e+00 */
    { 0x4207ca60,0x3f656402,0x3fc5af22 }, /* 133:  3.3947632e+01  8.9605725e-01  1.5444071e+00 */
    { 0x3f380f8a,0x400d90ad,0x3ea0e873 }, /* 134:  7.1898711e-01  2.2119553e+00  3.1427345e-01 */
    { 0xbee7e2e0,0xbf19c7fe,0xc01fb768 }, /* 135: -4.5290279e-01 -6.0070789e-01 -2.4955692e+00 */
    { 0x3fe1c510,0xbf2a6e64,0x3ff7423a }, /* 136:  1.7638264e+00 -6.6574693e-01  1.9317086e+00 */
    { 0xbf6875ee,0xc03b0c01,0xc035c84b }, /* 137: -9.0804946e-01 -2.9226077e+00 -2.8403499e+00 */
    { 0xbf99fa90,0xc0d841ba,0xc03dc9a8 }, /* 138: -1.2029591e+00 -6.7580233e+00 -2.9654331e+00 */
    { 0xbf692c6f,0xbf92785e,0xc01e092d }, /* 139: -9.1083425e-01 -1.1442983e+00 -2.4693100e+00 */
    { 0xbf6ef55a,0xbf6db89b,0xc016a15d }, /* 140: -9.3343127e-01 -9.2859811e-01 -2.3535988e+00 */
    { 0x3f096c49,0xbf2ac0b3,0x401db0fd }, /* 141:  5.3680855e-01 -6.6700286e-01  2.4639275e+00 */
    { 0x3fcbd5a8,0xbf97d683,0x400d8185 }, /* 142:  1.5924578e+00 -1.1862339e+00  2.2110302e+00 */
    { 0x3f616f7b,0xbf167033,0x400a3134 }, /* 143:  8.8060731e-01 -5.8764952e-01  2.1592531e+00 */
    { 0xbe17aea6,0xbf6aea51,0xc03ed1bb }, /* 144: -1.4812717e-01 -9.1763788e-01 -2.9815509e+00 */
    { 0xbf692e0c,0x3fe8a0d5,0xbeeddf7b }, /* 145: -9.1085887e-01  1.8174082e+00 -4.6459565e-01 */
    { 0x3f9f472c,0xbf652210,0x400c7038 }, /* 146:  1.2443595e+00 -8.9505100e-01  2.1943493e+00 */
    { 0xbf127e3f,0xbfa27664,0xc02df435 }, /* 147: -5.7223886e-01 -1.2692380e+00 -2.7180302e+00 */
    { 0xbf639c44,0x3f3e43aa,0xbf5fe163 }, /* 148: -8.8910317e-01  7.4321997e-01 -8.7453288e-01 */
    { 0xbf6722fb,0xbf6d483f,0xc017a2d5 }, /* 149: -9.0287751e-01 -9.2688364e-01 -2.3693135e+00 */
    { 0x3f74461a,0x3c474387,0x3fc76e38 }, /* 150:  9.5419466e-01  1.2162096e-02  1.5580511e+00 */
    { 0x3ff4b853,0x3f6f9fbd,0x3f8ec921 }, /* 151:  1.9118751e+00  9.3603116e-01  1.1155130e+00 */
    { 0x3ef86cc1,0xbf3e479c,0x40240c72 }, /* 152:  4.8520473e-01 -7.4328017e-01  2.5632596e+00 */
    { 0x3f47bc98,0x3fc1a36d,0x3ef3cbf4 }, /* 153:  7.8022146e-01  1.5127999e+00  4.7616541e-01 */
    { 0x3f6a6eeb,0x3f6d55ab,0x3f477cd0 }, /* 154:  9.1575497e-01  9.2708844e-01  7.7924824e-01 */
    { 0x3fa4d5f5,0xc0a88cb6,0x4039b72d }, /* 155:  1.2877795e+00 -5.2671766e+00  2.9018052e+00 */
    { 0x41e2b328,0xbf96065b,0x3fce5a67 }, /* 156:  2.8337479e+01 -1.1720690e+00  1.6121339e+00 */
    { 0xbf9946a2,0xbf2f0352,0xc005bb30 }, /* 157: -1.1974680e+00 -6.8364441e-01 -2.0895500e+00 */
    { 0x3f1f9b52,0xbf6aa782,0x4022d5b8 }, /* 158:  6.2346375e-01 -9.1661847e-01  2.5442944e+00 */
    { 0xbe49e252,0xc0453b23,0xc044f91f }, /* 159: -1.9715241e-01 -3.0817344e+00 -3.0777051e+00 */
    { 0x3e9a9193,0xbdc6601c,0x3ff0cd8f }, /* 160:  3.0189189e-01 -9.6863002e-02  1.8812732e+00 */
    { 0x3e7684ca,0xbf43d8a8,0x40358cd0 }, /* 161:  2.4074093e-01 -7.6502466e-01  2.8367195e+00 */
    { 0xbf1ba6eb,0xbf660b43,0xc022fda8 }, /* 162: -6.0801572e-01 -8.9860934e-01 -2.5467319e+00 */
    { 0x3fa1cfd6,0xbe0cdf98,0x3fd6efdb }, /* 163:  1.2641551e+00 -1.3757169e-01  1.6791948e+00 */
    { 0xbef0a00c,0xbf1d1f97,0xc01f3d22 }, /* 164: -4.6997106e-01 -6.1376327e-01 -2.4881063e+00 */
    { 0x4042a222,0xbf95f1e8,0x3ff8200d }, /* 165:  3.0411458e+00 -1.1714449e+00  1.9384781e+00 */
    { 0xc30711b1,0x3f05d259,0xbfc89109 }, /* 166: -1.3506911e+02  5.2274090e-01 -1.5669261e+00 */
    { 0x4034c4cc,0x3f5b641f,0x3fa35adc }, /* 167:  2.8245115e+00  8.5699648e-01  1.2762103e+00 */
    { 0x3fcf3e61,0x3ff8ee59,0x3f31bb75 }, /* 168:  1.6190912e+00  1.9447738e+00  6.9426662e-01 */
    { 0x3f8e6642,0x3ef13573,0x3f95c9c9 }, /* 169:  1.1124957e+00  4.7111091e-01  1.1702205e+00 */
    { 0xbfd34237,0x3ffc9f54,0xbf324b80 }, /* 170: -1.6504582e+00  1.9736123e+00 -6.9646454e-01 */
    { 0xc05e06ea,0x3fe7f091,0xbf8b731a }, /* 171: -3.4691720e+00  1.8120290e+00 -1.0894501e+00 */
    { 0x3fdb9fc4,0x3f7be2e6,0x3f866a9d }, /* 172:  1.7158132e+00  9.8393095e-01  1.0501286e+00 */
    { 0x3f979c46,0xbf15de08,0x4001e8ce }, /* 173:  1.1844566e+00 -5.8541918e-01  2.0298343e+00 */
    { 0xbf0d0083,0x3f63056d,0xbf0e4811 }, /* 174: -5.5078906e-01  8.8680154e-01 -5.5578715e-01 */
    { 0x401fbe62,0xbf6c422b,0x3ff664dc }, /* 175:  2.4959950e+00 -9.2288464e-01  1.9249530e+00 */
    { 0xbf23b8f9,0xbf627be2,0xc02100bd }, /* 176: -6.3954121e-01 -8.8470280e-01 -2.5156701e+00 */
    { 0x3eeed519,0xc08599ed,0x4041f0dc }, /* 177:  4.6646956e-01 -4.1750398e+00  3.0303259e+00 */
    { 0xbf640437,0x404ace7b,0xbe8c4a93 }, /* 178: -8.9068931e-01  3.1688526e+00 -2.7400646e-01 */
    { 0x3fdeaf38,0x40101dd3,0x3f28658b }, /* 179:  1.7397223e+00  2.2518203e+00  6.5779942e-01 */
    { 0xbf3d384f,0xbf9d7fec,0xc0267133 }, /* 180: -7.3914045e-01 -1.2304664e+00 -2.6006591e+00 */
    { 0xbf028f73,0x3f6e712b,0xbf003f3a }, /* 181: -5.1000136e-01  9.3141431e-01 -5.0096476e-01 */
    { 0x3d8b1d14,0xc0113e12,0x4047259b }, /* 182:  6.7926556e-02 -2.2694135e+00  3.1116703e+00 */
    { 0xbf6c5639,0x3fa22c07,0xbf213443 }, /* 183: -9.2319065e-01  1.2669686e+00 -6.2970370e-01 */
    { 0xbf670b02,0xbf6b0c53,0xc01758ad }, /* 184: -9.0251172e-01 -9.1815680e-01 -2.3647873e+00 */
    { 0x3f300490,0xbf645dea,0x401f0921 }, /* 185:  6.8756962e-01 -8.9205801e-01  2.4849322e+00 */
    { 0x3eea7d30,0x3edea76c,0x3f4fb025 }, /* 186:  4.5798635e-01  4.3487108e-01  8.1128150e-01 */
    { 0x3ff4ffb9,0xbf0f5748,0x3fed7d67 }, /* 187:  1.9140540e+00 -5.5992556e-01  1.8553895e+00 */
    { 0x4117942f,0x3f9b5052,0x3fb8c1a8 }, /* 188:  9.4736776e+00  1.2133887e+00  1.4434099e+00 */
    { 0x3e331101,0x3f926a5e,0x3e1b576f }, /* 189:  1.7486955e-01  1.1438711e+00  1.5170072e-01 */
    { 0x419e2f75,0xbf36799f,0x3fcdac95 }, /* 190:  1.9773172e+01 -7.1279329e-01  1.6068293e+00 */
    { 0xbf2a83cf,0xc01389b7,0xc0370f77 }, /* 191: -6.6607374e-01 -2.3052804e+00 -2.8603189e+00 */
    { 0x3fe3c992,0xbe9cdd3d,0x3fdee274 }, /* 192:  1.7795889e+00 -3.0637541e-01  1.7412858e+00 */
    { 0xc164dd21,0xbf96649e,0xbfd38d6d }, /* 193: -1.4303987e+01 -1.1749456e+00 -1.6527535e+00 */
    { 0x401c6169,0x3ed03971,0x3fb3f379 }, /* 194:  2.4434454e+00  4.0668824e-01  1.4058677e+00 */
    { 0xbe9dd4c8,0xbfe5eabc,0xc03e2f33 }, /* 195: -3.0826402e-01 -1.7962260e+00 -2.9716308e+00 */
    { 0xbf1c653a,0x3fd37e5b,0xbeb55359 }, /* 196: -6.1091959e-01  1.6522936e+00 -3.5415152e-01 */
    { 0xbfdb3282,0x405be2bb,0xbeecbefc }, /* 197: -1.7124789e+00  3.4357135e+00 -4.6239460e-01 */
    { 0x3f97c9f5,0x3ff1e1d6,0x3f0f7793 }, /* 198:  1.1858507e+00  1.8897045e+00  5.6041831e-01 */
    { 0x3ff03f55,0xc13353b5,0x403e7157 }, /* 199:  1.8769327e+00 -1.1207936e+01  2.9756677e+00 */
    { 0xc0675143,0xbf9b93df,0xbff295fa }, /* 200: -3.6143348e+00 -1.2154502e+00 -1.8952019e+00 */
    { 0xbf63f744,0x3fc72b2a,0xbf05117c }, /* 201: -8.9049172e-01  1.5560048e+00 -5.1979804e-01 */
    { 0xbfa2afec,0xbdd8cccc,0xbfd3b2c6 }, /* 202: -1.2709937e+00 -1.0585937e-01 -1.6538932e+00 */
    { 0x3e8e1db0,0x418b0f41,0x3c82cd5c }, /* 203:  2.7757025e-01  1.7382448e+01  1.5967064e-02 */
    { 0x3fed7050,0xbd966f9b,0x3fce20bf }, /* 204:  1.8549900e+00 -7.3455058e-02  1.6103743e+00 */
    { 0xbeb34622,0x3f615db7,0xbec1d21b }, /* 205: -3.5014445e-01  8.8033623e-01 -3.7855610e-01 */
    { 0x3f5d6153,0x3f65fea6,0x3f442d3e }, /* 206:  8.6476630e-01  8.9841688e-01  7.6631534e-01 */
    { 0x3e6ff9e1,0x3f285042,0x3eaf4f5c }, /* 207:  2.3435165e-01  6.5747464e-01  3.4240234e-01 */
    { 0x420b1bf9,0xbeefb2d8,0x3fcac8f1 }, /* 208:  3.4777317e+01 -4.6816134e-01  1.5842572e+00 */
    { 0x3ee98683,0xbf6fb517,0x402c0d56 }, /* 209:  4.5610437e-01 -9.3635696e-01  2.6883140e+00 */
    { 0xbea1d5a8,0x3eec25e5,0xbf19cdf1 }, /* 210: -3.1608319e-01  4.6122661e-01 -6.0079867e-01 */
    { 0x3f1dce93,0x3ff6f53e,0x3e9e561e }, /* 211:  6.1643332e-01  1.9293592e+00  3.0925077e-01 */
    { 0x3f3c8abd,0x3f592931,0x3f37087b }, /* 212:  7.3649198e-01  8.4828478e-01  7.1497315e-01 */
    { 0x3f6b653f,0x3edf11de,0x3f906c86 }, /* 213:  9.1951364e-01  4.3568319e-01  1.1283119e+00 */
    { 0xbfd5a04c,0x40490d2a,0xbefa0934 }, /* 214: -1.6689544e+00  3.1414285e+00 -4.8835146e-01 */
    { 0xbac1ab79,0xbfd0cb27,0xc0490103 }, /* 215: -1.4775834e-03 -1.6311997e+00 -3.1406868e+00 */
    { 0xbf3f630c,0x3fa08fe2,0xbf099761 }, /* 216: -7.4760509e-01  1.2543910e+00 -5.3746611e-01 */
    { 0x40065964,0x3f1e237d,0x3fa46dfd }, /* 217:  2.0992060e+00  6.1772901e-01  1.2846066e+00 */
    { 0x3e5ca0b2,0xbf846270,0x403beada }, /* 218:  2.1545675e-01 -1.0342541e+00  2.9362092e+00 */
    { 0xc05fd74f,0xc04bf2d4,0xc013d292 }, /* 219: -3.4975164e+00 -3.1866961e+00 -2.3097272e+00 */
    { 0xbf9bb63d,0x3f999d1f,0xbf4acc5e }, /* 220: -1.2164990e+00  1.2001075e+00 -7.9218090e-01 */
    { 0x3f8d5cad,0x3d82ee4b,0x3fc1a917 }, /* 221:  1.1043907e+00  6.3931070e-02  1.5129727e+00 */
    { 0xbfcd7ae5,0x3fd73f63,0xbf431ea7 }, /* 222: -1.6053129e+00  1.6816219e+00 -7.6218647e-01 */
    { 0x3eba1e1b,0x3ecfed6c,0x3f3ae83a }, /* 223:  3.6351094e-01  4.0610826e-01  7.3010600e-01 */
    { 0x3fc2c8b3,0xc17bf23f,0x4042e569 }, /* 224:  1.5217499e+00 -1.5746642e+01  3.0452521e+00 */
    { 0x3fe98f7c,0xc03d8456,0x4025b7dc }, /* 225:  1.8246913e+00 -2.9612021e+00  2.5893469e+00 */
    { 0xbf34a480,0x3fbe9350,0xbee29a3c }, /* 226: -7.0563507e-01  1.4888706e+00 -4.4258296e-01 */
    { 0xbf9acbb7,0xc61a0b85,0xc0490dd8 }, /* 227: -1.2093419e+00 -9.8588799e+03 -3.1414700e+00 */
    { 0xbf251d07,0x3f7557c2,0xbf17a56c }, /* 228: -6.4497417e-01  9.5837033e-01 -5.9236789e-01 */
    { 0x3fbe3f30,0x402c34d8,0x3f0131f9 }, /* 229:  1.4863033e+00  2.6907253e+00  5.0466877e-01 */
    { 0xbe983207,0x3f45e56e,0xbebbf4da }, /* 230: -2.9725668e-01  7.7303207e-01 -3.6710244e-01 */
    { 0xbfbf9417,0xc02dd472,0xc028d40c }, /* 231: -1.4967068e+00 -2.7160916e+00 -2.6379423e+00 */
    { 0xbf5bb85e,0xbd4e5d40,0xbfd09129 }, /* 232: -8.5828197e-01 -5.0381899e-02 -1.6294299e+00 */
    { 0x39e16ee2,0xbfbef9e6,0x40490b22 }, /* 233:  4.2997958e-04 -1.4920013e+00  3.1413045e+00 */
    { 0x3f67fef2,0x3fe69c0d,0x3eee9e04 }, /* 234:  9.0623391e-01  1.8016373e+00  4.6604931e-01 */
    { 0x3f0e0fd6,0x3fe16450,0x3e9c4f3b }, /* 235:  5.5492914e-01  1.7608738e+00  3.0529198e-01 */
    { 0xbfa0cfa3,0x3f6ea0ae,0xbf6eb628 }, /* 236: -1.2563366e+00  9.3213928e-01 -9.3246698e-01 */
    { 0x401394ee,0xbf5c722a,0x3ff6ceee }, /* 237:  2.3059649e+00 -8.6111701e-01  1.9281900e+00 */
    { 0xbf96c7fa,0xc0139f27,0xc02ad7ca }, /* 238: -1.1779778e+00 -2.3065889e+00 -2.6694207e+00 */
    { 0xc0633cd5,0xc0138446,0xc00961bd }, /* 239: -3.5505879e+00 -2.3049483e+00 -2.1465905e+00 */
    { 0xbe262587,0xbf313d60,0xc03a5448 }, /* 240: -1.6225253e-01 -6.9234276e-01 -2.9113941e+00 */
    { 0xbf58d1ac,0x3f8d00d8,0xbf27cbbc }, /* 241: -8.4694934e-01  1.1015882e+00 -6.5545249e-01 */
    { 0x3fe44122,0xc158cae4,0x4040afe6 }, /* 242:  1.7832377e+00 -1.3549534e+01  3.0107360e+00 */
    { 0xc0129a43,0x3f9a60e6,0xbf8b073b }, /* 243: -2.2906654e+00  1.2060821e+00 -1.0861582e+00 */
    { 0x3fef27a6,0xbed6c6da,0x3fe554cd }, /* 244:  1.8683975e+00 -4.1948587e-01  1.7916504e+00 */
    { 0x3f6dde23,0xbf8bcae9,0x401bf1ef }, /* 245:  9.2917079e-01 -1.0921298e+00  2.4366415e+00 */
    { 0xbf627f56,0x40321a99,0xbe9d9af9 }, /* 246: -8.8475549e-01  2.7828734e+00 -3.0782297e-01 */
    { 0xbdd1fa27,0xbf873cfe,0xc042dee8 }, /* 247: -1.0252791e-01 -1.0565488e+00 -3.0448551e+00 */
    { 0xbf91bef9,0xbf9babe4,0xc018e736 }, /* 248: -1.1386405e+00 -1.2161832e+00 -2.3891120e+00 */
    { 0xbf3b3df0,0x412c78da,0xbd8abfb0 }, /* 249: -7.3141384e-01  1.0779505e+01 -6.7748427e-02 */
    { 0xbde167d3,0x3f6a4925,0xbdf51e9f }, /* 250: -1.1006131e-01  9.1517860e-01 -1.1968731e-01 */
    { 0xc0028540,0xc3dfe40d,0xc048c53c }, /* 251: -2.0393829e+00 -4.4778165e+02 -3.1370382e+00 */
    { 0xc08822eb,0x3fc3e733,0xbf9cdbca }, /* 252: -4.2542624e+00  1.5304931e+00 -1.2254574e+00 */
    { 0xc1eb265b,0xbf15e17e,0xbfcb9c73 }, /* 253: -2.9393728e+01 -5.8547199e-01 -1.5907120e+00 */
    { 0x3f106448,0xbfc0d5d8,0x40322280 }, /* 254:  5.6403017e-01 -1.5065260e+00  2.7833557e+00 */
    { 0xc07b3f28,0x3ff98bfe,0xbf8e0fd9 }, /* 255: -3.9257298e+00  1.9495847e+00 -1.1098586e+00 */
    { 0xbffe25f2,0xbf5cf105,0xbffd8bd1 }, /* 256: -1.9855330e+00 -8.6305267e-01 -1.9808294e+00 */
    { 0x403238fe,0xc03f89e3,0x401919aa }, /* 257:  2.7847285e+00 -2.9927909e+00  2.3921914e+00 */
    { 0xbf1c729d,0x3fda1da2,0xbeb04e29 }, /* 258: -6.1112386e-01  1.7040293e+00 -3.4434631e-01 */
    { 0xbf3a2f36,0x3fbff23c,0xbee733fe }, /* 259: -7.2728288e-01  1.4995799e+00 -4.5156854e-01 */
    { 0x3f732919,0xbdfa3d5c,0x3fd97014 }, /* 260:  9.4984585e-01 -1.2218735e-01  1.6987329e+00 */
    { 0xc00183fe,0x415aa735,0xbe168b18 }, /* 261: -2.0236812e+00  1.3665822e+01 -1.4701498e-01 */
    { 0x3ee96adc,0xbf153e21,0x401e963f }, /* 262:  4.5589340e-01 -5.8297926e-01  2.4779203e+00 */
    { 0xb80405b6,0x3f2bce16,0xb844b8a8 }, /* 263: -3.1476571e-05  6.7111337e-01 -4.6902016e-05 */
    { 0xcc7fc55b,0xbf116bf2,0xbfc90fdb }, /* 264: -6.7048812e+07 -5.6805336e-01 -1.5707964e+00 */
    { 0xbf315e20,0xbf976ff5,0xc0272807 }, /* 265: -6.9284248e-01 -1.1831042e+00 -2.6118181e+00 */
    { 0xb84b483e,0x3ebfb3f2,0xb907bb43 }, /* 266: -4.8466252e-05  3.7441975e-01 -1.2944364e-04 */
    { 0x3f2d52e7,0x4200ab06,0x3cac6602 }, /* 267:  6.7704624e-01  3.2167015e+01  2.1044735e-02 */
    { 0x40aa3e8a,0xc02c34ff,0x40027fb6 }, /* 268:  5.3201342e+00 -2.6907346e+00  2.0390449e+00 */
    { 0x3ee9c9d0,0x3f9b5370,0x3eb84496 }, /* 269:  4.5661783e-01  1.2134838e+00  3.5989827e-01 */
    { 0x3f92e8d9,0x3f1cdc5a,0x3f8a4b49 }, /* 270:  1.1477309e+00  6.1273730e-01  1.0804225e+00 */
    { 0xbf9567a7,0xbeb83f49,0xbfef574f }, /* 271: -1.1672257e+00 -3.5985783e-01 -1.8698519e+00 */
    { 0xbf9ddd81,0x3fa0d11b,0xbf46b0e4 }, /* 272: -1.2333223e+00  1.2563814e+00 -7.7613664e-01 */
    { 0x3f9c387b,0x3f9c2f88,0x3f491730 }, /* 273:  1.2204736e+00  1.2202005e+00  7.8551006e-01 */
    { 0xbeb227e8,0xbf31ff68,0xc02b5da1 }, /* 274: -3.4796071e-01 -6.9530344e-01 -2.6775897e+00 */
    { 0x3f1d545a,0x3ee30979,0x3f721d98 }, /* 275:  6.1456835e-01  4.4343165e-01  9.4576406e-01 */
    { 0xbf9843bb,0xbff08da8,0xc024f220 }, /* 276: -1.1895670e+00 -1.8793230e+00 -2.5772781e+00 */
    { 0x3fd59e68,0x3fd497b7,0x3f49ada3 }, /* 277:  1.6688967e+00  1.6608800e+00  7.8780574e-01 */
    { 0xbef67fed,0x3f6b446b,0xbef71260 }, /* 278: -4.8144475e-01  9.1901273e-01 -4.8256207e-01 */
    { 0x4566a9bb,0x3fd1e8e1,0x3fc9014b }, /* 279:  3.6906082e+03  1.6399194e+00  1.5703520e+00 */
    { 0x3e793441,0x3f0a39bf,0x3ed8cec5 }, /* 280:  2.4336340e-01  5.3994364e-01  4.2345253e-01 */
    { 0x4004786b,0x3f5da5bd,0x3f9659de }, /* 281:  2.0698497e+00  8.6581022e-01  1.1746175e+00 */
    { 0xbedde9db,0xbee33aea,0xc0178dd3 }, /* 282: -4.3342480e-01 -4.4380885e-01 -2.3680313e+00 */
    { 0xbee32604,0x3f93c551,0xbebbd948 }, /* 283: -4.4364941e-01  1.1544591e+00 -3.6689210e-01 */
    { 0x3f759c7b,0x40bbdaf5,0x3e25e30e }, /* 284:  9.5941895e-01  5.8704782e+00  1.6199896e-01 */
    { 0x4089caaa,0x3f311053,0x3fb4ad07 }, /* 285:  4.3059893e+00  6.9165534e-01  1.4115304e+00 */
    { 0xbfc57b10,0xbf9cc8eb,0xc00f7a03 }, /* 286: -1.5428181e+00 -1.2248815e+00 -2.2418220e+00 */
    { 0x3fc671a0,0xbe9430a7,0x3fe0afb2 }, /* 287:  1.5503426e+00 -2.8943369e-01  1.7553618e+00 */
    { 0x3dcaded8,0x3f39b8d5,0x3e0af59f }, /* 288:  9.9057853e-02  7.2547656e-01  1.3570260e-01 */
    { 0x3e6ba61a,0x3ffefec1,0x3deb8894 }, /* 289:  2.3012581e-01  1.9921495e+00  1.1500660e-01 */
    { 0xbc116a66,0xbf14ab3a,0xc048157a }, /* 290: -8.8754650e-03 -5.8073771e-01 -3.1263108e+00 */
    { 0xbf999cf7,0x3f9c9d05,0xbf469613 }, /* 291: -1.2001027e+00  1.2235419e+00 -7.7572745e-01 */
    { 0x3fc1ee43,0x3f7057d2,0x3f820dc0 }, /* 292:  1.5150837e+00  9.3884003e-01  1.0160446e+00 */
    { 0x3f9bfdb2,0x41ef9035,0x3d269a0d }, /* 293:  1.2186797e+00  2.9945414e+01  4.0674258e-02 */
    { 0xbe10612c,0xbf76c1c4,0xc03fc420 }, /* 294: -1.4099568e-01 -9.6389413e-01 -2.9963455e+00 */
    { 0x408ba361,0xc09f9dda,0x401b1013 }, /* 295:  4.3636937e+00 -4.9880190e+00  2.4228561e+00 */
    { 0xbef8a2f8,0x3fd4efdc,0xbe916b44 }, /* 296: -4.8561835e-01  1.6635699e+00 -2.8402150e-01 */
    { 0x40612bae,0x4049afb6,0x3f5721cc }, /* 297:  3.5182910e+00  3.1513495e+00  8.4035945e-01 */
    { 0xbf1eb091,0xbf9e3377,0xc02b4f38 }, /* 298: -6.1988169e-01 -1.2359456e+00 -2.6767101e+00 */
    { 0xbe9c914b,0x3f700acd,0xbea16856 }, /* 299: -3.0579600e-01  9.3766481e-01 -3.1524915e-01 */
    { 0xbe75eb55,0x3f0f3f02,0xbecf9278 }, /* 300: -2.4015553e-01  5.5955517e-01 -4.0541434e-01 */
    { 0xe14d4f06,0x408ac079,0xbfc90fdb }, /* 301: -2.3670480e+20  4.3359952e+00 -1.5707964e+00 */
    { 0x3fe99ef5,0x3f3602b7,0x3f9983e3 }, /* 302:  1.8251635e+00  7.1097893e-01  1.1993374e+00 */
    { 0xc068e7be,0xbf6d21ff,0xbfe8f71d }, /* 303: -3.6391444e+00 -9.2629999e-01 -1.8200413e+00 */
    { 0x3f76cf41,0xbcb8d587,0x3fcc0e95 }, /* 304:  9.6409994e-01 -2.2562755e-02  1.5941950e+00 */
    { 0xbf600c9e,0x3fb9b414,0xbf0af513 }, /* 305: -8.7519252e-01  1.4508080e+00 -5.4280204e-01 */
    { 0x3f67364a,0x3f6bc840,0x3f468e85 }, /* 306:  9.0317214e-01  9.2102432e-01  7.7561218e-01 */
    { 0x3f749fa2,0xbf8ec1be,0x401bb91c }, /* 307:  9.5556080e-01 -1.1152875e+00  2.4331732e+00 */
    { 0xbf0234d5,0xbf975ab2,0xc02f1070 }, /* 308: -5.0861865e-01 -1.1824553e+00 -2.7353783e+00 */
    { 0xbf616bc5,0x3f3e879b,0xbf5e7c62 }, /* 309: -8.8055068e-01  7.4425668e-01 -8.6908543e-01 */
    { 0x40930fb3,0x3f756caf,0x3faebcdb }, /* 310:  4.5956664e+00  9.5868963e-01  1.3651384e+00 */
    { 0xc07e9de7,0x3f6b41ae,0xbfac0137 }, /* 311: -3.9783876e+00  9.1897094e-01 -1.3437871e+00 */
    { 0xbeff4974,0xbf5d630f,0xc02796e4 }, /* 312: -4.9860728e-01 -8.6479276e-01 -2.6185846e+00 */
    { 0xbf921c9e,0x3f440e3a,0xbf7ad83e }, /* 313: -1.1414983e+00  7.6584208e-01 -9.7986209e-01 */
    { 0xbf68c7d9,0xbf088872,0xc0067aee }, /* 314: -9.0929943e-01 -5.3333199e-01 -2.1012530e+00 */
    { 0x3663c4bf,0x4028b4ed,0x35accf9b }, /* 315:  3.3940157e-06  2.6360428e+00  1.2875420e-06 */
    { 0xbf04e001,0x413c5ff4,0xbd347596 }, /* 316: -5.1904303e-01  1.1773426e+01 -4.4057451e-02 */
    { 0xc15fcc00,0x3feabdbb,0xbfb85feb }, /* 317: -1.3987305e+01  1.8339151e+00 -1.4404272e+00 */
    { 0xbfcdd49e,0xbf9af3e7,0xc00dd48c }, /* 318: -1.6080511e+00 -1.2105683e+00 -2.2160978e+00 */
    { 0x3fd1533b,0xc1b2b765,0x4044629c }, /* 319:  1.6353525e+00 -2.2339548e+01  3.0685186e+00 */
    { 0x3d9a0f74,0xbfef73f5,0x40467d62 }, /* 320:  7.5224787e-02 -1.8707262e+00  3.1014028e+00 */
    { 0xbf9643d3,0x40279449,0xbed7cb41 }, /* 321: -1.1739448e+00  2.6184256e+00 -4.2147258e-01 */
    { 0xbfeb8a60,0x3fea8e54,0xbf49991c }, /* 322: -1.8401604e+00  1.8324685e+00 -7.8749251e-01 */
    { 0x3f70bf6d,0x3ffd0a07,0x3ee357d4 }, /* 323:  9.4042093e-01  1.9768685e+00  4.4402945e-01 */
    { 0x3f9512b8,0x401c7e39,0x3ee395e0 }, /* 324:  1.1646338e+00  2.4452040e+00  4.4450283e-01 */
    { 0x3f9bf55b,0xbf6ed762,0x400e5aa8 }, /* 325:  1.2184252e+00 -9.3297398e-01  2.2242832e+00 */
    { 0x3f3f5073,0xbf2a4105,0x401312a6 }, /* 326:  7.4732131e-01 -6.6505462e-01  2.2980132e+00 */
    { 0x3fe9206d,0xbd333716,0x3fcc22e6 }, /* 327:  1.8213021e+00 -4.3753706e-02  1.5948150e+00 */
    { 0xc0589846,0x3f174435,0xbfb2efc8 }, /* 328: -3.3842940e+00  5.9088451e-01 -1.3979425e+00 */
    { 0x403cfbcb,0x4701a548,0x38ba95b2 }, /* 329:  2.9528682e+00  3.3189281e+04  8.8970541e-05 */
    { 0xc012e53c,0x3f0a2fc6,0xbfab7f10 }, /* 330: -2.2952414e+00  5.3979146e-01 -1.3398151e+00 */
    { 0xbf800000,0xbff2f6fe,0xc02a07a2 }, /* 331: -1.0000000e+00 -1.8981626e+00 -2.6567159e+00 */
    { 0xbf69cf09,0x3fd9c41a,0xbefc4078 }, /* 332: -9.1331536e-01  1.7012970e+00 -4.9267936e-01 */
    { 0xbf6ea0a1,0x3eff17c4,0xbf8a3b2e }, /* 333: -9.3213850e-01  4.9822819e-01 -1.0799310e+00 */
    { 0xc011b6d6,0xc04fd6d8,0xc021edbb }, /* 334: -2.2767844e+00 -3.2474880e+00 -2.5301349e+00 */
    { 0xbfcbb156,0xbf986678,0xc00da406 }, /* 335: -1.5913494e+00 -1.1906271e+00 -2.2131362e+00 */
    { 0x3f67fae2,0xc16618a4,0x404508d5 }, /* 336:  9.0617192e-01 -1.4381016e+01  3.0786641e+00 */
    { 0xfac3aefc,0xbf26396c,0xbfc90fdb }, /* 337: -5.0802350e+35 -6.4931369e-01 -1.5707964e+00 */
    { 0x3f4a6fb5,0x4063ea4c,0x3e5fc04b }, /* 338:  7.9076701e-01  3.5611753e+00  2.1850698e-01 */
    { 0x3f6fb1b8,0xbf656d1f,0x40156557 }, /* 339:  9.3630552e-01 -8.9619631e-01  2.3343103e+00 */
    { 0xbf6d00f6,0xbf96cca0,0xc01e6f7e }, /* 340: -9.2579591e-01 -1.1781197e+00 -2.4755549e+00 */
    { 0x3fa3579e,0x3f92648b,0x3f570e95 }, /* 341:  1.2761114e+00  1.1436933e+00  8.4006625e-01 */
    { 0xcf5faefb,0x2b0204b7,0xbfc90fdb }, /* 342: -3.7527867e+09  4.6191821e-13 -1.5707964e+00 */
    { 0x3f77836d,0xbf9cdd62,0x401e5000 }, /* 343:  9.6684915e-01 -1.2255061e+00  2.4736328e+00 */
    { 0xbe54bb52,0xbf6e3a64,0xc03b013d }, /* 344: -2.0774582e-01 -9.3057847e-01 -2.9219506e+00 */
    { 0x3c8a4038,0x3f9d25b5,0x3c6133e2 }, /* 345:  1.6876325e-02  1.2277132e+00  1.3745280e-02 */
    { 0x3f2e0e72,0x3f990bfa,0x3f045cba }, /* 346:  6.7990792e-01  1.1956780e+00  5.1703990e-01 */
    { 0x3f6b24d7,0xbf664420,0x4016202f }, /* 347:  9.1853088e-01 -8.9947701e-01  2.3457143e+00 */
    { 0xc026976b,0xc076b45e,0xc0230cda }, /* 348: -2.6029918e+00 -3.8547587e+00 -2.5476594e+00 */
    { 0xbf905f91,0xbf1ae098,0xc0040a2d }, /* 349: -1.1279165e+00 -6.0498953e-01 -2.0631211e+00 */
    { 0xbebd87a6,0x3f63ed32,0xbec9bdd9 }, /* 350: -3.7017554e-01  8.9033806e-01 -3.9402655e-01 */
    { 0x3ec65fd8,0x3fa87a58,0x3e9292e3 }, /* 351:  3.8744998e-01  1.3162336e+00  2.8627691e-01 */
    { 0x3729175c,0x3f9bb5cd,0x370afff2 }, /* 352:  1.0078624e-05  1.2164856e+00  8.2850329e-06 */
    { 0xbfd10945,0x3ffc71b3,0xbf310d78 }, /* 353: -1.6330954e+00  1.9722198e+00 -6.9161177e-01 */
    { 0xbef3be99,0x4070e148,0xbe00d686 }, /* 354: -4.7606352e-01  3.7637501e+00 -1.2581834e-01 */
    { 0x4035eb06,0xbf72929e,0x3ff23f99 }, /* 355:  2.8424697e+00 -9.4754970e-01  1.8925658e+00 */
    { 0x4600ca25,0x3f8d7c25,0x3fc90b76 }, /* 356:  8.2425361e+03  1.1053511e+00  1.5706623e+00 */
    { 0xbeb4bd13,0xbf62f9d5,0xc030cfdb }, /* 357: -3.5300502e-01 -8.8662463e-01 -2.7626865e+00 */
    { 0x3fa27f14,0xc00c6054,0x40277b8c }, /* 358:  1.2695031e+00 -2.1933794e+00  2.6169157e+00 */
    { 0x3e95132e,0x3f9f4258,0x3e6b64c0 }, /* 359:  2.9116195e-01  1.2442122e+00  2.2987652e-01 */
    { 0x3c2901ef,0x3e4f37fa,0x3d509cf1 }, /* 360:  1.0315402e-02  2.0236197e-01  5.0930921e-02 */
    { 0xbd16dfe0,0xbe9ded1e,0xc0417486 }, /* 361: -3.6834598e-02 -3.0844969e-01 -3.0227370e+00 */
    { 0x3ef261fd,0xc07f575c,0x404180d6 }, /* 362:  4.7340384e-01 -3.9897070e+00  3.0234885e+00 */
    { 0xbb5ebc07,0x3f968eec,0xbb3d5c87 }, /* 363: -3.3986585e-03  1.1762366e+00 -2.8894262e-03 */
    { 0xbf21cfe1,0x401378f7,0xbe89130d }, /* 364: -6.3207823e-01  2.3042581e+00 -2.6772347e-01 */
    { 0xbe68b8c3,0xbf120ad4,0xc030cc86 }, /* 365: -2.2726731e-01 -5.7047772e-01 -2.7624831e+00 */
    { 0x3f362462,0x3f919825,0x3f0f1883 }, /* 366:  7.1149266e-01  1.1374556e+00  5.5896777e-01 */
    { 0x3f6f2686,0xbf09fb40,0x400605d5 }, /* 367:  9.3418157e-01 -5.3899002e-01  2.0941060e+00 */
    { 0x3bad287b,0x404d902d,0x3ad7a4d4 }, /* 368:  5.2843667e-03  3.2119248e+00  1.6452321e-03 */
    { 0xbfe8e5c6,0xbf96d3e9,0xc0094fc0 }, /* 369: -1.8195121e+00 -1.1783420e+00 -2.1454926e+00 */
    { 0xbfb78f48,0xbef4e56c,0xbff244ff }, /* 370: -1.4340601e+00 -4.7831285e-01 -1.8927306e+00 */
    { 0xc04bfd93,0x3f9654bb,0xbf9bdf7f }, /* 371: -3.1873519e+00  1.1744608e+00 -1.2177581e+00 */
    { 0x41163ff6,0xbdefb41b,0x3fcaa83f }, /* 372:  9.3906155e+00 -1.1704274e-01  1.5832595e+00 */
    { 0xbf64042e,0x3f9aee82,0xbf22676b }, /* 373: -8.9068878e-01  1.2104037e+00 -6.3439053e-01 */
    { 0xbf907b85,0x3f08869a,0xbf9090c9 }, /* 374: -1.1287695e+00  5.3330386e-01 -1.1294185e+00 */
    { 0xc10a6a39,0x3f409229,0xbfbdf5b5 }, /* 375: -8.6509333e+00  7.5223023e-01 -1.4840609e+00 */
    { 0x3f5dc594,0x3f9c936e,0x3f1dbf7f }, /* 376:  8.6629605e-01  1.2232492e+00  6.1620325e-01 */
    { 0xbfbc5aeb,0x3f90efdf,0xbf6a3975 }, /* 377: -1.4715246e+00  1.1323203e+00 -9.1493922e-01 */
    { 0x3dda23be,0xc0e777c8,0x40481e9d }, /* 378:  1.0651349e-01 -7.2333717e+00  3.1268685e+00 */
    { 0x4014b3f7,0xc11288fa,0x40392924 }, /* 379:  2.3234842e+00 -9.1584415e+00  2.8931360e+00 */
    { 0x3f941c22,0xb565a28d,0x3fc90fe1 }, /* 380:  1.1571085e+00 -8.5545690e-07  1.5707971e+00 */
    { 0xbf8623b3,0x2fc4a581,0xbfc90fdb }, /* 381: -1.0479645e+00  3.5769790e-10 -1.5707964e+00 */
    { 0x3f694519,0x4c5b023c,0x328855c1 }, /* 382:  9.1121060e-01  5.7411824e+07  1.5871480e-08 */
    { 0x405c4828,0xbfc778d3,0x3fff7b35 }, /* 383:  3.4419041e+00 -1.5583748e+00  1.9959475e+00 */
    { 0x3f919575,0x3f98b037,0x3f42f727 }, /* 384:  1.1373736e+00  1.1928777e+00  7.6158375e-01 */
    { 0x3ff0adc7,0x42335746,0x3d2bad82 }, /* 385:  1.8803033e+00  4.4835228e+01  4.1913517e-02 */
    { 0x3f6ff7af,0x3ebfaa70,0x3f986d91 }, /* 386:  9.3737310e-01  3.7434721e-01  1.1908437e+00 */
    { 0xbf63f0ae,0xbea81720,0xbff64726 }, /* 387: -8.9039123e-01 -3.2830143e-01 -1.9240463e+00 */
    { 0xbf1c46f0,0xbf98d50d,0xc02ad066 }, /* 388: -6.1045742e-01 -1.1940018e+00 -2.6689696e+00 */
    { 0x3f99b949,0x3e4e313b,0x3fb3cc73 }, /* 389:  1.2009670e+00  2.0135967e-01  1.4046768e+00 */
    { 0x31803766,0x3f9dbf46,0x31501375 }, /* 390:  3.7315884e-09  1.2323997e+00  3.0279044e-09 */
    { 0xbff6b13c,0xbd48e64a,0xbfcc5198 }, /* 391: -1.9272838e+00 -4.9047746e-02 -1.5962400e+00 */
    { 0x3f95532a,0x3eb77bd5,0x3fa2e9b7 }, /* 392:  1.1666005e+00  3.5836664e-01  1.2727574e+00 */
    { 0xbe3db74d,0x3e6df030,0xbf2c511c }, /* 393: -1.8526955e-01  2.3236156e-01 -6.7311263e-01 */
    { 0x3f9a4c38,0xc05de404,0x4033a589 }, /* 394:  1.2054510e+00 -3.4670420e+00  2.8069785e+00 */
    { 0x3ff06f36,0x42763157,0x3cf9ef4a }, /* 395:  1.8783939e+00  6.1548183e+01  3.0509610e-02 */
    { 0x3f692f1f,0xbee66bed,0x4001e682 }, /* 396:  9.1087526e-01 -4.5004216e-01  2.0296941e+00 */
    { 0x3ee0a13c,0xbf9f63d0,0x403361d3 }, /* 397:  4.3873012e-01 -1.2452335e+00  2.8028457e+00 */
    { 0x40f49d37,0xbf2987de,0x3fd41f88 }, /* 398:  7.6441913e+00 -6.6222942e-01  1.6572123e+00 */
    { 0xbfdb87b5,0xc01eb0ac,0xc0225568 }, /* 399: -1.7150789e+00 -2.4795332e+00 -2.5364628e+00 */
    { 0xbf29a7c0,0x3f97bb26,0xbf0280bc }, /* 400: -6.6271591e-01  1.1853988e+00 -5.0977683e-01 */
    { 0xc00fe68b,0x3f695191,0xbf97c4a8 }, /* 401: -2.2484462e+00  9.1140085e-01 -1.1856890e+00 */
    { 0xbf61e2f2,0xbfddabda,0xc02ae74e }, /* 402: -8.8236916e-01 -1.7318070e+00 -2.6703677e+00 */
    { 0xbfd950b0,0x3e0facfa,0xbfbe81f7 }, /* 403: -1.6977749e+00  1.4030829e-01 -1.4883412e+00 */
    { 0xbf0eb0a1,0xbfbbd128,0xc031d3ff }, /* 404: -5.5738264e-01 -1.4673204e+00 -2.7785642e+00 */
    { 0xbfc2a817,0x4042395f,0xbeedd7ea }, /* 405: -1.5207547e+00  3.0347517e+00 -4.6453792e-01 */
    { 0x3fbec374,0x3ffa7195,0x3f26a490 }, /* 406:  1.4903398e+00  1.9565912e+00  6.5094852e-01 */
    { 0x3f9d9c7d,0xd4910304,0x40490fdb }, /* 407:  1.2313381e+00 -4.9825668e+12  3.1415927e+00 */
    { 0x403324de,0xbfba3fca,0x40033631 }, /* 408:  2.7991252e+00 -1.4550717e+00  2.0501826e+00 */
    { 0xbfe78d60,0xc052993e,0xc028e471 }, /* 409: -1.8090019e+00 -3.2906032e+00 -2.6389430e+00 */
    { 0x44c6406e,0x3f98d115,0x3fc8f730 }, /* 410:  1.5860134e+03  1.1938807e+00  1.5700436e+00 */
    { 0x3ff5813d,0xc04de7af,0x4026a7f4 }, /* 411:  1.9180065e+00 -3.2172658e+00  2.6040010e+00 */
    { 0xbf72c17e,0x3f668d80,0xbf4fa92a }, /* 412: -9.4826496e-01  9.0059662e-01 -8.1117499e-01 */
    { 0xbf84f769,0x3fe2c1f5,0xbf07c4ba }, /* 413: -1.0388004e+00  1.7715441e+00 -5.3034556e-01 */
    { 0xbffec763,0x3f8d83a8,0xbf882a27 }, /* 414: -1.9904598e+00  1.1055803e+00 -1.0637864e+00 */
    { 0xc100965b,0x3f656b28,0xbfbad8f5 }, /* 415: -8.0367079e+00  8.9616632e-01 -1.4597460e+00 */
    { 0xbed7eed9,0x3f65024c,0xbee18f98 }, /* 416: -4.2174414e-01  8.9456630e-01 -4.4054866e-01 */
    { 0xc1803e1a,0x3f272421,0xbfc3d9fe }, /* 417: -1.6030323e+01  6.5289503e-01 -1.5300901e+00 */
    { 0xc0d8daff,0x3f9f3ead,0xbfb1d26b }, /* 418: -6.7767329e+00  1.2441002e+00 -1.3892339e+00 */
    { 0xbeee84b7,0xbf290575,0xc021bc73 }, /* 419: -4.6585628e-01 -6.6023952e-01 -2.5271270e+00 */
    { 0xbf969d30,0xbed6d7bb,0xbff4e89d }, /* 420: -1.1766720e+00 -4.1961464e-01 -1.9133488e+00 */
    { 0x3ec21c73,0x391036ac,0x3fc903f8 }, /* 421:  3.7912330e-01  1.3753277e-04  1.5704336e+00 */
    { 0x3fe74eaa,0xbfd9c6bc,0x4014de63 }, /* 422:  1.8070881e+00 -1.7013774e+00  2.3260734e+00 */
    { 0xbfde6599,0x3fdbd4c4,0xbf4a8c15 }, /* 423: -1.7374755e+00  1.7174306e+00 -7.9119998e-01 */
    { 0x3f980f88,0x3f9b5a66,0x3f4651fb }, /* 424:  1.1879740e+00  1.2136962e+00  7.7468842e-01 */
    { 0x426b6fd8,0x3ef71cb2,0x3fc8032a }, /* 425:  5.8859222e+01  4.8264080e-01  1.5625966e+00 */
    { 0xbf97e466,0x3f33ed74,0xbf849ddb }, /* 426: -1.1866577e+00  7.0284200e-01 -1.0360674e+00 */
    { 0xbf651633,0x401e0921,0xbeb2029b }, /* 427: -8.9486998e-01  2.4693072e+00 -3.4767613e-01 */
    { 0x3f8cc17a,0x482c72b8,0x36d0f3db }, /* 428:  1.0996544e+00  1.7658688e+05  6.2272716e-06 */
    { 0xbf70326a,0xbff64ae5,0xc02c0674 }, /* 429: -9.3826926e-01 -1.9241606e+00 -2.6878939e+00 */
    { 0x3ebfd8cc,0x4038d3ed,0x3e041f72 }, /* 430:  3.7470090e-01  2.8879349e+00  1.2902620e-01 */
    { 0x3fd5f93c,0xbedf9092,0x3fe9c3fe }, /* 431:  1.6716685e+00 -4.3664986e-01  1.8262937e+00 */
    { 0xbf6c8ca5,0x3f14a93e,0xbf813e57 }, /* 432: -9.2402107e-01  5.8070743e-01 -1.0097150e+00 */
    { 0xbfda84b5,0xc043975e,0xc028755d }, /* 433: -1.7071749e+00 -3.0561137e+00 -2.6321633e+00 */
    { 0x3fd093d2,0xbf10cd9f,0x3ff3d3e5 }, /* 434:  1.6295111e+00 -5.6563753e-01  1.9049040e+00 */
    { 0xbf635ac5,0xbf5e805c,0xc0161b24 }, /* 435: -8.8810378e-01 -8.6914611e-01 -2.3454065e+00 */
    { 0xbea15fb9,0xbee91b5f,0xc0224efb }, /* 436: -3.1518343e-01 -4.5528695e-01 -2.5360706e+00 */
    { 0xc01a4ee1,0xbf95fbae,0xc0017b9e }, /* 437: -2.4110644e+00 -1.1717432e+00 -2.0231700e+00 */
    { 0x3f963aa4,0xbf118815,0x40016621 }, /* 438:  1.1736646e+00 -5.6848270e-01  2.0218585e+00 */
    { 0x3f91c868,0x3fe42077,0x3f1191ff }, /* 439:  1.1389284e+00  1.7822407e+00  5.6863397e-01 */
    { 0x3f8e054f,0xc038bdc4,0x4031937a }, /* 440:  1.1095370e+00 -2.8865824e+00  2.7746263e+00 */
    { 0x40271d08,0xc0e39207,0x40328a89 }, /* 441:  2.6111469e+00 -7.1115756e+00  2.7897055e+00 */
    { 0x3ff81310,0xbeecb275,0x3fe708c4 }, /* 442:  1.9380817e+00 -4.6229902e-01  1.8049550e+00 */
    { 0x3f9a4659,0x3f08c39d,0x3f93a839 }, /* 443:  1.2052718e+00  5.3423482e-01  1.1535712e+00 */
    { 0x3fe40fb2,0xbfc13f0e,0x4011850f }, /* 444:  1.7817290e+00 -1.5097368e+00  2.2737463e+00 */
    { 0x3fa31ceb,0x3fd501f4,0x3f274c93 }, /* 445:  1.2743200e+00  1.6641221e+00  6.5351218e-01 */
    { 0x3d5d4e97,0xbf2f1547,0x40440430 }, /* 446:  5.4030027e-02 -6.8391842e-01  3.0627556e+00 */
    { 0x3fe1feb1,0xbf252edc,0x3ff5e90e }, /* 447:  1.7655851e+00 -6.4524627e-01  1.9211748e+00 */
    { 0x402a05e1,0x3fe994e0,0x3f780a64 }, /* 448:  2.6566088e+00  1.8248558e+00  9.6890855e-01 */
    { 0x3f15308e,0xbecc23c4,0x400aee9b }, /* 449:  5.8277214e-01 -3.9871037e-01  2.1708133e+00 */
    { 0xbf608313,0x3b4cdb4a,0xbfc89b10 }, /* 450: -8.7700003e-01  3.1258636e-03 -1.5672321e+00 */
    { 0xbff05ceb,0xbff3c59c,0xc0173f41 }, /* 451: -1.8778356e+00 -1.9044681e+00 -2.3632357e+00 */
    { 0xbeb96031,0x40842ad3,0xbdb312b2 }, /* 452: -3.6206201e-01  4.1302276e+00 -8.7438002e-02 */
    { 0xc070d23f,0xbf979470,0xbff016d9 }, /* 453: -3.7628324e+00 -1.1842175e+00 -1.8756973e+00 */
    { 0xbc616df1,0xc037a6a2,0xc048c14c }, /* 454: -1.3759122e-02 -2.8695455e+00 -3.1367979e+00 */
    { 0xbf999446,0x3f4a45a0,0xbf7d0b15 }, /* 455: -1.1998374e+00  7.9012489e-01 -9.8845035e-01 */
    { 0xbf5ca9f0,0x3fa177e1,0xbf197468 }, /* 456: -8.6196804e-01  1.2614709e+00 -5.9943247e-01 */
    { 0xc133a03b,0xbe3d79eb,0xbfcb2be2 }, /* 457: -1.1226619e+01 -1.8503539e-01 -1.5872767e+00 */
    { 0xb9471442,0x3ec059e5,0xba047a25 }, /* 458: -1.8985666e-04  3.7568584e-01 -5.0536013e-04 */
    { 0xbee588e3,0xbed1be94,0xc013ea43 }, /* 459: -4.4830999e-01 -4.0965712e-01 -2.3111732e+00 */
    { 0x3f9b9b96,0xbeff15d7,0x3ffad8c5 }, /* 460:  1.2156856e+00 -4.9821350e-01  1.9597403e+00 */
    { 0xbf173be4,0x3ebf5f4c,0xbf80dacc }, /* 461: -5.9075761e-01  3.7377393e-01 -1.0066772e+00 */
    { 0x3f9ad51c,0xbf7592f9,0x400f7108 }, /* 462:  1.2096286e+00 -9.5927387e-01  2.2412739e+00 */
    { 0xbf40bf78,0x3f5e7ed7,0xbf36c0f1 }, /* 463: -7.5292158e-01  8.6912292e-01 -7.1388155e-01 */
    { 0xbee67609,0xbf1030f7,0xc01de963 }, /* 464: -4.5011929e-01 -5.6324714e-01 -2.4673698e+00 */
    { 0xbd0d7a5a,0x3f94c937,0xbcf35aad }, /* 465: -3.4540512e-02  1.1623906e+00 -2.9706324e-02 */
    { 0x3f2a5143,0x3eee7bf6,0x3f75c208 }, /* 466:  6.6530246e-01  4.6578950e-01  9.5999193e-01 */
    { 0xbfc0114c,0x3f8cf106,0xbf700f7c }, /* 467: -1.5005279e+00  1.1011055e+00 -9.3773627e-01 */
    { 0x40cfc677,0xbf71173f,0x3fdb7fb6 }, /* 468:  6.4929767e+00 -9.4176096e-01  1.7148349e+00 */
    { 0x268b7d83,0x3f2811ef,0x26d477d0 }, /* 469:  9.6790825e-16  6.5652364e-01  1.4742930e-15 */
    { 0x4022a0b2,0xbfe59a64,0x400bdeef }, /* 470:  2.5410581e+00 -1.7937741e+00  2.1854818e+00 */
    { 0xbf1a8596,0x3f30d708,0xbf37d87a }, /* 471: -6.0360086e-01  6.9078112e-01 -7.1814692e-01 */
    { 0x3f9f0371,0x3f5f75c8,0x3f7552f8 }, /* 472:  1.2422925e+00  8.7289095e-01  9.5829725e-01 */
    { 0x3f9b5c44,0xbf1966fc,0x4001e185 }, /* 473:  1.2137532e+00 -5.9922767e-01  2.0293896e+00 */
    { 0x3f5edbd1,0xc0058764,0x402fc37b }, /* 474:  8.7054163e-01 -2.0863886e+00  2.7463062e+00 */
    { 0x53d6a96a,0xbf294fb3,0x3fc90fdb }, /* 475:  1.8439306e+12 -6.6137236e-01  1.5707964e+00 */
    { 0x400b2025,0x3edac4f8,0x3fb03822 }, /* 476:  2.1738369e+00  4.2728400e-01  1.3767130e+00 */
    { 0xbd56285b,0xbfcebbbf,0xc046fda7 }, /* 477: -5.2284580e-02 -1.6151046e+00 -3.1092317e+00 */
    { 0xbf331072,0x3e1d1126,0xbfad6e2c }, /* 478: -6.9946969e-01  1.5338573e-01 -1.3549247e+00 */
    { 0xbfa00ee2,0xc0115df5,0xc028da97 }, /* 479: -1.2504542e+00 -2.2713597e+00 -2.6383417e+00 */
    { 0x3f6fce9a,0xbf1a0790,0x40091255 }, /* 480:  9.3674624e-01 -6.0167789e-01  2.1417439e+00 */
    { 0x3f750c6d,0xbeab3d18,0x3ff4166c }, /* 481:  9.5722085e-01 -3.3445048e-01  1.9069343e+00 */
    { 0x3f6815a0,0xbccb9d08,0x3fcc9202 }, /* 482:  9.0657997e-01 -2.4855152e-02  1.5982058e+00 */
    { 0x3e18c743,0x42510803,0x3b3b1b51 }, /* 483:  1.4919762e-01  5.2257824e+01  2.8550217e-03 */
    { 0x405dd078,0x3efc4e80,0x3fb6fbcf }, /* 484:  3.4658489e+00  4.9278641e-01  1.4295596e+00 */
    { 0xbfcb4e22,0xbf96f0e4,0xc00d6771 }, /* 485: -1.5883219e+00 -1.1792264e+00 -2.2094386e+00 */
    { 0xbf62fce0,0x4275e43e,0xbc6c4d7f }, /* 486: -8.8667107e-01  6.1472893e+01 -1.4422773e-02 */
    { 0xc0fb57c6,0x3eba0b87,0xbfc324ff }, /* 487: -7.8544645e+00  3.6336920e-01 -1.5245665e+00 */
    { 0x3f1ab107,0x3f9468da,0x3ef5fb9c }, /* 488:  6.0426372e-01  1.1594498e+00  4.8043525e-01 */
    { 0xbf7447a2,0x3f2f8639,0xbf729ee2 }, /* 489: -9.5421803e-01  6.8564183e-01 -9.4773686e-01 */
    { 0x3f971bd2,0xbf7339ab,0x400fe6c0 }, /* 490:  1.1805365e+00 -9.5009869e-01  2.2484589e+00 */
    { 0xbf696274,0x3f2f7e32,0xbf6d119d }, /* 491: -9.1165853e-01  6.8551934e-01 -9.2605001e-01 */
    { 0xbf686ba0,0xbf4ee9be,0xc01315b7 }, /* 492: -9.0789223e-01 -8.0825412e-01 -2.2982004e+00 */
    { 0xbf95d2b9,0xbee49850,0xbff7b4b5 }, /* 493: -1.1704932e+00 -4.4647455e-01 -1.9352022e+00 */
    { 0xbf61cc2d,0x3f23ed00,0xbf715e1f }, /* 494: -8.8202173e-01  6.4033508e-01 -9.4284242e-01 */
    { 0xc37117f9,0xbf9a94f5,0xbfc9b3fe }, /* 495: -2.4109364e+02 -1.2076708e+00 -1.5758054e+00 */
    { 0x3ee0d440,0x3ff90c6f,0x3e634be5 }, /* 496:  4.3911934e-01  1.9456919e+00  2.2196920e-01 */
    { 0xbf5bdde4,0xbf0b27a6,0xc008a4d4 }, /* 497: -8.5885453e-01 -5.4357374e-01 -2.1350603e+00 */
    { 0x3feb3da0,0x40139737,0x3f2c4135 }, /* 498:  1.8378181e+00  2.3061044e+00  6.7286998e-01 */
    { 0xbf0b4297,0x3efce831,0xbf55640e }, /* 499: -5.4398483e-01  4.9395898e-01 -8.3355796e-01 */
    { 0x3fd4320c,0x3f64364f,0x3f89e8b6 }, /* 500:  1.6577773e+00  8.9145368e-01  1.0774143e+00 */
};

void x_exit (int index)
{
#ifndef	__AVR__
    fprintf (stderr, "t[%d]:  %#lx\n", index - 1, v.lo);
#endif
    exit (index ? index : -1);
}

int main ()
{
    union lofl_u y, x, z;
    unsigned long v1, z1, r;
    int i;
    
    for (i = 0; i < (int) (sizeof(t) / sizeof(t[0])); i++) {
	y.lo = pgm_read_dword (& t[i].y);
	x.lo = pgm_read_dword (& t[i].x);
	z.lo = pgm_read_dword (& t[i].z);
	v.fl = atan2 (y.fl, x.fl);
	
	v1 = (v.lo < 0) ? (unsigned long)~(v.lo) : v.lo + 0x80000000;
	z1 = (z.lo < 0) ? (unsigned long)~(z.lo) : z.lo + 0x80000000;
	r = (v1 >= z1) ? v1 - z1 : z1 - v1;
	
	if (r > 2) x_exit (i+1);
    }
    return 0;
}
