#ifndef _INTERRUPT_H_
#define _INTERRUPT_H_

#include <io.h>

#define sei()  __asm__ __volatile__ ("sei" ::)
#define cli()  __asm__ __volatile__ ("cli" ::)

#ifdef __cplusplus
extern "C" {
#endif

extern inline void enable_external_int (unsigned char ints)
{
#ifdef EIMSK
  outp (ints, EIMSK);
#else
#ifdef GIMSK
  outp (ints, GIMSK);
#endif
#endif
}

extern inline void timer_enable_int (unsigned char ints)
{
#ifdef TIMSK
  outp (ints, TIMSK);
#endif
}

#ifdef __cplusplus
}
#endif

#endif
