/*
 * Decompiled with CFR 0.152.
 */
package org.dom4j.io;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dom4j.Branch;
import org.dom4j.Document;
import org.dom4j.DocumentFactory;
import org.dom4j.DocumentType;
import org.dom4j.Element;
import org.dom4j.ElementHandler;
import org.dom4j.Namespace;
import org.dom4j.QName;
import org.dom4j.dtd.AttributeDecl;
import org.dom4j.dtd.ElementDecl;
import org.dom4j.dtd.ExternalEntityDecl;
import org.dom4j.dtd.InternalEntityDecl;
import org.dom4j.io.DispatchHandler;
import org.dom4j.io.ElementStack;
import org.dom4j.tree.AbstractElement;
import org.dom4j.tree.NamespaceStack;
import org.xml.sax.Attributes;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.ext.DeclHandler;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.DefaultHandler;

public class SAXContentHandler
extends DefaultHandler
implements LexicalHandler,
DeclHandler,
DTDHandler {
    private DocumentFactory documentFactory;
    private Document document;
    private ElementStack elementStack;
    private NamespaceStack namespaceStack;
    private ElementHandler elementHandler;
    private String entity;
    private boolean insideDTDSection;
    private boolean insideCDATASection;
    private Map availableNamespaceMap = new HashMap();
    private List declaredNamespaceList = new ArrayList();
    private List internalDTDDeclarations;
    private List externalDTDDeclarations;
    private int declaredNamespaceIndex;
    private EntityResolver entityResolver;
    private InputSource inputSource;
    private Element currentElement;
    private boolean includeInternalDTDDeclarations = false;
    private boolean includeExternalDTDDeclarations = false;
    private int entityLevel;
    private boolean internalDTDsubset = false;
    private boolean mergeAdjacentText = false;
    private boolean textInTextBuffer = false;
    private StringBuffer textBuffer;
    private boolean stripWhitespaceText = false;

    public SAXContentHandler() {
        this(DocumentFactory.getInstance());
    }

    public SAXContentHandler(DocumentFactory documentFactory) {
        this.documentFactory = documentFactory;
        this.namespaceStack = new NamespaceStack(documentFactory);
    }

    public SAXContentHandler(DocumentFactory documentFactory, ElementHandler elementHandler) {
        this.documentFactory = documentFactory;
        this.elementHandler = elementHandler;
        this.namespaceStack = new NamespaceStack(documentFactory);
    }

    public SAXContentHandler(DocumentFactory documentFactory, ElementHandler elementHandler, ElementStack elementStack) {
        this.documentFactory = documentFactory;
        this.elementHandler = elementHandler;
        this.elementStack = elementStack;
        this.namespaceStack = new NamespaceStack(documentFactory);
    }

    protected void addAttributes(Element element, Attributes attributes) {
        boolean noNamespaceAttributes = false;
        if (element instanceof AbstractElement) {
            AbstractElement baseElement = (AbstractElement)element;
            baseElement.setAttributes(attributes, this.namespaceStack, noNamespaceAttributes);
        } else {
            int size = attributes.getLength();
            int i = 0;
            while (i < size) {
                String attributeQualifiedName = attributes.getQName(i);
                if (noNamespaceAttributes || !attributeQualifiedName.startsWith("xmlns")) {
                    String attributeURI = attributes.getURI(i);
                    String attributeLocalName = attributes.getLocalName(i);
                    String attributeValue = attributes.getValue(i);
                    QName attributeQName = this.namespaceStack.getAttributeQName(attributeURI, attributeLocalName, attributeQualifiedName);
                    element.addAttribute(attributeQName, attributeValue);
                }
                ++i;
            }
        }
    }

    protected void addDTDDeclaration(Object declaration) {
        if (this.internalDTDDeclarations == null) {
            this.internalDTDDeclarations = new ArrayList();
        }
        this.internalDTDDeclarations.add(declaration);
    }

    protected void addDeclaredNamespaces(Element element) {
        Namespace elementNamespace = element.getNamespace();
        int size = this.namespaceStack.size();
        while (this.declaredNamespaceIndex < size) {
            Namespace namespace = this.namespaceStack.getNamespace(this.declaredNamespaceIndex);
            if (namespace != elementNamespace) {
                element.add(namespace);
            }
            ++this.declaredNamespaceIndex;
        }
    }

    protected void addExternalDTDDeclaration(Object declaration) {
        if (this.externalDTDDeclarations == null) {
            this.externalDTDDeclarations = new ArrayList();
        }
        this.externalDTDDeclarations.add(declaration);
    }

    public void attributeDecl(String eName, String aName, String type, String valueDefault, String value) throws SAXException {
        if (this.internalDTDsubset) {
            if (this.includeInternalDTDDeclarations) {
                this.addDTDDeclaration(new AttributeDecl(eName, aName, type, valueDefault, value));
            }
        } else if (this.includeExternalDTDDeclarations) {
            this.addExternalDTDDeclaration(new AttributeDecl(eName, aName, type, valueDefault, value));
        }
    }

    public void characters(char[] ch, int start, int end) throws SAXException {
        if (end == 0) {
            return;
        }
        if (this.currentElement != null) {
            if (this.entity != null) {
                if (this.mergeAdjacentText && this.textInTextBuffer) {
                    this.completeCurrentTextNode();
                }
                this.currentElement.addEntity(this.entity, new String(ch, start, end));
                this.entity = null;
            } else if (this.insideCDATASection) {
                if (this.mergeAdjacentText && this.textInTextBuffer) {
                    this.completeCurrentTextNode();
                }
                this.currentElement.addCDATA(new String(ch, start, end));
            } else if (this.mergeAdjacentText) {
                this.textBuffer.append(ch, start, end);
                this.textInTextBuffer = true;
            } else {
                this.currentElement.addText(new String(ch, start, end));
            }
        }
    }

    public void comment(char[] ch, int start, int end) throws SAXException {
        if (this.mergeAdjacentText && this.textInTextBuffer) {
            this.completeCurrentTextNode();
        }
        String text = new String(ch, start, end);
        if (!this.insideDTDSection && text.length() > 0) {
            if (this.currentElement != null) {
                this.currentElement.addComment(text);
            } else {
                this.document.addComment(text);
            }
        }
    }

    protected void completeCurrentTextNode() {
        if (this.stripWhitespaceText) {
            boolean whitespace = true;
            int i = 0;
            int size = this.textBuffer.length();
            while (i < size) {
                if (!Character.isWhitespace(this.textBuffer.charAt(i))) {
                    whitespace = false;
                    break;
                }
                ++i;
            }
            if (!whitespace) {
                this.currentElement.addText(this.textBuffer.toString());
            }
        } else {
            this.currentElement.addText(this.textBuffer.toString());
        }
        this.textBuffer.setLength(0);
        this.textInTextBuffer = false;
    }

    protected Document createDocument() {
        Document document = this.documentFactory.createDocument();
        document.setEntityResolver(this.entityResolver);
        if (this.inputSource != null) {
            document.setName(this.inputSource.getSystemId());
        }
        return document;
    }

    protected ElementStack createElementStack() {
        return new ElementStack();
    }

    public void elementDecl(String name, String model) throws SAXException {
        if (this.internalDTDsubset) {
            if (this.includeInternalDTDDeclarations) {
                this.addDTDDeclaration(new ElementDecl(name, model));
            }
        } else if (this.includeExternalDTDDeclarations) {
            this.addExternalDTDDeclaration(new ElementDecl(name, model));
        }
    }

    public void endCDATA() throws SAXException {
        this.insideCDATASection = false;
    }

    public void endDTD() throws SAXException {
        DocumentType docType;
        this.insideDTDSection = false;
        if (this.document != null && (docType = this.document.getDocType()) != null) {
            if (this.internalDTDDeclarations != null) {
                docType.setInternalDeclarations(this.internalDTDDeclarations);
            }
            if (this.externalDTDDeclarations != null) {
                docType.setExternalDeclarations(this.externalDTDDeclarations);
            }
        }
        this.internalDTDDeclarations = null;
        this.externalDTDDeclarations = null;
    }

    public void endDocument() throws SAXException {
        this.namespaceStack.clear();
        this.elementStack.clear();
        this.currentElement = null;
        this.textBuffer = null;
    }

    public void endElement(String namespaceURI, String localName, String qName) {
        if (this.mergeAdjacentText && this.textInTextBuffer) {
            this.completeCurrentTextNode();
        }
        if (this.elementHandler != null && this.currentElement != null) {
            this.elementHandler.onEnd(this.elementStack);
        }
        this.elementStack.popElement();
        this.currentElement = this.elementStack.peekElement();
    }

    public void endEntity(String name) throws SAXException {
        --this.entityLevel;
        this.entity = null;
        if (this.entityLevel == 0) {
            this.internalDTDsubset = true;
        }
    }

    public void endPrefixMapping(String prefix) throws SAXException {
        this.namespaceStack.pop(prefix);
        this.declaredNamespaceIndex = this.namespaceStack.size();
    }

    public void error(SAXParseException exception) throws SAXException {
        throw exception;
    }

    public void externalEntityDecl(String name, String publicID, String systemID) throws SAXException {
        if (this.internalDTDsubset) {
            if (this.includeInternalDTDDeclarations) {
                this.addDTDDeclaration(new ExternalEntityDecl(name, publicID, systemID));
            }
        } else if (this.includeExternalDTDDeclarations) {
            this.addExternalDTDDeclaration(new ExternalEntityDecl(name, publicID, systemID));
        }
    }

    public void fatalError(SAXParseException exception) throws SAXException {
        throw exception;
    }

    public Document getDocument() {
        if (this.document == null) {
            this.document = this.createDocument();
        }
        return this.document;
    }

    public ElementStack getElementStack() {
        return this.elementStack;
    }

    public EntityResolver getEntityResolver() {
        return this.entityResolver;
    }

    public InputSource getInputSource() {
        return this.inputSource;
    }

    public void internalEntityDecl(String name, String value) throws SAXException {
        if (this.internalDTDsubset) {
            if (this.includeInternalDTDDeclarations) {
                this.addDTDDeclaration(new InternalEntityDecl(name, value));
            }
        } else if (this.includeExternalDTDDeclarations) {
            this.addExternalDTDDeclaration(new InternalEntityDecl(name, value));
        }
    }

    protected boolean isIgnorableEntity(String name) {
        return "amp".equals(name) || "apos".equals(name) || "gt".equals(name) || "lt".equals(name) || "quot".equals(name);
    }

    public boolean isIncludeExternalDTDDeclarations() {
        return this.includeExternalDTDDeclarations;
    }

    public boolean isIncludeInternalDTDDeclarations() {
        return this.includeInternalDTDDeclarations;
    }

    public boolean isMergeAdjacentText() {
        return this.mergeAdjacentText;
    }

    public boolean isStripWhitespaceText() {
        return this.stripWhitespaceText;
    }

    public void notationDecl(String name, String publicId, String systemId) throws SAXException {
    }

    public void processingInstruction(String target, String data) throws SAXException {
        if (this.mergeAdjacentText && this.textInTextBuffer) {
            this.completeCurrentTextNode();
        }
        if (this.currentElement != null) {
            this.currentElement.addProcessingInstruction(target, data);
        } else {
            this.document.addProcessingInstruction(target, data);
        }
    }

    public void setElementStack(ElementStack elementStack) {
        this.elementStack = elementStack;
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this.entityResolver = entityResolver;
    }

    public void setIncludeExternalDTDDeclarations(boolean includeExternalDTDDeclarations) {
        this.includeExternalDTDDeclarations = includeExternalDTDDeclarations;
    }

    public void setIncludeInternalDTDDeclarations(boolean includeInternalDTDDeclarations) {
        this.includeInternalDTDDeclarations = includeInternalDTDDeclarations;
    }

    public void setInputSource(InputSource inputSource) {
        this.inputSource = inputSource;
    }

    public void setMergeAdjacentText(boolean mergeAdjacentText) {
        this.mergeAdjacentText = mergeAdjacentText;
    }

    public void setStripWhitespaceText(boolean stripWhitespaceText) {
        this.stripWhitespaceText = stripWhitespaceText;
    }

    public void startCDATA() throws SAXException {
        this.insideCDATASection = true;
    }

    public void startDTD(String name, String publicId, String systemId) throws SAXException {
        if (this.document != null) {
            this.document.addDocType(name, publicId, systemId);
        }
        this.insideDTDSection = true;
        this.internalDTDsubset = true;
    }

    public void startDocument() throws SAXException {
        this.document = this.createDocument();
        this.currentElement = null;
        if (this.elementStack == null) {
            this.elementStack = this.createElementStack();
        } else {
            this.elementStack.clear();
        }
        if (this.elementHandler != null && this.elementHandler instanceof DispatchHandler) {
            this.elementStack.setDispatchHandler((DispatchHandler)this.elementHandler);
        }
        this.namespaceStack.clear();
        this.declaredNamespaceIndex = 0;
        if (this.mergeAdjacentText && this.textBuffer == null) {
            this.textBuffer = new StringBuffer();
        }
        this.textInTextBuffer = false;
    }

    public void startElement(String namespaceURI, String localName, String qualifiedName, Attributes attributes) throws SAXException {
        if (this.mergeAdjacentText && this.textInTextBuffer) {
            this.completeCurrentTextNode();
        }
        QName qName = this.namespaceStack.getQName(namespaceURI, localName, qualifiedName);
        Branch branch = this.currentElement;
        if (branch == null) {
            branch = this.document;
        }
        Element element = branch.addElement(qName);
        this.addDeclaredNamespaces(element);
        this.addAttributes(element, attributes);
        this.elementStack.pushElement(element);
        this.currentElement = element;
        if (this.elementHandler != null) {
            this.elementHandler.onStart(this.elementStack);
        }
    }

    public void startEntity(String name) throws SAXException {
        ++this.entityLevel;
        this.entity = null;
        if (!this.insideDTDSection && !this.isIgnorableEntity(name)) {
            this.entity = name;
        }
        this.internalDTDsubset = false;
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        this.namespaceStack.push(prefix, uri);
    }

    public void unparsedEntityDecl(String name, String publicId, String systemId, String notationName) throws SAXException {
    }

    public void warning(SAXParseException exception) throws SAXException {
    }
}

