/*
 * Decompiled with CFR 0.152.
 */
package hu.origo.lucenetools.iac;

import hu.origo.lucenetools.iac.SearcherEvent;
import hu.origo.lucenetools.iac.SearcherListener;
import java.io.IOException;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.HitCollector;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopFieldDocs;
import org.apache.lucene.search.Weight;

public class ManagedSearcher
extends Searcher {
    protected Searcher m_searcher;
    protected long m_lastUsed;
    protected SearcherListener m_manager;

    public ManagedSearcher(SearcherListener manager, Searcher searcher) {
        this.m_manager = manager;
        this.m_searcher = searcher;
    }

    Searcher getRealSearcher() {
        return this.m_searcher;
    }

    public void close() throws IOException {
        this.m_manager.searcherClosed(new SearcherEvent((Object)this));
    }

    public Document doc(int i) throws IOException {
        return this.m_searcher.doc(i);
    }

    public TopDocs search(Query query, Filter filter, int n) throws IOException {
        return this.m_searcher.search(query, filter, n);
    }

    public TopDocs search(Weight weight, Filter filter, int doc) throws IOException {
        return this.m_searcher.search(weight, filter, doc);
    }

    public void search(Query query, Filter filter, HitCollector results) throws IOException {
        this.m_searcher.search(query, filter, results);
    }

    public void search(Weight weight, Filter filter, HitCollector results) throws IOException {
        this.m_searcher.search(weight, filter, results);
    }

    public TopFieldDocs search(Query query, Filter filter, int n, Sort sort) throws IOException {
        return this.m_searcher.search(query, filter, n, sort);
    }

    public TopFieldDocs search(Weight weight, Filter filter, int n, Sort sort) throws IOException {
        return this.m_searcher.search(weight, filter, n, sort);
    }

    public int docFreq(Term term) throws IOException {
        return this.m_searcher.docFreq(term);
    }

    public int maxDoc() throws IOException {
        return this.m_searcher.maxDoc();
    }

    public Query rewrite(Query original) throws IOException {
        return this.m_searcher.rewrite(original);
    }

    public Explanation explain(Query query, int doc) throws IOException {
        return this.m_searcher.explain(query, doc);
    }

    public Explanation explain(Weight weight, int doc) throws IOException {
        return this.m_searcher.explain(weight, doc);
    }
}

