/*
 * Decompiled with CFR 0.152.
 */
package nz.net.catalyst.lucene.cache;

import java.io.IOException;
import java.util.HashMap;
import nz.net.catalyst.Log;
import nz.net.catalyst.lucene.cache.SearcherSource;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.HitCollector;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopFieldDocs;
import org.apache.lucene.search.Weight;

public abstract class SearcherCache
implements SearcherSource {
    private boolean debug = false;
    protected CachedSearcher m_actualCachedSearcher = null;
    protected HashMap m_oldSearchersInfo = new HashMap();

    public synchronized void release() throws IOException {
        if (this.m_actualCachedSearcher != null) {
            this.m_actualCachedSearcher.getRealSearcher().close();
            this.m_actualCachedSearcher = null;
        }
        for (CachedSearcher searcher : this.m_oldSearchersInfo.keySet()) {
            searcher.getRealSearcher().close();
        }
        this.m_oldSearchersInfo.clear();
    }

    public synchronized Searcher getSearcher(int maxSearchers) throws IOException {
        if (this.m_actualCachedSearcher == null || this.isSearcherOld(this.m_actualCachedSearcher)) {
            if (this.m_actualCachedSearcher != null) {
                if (this.m_actualCachedSearcher.getCheckoutCount() <= 1) {
                    Log.debug("getSearcher: closing current expired unused searcher");
                    this.m_actualCachedSearcher.getRealSearcher().close();
                    Log.debug("getSearcher: creating fresh searcher due to changed index");
                    this.m_actualCachedSearcher = this.createNewCachedSearcher();
                } else if (this.m_oldSearchersInfo.size() < maxSearchers) {
                    Log.debug("getSearcher: flagging current, in-use searcher as expired");
                    this.m_oldSearchersInfo.put(this.m_actualCachedSearcher, this.m_actualCachedSearcher);
                    Log.debug("getSearcher: creating fresh searcher due to changed index");
                    this.m_actualCachedSearcher = this.createNewCachedSearcher();
                } else {
                    Log.info("getSearcher: using existing searcher due to max threshold (" + maxSearchers + ") reached");
                    this.m_actualCachedSearcher.checkout();
                }
            } else {
                Log.debug("getSearcher: creating initial searcher");
                this.m_actualCachedSearcher = this.createNewCachedSearcher();
            }
        } else {
            Log.debug("getSearcher: using current cached searcher");
            this.m_actualCachedSearcher.checkout();
        }
        return this.m_actualCachedSearcher;
    }

    protected abstract boolean isSearcherOld(CachedSearcher var1);

    protected abstract CachedSearcher createNewCachedSearcher() throws IOException;

    protected synchronized void searcherClosed(CachedSearcher searcher) throws IOException {
        this.releaseSearcher(searcher);
    }

    protected synchronized void releaseSearcher(CachedSearcher searcherToRelease) throws IOException {
        if (searcherToRelease.getCheckoutCount() > 1) {
            Log.debug("releaseSearcher: searcher checked in but not closed");
            searcherToRelease.checkin();
        } else if (this.m_oldSearchersInfo.containsKey((Object)searcherToRelease)) {
            Log.debug("releaseSearcher: searcher closed");
            searcherToRelease.getRealSearcher().close();
            this.m_oldSearchersInfo.remove((Object)searcherToRelease);
        }
    }

    protected class CachedSearcher
    extends Searcher {
        int m_checkoutCount = 1;
        long m_creationTime;
        Searcher m_searcher;

        CachedSearcher(Searcher searcher) {
            this.m_searcher = searcher;
            this.m_creationTime = System.currentTimeMillis();
            this.m_checkoutCount = 1;
        }

        long getCreationTime() {
            return this.m_creationTime;
        }

        Searcher getRealSearcher() {
            return this.m_searcher;
        }

        int getCheckoutCount() {
            return this.m_checkoutCount;
        }

        void checkout() {
            ++this.m_checkoutCount;
        }

        void checkin() {
            --this.m_checkoutCount;
        }

        public boolean equals(Object other) {
            if (other instanceof CachedSearcher) {
                CachedSearcher c = (CachedSearcher)((Object)other);
                return c.m_creationTime == this.m_creationTime && c.m_checkoutCount == this.m_checkoutCount && c.m_searcher == this.m_searcher;
            }
            return false;
        }

        public int hashCode() {
            return this.m_searcher.hashCode() * this.m_checkoutCount;
        }

        public void close() throws IOException {
            SearcherCache.this.searcherClosed(this);
        }

        public Document doc(int i) throws IOException {
            return this.m_searcher.doc(i);
        }

        public void search(Query query, Filter filter, HitCollector results) throws IOException {
            this.m_searcher.search(query, filter, results);
        }

        public void search(Weight weight, Filter filter, HitCollector results) throws IOException {
            this.m_searcher.search(weight, filter, results);
        }

        public TopDocs search(Query query, Filter filter, int n) throws IOException {
            return this.m_searcher.search(query, filter, n);
        }

        public TopDocs search(Weight weight, Filter filter, int n) throws IOException {
            return this.m_searcher.search(weight, filter, n);
        }

        public TopFieldDocs search(Query query, Filter filter, int n, Sort sort) throws IOException {
            return this.m_searcher.search(query, filter, n, sort);
        }

        public TopFieldDocs search(Weight weight, Filter filter, int n, Sort sort) throws IOException {
            return this.m_searcher.search(weight, filter, n, sort);
        }

        public int docFreq(Term term) throws IOException {
            return this.m_searcher.docFreq(term);
        }

        public int maxDoc() throws IOException {
            return this.m_searcher.maxDoc();
        }

        public Query rewrite(Query original) throws IOException {
            return this.m_searcher.rewrite(original);
        }

        public Explanation explain(Query query, int doc) throws IOException {
            return this.m_searcher.explain(query, doc);
        }

        public Explanation explain(Weight weight, int doc) throws IOException {
            return this.m_searcher.explain(weight, doc);
        }
    }
}

