/* ******************************************************************** */
/* CATALYST PHP Source Code                                             */
/* -------------------------------------------------------------------- */
/* This program is free software; you can redistribute it and/or modify */
/* it under the terms of the GNU General Public License as published by */
/* the Free Software Foundation; either version 2 of the License, or    */
/* (at your option) any later version.                                  */
/*                                                                      */
/* This program is distributed in the hope that it will be useful,      */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of       */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        */
/* GNU General Public License for more details.                         */
/*                                                                      */
/* You should have received a copy of the GNU General Public License    */
/* along with this program; if not, write to:                           */
/*   The Free Software Foundation, Inc., 59 Temple Place, Suite 330,    */
/*   Boston, MA  02111-1307  USA                                        */
/* -------------------------------------------------------------------- */
/*                                                                      */
/* Filename:    fieldvalidation.js                                      */
/* Author:      Paul Waite                                              */
/* Description: Javascript function for validating fields in a form.    */
/*                                                                      */
/* ******************************************************************** */
// VARIABLES
var digs=' ,0123456789';
// IMPOSE INTEGER LIMITS - will rewrite field
function limitInt(fmelem, lo, hi, dflt) {
  var vali = parseInt(fmelem.value.replace(/\$|,|%/g, ''));
  if (isNaN(vali)) {
    if (dflt) vali = dflt;
    else vali = lo;
  }
  else if (vali < lo) vali = lo;
  else if (vali > hi) vali = hi;
  fmelem.value = vali;
}
// VALIDATE FIELD IS NON-BLANK
function isNonBlank(fmelem, failmsg) {
  var i, c;
  var ok=true;

  if (fmelem.type == 'select-one') {
    if (fmelem.selectedIndex == -1) {
      ok=false;
    }
    else if (fmelem.options[fmelem.selectedIndex].value == '') {
      ok=false;
    }
  }
  else {
    if ((fmelem.value == null) || (fmelem.value == '')) {
        ok=false;
    }

    for (i = 0; i < fmelem.value.length; i++) {
        c = fmelem.value.charAt(i);
        if (c != '\s') {
        return ok;
        }
    }
    ok=false;
  }

  if (!ok) {
    valFail(fmelem, failmsg);
  }
  else {
    return ok;
  }
}
// VALIDATE FIELD IS ONLY DIGITS
function isOnlyDigits(fmelem, failmsg) {
  var ok=true;
  if (fmelem.value.length > 0) ok=strDigits(fmelem.value);
  if (!ok) valFail(fmelem, failmsg);
  return ok;
}
// VALIDATE FIELD HAS VALID DATE d[d]/m[m]/yyyy or d[d]-m[m]-yyyy
function isValidDate(fmelem, failmsg) {
  var ok=true;
  if (fmelem.value.length > 0) ok=strValidDate(fmelem.value);
  if (!ok) valFail(fmelem, failmsg);
  return ok;
}
// VALIDATE FIELD HAS VALID TIME [H]H:MM[:SS][ AM|PM]
function isValidTime(fmelem, failmsg) {
  var ok=true;
  if (fmelem.value.length > 0) ok=strValidTime(fmelem.value);
  if (!ok) valFail(fmelem, failmsg);
  return ok;
}
// UTILITY FUNCTIONS - called by validation functions above
// String is non-null and all digits

// Generic validation popup, field highlighting and keyboard focus.
function valFail(fmelem, failmsg) {
  if (failmsg != '') {
    var s='\n\nNOTE: your data entry has failed validation.\n';
    alert(s + failmsg + '\n\n');
  }
  if (fmelem) {
    fmelem.style.backgroundColor='rgb(255,255,0)';
    if(fmelem.type.substr(0,6)!='select') fmelem.select();
  }
}
// String is a numeric/number
function strNumeric(s) {
  var ok=true;
  if ((s != '') && strDigits(s)) {
    if (isNaN(parseInt(s))) ok=false;
  }
  return ok;
}
// String is digits or space or comma
function strDigits(s) {
  var i, ok=true;
  for (i=0; i<s.length; i++) {
    if (digs.indexOf(s.substring(i, i+1)) == -1) {
      ok = false;
      break;
    }
  }
  return ok;
}
// String is a valid date
function strValidDate(s)  {
  var month=0, day=0, year=0, offset=0, dtVal='', testStr='', sep='';
  if (s.length == 0) return true;
  dtVal = s;
  if (dtVal.indexOf('/') > -1) sep='/';
  else if (dtVal.indexOf('-') > -1) sep='-';
  // Day
  offset = dtVal.indexOf(sep);
  if (offset < 1) return false;
  testStr = dtVal.substring(0, offset);
  if (!strDigits(testStr)) return false;
  day = parseInt(testStr, 10);
  if ((day < 1) || (day > 31)) return false;
  // Month
  dtVal = dtVal.substring(offset+1, dtVal.length);
  offset = dtVal.indexOf(sep);
  if (offset < 1) return false;
  testStr = dtVal.substring(0, offset);
  if (!strDigits(testStr)) return false;
  month = parseInt(testStr, 10);
  if ((month < 1) || (month > 12)) return false;
  // Year (first remove extraneous content if present)
  testStr = dtVal.substring(offset+1, dtVal.length);
  if ( testStr.length > 4) {
    testStr = testStr.substring( 0, 4 );
  }
  if (!strDigits(testStr)) return false;
  year = parseInt( testStr, 10 );
  if ( month == 2 ) {
    if ((4 * Math.floor(year / 4)) == year) {
      if ( day > 29 ) return false;
    }
    else {
      if (day > 28) return false;
    }
  }
  else if ((month == 4) || (month == 6) || (month == 9) || (month == 11) ) {
    if (day > 30) return false;
  }
  return true;
}
// String is a valid time
function strValidTime(s) {
  var hour=0, minute=0, second=0, offset=0, tiVal='', testStr='', sep='';
  tiVal = s;
  if (tiVal.indexOf(':') > -1) sep=':';
  else if (tiVal.indexOf('.') > -1) sep='.';
  offset = tiVal.indexOf(sep);
  if (offset < 1) return false;
  // Hour
  testStr = tiVal.substring(0,offset);
  if (!strDigits(testStr)) return false;
  hour = parseInt(testStr, 10);
  if (hour > 23) return false;
  // Minutes
  tiVal = tiVal.substring(offset+1, tiVal.length);
  testStr = tiVal.substring(0, 2);
  if (!strDigits(testStr)) return false;
  minute = parseInt(testStr, 10);
  if (minute > 59) return false;
  // Seconds
  tiVal = tiVal.substring(2, tiVal.length);
  if (tiVal.length > 0) {
    if (tiVal.charAt(0) == sep) {
      testStr = tiVal.substring(1, 3);
      if (!strDigits(testStr)) return false;
      second = parseInt(testStr, 10);
      if (second > 59) return false;
      tiVal = tiVal.substring(3, tiVal.length);
    }
  }
  // AM/PM suffix
  if (tiVal.length > 0) {
    if (tiVal.charAt(0) == ' ') tiVal = tiVal.substring(1, tiVal.length);
    tiVal = tiVal.toUpperCase();
    if (tiVal == "PM") {
      hour += 12;
      if (hour > 23) return false;
    }
    else if (tiVal == "AM") {
      if (hour > 12) return false;
    }
    else return false;
  }
  return true;
}
// Trim whitespace from string
function trimStr(s) {
  var start=-1, end=-1, done;
  start = 0;
  done = false;
  while (start < s.length && !done) {
    if (s.substring(start, start+1) != ' ') done = true;
    else start++;
  }
  end = s.length - 1;
  done = false;
  while (end >= 0 && !done) {
    if (s.substring(end, end+1) != ' ') {
      done = true;
      end++;
    }
    else end--;
  }
  if (start != -1 && end != -1) return s.substring(start, end);
  else return '';
}