#!/usr/bin/php4 -q
<?php
/* ******************************************************************** */
/* CATALYST PHP Source Code                                             */
/* -------------------------------------------------------------------- */
/* This program is free software; you can redistribute it and/or modify */
/* it under the terms of the GNU General Public License as published by */
/* the Free Software Foundation; either version 2 of the License, or    */
/* (at your option) any later version.                                  */
/*                                                                      */
/* This program is distributed in the hope that it will be useful,      */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of       */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        */
/* GNU General Public License for more details.                         */
/*                                                                      */
/* You should have received a copy of the GNU General Public License    */
/* along with this program; if not, write to:                           */
/*   The Free Software Foundation, Inc., 59 Temple Place, Suite 330,    */
/*   Boston, MA  02111-1307  USA                                        */
/* -------------------------------------------------------------------- */
/*                                                                      */
/* Filename:    fix-null-layout-ids.php                                 */
/* Author:      Paul Waite                                              */
/* Description: Fixup for problems with block having null layout IDs    */
/*              This script cruises through all layouts, and block of   */
/*              these layouts, making sure that each block has a valid  */
/*              layout_id.                                              */
/*                                                                      */
/* ******************************************************************** */
// CLI Program working dir is always its own directory
// so we need to get into the website root directory..
chdir("../..");

include_once("application.php");
include_once("layout-defs.php");

debug_on(DBG_DIAGNOSTIC);
debug_output(DBG_O_CLI);

debugbr("block null layout_id fixup begins..");
//start_transaction();

$layouts = dbrecordset("SELECT * FROM ax_layout");
if ($layouts->hasdata) {
  $nullblocks = 0;
  $totblocks = 0;
  $totlayouts = 0;
  $fixed_blocks = array();
  $missing_blocks = array();
  do {
    $totlayouts += 1;
    $layout_id = $layouts->field("layout_id");
    $thelayout = new layout($layout_id);
    if ($thelayout->tot_block > 0) {
      foreach ($thelayout->layout_blocks as $rowcol => $blockid) {
        $totblocks += 1;
        if ($blockid != "") {
          $b = new block($blockid);
          if ($b->exists) {
            if ($b->layoutid == "") {
              dbcommand("update ax_block set layout_id=$layout_id where block_id=$blockid");
              $fixed_blocks[] = $blockid;
            }
          }
          else {
            $missing_blocks[] = $blockid;
          }
        }
        else $nullblocks += 1;
      } // foreach
    }
  } while ($layouts->get_next());

  debugbr("layouts processed: " . $totlayouts);
  debugbr("null blocks: " . $nullblocks);
  debugbr("blocks processed: " . $totblocks);
  debugbr("total fixed blocks: " . count($fixed_blocks));
  $fixed_list = implode(",", $fixed_blocks);
  if ($fixed_list != "") debugbr($fixed_list);
  debugbr("total missing blocks: " . count($missing_blocks));
  $missing_list = implode(",", $missing_blocks);
  if ($missing_list != "") debugbr($missing_list);
}

//commit();
debugbr("finished..");

?>
