<?php
/* ******************************************************************** */
/* CATALYST PHP Source Code                                             */
/* -------------------------------------------------------------------- */
/* This program is free software; you can redistribute it and/or modify */
/* it under the terms of the GNU General Public License as published by */
/* the Free Software Foundation; either version 2 of the License, or    */
/* (at your option) any later version.                                  */
/*                                                                      */
/* This program is distributed in the hope that it will be useful,      */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of       */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        */
/* GNU General Public License for more details.                         */
/*                                                                      */
/* You should have received a copy of the GNU General Public License    */
/* along with this program; if not, write to:                           */
/*   The Free Software Foundation, Inc., 59 Temple Place, Suite 330,    */
/*   Boston, MA  02111-1307  USA                                        */
/* -------------------------------------------------------------------- */
/*                                                                      */
/* Filename:    setup-menu.php                                          */
/* Author:      Paul Waite                                              */
/* Description: Menu Setup Webpage                                      */
/*                                                                      */
/* ******************************************************************** */
include_once("application.php");
include_once("menumaint-defs.php");
include_once("recmaint-defs.php");

// -----------------------------------------------------------------------
// Define the webpage..
// Usage: $RESPONSE->page(title, templatename, theme, stylesheet);
$RESPONSE->page("Menu Builder", "maint", $theme);

//debug_on(DBG_DUMP|DBG_DIAGNOSTIC|DBG_SQL);
//debug_on(DBG_DIAGNOSTIC);
//debug_output(DBG_O_LOG);

// -----------------------------------------------------------------------
// Site-specific content..
include_once("site-webpage.php");

$menumaint = new menumaintainer("", 0, $RESPONSE->multilang);
$menumaint->setalign("center");

// -----------------------------------------------------------------------------------------------
// MAIN CONTENT
$RESPONSE->plugin("MAIN_CONTENT", $menumaint->render());

// #######################################################################
// OUTPUT..
// These go last of all, since they are content
// replacements within replacements..

// -----------------------------------------------------------------------------------------------
// DELIVER..
$RESPONSE->send();
?>