#!/bin/sh
# -*- mode: sh; coding: utf-8 -*-
# vim:smartindent ts=8:sts=2:sta:et:ai:shiftwidth=2
# Test id
# Copyright © 2005 Canonical Limited
#	Authors: Robert Collins <robert.collins@canonical.com>
#
# See the file "COPYING" for further information about
# the copyright and warranty status of this work.

set -e

arg0="$0"
srcdir=`dirname "$arg0"`

. ${srcdir}/test-framework

setup_workdir

test_class "id"

make_names_tree()
{
  mkdir foo
  tla init-tree --nested -d foo foo@example.com--2003/hello-world--1.0
  cd foo
  echo "names" > \{arch\}/\=tagging-method
  mkdir dir
  mkdir dir2
  touch dir/file
  cd dir2
  ln -s ../dir/file link
  cd ..
}

begin_test "names file id"
make_names_tree
[ "$(tla id dir/file)" = "$(echo -e dir/file\\t?./dir/file)" ] || test_fail "incorrect id returned : wanted '$(echo -e dir/file\\t?./dir/file)' got '$(tla id dir/file)'"
end_test

begin_test "names symlink id"
make_names_tree
[ "$(tla id dir2/link)" = "$(echo -e dir2/link\\t?./dir2/link)" ] || test_fail "incorrect id returned : wanted '$(echo -e dir2/link\\t?./dir2/link)' got '$(tla id dir2/link)'"
end_test

begin_test "names dir id"
make_names_tree
[ "$(tla id dir)" = "$(echo -e dir\\t?./dir)" ] || test_fail "incorrect id returned : wanted '$(echo -e dir\\t?./dir)' got '$(tla id dir)'"
end_test

begin_test "names dir/ id"
make_names_tree
[ "$(tla id dir/)" = "$(echo -e dir\\t?./dir)" ] || test_fail "incorrect id returned : wanted '$(echo -e dir\\t?./dir)' got '$(tla id dir/)'"
end_test

begin_test "names subdir file id"
make_names_tree
cd dir
[ "$(tla id file)" = "$(echo -e file\\t?./dir/file)" ] || test_fail "incorrect id returned : wanted '$(echo -e file\\t?./dir/file)' got '$(tla id file)'"
end_test

begin_test "names subdir symlink id"
make_names_tree
cd dir2
[ "$(tla id link)" = "$(echo -e link\\t?./dir2/link)" ] || test_fail "incorrect id returned : wanted '$(echo -e link\\t?./dir2/link)' got '$(tla id link)'"
end_test

begin_test "names subdir . id"
make_names_tree
cd dir
[ "$(tla id .)" = "$(echo -e .\\t?./dir)" ] || test_fail "incorrect id returned : wanted '$(echo -e .\\t?./dir)' got '$(tla id .)'"
end_test

begin_test "names subdir ./ id"
make_names_tree
cd dir
[ "$(tla id ./)" = "$(echo -e .\\t?./dir)" ] || test_fail "incorrect id returned : wanted '$(echo -e .\\t?./dir)' got '$(tla id ./)'"
end_test

begin_test "names subdir relpath file id"
make_names_tree
cd dir2
[ "$(tla id ../dir/file)" = "$(echo -e ../dir/file\\t?./dir/file)" ] || test_fail "incorrect id returned : wanted '$(echo -e ../dir/file\\t?./dir/file)' got '$(tla id ../dir/file)'"
end_test

begin_test "names subdir relpath symlink id"
make_names_tree
cd dir
[ "$(tla id ../dir2/link)" = "$(echo -e ../dir2/link\\t?./dir2/link)" ] || test_fail "incorrect id returned : wanted '$(echo -e ../dir2/link\\t?./dir2/link)' got '$(tla id link)'"
end_test

begin_test "names subdir relpath dir id"
make_names_tree
cd dir2
[ "$(tla id ../dir)" = "$(echo -e ../dir\\t?./dir)" ] || test_fail "incorrect id returned : wanted '$(echo -e .../dir\\t?./dir)' got '$(tla id ../dir)'"
end_test

begin_test "names subdir ../dir/ id"
make_names_tree
cd dir2
[ "$(tla id ../dir/)" = "$(echo -e ../dir\\t?./dir)" ] || test_fail "incorrect id returned : wanted '$(echo -e ../dir\\t?./dir)' got '$(tla id ../dir/)'"
end_test

tla my-id '<foo@example.com>'

make_implicit_tree()
{
  mkdir foo
  tla init-tree --nested -d foo foo@example.com--2003/hello-world--1.0
  cd foo
  echo "implicit
untagged_source source" > \{arch\}/\=tagging-method
  mkdir dir
  mkdir dir2
  tla add --id dirid_ dir2
  touch dir/file
  tla add --id fileid_ dir/file
  cd dir2
  ln -s ../dir/file link
  cd ..
}

begin_test "implicit file id"
make_implicit_tree
[ "$(tla id dir/file)" = "$(echo -e dir/file\\tx_fileid_)" ] || test_fail "incorrect id returned : wanted '$(echo -e dir/file\\tx_fileid_)' got '$(tla id dir/file)'"
end_test

begin_test "implicit file id id"
make_implicit_tree
[ "$(tla id dir/.arch-ids/file.id)" = "$(echo -e dir/.arch-ids/file.id\\tE_fileid_)" ] || test_fail "incorrect id returned : wanted '$(echo -e dir/.arch-ids/file.id\\tE_fileid_)' got '$(tla id dir/.arch-ids/file.id)'"
end_test

begin_test "implicit file id dir id"
make_implicit_tree
[ "$(tla id dir/.arch-ids)" = "$(echo -e dir/.arch-ids\\tD_./dir/.arch-ids)" ] || test_fail "incorrect id returned : wanted '$(echo -e dir/.arch-ids\\tD_./dir/.arch-ids)' got '$(tla id dir/.arch-ids)'"
end_test

begin_test "implicit symlink id"
make_implicit_tree
[ "$(tla id dir2/link)" = "$(echo -e dir2/link\\t?_./dir2/link)" ] || test_fail "incorrect id returned : wanted '$(echo -e dir2/link\\t?_./dir2/link)' got '$(tla id dir2/link)'"
end_test

begin_test "implicit dir id"
make_implicit_tree
[ "$(tla id dir)" = "$(echo -e dir\\t?_./dir)" ] || test_fail "incorrect id returned : wanted '$(echo -e dir\\t?_./dir)' got '$(tla id dir)'"
end_test

begin_test "implicit dir2/ id"
make_implicit_tree
[ "$(tla id dir2/)" = "$(echo -e dir2\\tx_dirid_)" ] || test_fail "incorrect id returned : wanted '$(echo -e dir2\\tx_dirid_)' got '$(tla id dir2/)'"
end_test

begin_test "implicit subdir file id"
make_implicit_tree
cd dir
[ "$(tla id file)" = "$(echo -e file\\tx_fileid_)" ] || test_fail "incorrect id returned : wanted '$(echo -e file\\tx_fileid_)' got '$(tla id file)'"
end_test

begin_test "implicit subdir file id id"
make_implicit_tree
cd dir
[ "$(tla id .arch-ids/file.id)" = "$(echo -e .arch-ids/file.id\\tE_fileid_)" ] || test_fail "incorrect id returned : wanted '$(echo -e .arch-ids/file.id\\tE_fileid_)' got '$(tla id .arch-ids/file.id)'"
end_test

begin_test "implicit file subdir id dir id"
make_implicit_tree
cd dir
[ "$(tla id .arch-ids)" = "$(echo -e .arch-ids\\tD_./dir/.arch-ids)" ] || test_fail "incorrect id returned : wanted '$(echo -e .arch-ids\\tD_./dir/.arch-ids)' got '$(tla id .arch-ids)'"
end_test

begin_test "implicit subdir symlink id"
make_implicit_tree
cd dir2
[ "$(tla id link)" = "$(echo -e link\\t?_./dir2/link)" ] || test_fail "incorrect id returned : wanted '$(echo -e link\\t?_./dir2/link)' got '$(tla id link)'"
end_test

begin_test "implicit subdir . id"
make_implicit_tree
cd dir
[ "$(tla id .)" = "$(echo -e .\\t?_./dir)" ] || test_fail "incorrect id returned : wanted '$(echo -e .\\t?_./dir)' got '$(tla id .)'"
end_test

begin_test "implicit subdir ./ id"
make_implicit_tree
cd dir2
[ "$(tla id ./)" = "$(echo -e .\\tx_dirid_)" ] || test_fail "incorrect id returned : wanted '$(echo -e .\\tx_dirid_)' got '$(tla id ./)'"
end_test

begin_test "implicit subdir relpath file id"
make_implicit_tree
cd dir2
[ "$(tla id ../dir/file)" = "$(echo -e ../dir/file\\tx_fileid_)" ] || test_fail "incorrect id returned : wanted '$(echo -e ../dir/file\\tx_fileid_)' got '$(tla id ../dir/file)'"
end_test

begin_test "implicit subdir relpath file id id"
make_implicit_tree
cd dir2
[ "$(tla id ../dir/.arch-ids/file.id)" = "$(echo -e ../dir/.arch-ids/file.id\\tE_fileid_)" ] || test_fail "incorrect id returned : wanted '$(echo -e ../dir/.arch-ids/file.id\\tE_fileid_)' got '$(tla id ../dir/.arch-ids/file.id)'"
end_test

begin_test "implicit file relpath subdir id dir id"
make_implicit_tree
cd dir2
[ "$(tla id ../dir/.arch-ids)" = "$(echo -e ../dir/.arch-ids\\tD_./dir/.arch-ids)" ] || test_fail "incorrect id returned : wanted '$(echo -e ../dir/.arch-ids\\tD_./dir/.arch-ids)' got '$(tla id ../dir/.arch-ids)'"
end_test

begin_test "implicit subdir relpath symlink id"
make_implicit_tree
cd dir
[ "$(tla id ../dir2/link)" = "$(echo -e ../dir2/link\\t?_./dir2/link)" ] || test_fail "incorrect id returned : wanted '$(echo -e ../dir2/link\\t?_./dir2/link)' got '$(tla id link)'"
end_test

begin_test "implicit subdir relpath dir id"
make_implicit_tree
cd dir2
[ "$(tla id ../dir)" = "$(echo -e ../dir\\t?_./dir)" ] || test_fail "incorrect id returned : wanted '$(echo -e .../dir\\t?_./dir)' got '$(tla id ../dir)'"
end_test

begin_test "implicit subdir ../dir2/ id"
make_implicit_tree
cd dir
[ "$(tla id ../dir2/)" = "$(echo -e ../dir2\\tx_dirid_)" ] || test_fail "incorrect id returned : wanted '$(echo -e ../dir2\\tx_dirid_)' got '$(tla id ../dir2/)'"
end_test

make_tagline_tree()
{
# note that tagline ignores the explicit ids here. it only uses taglines.
  mkdir foo
  tla init-tree --nested -d foo foo@example.com--2003/hello-world--1.0
  cd foo
  echo "tagline
untagged_source source" > \{arch\}/\=tagging-method
  mkdir dir
  mkdir dir2
  tla add --id dirid_ dir2
  touch dir/file
  tla add --id fileid_ dir/file
  cd dir2
  ln -s ../dir/file link
  cd ..
}

begin_test "tagline file id"
make_tagline_tree
[ "$(tla id dir/file)" = "$(echo -e dir/file\\tx_fileid_)" ] || test_fail "incorrect id returned : wanted '$(echo -e dir/file\\tx_fileid_)' got '$(tla id dir/file)'"
end_test

begin_test "tagline symlink id"
make_tagline_tree
[ "$(tla id dir2/link)" = "$(echo -e dir2/link\\t?_./dir2/link)" ] || test_fail "incorrect id returned : wanted '$(echo -e dir2/link\\t?_./dir2/link)' got '$(tla id dir2/link)'"
end_test

begin_test "tagline dir id"
make_tagline_tree
[ "$(tla id dir)" = "$(echo -e dir\\t?_./dir)" ] || test_fail "incorrect id returned : wanted '$(echo -e dir\\t?_./dir)' got '$(tla id dir)'"
end_test

begin_test "tagline dir2/ id"
make_tagline_tree
[ "$(tla id dir2/)" = "$(echo -e dir2\\tx_dirid_)" ] || test_fail "incorrect id returned : wanted '$(echo -e dir2\\tx_dirid_)' got '$(tla id dir2/)'"
end_test

begin_test "tagline subdir file id"
make_tagline_tree
cd dir
[ "$(tla id file)" = "$(echo -e file\\tx_fileid_)" ] || test_fail "incorrect id returned : wanted '$(echo -e file\\tx_fileid_)' got '$(tla id file)'"
end_test

begin_test "tagline subdir symlink id"
make_tagline_tree
cd dir2
[ "$(tla id link)" = "$(echo -e link\\t?_./dir2/link)" ] || test_fail "incorrect id returned : wanted '$(echo -e link\\t?_./dir2/link)' got '$(tla id link)'"
end_test

begin_test "tagline subdir . id"
make_tagline_tree
cd dir
[ "$(tla id .)" = "$(echo -e .\\t?_./dir)" ] || test_fail "incorrect id returned : wanted '$(echo -e .\\t?_./dir)' got '$(tla id .)'"
end_test

begin_test "tagline subdir ./ id"
make_tagline_tree
cd dir2
[ "$(tla id ./)" = "$(echo -e .\\tx_dirid_)" ] || test_fail "incorrect id returned : wanted '$(echo -e .\\tx_dirid_)' got '$(tla id ./)'"
end_test

begin_test "tagline subdir relpath file id"
make_tagline_tree
cd dir2
[ "$(tla id ../dir/file)" = "$(echo -e ../dir/file\\tx_fileid_)" ] || test_fail "incorrect id returned : wanted '$(echo -e ../dir/file\\tx_fileid_)' got '$(tla id ../dir/file)'"
end_test

begin_test "tagline subdir relpath symlink id"
make_tagline_tree
cd dir
[ "$(tla id ../dir2/link)" = "$(echo -e ../dir2/link\\t?_./dir2/link)" ] || test_fail "incorrect id returned : wanted '$(echo -e ../dir2/link\\t?_./dir2/link)' got '$(tla id link)'"
end_test

begin_test "tagline subdir relpath dir id"
make_tagline_tree
cd dir2
[ "$(tla id ../dir)" = "$(echo -e ../dir\\t?_./dir)" ] || test_fail "incorrect id returned : wanted '$(echo -e .../dir\\t?_./dir)' got '$(tla id ../dir)'"
end_test

begin_test "tagline subdir ../dir/ id"
make_tagline_tree
cd dir
[ "$(tla id ../dir2/)" = "$(echo -e ../dir2\\tx_dirid_)" ] || test_fail "incorrect id returned : wanted '$(echo -e ../dir2\\tx_dirid_)' got '$(tla id ../dir2/)'"
end_test

make_explicit_tree()
{
# note that explicit ignores the explicit ids here. it only uses explicits.
  mkdir foo
  tla init-tree --nested -d foo foo@example.com--2003/hello-world--1.0
  cd foo
  echo "explicit
untagged_source source" > \{arch\}/\=tagging-method
  mkdir dir
  mkdir dir2
  tla add --id dirid_ dir2
  touch dir/file
  tla add --id fileid_ dir/file
  cd dir2
  ln -s ../dir/file link
  cd ..
}

begin_test "explicit file id"
make_explicit_tree
[ "$(tla id dir/file)" = "$(echo -e dir/file\\tx_fileid_)" ] || test_fail "incorrect id returned : wanted '$(echo -e dir/file\\tx_fileid_)' got '$(tla id dir/file)'"
end_test

begin_test "explicit symlink id"
make_explicit_tree
[ "$(tla id dir2/link)" = "" ] || test_fail "incorrect id returned : wanted '' got '$(tla id dir2/link)'"
end_test

begin_test "explicit dir id"
make_explicit_tree
[ "$(tla id dir)" = "" ] || test_fail "incorrect id returned : wanted '' got '$(tla id dir)'"
end_test

begin_test "explicit dir/ id"
make_explicit_tree
[ "$(tla id dir2/)" = "$(echo -e dir2\\tx_dirid_)" ] || test_fail "incorrect id returned : wanted '$(echo -e dir2\\tx_dirid_)' got '$(tla id dir2/)'"
end_test

begin_test "explicit subdir file id"
make_explicit_tree
cd dir
[ "$(tla id file)" = "$(echo -e file\\tx_fileid_)" ] || test_fail "incorrect id returned : wanted '$(echo -e file\\tx_fileid_)' got '$(tla id file)'"
end_test

begin_test "explicit subdir symlink id"
make_explicit_tree
cd dir2
[ "$(tla id link)" = "" ] || test_fail "incorrect id returned : wanted '' got '$(tla id link)'"
end_test

begin_test "explicit subdir . id"
make_explicit_tree
cd dir
[ "$(tla id .)" = "" ] || test_fail "incorrect id returned : wanted '' got '$(tla id .)'"
end_test

begin_test "explicit subdir ./ id"
make_explicit_tree
cd dir2
[ "$(tla id ./)" = "$(echo -e .\\tx_dirid_)" ] || test_fail "incorrect id returned : wanted '$(echo -e .\\tx_dirid_)' got '$(tla id ./)'"
end_test

begin_test "explicit subdir relpath file id"
make_explicit_tree
cd dir2
[ "$(tla id ../dir/file)" = "$(echo -e ../dir/file\\tx_fileid_)" ] || test_fail "incorrect id returned : wanted '$(echo -e ../dir/file\\tx_fileid_)' got '$(tla id ../dir/file)'"
end_test

begin_test "explicit subdir relpath symlink id"
make_explicit_tree
cd dir
[ "$(tla id ../dir2/link)" = "" ] || test_fail "incorrect id returned : wanted '' got '$(tla id link)'"
end_test

begin_test "explicit subdir relpath dir id"
make_explicit_tree
cd dir2
[ "$(tla id ../dir)" = "" ] || test_fail "incorrect id returned : wanted '' got '$(tla id ../dir)'"
end_test

begin_test "explicit subdir ../dir/ id"
make_explicit_tree
cd dir
[ "$(tla id ../dir2/)" = "$(echo -e ../dir2\\tx_dirid_)" ] || test_fail "incorrect id returned : wanted '$(echo -e ../dir2\\tx_dirid_)' got '$(tla id ../dir2/)'"
end_test

clean_workdir
