// resource.cc for bbdate - an tool to display new mail in X11.
//
//  Copyright (c) 1998-1999 John Kennis, j.m.b.m.kennis@tue.nl
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//
// (See the included file COPYING / GPL-2.0)
//

#include "resource.hh"
#include "blackboxstyle.hh"

Resource::Resource(ToolWindow *toolwindow): 
  BaseResource(toolwindow)
{
  frame.font=0;
  label.font=0;
  Load();
}

Resource::~Resource()
{
	Clean();
}

void Resource::Clean()
{
	if (label.font) 
		XFreeFont(bbtool->dpy, label.font);
	if (frame.font) 
		XFreeFont(bbtool->dpy, frame.font);
}


void Resource::LoadBBToolResource(void)
{
	XrmValue value;
	char *value_type;

	if (XrmGetResource(resource_db, "bbdate.autoConfig",
		     "Bbdate.Autoconfig", &value_type, &value))
	{
    	if (! strncasecmp("true", value.addr, value.size))
    	{
				style.auto_config = True;
  		}
	    else
    		style.auto_config = False;
	}
	else
		style.auto_config = False;

  SizeAndPosition();
	
	Frame();
	Show();
	
	Label();

}


void Resource::Frame()
{
	XrmValue value;
	char *value_type;

  readDatabaseTexture("bbdate.frame","Bbdate.Frame",BB_FRAME,"Toolbar",
                      "slategrey","darkslategrey",
                      BImage_Raised|BImage_Gradient|BImage_Vertical|
                      BImage_Bevel1,&frame.texture);
	
	if (XrmGetResource(resource_db, "bbdate.bevelWidth","Bbdate.BevelWidth",
						&value_type, &value))
	{
		if (sscanf(value.addr, "%u", &frame.bevelWidth) != 1)
			frame.bevelWidth = 4;
		else if (frame.bevelWidth == 0)
			frame.bevelWidth = 4;
	}
	else if (XrmGetResource(resource_db, BB_BEVELWIDTH,"BevelWidth", &value_type,
                          &value))
	{
		if (sscanf(value.addr, "%u", &frame.bevelWidth) != 1)
			frame.bevelWidth = 4;
		else if (frame.bevelWidth == 0)
			frame.bevelWidth = 4;
	}
	else
    	frame.bevelWidth = 4;
}


void Resource::SizeAndPosition()
{
	XrmValue value;
	char *value_type;
	unsigned int w,h;
	char positionstring[11];

  if (!(bbtool->withdrawn))
  {
  	if (XrmGetResource(resource_db, "bbdate.withdrawn",
		     "Bbdate.Withdrawn", &value_type, &value))
    {
  		if (! strncasecmp("true", value.addr, value.size))
	  		bbtool->withdrawn = True;
	    else
		  	bbtool->withdrawn = False;
  	}	
	  else
		  bbtool->withdrawn = False;
  }

  if (!(bbtool->shape))
  {
  	if (XrmGetResource(resource_db, "bbdate.shape",
		     "Bbdate.Shape", &value_type, &value))
    {
  		if (! strncasecmp("true", value.addr, value.size))
	  		bbtool->shape = True;
	    else
		  	bbtool->shape = False;
  	}	
	  else
		  bbtool->shape = bbtool->withdrawn;
  }

  
	if (!(bbtool->position))
	{
		if (!(XrmGetResource(resource_db, "bbdate.position","Bbdate.Position",
							&value_type, &value)))
			strncpy(positionstring, "-0-0", 5);
		else
			strncpy(positionstring, value.addr, strlen(value.addr)+1);
	}
	else
		strncpy(positionstring, bbtool->position, strlen(bbtool->position)+1);


	position.mask=XParseGeometry(positionstring, &position.x, &position.y, &w, &h);
	if (!(position.mask & XValue))
		position.x=0;
	if (!(position.mask & YValue))
		position.y=0;

	/* need this to compute the height */
	const char *defaultFont = "-*-helvetica-medium-r-*-*-*-120-*-*-*-*-*-*";
	
	if (frame.font)
	{
    	XFreeFont(bbtool->dpy, frame.font);
		frame.font = 0;
	}
	
	if (XrmGetResource(resource_db, "bbdate.heightBy.font","Bbdate.heightBy.Font",
						&value_type, &value))
	{
    	if ((frame.font = XLoadQueryFont(bbtool->dpy, value.addr)) == NULL)
		{
    		fprintf(stderr, " blackbox: couldn't load font '%s'\n"
	      					" ...  reverting to default font.", value.addr);
	    	if ((frame.font = XLoadQueryFont(bbtool->dpy, defaultFont)) == NULL)
			{
				fprintf(stderr,"blackbox: couldn't load default font.  please check to\n"
								"make sure the necessary font is installed '%s'\n",
					defaultFont);
				exit(2);
			}
		}
	}
	else if (XrmGetResource(resource_db, BB_FONT,"TitleFont", &value_type, &value))
	{
		if ((frame.font = XLoadQueryFont(bbtool->dpy, value.addr)) == NULL)
		{
    		fprintf(stderr, " blackbox: couldn't load font '%s'\n"
	      					" ...  reverting to default font.", value.addr);
			if ((frame.font = XLoadQueryFont(bbtool->dpy, defaultFont)) == NULL)
			{
				fprintf(stderr,
					"blackbox: couldn't load default font.  please check to\n"
					"make sure the necessary font is installed '%s'\n",
					defaultFont);
				exit(2);
			}
		}
	}
	else 
	{
    	if ((frame.font = XLoadQueryFont(bbtool->dpy, defaultFont)) == NULL)
		{
			fprintf(stderr,
	      			"blackbox: couldn't load default font.  please check to\n"
	      			"make sure the necessary font is installed '%s'\n", defaultFont);
			exit(2);
		}
	}
}
	
void Resource::Label(void)
{
	XrmValue value;
	char *value_type;

	/* text-label resources */
	if (XrmGetResource(resource_db, "bbdate.label.transparent",
		     "Bbdate.label.Transparent", &value_type, &value))
	{
		if (! strncasecmp("true", value.addr, value.size))
			label.transparent = True;
	    else
			label.transparent = False;
	}	
	else
		label.transparent = False;
	
	readDatabaseTexture("bbdate.label", "Bbdate.Label",BB_LABEL,"Toolbar.Label",
                      "slategrey","darkslategrey",
                      BImage_Sunken|BImage_Gradient|BImage_Vertical|
                      BImage_Bevel1,&label.texture);

		readDatabaseColor("bbdate..textColor",
      								"Bbdate.TextColor",
                      BB_LABEL_TEXTCOLOR, "Toolbar.TextColor",
                      "LightGrey",&label.textColor);

    
	const char *defaultFont = "-*-helvetica-medium-r-*-*-*-120-*-*-*-*-*-*";
	
	if (label.font)
	{
		XFreeFont(bbtool->dpy, label.font);
		label.font = 0;
	}
	
	if (XrmGetResource(resource_db, "bbdate.label.font", "Bbdate.Label.Font",
						&value_type, &value))
	{
		if ((label.font = XLoadQueryFont(bbtool->dpy, value.addr)) == NULL)
		{
    	fprintf(stderr, " blackbox: couldn't load font '%s'\n"
	      							" ...  reverting to default font.", value.addr);
		    if ((label.font = XLoadQueryFont(bbtool->dpy, defaultFont)) == NULL)
			{
				fprintf(stderr,
					"blackbox: couldn't load default font.  please check to\n"
					"make sure the necessary font is installed '%s'\n",
					defaultFont);
			exit(2);
			}
		}
	}
	else if  (XrmGetResource(resource_db, BB_FONT, "TitleFont", &value_type, &value))
	{
		if ((label.font = XLoadQueryFont(bbtool->dpy, value.addr)) == NULL)
		{
			fprintf(stderr, " blackbox: couldn't load font '%s'\n"
	      					" ...  reverting to default font.", value.addr);
			if ((label.font = XLoadQueryFont(bbtool->dpy, defaultFont)) == NULL)
			{
				fprintf(stderr,
					"blackbox: couldn't load default font.  please check to\n"
					"make sure the necessary font is installed '%s'\n",
					defaultFont);
				exit(2);
			}
		}
	}
	else
	{
		if ((label.font = XLoadQueryFont(bbtool->dpy, defaultFont)) == NULL)
		{
			fprintf(stderr,"blackbox: couldn't load default font.  please check to\n"
				    "make sure the necessary font is installed '%s'\n", defaultFont);
			exit(2);
		}
	}
}


void Resource::Show()
{
	XrmValue value;
	char *value_type;

	report.euStyle = False;
	report.intStyle = False;

 	if (XrmGetResource(resource_db, "bbdate.show.euStyle",
		     "Bbdate.show.EuStyle", &value_type, &value))
	{
    	if (! strncasecmp("true", value.addr, value.size))
    	{
				report.euStyle = True;
  		}
	}
	else if (XrmGetResource(resource_db, "bbdate.show.intStyle",
			"Bbdate.show.IntStyle", &value_type, &value))
	{
		if (! strncasecmp("true", value.addr, value.size))
		{
			report.intStyle = True;
		}
	}
 
	/* what to show.resources */
}
