/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2004  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "NfaString.h"

NfaString::NfaString(std::string const& str)
:	m_length(str.length())
{
	m_states.reserve(str.length()+1);
	for (int i = 0; i < m_length; ++i) {
		m_states.push_back(NfaState());
		m_states.back().setSymbolTransition(str[i], 1);
	}
	m_states.push_back(NfaState()); // finish state
}

NfaString::~NfaString()
{
}

int
NfaString::length() const
{
	return m_length;
}

NfaState const*
NfaString::statesBegin() const
{
	return &m_states[0];
}

NfaState const*
NfaString::statesEnd() const
{
	return &m_states[m_states.size()];
}

int
NfaString::getStartPos() const
{
	return 0;
}

int
NfaString::getFinishPos() const
{
	return m_states.size() - 1;
}
