/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2005  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "pch.h"

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "ReplacementJs.h"
#include "CraftedResponse.h"
#include "HttpStatusLine.h"
#include "HttpResponseMetadata.h"
#include "HttpHeadersCollection.h"
#include "HttpHeader.h"
#include "Date.h"

using namespace std;

auto_ptr<CraftedResponse>
ReplacementJs::createHttpResponse(bool is_head_response)
{
	auto_ptr<CraftedResponse> response(new CraftedResponse(HttpStatusLine::SC_OK));
	response->metadata().headers().setHeader(
		HttpHeader(BString("Content-Type"), BString("text/x-javascript"))
	);
	response->metadata().headers().setHeader(
		HttpHeader(BString("Date"), Date::formatCurrentTime())
	);
	if (is_head_response) {
		response->metadata().setBodyStatus(HttpResponseMetadata::BODY_FORBIDDEN);
	} else {
		response->metadata().setBodyStatus(HttpResponseMetadata::BODY_SIZE_KNOWN);
		response->metadata().setBodySize(response->body().size());
	}
	return response;
}
