/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2006  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "pch.h"

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "SocksAsyncConnector.h"
#include "SocksConnectorListener.h"
#include "SocksError.h"
#include "DnsResolver.h"
#include "InetAddr.h"
#include <vector>

using namespace std;

SocksAsyncConnector::SocksAsyncConnector()
{
}

SocksAsyncConnector::~SocksAsyncConnector()
{
}

bool
SocksAsyncConnector::isInProgress() const
{
	return m_socks4Connector.isInProgress() ||
		m_socks5Connector.isInProgress();
}

#include <iostream>

void
SocksAsyncConnector::initiate(
	SocksType socks_type, Listener& listener, Reactor& reactor,
	AutoClosingSAP<ACE_SOCK_Stream>& proxy_conn,
	SymbolicInetAddr const& target_addr,
	std::string const& username, std::string const& password,
	TimeDelta const* timeout)
{
	abort();
	
	if (socks_type == SOCKS4) {
		vector<InetAddr> resolved_addrs(DnsResolver::resolve(target_addr));
		if (resolved_addrs.empty()) {
			listener.onConnThroughSocksFailed(SocksError::LOCAL_DNS_FAILED);
			return;
		}
		vector<InetAddr>::const_iterator it(resolved_addrs.begin());
		vector<InetAddr>::const_iterator const end(resolved_addrs.end());
		for (; it != end; ++it) {
			std::cerr << it->get_addr_size() << std::endl;
			if (it->get_type() == AF_INET) { // IPv4
				m_socks4Connector.initiate(
					listener, reactor, proxy_conn,
					*it, username, timeout
				);
				return;
			}
		}
		listener.onConnThroughSocksFailed(SocksError::UNSUPPORTED_ADDRESS_TYPE);
		return;
	}
	
	if (socks_type == SOCKS4A) {
		m_socks4Connector.initiate(
			Socks4AsyncConnector::SOCKS4A, listener,
			reactor, proxy_conn, target_addr,
			username, timeout
		);
		return;
	}
	
	if (socks_type == SOCKS5) {
		m_socks5Connector.initiate(
			listener, reactor, proxy_conn,
			target_addr, username, password, timeout
		);
		return;
	}
}

void
SocksAsyncConnector::abort()
{
	m_socks4Connector.abort();
	m_socks5Connector.abort();
}
