/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2006  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "pch.h"

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "SymbolicInetAddr.h"
#include "StringUtils.h"
#include <ostream>
#include <algorithm>
#include <vector>

using namespace std;

void
SymbolicInetAddr::swap(SymbolicInetAddr& other)
{
	m_host.swap(other.m_host);
	std::swap(m_port, other.m_port);
}

void
SymbolicInetAddr::toStream(std::ostream& strm) const
{
	strm << m_host << ':' << m_port;
}

bool
SymbolicInetAddr::operator==(SymbolicInetAddr const& other) const
{
	return (StringUtils::ciEqual(m_host, other.m_host) && m_port == other.m_port);
}

bool
SymbolicInetAddr::operator!=(SymbolicInetAddr const& other) const
{
	return (!StringUtils::ciEqual(m_host, other.m_host) || m_port != other.m_port);
}

bool
SymbolicInetAddr::operator<(SymbolicInetAddr const& rhs) const
{
	if (m_port < rhs.m_port) {
		return true;
	} else if (rhs.m_port < m_port) {
		return false;
	}
	return StringUtils::ciLess(m_host, rhs.m_host);
}

bool
SymbolicInetAddr::operator<=(SymbolicInetAddr const& rhs) const
{
	if (m_port < rhs.m_port) {
		return true;
	} else if (rhs.m_port < m_port) {
		return false;
	}
	return StringUtils::ciLessEqual(m_host, rhs.m_host);
}

bool
SymbolicInetAddr::operator>(SymbolicInetAddr const& rhs) const
{
	if (rhs.m_port < m_port) {
		return true;
	} else if (m_port < rhs.m_port) {
		return false;
	}
	return StringUtils::ciLess(rhs.m_host, m_host);
}

bool
SymbolicInetAddr::operator>=(SymbolicInetAddr const& rhs) const
{
	if (rhs.m_port < m_port) {
		return true;
	} else if (m_port < rhs.m_port) {
		return false;
	}
	return StringUtils::ciLessEqual(rhs.m_host, m_host);
}
