/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2005  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "pch.h"

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "LogDialog.h"
#include "OperationLog.h"
#include "AutoScrollingWindow.h"
#include "Application.h"
#include "CompiledImages.h"
#include <gtkmm/box.h>
#include <gtkmm/buttonbox.h>
#include <gtkmm/button.h>
#include <gtkmm/alignment.h>
#include <gtkmm/adjustment.h>
#include <gtkmm/stock.h>
#include <gtkmm/scrolledwindow.h>
#include <gtkmm/textview.h>
#include <cassert>

using namespace std;

LogDialog* LogDialog::m_spInstance = 0;

LogDialog::LogDialog()
:	AbstractLogView(*OperationLog::instance())
{
	set_icon(CompiledImages::window_icon_png.getPixbuf());
	
	signal_focus_in_event().connect(
		sigc::mem_fun(*this, &LogDialog::onFocusChange)
	);
	signal_focus_out_event().connect(
		sigc::mem_fun(*this, &LogDialog::onFocusChange)
	);
	
	set_title("BFilter Operation Log");
	set_border_width(5);
	
	Gtk::VBox* vbox = manage(new Gtk::VBox);
	add(*vbox);
	
	AutoScrollingWindow* scrolled_window = manage(new AutoScrollingWindow);
	vbox->pack_start(*scrolled_window);
	scrolled_window->set_policy(Gtk::POLICY_AUTOMATIC, Gtk::POLICY_AUTOMATIC);
	scrolled_window->set_shadow_type(Gtk::SHADOW_IN);
	scrolled_window->set_size_request(450, 150);
	
	Gtk::TextView* log_widget = manage(
		new Gtk::TextView(OperationLog::instance()->getTextBuffer())
	);
	scrolled_window->add(*log_widget);
	log_widget->set_editable(false);
	log_widget->set_cursor_visible(false);
	log_widget->set_wrap_mode(Gtk::WRAP_WORD);
	
	Gtk::Alignment* spacer1 = manage(new Gtk::Alignment());
	vbox->pack_start(*spacer1, Gtk::PACK_SHRINK);
	spacer1->set_size_request(8, 8);
	
	Gtk::Alignment* bbox_alignment = manage(
		new Gtk::Alignment(0.5, 0.5, 0.0, 0.0)
	);
	vbox->pack_start(*bbox_alignment, Gtk::PACK_SHRINK);
	
	Gtk::Alignment* spacer2 = manage(new Gtk::Alignment());
	vbox->pack_start(*spacer2, Gtk::PACK_SHRINK);
	spacer2->set_size_request(3, 3);
	
	Gtk::HButtonBox* button_box = manage(new Gtk::HButtonBox);
	bbox_alignment->add(*button_box);
	button_box->set_spacing(10);
	
	Gtk::Button *clear_btn = manage(new Gtk::Button(Gtk::Stock::CLEAR));
	button_box->pack_start(*clear_btn, Gtk::PACK_SHRINK);
	clear_btn->signal_clicked().connect(
		sigc::mem_fun(*this, &LogDialog::onClearLog)
	);
	
	Gtk::Button *close_btn = manage(new Gtk::Button(Gtk::Stock::CLOSE));
	button_box->pack_start(*close_btn, Gtk::PACK_SHRINK);
	close_btn->signal_clicked().connect(
		sigc::mem_fun(*this, &LogDialog::hide)
	);
	close_btn->grab_focus();
	
	show_all_children();
	
	Application::instance()->destroySignal().connect(
		sigc::mem_fun(*this, &LogDialog::hide)
	);
}

LogDialog::~LogDialog()
{
	assert(m_spInstance);
	m_spInstance = 0;
	
	// prevent slots being called during destruction
	sigc::trackable::notify_callbacks();
}

void
LogDialog::showWindow()
{
	if (m_spInstance) {
		m_spInstance->present();
	} else {
		(m_spInstance = new LogDialog)->show();
	}
}

void
LogDialog::on_hide()
{
	delete this;
}

void
LogDialog::onClearLog()
{
	OperationLog::instance()->clear();
}

bool
LogDialog::onFocusChange(GdkEventFocus*)
{
	AbstractLogView::reportVisibility(property_is_active());
	return false; // propagate event further
}
