#!/bin/sh

cat <<END
/* This file was generated by img2src.sh */

#include "CompiledImage.h"
#include <glib/gtypes.h>

END

for f
do
  fname=`basename "$f"`
  ident=`echo "$fname" | sed -e s/[^A-Za-z0-9]/_/g | tr A-Z a-z`
  suffix='_'
  ident2="$ident$suffix"
  gdk-pixbuf-csource --static --raw "--name=$ident2" "$f" || exit 1
  cat <<END
namespace CompiledImages {
	extern struct CompiledImage const $ident = {
		$ident2, sizeof($ident2) - 1
	};
}

END
done
